/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.handler.approval;

import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.contract.domain.OcContractReDomain;
import com.yqbsoft.laser.service.contract.handler.approval.AbstractContractApprovalHandler;
import com.yqbsoft.laser.service.contract.model.OcApprovalInstance;
import com.yqbsoft.laser.service.contract.service.OcContractEngineService;
import com.yqbsoft.laser.service.contract.service.OcContractService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="priceHandler")
public class PriceApprovalHandler
extends AbstractContractApprovalHandler {
    private static final Logger log = LoggerFactory.getLogger(PriceApprovalHandler.class);

    public PriceApprovalHandler(OcContractService contractService, OcContractEngineService contractEngineService) {
        super(contractService, contractEngineService);
    }

    @Override
    public String getBizType() {
        return "ORDER";
    }

    @Override
    public String validateBeforeApply(String bizId) {
        OcContractReDomain ocContractReDomain = this.getContractByCode(bizId);
        return JSONObject.toJSONString((Object)ocContractReDomain);
    }

    @Override
    public void onApproved(OcApprovalInstance instance) {
        log.info("==============PriceApprovalHandler =========onApproved {}", (Object)instance.getBizId());
        this.handleContractStatus(instance.getBizId(), "3");
        this.contractEngineService.sendContractNext(instance.getBizId(), instance.getTenantId(), null);
    }

    @Override
    public void onRejected(OcApprovalInstance instance) {
        this.handleContractStatus(instance.getBizId(), "4");
        this.contractEngineService.sendContractBack(instance.getBizId(), instance.getTenantId(), null);
    }
}

