/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.enums;

import java.util.Arrays;

public enum OrderStatusEnum {
    TO_SUBMIT(1, "\u5f85\u63d0\u4ea4"),
    PRICE_APPROVING(2, "\u4ef7\u683c\u5ba1\u6279\u4e2d"),
    TO_PAY(3, "\u5f85\u4ed8\u6b3e"),
    TO_DELIVER(4, "\u5f85\u53d1\u8d27"),
    IN_PRODUCTION(5, "\u5236\u4f5c\u4e2d"),
    TO_RECEIVE(6, "\u5f85\u6536\u8d27"),
    SHORT_PAY_APPROVING(7, "\u7f3a\u6b3e\u53d1\u8d27\u5ba1\u6279\u4e2d"),
    COMPLETED(8, "\u5df2\u5b8c\u6210"),
    CANCEL_APPROVING(9, "\u8ba2\u5355\u53d6\u6d88\u5ba1\u6279\u4e2d"),
    CANCELED(-1, "\u5df2\u53d6\u6d88");

    private final int code;
    private final String desc;

    private OrderStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static OrderStatusEnum of(Integer code) {
        if (code == null) {
            return null;
        }
        return Arrays.stream(OrderStatusEnum.values()).filter(e -> e.code == code).findFirst().orElse(null);
    }

    public static String getDescByCode(Integer code) {
        OrderStatusEnum status = OrderStatusEnum.of(code);
        return status != null ? status.getDesc() : "";
    }

    public boolean isFinalStatus() {
        return this == COMPLETED || this == CANCELED;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

