/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.OcRecflowMapper;
import com.yqbsoft.laser.service.contract.dao.OcRecflowNodeMapper;
import com.yqbsoft.laser.service.contract.domain.OcRecflowDomain;
import com.yqbsoft.laser.service.contract.domain.OcRecflowNodeDomain;
import com.yqbsoft.laser.service.contract.domain.OcRecflowNodeReDomain;
import com.yqbsoft.laser.service.contract.domain.OcRecflowReDomain;
import com.yqbsoft.laser.service.contract.model.OcRecflow;
import com.yqbsoft.laser.service.contract.model.OcRecflowNode;
import com.yqbsoft.laser.service.contract.refundes.RecflowPollThread;
import com.yqbsoft.laser.service.contract.refundes.RecflowService;
import com.yqbsoft.laser.service.contract.service.OcRecflowService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class OcRecflowServiceImpl
extends BaseServiceImpl
implements OcRecflowService {
    public static final String SYS_CODE = "oc.CONTRACT.OcRecflowServiceImpl";
    public static final String CACHE_KEY_CFLOW = "ocProtRecflow";
    public static final String CACHE_KEY_CFLOWNODE = "ocProtRecflowNode";
    public static final String CACHE_KEY_PARENTCFLOWNODE = "ocProtRecflowNodeByParent";
    private static RecflowService recflowService;
    private static Object lock;
    private OcRecflowMapper ocRecflowMapper;
    private OcRecflowNodeMapper ocRecflowNodeMapper;

    public void setOcRecflowMapper(OcRecflowMapper ocRecflowMapper) {
        this.ocRecflowMapper = ocRecflowMapper;
    }

    public void setOcRecflowNodeMapper(OcRecflowNodeMapper ocRecflowNodeMapper) {
        this.ocRecflowNodeMapper = ocRecflowNodeMapper;
    }

    private Date getSysDate() {
        try {
            return this.ocRecflowMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRecflowServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRecflow(OcRecflowDomain ocRecflowDomain) {
        if (null == ocRecflowDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocRecflowDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRecflowDefault(OcRecflow ocRecflow) {
        if (null == ocRecflow) {
            return;
        }
        if (null == ocRecflow.getDataState()) {
            ocRecflow.setDataState(0);
        }
        if (null == ocRecflow.getGmtCreate()) {
            ocRecflow.setGmtCreate(this.getSysDate());
        }
        ocRecflow.setGmtModified(this.getSysDate());
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.ocRecflowMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRecflowServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRecflowUpdataDefault(OcRecflow ocRecflow) {
        if (null == ocRecflow) {
            return;
        }
        ocRecflow.setGmtModified(this.getSysDate());
    }

    private void saveRecflowModel(OcRecflow ocRecflow) throws ApiException {
        if (null == ocRecflow) {
            return;
        }
        try {
            this.ocRecflowMapper.insert(ocRecflow);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRecflowServiceImpl.saveRecflowModel.ex", (Throwable)e);
        }
    }

    private OcRecflow getRecflowModelById(Integer recflowId) {
        if (null == recflowId) {
            return null;
        }
        try {
            return this.ocRecflowMapper.selectByPrimaryKey(recflowId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRecflowServiceImpl.getRecflowModelById", (Throwable)e);
            return null;
        }
    }

    public OcRecflow getRecflowModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocRecflowMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRecflowServiceImpl.getRecflowModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delRecflowModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRecflowMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRecflowServiceImpl.delRecflowModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRecflowServiceImpl.delRecflowModelByCode.num");
        }
    }

    private void deleteRecflowModel(Integer recflowId) throws ApiException {
        if (null == recflowId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRecflowMapper.deleteByPrimaryKey(recflowId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRecflowServiceImpl.deleteRecflowModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRecflowServiceImpl.deleteRecflowModel.num");
        }
    }

    private void updateRecflowModel(OcRecflow ocRecflow) throws ApiException {
        if (null == ocRecflow) {
            return;
        }
        try {
            this.ocRecflowMapper.updateByPrimaryKeySelective(ocRecflow);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRecflowServiceImpl.updateRecflowModel.ex", (Throwable)e);
        }
    }

    private void updateStateRecflowModel(Integer recflowId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == recflowId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("recflowId", recflowId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocRecflowMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRecflowServiceImpl.updateStateRecflowModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRecflowServiceImpl.updateStateRecflowModel.null");
        }
    }

    private OcRecflow makeRecflow(OcRecflowDomain ocRecflowDomain, OcRecflow ocRecflow) {
        if (null == ocRecflowDomain) {
            return null;
        }
        if (null == ocRecflow) {
            ocRecflow = new OcRecflow();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocRecflow, (Object)ocRecflowDomain);
            return ocRecflow;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRecflowServiceImpl.makeRecflow", (Throwable)e);
            return null;
        }
    }

    private OcRecflowReDomain makeReRecflow(OcRecflow ocRecflow) {
        if (null == ocRecflow) {
            return null;
        }
        OcRecflowReDomain ocRecflowReDomain = new OcRecflowReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocRecflowReDomain, (Object)ocRecflow);
            return ocRecflowReDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRecflowServiceImpl.makeReRecflow", (Throwable)e);
            return null;
        }
    }

    private List<OcRecflow> queryRecflowModelPage(Map<String, Object> parammap) {
        try {
            return this.ocRecflowMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRecflowServiceImpl.queryRecflowModel", (Throwable)e);
            return null;
        }
    }

    private int countRecflow(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocRecflowMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRecflowServiceImpl.countRecflow", (Throwable)e);
        }
        return i;
    }

    private String checkRecflowNode(OcRecflowNodeDomain ocRecflowNodeDomain) {
        if (null == ocRecflowNodeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocRecflowNodeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRecflowNodeDefault(OcRecflowNode ocRecflowNode) {
        if (null == ocRecflowNode) {
            return;
        }
        if (null == ocRecflowNode.getDataState()) {
            ocRecflowNode.setDataState(0);
        }
        if (null == ocRecflowNode.getGmtCreate()) {
            ocRecflowNode.setGmtCreate(this.getSysDate());
        }
        ocRecflowNode.setGmtModified(this.getSysDate());
    }

    private int getRecflowNodeMaxCode() {
        int code = 0;
        try {
            return this.ocRecflowNodeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRecflowServiceImpl.getRecflowNodeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRecflowNodeUpdataDefault(OcRecflowNode ocRecflowNode) {
        if (null == ocRecflowNode) {
            return;
        }
        ocRecflowNode.setGmtModified(this.getSysDate());
    }

    private void saveRecflowNodeModel(OcRecflowNode ocRecflowNode) throws ApiException {
        if (null == ocRecflowNode) {
            return;
        }
        try {
            this.ocRecflowNodeMapper.insert(ocRecflowNode);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRecflowServiceImpl.saveRecflowNodeModel.ex", (Throwable)e);
        }
    }

    private OcRecflowNode getRecflowNodeModelById(Integer recflowNodeId) {
        if (null == recflowNodeId) {
            return null;
        }
        try {
            return this.ocRecflowNodeMapper.selectByPrimaryKey(recflowNodeId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRecflowServiceImpl.getRecflowNodeModelById", (Throwable)e);
            return null;
        }
    }

    public OcRecflowNode getRecflowNodeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocRecflowNodeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRecflowServiceImpl.getRecflowNodeModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delRecflowNodeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRecflowNodeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRecflowServiceImpl.delRecflowNodeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRecflowServiceImpl.delRecflowNodeModelByCode.num");
        }
    }

    private void deleteRecflowNodeModel(Integer recflowNodeId) throws ApiException {
        if (null == recflowNodeId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRecflowNodeMapper.deleteByPrimaryKey(recflowNodeId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRecflowServiceImpl.deleteRecflowNodeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRecflowServiceImpl.deleteRecflowNodeModel.num");
        }
    }

    private void updateRecflowNodeModel(OcRecflowNode ocRecflowNode) throws ApiException {
        if (null == ocRecflowNode) {
            return;
        }
        try {
            this.ocRecflowNodeMapper.updateByPrimaryKeySelective(ocRecflowNode);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRecflowServiceImpl.updateRecflowNodeModel.ex", (Throwable)e);
        }
    }

    private void updateStateRecflowNodeModel(Integer recflowNodeId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == recflowNodeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("recflowNodeId", recflowNodeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocRecflowNodeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRecflowServiceImpl.updateStateRecflowNodeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRecflowServiceImpl.updateStateRecflowNodeModel.null");
        }
    }

    private OcRecflowNode makeRecflowNode(OcRecflowNodeDomain ocRecflowNodeDomain, OcRecflowNode ocRecflowNode) {
        if (null == ocRecflowNodeDomain) {
            return null;
        }
        if (null == ocRecflowNode) {
            ocRecflowNode = new OcRecflowNode();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocRecflowNode, (Object)ocRecflowNodeDomain);
            return ocRecflowNode;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRecflowServiceImpl.makeRecflowNode", (Throwable)e);
            return null;
        }
    }

    private OcRecflowNodeReDomain makeReRecflowNode(OcRecflowNode ocRecflowNode) {
        if (null == ocRecflowNode) {
            return null;
        }
        OcRecflowNodeReDomain ocRecflowNodeReDomain = new OcRecflowNodeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocRecflowNodeReDomain, (Object)ocRecflowNode);
            return ocRecflowNodeReDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRecflowServiceImpl.makeReRecflowNode", (Throwable)e);
            return null;
        }
    }

    private List<OcRecflowNodeReDomain> makeReRecflowNodeList(List<OcRecflowNode> ocRecflowNodeList) {
        if (null == ocRecflowNodeList || ocRecflowNodeList.isEmpty()) {
            return null;
        }
        ArrayList<OcRecflowNodeReDomain> nodeReList = new ArrayList<OcRecflowNodeReDomain>();
        for (OcRecflowNode ocRecflowNode : ocRecflowNodeList) {
            nodeReList.add(this.makeReRecflowNode(ocRecflowNode));
        }
        return nodeReList;
    }

    private List<OcRecflowNode> queryRecflowNodeModelPage(Map<String, Object> parammap) {
        try {
            return this.ocRecflowNodeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRecflowServiceImpl.queryRecflowNodeModel", (Throwable)e);
            return null;
        }
    }

    private int countRecflowNode(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocRecflowNodeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRecflowServiceImpl.countRecflowNode", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveRecflow(OcRecflowDomain ocRecflowDomain) throws ApiException {
        String msg = this.checkRecflow(ocRecflowDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRecflowServiceImpl.saveRecflow.checkRecflow", msg);
        }
        OcRecflow ocRecflow = this.makeRecflow(ocRecflowDomain, null);
        this.setRecflowDefault(ocRecflow);
        this.saveRecflowModel(ocRecflow);
    }

    @Override
    public void updateRecflowState(Integer recflowId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateRecflowModel(recflowId, dataState, oldDataState);
    }

    @Override
    public void updateRecflow(OcRecflowDomain ocRecflowDomain) throws ApiException {
        String msg = this.checkRecflow(ocRecflowDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRecflowServiceImpl.updateRecflow.checkRecflow", msg);
        }
        OcRecflow oldOcRecflow = this.getRecflowModelById(ocRecflowDomain.getRecflowId());
        if (null == oldOcRecflow) {
            throw new ApiException("oc.CONTRACT.OcRecflowServiceImpl.updateRecflow.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcRecflow ocRecflow = this.makeRecflow(ocRecflowDomain, oldOcRecflow);
        this.setRecflowUpdataDefault(ocRecflow);
        this.updateRecflowModel(ocRecflow);
    }

    @Override
    public OcRecflow getRecflow(Integer recflowId) {
        return this.getRecflowModelById(recflowId);
    }

    @Override
    public OcRecflowReDomain getRecflowByPaypdCode(String dicPaypdCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dicPaypdCode", dicPaypdCode);
        map.put("tenantCode", tenantCode);
        List<OcRecflow> ocRecflowList = this.queryRecflowModelPage(map);
        if (null == ocRecflowList || ocRecflowList.isEmpty()) {
            return null;
        }
        OcRecflow ocRecflow = ocRecflowList.get(0);
        OcRecflowReDomain ocRecflowReDomain = this.makeReRecflow(ocRecflow);
        if (null == ocRecflowReDomain) {
            return null;
        }
        List<OcRecflowNodeReDomain> nodeReList = this.queryNodeNext(tenantCode, ocRecflowReDomain.getRecflowCode(), ocRecflowReDomain.getRecflowCode());
        ocRecflowReDomain.setNodeReList(nodeReList);
        return ocRecflowReDomain;
    }

    @Override
    public List<OcRecflowNodeReDomain> queryRecflowNodeNext(String recflowCode, String recflowNodeParentcode, String tenantCode) {
        return this.queryNodeNext(tenantCode, recflowNodeParentcode, recflowCode);
    }

    private List<OcRecflowNodeReDomain> queryNodeNext(String tenantCode, String recflowNodeParentcode, String recflowCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recflowCode", recflowCode);
        map.put("recflowNodeParentcode", recflowNodeParentcode);
        map.put("orderStr", "RECFLOW_NODE_INDEX");
        map.put("order", true);
        List<OcRecflowNodeReDomain> nodeReList = this.makeReRecflowNodeList(this.queryRecflowNodeModelPage(map));
        if (null == nodeReList || nodeReList.isEmpty()) {
            return null;
        }
        return nodeReList;
    }

    public void createNodeChildren(String tenantCode, List<OcRecflowNodeReDomain> nodeReList) {
        if (null == nodeReList || nodeReList.isEmpty()) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        for (OcRecflowNodeReDomain ocRecflowNodeReDomain : nodeReList) {
            map.put("recflowCode", ocRecflowNodeReDomain.getRecflowCode());
            map.put("recflowNodeParentcode", ocRecflowNodeReDomain.getRecflowNodeCode());
            List<OcRecflowNodeReDomain> nodeReChildrenList = this.makeReRecflowNodeList(this.queryRecflowNodeModelPage(map));
            if (null == nodeReChildrenList || nodeReChildrenList.isEmpty()) continue;
            ocRecflowNodeReDomain.setChildren(nodeReChildrenList);
            this.createNodeChildren(tenantCode, nodeReChildrenList);
        }
    }

    @Override
    public void deleteRecflow(Integer recflowId) throws ApiException {
        this.deleteRecflowModel(recflowId);
    }

    @Override
    public QueryResult<OcRecflow> queryRecflowPage(Map<String, Object> map) {
        List<OcRecflow> ocRecflowList = this.queryRecflowModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRecflow(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocRecflowList);
        return queryResult;
    }

    @Override
    public void saveRecflowNode(OcRecflowNodeDomain ocRecflowNodeDomain) throws ApiException {
        String msg = this.checkRecflowNode(ocRecflowNodeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRecflowServiceImpl.saveRecflowNode.checkRecflowNode", msg);
        }
        OcRecflowNode ocRecflowNode = this.makeRecflowNode(ocRecflowNodeDomain, null);
        this.setRecflowNodeDefault(ocRecflowNode);
        this.saveRecflowNodeModel(ocRecflowNode);
    }

    @Override
    public void updateRecflowNodeState(Integer recflowNodeId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateRecflowNodeModel(recflowNodeId, dataState, oldDataState);
    }

    @Override
    public void updateRecflowNode(OcRecflowNodeDomain ocRecflowNodeDomain) throws ApiException {
        String msg = this.checkRecflowNode(ocRecflowNodeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRecflowServiceImpl.updateRecflowNode.checkRecflowNode", msg);
        }
        OcRecflowNode oldOcRecflowNode = this.getRecflowNodeModelById(ocRecflowNodeDomain.getRecflowNodeId());
        if (null == oldOcRecflowNode) {
            throw new ApiException("oc.CONTRACT.OcRecflowServiceImpl.updateRecflowNode.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcRecflowNode ocRecflowNode = this.makeRecflowNode(ocRecflowNodeDomain, oldOcRecflowNode);
        this.setRecflowNodeUpdataDefault(ocRecflowNode);
        this.updateRecflowNodeModel(ocRecflowNode);
    }

    @Override
    public OcRecflowNode getRecflowNode(Integer recflowNodeId) {
        return this.getRecflowNodeModelById(recflowNodeId);
    }

    @Override
    public OcRecflowNode getRecflowNodeByCode(String recflowNodeCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("recflowNodeCode", recflowNodeCode);
        map.put("tenantCode", tenantCode);
        return this.getRecflowNodeModelByCode(map);
    }

    @Override
    public void deleteRecflowNode(Integer recflowNodeId) throws ApiException {
        this.deleteRecflowNodeModel(recflowNodeId);
    }

    @Override
    public QueryResult<OcRecflowNode> queryRecflowNodePage(Map<String, Object> map) {
        List<OcRecflowNode> ocRecflowNodeList = this.queryRecflowNodeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRecflowNode(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocRecflowNodeList);
        return queryResult;
    }

    @Override
    public void queryRecflowCache() {
        this.info("oc.CONTRACT.OcRecflowServiceImpl.queryRecflowCache.start", "=======\u8c03\u5ea6start=======");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dataState", 1L);
        List<OcRecflow> recflowList = this.queryRecflowModelPage(params);
        if (CollectionUtils.isEmpty(recflowList)) {
            DisUtil.delVer((String)CACHE_KEY_CFLOW);
            DisUtil.delVer((String)CACHE_KEY_CFLOWNODE);
            DisUtil.delVer((String)CACHE_KEY_PARENTCFLOWNODE);
            this.info("oc.CONTRACT.OcRecflowServiceImpl.queryRecflowCache.null", "=======\u8c03\u5ea6end=======");
            return;
        }
        HashMap<String, String> mmap = new HashMap<String, String>();
        HashMap<String, String> nodemap = new HashMap<String, String>();
        HashMap<String, String> nodeparentmap = new HashMap<String, String>();
        String key = "";
        for (OcRecflow ocRecflow : recflowList) {
            OcRecflowReDomain ocRecflowReDomain = this.makeCache(ocRecflow);
            key = ocRecflowReDomain.getDicPaypdCode();
            if (StringUtils.isNotBlank((String)ocRecflowReDomain.getProappCode())) {
                key = key + "-" + ocRecflowReDomain.getProappCode();
            }
            if (StringUtils.isNotBlank((String)ocRecflowReDomain.getChannelCode())) {
                key = key + "-" + ocRecflowReDomain.getChannelCode();
            }
            if (StringUtils.isNotBlank((String)ocRecflowReDomain.getGoodsClass())) {
                key = key + "-" + ocRecflowReDomain.getGoodsClass();
            }
            key = key + "-" + ocRecflowReDomain.getTenantCode();
            mmap.put(key, JsonUtil.buildNormalBinder().toJson((Object)ocRecflowReDomain));
        }
        params.put("orderStr", "RECFLOW_NODE_INDEX");
        params.put("order", true);
        List<OcRecflowNode> nodeList = this.queryRecflowNodeModelPage(params);
        if (null == nodeList || nodeList.isEmpty()) {
            DisUtil.delVer((String)CACHE_KEY_CFLOWNODE);
            DisUtil.delVer((String)CACHE_KEY_PARENTCFLOWNODE);
            return;
        }
        String nodekey = "";
        String parkey = "";
        String str = "";
        List<OcRecflowNodeReDomain> nodeParentList = null;
        for (OcRecflowNode ocRecflowNode : nodeList) {
            nodekey = ocRecflowNode.getRecflowCode() + "-" + ocRecflowNode.getRecflowNodeCode() + "-" + ocRecflowNode.getTenantCode();
            nodemap.put(nodekey, JsonUtil.buildNormalBinder().toJson((Object)ocRecflowNode));
            parkey = ocRecflowNode.getRecflowCode() + "-" + ocRecflowNode.getRecflowNodeParentcode() + "-" + ocRecflowNode.getTenantCode();
            str = (String)nodeparentmap.get(parkey);
            nodeParentList = StringUtils.isNotBlank((String)str) ? (List)JsonUtil.buildNormalBinder().getJsonToList(str, OcRecflowNodeReDomain.class) : new ArrayList<OcRecflowNodeReDomain>();
            nodeParentList.add(this.makeReRecflowNode(ocRecflowNode));
            nodeparentmap.put(parkey, JsonUtil.buildNormalBinder().toJson(nodeParentList));
        }
        DisUtil.setMap((String)CACHE_KEY_CFLOW, mmap);
        DisUtil.setMap((String)CACHE_KEY_CFLOWNODE, nodemap);
        DisUtil.setMap((String)CACHE_KEY_PARENTCFLOWNODE, nodeparentmap);
        this.info("oc.CONTRACT.OcRecflowServiceImpl.queryRecflowCache.end", "=======\u8c03\u5ea6end=======");
    }

    private OcRecflowReDomain makeCache(OcRecflow ocRecflow) {
        if (null == ocRecflow) {
            return null;
        }
        OcRecflowReDomain ocRecflowReDomain = this.makeReRecflow(ocRecflow);
        if (null == ocRecflowReDomain) {
            return null;
        }
        List<OcRecflowNodeReDomain> nodeReList = this.queryNodeNext(ocRecflow.getTenantCode(), ocRecflowReDomain.getRecflowCode(), ocRecflowReDomain.getRecflowCode());
        if (ListUtil.isEmpty(nodeReList) && !"00000000".equals(ocRecflow.getTenantCode())) {
            nodeReList = this.queryNodeNext("00000000", ocRecflowReDomain.getRecflowCode(), ocRecflowReDomain.getRecflowCode());
        }
        ocRecflowReDomain.setNodeReList(nodeReList);
        return ocRecflowReDomain;
    }

    @Override
    public void saveRecflowInit(String tenantCode) {
        List<OcRecflow> recflowList = this.queryRecflowModelPage(this.getQueryParamMap("tenantCode,dataState", new Object[]{"00000000", 1L}));
        List<OcRecflowNode> list = this.queryRecflowNodeModelPage(this.getQueryParamMap("tenantCode,dataState", new Object[]{"00000000", 1L}));
        HashMap map = new HashMap();
        for (OcRecflowNode node : list) {
            ArrayList<OcRecflowNode> nodelist = (ArrayList<OcRecflowNode>)map.get(node.getRecflowCode());
            if (null == nodelist) {
                nodelist = new ArrayList<OcRecflowNode>();
            }
            node.setTenantCode(tenantCode);
            node.setRecflowNodeId(null);
            nodelist.add(node);
            map.put(node.getRecflowCode(), nodelist);
        }
        for (OcRecflow recflow : recflowList) {
            recflow.setTenantCode(tenantCode);
            recflow.setRecflowId(null);
            recflow.setOcRecflowNodeList((List)map.get(recflow.getRecflowCode()));
        }
        this.getRecflowService().putQueue(recflowList);
    }

    @Override
    public void saveRecflowByList(List<OcRecflow> list) {
        if (null == list || list.size() == 0) {
            return;
        }
        for (OcRecflow recflow : list) {
            this.saveRecflowModel(recflow);
            for (OcRecflowNode node : recflow.getOcRecflowNodeList()) {
                this.saveRecflowNodeModel(node);
            }
        }
        this.queryRecflowCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecflowService getRecflowService() {
        Object object = lock;
        synchronized (object) {
            if (null == recflowService) {
                recflowService = new RecflowService((OcRecflowService)SpringApplicationContextUtil.getBean((String)"ocRecflowService"));
                recflowService.addPollPool(new RecflowPollThread(recflowService));
            }
            return recflowService;
        }
    }

    static {
        lock = new Object();
    }
}

