/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.crp.service.impl;

import com.yqbsoft.laser.service.crp.CrpConstants;
import com.yqbsoft.laser.service.crp.domain.CrpRechargeDomain;
import com.yqbsoft.laser.service.crp.model.CrpRecharge;
import com.yqbsoft.laser.service.crp.model.CrpUrecharge;
import com.yqbsoft.laser.service.crp.service.CrpChannelsendBaseService;
import com.yqbsoft.laser.service.crp.service.CrpRechargeBaseService;
import com.yqbsoft.laser.service.crp.service.CrpRechargeService;
import com.yqbsoft.laser.service.crp.service.CrpUrechargeService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.helper.StringUtil;

public class CrpRechargeBaseServiceImpl
extends BaseServiceImpl
implements CrpRechargeBaseService {
    private static final String SYS_CODE = "service.crp.CrpRechargeBaseServiceImpl";
    private CrpChannelsendBaseService crpChannelsendBaseService;
    CrpRechargeService crpRechargeService;
    CrpUrechargeService crpUrechargeService;

    public CrpUrechargeService getCrpUrechargeService() {
        return this.crpUrechargeService;
    }

    public void setCrpUrechargeService(CrpUrechargeService crpUrechargeService) {
        this.crpUrechargeService = crpUrechargeService;
    }

    public void setCrpRechargeService(CrpRechargeService crpRechargeService) {
        this.crpRechargeService = crpRechargeService;
    }

    public void setCrpChannelsendBaseService(CrpChannelsendBaseService crpChannelsendBaseService) {
        this.crpChannelsendBaseService = crpChannelsendBaseService;
    }

    @Override
    public String saveRechargeBase(CrpRechargeDomain crpRechargeDomain) throws ApiException {
        if (null == crpRechargeDomain || StringUtil.isBlank((String)crpRechargeDomain.getRechargeOpcode()) || StringUtil.isBlank((String)crpRechargeDomain.getUserinfoCode())) {
            this.logger.error("service.crp.CrpRechargeBaseServiceImpl.saveRechargeBase", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)crpRechargeDomain));
            return "error";
        }
        this.crpChannelsendBaseService.sendChangeApply(crpRechargeDomain);
        return "success";
    }

    @Override
    public String updateSendUrechargeBase(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map) || EmptyUtil.isEmpty((Object)map.get("cpRechargeDomain"))) {
            throw new ApiException("service.crp.CrpRechargeBaseServiceImplupdateSendUrechargeBase.", "\u53c2\u6570\u4e3a\u7a7a");
        }
        this.crpChannelsendBaseService.updateSendAutoUrechargeStr(map);
        return "success";
    }

    @Override
    public String loadSendUrechargeBase(String tenantCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rechargeState", 2);
        Date vf = new Date();
        String nowStr = DateUtil.getDateString((Date)vf, (String)"yyyy-MM-dd HH:mm:ss");
        Date da = DateUtil.getDateToString((String)nowStr, (String)"yyyy-MM-dd HH:mm:ss");
        map.put("startDate", da);
        map.put("endDate", da);
        List<CrpRecharge> qlist = this.crpRechargeService.queryBmoneyCrp(map);
        if (null != qlist && ListUtil.isNotEmpty(qlist)) {
            for (CrpRecharge crpRecharge : qlist) {
                HashMap<String, Object> map1 = new HashMap<String, Object>();
                map.put("rechargeState", CrpConstants.RECHARGE_STATE_END);
                this.crpRechargeService.updateCrpRechargeStateBeoverdue(crpRecharge.getRechargeId(), crpRecharge.getDataState(), null, map1);
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("tenantCode", crpRecharge.getTenantCode());
                param.put("rechargeType", crpRecharge.getRechargeType());
                param.put("userinfoCode", crpRecharge.getUserinfoCode());
                param.put("channelCode", crpRecharge.getChannelCode());
                QueryResult<CrpUrecharge> crpUrechargeQueryResult = this.crpUrechargeService.queryCrpUrechargePage(param);
                if (!ListUtil.isNotEmpty((Collection)crpUrechargeQueryResult.getList())) continue;
                for (CrpUrecharge crpUrecharge : crpUrechargeQueryResult.getList()) {
                    HashMap<String, Object> map2 = new HashMap<String, Object>();
                    map2.put("rechargeName10", "3");
                    this.crpUrechargeService.updateCrpUrechargeStateByCodeBeoverdue(crpUrecharge.getTenantCode(), crpUrecharge.getUrechargeCode(), crpUrecharge.getDataState(), null, map2);
                }
            }
        }
        return "success";
    }

    @Override
    public String loadSendUrechargeBaseToTime(String tenantCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dataState", 2);
        map.put("rechargeStateStr", "0,1");
        map.put("rechargeType", "0");
        map.put("rechargeName10", "0,-1");
        Date vf = new Date();
        String nowStr = DateUtil.getDateString((Date)vf, (String)"yyyy-MM-dd");
        Date da = DateUtil.getDateToString((String)nowStr, (String)"yyyy-MM-dd");
        map.put("rechargeEndStr", da);
        this.logger.error("map====4", (Object)JsonUtil.buildNormalBinder().toJson(map));
        QueryResult<CrpRecharge> qlist = this.crpRechargeService.queryCrpPage(map);
        this.logger.error("qlist====4", (Object)JsonUtil.buildNormalBinder().toJson(qlist));
        if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            for (CrpRecharge crpRecharge : qlist.getList()) {
                this.crpRechargeService.updateCrpRechargeEndToTime(crpRecharge);
            }
        }
        map.remove("rechargeEndStr");
        map.put("rechargeStartQend", da);
        map.put("rechargeEndQstart", da);
        map.put("order", true);
        map.put("orderStr", "RECHARGE_END ASC");
        map.put("rechargeSortStr", "3");
        map.put("rechargeName10", "0,-1");
        this.logger.error("map====1", (Object)JsonUtil.buildNormalBinder().toJson(map));
        qlist = this.crpRechargeService.queryCrpPage(map);
        this.logger.error("qlist====1", (Object)JsonUtil.buildNormalBinder().toJson(qlist));
        if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            for (CrpRecharge crpRecharge : qlist.getList()) {
                this.crpRechargeService.updateCrpRechargeStarToTime(crpRecharge);
            }
        }
        map = new HashMap();
        map.put("tenantCode", tenantCode);
        map.put("rechargeType", "0");
        map.put("rechargeName10", "3");
        map.put("rechargeState", 3);
        map.put("rechargeSort", "3");
        map.put("order", true);
        map.put("orderStr", "RECHARGE_END  asc, RECHARGE_ID asc");
        map.put("refundType", "automatic");
        return this.crpRechargeService.updateBmoneyCrpTobeReturn(map);
    }
}

