/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.crp.service.impl;

import com.yqbsoft.laser.service.crp.CrpConstants;
import com.yqbsoft.laser.service.crp.dao.CrpRechargeMapper;
import com.yqbsoft.laser.service.crp.dao.CrpUrechargeconfMapper;
import com.yqbsoft.laser.service.crp.dao.CrpUrechargelistMapper;
import com.yqbsoft.laser.service.crp.domain.CpRechargeDomain;
import com.yqbsoft.laser.service.crp.domain.CrpChannelsendDomain;
import com.yqbsoft.laser.service.crp.domain.CrpRechargeDomain;
import com.yqbsoft.laser.service.crp.domain.CrpRechargeReDomain;
import com.yqbsoft.laser.service.crp.domain.CrpUrechargeDomain;
import com.yqbsoft.laser.service.crp.domain.CrpUrechargelistDomain;
import com.yqbsoft.laser.service.crp.domain.MessageEnum;
import com.yqbsoft.laser.service.crp.domain.OcContractDomain;
import com.yqbsoft.laser.service.crp.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.crp.domain.OcContractReDomain;
import com.yqbsoft.laser.service.crp.domain.OcContractSettlDomain;
import com.yqbsoft.laser.service.crp.domain.PtePtfchannelReDomain;
import com.yqbsoft.laser.service.crp.domain.SgGoodsNumDomain;
import com.yqbsoft.laser.service.crp.domain.SgSendgoodsDomain;
import com.yqbsoft.laser.service.crp.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.crp.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.crp.domain.VdFaccountOuterSubsetDomain;
import com.yqbsoft.laser.service.crp.engine.SendPutThread;
import com.yqbsoft.laser.service.crp.model.CpRecharge;
import com.yqbsoft.laser.service.crp.model.CrpChannelsend;
import com.yqbsoft.laser.service.crp.model.CrpRecharge;
import com.yqbsoft.laser.service.crp.model.CrpUrecharge;
import com.yqbsoft.laser.service.crp.model.CrpUrechargelist;
import com.yqbsoft.laser.service.crp.model.OcContract;
import com.yqbsoft.laser.service.crp.model.OcContractSettl;
import com.yqbsoft.laser.service.crp.model.SgSendgoods;
import com.yqbsoft.laser.service.crp.model.SgSendgoodsGoods;
import com.yqbsoft.laser.service.crp.model.VdFaccountInfo;
import com.yqbsoft.laser.service.crp.model.VdFaccountOuter;
import com.yqbsoft.laser.service.crp.model.VdFaccountOuterDt;
import com.yqbsoft.laser.service.crp.model.VdFaccountOuterSubset;
import com.yqbsoft.laser.service.crp.service.CrpChannelsendService;
import com.yqbsoft.laser.service.crp.service.CrpRechargeService;
import com.yqbsoft.laser.service.crp.service.CrpUrechargeService;
import com.yqbsoft.laser.service.crp.service.CrpUrechargelistService;
import com.yqbsoft.laser.service.crp.service.impl.CrpChannelsendServiceImpl;
import com.yqbsoft.laser.service.crp.utils.FlagSettingUtils;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.RandomUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class CrpRechargeServiceImpl
extends BaseServiceImpl
implements CrpRechargeService {
    private static final String SYS_CODE = "service.crp.CrpRechargeServiceImpl";
    private CrpChannelsendService crpChannelsendService;
    private CrpRechargeMapper crpRechargeMapper;
    private CrpUrechargeService crpUrechargeService;
    private CrpUrechargelistMapper crpUrechargelistMapper;
    private CrpUrechargelistService crpUrechargelistService;
    CrpUrechargeconfMapper crpUrechargeconfMapper;

    public void setCrpUrechargelistMapper(CrpUrechargelistMapper crpUrechargelistMapper) {
        this.crpUrechargelistMapper = crpUrechargelistMapper;
    }

    public CrpUrechargelistService getCrpUrechargelistService() {
        return this.crpUrechargelistService;
    }

    public void setCrpUrechargelistService(CrpUrechargelistService crpUrechargelistService) {
        this.crpUrechargelistService = crpUrechargelistService;
    }

    public CrpUrechargeService getCrpUrechargeService() {
        return this.crpUrechargeService;
    }

    public void setCrpUrechargeService(CrpUrechargeService crpUrechargeService) {
        this.crpUrechargeService = crpUrechargeService;
    }

    public CrpChannelsendService getCrpChannelsendService() {
        return this.crpChannelsendService;
    }

    public void setCrpChannelsendService(CrpChannelsendService crpChannelsendService) {
        this.crpChannelsendService = crpChannelsendService;
    }

    public void setCrpRechargeMapper(CrpRechargeMapper crpRechargeMapper) {
        this.crpRechargeMapper = crpRechargeMapper;
    }

    private Date getSysDate() {
        try {
            return this.crpRechargeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCrp(CrpRechargeDomain crpRechargeDomain) {
        if (null == crpRechargeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)crpRechargeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCrpDefault(CrpRecharge crpRecharge) {
        if (null == crpRecharge) {
            return;
        }
        if (null == crpRecharge.getDataState()) {
            crpRecharge.setDataState(1);
        }
        Date date = this.getSysDate();
        if (null == crpRecharge.getGmtCreate()) {
            crpRecharge.setGmtCreate(date);
        }
        crpRecharge.setGmtModified(date);
        if (StringUtils.isBlank((String)crpRecharge.getRechargeCode())) {
            crpRecharge.setRechargeCode(this.getNo(null, "CrpRecharge", "crpRecharge", crpRecharge.getTenantCode()));
        }
    }

    private int getCrpMaxCode() {
        int code = 0;
        try {
            return this.crpRechargeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.getCrpMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCrpUpdataDefault(CrpRecharge crpRecharge) {
        if (null == crpRecharge) {
            return;
        }
        crpRecharge.setGmtModified(this.getSysDate());
    }

    @Override
    public List<CrpChannelsend> saveCrpRecharge(CrpRechargeDomain crpRechargeDomain) throws ApiException {
        if (null == crpRechargeDomain) {
            return null;
        }
        if (StringUtils.isBlank((String)crpRechargeDomain.getRechargeType())) {
            crpRechargeDomain.setRechargeType("0");
        }
        if (EmptyUtil.isEmpty((Object)crpRechargeDomain.getRechargeState())) {
            crpRechargeDomain.setRechargeState(CrpConstants.RECHARGE_STATE_OPEN);
        }
        return this.saveCrpRechargeRe(crpRechargeDomain);
    }

    private List<CrpChannelsend> saveCrpRechargeRe(CrpRechargeDomain crpRechargeDomain) throws ApiException {
        CrpRecharge ctCustrel = this.createCrpRecharge(crpRechargeDomain);
        if (null != ctCustrel.getRechargeState() && 2 == ctCustrel.getRechargeState()) {
            ctCustrel.setDataState(2);
        }
        this.saveCrpModel(ctCustrel);
        if (null != ctCustrel.getRechargeState() && 2 == ctCustrel.getRechargeState()) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.saveCrpRechargeRe", (Object)JsonUtil.buildNormalBinder().toJson((Object)ctCustrel));
            this.handlerCrpRechargeB2B(ctCustrel);
        }
        ArrayList<CrpRecharge> list = new ArrayList<CrpRecharge>();
        list.add(ctCustrel);
        return this.buidPmChannelsend(list, "insert");
    }

    private List<CrpChannelsend> buidPmChannelsend(List<CrpRecharge> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<CrpChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<CrpChannelsendDomain> disChannelsendDomainList = new ArrayList<CrpChannelsendDomain>();
        for (CrpRecharge promotion : pmPromotionList) {
            CrpChannelsendDomain pmChannelsendDomain = new CrpChannelsendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getRechargeCode());
            pmChannelsendDomain.setChannelsendType("crpRecharge");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.crpChannelsendService.saveCrpBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    private void saveCrpModel(CrpRecharge crpRecharge) throws ApiException {
        if (null == crpRecharge) {
            return;
        }
        try {
            this.crpRechargeMapper.insert(crpRecharge);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.saveCrpModel.ex", (Throwable)e);
        }
    }

    private void saveCrpBatchModel(List<CrpRecharge> crpRechargeList) throws ApiException {
        if (null == crpRechargeList || crpRechargeList.isEmpty()) {
            return;
        }
        try {
            this.crpRechargeMapper.insertBatch(crpRechargeList);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.saveCrpBatchModel.ex", (Throwable)e);
        }
    }

    private CrpRecharge getCrpModelById(Integer rechargeId) {
        if (null == rechargeId) {
            return null;
        }
        try {
            return this.crpRechargeMapper.selectByPrimaryKey(rechargeId);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.getCrpModelById", (Throwable)e);
            return null;
        }
    }

    private CrpRecharge getCrpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.crpRechargeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.getCrpModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCrpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.crpRechargeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.delCrpModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.delCrpModelByCode.num");
        }
    }

    private void deleteCrpModel(Integer rechargeId) throws ApiException {
        if (null == rechargeId) {
            return;
        }
        int i = 0;
        try {
            i = this.crpRechargeMapper.deleteByPrimaryKey(rechargeId);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.deleteCrpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.deleteCrpModel.num");
        }
    }

    private void updateCrpModel(CrpRecharge crpRecharge) throws ApiException {
        if (null == crpRecharge) {
            return;
        }
        int i = 0;
        try {
            i = this.crpRechargeMapper.updateByPrimaryKey(crpRecharge);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpModel.num");
        }
    }

    private void updateByPrimaryKeyModel(CrpRecharge crpRecharge) throws ApiException {
        if (null == crpRecharge) {
            return;
        }
        int i = 0;
        try {
            i = this.crpRechargeMapper.updateByPrimaryKeySelective(crpRecharge);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateByPrimaryKeyModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateByPrimaryKeyModel.num");
        }
    }

    private void updateStateCrpModel(Integer rechargeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == rechargeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rechargeId", rechargeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crpRechargeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateStateCrpModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateStateCrpModel.null");
        }
    }

    private boolean lockRechargesData(Map<String, Object> map) {
        if (map.isEmpty()) {
            return false;
        }
        int i = 0;
        try {
            i = this.crpRechargeMapper.lockDataByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.lockGoodsData", map.toString(), (Throwable)e);
        }
        return i > 0;
    }

    private void updateStateCrpModelByCode(String tenantCode, String rechargeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)rechargeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rechargeCode", rechargeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crpRechargeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateStateCrpModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateStateCrpModelByCode.null", JsonUtil.buildNonNullBinder().toJson(map));
        }
    }

    private CrpRecharge makeCrp(CrpRechargeDomain crpRechargeDomain, CrpRecharge crpRecharge) {
        if (null == crpRechargeDomain) {
            return null;
        }
        if (null == crpRecharge) {
            crpRecharge = new CrpRecharge();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)crpRecharge, (Object)crpRechargeDomain);
            return crpRecharge;
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.makeCrp", (Throwable)e);
            return null;
        }
    }

    private CrpRechargeReDomain makeCrpRechargeReDomain(CrpRecharge crpRecharge) {
        if (null == crpRecharge) {
            return null;
        }
        CrpRechargeReDomain crpRechargeReDomain = new CrpRechargeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crpRechargeReDomain, (Object)crpRecharge);
            return crpRechargeReDomain;
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.makeCrpRechargeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CrpRecharge> queryCrpModelPage(Map<String, Object> parammap) {
        try {
            return this.crpRechargeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.queryCrpModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<CrpRecharge> queryBmoney(Map<String, Object> map) {
        List<CrpRecharge> crpRecharges = this.queryBmoneyModel(map);
        return crpRecharges;
    }

    private List<CrpRecharge> queryBmoneyModel(Map<String, Object> parammap) {
        try {
            return this.crpRechargeMapper.queryBmoney(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.queryBmoneyModel", (Throwable)e);
            return null;
        }
    }

    private List<CrpRecharge> queryBmoneyToAutomatic(Map<String, Object> parammap) {
        try {
            return this.crpRechargeMapper.queryBmoneyToAutomatic(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.queryBmoneyToAutomatic", (Throwable)e);
            return null;
        }
    }

    private List<CrpRecharge> queryRechargeGroup(Map<String, Object> parammap) {
        try {
            return this.crpRechargeMapper.queryRechargeGroup(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.queryCrpModel", (Throwable)e);
            return null;
        }
    }

    private List<CrpRechargeReDomain> queryCrpModelPageList(Map<String, Object> parammap) {
        try {
            return this.crpRechargeMapper.queryCrpRechargePageList(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.queryCrpModel", (Throwable)e);
            return null;
        }
    }

    private int countCrp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.crpRechargeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.countCrp", (Throwable)e);
        }
        return i;
    }

    private int countCrpRechargeRe(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.crpRechargeMapper.countCrpRechargeRe(map);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.countCrp", (Throwable)e);
        }
        return i;
    }

    private CrpRecharge createCrpRecharge(CrpRechargeDomain crpRechargeDomain) {
        String msg = this.checkCrp(crpRechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.saveCrp.checkCrp", msg);
        }
        CrpRecharge crpRecharge = this.makeCrp(crpRechargeDomain, null);
        this.setCrpDefault(crpRecharge);
        crpRechargeDomain.setRechargeCode(crpRecharge.getRechargeCode());
        return crpRecharge;
    }

    @Override
    public List<CrpChannelsend> saveCrpRechargeBatch(List<CrpRechargeDomain> crpRechargeDomainList) throws ApiException {
        if (null == crpRechargeDomainList || crpRechargeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CrpChannelsend> relist = new ArrayList<CrpChannelsend>();
        for (CrpRechargeDomain crpRechargeDomain : crpRechargeDomainList) {
            List<CrpChannelsend> list = this.saveCrpRecharge(crpRechargeDomain);
            if (!ListUtil.isNotEmpty(list)) continue;
            relist.addAll(list);
        }
        return relist;
    }

    @Override
    public List<CrpChannelsend> updateCrpRechargeState(Integer rechargeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == rechargeId) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpRechargeState.null");
        }
        CrpRecharge crpRecharge = this.getCrpRecharge(rechargeId);
        if (null == crpRecharge) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpRechargeState.crpRecharge", rechargeId + "");
        }
        return this.updateCrpRechargeStateAll(crpRecharge, dataState, oldDataState, map);
    }

    public List<CrpChannelsend> updateCrpRechargeStateAll(CrpRecharge crpRecharge, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == crpRecharge) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpRechargeStateAll.null");
        }
        if (null == map) {
            map = new HashMap<String, Object>();
        }
        if (CrpConstants.RECHARGE_STATE_OPEN.compareTo(crpRecharge.getRechargeState()) == 0) {
            if (map.containsKey("rechargeName3") && map.containsKey("rechargeName4")) {
                this.logger.info("service.crp.CrpRechargeServiceImpl.updateCrpRechargeStateAll.date", (Object)(map.get("rechargeName3") + "  " + map.get("rechargeName4")));
                Date dateStart = null;
                Date dateEnd = null;
                try {
                    dateStart = DateUtil.getDateToString((String)String.valueOf(map.get("rechargeName3")), (String)"yyyy-MM-dd HH:mm:ss");
                    dateEnd = DateUtil.getDateToString((String)String.valueOf(map.get("rechargeName4")), (String)"yyyy-MM-dd HH:mm:ss");
                }
                catch (Exception e) {
                    throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpRechargeStateAll.date is error");
                }
                if (dataState == 2 && (null == dateStart || dateStart.getTime() <= new Date().getTime())) {
                    map.put("rechargeState", CrpConstants.RECHARGE_STATE_0);
                }
                if (dataState == 2 && null != dateEnd && dateEnd.getTime() <= new Date().getTime()) {
                    map.put("rechargeState", CrpConstants.RECHARGE_STATE_END);
                }
                map.put("rechargeStart", dateStart);
                map.put("rechargeEnd", dateEnd);
            } else {
                if (dataState == 2 && (null == crpRecharge.getRechargeStart() || crpRecharge.getRechargeStart().getTime() <= new Date().getTime())) {
                    map.put("rechargeState", CrpConstants.RECHARGE_STATE_0);
                }
                if (dataState == 2 && null != crpRecharge.getRechargeEnd() && crpRecharge.getRechargeEnd().getTime() <= new Date().getTime()) {
                    map.put("rechargeState", CrpConstants.RECHARGE_STATE_END);
                }
            }
        }
        this.updateStateCrpModel(crpRecharge.getRechargeId(), dataState, oldDataState, map);
        if (dataState != 2) {
            return null;
        }
        crpRecharge = this.getCrpRecharge(crpRecharge.getRechargeId());
        List<CrpChannelsend> relist = null;
        String getddflag = FlagSettingUtils.getUrl(crpRecharge.getTenantCode(), "CrpBalance", "CrpBalance");
        Integer rechargeState = null == map.get("rechargeState") ? 1 : Integer.valueOf(map.get("rechargeState").toString());
        if (StringUtils.isNotBlank((String)getddflag) && rechargeState == 0) {
            relist = this.handlerCrpRecharge(crpRecharge);
        } else if (StringUtils.isBlank((String)getddflag)) {
            relist = this.handlerCrpRecharge(crpRecharge);
        }
        ArrayList<CrpRecharge> list = new ArrayList<CrpRecharge>();
        list.add(crpRecharge);
        List<CrpChannelsend> relistm = this.buidPmChannelsendStr(list, "update");
        if (null == relistm) {
            relistm = new ArrayList<CrpChannelsend>();
        }
        if (null != relist) {
            relistm.addAll(relist);
        }
        return relistm;
    }

    @Override
    public List<CrpChannelsend> updateCrpRechargeStateByCode(String tenantCode, String rechargeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        CrpRecharge crpRecharge = this.getCrpByCode(tenantCode, rechargeCode);
        if (null == crpRecharge) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpRechargeStateByCode.crpRecharge", rechargeCode + "");
        }
        return this.updateCrpRechargeStateAll(crpRecharge, dataState, oldDataState, map);
    }

    private List<CrpChannelsend> handlerCrpRecharge(CrpRecharge crpRecharge) {
        if (null == crpRecharge) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.handlerCrpRecharge.crpRecharge", (Object)"crpRecharge is null");
            return null;
        }
        if (crpRecharge.getDataState() != 2 && crpRecharge.getRechargeState().intValue() != CrpConstants.RECHARGE_STATE_0.intValue()) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.handlerCrpRecharge.crpRecharge.dataState", (Object)JsonUtil.buildNormalBinder().toJson((Object)crpRecharge));
            return null;
        }
        CrpUrechargelistDomain crpUrechargelistDomain = new CrpUrechargelistDomain();
        crpUrechargelistDomain.setRechargeOpcode(crpRecharge.getRechargeOpcode());
        try {
            BeanUtils.copyAllPropertys((Object)crpUrechargelistDomain, (Object)crpRecharge);
            crpUrechargelistDomain.setRechargeAllmoney(crpRecharge.getRechargeMoney());
            crpUrechargelistDomain.setRechargeSmoney(crpRecharge.getRechargeMoney());
            crpUrechargelistDomain.setUrechargelistDir("0");
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.handlerCrpRecharge", (Throwable)e);
        }
        if (!"0".equals(crpRecharge.getRechargeType())) {
            return this.updateCrpRechargeList(crpUrechargelistDomain);
        }
        String field = crpUrechargelistDomain.getTenantCode().concat("-").concat("1-creat_type_one");
        String cds = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
        String name10 = crpUrechargelistDomain.getRechargeName10();
        if ("0".equals(crpUrechargelistDomain.getRechargeType()) && StringUtils.isNotBlank((String)cds)) {
            crpUrechargelistDomain.setBankcodeName(cds);
            if (!EmptyUtil.isEmpty((Object)crpRecharge.getRechargeMoney())) {
                crpUrechargelistDomain.setRechargeUrl4(crpRecharge.getRechargeMoney().toString());
            }
            String randomCode = RandomUtils.generateRandom((int)16, (Integer)0);
            crpUrechargelistDomain.setRechargeUrl3(randomCode);
            crpUrechargelistDomain.setRechargeName10(null);
            crpUrechargelistDomain.setRechargeName9(null);
        }
        List<CrpChannelsend> channelsends = this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelistDomain);
        if (StringUtils.isNotBlank((String)name10)) {
            crpUrechargelistDomain.setRechargeName10(name10);
        }
        this.crpUrechargeService.saveOrUpdateCrpUrecharge(crpUrechargelistDomain);
        return channelsends;
    }

    private List<CrpChannelsend> buidPmChannelsendStr(List<CrpRecharge> crpRechargeList, String dri) {
        if (ListUtil.isEmpty(crpRechargeList)) {
            return null;
        }
        ArrayList<CrpChannelsendDomain> disChannelsendDomainList = new ArrayList<CrpChannelsendDomain>();
        for (CrpRecharge recharge : crpRechargeList) {
            CrpChannelsendDomain crpChannelsendDomain = new CrpChannelsendDomain();
            crpChannelsendDomain.setChannelsendOpcode(recharge.getRechargeCode());
            crpChannelsendDomain.setChannelsendType("crpRecharge");
            crpChannelsendDomain.setChannelsendDir(dri);
            crpChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)recharge));
            crpChannelsendDomain.setTenantCode(recharge.getTenantCode());
            disChannelsendDomainList.add(crpChannelsendDomain);
        }
        List<CrpChannelsend> pmChannelsendList = this.crpChannelsendService.saveCrpBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    @Override
    public List<CrpChannelsend> updateCrpRecharge(CrpRechargeDomain crpRechargeDomain) throws ApiException {
        Date vf;
        String nowStr;
        Date da;
        String msg = this.checkCrp(crpRechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrp.checkCrp", msg);
        }
        CrpRecharge crpRecharge = this.getCrpModelById(crpRechargeDomain.getRechargeId());
        if (null == crpRecharge) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        Integer dataState = crpRecharge.getDataState();
        String name10 = crpRecharge.getRechargeName10();
        BigDecimal allRechargeMoney = crpRecharge.getRechargeMoney();
        if (EmptyUtil.isEmpty((Object)allRechargeMoney)) {
            allRechargeMoney = BigDecimal.ZERO;
        }
        if (EmptyUtil.isEmpty((Object)crpRecharge.getRechargeUmoney())) {
            crpRecharge.setRechargeUmoney(BigDecimal.ZERO);
        }
        Integer state = crpRecharge.getRechargeState();
        ArrayList<CrpRecharge> list = new ArrayList<CrpRecharge>();
        crpRecharge = this.makeCrp(crpRechargeDomain, crpRecharge);
        this.setCrpUpdataDefault(crpRecharge);
        if (CrpConstants.RECHARGE_STATE_OPEN.intValue() == crpRecharge.getRechargeState().intValue() && (da = DateUtil.getDateToString((String)(nowStr = DateUtil.getDateString((Date)(vf = new Date()), (String)"yyyy-MM-dd")), (String)"yyyy-MM-dd")).compareTo(crpRechargeDomain.getRechargeEnd()) > 0) {
            crpRecharge.setRechargeState(CrpConstants.RECHARGE_STATE_END);
        }
        this.updateCrpModel(crpRecharge);
        BigDecimal sMoneys = BigDecimal.ZERO;
        if (EmptyUtil.isEmpty((Object)crpRechargeDomain.getRechargeUmoney())) {
            crpRechargeDomain.setRechargeUmoney(BigDecimal.ZERO);
        }
        boolean allFlag = false;
        BigDecimal allFlagMoney = BigDecimal.ZERO;
        if (2 == dataState && !crpRechargeDomain.getRechargeState().equals(state)) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRecharge", (Object)(JsonUtil.buildNormalBinder().toJson((Object)crpRechargeDomain) + "state:" + state + "name10:" + name10));
            if (state == 1 && 0 == crpRechargeDomain.getRechargeState()) {
                if ("-1".equals(crpRechargeDomain.getRechargeName10())) {
                    allFlag = true;
                    allFlagMoney = crpRecharge.getRechargeMoney();
                } else if ("0".equals(crpRechargeDomain.getRechargeName10())) {
                    allFlag = true;
                    allFlagMoney = crpRecharge.getRechargeMoney();
                    sMoneys = crpRecharge.getRechargeMoney().subtract(crpRecharge.getRechargeUmoney());
                } else if ("3".equals(crpRechargeDomain.getRechargeName10())) {
                    // empty if block
                }
            } else if (state == 0 && 1 == crpRechargeDomain.getRechargeState()) {
                if (!crpRechargeDomain.getRechargeName10().equals(name10)) {
                    if ("-1".equals(crpRechargeDomain.getRechargeName10()) && "0".equals(name10)) {
                        sMoneys = crpRechargeDomain.getRechargeMoney().subtract(crpRechargeDomain.getRechargeUmoney());
                        sMoneys = new BigDecimal("-1").multiply(sMoneys);
                        allFlag = true;
                        allFlagMoney = new BigDecimal("-1").multiply(crpRecharge.getRechargeMoney());
                    } else if ("0".equals(crpRechargeDomain.getRechargeName10()) && "-1".equals(name10)) {
                        allFlag = true;
                        allFlagMoney = new BigDecimal("-1").multiply(crpRecharge.getRechargeMoney());
                    }
                } else if ("-1".equals(crpRechargeDomain.getRechargeName10())) {
                    allFlag = true;
                    allFlagMoney = new BigDecimal("-1").multiply(crpRecharge.getRechargeMoney());
                } else if ("0".equals(crpRechargeDomain.getRechargeName10())) {
                    sMoneys = crpRechargeDomain.getRechargeMoney().subtract(crpRechargeDomain.getRechargeUmoney());
                    sMoneys = new BigDecimal("-1").multiply(sMoneys);
                    allFlag = true;
                    allFlagMoney = new BigDecimal("-1").multiply(crpRecharge.getRechargeMoney());
                }
            } else if (state == 0 && 3 == crpRechargeDomain.getRechargeState()) {
                if (!crpRechargeDomain.getRechargeName10().equals(name10)) {
                    if ("-1".equals(crpRechargeDomain.getRechargeName10()) && "0".equals(name10)) {
                        sMoneys = crpRechargeDomain.getRechargeMoney().subtract(crpRechargeDomain.getRechargeUmoney());
                        sMoneys = new BigDecimal("-1").multiply(sMoneys);
                        allFlag = true;
                        allFlagMoney = new BigDecimal("-1").multiply(crpRecharge.getRechargeMoney());
                    } else if (!"-1".equals(crpRechargeDomain.getRechargeName10()) || !"3".equals(name10)) {
                        if ("0".equals(crpRechargeDomain.getRechargeName10()) && "-1".equals(name10)) {
                            allFlag = true;
                            allFlagMoney = new BigDecimal("-1").multiply(crpRecharge.getRechargeMoney());
                        } else if ("3".equals(crpRechargeDomain.getRechargeName10()) && "0".equals(name10)) {
                            sMoneys = crpRechargeDomain.getRechargeMoney().subtract(crpRechargeDomain.getRechargeUmoney());
                            sMoneys = new BigDecimal("-1").multiply(sMoneys);
                            allFlag = true;
                            allFlagMoney = new BigDecimal("-1").multiply(crpRecharge.getRechargeMoney());
                        } else if ("3".equals(crpRechargeDomain.getRechargeName10()) && "-1".equals(name10)) {
                            allFlag = true;
                            allFlagMoney = new BigDecimal("-1").multiply(crpRecharge.getRechargeMoney());
                        }
                    }
                } else {
                    allFlag = true;
                    allFlagMoney = new BigDecimal("-1").multiply(crpRecharge.getRechargeMoney());
                    if (!"-1".equals(crpRechargeDomain.getRechargeName10()) && "0".equals(crpRechargeDomain.getRechargeName10())) {
                        sMoneys = crpRechargeDomain.getRechargeMoney().subtract(crpRechargeDomain.getRechargeUmoney());
                        sMoneys = new BigDecimal("-1").multiply(sMoneys);
                    }
                }
            }
        } else if (2 == dataState && crpRechargeDomain.getRechargeState().equals(state)) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRecharge-one", (Object)(JsonUtil.buildNormalBinder().toJson((Object)crpRechargeDomain) + "state:" + state + "name10:" + name10));
            if (1 != crpRechargeDomain.getRechargeState() && 0 == crpRechargeDomain.getRechargeState() && !crpRechargeDomain.getRechargeName10().equals(name10)) {
                if ("-1".equals(crpRechargeDomain.getRechargeName10()) && "0".equals(name10)) {
                    sMoneys = crpRechargeDomain.getRechargeMoney().subtract(crpRechargeDomain.getRechargeUmoney());
                    sMoneys = new BigDecimal("-1").multiply(sMoneys);
                } else if ("0".equals(crpRechargeDomain.getRechargeName10()) && "-1".equals(name10)) {
                    sMoneys = crpRechargeDomain.getRechargeMoney().subtract(crpRechargeDomain.getRechargeUmoney());
                }
            }
        }
        if (sMoneys.compareTo(BigDecimal.ZERO) != 0 || allFlag) {
            HashMap<String, Object> stringObjectMap = new HashMap<String, Object>();
            stringObjectMap.put("tenantCode", crpRecharge.getTenantCode());
            stringObjectMap.put("userinfoCode", crpRecharge.getUserinfoCode());
            stringObjectMap.put("rechargeMode", crpRecharge.getRechargeMode());
            QueryResult<CrpUrecharge> queryResult = this.crpUrechargeService.queryCrpUrechargePage(stringObjectMap);
            if (null != queryResult && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
                CrpUrecharge crpUrecharge = (CrpUrecharge)queryResult.getList().get(0);
                HashMap<String, Object> crpMap = new HashMap<String, Object>();
                crpMap.put("tenantCode", crpUrecharge.getTenantCode());
                crpMap.put("rechargeMode", crpUrecharge.getRechargeMode());
                crpMap.put("userinfoCode", crpUrecharge.getUserinfoCode());
                crpMap.put("rechargeType", "0");
                crpMap.put("rechargeName10", "0");
                crpMap.put("dataState", 2);
                Date vf2 = new Date();
                String nowStr2 = DateUtil.getDateString((Date)vf2, (String)"yyyy-MM-dd");
                Date da2 = DateUtil.getDateToString((String)nowStr2, (String)"yyyy-MM-dd");
                crpMap.put("rechargeStartQend", da2);
                crpMap.put("rechargeEndQstart", da2);
                crpMap.put("order", true);
                crpMap.put("orderStr", "RECHARGE_END desc");
                HashMap<String, Object> sendMap = new HashMap<String, Object>();
                QueryResult<CrpRecharge> queryResu = this.queryCrpPage(crpMap);
                if (null != queryResu && ListUtil.isNotEmpty((Collection)queryResu.getList())) {
                    CrpRecharge crpRechar = (CrpRecharge)queryResu.getList().get(0);
                    sendMap.put("rechargeEnd", crpRechar.getRechargeEnd());
                }
                CrpUrechargeDomain crpUrechargeDomain = new CrpUrechargeDomain();
                crpUrechargeDomain.setUrechargeId(crpUrecharge.getUrechargeId());
                crpUrechargeDomain.setTenantCode(crpRechargeDomain.getTenantCode());
                sendMap.put("tenantCode", crpRechargeDomain.getTenantCode());
                sendMap.put("urechargeCode", crpUrecharge.getUrechargeCode());
                sendMap.put("rechargeSmoney", sMoneys);
                sendMap.put("allRechargeMoney", allFlagMoney);
                sendMap.put("type", "57");
                this.logger.error("sendMap====-", (Object)JsonUtil.buildNormalBinder().toJson(sendMap));
                this.crpUrechargeService.updateUrechargeBlanceByCode(sendMap);
            }
        }
        list.add(crpRecharge);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public List<CrpChannelsend> auditCrpRecharge(Map<String, Object> map) throws ApiException {
        Integer rechargeId = Integer.parseInt(map.get("rechargeId").toString());
        Integer dataState = Integer.parseInt(map.get("dataState").toString());
        CrpRecharge crpRecharge = this.getCrpModelById(rechargeId);
        if (null == crpRecharge) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        crpRecharge.setDataState(dataState);
        crpRecharge.setRechargeMode(map.get("rechargeMode") != null ? map.get("rechargeMode").toString() : null);
        crpRecharge.setRechargeUrl1(map.get("rechargeUrl1") != null ? map.get("rechargeUrl1").toString() : null);
        if (map.get("rechargeMode").toString().equals("0")) {
            crpRecharge.setRechargeName1(map.get("rechargeName1") != null ? map.get("rechargeName1").toString() : null);
        }
        if (!EmptyUtil.isEmpty((Object)map.get("rechargeName3"))) {
            crpRecharge.setRechargeName3(map.get("rechargeName3").toString());
        }
        if (!EmptyUtil.isEmpty((Object)map.get("rechargeName3"))) {
            crpRecharge.setRechargeName3(map.get("rechargeName3").toString());
        }
        if (!EmptyUtil.isEmpty((Object)map.get("rechargeName4"))) {
            crpRecharge.setRechargeName4(map.get("rechargeName4").toString());
        }
        if (dataState == 2 && !EmptyUtil.isEmpty((Object)map.get("rechargeSort"))) {
            crpRecharge.setRechargeSort(map.get("rechargeSort").toString());
        }
        if (dataState == 6) {
            crpRecharge.setMemo(map.get("memo").toString());
        }
        this.setCrpUpdataDefault(crpRecharge);
        this.updateByPrimaryKeyModel(crpRecharge);
        if (dataState == 2) {
            this.handlerCrpRecharge(crpRecharge);
        }
        ArrayList<CrpRecharge> list = new ArrayList<CrpRecharge>();
        list.add(crpRecharge);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public CrpRecharge getCrpRecharge(Integer rechargeId) {
        if (null == rechargeId) {
            return null;
        }
        return this.getCrpModelById(rechargeId);
    }

    @Override
    public List<CrpChannelsend> deleteCrpRecharge(Integer rechargeId) throws ApiException {
        CrpRecharge orgDepartemp = this.getCrpRecharge(rechargeId);
        ArrayList<CrpRecharge> list = new ArrayList<CrpRecharge>();
        list.add(orgDepartemp);
        this.deleteCrpModel(rechargeId);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public QueryResult<CrpRecharge> queryCrpPage(Map<String, Object> map) {
        List<CrpRecharge> crpRechargeList = this.queryCrpModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCrp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(crpRechargeList);
        return queryResult;
    }

    @Override
    public List<CrpRecharge> queryBmoneyCrp(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.queryBmoneyCrp.map");
            return null;
        }
        List<CrpRecharge> crpRechargeList = this.queryBmoneyToAutomatic(map);
        return crpRechargeList;
    }

    @Override
    public synchronized String updateBmoneyCrpTobeReturn(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.queryBmoneyCrpTobeReturn.map");
            return null;
        }
        this.logger.info("service.crp.CrpRechargeServiceImpl.updateBmoneyCrpTobeReturn.map", (Object)JsonUtil.buildNonNullBinder().toJson(map));
        Date rechargeEndQstart = DateUtil.getDateToString((String)"2023-03-01", (String)"yyyy-MM-dd");
        map.put("rechargeEndQstart", rechargeEndQstart);
        List<CrpRecharge> crpList = this.queryBmoneyCrp(map);
        if (ListUtil.isNotEmpty(crpList)) {
            Map<String, List<CrpRecharge>> crpMap = crpList.stream().collect(Collectors.groupingBy(a -> a.getUserinfoCode()));
            if (MapUtil.isNotEmpty(crpMap) && ("automatic".equals(map.get("refundType")) || "vdAutomatic".equals(map.get("refundType")))) {
                for (String key : crpMap.keySet()) {
                    List<CrpRecharge> crpRechar = crpMap.get(key);
                    this.updateCrpUrechargeByAutomaticVd(crpRechar, map);
                }
            } else if (MapUtil.isNotEmpty(crpMap) && ("dms".equals(map.get("refundType")) || "sapDms".equals(map.get("refundType")))) {
                return this.updateCrpUrechargeByAutomaticVdDms(crpList, map);
            }
        }
        return "success";
    }

    @Override
    public String updateBmoneyToRepayment(CpRechargeDomain cpRechargeDomain) {
        this.logger.error("cpRechargeDomain====", (Object)JsonUtil.buildNormalBinder().toJson((Object)cpRechargeDomain));
        if (null == cpRechargeDomain) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateBmoneyToRepayment.cpRecharge");
            return null;
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoCode", cpRechargeDomain.getUserinfoCode());
        map.put("tenantCode", cpRechargeDomain.getTenantCode());
        map.put("rechargeType", "0");
        map.put("rechargeName10", "3");
        map.put("rechargeState", 3);
        map.put("rechargeSort", "3");
        map.put("order", true);
        map.put("orderStr", "RECHARGE_END  asc, RECHARGE_ID asc");
        map.put("refundType", "vdAutomatic");
        this.updateBmoneyCrpTobeReturn(map);
        return "success";
    }

    @Override
    public QueryResult<CrpRechargeReDomain> queryCrpRechargePageList(Map<String, Object> map) {
        List<CrpRechargeReDomain> crpRechargeList = this.queryCrpModelPageList(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCrpRechargeRe(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(crpRechargeList);
        return queryResult;
    }

    @Override
    public CrpRecharge getCrpByCode(String tenantCode, String rechargeCode) throws ApiException {
        if (StringUtils.isBlank((String)rechargeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rechargeCode", rechargeCode);
        return this.getCrpModelByCode(map);
    }

    @Override
    public List<CrpChannelsend> deleteCrpByCode(String tenantCode, String rechargeCode) throws ApiException {
        CrpRecharge orgDepartemp = this.getCrpByCode(tenantCode, rechargeCode);
        ArrayList<CrpRecharge> list = new ArrayList<CrpRecharge>();
        list.add(orgDepartemp);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rechargeCode", rechargeCode);
        this.delCrpModelByCode(map);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public List<CrpChannelsend> updateCrpRechargeDeail(CrpRechargeDomain crpRechargeDomain) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", crpRechargeDomain.getTenantCode());
        map.put("rechargeType", "0");
        map.put("userinfoCode", crpRechargeDomain.getUserinfoCode());
        map.put("rechargeState", CrpConstants.RECHARGE_STATE_0);
        map.put("rechargeName7", "1");
        map.put("rechargeName3Str", "date");
        Integer i = 0;
        Boolean flag = true;
        BigDecimal money = BigDecimal.ZERO;
        BigDecimal upMoney = BigDecimal.ZERO;
        SgSendgoodsReDomain sendgoodsReDomain = null;
        ArrayList<SgSendgoodsGoodsDomain> sendgoodsGoodsDomainList = null;
        QueryResult<CrpRecharge> queryResult = this.queryCrpPage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.queryResult1", map);
            map.put("rechargeType", "1");
            queryResult = this.queryCrpPage(map);
        }
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.updateCrpVd(crpRechargeDomain);
        }
        BigDecimal availableCredit = BigDecimal.ZERO;
        CrpRecharge crpRecharge = (CrpRecharge)queryResult.getList().get(0);
        if ("0".equals(crpRecharge.getRechargeName5())) {
            availableCredit = crpRecharge.getRechargeMoney();
        } else if ("1".equals(crpRecharge.getRechargeName5())) {
            availableCredit = crpRecharge.getRechargeMoney().divide(new BigDecimal(2));
        }
        if (null == crpRechargeDomain.getRechargeName10() || "".equals(crpRechargeDomain.getRechargeName10())) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.rechargeName10", JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain));
        }
        money = new BigDecimal(crpRechargeDomain.getRechargeName10());
        if ("ocContract".equals(crpRechargeDomain.getRechargeRemark())) {
            money = money.multiply(new BigDecimal(0.3)).setScale(2, 4);
        }
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("tenantCode", crpRechargeDomain.getTenantCode());
        map1.put("contractBillcode", crpRechargeDomain.getRechargeOpcode());
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("map", JsonUtil.buildNormalBinder().toJson(map1));
        String json = (String)this.getInternalRouter().inInvoke("oc.contract.getContractModelByCodes", sendMap);
        OcContract ocContract = (OcContract)JsonUtil.buildNonDefaultBinder().getJsonToObject(json, OcContract.class);
        if (null == ocContract) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.contrac", "\u8ba2\u5355\u6570\u636e\u9519\u8bef", JsonUtil.buildNonNullBinder().toJson(sendMap));
        }
        sendgoodsReDomain = new SgSendgoodsReDomain();
        sendgoodsGoodsDomainList = new ArrayList<SgSendgoodsGoodsDomain>();
        if ("sgSendgoods".equals(crpRechargeDomain.getRechargeRemark()) && ("9".equals(crpRechargeDomain.getRechargeType()) || "8".equals(crpRechargeDomain.getRechargeType()))) {
            BigDecimal sendAmount;
            Boolean moneyFlag = false;
            if (null == ocContract.getContractPaymoney() || "".equals(ocContract.getContractPaymoney())) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.contractPaymoney", (Object)ocContract.getContractBillcode());
                ocContract.setContractPaymoney(BigDecimal.ZERO);
            }
            BigDecimal remainAmount = ocContract.getDataBmoney().subtract(ocContract.getContractPaymoney());
            map1.put("contractSettlBlance", "REB");
            String jsonList = (String)this.getInternalRouter().inInvoke("oc.contract.queryContractSettlPage", sendMap);
            SupQueryResult querynulListQuery = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(jsonList, SupQueryResult.class);
            if (null != querynulListQuery && ListUtil.isNotEmpty((Collection)querynulListQuery.getList())) {
                OcContractSettl ocContractSettl = (OcContractSettl)querynulListQuery.getList().get(0);
                if (null == ocContractSettl.getContractSettlGmoney() || "".equals(ocContractSettl.getContractSettlGmoney())) {
                    this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.remainAmount", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractSettl));
                    throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.remainAmount", "\u8fd4\u5229\u7ed3\u7b97\u6570\u636e\u9519\u8bef");
                }
                if ((remainAmount = remainAmount.subtract(ocContractSettl.getContractSettlGmoney())).compareTo(BigDecimal.ZERO) <= 0) {
                    this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.remainAmount", (Object)remainAmount);
                    throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.remainAmount", "\u91d1\u989d\u9519\u8bef");
                }
            }
            map1.remove("contractSettlBlance");
            map1.put("sendgoodsCode", crpRechargeDomain.getRechargeName8());
            map1.put("colValue9", -1);
            String sendGoodsJson = (String)this.getInternalRouter().inInvoke("sg.sendgoods.getSgSendGoods", sendMap);
            SgSendgoodsReDomain sgSendgoodsReDomain = (SgSendgoodsReDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(sendGoodsJson, SgSendgoodsReDomain.class);
            if (null == sgSendgoodsReDomain || ListUtil.isEmpty(sgSendgoodsReDomain.getSgSendgoodsGoodsDomainList())) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.sgSendgoodsReDomain", (Object)remainAmount);
                throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.remainAmount", "\u53d1\u8d27\u5355\u6570\u636e\u9519\u8bef");
            }
            BigDecimal sendGoodsBmoney = sgSendgoodsReDomain.getDataBmoney();
            BigDecimal proportiMoney = sendGoodsBmoney.divide(ocContract.getDataBmoney()).setScale(8, 4);
            this.logger.info("service.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.sendGoodsBmoney", (Object)proportiMoney);
            money = sendAmount = proportiMoney.multiply(remainAmount).setScale(2, 4);
            try {
                BeanUtils.copyAllPropertys((Object)sendgoodsReDomain, (Object)sgSendgoodsReDomain);
                sendgoodsReDomain.setSgSendgoodsGoodsDomainList(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (ocContract.getContractPaymoney().compareTo(BigDecimal.ZERO) == 0 && (null == querynulListQuery || ListUtil.isEmpty((Collection)querynulListQuery.getList()))) {
                this.makeSendGoodsMoney(null, sendgoodsGoodsDomainList, sgSendgoodsReDomain);
            } else {
                sendgoodsReDomain.setContractPaymoney(sendAmount);
                this.makeSendGoodsMoney(sendAmount, sendgoodsGoodsDomainList, sgSendgoodsReDomain);
            }
            sendgoodsReDomain.setSgSendgoodsGoodsDomainList(sendgoodsGoodsDomainList);
        }
        if (availableCredit.compareTo(crpRecharge.getRechargeAmoney()) >= 0) {
            availableCredit = crpRecharge.getRechargeAmoney();
        }
        HashMap<String, Object> crpMap = new HashMap<String, Object>();
        if (availableCredit.compareTo(money) >= 0) {
            upMoney = availableCredit.subtract(money);
            crpRecharge.setRechargeAmoney(upMoney);
        } else {
            upMoney = availableCredit;
            BigDecimal availableCr = money.subtract(availableCredit);
            sendMap.clear();
            map.clear();
            sendMap.put("merchantCode", crpRechargeDomain.getUserinfoCode());
            sendMap.put("faccountType", "101");
            sendMap.put("tenantCode", crpRechargeDomain.getTenantCode());
            map.put("map", JsonUtil.buildNonNullBinder().toJson(sendMap));
            QueryResult queryResutl = this.getQueryResutl("vd.faccountOuter.queryFaccountOuterPageNew", map, VdFaccountOuter.class);
            if (EmptyUtil.isEmpty((Object)queryResutl) || ListUtil.isEmpty((Collection)queryResutl.getList())) {
                throw new ApiException("service.crp.CrpRechargeServiceImplupdateCrpRechargeDeail.null", ((Object)map).toString());
            }
            VdFaccountOuter vdFaccountOuter = (VdFaccountOuter)queryResutl.getList().get(0);
            BigDecimal faccountAmount = vdFaccountOuter.getFaccountAmount();
            if (faccountAmount.compareTo(availableCr) < 0) {
                throw new ApiException("service.crp.CrpRechargeServiceImplupdateCrpRechargeDeail.null", faccountAmount + "," + availableCr);
            }
            vdFaccountOuter.setFaccountAmount(faccountAmount.subtract(availableCr));
            map = new HashMap();
            map.put("vdFaccountOuterDomain", JsonUtil.buildNonNullBinder().toJson((Object)vdFaccountOuter));
            this.getInternalRouter().inInvoke("vd.faccountOuter.updateFaccountOuter", map);
            VdFaccountOuterDt vdFaccountOuterDt = new VdFaccountOuterDt();
            try {
                BeanUtils.copyAllPropertys((Object)vdFaccountOuterDt, (Object)vdFaccountOuter);
                vdFaccountOuterDt.setOrderAmount(availableCr);
                vdFaccountOuterDt.setFaccountAfamount(vdFaccountOuter.getFaccountAmount());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            map = new HashMap();
            map.put("vdFaccountOuterDtDomain", JsonUtil.buildNonNullBinder().toJson((Object)vdFaccountOuter));
            this.getInternalRouter().inInvoke("vd.faccountOuter.saveFaccountOuterDt", map);
        }
        if (StringUtils.isBlank((String)crpRecharge.getRechargeUrl4())) {
            crpMap.put("rechargeUrl4Str", "1");
        } else {
            Integer integer = Integer.valueOf(crpRecharge.getRechargeUrl4());
            crpMap.put("rechargeUrl4Str", integer.toString());
        }
        crpMap.put("tenantCode", crpRecharge.getTenantCode());
        crpMap.put("rechargeUrl4", crpRecharge.getRechargeUrl4());
        crpMap.put("rechargeAmoney", crpRecharge.getRechargeAmoney());
        crpMap.put("rechargeCode", crpRecharge.getRechargeCode());
        crpMap.put("gmtModified", crpRecharge.getGmtModified());
        this.updateStateByCodeAndModified(crpMap);
        map.remove("rechargeType");
        map.remove("rechargeState");
        map.remove("rechargeName7");
        map.remove("rechargeName3Str");
        map.put("rechargeOpcode", crpRechargeDomain.getRechargeOpcode());
        map.put("money", money);
        map.put("rechargeRemark", crpRechargeDomain.getRechargeRemark());
        map.put("sendGoods", sendgoodsReDomain);
        return this.crpUrechargeService.updateCrpUrecharges(map, upMoney);
    }

    public void makeSendGoodsMoney(BigDecimal sendGoodsBmoney, List<SgSendgoodsGoodsDomain> goodsDomainList, SgSendgoodsReDomain sgSendgoodsReDomain) {
        int i = 0;
        BigDecimal goodspecMoney = BigDecimal.ZERO;
        BigDecimal allMoney = BigDecimal.ZERO;
        for (SgSendgoodsGoodsDomain sendgoodsGoodsDomain : sgSendgoodsReDomain.getSgSendgoodsGoodsDomainList()) {
            ++i;
            if (null == sendGoodsBmoney || "".equals(sendGoodsBmoney)) {
                sendgoodsGoodsDomain.setGoodsSpec(sendgoodsGoodsDomain.getContractGoodsMoney().toString());
                continue;
            }
            if (i != sgSendgoodsReDomain.getSgSendgoodsGoodsDomainList().size()) {
                goodspecMoney = sendgoodsGoodsDomain.getContractGoodsMoney().divide(sendGoodsBmoney).setScale(8, 4).multiply(sendGoodsBmoney);
                sendgoodsGoodsDomain.setGoodsSpec(goodspecMoney.toString());
                allMoney = allMoney.add(goodspecMoney);
                continue;
            }
            allMoney = sendGoodsBmoney.subtract(allMoney);
            sendgoodsGoodsDomain.setGoodsSpec(allMoney.toString());
        }
    }

    private void updateStateByCodeAndModified(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateStateByCodeAndModified.map", map);
            return;
        }
        int i = 0;
        try {
            i = this.crpRechargeMapper.updateStateByCodeAndModified(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateStateCrpModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateStateCrpModelByCode.null", JsonUtil.buildNonNullBinder().toJson(map));
        }
    }

    @Override
    public String updateCrpVd(CrpRechargeDomain crpRechargeDomain) throws ApiException {
        HashMap<String, String> sendMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        sendMap.put("merchantCode", crpRechargeDomain.getUserinfoCode());
        sendMap.put("faccountType", "101");
        sendMap.put("tenantCode", crpRechargeDomain.getTenantCode());
        map.put("map", JsonUtil.buildNonNullBinder().toJson(sendMap));
        QueryResult queryResutl = this.getQueryResutl("vd.faccountOuter.queryFaccountOuterPageNew", map, VdFaccountOuter.class);
        if (EmptyUtil.isEmpty((Object)queryResutl) || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            throw new ApiException("service.crp.CrpRechargeServiceImplupdateCrpVd.updateCrpRechargeDeail.null", ((Object)map).toString());
        }
        if (StringUtils.isBlank((String)crpRechargeDomain.getRechargeName10())) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpVd.rechargeName10", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain));
            return "error";
        }
        VdFaccountOuter vdFaccountOuter = (VdFaccountOuter)queryResutl.getList().get(0);
        sendMap.clear();
        map.clear();
        sendMap.put("faccountOuterNo", vdFaccountOuter.getFaccountOuterNo());
        sendMap.put("tenantCode", vdFaccountOuter.getTenantCode());
        sendMap.put("fundType", "01");
        map.put("map", JsonUtil.buildNormalBinder().toJson(sendMap));
        QueryResult sendgoodsGoodsQuery = this.getQueryResutl("vd.faccountOuter.queryFaccountOuterSubsetPage", map, VdFaccountOuterSubset.class);
        VdFaccountOuterSubset vdFaccountOuterSubset = (VdFaccountOuterSubset)sendgoodsGoodsQuery.getList().get(0);
        BigDecimal faccountAmount = vdFaccountOuterSubset.getFaccountAmount();
        if (null == faccountAmount || "".equals(faccountAmount)) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpVd.faccountAmount", (Object)JsonUtil.buildNonNullBinder().toJson((Object)vdFaccountOuter));
            return "error";
        }
        sendMap.clear();
        map.clear();
        map = new HashMap();
        map.put("sendgoodsCode", crpRechargeDomain.getRechargeName8());
        map.put("tenantCode", crpRechargeDomain.getTenantCode());
        sendMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult sendgoodsGoodsQueryResult = this.getQueryResutl("sg.sendgoods.querySendgoodsGoodsPage", sendMap, SgSendgoodsGoods.class);
        if (null == sendgoodsGoodsQueryResult || ListUtil.isEmpty((Collection)sendgoodsGoodsQueryResult.getList())) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpVd.sendgoodsGoodsQueryResult.null", JsonUtil.buildNonNullBinder().toJson((Object)sendgoodsGoodsQuery));
        }
        this.logger.error("service.crp.CrpRechargeServiceImplsendgoodsGoodsQueryResult--1", (Object)JsonUtil.buildNonNullBinder().toJson((Object)sendgoodsGoodsQueryResult));
        BigDecimal consMoney = new BigDecimal(crpRechargeDomain.getRechargeName10());
        if (faccountAmount.compareTo(consMoney) < 0) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpVd.faccountAmount", (Object)("consMoney:" + consMoney + ",faccountAmount:" + faccountAmount));
            return "error";
        }
        BigDecimal remaMoney = faccountAmount.subtract(consMoney);
        VdFaccountOuterSubsetDomain vdFaccountOuterSubsetDomain = new VdFaccountOuterSubsetDomain();
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountOuterSubsetDomain, (Object)vdFaccountOuterSubset);
            vdFaccountOuterSubsetDomain.setFaccountAmount(remaMoney);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        map.clear();
        sendMap.clear();
        map.put("vdFaccountOuterSubsetDomain", JsonUtil.buildNonNullBinder().toJson((Object)vdFaccountOuterSubsetDomain));
        this.logger.error("map------", (Object)JsonUtil.buildNonNullBinder().toJson(map));
        this.getInternalRouter().inInvoke("vd.faccountOuter.updateFaccountOuterSubset", map);
        VdFaccountOuterDt vdFaccountOuterDt = new VdFaccountOuterDt();
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountOuterDt, (Object)vdFaccountOuter);
            BeanUtils.copyAllPropertysNotNull((Object)vdFaccountOuterDt, (Object)vdFaccountOuterSubsetDomain);
            vdFaccountOuterDt.setOrderAmount(consMoney);
            vdFaccountOuterDt.setFaccountAfamount(remaMoney);
            vdFaccountOuterDt.setGmtCreate(null);
            vdFaccountOuterDt.setGmtModified(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        map.clear();
        map.put("vdFaccountOuterDtDomain", JsonUtil.buildNonNullBinder().toJson((Object)vdFaccountOuterDt));
        this.getInternalRouter().inInvoke("vd.faccountOuter.saveFaccountOuterDt", map);
        if (StringUtils.isBlank((String)crpRechargeDomain.getRechargeName7()) || StringUtils.isBlank((String)crpRechargeDomain.getRechargeName6())) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpVd.rechargeName7", JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain));
        }
        ArrayList<SgGoodsNumDomain> sgGoodsNumDomains = new ArrayList<SgGoodsNumDomain>();
        for (SgSendgoodsGoods goods : sendgoodsGoodsQueryResult.getList()) {
            SgGoodsNumDomain sgGoodsNumDomain = new SgGoodsNumDomain();
            sgGoodsNumDomain.setContractBillcode(crpRechargeDomain.getRechargeOpcode());
            sgGoodsNumDomain.setContractGoodsCode(goods.getContractGoodsCode());
            sgGoodsNumDomain.setTenantCode(goods.getTenantCode());
            if (null == goods.getGoodsCweight()) {
                goods.setGoodsOneweight(BigDecimal.ZERO);
            }
            sgGoodsNumDomain.setContractSgSenPaygmoney(consMoney);
            sgGoodsNumDomain.setContractGoodsSgSendweight(goods.getGoodsWeight());
            sgGoodsNumDomain.setContractSgSendnum(new BigDecimal(crpRechargeDomain.getRechargeName7()));
            sgGoodsNumDomain.setContractSgSendweight(new BigDecimal(crpRechargeDomain.getRechargeName6()));
            sgGoodsNumDomains.add(sgGoodsNumDomain);
        }
        map.clear();
        map.put("sgGoodsNumDomainList", JsonUtil.buildNormalBinder().toJson(sgGoodsNumDomains));
        this.logger.error("map---3", (Object)JsonUtil.buildNonNullBinder().toJson(map));
        this.getInternalRouter().inInvoke("oc.contract.updateContractPayAndSgContract", map);
        return "success";
    }

    public String updateCrpVdable(CrpRechargeDomain crpRechargeDomain, Map<String, Object> hashMap) throws ApiException {
        SgGoodsNumDomain sgGoodsNumDomain;
        HashMap<String, String> sendMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        sendMap.put("merchantCode", crpRechargeDomain.getUserinfoCode());
        sendMap.put("faccountType", "101");
        sendMap.put("tenantCode", crpRechargeDomain.getTenantCode());
        map.put("map", JsonUtil.buildNonNullBinder().toJson(sendMap));
        QueryResult queryResutl = this.getQueryResutl("vd.faccountOuter.queryFaccountOuterPageNew", map, VdFaccountOuter.class);
        if (EmptyUtil.isEmpty((Object)queryResutl) || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            throw new ApiException("service.crp.CrpRechargeServiceImplupdateCrpVdable.updateCrpRechargeDeail.null", ((Object)map).toString());
        }
        if (StringUtils.isBlank((String)crpRechargeDomain.getRechargeName10())) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpVdable.rechargeName10", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain));
            return "error";
        }
        VdFaccountOuter vdFaccountOuter = (VdFaccountOuter)queryResutl.getList().get(0);
        sendMap.clear();
        map.clear();
        sendMap.put("faccountOuterNo", vdFaccountOuter.getFaccountOuterNo());
        sendMap.put("tenantCode", vdFaccountOuter.getTenantCode());
        sendMap.put("fundType", "01");
        map.put("map", JsonUtil.buildNormalBinder().toJson(sendMap));
        QueryResult sendgoodsGoodsQuery = this.getQueryResutl("vd.faccountOuter.queryFaccountOuterSubsetPage", map, VdFaccountOuterSubset.class);
        VdFaccountOuterSubset vdFaccountOuterSubset = (VdFaccountOuterSubset)sendgoodsGoodsQuery.getList().get(0);
        BigDecimal faccountAmount = vdFaccountOuterSubset.getFaccountAmount();
        if (null == faccountAmount || "".equals(faccountAmount)) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpVdable.faccountAmount", (Object)JsonUtil.buildNonNullBinder().toJson((Object)vdFaccountOuter));
            return "error";
        }
        BigDecimal consMoney = new BigDecimal(crpRechargeDomain.getRechargeName10());
        if (consMoney.compareTo(BigDecimal.ZERO) > 0) {
            if (faccountAmount.compareTo(consMoney) < 0) {
                BigDecimal dataMoney = consMoney.subtract(faccountAmount);
                this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpVdable.faccountAmount", (Object)("consMoney:" + consMoney + ",faccountAmount:" + faccountAmount));
                return dataMoney.toString();
            }
            BigDecimal remaMoney = faccountAmount.subtract(consMoney);
            VdFaccountOuterSubsetDomain vdFaccountOuterSubsetDomain = new VdFaccountOuterSubsetDomain();
            try {
                BeanUtils.copyAllPropertys((Object)vdFaccountOuterSubsetDomain, (Object)vdFaccountOuterSubset);
                vdFaccountOuterSubsetDomain.setFaccountAmount(remaMoney);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            map.clear();
            sendMap.clear();
            map.put("vdFaccountOuterSubsetDomain", JsonUtil.buildNonNullBinder().toJson((Object)vdFaccountOuterSubsetDomain));
            this.logger.error("map------", (Object)JsonUtil.buildNonNullBinder().toJson(map));
            this.getInternalRouter().inInvoke("vd.faccountOuter.updateFaccountOuterSubset", map);
            VdFaccountOuterDt vdFaccountOuterDt = new VdFaccountOuterDt();
            try {
                Object cds;
                String field;
                BeanUtils.copyAllPropertys((Object)vdFaccountOuterDt, (Object)vdFaccountOuter);
                BeanUtils.copyAllPropertysNotNull((Object)vdFaccountOuterDt, (Object)vdFaccountOuterSubsetDomain);
                vdFaccountOuterDt.setOrderAmount(consMoney);
                vdFaccountOuterDt.setFaccountAfamount(remaMoney);
                vdFaccountOuterDt.setOrderDc("1");
                if ("ocContract".equals(crpRechargeDomain.getRechargeRemark())) {
                    vdFaccountOuterDt.setBusinessOrderno(crpRechargeDomain.getRechargeOpcode());
                    field = crpRechargeDomain.getTenantCode().concat("-").concat("1-transaction_type_one");
                    cds = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
                    vdFaccountOuterDt.setPaymentOrderMemo((String)cds);
                } else if ("sgSendgoods".equals(crpRechargeDomain.getRechargeRemark())) {
                    vdFaccountOuterDt.setBusinessOrderno(crpRechargeDomain.getRechargeName8());
                    field = crpRechargeDomain.getTenantCode().concat("-").concat("3-transaction_type_thre");
                    cds = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
                    vdFaccountOuterDt.setPaymentOrderMemo((String)cds);
                }
                vdFaccountOuterDt.setGmtCreate(null);
                vdFaccountOuterDt.setGmtModified(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            map.clear();
            map.put("vdFaccountOuterDtDomain", JsonUtil.buildNonNullBinder().toJson((Object)vdFaccountOuterDt));
            this.getInternalRouter().inInvoke("vd.faccountOuter.saveFaccountOuterDt", map);
        }
        ArrayList<SgGoodsNumDomain> sgGoodsNumDomains = new ArrayList<SgGoodsNumDomain>();
        if ("ocContract".equals(crpRechargeDomain.getRechargeRemark())) {
            sendMap.clear();
            map.clear();
            map.put("contractBillcode", crpRechargeDomain.getRechargeOpcode());
            map.put("tenantCode", crpRechargeDomain.getTenantCode());
            sendMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
            String obj = (String)this.getInternalRouter().inInvoke("oc.contract.getContractByCode", sendMap);
            OcContractDomain ocContractDomain = (OcContractDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(obj, OcContractDomain.class);
            if (null == ocContractDomain || ListUtil.isEmpty(ocContractDomain.getGoodsList())) {
                throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpVdable.ocContractGoodsList.null", JsonUtil.buildNonNullBinder().toJson(sendMap));
            }
            for (OcContractGoodsDomain goods : ocContractDomain.getGoodsList()) {
                sgGoodsNumDomain = new SgGoodsNumDomain();
                sgGoodsNumDomain.setSendNumFlag(true);
                sgGoodsNumDomain.setContractBillcode(goods.getContractBillcode());
                sgGoodsNumDomain.setContractGoodsCode(goods.getContractGoodsCode());
                sgGoodsNumDomain.setTenantCode(goods.getTenantCode());
                sgGoodsNumDomain.setContractSgSenPaygmoney(consMoney);
                sgGoodsNumDomain.setGoodsCamount(goods.getGoodsCamount());
                sgGoodsNumDomain.setContractGoodsMoney(goods.getContractGoodsMoney());
                sgGoodsNumDomain.setContractGoodsInmoney(goods.getContractGoodsInmoney());
                sgGoodsNumDomain.setContractInmoney(ocContractDomain.getContractInmoney());
                sgGoodsNumDomain.setPricesetNprice(goods.getPricesetNprice());
                if (null != hashMap && null != hashMap.get("money") && !"".equals(hashMap.get("money"))) {
                    Object money = hashMap.get("money");
                    sgGoodsNumDomain.setContractSgSenPaygmoney(new BigDecimal(money.toString()));
                }
                sgGoodsNumDomains.add(sgGoodsNumDomain);
            }
        } else if ("sgSendgoods".equals(crpRechargeDomain.getRechargeRemark())) {
            sendMap.clear();
            map.clear();
            map = new HashMap();
            map.put("sendgoodsCode", crpRechargeDomain.getRechargeName8());
            map.put("tenantCode", crpRechargeDomain.getTenantCode());
            sendMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
            QueryResult sendgoodsGoodsQueryResult = this.getQueryResutl("sg.sendgoods.querySendgoodsGoodsPage", sendMap, SgSendgoodsGoods.class);
            if (null == sendgoodsGoodsQueryResult || ListUtil.isEmpty((Collection)sendgoodsGoodsQueryResult.getList())) {
                throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpVd.sendgoodsGoodsQueryResult.null", JsonUtil.buildNonNullBinder().toJson((Object)sendgoodsGoodsQuery));
            }
            for (SgSendgoodsGoods goods : sendgoodsGoodsQueryResult.getList()) {
                sgGoodsNumDomain = new SgGoodsNumDomain();
                sgGoodsNumDomain.setContractBillcode(goods.getContractBillcode());
                sgGoodsNumDomain.setContractGoodsCode(goods.getContractGoodsCode());
                sgGoodsNumDomain.setTenantCode(goods.getTenantCode());
                sgGoodsNumDomain.setContractSgSenPaygmoney(consMoney);
                sgGoodsNumDomain.setSendNumFlag(false);
                if (null != hashMap && null != hashMap.get("money") && !"".equals(hashMap.get("money"))) {
                    Object money = hashMap.get("money");
                    sgGoodsNumDomain.setContractSgSenPaygmoney(new BigDecimal(money.toString()));
                }
                if (null == goods.getGoodsCweight()) {
                    goods.setGoodsOneweight(BigDecimal.ZERO);
                }
                sgGoodsNumDomain.setContractGoodsSgSendweight(goods.getGoodsWeight());
                sgGoodsNumDomain.setContractSgSendnum(new BigDecimal(crpRechargeDomain.getRechargeName7()));
                sgGoodsNumDomain.setContractSgSendweight(new BigDecimal(crpRechargeDomain.getRechargeName6()));
                if ("10".equals(crpRechargeDomain.getRechargeName2())) {
                    sgGoodsNumDomain.setContractGoodsSgSendnum(BigDecimal.ZERO);
                    sgGoodsNumDomain.setContractSgSendnum(BigDecimal.ZERO);
                    sgGoodsNumDomain.setContractSgSendweight(BigDecimal.ZERO);
                    sgGoodsNumDomain.setContractGoodsSgSendweight(BigDecimal.ZERO);
                }
                sgGoodsNumDomains.add(sgGoodsNumDomain);
            }
        }
        map.clear();
        map.put("sgGoodsNumDomainList", JsonUtil.buildNormalBinder().toJson(sgGoodsNumDomains));
        this.getInternalRouter().inInvoke("oc.contract.updateContractPayAndSgContract", map);
        return "success";
    }

    public BigDecimal getCrpRechargeNowStarMoneyAll(String userinfoCode, String rechargeMode, String partnerCode, BigDecimal orderMoney, String tenantCode) {
        List<CrpRecharge> ordinaCrpList;
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        if (StringUtils.isBlank((String)rechargeMode)) {
            rechargeMode = "0";
        }
        if ("1".equals(rechargeMode)) {
            if (StringUtils.isBlank((String)partnerCode)) {
                return null;
            }
        } else {
            partnerCode = null;
        }
        ArrayList<CrpRecharge> relist = new ArrayList<CrpRecharge>();
        List<CrpRecharge> proRelist = this.getCrpRechargeNowStar(userinfoCode, rechargeMode, partnerCode, tenantCode, null);
        if (ListUtil.isNotEmpty(proRelist)) {
            relist.addAll(proRelist);
        }
        if (StringUtils.isNotBlank((String)partnerCode) && ListUtil.isNotEmpty(ordinaCrpList = this.getCrpRechargeNowStar(userinfoCode, "0", null, tenantCode, null))) {
            relist.addAll(ordinaCrpList);
        }
        if (ListUtil.isEmpty(relist)) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.getCrpRechargeNowStarByOrder.relist", (Object)(userinfoCode + "=" + rechargeMode + "=" + tenantCode));
            return null;
        }
        this.logger.error("service.crp.CrpRechargeServiceImplgetCrpRechargeNowStarByOrder.relists", (Object)JsonUtil.buildNormalBinder().toJson(relist));
        BigDecimal tMoney = orderMoney;
        BigDecimal decimalMoney = BigDecimal.ZERO;
        int i = 0;
        for (CrpRecharge recharge : relist) {
            BigDecimal userMoney = BigDecimal.ZERO;
            if (EmptyUtil.isEmpty((Object)recharge.getRechargeMoney())) {
                recharge.setRechargeMoney(BigDecimal.ZERO);
            }
            if (EmptyUtil.isEmpty((Object)recharge.getRechargeUmoney())) {
                recharge.setRechargeUmoney(BigDecimal.ZERO);
            }
            if (recharge.getRechargeMoney().subtract(recharge.getRechargeUmoney()).compareTo(BigDecimal.ZERO) <= 0) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.updateAllCrpRechargeList.crpRecharges", (Object)("recharge:" + JsonUtil.buildNonNullBinder().toJson((Object)recharge) + "userinfoCode:" + userinfoCode + "=" + rechargeMode + "=" + tenantCode));
                continue;
            }
            if (tMoney.compareTo(BigDecimal.ZERO) == 0) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.updateAllCrpRechargeList.tMoney", (Object)("recharge:" + JsonUtil.buildNonNullBinder().toJson((Object)recharge) + "tMoney:" + tMoney));
                break;
            }
            ++i;
            BigDecimal crpAllMoney = recharge.getRechargeMoney().subtract(recharge.getRechargeUmoney());
            if ("0".equals(recharge.getRechargeName5()) || "1".equals(recharge.getRechargeMode())) {
                if (crpAllMoney.compareTo(tMoney) >= 0) {
                    userMoney = tMoney;
                    decimalMoney = decimalMoney.add(tMoney);
                    tMoney = tMoney.subtract(tMoney);
                } else {
                    userMoney = crpAllMoney;
                    decimalMoney = decimalMoney.add(crpAllMoney);
                    tMoney = tMoney.subtract(crpAllMoney);
                }
            } else if (crpAllMoney.compareTo(tMoney = tMoney.multiply(new BigDecimal("0.5"))) >= 0) {
                userMoney = tMoney;
                decimalMoney = decimalMoney.add(tMoney);
            } else {
                userMoney = crpAllMoney;
                decimalMoney = decimalMoney.add(crpAllMoney);
                tMoney = tMoney.add(tMoney.subtract(crpAllMoney));
            }
            this.logger.error("service.crp.CrpRechargeServiceImpl.getCrpRechargeNowStarMoneyAll.", (Object)("userMoney:" + userMoney + "tMoney:" + tMoney + "decimalMoney:" + decimalMoney));
        }
        return decimalMoney;
    }

    @Override
    public BigDecimal getCrpRechargeNowStarByOrder(String userinfoCode, String rechargeMode, BigDecimal orderMoney, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        return this.getCrpRechargeNowStarMoneyAll(userinfoCode, "0", null, orderMoney, tenantCode);
    }

    @Override
    public BigDecimal getCrpRechargeNowStarByOrderAll(String userinfoCode, String rechargeMode, String partnerCode, BigDecimal orderMoney, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)partnerCode)) {
            return null;
        }
        return this.getCrpRechargeNowStarMoneyAll(userinfoCode, rechargeMode, partnerCode, orderMoney, tenantCode);
    }

    public List<CrpRecharge> getCrpRechargeNowStar(String userinfoCode, String rechargeMode, String partnerCode, String tenantCode, String refundFlag) {
        QueryResult<CrpRecharge> queryResult;
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        if (StringUtils.isBlank((String)rechargeMode)) {
            rechargeMode = "0";
        }
        if ("1".equals(rechargeMode) && StringUtils.isBlank((String)partnerCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rechargeMode", rechargeMode);
        map.put("userinfoCode", userinfoCode);
        map.put("partnerCode", partnerCode);
        map.put("rechargeState", CrpConstants.RECHARGE_STATE_0);
        map.put("rechargeType", "0");
        map.put("rechargeName10", "0");
        map.put("dataState", 2);
        Date vf = new Date();
        String nowStr = DateUtil.getDateString((Date)vf, (String)"yyyy-MM-dd");
        Date da = DateUtil.getDateToString((String)nowStr, (String)"yyyy-MM-dd");
        map.put("rechargeStartQend", da);
        map.put("rechargeEndQstart", da);
        map.put("order", true);
        map.put("orderStr", "RECHARGE_START asc ,RECHARGE_ID asc");
        if (StringUtils.isNotBlank((String)refundFlag)) {
            map.put("orderStr", "RECHARGE_END desc ,RECHARGE_ID desc");
        }
        if (null == (queryResult = this.queryCrpPage(map)) || ListUtil.isEmpty((Collection)queryResult.getList())) {
            return null;
        }
        return queryResult.getList();
    }

    @Override
    public CrpRecharge getCrpRechargeNowStar(String userinfoCode, String rechargeMode, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        return this.getCrpRechargeNowStarAll(userinfoCode, "0", null, tenantCode);
    }

    @Override
    public CrpRecharge getCrpRechargeNowStarAll(String userinfoCode, String rechargeMode, String partnerCode, String tenantCode) {
        List<CrpRecharge> relist;
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        if (StringUtils.isBlank((String)rechargeMode)) {
            rechargeMode = StringUtils.isBlank((String)partnerCode) ? "0" : "1";
        }
        if ("1".equals(rechargeMode)) {
            if (StringUtils.isBlank((String)partnerCode)) {
                return null;
            }
        } else {
            partnerCode = null;
        }
        if (ListUtil.isEmpty(relist = this.getCrpRechargeNowStar(userinfoCode, rechargeMode, partnerCode, tenantCode, null))) {
            return null;
        }
        for (CrpRecharge crpRecharge : relist) {
            if (null == crpRecharge.getRechargeMoney()) {
                crpRecharge.setRechargeMoney(BigDecimal.ZERO);
            }
            if (null == crpRecharge.getRechargeUmoney()) {
                crpRecharge.setRechargeUmoney(BigDecimal.ZERO);
            }
            if (crpRecharge.getRechargeMoney().subtract(crpRecharge.getRechargeUmoney()).compareTo(BigDecimal.ZERO) <= 0) continue;
            return crpRecharge;
        }
        return null;
    }

    @Override
    public List<CrpRecharge> getCrpRechargeNowStarAllNew(String userinfoCode, String rechargeMode, String partnerCode, String tenantCode, String refundFlag) {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        if (StringUtils.isBlank((String)rechargeMode)) {
            rechargeMode = StringUtils.isBlank((String)partnerCode) ? "0" : "1";
        }
        if ("1".equals(rechargeMode)) {
            if (StringUtils.isBlank((String)partnerCode)) {
                return null;
            }
        } else {
            partnerCode = null;
        }
        List<CrpRecharge> relist = this.getCrpRechargeNowStar(userinfoCode, rechargeMode, partnerCode, tenantCode, refundFlag);
        return relist;
    }

    @Override
    public synchronized String updateCrpRechargeOuntByOrder(CrpRechargeDomain crpRechargeDomain) throws ApiException {
        if (null == crpRechargeDomain) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeOuntByOrder.crpRechargeDomain");
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", crpRechargeDomain.getTenantCode());
        map.put("rechargeType", "0");
        map.put("userinfoCode", crpRechargeDomain.getUserinfoCode());
        map.put("rechargeState", CrpConstants.RECHARGE_STATE_0);
        map.put("rechargeName7", "1");
        map.put("dataState", 2);
        map.put("rechargeName3Str", "date");
        Integer i = 0;
        Boolean flag = true;
        BigDecimal money = BigDecimal.ZERO;
        BigDecimal upMoney = BigDecimal.ZERO;
        CrpRecharge crpRecharge = null;
        CrpUrecharge crpUrecharge = null;
        CrpUrechargelist crpUrechargelistCopy = new CrpUrechargelist();
        String name10 = crpRechargeDomain.getRechargeName10();
        QueryResult<CrpRecharge> queryResult = this.queryCrpPage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeOuntByOrder.queryResult1", map);
            map.put("rechargeType", "1");
            queryResult = this.queryCrpPage(map);
        }
        if (StringUtils.isBlank((String)crpRechargeDomain.getRechargeName10())) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeOuntByOrder.remainAmount", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)crpRechargeDomain));
            return "error";
        }
        HashMap<String, Object> crpMap = new HashMap<String, Object>();
        money = new BigDecimal(crpRechargeDomain.getRechargeName10());
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            if ("ocContract".equals(crpRechargeDomain.getRechargeRemark())) {
                money = money.multiply(new BigDecimal(0.3)).setScale(2, 4);
            }
            crpRechargeDomain.setRechargeName10(money.toString());
            String dataMoney = this.updateCrpVdable(crpRechargeDomain, null);
            if ("error".equals(dataMoney) || "success".equals(dataMoney)) {
                this.logger.error("service.crp.CrpRechargeServiceImpl..updateCrpRechargeOuntByOrder.dataMoney", (Object)dataMoney);
                return dataMoney;
            }
            if ("ocContract".equals(crpRechargeDomain.getRechargeRemark())) {
                this.logger.error("service.crp.CrpRechargeServiceImpl..updateCrpRechargeOuntByOrder.ocContract.dataMoney", (Object)dataMoney);
                this.updateOccontractAndSg(crpRechargeDomain, dataMoney);
                return "error";
            }
            if ("sgSendgoods".equals(crpRechargeDomain.getRechargeRemark())) {
                this.updateOccontractAndSg(crpRechargeDomain, dataMoney);
                return "error";
            }
        } else {
            BigDecimal availableCredit = BigDecimal.ZERO;
            crpRecharge = (CrpRecharge)queryResult.getList().get(0);
            this.logger.info("crpRecharge=======", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpRecharge));
            HashMap<String, Object> lockMap = new HashMap<String, Object>();
            lockMap.put("tenantCode", crpRecharge.getTenantCode());
            lockMap.put("rechargeId", crpRecharge.getRechargeId());
            HashMap<String, Object> crp = new HashMap<String, Object>();
            crp.put("tenantCode", crpRecharge.getTenantCode());
            crp.put("rechargeType", crpRecharge.getRechargeType());
            crp.put("userinfoCode", crpRecharge.getUserinfoCode());
            QueryResult<CrpUrecharge> urechargePage = this.crpUrechargeService.queryCrpUrechargePage(crp);
            if (null == urechargePage || ListUtil.isEmpty((Collection)urechargePage.getList())) {
                throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.urechargePage", JsonUtil.buildNonNullBinder().toJson(crpMap));
            }
            this.lockRechargesData(lockMap);
            crp.clear();
            crpUrecharge = (CrpUrecharge)urechargePage.getList().get(0);
            crp.put("tenantCode", crpUrecharge.getTenantCode());
            crp.put("urechargeId", crpUrecharge.getUrechargeId());
            crpUrecharge = this.crpUrechargeService.getCrpUrecharge(crpUrecharge.getUrechargeId());
            crpRecharge = this.getCrpRecharge(crpRecharge.getRechargeId());
            if (null == crpRecharge) {
                this.logger.error("service.crp.CrpRechargeServiceImpl..updateCrpRechargeOuntByOrder.lockMap", lockMap);
                return "error";
            }
            if ("ocContract".equals(crpRechargeDomain.getRechargeRemark())) {
                money = money.multiply(new BigDecimal(0.3)).setScale(2, 4);
            }
            this.logger.error("money------", (Object)money);
            if ("0".equals(crpRecharge.getRechargeType())) {
                String tran = this.makeCrpMoney(crpUrechargelistCopy, crpRecharge, crpRechargeDomain, money, availableCredit, upMoney);
                if ("success".equals(tran) || "error".equals(tran)) {
                    this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeOuntByOrder.tran", (Object)tran);
                    return tran;
                }
            } else if (!"1".equals(crpRecharge.getRechargeType())) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeOuntByOrder.rechargeType", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)crpRecharge));
                return "error";
            }
        }
        crpMap.put("tenantCode", crpRecharge.getTenantCode());
        crpMap.put("rechargeUrl4", crpRecharge.getRechargeUrl4());
        crpMap.put("rechargeAmoney", crpRecharge.getRechargeAmoney());
        crpMap.put("rechargeCode", crpRecharge.getRechargeCode());
        crpMap.put("gmtModified", crpRecharge.getGmtModified());
        crpMap.put("type", "1");
        this.logger.error("crpMap=====", (Object)JsonUtil.buildNonNullBinder().toJson(crpMap));
        this.updateStateByCodeAndModified(crpMap);
        map.clear();
        map.put("crpUrechargelistCopy", crpUrechargelistCopy);
        crpUrechargelistCopy.setRechargeName10(name10);
        map.put("crpRechargeDomain", crpRechargeDomain);
        map.put("crpUrechargelist", crpRecharge);
        map.put("crpUrecharge", crpUrecharge);
        this.crpUrechargeService.updateCrpUrechargesToOrder(map);
        return "success";
    }

    public String makeCrpMoney(CrpUrechargelist crpUrechargelistCopy, CrpRecharge recharge, CrpRechargeDomain crpRechargeDomain, BigDecimal money, BigDecimal availableCredit, BigDecimal upMoney) {
        if (EmptyUtil.isEmpty((Object)recharge.getRechargeAmoney()) || recharge.getRechargeAmoney().compareTo(BigDecimal.ZERO) < 0) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.rechargeSmoney", JsonUtil.buildNonNullBinder().toJson((Object)recharge));
        }
        this.logger.error("CrpRecharge----", (Object)JsonUtil.buildNonNullBinder().toJson((Object)recharge));
        this.logger.error("crpRechargeDomain----", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain));
        this.logger.error("money----", (Object)JsonUtil.buildNonNullBinder().toJson((Object)money));
        if (recharge.getRechargeAmoney().compareTo(BigDecimal.ZERO) > 0) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.makeCrpMoney", (Object)recharge.getRechargeAmoney());
            availableCredit = recharge.getRechargeAmoney();
            BigDecimal supMoney = BigDecimal.ZERO;
            BigDecimal sMoney = BigDecimal.ZERO;
            if ("0".equals(recharge.getRechargeName5())) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.rechargeName5", (Object)recharge.getRechargeName5());
                if (availableCredit.compareTo(money) >= 0) {
                    this.logger.error("service.crp.CrpRechargeServiceImpl.availableCredit.money", (Object)(availableCredit + "," + money));
                    upMoney = availableCredit.subtract(money);
                    supMoney = money;
                    sMoney = recharge.getRechargeAmoney();
                    recharge.setRechargeAmoney(money);
                    HashMap<String, Object> stringObjectMap = new HashMap<String, Object>();
                    stringObjectMap.put("money", money);
                    crpRechargeDomain.setRechargeName10("0");
                    String data = this.updateCrpVdable(crpRechargeDomain, stringObjectMap);
                    if ("error".equals(data)) {
                        this.logger.info("service.crp.CrpRechargeServiceImpl.availableCredit.money.data", (Object)(JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain) + "," + stringObjectMap));
                        return "error";
                    }
                } else {
                    this.logger.error("service.crp.CrpRechargeServiceImpl.availableCredit.money1", (Object)(availableCredit + "," + money));
                    BigDecimal available = money.subtract(availableCredit);
                    sMoney = recharge.getRechargeAmoney();
                    recharge.setRechargeAmoney(availableCredit);
                    supMoney = availableCredit;
                    HashMap<String, Object> stringObjectMap = new HashMap<String, Object>();
                    stringObjectMap.put("money", money);
                    crpRechargeDomain.setRechargeName10(available.toString());
                    String data = this.updateCrpVdable(crpRechargeDomain, stringObjectMap);
                    if ("error".equals(data)) {
                        this.logger.error("service.crp.CrpRechargeServiceImpl.availableCredit.money1.data", (Object)(JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain) + "," + stringObjectMap));
                        return "error";
                    }
                    if (!"error".equals(data) && !"success".equals(data)) {
                        if ("ocContract".equals(crpRechargeDomain.getRechargeRemark())) {
                            this.logger.error("service.crp.CrpRechargeServiceImpl..updateCrpRechargeOuntByOrder.ocContract.dataMoney5", (Object)data);
                            this.updateOccontractAndSg(crpRechargeDomain, data);
                            return "error";
                        }
                        if ("sgSendgoods".equals(crpRechargeDomain.getRechargeRemark())) {
                            this.logger.error("service.crp.CrpRechargeServiceImpl..updateCrpRechargeOuntByOrder.sgSendgoods.dataMoney3", (Object)data);
                            this.updateOccontractAndSg(crpRechargeDomain, data);
                            return "error";
                        }
                    }
                }
            } else if ("1".equals(recharge.getRechargeName5())) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.rechargeName5.1", (Object)recharge.getRechargeName5());
                BigDecimal amountMoney = BigDecimal.ZERO;
                BigDecimal crpMoney = BigDecimal.ZERO;
                crpMoney = money.divide(new BigDecimal(2));
                if (availableCredit.compareTo(crpMoney) >= 0) {
                    this.logger.error("service.crp.CrpRechargeServiceImpl.rechargeName5.1.availableCredit", (Object)(availableCredit + "," + crpMoney));
                    upMoney = availableCredit.subtract(crpMoney);
                    supMoney = crpMoney;
                    sMoney = recharge.getRechargeAmoney();
                    recharge.setRechargeAmoney(crpMoney);
                    HashMap<String, Object> stringObjectMap = new HashMap<String, Object>();
                    stringObjectMap.put("money", money);
                    crpRechargeDomain.setRechargeName10(crpMoney.toString());
                    String data = this.updateCrpVdable(crpRechargeDomain, stringObjectMap);
                    if ("error".equals(data)) {
                        this.logger.info("service.crp.CrpRechargeServiceImpl.rechargeName5.1.availableCredit.data", (Object)(JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain) + "," + stringObjectMap));
                        return "error";
                    }
                    if (!"error".equals(data) && !"success".equals(data)) {
                        if ("ocContract".equals(crpRechargeDomain.getRechargeRemark())) {
                            this.logger.error("service.crp.CrpRechargeServiceImpl..updateCrpRechargeOuntByOrder..rechargeName5.1.dataMoney5", (Object)data);
                            this.updateOccontractAndSg(crpRechargeDomain, data);
                            return "error";
                        }
                        if ("sgSendgoods".equals(crpRechargeDomain.getRechargeRemark())) {
                            this.logger.error("service.crp.CrpRechargeServiceImpl..updateCrpRechargeOuntByOrder..rechargeName5.1.dataMoney3", (Object)data);
                            this.updateOccontractAndSg(crpRechargeDomain, data);
                            return "error";
                        }
                    }
                } else {
                    this.logger.error("service.crp.CrpRechargeServiceImpl.rechargeName5.1.available", (Object)(availableCredit + "," + crpMoney));
                    amountMoney = crpMoney.add(crpMoney.subtract(availableCredit));
                    supMoney = availableCredit;
                    sMoney = recharge.getRechargeAmoney();
                    recharge.setRechargeAmoney(availableCredit);
                    HashMap<String, Object> stringObjectMap = new HashMap<String, Object>();
                    stringObjectMap.put("money", money);
                    crpRechargeDomain.setRechargeName10(amountMoney.toString());
                    this.logger.error("crpRechargeDomain===1", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain));
                    this.logger.error("stringObjectMap===1", (Object)JsonUtil.buildNonNullBinder().toJson(stringObjectMap));
                    String data = this.updateCrpVdable(crpRechargeDomain, stringObjectMap);
                    if ("error".equals(data)) {
                        this.logger.error("service.crp.CrpRechargeServiceImpl.rechargeName5.1.available.data", (Object)(JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain) + "," + stringObjectMap));
                        return "error";
                    }
                    if (!"error".equals(data) && !"success".equals(data)) {
                        if ("ocContract".equals(crpRechargeDomain.getRechargeRemark())) {
                            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeOuntByOrder.available1.dataMoney5", (Object)data);
                            this.updateOccontractAndSg(crpRechargeDomain, data);
                            return "error";
                        }
                        if ("sgSendgoods".equals(crpRechargeDomain.getRechargeRemark())) {
                            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeOuntByOrder.rechargeName5.dataMoney8", (Object)data);
                            this.updateOccontractAndSg(crpRechargeDomain, data);
                            return "error";
                        }
                    }
                }
            }
            try {
                String cds;
                String field;
                BeanUtils.copyAllPropertysNotNull((Object)crpUrechargelistCopy, (Object)recharge);
                crpUrechargelistCopy.setRechargeName8(recharge.getRechargeId().toString());
                crpUrechargelistCopy.setRechargeUrl4(supMoney.toString());
                crpUrechargelistCopy.setRechargeSmoney(upMoney);
                crpUrechargelistCopy.setUrechargelistDir("1");
                crpUrechargelistCopy.setRechargeUrl1(crpRechargeDomain.getRechargeRemark());
                crpUrechargelistCopy.setRechargeUrl2(sMoney.toString());
                crpUrechargelistCopy.setRechargeAllmoney(recharge.getRechargeMoney());
                crpUrechargelistCopy.setRechargeUrl3(crpRechargeDomain.getRechargeOpcode());
                if (StringUtils.isNotBlank((String)crpRechargeDomain.getRechargeName8())) {
                    crpUrechargelistCopy.setRechargeName9(crpRechargeDomain.getRechargeName8());
                }
                if ("ocContract".equals(crpRechargeDomain.getRechargeRemark())) {
                    field = crpRechargeDomain.getTenantCode().concat("-").concat("2-creat_type_two");
                    cds = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
                    crpUrechargelistCopy.setBankcodeName(cds);
                    crpUrechargelistCopy.setRechargeName9(null);
                } else if ("sgSendgoods".equals(crpRechargeDomain.getRechargeRemark())) {
                    field = crpRechargeDomain.getTenantCode().concat("-").concat("4-creat_type_fou");
                    cds = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
                    crpUrechargelistCopy.setBankcodeName(cds);
                }
                crpUrechargelistCopy.setUrechargelistId(null);
                crpUrechargelistCopy.setUrechargelistCode(null);
                crpUrechargelistCopy.setGmtCreate(null);
                crpUrechargelistCopy.setGmtModified(null);
                crpUrechargelistCopy.setRechargeType("8");
                this.logger.error("crpUrechargelistCopy=====", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpUrechargelistCopy));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            crpRechargeDomain.setRechargeName10(money.toString());
            String data = this.updateCrpVdable(crpRechargeDomain, null);
            if ("error".equals(data)) {
                this.logger.info("service.crp.CrpRechargeServiceImpl.rechargeName5.1.available.data5", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain));
                return "error";
            }
            if (!"error".equals(data) && !"success".equals(data)) {
                if ("ocContract".equals(crpRechargeDomain.getRechargeRemark())) {
                    this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeOuntByOrder.available1.dataMoney5", (Object)data);
                    this.updateOccontractAndSg(crpRechargeDomain, data);
                    return "error";
                }
                if ("sgSendgoods".equals(crpRechargeDomain.getRechargeRemark())) {
                    this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeOuntByOrder.rechargeName5.dataMoney8", (Object)data);
                    this.updateOccontractAndSg(crpRechargeDomain, data);
                    return "error";
                }
            }
            return "success";
        }
        return "data";
    }

    @Override
    public void updateCrpRechargeAndList(CrpRechargeReDomain crpRechargeReDomain) throws ApiException {
        String msg = this.checkCrp(crpRechargeReDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrp.checkCrp", msg);
        }
        CrpRecharge crpRecharges = this.makeCrp(crpRechargeReDomain, null);
        HashMap<String, Object> crp = new HashMap<String, Object>();
        crp.put("tenantCode", crpRecharges.getTenantCode());
        crp.put("rechargeId", crpRecharges.getRechargeId());
        this.lockRechargesData(crp);
        crpRecharges.getRechargeAmoney();
        BigDecimal uMoney = crpRecharges.getRechargeAmoney().multiply(new BigDecimal("-1"));
        HashMap<String, Object> crpMap = new HashMap<String, Object>();
        crpMap.put("tenantCode", crpRecharges.getTenantCode());
        crpMap.put("rechargeMoney", uMoney);
        crpMap.put("rechargeCode", crpRecharges.getRechargeCode());
        crpMap.put("type", "1");
        this.updateStateByCodeAndModified(crpMap);
    }

    public String updateOccontractAndSg(CrpRechargeDomain crpRechargeDomain, String objMoney) throws ApiException {
        HashMap<String, String> sendMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<SgGoodsNumDomain> sgGoodsNumDomains = new ArrayList<SgGoodsNumDomain>();
        if ("ocContract".equals(crpRechargeDomain.getRechargeRemark())) {
            map.put("contractBillcode", crpRechargeDomain.getRechargeOpcode());
            map.put("tenantCode", crpRechargeDomain.getTenantCode());
            sendMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
            String obj = (String)this.getInternalRouter().inInvoke("oc.contract.getContractByCode", sendMap);
            OcContractDomain ocContractDomain = (OcContractDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(obj, OcContractDomain.class);
            if (null == ocContractDomain || ListUtil.isEmpty(ocContractDomain.getGoodsList())) {
                throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpVdable.ocContractGoodsList.null", JsonUtil.buildNonNullBinder().toJson(sendMap));
            }
            SgGoodsNumDomain sgGoodsNumDomain = new SgGoodsNumDomain();
            sgGoodsNumDomain.setContractBillcode(ocContractDomain.getContractBillcode());
            sgGoodsNumDomain.setTenantCode(ocContractDomain.getTenantCode());
            sgGoodsNumDomain.setContractFlag(true);
            sgGoodsNumDomain.setMschannelCode(objMoney);
            sgGoodsNumDomains.add(sgGoodsNumDomain);
        } else if ("sgSendgoods".equals(crpRechargeDomain.getRechargeRemark())) {
            map = new HashMap();
            map.put("sendgoodsCode", crpRechargeDomain.getRechargeName8());
            map.put("tenantCode", crpRechargeDomain.getTenantCode());
            sendMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
            QueryResult sendgoodsGoodsQueryResult = this.getQueryResutl("sg.sendgoods.querySendgoodsGoodsPage", sendMap, SgSendgoodsGoods.class);
            if (null == sendgoodsGoodsQueryResult || ListUtil.isEmpty((Collection)sendgoodsGoodsQueryResult.getList())) {
                throw new ApiException("service.crp.CrpRechargeServiceImpl.updateOccontractAndSg.sendgoodsGoodsQueryResult.null", JsonUtil.buildNonNullBinder().toJson(sendMap));
            }
            for (SgSendgoodsGoods goods : sendgoodsGoodsQueryResult.getList()) {
                SgGoodsNumDomain sgGoodsNumDomain = new SgGoodsNumDomain();
                sgGoodsNumDomain.setContractBillcode(goods.getContractBillcode());
                sgGoodsNumDomain.setContractGoodsCode(goods.getContractGoodsCode());
                sgGoodsNumDomain.setTenantCode(goods.getTenantCode());
                sgGoodsNumDomain.setContractSgSenPaygmoney(BigDecimal.ZERO);
                if (null == goods.getGoodsCweight()) {
                    goods.setGoodsOneweight(BigDecimal.ZERO);
                }
                if (StringUtils.isBlank((String)crpRechargeDomain.getRechargeName6())) {
                    sgGoodsNumDomain.setContractSgSendweight(BigDecimal.ZERO);
                }
                sgGoodsNumDomain.setContractGoodsSgSendweight(goods.getGoodsWeight());
                sgGoodsNumDomain.setContractSgSendnum(new BigDecimal(crpRechargeDomain.getRechargeName7()));
                if ("10".equals(crpRechargeDomain.getRechargeName2())) {
                    sgGoodsNumDomain.setContractGoodsSgSendnum(BigDecimal.ZERO);
                    sgGoodsNumDomain.setContractSgSendnum(BigDecimal.ZERO);
                    sgGoodsNumDomain.setContractSgSendweight(BigDecimal.ZERO);
                    sgGoodsNumDomain.setContractGoodsSgSendweight(BigDecimal.ZERO);
                }
                sgGoodsNumDomains.add(sgGoodsNumDomain);
            }
            SgSendgoodsDomain sgSendgoodsDomain = new SgSendgoodsDomain();
            sgSendgoodsDomain.setSendgoodsCode(((SgSendgoodsGoods)sendgoodsGoodsQueryResult.getList().get(0)).getSendgoodsCode());
            sgSendgoodsDomain.setTenantCode(((SgSendgoodsGoods)sendgoodsGoodsQueryResult.getList().get(0)).getTenantCode());
            sgSendgoodsDomain.setContractBillcode(((SgSendgoodsGoods)sendgoodsGoodsQueryResult.getList().get(0)).getContractBillcode());
            sgSendgoodsDomain.setMschannelCode(objMoney);
            sendMap.clear();
            sendMap.put("sgSendgoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
            this.logger.error("sgSendgoodsDomain=====", sendMap);
            this.getInternalRouter().inInvoke("sg.sendgoods.updateSendgoods", sendMap);
        }
        map.clear();
        map.put("sgGoodsNumDomainList", JsonUtil.buildNormalBinder().toJson(sgGoodsNumDomains));
        this.logger.info("service.crp.CrpRechargeServiceImpl.updateOccontractAndSg.map---3", (Object)JsonUtil.buildNonNullBinder().toJson(map));
        this.getInternalRouter().inInvoke("oc.contract.updateContractPayAndSgContract", map);
        return "error";
    }

    @Override
    public void updateCrpRechargeArrears(String tenantCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dataState", 2);
        map.put("rechargeStateStr", "-1,0");
        map.put("rechargeName4Str", "date");
        this.logger.info("service.crp.CrpRechargeServiceImpl.updateCrpRechargeArrears.map", map);
        List<CrpRecharge> gropRechargeList = this.queryRechargeGroup(map);
        List<CrpRecharge> crpRechargeList = this.queryCrpModelPage(map);
        if (ListUtil.isNotEmpty(crpRechargeList)) {
            for (CrpRecharge crp : crpRechargeList) {
                if (EmptyUtil.isEmpty((Object)crp.getRechargeAmoney())) {
                    crp.setRechargeAmoney(BigDecimal.ZERO);
                }
                if (EmptyUtil.isEmpty((Object)crp.getRechargeMoney())) {
                    crp.setRechargeAmoney(BigDecimal.ZERO);
                }
                CrpRecharge crpRecharge = new CrpRecharge();
                crpRecharge.setRechargeCode(crp.getRechargeCode());
                crpRecharge.setTenantCode(crp.getTenantCode());
                BigDecimal sMoney = crp.getRechargeMoney().subtract(crp.getRechargeAmoney());
                this.logger.info("service.crp.CrpRechargeServiceImpl.updateCrpRechargeArrears.sMoney===", (Object)sMoney);
                crpRecharge.setRechargeName8(sMoney.toString());
                crpRecharge.setRechargeState(3);
                crpRecharge.setRechargeUrl4("1");
                crpRecharge.setRechargeId(crp.getRechargeId());
                this.setCrpDefault(crpRecharge);
                this.updateByPrimaryKeyModel(crpRecharge);
            }
        }
        if (ListUtil.isNotEmpty(gropRechargeList)) {
            for (CrpRecharge recharge : gropRechargeList) {
                if (StringUtils.isBlank((String)recharge.getRechargeName8())) {
                    this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeArrears.recharge", (Object)JsonUtil.buildNonNullBinder().toJson((Object)recharge));
                    continue;
                }
                BigDecimal money = new BigDecimal(recharge.getRechargeName8());
                if (money.compareTo(BigDecimal.ZERO) < 0) {
                    this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeArrears.money", (Object)JsonUtil.buildNonNullBinder().toJson((Object)recharge));
                    continue;
                }
                HashMap<String, Object> uMap = new HashMap<String, Object>();
                uMap.put("userinfoCode", recharge.getUserinfoCode());
                uMap.put("tenantCode", recharge.getTenantCode());
                uMap.put("rechargeType", recharge.getRechargeType());
                QueryResult<CrpUrecharge> queryResult = this.crpUrechargeService.queryCrpUrechargePage(uMap);
                if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
                    this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeArrears.queryResult", (Object)JsonUtil.buildNonNullBinder().toJson((Object)recharge));
                    continue;
                }
                uMap.clear();
                CrpUrecharge crpUrecharge = (CrpUrecharge)queryResult.getList().get(0);
                uMap.put("tenantCode", crpUrecharge.getTenantCode());
                uMap.put("urechargeCode", crpUrecharge.getUrechargeCode());
                if (StringUtils.isBlank((String)crpUrecharge.getRechargeUrl3())) {
                    uMap.put("rechargeUrl3", recharge.getRechargeName8());
                } else {
                    BigDecimal uMoney = new BigDecimal(crpUrecharge.getRechargeUrl3());
                    BigDecimal nMoney = new BigDecimal(recharge.getRechargeName8());
                    BigDecimal ulMoney = uMoney.add(nMoney).setScale(3, 1);
                    uMap.put("rechargeUrl3", ulMoney.toString());
                }
                this.crpUrechargeService.updateUlmoneyByCode(uMap);
            }
        }
    }

    @Override
    public Map<String, Object> updateCrpRechargeByOrder(CrpRechargeDomain crpRechargeDomain) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", crpRechargeDomain.getTenantCode());
        map.put("rechargeMode", "0");
        map.put("userinfoCode", crpRechargeDomain.getUserinfoCode());
        map.put("rechargeState", CrpConstants.RECHARGE_STATE_0);
        map.put("rechargeType", "0");
        map.put("dataState", 2);
        Date vf = new Date();
        String nowStr = DateUtil.getDateString((Date)vf, (String)"yyyy-MM-dd");
        Date da = DateUtil.getDateToString((String)nowStr, (String)"yyyy-MM-dd");
        map.put("rechargeStartQend", da);
        map.put("rechargeEndQstart", da);
        map.put("rechargeName10", "0");
        BigDecimal money = BigDecimal.ZERO;
        BigDecimal upMoney = BigDecimal.ZERO;
        CrpRecharge crpRecharge = null;
        this.logger.error("crpRechargeDomain-----1", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain));
        QueryResult<CrpRecharge> queryResult = this.queryCrpPage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeOuntByOrder.queryResult1", map);
            map.put("rechargeMode", "1");
            queryResult = this.queryCrpPage(map);
        }
        this.logger.error("queryResult=======", (Object)JsonUtil.buildNonNullBinder().toJson(queryResult));
        if (StringUtils.isBlank((String)crpRechargeDomain.getRechargeName10())) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeOuntByOrder.remainAmount", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)crpRechargeDomain));
            return null;
        }
        money = new BigDecimal(crpRechargeDomain.getRechargeName10());
        HashMap<String, Object> moneyMap = new HashMap<String, Object>();
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            if ("ocContract".equals(crpRechargeDomain.getRechargeRemark())) {
                money = money.multiply(new BigDecimal(0.3)).setScale(2, 4);
            }
            crpRechargeDomain.setRechargeName10(money.toString());
            this.updateCrpVdableStr(crpRechargeDomain, moneyMap);
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeByOrder.moneyMap7", (Object)(JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain) + "," + moneyMap));
            return moneyMap;
        }
        BigDecimal availableCredit = BigDecimal.ZERO;
        crpRecharge = (CrpRecharge)queryResult.getList().get(0);
        if ("ocContract".equals(crpRechargeDomain.getRechargeRemark())) {
            money = money.multiply(new BigDecimal(0.3)).setScale(2, 4);
        }
        this.logger.error("money------", (Object)money);
        if ("0".equals(crpRecharge.getRechargeMode())) {
            this.makeCrpMoneyStr(crpRecharge, crpRechargeDomain, money, availableCredit, upMoney, moneyMap);
            return moneyMap;
        }
        if (!"1".equals(crpRecharge.getRechargeType())) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeOuntByOrder.rechargeType", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)crpRecharge));
            return null;
        }
        return null;
    }

    public String updateCrpVdableStr(CrpRechargeDomain crpRechargeDomain, Map<String, Object> hashMap) throws ApiException {
        HashMap<String, String> sendMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        sendMap.put("merchantCode", crpRechargeDomain.getUserinfoCode());
        sendMap.put("faccountType", "101");
        sendMap.put("tenantCode", crpRechargeDomain.getTenantCode());
        map.put("map", JsonUtil.buildNonNullBinder().toJson(sendMap));
        QueryResult queryResutl = this.getQueryResutl("vd.faccountOuter.queryFaccountOuterPageNew", map, VdFaccountOuter.class);
        if (EmptyUtil.isEmpty((Object)queryResutl) || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            throw new ApiException("service.crp.CrpRechargeServiceImplupdateCrpVdableStr.updateCrpRechargeDeail.null", ((Object)map).toString());
        }
        if (StringUtils.isBlank((String)crpRechargeDomain.getRechargeName10())) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpVdableStr.rechargeName10", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain));
            return "error";
        }
        VdFaccountOuter vdFaccountOuter = (VdFaccountOuter)queryResutl.getList().get(0);
        sendMap.clear();
        map.clear();
        sendMap.put("faccountOuterNo", vdFaccountOuter.getFaccountOuterNo());
        sendMap.put("tenantCode", vdFaccountOuter.getTenantCode());
        sendMap.put("fundType", "01");
        map.put("map", JsonUtil.buildNormalBinder().toJson(sendMap));
        QueryResult sendgoodsGoodsQuery = this.getQueryResutl("vd.faccountOuter.queryFaccountOuterSubsetPage", map, VdFaccountOuterSubset.class);
        VdFaccountOuterSubset vdFaccountOuterSubset = (VdFaccountOuterSubset)sendgoodsGoodsQuery.getList().get(0);
        BigDecimal faccountAmount = vdFaccountOuterSubset.getFaccountAmount();
        if (null == faccountAmount || "".equals(faccountAmount)) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpVdableStr.faccountAmount", (Object)JsonUtil.buildNonNullBinder().toJson((Object)vdFaccountOuter));
            return "error";
        }
        BigDecimal consMoney = new BigDecimal(crpRechargeDomain.getRechargeName10());
        if (consMoney.compareTo(BigDecimal.ZERO) > 0) {
            if (faccountAmount.compareTo(consMoney) < 0) {
                BigDecimal smoney = consMoney.subtract(faccountAmount);
                hashMap.put("smoney", smoney);
                this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpVdableStr.smoney", (Object)("consMoney:" + consMoney + ",faccountAmount:" + faccountAmount));
                return "error";
            }
            hashMap.put("consMoney", consMoney);
        }
        return "success";
    }

    public String makeCrpMoneyStr(CrpRecharge recharge, CrpRechargeDomain crpRechargeDomain, BigDecimal money, BigDecimal availableCredit, BigDecimal upMoney, Map<String, Object> moneyMap) {
        BigDecimal buMoney;
        if (EmptyUtil.isEmpty((Object)recharge.getRechargeAmoney()) || recharge.getRechargeAmoney().compareTo(BigDecimal.ZERO) < 0) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpRechargeDeail.rechargeSmoney", JsonUtil.buildNonNullBinder().toJson((Object)recharge));
        }
        this.logger.error("makeCrpMoneyStr.CrpRecharge----", (Object)JsonUtil.buildNonNullBinder().toJson((Object)recharge));
        this.logger.error("makeCrpMoneyStr.crpRechargeDomain----", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain));
        this.logger.error("makeCrpMoneyStr.money----", (Object)JsonUtil.buildNonNullBinder().toJson((Object)money));
        if (EmptyUtil.isEmpty((Object)recharge.getRechargeUmoney())) {
            recharge.setRechargeUmoney(BigDecimal.ZERO);
        }
        if (EmptyUtil.isEmpty((Object)recharge.getRechargeBmoney())) {
            recharge.setRechargeBmoney(BigDecimal.ZERO);
        }
        if ((buMoney = recharge.getRechargeAmoney().subtract(recharge.getRechargeUmoney())).compareTo(BigDecimal.ZERO) > 0) {
            this.logger.error("service.crp.CrpRechargeServiceImplmakeCrpMoneyStr.makeCrpMoney", (Object)recharge.getRechargeAmoney());
            availableCredit = buMoney;
            BigDecimal supMoney = BigDecimal.ZERO;
            BigDecimal sMoney = BigDecimal.ZERO;
            if ("0".equals(recharge.getRechargeName5())) {
                this.logger.error("service.crp.CrpRechargeServiceImplmakeCrpMoneyStr.rechargeName5", (Object)recharge.getRechargeName5());
                if (availableCredit.compareTo(money) >= 0) {
                    moneyMap.put("crpMoney", money);
                    this.logger.error("makeCrpMoneyStr.moneyMap====0", (Object)("crpRechargeDomain:" + JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain) + "moneyMap:" + JsonUtil.buildNonNullBinder().toJson(moneyMap)));
                    return "success";
                }
                this.logger.error("service.crp.CrpRechargeServiceImplmakeCrpMoneyStr.availableCredit.money1", (Object)(availableCredit + "," + money));
                BigDecimal available = money.subtract(availableCredit);
                moneyMap.put("crpMoney", availableCredit);
                recharge.setRechargeAmoney(availableCredit);
                crpRechargeDomain.setRechargeName10(available.toString());
                this.updateCrpVdableStr(crpRechargeDomain, moneyMap);
                this.logger.error("makeCrpMoneyStr.moneyMap====1", (Object)("crpRechargeDomain:" + JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain) + "moneyMap:" + JsonUtil.buildNonNullBinder().toJson(moneyMap)));
                return "success";
            }
            if ("1".equals(recharge.getRechargeName5())) {
                this.logger.error("service.crp.CrpRechargeServiceImplmakeCrpMoneyStr.rechargeName5.1", (Object)recharge.getRechargeName5());
                BigDecimal amountMoney = BigDecimal.ZERO;
                BigDecimal crpMoney = BigDecimal.ZERO;
                crpMoney = money.divide(new BigDecimal(2));
                if (availableCredit.compareTo(crpMoney) >= 0) {
                    this.logger.error("service.crp.CrpRechargeServiceImplmakeCrpMoneyStr.rechargeName5.1.availableCredit", (Object)(availableCredit + "," + crpMoney));
                    upMoney = availableCredit.subtract(crpMoney);
                    moneyMap.put("crpMoney", crpMoney);
                    recharge.setRechargeAmoney(crpMoney);
                    crpRechargeDomain.setRechargeName10(crpMoney.toString());
                    this.updateCrpVdableStr(crpRechargeDomain, moneyMap);
                    this.logger.error("makeCrpMoneyStr.moneyMap====2", (Object)("crpRechargeDomain:" + JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain) + "moneyMap:" + JsonUtil.buildNonNullBinder().toJson(moneyMap)));
                    return "success";
                }
                this.logger.error("service.crp.CrpRechargeServiceImplmakeCrpMoneyStr.rechargeName5.1.available", (Object)(availableCredit + "," + crpMoney));
                moneyMap.put("crpMoney", availableCredit);
                amountMoney = crpMoney.add(crpMoney.subtract(availableCredit));
                HashMap<String, BigDecimal> stringObjectMap = new HashMap<String, BigDecimal>();
                stringObjectMap.put("money", money);
                crpRechargeDomain.setRechargeName10(amountMoney.toString());
                this.updateCrpVdableStr(crpRechargeDomain, moneyMap);
                this.logger.error("makeCrpMoneyStr.moneyMap====4", (Object)("crpRechargeDomain:" + JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain) + "moneyMap:" + JsonUtil.buildNonNullBinder().toJson(moneyMap)));
                return "success";
            }
        } else {
            crpRechargeDomain.setRechargeName10(money.toString());
            this.updateCrpVdableStr(crpRechargeDomain, moneyMap);
            this.logger.error("makeCrpMoneyStr.moneyMap====4", (Object)("crpRechargeDomain:" + JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain) + "moneyMap:" + JsonUtil.buildNonNullBinder().toJson(moneyMap)));
            return "success";
        }
        return "success";
    }

    @Override
    public List<CrpChannelsend> updateCrpRechargeDeailStr(CrpRechargeDomain crpRechargeDomain) throws ApiException {
        if (null == crpRechargeDomain || StringUtils.isBlank((String)crpRechargeDomain.getRechargeName10())) {
            this.logger.error("makeCrpMoneyStr.updateCrpRechargeDeailStr", (Object)("crpRechargeDomain:" + JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain)));
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", crpRechargeDomain.getTenantCode());
        map.put("userinfoCode", crpRechargeDomain.getUserinfoCode());
        map.put("rechargeCode", crpRechargeDomain.getRechargeCode());
        map.put("rechargeState", CrpConstants.RECHARGE_STATE_0);
        map.put("rechargeName7", "1");
        map.put("dataState", 2);
        map.put("rechargeName3Str", "date");
        QueryResult<CrpRecharge> queryResult = this.queryCrpPage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("makeCrpMoneyStr.updateCrpRechargeDeailStr.queryResult", (Object)JsonUtil.buildNonNullBinder().toJson(map));
            return null;
        }
        BigDecimal aMoney = new BigDecimal(crpRechargeDomain.getRechargeName10());
        CrpRecharge crpRecharge = (CrpRecharge)queryResult.getList().get(0);
        BigDecimal smoney = crpRecharge.getRechargeAmoney().subtract(aMoney);
        if (smoney.compareTo(BigDecimal.ZERO) < 0) {
            this.logger.error("service.crp.CrpRechargeServiceImplmakeCrpMoneyStr.updateCrpRechargeDeailStr.queryResult", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpRecharge));
            return null;
        }
        map.clear();
        map.put("tenantCode", crpRecharge.getTenantCode());
        map.put("rechargeAmoney", aMoney);
        map.put("rechargeCode", crpRecharge.getRechargeCode());
        map.put("type", "1");
        this.logger.error("crpMap=====", (Object)JsonUtil.buildNonNullBinder().toJson(map));
        this.updateStateByCodeAndModified(map);
        CrpUrechargelistDomain crpUrechargelistDomain = new CrpUrechargelistDomain();
        try {
            String field;
            BeanUtils.copyAllPropertysNotNull((Object)crpUrechargelistDomain, (Object)crpRecharge);
            crpUrechargelistDomain.setRechargeName8(crpRecharge.getRechargeId().toString());
            crpUrechargelistDomain.setRechargeUrl4(aMoney.toString());
            crpUrechargelistDomain.setRechargeSmoney(smoney);
            crpUrechargelistDomain.setUrechargelistDir("1");
            crpUrechargelistDomain.setRechargeUrl1(crpRechargeDomain.getRechargeRemark());
            crpUrechargelistDomain.setRechargeUrl2(crpRecharge.getRechargeAmoney().toString());
            crpUrechargelistDomain.setRechargeAllmoney(crpRecharge.getRechargeMoney());
            crpUrechargelistDomain.setRechargeUrl3(crpRechargeDomain.getRechargeOpcode());
            if (StringUtils.isNotBlank((String)crpRechargeDomain.getRechargeName8())) {
                crpUrechargelistDomain.setRechargeName9(crpRechargeDomain.getRechargeName8());
            }
            if ("ocContract".equals(crpRechargeDomain.getRechargeRemark())) {
                field = crpRechargeDomain.getTenantCode().concat("-").concat("2-creat_type_two");
                String cds = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
                crpUrechargelistDomain.setBankcodeName(cds);
                crpUrechargelistDomain.setRechargeName9(null);
            } else if ("sgSendgoods".equals(crpRechargeDomain.getRechargeRemark())) {
                field = crpRechargeDomain.getTenantCode().concat("-").concat("4-creat_type_fou");
                String cds = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
                crpUrechargelistDomain.setBankcodeName(cds);
            }
            crpUrechargelistDomain.setRechargeType("8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        crpUrechargelistDomain.setRechargeOpno2(crpRecharge.getRechargeType());
        List<CrpChannelsend> channelsends = this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelistDomain);
        this.crpUrechargeService.saveOrUpdateCrpUrecharge(crpUrechargelistDomain);
        return channelsends;
    }

    @Override
    public List<CrpChannelsend> updateCrpUrechargeByCp(CrpRechargeDomain crpRechargeDomain) throws ApiException {
        if (null == crpRechargeDomain) {
            return null;
        }
        if (!"1".equals(crpRechargeDomain.getRechargeType())) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByCp.", "\u7c7b\u578b\u9519\u8bef");
        }
        List<CrpChannelsend> relist = this.saveCrpRechargeRe(crpRechargeDomain);
        List<CrpChannelsend> relist1 = this.updateCrpRechargeStateByCode(crpRechargeDomain.getTenantCode(), crpRechargeDomain.getRechargeCode(), 2, null, null);
        if (null == relist) {
            relist = new ArrayList<CrpChannelsend>();
        }
        if (ListUtil.isNotEmpty(relist1)) {
            relist.addAll(relist1);
        }
        return relist;
    }

    @Override
    public List<CrpChannelsend> updateCrpUrechargeByOut(CrpRechargeDomain crpRechargeDomain) throws ApiException {
        if (null == crpRechargeDomain) {
            return null;
        }
        if (!"2".equals(crpRechargeDomain.getRechargeType())) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByCp.", "\u7c7b\u578b\u9519\u8bef");
        }
        List<CrpChannelsend> relist = this.saveCrpRechargeRe(crpRechargeDomain);
        return relist;
    }

    @Override
    public List<CrpChannelsend> updateCrpUrechargeByAutomatic(CrpRecharge crpRecharge, Map<String, Object> map) throws ApiException {
        if (null == crpRecharge) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomatic.crpRecharge");
            return null;
        }
        if (!"1".equals(crpRecharge.getRechargeType())) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomatic.", "\u7c7b\u578b\u9519\u8bef");
        }
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        objectMap.put("tenantCode", crpRecharge.getTenantCode());
        objectMap.put("rechargeMoney", crpRecharge.getRechargeMoney());
        objectMap.put("rechargeCode", crpRecharge.getRechargeCode());
        objectMap.put("type", "2");
        this.updateStateByCodeAndModified(objectMap);
        CrpRecharge recharge = this.getCrpRecharge(crpRecharge.getRechargeId());
        if (null == recharge) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomatic.recharge", "recharge:" + JsonUtil.getNotDefJsonUtil().toJson((Object)crpRecharge));
        }
        CrpUrechargelistDomain crpUrechargelistDomain = new CrpUrechargelistDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crpUrechargelistDomain, (Object)crpRecharge);
            crpUrechargelistDomain.setRechargeType("1");
            crpUrechargelistDomain.setUrechargelistDir("0");
            crpUrechargelistDomain.setRechargeEnd(null);
            crpUrechargelistDomain.setRechargeStart(null);
            crpUrechargelistDomain.setRechargeName9(null);
            crpUrechargelistDomain.setRechargeName10("0");
            String field = crpRecharge.getTenantCode().concat("-").concat("1-fund_type_one");
            String cds = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
            crpUrechargelistDomain.setBankcodeName(cds);
            crpUrechargelistDomain.setRechargeSmoney(crpRecharge.getRechargeMoney());
            if (EmptyUtil.isEmpty((Object)recharge.getRechargeUmoney())) {
                recharge.setRechargeUmoney(BigDecimal.ZERO);
            }
            if (EmptyUtil.isEmpty((Object)recharge.getRechargeBmoney())) {
                recharge.setRechargeBmoney(BigDecimal.ZERO);
            }
            crpUrechargelistDomain.setRechargeAllmoney(recharge.getRechargeUmoney().subtract(recharge.getRechargeBmoney()));
            crpUrechargelistDomain.setRechargeName8(crpRecharge.getRechargeId().toString());
            if (StringUtils.isBlank((String)crpUrechargelistDomain.getUrechargelistCode())) {
                crpUrechargelistDomain.setUrechargelistCode(this.getNo(null, "CrpUrechargelist", "crpUrechargelist", crpUrechargelistDomain.getTenantCode()));
            }
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("tenantCode", crpRecharge.getTenantCode());
            map1.put("userinfoCode", crpRecharge.getUserinfoCode());
            QueryResult<CrpUrecharge> queryResult = this.crpUrechargeService.queryCrpUrechargePage(map1);
            if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeEndToTime.queryResult", (Object)JsonUtil.buildNonNullBinder().toJson(map1));
                throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomatic.queryResult", "\u6570\u636e\u9519\u8bef");
            }
            BigDecimal amountArrears = BigDecimal.ZERO;
            for (CrpUrecharge crp : queryResult.getList()) {
                if (EmptyUtil.isEmpty((Object)crp.getRechargeUmoney())) {
                    crp.setRechargeUmoney(BigDecimal.ZERO);
                }
                if (EmptyUtil.isEmpty((Object)crp.getRechargeUmoney())) {
                    crp.setRechargeUmoney(BigDecimal.ZERO);
                }
                amountArrears = amountArrears.add(crp.getRechargeUmoney().subtract(crp.getRechargeBmoney()));
            }
            if (amountArrears.compareTo(crpUrechargelistDomain.getRechargeSmoney()) < 0) {
                throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomatic.amountArrears", "amountArrears:" + amountArrears + "rechargeSmoney:" + crpUrechargelistDomain.getRechargeSmoney());
            }
            crpUrechargelistDomain.setRechargeAllmoney(amountArrears.subtract(crpUrechargelistDomain.getRechargeSmoney()));
            crpUrechargelistDomain.setRechargeUrl3(crpUrechargelistDomain.getUrechargelistCode());
            if (MapUtil.isNotEmpty(map) && !EmptyUtil.isEmpty((Object)map.get("rechargeOpcodeStr"))) {
                crpUrechargelistDomain.setRechargeOpcode(map.get("rechargeOpcodeStr").toString());
            }
            if (MapUtil.isNotEmpty(map) && !EmptyUtil.isEmpty((Object)map.get("refundCode"))) {
                crpUrechargelistDomain.setRechargeUrl3(map.get("refundCode").toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<CrpChannelsend> channelsends = this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelistDomain);
        this.crpUrechargeService.saveOrUpdateCrpUrecharge(crpUrechargelistDomain);
        return channelsends;
    }

    @Override
    public String updateCrpUrechargeByAutomaticVd(List<CrpRecharge> crpRechargeList, Map<String, Object> map) throws ApiException {
        if (ListUtil.isEmpty(crpRechargeList) || MapUtil.isEmpty(map)) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomatics.crpRechargeList");
            return null;
        }
        CrpRecharge crpRecha = crpRechargeList.get(0);
        BigDecimal rmoney = BigDecimal.ZERO;
        BigDecimal allMoney = BigDecimal.ZERO;
        VdFaccountInfo vdFaccountInfo = this.getVd("01", crpRecha.getUserinfoCode(), crpRecha.getTenantCode());
        if (null == vdFaccountInfo || EmptyUtil.isEmpty((Object)vdFaccountInfo.getFaccountAmount())) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.loadSendUrechargeBaseToTime.vdFaccountInfo", (Object)("userinfoCode:" + crpRecha.getUserinfoCode() + "vdFaccountInfo:" + JsonUtil.buildNonDefaultBinder().toJson((Object)vdFaccountInfo)));
            return null;
        }
        this.logger.error("vdFaccountInfo===", (Object)JsonUtil.buildNormalBinder().toJson((Object)vdFaccountInfo));
        BigDecimal vdMoney = vdFaccountInfo.getFaccountAmount();
        if (vdMoney.compareTo(BigDecimal.ZERO) == 0) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.loadSendUrechargeBaseToTime.vdMoney", (Object)("userinfoCode:" + crpRecha.getUserinfoCode()));
            return null;
        }
        String memberName = "";
        BigDecimal vdCumulaMoney = vdMoney;
        for (CrpRecharge crpRecharge : crpRechargeList) {
            BigDecimal stilMoney = BigDecimal.ZERO;
            if (null == crpRecharge.getRechargeUmoney()) {
                crpRecharge.setRechargeUmoney(BigDecimal.ZERO);
            }
            if (null == crpRecharge.getRechargeBmoney()) {
                crpRecharge.setRechargeBmoney(BigDecimal.ZERO);
            }
            if ((rmoney = crpRecharge.getRechargeUmoney().subtract(crpRecharge.getRechargeBmoney())).compareTo(BigDecimal.ZERO) <= 0) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomaticVd.rmoney", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpRecharge));
                continue;
            }
            if (vdCumulaMoney.compareTo(rmoney) >= 0) {
                vdCumulaMoney = vdCumulaMoney.subtract(rmoney);
                stilMoney = rmoney;
            } else {
                stilMoney = vdCumulaMoney;
                vdCumulaMoney = BigDecimal.ZERO;
            }
            allMoney = allMoney.add(stilMoney);
            crpRecharge.setRechargeMoney(stilMoney);
            crpRecharge.setRechargeType("1");
            this.updateCrpUrechargeByAutomatic(crpRecharge, null);
            memberName = crpRecharge.getRechargeName2();
            if (vdCumulaMoney.compareTo(BigDecimal.ZERO) != 0) continue;
            this.logger.error("service.crp.CrpRechargeServiceImpl.loadSendUrechargeBaseToTime.crpRecharge", (Object)("userinfoCode:" + crpRecharge.getUserinfoCode() + "vdMoney:" + vdCumulaMoney + "allMoney:" + allMoney));
            break;
        }
        if (allMoney.compareTo(BigDecimal.ZERO) <= 0) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.loadSendUrechargeBaseToTime.allMoney", (Object)("userinfoCode:" + crpRecha.getUserinfoCode() + "vdMoney:" + vdCumulaMoney + "allMoney:" + allMoney));
            return null;
        }
        String facoun = this.makeVdFamount(allMoney, vdFaccountInfo, memberName, map);
        if (!"success".equals(facoun)) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomatic.facoun");
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomatic.channelMap", "\u8d26\u6237\u4fe1\u606f\u5f02\u5e38");
        }
        return "success";
    }

    @Override
    public String updateCrpUrechargeByAutomaticVdDms(List<CrpRecharge> crpRechargeList, Map<String, Object> map) throws ApiException {
        if (ListUtil.isEmpty(crpRechargeList) || MapUtil.isEmpty(map)) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomaticVdDms.crpRechargeList", (Object)("crpRechargeList:" + JsonUtil.buildNonDefaultBinder().toJson(crpRechargeList) + "map:" + JsonUtil.buildNonNullBinder().toJson(map)));
            return null;
        }
        BigDecimal allVdCrpMoney = BigDecimal.ZERO;
        if ("dms".equals(map.get("refundType"))) {
            Object vdCrpMoney = map.get("VdCrpMoney");
            if (EmptyUtil.isEmpty((Object)vdCrpMoney)) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomaticVdDms.vdCrpMoney", (Object)("crpRechargeList:" + JsonUtil.buildNonDefaultBinder().toJson(crpRechargeList) + "map:" + JsonUtil.buildNonNullBinder().toJson(map)));
                return null;
            }
            allVdCrpMoney = new BigDecimal(vdCrpMoney.toString());
        }
        if (allVdCrpMoney.compareTo(BigDecimal.ZERO) <= 0) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomaticVdDms.crpRechargeList", (Object)("crpRechargeList:" + JsonUtil.buildNonDefaultBinder().toJson(crpRechargeList) + "map:" + JsonUtil.buildNonNullBinder().toJson(map)));
            return null;
        }
        CrpRecharge crpRecha = crpRechargeList.get(0);
        BigDecimal rmoney = BigDecimal.ZERO;
        BigDecimal allMoney = BigDecimal.ZERO;
        BigDecimal vdMoney = allVdCrpMoney;
        if (vdMoney.compareTo(BigDecimal.ZERO) == 0) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomaticVdDms.vdMoney", (Object)("userinfoCode:" + crpRecha.getUserinfoCode()));
            return null;
        }
        BigDecimal vdCumulaMoney = vdMoney;
        for (CrpRecharge crpRecharge : crpRechargeList) {
            BigDecimal stilMoney = BigDecimal.ZERO;
            if (null == crpRecharge.getRechargeUmoney()) {
                crpRecharge.setRechargeUmoney(BigDecimal.ZERO);
            }
            if (null == crpRecharge.getRechargeBmoney()) {
                crpRecharge.setRechargeBmoney(BigDecimal.ZERO);
            }
            if ((rmoney = crpRecharge.getRechargeUmoney().subtract(crpRecharge.getRechargeBmoney())).compareTo(BigDecimal.ZERO) <= 0) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomaticVdDms.rmoney", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpRecharge));
                continue;
            }
            if (vdCumulaMoney.compareTo(rmoney) >= 0) {
                vdCumulaMoney = vdCumulaMoney.subtract(rmoney);
                stilMoney = rmoney;
            } else {
                stilMoney = vdCumulaMoney;
                vdCumulaMoney = BigDecimal.ZERO;
            }
            allMoney = allMoney.add(stilMoney);
            crpRecharge.setRechargeMoney(stilMoney);
            crpRecharge.setRechargeType("1");
            List<CrpChannelsend> crpChannelsends = this.updateCrpUrechargeByAutomatic(crpRecharge, map);
            if (ListUtil.isEmpty(crpChannelsends)) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomatic.facoun", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpRecharge));
                throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomatic.channelMap", "\u8fd4\u56de\u4fe1\u606f\u5f02\u5e38");
            }
            if (vdCumulaMoney.compareTo(BigDecimal.ZERO) != 0) continue;
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomaticVdDms.crpRecharge", (Object)("userinfoCode:" + crpRecharge.getUserinfoCode() + "vdMoney:" + vdCumulaMoney + "allMoney:" + allMoney));
            break;
        }
        if (allMoney.compareTo(BigDecimal.ZERO) <= 0) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomaticVdDms.allMoney", (Object)("userinfoCode:" + crpRecha.getUserinfoCode() + "vdMoney:" + vdCumulaMoney + "allMoney:" + allMoney));
            return null;
        }
        return vdCumulaMoney.toPlainString();
    }

    private String makeVdFamount(BigDecimal allMoney, VdFaccountInfo vdFaccountInfo, String memberName, Map<String, Object> map) {
        BigDecimal bigDecimal = allMoney;
        bigDecimal = bigDecimal.negate();
        CpRechargeDomain cpRechargeDomain = new CpRechargeDomain();
        cpRechargeDomain.setTenantCode(vdFaccountInfo.getTenantCode());
        cpRechargeDomain.setUserinfoCode(vdFaccountInfo.getMerchantCode());
        cpRechargeDomain.setFaccountId(vdFaccountInfo.getFaccountOuterNo());
        cpRechargeDomain.setUserbankNo(vdFaccountInfo.getFaccountOuterNo());
        cpRechargeDomain.setUserinfoName(memberName);
        cpRechargeDomain.setBankcodeName("\u81ea\u52a8\u8fd8\u6b3e");
        cpRechargeDomain.setRechargeType("02");
        cpRechargeDomain.setUserCode(vdFaccountInfo.getMerchantCode());
        cpRechargeDomain.setUserName(memberName);
        cpRechargeDomain.setRechargeMoney(bigDecimal);
        cpRechargeDomain.setFchannelCode(map.get("refundType").toString());
        cpRechargeDomain.setDataState(2);
        cpRechargeDomain.setRechargeCategory(cpRechargeDomain.getUserinfoCode().substring(0, 1));
        cpRechargeDomain.setRechargeMode("1");
        cpRechargeDomain.setFchannelPmodeCode("web");
        CpRechargeDomain cpRechargeDomainNew = new CpRechargeDomain();
        Map<String, PtePtfchannelReDomain> channelMap = this.queryChannel("web", vdFaccountInfo.getTenantCode(), "IN");
        if (null == channelMap || channelMap.isEmpty()) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomatic.makeVdFamount.channelMap");
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomatic.channelMap", "\u8d26\u6237\u4fe1\u606f\u5f02\u5e38");
        }
        PtePtfchannelReDomain ptePtfchannelReDomain = channelMap.get("ctest");
        if (null == ptePtfchannelReDomain) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomatic.ptePtfchannelReDomain.channelMap", (Object)JsonUtil.buildNormalBinder().toJson(channelMap));
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomatic.ptePtfchannelReDomain", "\u8d26\u6237\u4fe1\u606f\u5f02\u5e38");
        }
        try {
            BeanUtils.copyAllPropertys((Object)cpRechargeDomainNew, (Object)ptePtfchannelReDomain);
            BeanUtils.copyAllPropertys((Object)cpRechargeDomainNew, (Object)cpRechargeDomain);
            cpRechargeDomain.setFchannelClassifyCode(ptePtfchannelReDomain.getFchannelType());
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.rechargeAccount==9", (Object)ptePtfchannelReDomain.toString());
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomatic.ptePtfchannelReDomain", (Throwable)e);
        }
        cpRechargeDomainNew.setGmtCreate(cpRechargeDomain.getGmtCreate());
        cpRechargeDomainNew.setDataState(cpRechargeDomain.getDataState());
        if (StringUtils.isBlank((String)cpRechargeDomainNew.getUserbankName())) {
            cpRechargeDomainNew.setUserbankName("\u57fa\u672c\u6237");
        }
        HashMap<String, Object> sendMap = new HashMap<String, Object>();
        sendMap.put("cpRechargeDomain", JsonUtil.buildNormalBinder().toJson((Object)cpRechargeDomainNew));
        String result = this.internalInvoke("cp.recharge.saveRecharge", sendMap);
        this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomatic==result", (Object)result);
        if (StringUtils.isBlank((String)result)) {
            this.logger.error("service.crp.CrpRechargeServiceImplupdateCrpUrechargeByAutomatic.result", (Object)ptePtfchannelReDomain.toString());
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomatic.result", "\u8fd8\u6b3e\u5931\u8d25");
        }
        sendMap = new HashMap();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("rechargeCode", result);
        paramMap.put("tenantCode", vdFaccountInfo.getTenantCode());
        sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        QueryResult getResult = this.getQueryResutl("cp.recharge.queryRechargePage", sendMap, CpRecharge.class);
        if (EmptyUtil.isEmpty((Object)getResult) || ListUtil.isEmpty((Collection)getResult.getList())) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomatic.getResult", (Object)ptePtfchannelReDomain.toString());
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByAutomatic.getResult", "\u8fd8\u6b3e\u5931\u8d25");
        }
        CpRecharge cpRecharge = (CpRecharge)getResult.getList().get(0);
        paramMap = new HashMap();
        sendMap = new HashMap();
        paramMap.put("wap_type", "web");
        sendMap.put("rechargeId", cpRecharge.getRechargeId());
        sendMap.put("dataState", 2);
        sendMap.put("oldDataState", 2);
        sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        this.internalInvoke("cp.recharge.updateRechargeState", sendMap);
        return "success";
    }

    public Map<String, PtePtfchannelReDomain> queryChannel(String fchannelPmodeCode, String tenantCode, String fchannelDr) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fchannelPmodeCode", fchannelPmodeCode);
        map.put("tenantCode", tenantCode);
        map.put("fchannelDr", fchannelDr);
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        String s = (String)this.getInternalRouter().inInvoke("pte.ptfchannel.queryPtfchannelReList", paramsMap);
        if (StringUtils.isBlank((String)s)) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.queryChannel==1", (Object)((Object)map).toString());
            return null;
        }
        List ptePtfchannelReDomains = JsonUtil.buildNormalBinder().getJsonToList(s, PtePtfchannelReDomain.class);
        if (ListUtil.isEmpty((Collection)ptePtfchannelReDomains)) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.queryChannel==2", (Object)s);
            return null;
        }
        if (null == ptePtfchannelReDomains || ptePtfchannelReDomains.isEmpty()) {
            return null;
        }
        HashMap<String, PtePtfchannelReDomain> channelmap = new HashMap<String, PtePtfchannelReDomain>();
        for (PtePtfchannelReDomain ptePtfchannelReDomain : ptePtfchannelReDomains) {
            channelmap.put(ptePtfchannelReDomain.getFchannelCode(), ptePtfchannelReDomain);
        }
        return channelmap;
    }

    private VdFaccountInfo getVd(String fundType, String memberBcode, String tenantCode) {
        if (StringUtils.isBlank((String)memberBcode) || StringUtils.isBlank((String)fundType) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String type = memberBcode.substring(0, 1);
        VdFaccountInfo vdFaccountInfo = this.getOuterFaccount(memberBcode, type + fundType, tenantCode);
        return vdFaccountInfo;
    }

    private VdFaccountInfo getOuterFaccount(String merchantCode, String faccountType, String tenantCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("merchantCode", merchantCode);
        pmap.put("faccountType", faccountType);
        pmap.put("tenantCode", tenantCode);
        List list = (List)this.readObj("vd.faccount.queryOuterFaccount", pmap, "list", new Object[]{VdFaccountInfo.class});
        if (ListUtil.isEmpty((Collection)list)) {
            return null;
        }
        return (VdFaccountInfo)list.get(0);
    }

    public List<CrpChannelsend> updateCrpUrechargeByCpOld(CpRechargeDomain cpRechargeDomain) throws ApiException {
        BigDecimal allMoney;
        if (null == cpRechargeDomain) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByCp.", "\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoCode", cpRechargeDomain.getUserinfoCode());
        map.put("tenantCode", cpRechargeDomain.getTenantCode());
        map.put("dataState", 2);
        map.put("rechargeState", 3);
        map.put("rechargeUrl4", "1");
        this.logger.info("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByCp.map", map);
        List<CrpRecharge> gropRechargeList = this.queryRechargeGroup(map);
        map.put("order", true);
        map.put("orderStr", "STR_TO_DATE(RECHARGE_NAME4,'%Y-%m-%d')  asc");
        List<CrpRecharge> crpRechargeList = this.queryCrpModelPage(map);
        map.clear();
        BigDecimal surpMoney = allMoney = cpRechargeDomain.getRechargeMoney();
        BigDecimal arrearMoney = BigDecimal.ZERO;
        ArrayList<CrpUrecharge> crpUrechargeList = new ArrayList<CrpUrecharge>();
        if (ListUtil.isNotEmpty(gropRechargeList) && ListUtil.isEmpty(crpRechargeList)) {
            for (CrpRecharge recharge : gropRechargeList) {
                BigDecimal urlmoney;
                HashMap uMap = new HashMap();
                uMap.put("userinfoCode", recharge.getUserinfoCode());
                uMap.put("tenantCode", recharge.getTenantCode());
                uMap.put("rechargeType", recharge.getRechargeType());
                QueryResult<CrpUrecharge> queryResult = this.crpUrechargeService.queryCrpUrechargePage(uMap);
                if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
                    this.logger.error(".updateCrpUrechargeByCp.queryResult", (Object)uMap);
                    throw new ApiException("service.crp.CrpRechargeServiceImplupdateCrpUrechargeByCp.queryResult", "\u53c2\u6570\u4e3a\u7a7a1");
                }
                CrpUrecharge crpUrecharge = (CrpUrecharge)queryResult.getList().get(0);
                if (StringUtils.isBlank((String)recharge.getRechargeName8()) && StringUtils.isBlank((String)crpUrecharge.getRechargeUrl4())) {
                    this.logger.error(".updateCrpUrechargeByCp.queryResult.crpUrecharge", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpUrecharge));
                    continue;
                }
                if (StringUtils.isBlank((String)recharge.getRechargeName8()) || StringUtils.isBlank((String)crpUrecharge.getRechargeUrl4())) {
                    this.logger.error(".updateCrpUrechargeByCp.queryResult", (Object)("rechargeName8:" + recharge.getRechargeName8() + "rechargeUrl4:" + crpUrecharge.getRechargeUrl4()));
                    throw new ApiException("service.crp.CrpRechargeServiceImplupdateCrpUrechargeByCp.rechargeName8", "\u53c2\u6570\u4e3a\u7a7a2");
                }
                BigDecimal money = new BigDecimal(recharge.getRechargeName8());
                if (money.compareTo(urlmoney = new BigDecimal(recharge.getRechargeUrl4())) != 0) {
                    this.logger.error(".updateCrpUrechargeByCp.money", (Object)("money:" + money + "urlmoney:" + urlmoney));
                    throw new ApiException("service.crp.CrpRechargeServiceImplupdateCrpUrechargeByCp.money", "\u6570\u636e\u9519\u8bef");
                }
                crpUrechargeList.add(crpUrecharge);
                arrearMoney = arrearMoney.add(money);
            }
            BigDecimal ordinaryMoney = BigDecimal.ZERO;
            BigDecimal temporaryMoney = BigDecimal.ZERO;
            for (CrpRecharge recharge : crpRechargeList) {
                BigDecimal nameMoney;
                if (StringUtils.isBlank((String)recharge.getRechargeName8())) {
                    this.logger.error(".updateCrpUrechargeByCp.recharge", (Object)JsonUtil.buildNonNullBinder().toJson((Object)recharge));
                    continue;
                }
                if (surpMoney.compareTo(BigDecimal.ZERO) <= 0) {
                    this.logger.error(".updateCrpUrechargeByCp.recharge", (Object)JsonUtil.buildNonNullBinder().toJson((Object)recharge));
                    break;
                }
                BigDecimal cMoney = new BigDecimal(recharge.getRechargeName8());
                CrpRecharge crpRecharge = new CrpRecharge();
                crpRecharge.setRechargeId(recharge.getRechargeId());
                crpRecharge.setRechargeCode(recharge.getRechargeCode());
                if ("0".equals(recharge.getRechargeMode())) {
                    if (surpMoney.compareTo(cMoney) >= 0) {
                        surpMoney = surpMoney.subtract(cMoney);
                        ordinaryMoney = ordinaryMoney.add(cMoney);
                        crpRecharge.setRechargeName8("0");
                        crpRecharge.setRechargeUrl4("2");
                    } else {
                        nameMoney = cMoney.subtract(surpMoney);
                        surpMoney = BigDecimal.ZERO;
                        ordinaryMoney = ordinaryMoney.add(surpMoney);
                        crpRecharge.setRechargeName8(nameMoney.toPlainString());
                    }
                } else if ("1".equals(recharge.getRechargeMode())) {
                    if (surpMoney.compareTo(cMoney) >= 0) {
                        surpMoney = surpMoney.subtract(cMoney);
                        temporaryMoney = temporaryMoney.add(cMoney);
                        crpRecharge.setRechargeName8("0");
                        crpRecharge.setRechargeUrl4("2");
                    } else {
                        nameMoney = cMoney.subtract(surpMoney);
                        surpMoney = BigDecimal.ZERO;
                        temporaryMoney = temporaryMoney.add(surpMoney);
                        crpRecharge.setRechargeName8(nameMoney.toPlainString());
                    }
                }
                this.setCrpDefault(crpRecharge);
                this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByCp.crpRecharge===", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpRecharge));
                this.updateByPrimaryKeyModel(crpRecharge);
            }
            BigDecimal useMoney = ordinaryMoney.add(temporaryMoney);
            CrpUrechargelistDomain crpUrechargelistDomain = new CrpUrechargelistDomain();
            crpUrechargelistDomain.setRechargeType("9");
            crpUrechargelistDomain.setTenantCode(cpRechargeDomain.getTenantCode());
            if (allMoney.compareTo(useMoney) > 0) {
                crpUrechargelistDomain.setRechargeAllmoney(useMoney);
                crpUrechargelistDomain.setRechargeSmoney(new BigDecimal(0));
            } else {
                crpUrechargelistDomain.setRechargeAllmoney(allMoney);
                crpUrechargelistDomain.setRechargeSmoney(arrearMoney.subtract(allMoney));
            }
            String field = cpRechargeDomain.getTenantCode().concat("-").concat("4-creat_type_fou");
            String cds = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
            crpUrechargelistDomain.setBankcodeName(cds);
            crpUrechargelistDomain.setUrechargelistDir("0");
            this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelistDomain);
            this.crpUrechargeService.saveOrUpdateCrpUrecharge(crpUrechargelistDomain);
            for (CrpUrecharge urecharge : crpUrechargeList) {
                if ("0".equals(urecharge.getRechargeType())) {
                    urecharge.setRechargeUrl3(ordinaryMoney.toPlainString());
                } else if ("1".equals(urecharge.getRechargeType())) {
                    urecharge.setRechargeUrl3(temporaryMoney.toPlainString());
                }
                this.crpUrechargeService.updateCrpUrechargemonery(urecharge);
            }
        }
        if (surpMoney.compareTo(BigDecimal.ZERO) > 0) {
            cpRechargeDomain.setRechargeMoney(surpMoney);
            HashMap<String, Object> sendMap = new HashMap<String, Object>();
            sendMap.put("cpRechargeDomain", JsonUtil.buildNormalBinder().toJson((Object)cpRechargeDomain));
            String result = this.internalInvoke("cp.recharge.saveRecharge", sendMap);
            this.logger.error("service.crp.CrpRechargeServiceImpl.rechargeAccount==result", (Object)result);
            if (StringUtils.isBlank((String)result)) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByCp.result==10", (Object)JsonUtil.buildNonNullBinder().toJson(sendMap));
                throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByCp.result", "\u5145\u503c\u5931\u8d25");
            }
            sendMap = new HashMap();
            map = new HashMap();
            map.put("rechargeCode", result);
            map.put("tenantCode", cpRechargeDomain.getTenantCode());
            sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
            QueryResult getResult = this.getQueryResutl("cp.recharge.queryRechargePage", sendMap, CpRecharge.class);
            if (EmptyUtil.isEmpty((Object)getResult) || ListUtil.isEmpty((Collection)getResult.getList())) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.getResult==10", (Object)JsonUtil.buildNonNullBinder().toJson(sendMap));
                throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrpUrechargeByCp.getResult", "\u5145\u503c\u5931\u8d25");
            }
            CpRecharge cpRecharge = (CpRecharge)getResult.getList().get(0);
            map = new HashMap();
            sendMap = new HashMap();
            map.put("wap_type", "web");
            sendMap.put("rechargeId", cpRecharge.getRechargeId());
            sendMap.put("dataState", 2);
            sendMap.put("oldDataState", 2);
            sendMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
            this.internalInvoke("cp.recharge.updateRechargeState", sendMap);
        }
        return null;
    }

    private List<CrpChannelsend> buildCrpByOc(List<CrpRecharge> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<CrpChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<CrpChannelsendDomain> disChannelsendDomainList = new ArrayList<CrpChannelsendDomain>();
        for (CrpRecharge promotion : pmPromotionList) {
            CrpChannelsendDomain pmChannelsendDomain = new CrpChannelsendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getRechargeOpcode());
            pmChannelsendDomain.setChannelsendType("sgSendgoods");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.crpChannelsendService.saveCrpBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    public Map<String, List<String>> makeOcAndSgMoney(String userinfoCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberBcode", userinfoCode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", 10);
        map.put("order", true);
        map.put("orderStr", "GMT_CREATE asc");
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult sendgoodsQuery = this.getQueryResutl("sg.sendgoods.querySendgoodsPage", sendMap, SgSendgoods.class);
        BigDecimal sgMoney = BigDecimal.ZERO;
        HashMap<String, List<String>> sgOcMap = new HashMap<String, List<String>>();
        ArrayList<String> sgList = new ArrayList<String>();
        if (null != sendgoodsQuery && ListUtil.isNotEmpty((Collection)sendgoodsQuery.getList())) {
            for (SgSendgoods sgSendgoods : sendgoodsQuery.getList()) {
                sgMoney = sgMoney.add(sgSendgoods.getDataBmoney());
                sgList.add(sgSendgoods.getSendgoodsCode());
            }
            CrpRechargeDomain crpRechargeDomain = new CrpRechargeDomain();
            crpRechargeDomain.setTenantCode(tenantCode);
            crpRechargeDomain.setRechargeName10(sgMoney.toPlainString());
            crpRechargeDomain.setUserinfoCode(userinfoCode);
            crpRechargeDomain.setRechargeRemark("sgSendgoods");
            Map<String, Object> map1 = this.updateCrpRechargeByOrder(crpRechargeDomain);
            if (MapUtil.isEmpty(map1)) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.map1==10", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain));
                throw new ApiException("service.crp.CrpRechargeServiceImpl.makeOcAndSgMoney.crpRechargeDomain", "check \u5931\u8d25");
            }
            String smoney = String.valueOf(map1.get("smoney"));
            if (StringUtils.isNotBlank((String)smoney)) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.smoney==10", (Object)JsonUtil.buildNonNullBinder().toJson(map1));
                return null;
            }
        }
        map.put("dataState", 17);
        this.logger.info("service.crp.CrpRechargeServiceImpl.sendMapDataState", sendMap);
        QueryResult domainQueryResult = this.getQueryResutl("oc.contract.queryContractPageReDomain", sendMap, OcContractReDomain.class);
        BigDecimal ocMoney = BigDecimal.ZERO;
        ArrayList<String> ocList = new ArrayList<String>();
        if (null != domainQueryResult && ListUtil.isNotEmpty((Collection)domainQueryResult.getList())) {
            for (OcContractReDomain ocContractReDomain : domainQueryResult.getList()) {
                ocMoney = ocMoney.add(ocContractReDomain.getDataBmoney());
                ocList.add(ocContractReDomain.getContractBillcode());
            }
        }
        if (ListUtil.isEmpty(sgList) && ListUtil.isNotEmpty(ocList)) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.ocList", (Object)JsonUtil.buildNonNullBinder().toJson(ocList));
            CrpRechargeDomain crpRechargeDomain = new CrpRechargeDomain();
            crpRechargeDomain.setTenantCode(tenantCode);
            crpRechargeDomain.setRechargeName10(ocMoney.toPlainString());
            crpRechargeDomain.setUserinfoCode(userinfoCode);
            crpRechargeDomain.setRechargeRemark("ocContract");
            Map<String, Object> map1 = this.updateCrpRechargeByOrder(crpRechargeDomain);
            if (MapUtil.isEmpty(map1)) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.map1==10", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain));
                throw new ApiException("service.crp.CrpRechargeServiceImpl.makeOcAndSgMoney.crpRechargeDomain", "check \u5931\u8d25");
            }
            String smoney = String.valueOf(map1.get("smoney"));
            if (StringUtils.isNotBlank((String)smoney)) {
                ocList.clear();
                this.logger.error("service.crp.CrpRechargeServiceImpl.smoney==10", (Object)JsonUtil.buildNonNullBinder().toJson(map1));
                return null;
            }
        } else if (ListUtil.isNotEmpty(sgList) && ListUtil.isNotEmpty(ocList)) {
            ocMoney = ocMoney.multiply(new BigDecimal(0.3)).setScale(2, 4);
            BigDecimal allMoney = ocMoney.add(sgMoney);
            this.logger.error("service.crp.CrpRechargeServiceImpl.ocList", (Object)JsonUtil.buildNonNullBinder().toJson((Object)allMoney));
            CrpRechargeDomain crpRechargeDomain = new CrpRechargeDomain();
            crpRechargeDomain.setTenantCode(tenantCode);
            crpRechargeDomain.setRechargeName10(allMoney.toPlainString());
            crpRechargeDomain.setUserinfoCode(userinfoCode);
            crpRechargeDomain.setRechargeRemark("sgOc");
            Map<String, Object> map1 = this.updateCrpRechargeByOrder(crpRechargeDomain);
            if (MapUtil.isEmpty(map1)) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.map1==10", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpRechargeDomain));
                throw new ApiException("service.crp.CrpRechargeServiceImpl.makeOcAndSgMoney.crpRechargeDomain", "check \u5931\u8d25");
            }
            String smoney = String.valueOf(map1.get("smoney"));
            if (StringUtils.isNotBlank((String)smoney)) {
                ocList.clear();
                this.logger.error("service.crp.CrpRechargeServiceImpl.smoney==10", (Object)JsonUtil.buildNonNullBinder().toJson(map1));
            }
        }
        if (ListUtil.isNotEmpty(ocList)) {
            sgOcMap.put("ocContract", ocList);
        }
        if (ListUtil.isNotEmpty(sgList)) {
            sgOcMap.put("sgSendgoods", sgList);
        }
        return sgOcMap;
    }

    private void backMoney(CrpUrechargelistDomain crpUrechargelistDomain) {
        if (null == crpUrechargelistDomain || null == crpUrechargelistDomain.getRechargeSmoney() || crpUrechargelistDomain.getRechargeSmoney().compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoCode", crpUrechargelistDomain.getUserinfoCode());
        map.put("tenantCode", crpUrechargelistDomain.getTenantCode());
        map.put("rechargeType", "0");
        map.put("money", "1");
        map.put("order", true);
        map.put("orderStr", "RECHARGE_END  asc, RECHARGE_ID asc");
        List<CrpRecharge> crpRechargeList = this.queryBmoneyModel(map);
        HashMap<String, Object> crpMap = new HashMap<String, Object>();
        BigDecimal money = crpUrechargelistDomain.getRechargeSmoney();
        for (CrpRecharge crpRecharge : crpRechargeList) {
            if (null == crpRecharge.getRechargeUmoney()) {
                crpRecharge.setRechargeUmoney(BigDecimal.ZERO);
            }
            if (null == crpRecharge.getRechargeBmoney()) {
                crpRecharge.setRechargeBmoney(BigDecimal.ZERO);
            }
            BigDecimal rmoney = crpRecharge.getRechargeUmoney().subtract(crpRecharge.getRechargeBmoney());
            BigDecimal brmoney = money;
            money = money.subtract(rmoney);
            crpMap.put("tenantCode", crpUrechargelistDomain.getTenantCode());
            crpMap.put("rechargeMoney", money.compareTo(BigDecimal.ZERO) >= 0 ? rmoney : brmoney);
            crpMap.put("rechargeCode", crpRecharge.getRechargeCode());
            crpMap.put("type", "2");
            this.updateStateByCodeAndModified(crpMap);
            if (money.compareTo(BigDecimal.ZERO) > 0) continue;
            break;
        }
    }

    @Override
    public List<CrpChannelsend> updateCrpRechargeList(CrpUrechargelistDomain crpUrechargelistDomain) throws ApiException {
        if (null == crpUrechargelistDomain) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeList.crpUrechargelistDomain", (Object)"crpUrechargelistDomain is null");
            return null;
        }
        if ("1".equals(crpUrechargelistDomain.getRechargeType()) || "2".equals(crpUrechargelistDomain.getRechargeType())) {
            this.backMoney(crpUrechargelistDomain);
        } else if ("1".equals(crpUrechargelistDomain.getUrechargelistDir())) {
            CrpRecharge crpRecharge = this.getCrpRechargeNowStarAll(crpUrechargelistDomain.getUserinfoCode(), null, crpUrechargelistDomain.getPartnerCode(), crpUrechargelistDomain.getTenantCode());
            if (null == crpRecharge) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeList.crpRecharge", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpUrechargelistDomain));
                return null;
            }
            HashMap<String, Object> crpMap = new HashMap<String, Object>();
            crpMap.put("tenantCode", crpRecharge.getTenantCode());
            crpMap.put("rechargeUrl4", crpUrechargelistDomain.getRechargeUrl4());
            crpMap.put("rechargeMoney", crpUrechargelistDomain.getRechargeSmoney());
            crpMap.put("rechargeCode", crpRecharge.getRechargeCode());
            crpMap.put("type", "1");
            this.updateStateByCodeAndModified(crpMap);
        }
        List<CrpChannelsend> channelsends = this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelistDomain);
        this.crpUrechargeService.saveOrUpdateCrpUrecharge(crpUrechargelistDomain);
        return channelsends;
    }

    @Override
    public List<CrpChannelsend> updateCrpRechargeListToMake(CrpUrechargelistDomain crpUrechargelistDomain) throws ApiException {
        String cds;
        String field;
        if (null == crpUrechargelistDomain) {
            return null;
        }
        CrpUrechargelistDomain copyRechargelistDomain = new CrpUrechargelistDomain();
        this.logger.error("service.crp.CrpRechargeServiceImplupdateCrpRechargeListToMake.crpUrechargelistDomain===", (Object)JsonUtil.buildNormalBinder().toJson((Object)crpUrechargelistDomain));
        CrpRecharge crpRecharge = this.getCrpRechargeNowStarAll(crpUrechargelistDomain.getUserinfoCode(), null, crpUrechargelistDomain.getPartnerCode(), crpUrechargelistDomain.getTenantCode());
        HashMap<String, Object> crpMap = new HashMap<String, Object>();
        crpMap.put("type", "1");
        if ("6".equals(crpUrechargelistDomain.getRechargeType()) || "9".equals(crpUrechargelistDomain.getRechargeType())) {
            HashMap<String, Object> crptoMap = new HashMap<String, Object>();
            crptoMap.put("tenantCode", crpUrechargelistDomain.getTenantCode());
            if ("6".equals(crpUrechargelistDomain.getRechargeType())) {
                crptoMap.put("rechargeUrl3", crpUrechargelistDomain.getRechargeOpno1());
                crptoMap.put("rechargeUrl1", "ocContract");
            } else if ("9".equals(crpUrechargelistDomain.getRechargeType())) {
                crptoMap.put("rechargeUrl1", "sgSendgoods");
                crptoMap.put("rechargeName9", crpUrechargelistDomain.getRechargeOpno1());
            }
            crptoMap.put("userinfoCode", crpUrechargelistDomain.getUserinfoCode());
            crptoMap.put("rechargeType", "8");
            QueryResult<CrpUrechargelist> urechargelistQuery = this.crpUrechargelistService.queryCrpUrechargelistPage(crptoMap);
            if (null == urechargelistQuery || ListUtil.isEmpty((Collection)urechargelistQuery.getList())) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeListToMake.urechargelistQuery", (Object)JsonUtil.buildNonNullBinder().toJson(crptoMap));
                return null;
            }
            CrpUrechargelist crpUrechargelist = (CrpUrechargelist)urechargelistQuery.getList().get(0);
            if (StringUtils.isBlank((String)crpUrechargelist.getRechargeName8())) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeListToMake.rechargeName8", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpUrechargelist));
                return null;
            }
            crptoMap.clear();
            crpMap.put("type", "52");
            crpRecharge = this.getCrpRecharge(Integer.valueOf(crpUrechargelist.getRechargeName8()));
        }
        if (null == crpRecharge) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeList.crpRecharge", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpUrechargelistDomain));
            return null;
        }
        crpMap.put("tenantCode", crpRecharge.getTenantCode());
        crpMap.put("rechargeMoney", crpUrechargelistDomain.getRechargeSmoney());
        crpMap.put("rechargeCode", crpRecharge.getRechargeCode());
        this.logger.error("crpMap===", (Object)JsonUtil.buildNormalBinder().toJson(crpMap));
        this.updateStateByCodeAndModified(crpMap);
        try {
            BeanUtils.copyAllPropertys((Object)copyRechargelistDomain, (Object)crpUrechargelistDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        copyRechargelistDomain.setRechargeType("8");
        if ("7".equals(crpUrechargelistDomain.getRechargeType())) {
            field = crpRecharge.getTenantCode().concat("-").concat("3-transaction_type_thre");
            cds = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
            copyRechargelistDomain.setBankcodeName(cds);
            copyRechargelistDomain.setRechargeUrl1("sgSendgoods");
            copyRechargelistDomain.setRechargeName9(crpUrechargelistDomain.getRechargeOpcode());
        } else if ("3".equals(crpUrechargelistDomain.getRechargeType())) {
            field = crpRecharge.getTenantCode().concat("-").concat("1-transaction_type_one");
            cds = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
            copyRechargelistDomain.setBankcodeName(cds);
            copyRechargelistDomain.setRechargeUrl1("ocContract");
            copyRechargelistDomain.setRechargeUrl3(crpUrechargelistDomain.getRechargeOpcode());
            crpUrechargelistDomain.setRechargeOpcode(null);
        } else if ("6".equals(crpUrechargelistDomain.getRechargeType())) {
            field = crpRecharge.getTenantCode().concat("-").concat("2-transaction_type_two");
            cds = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
            copyRechargelistDomain.setBankcodeName(cds);
            copyRechargelistDomain.setRechargeUrl1("ocContract");
            copyRechargelistDomain.setRechargeUrl3(crpUrechargelistDomain.getRechargeOpno1());
            copyRechargelistDomain.setRechargeType(crpUrechargelistDomain.getRechargeType());
            crpUrechargelistDomain.setRechargeOpcode(null);
        } else if ("9".equals(crpUrechargelistDomain.getRechargeType())) {
            field = crpRecharge.getTenantCode().concat("-").concat("4-transaction_type_four");
            cds = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
            copyRechargelistDomain.setBankcodeName(cds);
            copyRechargelistDomain.setRechargeUrl1("sgSendgoods");
            copyRechargelistDomain.setRechargeUrl3(crpUrechargelistDomain.getRechargeOpno2());
            copyRechargelistDomain.setRechargeType(crpUrechargelistDomain.getRechargeType());
        }
        CrpRecharge recharge = this.getCrpRecharge(crpRecharge.getRechargeId());
        copyRechargelistDomain.setRechargeName8(recharge.getRechargeId().toString());
        copyRechargelistDomain.setRechargeUrl4(crpUrechargelistDomain.getRechargeSmoney().toPlainString());
        copyRechargelistDomain.setRechargeSmoney(recharge.getRechargeMoney().subtract(recharge.getRechargeUmoney()));
        if (EmptyUtil.isEmpty((Object)crpRecharge.getRechargeUmoney())) {
            crpRecharge.setRechargeUmoney(BigDecimal.ZERO);
        }
        copyRechargelistDomain.setRechargeUrl2(crpRecharge.getRechargeMoney().subtract(crpRecharge.getRechargeUmoney()).toPlainString());
        copyRechargelistDomain.setRechargeAllmoney(crpRecharge.getRechargeAmoney());
        copyRechargelistDomain.setRechargeName9(crpUrechargelistDomain.getRechargeOpcode());
        if ("9".equals(crpUrechargelistDomain.getRechargeType())) {
            copyRechargelistDomain.setRechargeName9(crpUrechargelistDomain.getRechargeOpno1());
        }
        copyRechargelistDomain.setRechargeMode(crpRecharge.getRechargeMode());
        copyRechargelistDomain.setRechargeEnd(crpRecharge.getRechargeEnd());
        copyRechargelistDomain.setRechargeStart(crpRecharge.getRechargeStart());
        copyRechargelistDomain.setRechargeName2(crpRecharge.getRechargeName2());
        copyRechargelistDomain.setRechargeName5(crpRecharge.getRechargeName5());
        copyRechargelistDomain.setRechargeName10(copyRechargelistDomain.getRechargeName10());
        crpUrechargelistDomain.setRechargeName10(null);
        List<CrpChannelsend> crpChannelsends = null;
        crpChannelsends = this.crpUrechargelistService.saveCrpUrechargelistToMake(crpUrechargelistDomain, copyRechargelistDomain);
        this.crpUrechargeService.saveOrUpdateCrpUrecharge(crpUrechargelistDomain);
        return crpChannelsends;
    }

    @Override
    public List<CrpChannelsend> updateAllCrpRechargeList(CrpUrechargelistDomain crpUrechargelistDomain) throws ApiException {
        List<CrpRecharge> orCrpRechar;
        if (null == crpUrechargelistDomain) {
            return null;
        }
        this.logger.error("service.crp.CrpRechargeServiceImplupdateAllCrpRechargeList.crpUrechargelistDomain===", (Object)JsonUtil.buildNormalBinder().toJson((Object)crpUrechargelistDomain));
        ArrayList<CrpRecharge> crpRecharges = new ArrayList<CrpRecharge>();
        List<CrpRecharge> crpRechar = this.getCrpRechargeNowStarAllNew(crpUrechargelistDomain.getUserinfoCode(), null, crpUrechargelistDomain.getPartnerCode(), crpUrechargelistDomain.getTenantCode(), null);
        if (ListUtil.isNotEmpty(crpRechar)) {
            crpRecharges.addAll(crpRechar);
        }
        HashMap<String, String> crpMap = new HashMap<String, String>();
        crpMap.put("type", "1");
        if (StringUtils.isNotBlank((String)crpUrechargelistDomain.getPartnerCode()) && ListUtil.isNotEmpty(orCrpRechar = this.getCrpRechargeNowStarAllNew(crpUrechargelistDomain.getUserinfoCode(), null, null, crpUrechargelistDomain.getTenantCode(), null))) {
            crpRecharges.addAll(orCrpRechar);
        }
        if (ListUtil.isEmpty(crpRecharges)) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateAllCrpRechargeList.crpRecharges", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpUrechargelistDomain));
            return null;
        }
        BigDecimal nameMoney = BigDecimal.ZERO;
        ArrayList<CrpChannelsend> crpChannelsends = new ArrayList<CrpChannelsend>();
        if ("7".equals(crpUrechargelistDomain.getRechargeType()) || "3".equals(crpUrechargelistDomain.getRechargeType())) {
            if (StringUtils.isBlank((String)crpUrechargelistDomain.getRechargeName3())) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.updateAllCrpRechargeList.rechargeName3", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpUrechargelistDomain));
                return null;
            }
            BigDecimal rMoney = nameMoney = new BigDecimal(crpUrechargelistDomain.getRechargeName3());
            BigDecimal tMoney = nameMoney;
            BigDecimal smoney = crpUrechargelistDomain.getRechargeSmoney();
            BigDecimal decimalMoney = BigDecimal.ZERO;
            ArrayList crpList = new ArrayList();
            HashMap<BigDecimal, CrpRecharge> sendMap = null;
            TreeMap<Integer, Map> treeMap = new TreeMap<Integer, Map>();
            int i = 0;
            for (CrpRecharge recharge : crpRecharges) {
                BigDecimal userMoney = BigDecimal.ZERO;
                if (EmptyUtil.isEmpty((Object)recharge.getRechargeMoney())) {
                    recharge.setRechargeMoney(BigDecimal.ZERO);
                }
                if (EmptyUtil.isEmpty((Object)recharge.getRechargeUmoney())) {
                    recharge.setRechargeUmoney(BigDecimal.ZERO);
                }
                if (recharge.getRechargeMoney().subtract(recharge.getRechargeUmoney()).compareTo(BigDecimal.ZERO) <= 0) {
                    this.logger.error("service.crp.CrpRechargeServiceImpl.updateAllCrpRechargeList.crpRecharges", (Object)("recharge:" + JsonUtil.buildNonNullBinder().toJson((Object)recharge) + "crpUrechargelistDomain:" + JsonUtil.buildNonDefaultBinder().toJson((Object)crpUrechargelistDomain)));
                    continue;
                }
                if (tMoney.compareTo(BigDecimal.ZERO) == 0) {
                    this.logger.error("service.crp.CrpRechargeServiceImpl.updateAllCrpRechargeList.tMoney", (Object)("recharge:" + JsonUtil.buildNonNullBinder().toJson((Object)recharge) + "tMoney:" + tMoney));
                    break;
                }
                sendMap = new HashMap<BigDecimal, CrpRecharge>();
                ++i;
                BigDecimal crpAllMoney = recharge.getRechargeMoney().subtract(recharge.getRechargeUmoney());
                if ("0".equals(recharge.getRechargeName5()) || "1".equals(recharge.getRechargeMode())) {
                    if (crpAllMoney.compareTo(tMoney) >= 0) {
                        userMoney = tMoney;
                        decimalMoney = decimalMoney.add(tMoney);
                        tMoney = tMoney.subtract(tMoney);
                    } else {
                        userMoney = crpAllMoney;
                        decimalMoney = decimalMoney.add(crpAllMoney);
                        tMoney = tMoney.subtract(crpAllMoney);
                    }
                } else if (crpAllMoney.compareTo(tMoney = tMoney.multiply(new BigDecimal("0.5"))) >= 0) {
                    userMoney = tMoney;
                    decimalMoney = decimalMoney.add(tMoney);
                } else {
                    userMoney = crpAllMoney;
                    decimalMoney = decimalMoney.add(crpAllMoney);
                    tMoney = tMoney.add(tMoney.subtract(crpAllMoney));
                }
                sendMap.put(userMoney, recharge);
                treeMap.put(i, sendMap);
            }
            if (decimalMoney.compareTo(smoney) != 0 || MapUtil.isEmpty(treeMap)) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.updateAllCrpRechargeList.treeMap", (Object)("decimalMoney:" + decimalMoney + "nameMoney:" + nameMoney + "treeMap:" + JsonUtil.buildNonDefaultBinder().toJson(treeMap)));
                return null;
            }
            String opCode = crpUrechargelistDomain.getRechargeOpcode();
            String name10 = crpUrechargelistDomain.getRechargeName10();
            treeMap.forEach((k, v) -> {
                for (BigDecimal key : v.keySet()) {
                    String cds;
                    String field;
                    CrpRecharge rec = (CrpRecharge)v.get(key);
                    crpMap.put("tenantCode", rec.getTenantCode());
                    crpMap.put("rechargeMoney", (String)((Object)key));
                    crpMap.put("rechargeCode", rec.getRechargeCode());
                    this.logger.error("crpMap===", (Object)JsonUtil.buildNormalBinder().toJson((Object)crpMap));
                    this.updateStateByCodeAndModified(crpMap);
                    CrpUrechargelistDomain copyRechargelistDomain = new CrpUrechargelistDomain();
                    crpUrechargelistDomain.setRechargeMode(rec.getRechargeMode());
                    try {
                        BeanUtils.copyAllPropertys((Object)copyRechargelistDomain, (Object)crpUrechargelistDomain);
                        copyRechargelistDomain.setRechargeRemark(rec.getRechargeRemark());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    copyRechargelistDomain.setRechargeType("8");
                    if ("7".equals(crpUrechargelistDomain.getRechargeType())) {
                        field = rec.getTenantCode().concat("-").concat("3-transaction_type_thre");
                        cds = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
                        copyRechargelistDomain.setBankcodeName(cds);
                        copyRechargelistDomain.setRechargeUrl1("sgSendgoods");
                        copyRechargelistDomain.setRechargeName9(opCode);
                    } else if ("3".equals(crpUrechargelistDomain.getRechargeType())) {
                        field = rec.getTenantCode().concat("-").concat("1-transaction_type_one");
                        cds = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
                        copyRechargelistDomain.setBankcodeName(cds);
                        copyRechargelistDomain.setRechargeUrl1("ocContract");
                        copyRechargelistDomain.setRechargeUrl3(opCode);
                        crpUrechargelistDomain.setRechargeOpcode(null);
                    }
                    CrpRecharge rechargeStr = this.getCrpRecharge(rec.getRechargeId());
                    copyRechargelistDomain.setRechargeName8(rechargeStr.getRechargeId().toString());
                    copyRechargelistDomain.setRechargeUrl4(key.toPlainString());
                    copyRechargelistDomain.setRechargeSmoney(rechargeStr.getRechargeMoney().subtract(rechargeStr.getRechargeUmoney()));
                    if (EmptyUtil.isEmpty((Object)rec.getRechargeUmoney())) {
                        rec.setRechargeUmoney(BigDecimal.ZERO);
                    }
                    copyRechargelistDomain.setRechargeUrl2(rec.getRechargeMoney().subtract(rec.getRechargeUmoney()).toPlainString());
                    copyRechargelistDomain.setRechargeAllmoney(rec.getRechargeAmoney());
                    copyRechargelistDomain.setRechargeName9(opCode);
                    copyRechargelistDomain.setRechargeMode(rec.getRechargeMode());
                    copyRechargelistDomain.setRechargeEnd(rec.getRechargeEnd());
                    copyRechargelistDomain.setRechargeStart(rec.getRechargeStart());
                    copyRechargelistDomain.setRechargeName2(rec.getRechargeName2());
                    copyRechargelistDomain.setRechargeName5(rec.getRechargeName5());
                    copyRechargelistDomain.setRechargeName10(name10);
                    crpUrechargelistDomain.setRechargeName10(null);
                    crpUrechargelistDomain.setRechargeSmoney(key);
                    List<CrpChannelsend> list = this.crpUrechargelistService.saveCrpUrechargelistToMake(crpUrechargelistDomain, copyRechargelistDomain);
                    this.crpUrechargeService.saveOrUpdateCrpUrecharge(crpUrechargelistDomain);
                    crpChannelsends.addAll(list);
                }
            });
        }
        return crpChannelsends;
    }

    @Override
    public String updateCrpRechargeListToMakeRefund(CrpUrechargelistDomain crpUrechargelistDomain) throws ApiException {
        String cds;
        String field;
        if (null == crpUrechargelistDomain) {
            return null;
        }
        CrpUrechargelistDomain copyRechargelistDomain = new CrpUrechargelistDomain();
        this.logger.error("service.crp.CrpRechargeServiceImplupdateCrpRechargeListToMake.crpUrechargelistDomain===", (Object)JsonUtil.buildNormalBinder().toJson((Object)crpUrechargelistDomain));
        List<CrpRecharge> crpRechargeList = this.getCrpRechargeNowStarAllNew(crpUrechargelistDomain.getUserinfoCode(), null, crpUrechargelistDomain.getPartnerCode(), crpUrechargelistDomain.getTenantCode(), "refund");
        if (ListUtil.isEmpty(crpRechargeList)) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeListToMake.urechargelistQuery", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpUrechargelistDomain));
            return "addVd";
        }
        CrpRecharge recha = crpRechargeList.get(0);
        HashMap<String, Object> crpMap = new HashMap<String, Object>();
        crpMap.put("type", "1");
        if ("6".equals(crpUrechargelistDomain.getRechargeType()) || "9".equals(crpUrechargelistDomain.getRechargeType())) {
            HashMap<String, Object> crptoMap = new HashMap<String, Object>();
            crptoMap.put("tenantCode", crpUrechargelistDomain.getTenantCode());
            if ("6".equals(crpUrechargelistDomain.getRechargeType())) {
                crptoMap.put("rechargeUrl3", crpUrechargelistDomain.getRechargeOpno1());
                crptoMap.put("rechargeUrl1", "ocContract");
            } else if ("9".equals(crpUrechargelistDomain.getRechargeType())) {
                crptoMap.put("rechargeUrl1", "sgSendgoods");
                crptoMap.put("rechargeName9", crpUrechargelistDomain.getRechargeOpno1());
            }
            crptoMap.put("userinfoCode", crpUrechargelistDomain.getUserinfoCode());
            crptoMap.put("rechargeType", "8");
            QueryResult<CrpUrechargelist> urechargelistQuery = this.crpUrechargelistService.queryCrpUrechargelistPage(crptoMap);
            if (null == urechargelistQuery || ListUtil.isEmpty((Collection)urechargelistQuery.getList())) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeListToMake.urechargelistQuery", (Object)JsonUtil.buildNonNullBinder().toJson(crptoMap));
                return null;
            }
        }
        if (null == recha) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeList.crpRecharge", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpUrechargelistDomain));
            return null;
        }
        crpMap.put("tenantCode", recha.getTenantCode());
        crpMap.put("rechargeMoney", crpUrechargelistDomain.getRechargeSmoney());
        crpMap.put("rechargeCode", recha.getRechargeCode());
        this.logger.error("crpMap===", (Object)JsonUtil.buildNormalBinder().toJson(crpMap));
        this.updateStateByCodeAndModified(crpMap);
        try {
            BeanUtils.copyAllPropertys((Object)copyRechargelistDomain, (Object)crpUrechargelistDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        copyRechargelistDomain.setRechargeType("8");
        if ("6".equals(crpUrechargelistDomain.getRechargeType())) {
            field = recha.getTenantCode().concat("-").concat("2-transaction_type_two");
            cds = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
            copyRechargelistDomain.setBankcodeName(cds);
            copyRechargelistDomain.setRechargeUrl1("ocContract");
            copyRechargelistDomain.setRechargeUrl3(crpUrechargelistDomain.getRechargeOpno1());
            copyRechargelistDomain.setRechargeType(crpUrechargelistDomain.getRechargeType());
            crpUrechargelistDomain.setRechargeOpcode(null);
        } else if ("9".equals(crpUrechargelistDomain.getRechargeType())) {
            field = recha.getTenantCode().concat("-").concat("4-transaction_type_four");
            cds = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
            copyRechargelistDomain.setBankcodeName(cds);
            copyRechargelistDomain.setRechargeUrl1("sgSendgoods");
            copyRechargelistDomain.setRechargeUrl3(crpUrechargelistDomain.getRechargeOpno2());
            copyRechargelistDomain.setRechargeType(crpUrechargelistDomain.getRechargeType());
        }
        CrpRecharge recharge = this.getCrpRecharge(recha.getRechargeId());
        copyRechargelistDomain.setRechargeName8(recharge.getRechargeId().toString());
        copyRechargelistDomain.setRechargeUrl4(crpUrechargelistDomain.getRechargeSmoney().toPlainString());
        copyRechargelistDomain.setRechargeSmoney(recharge.getRechargeMoney().subtract(recharge.getRechargeUmoney()));
        if (EmptyUtil.isEmpty((Object)recha.getRechargeUmoney())) {
            recha.setRechargeUmoney(BigDecimal.ZERO);
        }
        copyRechargelistDomain.setRechargeUrl2(recha.getRechargeMoney().subtract(recha.getRechargeUmoney()).toPlainString());
        copyRechargelistDomain.setRechargeAllmoney(recha.getRechargeAmoney());
        copyRechargelistDomain.setRechargeName9(crpUrechargelistDomain.getRechargeOpcode());
        if ("9".equals(crpUrechargelistDomain.getRechargeType())) {
            copyRechargelistDomain.setRechargeName9(crpUrechargelistDomain.getRechargeOpno1());
        }
        copyRechargelistDomain.setRechargeMode(recha.getRechargeMode());
        copyRechargelistDomain.setRechargeEnd(recha.getRechargeEnd());
        copyRechargelistDomain.setRechargeStart(recha.getRechargeStart());
        copyRechargelistDomain.setRechargeName2(recha.getRechargeName2());
        copyRechargelistDomain.setRechargeName5(recha.getRechargeName5());
        copyRechargelistDomain.setRechargeName10(copyRechargelistDomain.getRechargeName10());
        crpUrechargelistDomain.setRechargeName10(null);
        List<CrpChannelsend> crpChannelsends = this.crpUrechargelistService.saveCrpUrechargelistToMake(crpUrechargelistDomain, copyRechargelistDomain);
        this.crpUrechargeService.saveOrUpdateCrpUrecharge(crpUrechargelistDomain);
        if (ListUtil.isNotEmpty(crpChannelsends)) {
            CrpChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(CrpChannelsendServiceImpl.getSendService(), crpChannelsends));
            return crpChannelsends.get(0).getChannelsendOpcode();
        }
        return null;
    }

    @Override
    public List<CrpChannelsend> updateCrpRechargeStar(CrpRecharge crpRecharge) {
        if (null == crpRecharge) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rechargeState", CrpConstants.RECHARGE_STATE_0);
        crpRecharge.setRechargeState(CrpConstants.RECHARGE_STATE_0);
        this.updateStateCrpModel(crpRecharge.getRechargeId(), crpRecharge.getDataState(), null, map);
        return this.handlerCrpRecharge(crpRecharge);
    }

    @Override
    public List<CrpChannelsend> updateCrpRechargeEnd(CrpRecharge crpRecharge) {
        if (null == crpRecharge) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rechargeState", CrpConstants.RECHARGE_STATE_END);
        crpRecharge.setRechargeState(CrpConstants.RECHARGE_STATE_END);
        this.updateStateCrpModel(crpRecharge.getRechargeId(), crpRecharge.getDataState(), null, map);
        BigDecimal money = BigDecimal.ZERO;
        String getddflag = FlagSettingUtils.getUrl(crpRecharge.getTenantCode(), "CrpBalance", "CrpBalance");
        if (StringUtils.isNotBlank((String)getddflag)) {
            money = crpRecharge.getRechargeMoney();
        } else {
            if (null == crpRecharge.getRechargeUmoney()) {
                crpRecharge.setRechargeUmoney(BigDecimal.ZERO);
            }
            if (null == crpRecharge.getRechargeBmoney()) {
                crpRecharge.setRechargeBmoney(BigDecimal.ZERO);
            }
            money = crpRecharge.getRechargeUmoney().subtract(crpRecharge.getRechargeBmoney());
        }
        ArrayList<CrpChannelsend> relist = new ArrayList<CrpChannelsend>();
        if (money.compareTo(BigDecimal.ZERO) > 0) {
            CrpUrechargelistDomain crpUrechargelistDomain = new CrpUrechargelistDomain();
            try {
                BeanUtils.copyAllPropertys((Object)crpUrechargelistDomain, (Object)crpRecharge);
                crpUrechargelistDomain.setRechargeAllmoney(money);
                crpUrechargelistDomain.setRechargeSmoney(money);
                if (StringUtils.isNotBlank((String)getddflag)) {
                    crpUrechargelistDomain.setRechargeName10("\u6388\u4fe1\u5931\u6548");
                }
                crpUrechargelistDomain.setRechargeOpcode(crpRecharge.getRechargeOpcode());
                crpUrechargelistDomain.setRechargeType("10");
                crpUrechargelistDomain.setUrechargelistDir("1");
            }
            catch (Exception e) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.handlerCrpRecharge", (Throwable)e);
            }
            List<CrpChannelsend> relist1 = this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelistDomain);
            this.crpUrechargeService.saveOrUpdateCrpUrecharge(crpUrechargelistDomain);
            if (null != relist1) {
                relist.addAll(relist1);
            }
        }
        return relist;
    }

    @Override
    public List<CrpChannelsend> updateCrpRechargeStarToTime(CrpRecharge crpRecharge) {
        if (null == crpRecharge) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rechargeState", CrpConstants.RECHARGE_STATE_0);
        map.put("rechargeSort", "3");
        crpRecharge.setRechargeState(CrpConstants.RECHARGE_STATE_0);
        this.updateStateCrpModel(crpRecharge.getRechargeId(), crpRecharge.getDataState(), null, map);
        if (null == crpRecharge.getRechargeUmoney()) {
            crpRecharge.setRechargeUmoney(BigDecimal.ZERO);
        }
        if (null == crpRecharge.getRechargeBmoney()) {
            crpRecharge.setRechargeBmoney(BigDecimal.ZERO);
        }
        BigDecimal money = crpRecharge.getRechargeMoney().subtract(crpRecharge.getRechargeUmoney());
        ArrayList<CrpChannelsend> relist = new ArrayList<CrpChannelsend>();
        CrpUrechargelistDomain crpUrechargelistDomain = new CrpUrechargelistDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crpUrechargelistDomain, (Object)crpRecharge);
            crpUrechargelistDomain.setRechargeAllmoney(crpRecharge.getRechargeMoney());
            crpUrechargelistDomain.setRechargeSmoney(money);
            crpUrechargelistDomain.setRechargeName8(crpRecharge.getRechargeId().toString());
            crpUrechargelistDomain.setRechargeType("24");
            crpUrechargelistDomain.setUrechargelistDir("0");
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.handlerCrpRecharge", (Throwable)e);
        }
        List<CrpChannelsend> relist1 = this.crpUrechargelistService.saveCrpUrechargelistToTime(crpUrechargelistDomain);
        this.crpUrechargeService.saveOrUpdateCrpUrechargeToTime(crpUrechargelistDomain);
        if (null != relist1) {
            relist.addAll(relist1);
        }
        return relist;
    }

    @Override
    public List<CrpChannelsend> updateCrpRechargeEndToTime(CrpRecharge crpRecharge) {
        if (null == crpRecharge) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rechargeState", CrpConstants.RECHARGE_STATE_END);
        map.put("rechargeName10", "3");
        crpRecharge.setRechargeState(CrpConstants.RECHARGE_STATE_END);
        this.updateStateCrpModel(crpRecharge.getRechargeId(), crpRecharge.getDataState(), null, map);
        if (!"3".equals(crpRecharge.getRechargeSort())) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeEndToTime.rechargeSort", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpRecharge));
            return null;
        }
        if (null == crpRecharge.getRechargeUmoney()) {
            crpRecharge.setRechargeUmoney(BigDecimal.ZERO);
        }
        if (null == crpRecharge.getRechargeBmoney()) {
            crpRecharge.setRechargeBmoney(BigDecimal.ZERO);
        }
        BigDecimal money = crpRecharge.getRechargeMoney().subtract(crpRecharge.getRechargeUmoney());
        BigDecimal amountOwed = crpRecharge.getRechargeUmoney().subtract(crpRecharge.getRechargeBmoney());
        ArrayList<CrpChannelsend> relist = new ArrayList<CrpChannelsend>();
        CrpUrechargelistDomain crpUrechargelistDomain = new CrpUrechargelistDomain();
        CrpUrechargelistDomain crpUrechargelistDo = new CrpUrechargelistDomain();
        try {
            if (EmptyUtil.isEmpty((Object)crpRecharge.getRechargeBmoney())) {
                crpRecharge.setRechargeBmoney(BigDecimal.ZERO);
            }
            if (EmptyUtil.isEmpty((Object)crpRecharge.getRechargeUmoney())) {
                crpRecharge.setRechargeUmoney(BigDecimal.ZERO);
            }
            BeanUtils.copyAllPropertys((Object)crpUrechargelistDomain, (Object)crpRecharge);
            BeanUtils.copyAllPropertys((Object)crpUrechargelistDo, (Object)crpRecharge);
            crpUrechargelistDo.setRechargeSmoney(money);
            crpUrechargelistDo.setUrechargelistDir("1");
            crpUrechargelistDo.setRechargeAllmoney(crpRecharge.getRechargeMoney());
            crpUrechargelistDomain.setRechargeAllmoney(crpRecharge.getRechargeMoney());
            crpUrechargelistDomain.setRechargeSmoney(BigDecimal.ZERO);
            crpUrechargelistDomain.setRechargeUrl(money.toPlainString());
            crpUrechargelistDomain.setRechargeName7(amountOwed.toPlainString());
            crpUrechargelistDomain.setRechargeName8(crpRecharge.getRechargeId().toString());
            crpUrechargelistDomain.setRechargeType("23");
            crpUrechargelistDomain.setUrechargelistDir("1");
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("tenantCode", crpRecharge.getTenantCode());
            map1.put("userinfoCode", crpRecharge.getUserinfoCode());
            QueryResult<CrpUrecharge> queryResult = this.crpUrechargeService.queryCrpUrechargePage(map1);
            if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeEndToTime.queryResult", (Object)JsonUtil.buildNonNullBinder().toJson(map1));
                return null;
            }
            BigDecimal amountArrears = BigDecimal.ZERO;
            for (CrpUrecharge crp : queryResult.getList()) {
                if (EmptyUtil.isEmpty((Object)crp.getRechargeUmoney())) {
                    crp.setRechargeUmoney(BigDecimal.ZERO);
                }
                if (EmptyUtil.isEmpty((Object)crp.getRechargeBmoney())) {
                    crp.setRechargeBmoney(BigDecimal.ZERO);
                }
                amountArrears = amountArrears.add(crp.getRechargeUmoney().subtract(crp.getRechargeBmoney()));
            }
            crpUrechargelistDomain.setRechargeAllmoney(amountArrears);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.handlerCrpRecharge", (Throwable)e);
        }
        List<CrpChannelsend> relist1 = this.crpUrechargelistService.saveCrpUrechargelistToTime(crpUrechargelistDomain);
        this.crpUrechargeService.saveOrUpdateCrpUrechargeToTime(crpUrechargelistDo);
        if (null != relist1) {
            relist.addAll(relist1);
        }
        return relist;
    }

    @Override
    public List<CrpChannelsend> updateCrpRechargeBlance(CrpRechargeDomain crpRechargeDomain) throws ApiException {
        if (null == crpRechargeDomain) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeBlance.crpRechargeDomain");
            return null;
        }
        CrpUrechargelistDomain copyRechargelistDomain = new CrpUrechargelistDomain();
        BigDecimal reMoney = crpRechargeDomain.getRechargeMoney();
        copyRechargelistDomain.setUrechargelistDir("0");
        CrpRecharge oldCrpRecharge = this.getCrpByCode(crpRechargeDomain.getTenantCode(), crpRechargeDomain.getRechargeCode());
        if (EmptyUtil.isEmpty((Object)oldCrpRecharge)) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeBlance.oldCrpRecharge", (Object)JsonUtil.buildNormalBinder().toJson((Object)crpRechargeDomain));
            return null;
        }
        HashMap<String, Object> crpMap = new HashMap<String, Object>();
        crpMap.put("tenantCode", crpRechargeDomain.getTenantCode());
        crpMap.put("rechargeMoney", reMoney.abs());
        crpMap.put("rechargeCode", crpRechargeDomain.getRechargeCode());
        crpMap.put("type", "5");
        if ("25".equals(crpRechargeDomain.getRechargeType())) {
            copyRechargelistDomain.setUrechargelistDir("1");
            crpMap.put("type", "51");
        } else if ("26".equals(crpRechargeDomain.getRechargeType())) {
            crpMap.put("type", "52");
        }
        this.updateStateByCodeAndModified(crpMap);
        CrpRecharge crpRecharge = this.getCrpByCode(crpRechargeDomain.getTenantCode(), crpRechargeDomain.getRechargeCode());
        try {
            BeanUtils.copyAllPropertys((Object)copyRechargelistDomain, (Object)crpRecharge);
            BeanUtils.copyAllPropertysNotNull((Object)copyRechargelistDomain, (Object)crpRechargeDomain);
            if (EmptyUtil.isEmpty((Object)crpRecharge.getRechargeUmoney())) {
                crpRecharge.setRechargeUmoney(BigDecimal.ZERO);
            }
            String randomCode = RandomUtils.generateRandom((int)16, (Integer)0);
            copyRechargelistDomain.setRechargeName10(crpRecharge.getRechargeName10());
            copyRechargelistDomain.setRechargeMode(crpRecharge.getRechargeMode());
            copyRechargelistDomain.setRechargeUrl3(randomCode);
            copyRechargelistDomain.setRechargeName9(null);
            copyRechargelistDomain.setRechargeSmoney(crpRecharge.getRechargeMoney().subtract(crpRecharge.getRechargeUmoney()));
            copyRechargelistDomain.setRechargeAllmoney(crpRecharge.getRechargeMoney());
            if (EmptyUtil.isEmpty((Object)oldCrpRecharge.getRechargeMoney())) {
                oldCrpRecharge.setRechargeMoney(BigDecimal.ZERO);
            }
            if (EmptyUtil.isEmpty((Object)oldCrpRecharge.getRechargeUmoney())) {
                oldCrpRecharge.setRechargeUmoney(BigDecimal.ZERO);
            }
            copyRechargelistDomain.setRechargeUrl2(oldCrpRecharge.getRechargeMoney().subtract(oldCrpRecharge.getRechargeUmoney()).toPlainString());
            copyRechargelistDomain.setRechargeUrl4(crpRechargeDomain.getRechargeMoney().abs().toPlainString());
            copyRechargelistDomain.setRechargeName8(oldCrpRecharge.getRechargeId().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<CrpChannelsend> channelsends = null;
        channelsends = this.crpUrechargelistService.saveCrpUrechargelistToBlance(copyRechargelistDomain);
        this.crpUrechargeService.saveUrechargeBlance(copyRechargelistDomain);
        return channelsends;
    }

    @Override
    public String updateCrpRechargeListByContract(final CrpUrechargelistDomain crpUrechargelistDomain) throws ApiException {
        if (null == crpUrechargelistDomain) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeListByContract.crpUrechargelistDomain", (Object)"crpUrechargelistDomain is null");
            return "error";
        }
        if (EmptyUtil.isEmpty((Object)crpUrechargelistDomain.getRechargeSmoney()) && crpUrechargelistDomain.getRechargeSmoney().compareTo(BigDecimal.ZERO) != 1) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeList.queryResult", (Object)crpUrechargelistDomain.getRechargeOpcode());
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("rechargeOpno", crpUrechargelistDomain.getRechargeOpno());
                this.put("userinfoCode", crpUrechargelistDomain.getUserinfoCode());
                this.put("tenantCode", crpUrechargelistDomain.getTenantCode());
                this.put("urechargelistDir", crpUrechargelistDomain.getUrechargelistDir());
                this.put("rechargeOpcode", crpUrechargelistDomain.getRechargeOpcode());
                this.put("dataState", 2);
            }
        };
        QueryResult<CrpUrechargelist> queryResult = this.crpUrechargelistService.queryCrpUrechargelistPage((Map<String, Object>)map);
        if (null != queryResult && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeList.queryResult", (Object)map);
            return "error";
        }
        HashMap<String, Object> crpUmap = new HashMap<String, Object>(){
            {
                this.put("memberCode", crpUrechargelistDomain.getRechargeOpno());
                this.put("userinfoCode", crpUrechargelistDomain.getUserinfoCode());
                this.put("tenantCode", crpUrechargelistDomain.getTenantCode());
            }
        };
        QueryResult<CrpUrecharge> crpUrechargeQuery = this.crpUrechargeService.queryCrpUrechargePage((Map<String, Object>)crpUmap);
        CrpUrecharge urecharge = (CrpUrecharge)crpUrechargeQuery.getList().get(0);
        BigDecimal sMoney = crpUrechargelistDomain.getRechargeSmoney();
        if (EmptyUtil.isEmpty((Object)urecharge.getRechargeSmoney())) {
            urecharge.setRechargeSmoney(BigDecimal.ZERO);
        }
        if (urecharge.getRechargeSmoney().compareTo(sMoney) == -1) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeList.sMoney", (Object)("rechargeOpcode:" + crpUrechargelistDomain.getRechargeOpcode() + "sMoney:" + sMoney + "rechargeSmoney:" + urecharge.getRechargeSmoney()));
            return "error";
        }
        crpUrechargelistDomain.setRechargeAllmoney(urecharge.getRechargeSmoney());
        crpUrechargelistDomain.setUrechargeCode(urecharge.getUrechargeCode());
        crpUrechargelistDomain.setRechargeOpno4(urecharge.getRechargeName1());
        crpUrechargelistDomain.setRechargeOpno3(urecharge.getMemberName());
        crpUrechargelistDomain.setRechargeOpno(crpUrechargelistDomain.getRechargeOpcode());
        this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelistDomain);
        crpUrechargelistDomain.setRechargeSmoney(sMoney);
        this.crpUrechargeService.updateCrpUrechargeByContract(crpUrechargelistDomain);
        this.crpUrechargelistService.updateCrpUrechargelistStateByCode(crpUrechargelistDomain.getTenantCode(), crpUrechargelistDomain.getUrechargelistCode(), 2, 0, null);
        return "success";
    }

    @Override
    public String updateGroupCrpRechargeListByContract(final CrpUrechargelistDomain crpUrechargelistDomain) throws ApiException {
        if (null == crpUrechargelistDomain) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateGroupCrpRechargeListByContract.crpUrechargelistDomain", (Object)"crpUrechargelistDomain is null");
            return "error";
        }
        if (EmptyUtil.isEmpty((Object)crpUrechargelistDomain.getRechargeSmoney()) && crpUrechargelistDomain.getRechargeSmoney().compareTo(BigDecimal.ZERO) != 1) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateGroupCrpRechargeListByContract.queryResult", (Object)crpUrechargelistDomain.getRechargeOpcode());
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("rechargeOpno", crpUrechargelistDomain.getRechargeOpno());
                this.put("userinfoCode", crpUrechargelistDomain.getUserinfoCode());
                this.put("tenantCode", crpUrechargelistDomain.getTenantCode());
                this.put("urechargelistDir", crpUrechargelistDomain.getUrechargelistDir());
                this.put("rechargeOpcode", crpUrechargelistDomain.getRechargeOpcode());
                this.put("dataState", 2);
            }
        };
        QueryResult<CrpUrechargelist> queryResult = this.crpUrechargelistService.queryCrpUrechargelistPage((Map<String, Object>)map);
        if (null != queryResult && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateGroupCrpRechargeListByContract.queryResult", (Object)map);
            return "error";
        }
        HashMap<String, Object> crpUmap = new HashMap<String, Object>(){
            {
                this.put("memberCode", crpUrechargelistDomain.getRechargeOpno());
                this.put("userinfoCode", crpUrechargelistDomain.getUserinfoCode());
                this.put("tenantCode", crpUrechargelistDomain.getTenantCode());
            }
        };
        QueryResult<CrpUrecharge> crpUrechargeQuery = this.crpUrechargeService.queryCrpUrechargePage((Map<String, Object>)crpUmap);
        CrpUrecharge urecharge = (CrpUrecharge)crpUrechargeQuery.getList().get(0);
        BigDecimal sMoney = crpUrechargelistDomain.getRechargeSmoney();
        if ("uCode".equals(crpUrechargelistDomain.getRechargeUrl3())) {
            if (StringUtils.isBlank((String)crpUrechargelistDomain.getRechargeUrl4())) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.updateGroupCrpRechargeListByContract.rechargeUrl4", (Object)("rechargeOpcode:" + crpUrechargelistDomain.getRechargeOpcode()));
                return "error";
            }
            HashMap<String, Object> groupCrpUmap = new HashMap<String, Object>(){
                {
                    this.put("memberCode", crpUrechargelistDomain.getRechargeOpno());
                    this.put("userinfoCode", crpUrechargelistDomain.getRechargeUrl4());
                    this.put("tenantCode", crpUrechargelistDomain.getTenantCode());
                }
            };
            QueryResult<CrpUrecharge> groupCrpUrechargeQuery = this.crpUrechargeService.queryCrpUrechargePage((Map<String, Object>)groupCrpUmap);
            CrpUrecharge groupUrecharge = (CrpUrecharge)groupCrpUrechargeQuery.getList().get(0);
            if (EmptyUtil.isEmpty((Object)groupUrecharge.getRechargeSmoney())) {
                groupUrecharge.setRechargeSmoney(BigDecimal.ZERO);
            }
            if ("1".equals(crpUrechargelistDomain.getUrechargelistDir())) {
                if (groupUrecharge.getRechargeSmoney().compareTo(sMoney) == -1) {
                    this.logger.error("service.crp.CrpRechargeServiceImpl.updateGroupCrpRechargeListByContract.sMoney", (Object)("rechargeOpcode:" + crpUrechargelistDomain.getRechargeOpcode() + "sMoney:" + sMoney + "rechargeSmoney:" + urecharge.getRechargeSmoney()));
                    return "error";
                }
                crpUrechargelistDomain.setRechargeSmoney(groupUrecharge.getRechargeSmoney().subtract(sMoney));
            } else if ("0".equals(crpUrechargelistDomain.getUrechargelistDir())) {
                crpUrechargelistDomain.setRechargeSmoney(groupUrecharge.getRechargeSmoney().add(sMoney));
            }
            crpUrechargelistDomain.setRechargeAllmoney(groupUrecharge.getRechargeSmoney());
            crpUrechargelistDomain.setUrechargeCode(groupUrecharge.getUrechargeCode());
            crpUrechargelistDomain.setRechargeOpno4(urecharge.getRechargeName1());
            crpUrechargelistDomain.setRechargeOpno3(groupUrecharge.getMemberName());
        } else {
            if (EmptyUtil.isEmpty((Object)urecharge.getRechargeSmoney())) {
                urecharge.setRechargeSmoney(BigDecimal.ZERO);
            }
            if ("1".equals(crpUrechargelistDomain.getUrechargelistDir())) {
                if (urecharge.getRechargeSmoney().compareTo(sMoney) == -1) {
                    this.logger.error("service.crp.CrpRechargeServiceImpl.updateGroupCrpRechargeListByContract.sMoney", (Object)("rechargeOpcode:" + crpUrechargelistDomain.getRechargeOpcode() + "sMoney:" + sMoney + "rechargeSmoney:" + urecharge.getRechargeSmoney()));
                    return "error";
                }
                crpUrechargelistDomain.setRechargeSmoney(urecharge.getRechargeSmoney().subtract(sMoney));
            } else if ("0".equals(crpUrechargelistDomain.getUrechargelistDir())) {
                crpUrechargelistDomain.setRechargeSmoney(urecharge.getRechargeSmoney().add(sMoney));
            }
            crpUrechargelistDomain.setRechargeAllmoney(urecharge.getRechargeSmoney());
            crpUrechargelistDomain.setUrechargeCode(urecharge.getUrechargeCode());
            crpUrechargelistDomain.setRechargeOpno4(urecharge.getRechargeName1());
            crpUrechargelistDomain.setRechargeOpno3(urecharge.getMemberName());
        }
        crpUrechargelistDomain.setRechargeOpno(crpUrechargelistDomain.getRechargeOpcode());
        this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelistDomain);
        crpUrechargelistDomain.setRechargeSmoney(sMoney);
        this.crpUrechargeService.updateCrpUrechargeByContract(crpUrechargelistDomain);
        this.crpUrechargelistService.updateCrpUrechargelistStateByCode(crpUrechargelistDomain.getTenantCode(), crpUrechargelistDomain.getUrechargelistCode(), 2, 0, null);
        return "success";
    }

    @Override
    public List<CrpChannelsend> auditCrpRechargeB2B(Map<String, Object> map) throws ApiException {
        Integer rechargeId = Integer.parseInt(map.get("rechargeId").toString());
        Integer dataState = Integer.parseInt(map.get("dataState").toString());
        CrpRecharge crpRecharge = this.getCrpModelById(rechargeId);
        if (null == crpRecharge) {
            throw new ApiException("service.crp.CrpRechargeServiceImpl.updateCrp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        crpRecharge.setDataState(dataState);
        this.setCrpUpdataDefault(crpRecharge);
        this.updateByPrimaryKeyModel(crpRecharge);
        if (dataState == 2) {
            this.handlerCrpRechargeB2B(crpRecharge);
        }
        ArrayList<CrpRecharge> list = new ArrayList<CrpRecharge>();
        list.add(crpRecharge);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public List<CrpChannelsend> updateCrpRechargeListByGuaranteeContract(final CrpUrechargelistDomain crpUrechargelistDomain) throws ApiException {
        if (null == crpUrechargelistDomain) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeListByGuaranteeContract", (Object)"crpUrechargelistDomain is null");
            return null;
        }
        if (EmptyUtil.isEmpty((Object)crpUrechargelistDomain.getRechargeSmoney()) && crpUrechargelistDomain.getRechargeSmoney().compareTo(BigDecimal.ZERO) != 1) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeListByGuaranteeContract.queryResult", (Object)crpUrechargelistDomain.getRechargeOpcode());
            return null;
        }
        HashMap<String, Object> crpUmap = new HashMap<String, Object>(){
            {
                this.put("tenantCode", crpUrechargelistDomain.getTenantCode());
                this.put("urechargeCode", crpUrechargelistDomain.getUrechargeCode());
            }
        };
        QueryResult<CrpUrecharge> crpUrechargeQuery = this.crpUrechargeService.queryCrpUrechargePage((Map<String, Object>)crpUmap);
        if (null == crpUrechargeQuery || ListUtil.isEmpty((Collection)crpUrechargeQuery.getList())) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeListByGuaranteeContractcrpUrechargeQuery", (Object)crpUmap);
            return null;
        }
        CrpUrecharge urecharge = (CrpUrecharge)crpUrechargeQuery.getList().get(0);
        BigDecimal sMoney = crpUrechargelistDomain.getRechargeSmoney();
        if (EmptyUtil.isEmpty((Object)urecharge.getRechargeSmoney())) {
            urecharge.setRechargeSmoney(BigDecimal.ZERO);
        }
        if ("1".equals(crpUrechargelistDomain.getUrechargelistDir())) {
            if (urecharge.getRechargeSmoney().compareTo(sMoney) == -1) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeListByGuaranteeContractcrpUrechargeQuery.sMoney", (Object)("rechargeOpcode:" + crpUrechargelistDomain.getRechargeOpcode() + "sMoney:" + sMoney + "rechargeSmoney:" + urecharge.getRechargeSmoney()));
                return null;
            }
            crpUrechargelistDomain.setRechargeSmoney(urecharge.getRechargeSmoney().subtract(sMoney));
        } else if ("0".equals(crpUrechargelistDomain.getUrechargelistDir())) {
            crpUrechargelistDomain.setRechargeSmoney(urecharge.getRechargeSmoney().add(sMoney));
        }
        crpUrechargelistDomain.setRechargeAllmoney(urecharge.getRechargeSmoney());
        crpUrechargelistDomain.setUrechargeCode(urecharge.getUrechargeCode());
        crpUrechargelistDomain.setRechargeUrl4(sMoney.toPlainString());
        List<CrpChannelsend> channelsends = null;
        channelsends = this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelistDomain);
        crpUrechargelistDomain.setRechargeSmoney(sMoney);
        this.crpUrechargeService.saveOrUpdateCrpUrechargeB2B(crpUrechargelistDomain);
        this.saveContractSettlBatch(crpUrechargelistDomain);
        if ("3".equals(crpUrechargelistDomain.getRechargeCategory())) {
            this.crpUrechargelistService.updateCrpUrechargelistStateByCode(crpUrechargelistDomain.getTenantCode(), crpUrechargelistDomain.getUrechargelistCode(), 2, 0, null);
            this.orderNext(crpUrechargelistDomain.getRechargeOpno(), crpUrechargelistDomain.getTenantCode(), null);
        }
        return channelsends;
    }

    protected void orderNext(String contractBillcode, String tenantCode, Map<String, Object> map) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.orderNext", (Object)(tenantCode + "==" + contractBillcode + "map" + map));
            return;
        }
        String apiCode = "oc.contractEngine.sendContractNext";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("contractBillcode", contractBillcode);
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        try {
            this.internalInvoke(apiCode, paramMap);
        }
        catch (ApiException e) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.orderNext.e" + JsonUtil.buildNormalBinder().toJson(paramMap), (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.orderNext.e1" + JsonUtil.buildNormalBinder().toJson(paramMap), (Throwable)e);
        }
    }

    public void saveContractSettlBatch(CrpUrechargelistDomain crpUrechargelistDomain) {
        if (null == crpUrechargelistDomain) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.saveContractSettlBatch", (Object)"is nulll");
            return;
        }
        ArrayList<OcContractSettlDomain> ocContractSettlDomainList = new ArrayList<OcContractSettlDomain>();
        OcContractSettlDomain ocContractSettlDomain = new OcContractSettlDomain();
        ocContractSettlDomain.setContractSettlBlance("DCRP");
        ocContractSettlDomain.setContractSettlType("0");
        ocContractSettlDomain.setContractPmode("0");
        ocContractSettlDomain.setTenantCode(crpUrechargelistDomain.getTenantCode());
        ocContractSettlDomain.setContractBillcode(crpUrechargelistDomain.getRechargeOpno());
        ocContractSettlDomain.setContractSettlGmoney(crpUrechargelistDomain.getRechargeSmoney());
        ocContractSettlDomain.setContractSettlPmoney(crpUrechargelistDomain.getRechargeSmoney());
        ocContractSettlDomain.setContractSettlOpno1(crpUrechargelistDomain.getUrechargeCode());
        ocContractSettlDomain.setContractSettlOpno2(crpUrechargelistDomain.getRechargeType());
        ocContractSettlDomain.setContractSettlOpemo(crpUrechargelistDomain.getUrechargelistCode());
        ocContractSettlDomainList.add(ocContractSettlDomain);
        String apiCode = "oc.contract.saveContractSettlBatch";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        try {
            paramMap.put("ocContractSettlDomainList", JsonUtil.buildNormalBinder().toJson(ocContractSettlDomainList));
            this.internalInvoke(apiCode, paramMap);
        }
        catch (ApiException e) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.saveContractSettlBatch.e" + JsonUtil.buildNormalBinder().toJson(paramMap), (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.saveContractSettlBatch.e1" + JsonUtil.buildNormalBinder().toJson(paramMap), (Throwable)e);
        }
    }

    @Override
    public void updateCrpRechargeListByGuaranteeContractBack(final CrpUrechargelistDomain crpUrechargelistDomain) throws ApiException {
        if (null == crpUrechargelistDomain) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeListByGuaranteeContractBack", (Object)"crpUrechargelistDomain is null");
            return;
        }
        if (EmptyUtil.isEmpty((Object)crpUrechargelistDomain.getRechargeSmoney()) && crpUrechargelistDomain.getRechargeSmoney().compareTo(BigDecimal.ZERO) != 1) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeListByGuaranteeContractBack.queryResult", (Object)crpUrechargelistDomain.getRechargeOpcode());
            return;
        }
        HashMap<String, Object> crpUmap = new HashMap<String, Object>(){
            {
                this.put("tenantCode", crpUrechargelistDomain.getTenantCode());
                this.put("urechargeCode", crpUrechargelistDomain.getUrechargeCode());
            }
        };
        QueryResult<CrpUrecharge> crpUrechargeQuery = this.crpUrechargeService.queryCrpUrechargePage((Map<String, Object>)crpUmap);
        if (null == crpUrechargeQuery || ListUtil.isEmpty((Collection)crpUrechargeQuery.getList())) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeListByGuaranteeContractBackcrpUrechargeQuery", (Object)crpUmap);
            return;
        }
        CrpUrecharge urecharge = (CrpUrecharge)crpUrechargeQuery.getList().get(0);
        BigDecimal sMoney = crpUrechargelistDomain.getRechargeSmoney();
        if (EmptyUtil.isEmpty((Object)urecharge.getRechargeSmoney())) {
            urecharge.setRechargeSmoney(BigDecimal.ZERO);
        }
        if ("1".equals(crpUrechargelistDomain.getUrechargelistDir())) {
            if (urecharge.getRechargeSmoney().compareTo(sMoney) == -1) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.uupdateCrpRechargeListByGuaranteeContractBackUrechargeQuery.sMoney", (Object)("rechargeOpcode:" + crpUrechargelistDomain.getRechargeOpcode() + "sMoney:" + sMoney + "rechargeSmoney:" + urecharge.getRechargeSmoney()));
                return;
            }
            crpUrechargelistDomain.setRechargeSmoney(urecharge.getRechargeSmoney().subtract(sMoney));
        } else if ("0".equals(crpUrechargelistDomain.getUrechargelistDir())) {
            crpUrechargelistDomain.setRechargeSmoney(urecharge.getRechargeSmoney().add(sMoney));
        }
        crpUrechargelistDomain.setRechargeAllmoney(urecharge.getRechargeSmoney());
        crpUrechargelistDomain.setUrechargeCode(urecharge.getUrechargeCode());
        crpUrechargelistDomain.setRechargeUrl4(sMoney.toPlainString());
        this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelistDomain);
        crpUrechargelistDomain.setRechargeSmoney(sMoney);
        this.crpUrechargeService.saveOrUpdateCrpUrechargeB2B(crpUrechargelistDomain);
        this.delContractSettl(crpUrechargelistDomain);
    }

    @Override
    public void updateStateByCodeAndModifiedByCode(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateStateByCodeAndModifiedByCode", (Object)"is nulll");
            return;
        }
        this.updateStateByCodeAndModified(map);
    }

    @Override
    public void updateCrpRechargeStateBeoverdue(Integer rechargeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateCrpModel(rechargeId, dataState, oldDataState, map);
    }

    @Override
    public String crpOverDueJob(String tenantCode, String day) throws ApiException {
        Calendar instance = Calendar.getInstance();
        day = StringUtils.isEmpty((String)day) ? instance.get(5) - 1 + "" : Integer.valueOf(day) - 1 + "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rechargeType", "0");
        map.put("rechargeName8", day);
        QueryResult<CrpUrecharge> crpUrechargeQueryResult = this.crpUrechargeService.queryCrpUrechargePage(map);
        if (crpUrechargeQueryResult == null || CollectionUtils.isEmpty((Collection)crpUrechargeQueryResult.getList())) {
            this.logger.error("\u5f53\u524d\u5929\u6570\u4e0d\u9700\u8981\u8ba1\u7b97\u903e\u671f", (Object)day);
        }
        instance.set(5, Integer.valueOf(day));
        instance.set(11, 23);
        instance.set(12, 59);
        instance.set(13, 59);
        Date endDate = instance.getTime();
        instance.set(5, 1);
        instance.set(11, 0);
        instance.set(12, 0);
        instance.set(13, 0);
        Date startDate = instance.getTime();
        for (CrpUrecharge crpUrecharge : crpUrechargeQueryResult.getList()) {
            if (crpUrecharge.getRechargeUmoney() == null || crpUrecharge.getRechargeUmoney().compareTo(BigDecimal.ZERO) == 0) continue;
            int currentMonth = instance.get(2) + 1;
            if ("1".equals(crpUrecharge.getRechargeName9())) {
                this.doOverDue(startDate, endDate, crpUrecharge);
                continue;
            }
            if ("2".equals(crpUrecharge.getRechargeName9())) {
                if (currentMonth % 2 != 1) continue;
                this.doOverDue(startDate, endDate, crpUrecharge);
                continue;
            }
            if ("3".equals(crpUrecharge.getRechargeName9())) {
                if (currentMonth % 3 != 1) continue;
                this.doOverDue(startDate, endDate, crpUrecharge);
                continue;
            }
            if ("4".equals(crpUrecharge.getRechargeName9())) {
                if (currentMonth != 1 && currentMonth != 7) continue;
                this.doOverDue(startDate, endDate, crpUrecharge);
                continue;
            }
            if (!"5".equals(crpUrecharge.getRechargeName9()) || currentMonth != 1) continue;
            this.doOverDue(startDate, endDate, crpUrecharge);
        }
        return "success";
    }

    @Override
    public String dcrpOverDueJob(String tenantCode, String date) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("rechargeType", "1");
        QueryResult<CrpUrecharge> crpUrechargeQueryResult = this.crpUrechargeService.queryCrpUrechargePage(map);
        if (crpUrechargeQueryResult == null || CollectionUtils.isEmpty((Collection)crpUrechargeQueryResult.getList())) {
            this.logger.error("\u62c5\u4fdd\u903e\u671f\u6682\u672a\u67e5\u8be2\u5230\u6570\u636e", map);
        }
        if (StringUtils.isBlank((String)date)) {
            date = DateUtils.getDateString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        }
        for (CrpUrecharge crpUrecharge : crpUrechargeQueryResult.getList()) {
            HashMap<String, Object> crpUrechargelistMap = new HashMap<String, Object>();
            crpUrechargelistMap.put("fchannelClassifyCode", "DCRP");
            crpUrechargelistMap.put("urechargeCode", crpUrecharge.getUrechargeCode());
            crpUrechargelistMap.put("rechargeEndQstart", date);
            QueryResult<CrpUrechargelist> crpUrechargelistQueryResult = this.crpUrechargelistService.queryCrpUrechargelistPage(crpUrechargelistMap);
            BigDecimal reduce = BigDecimal.ZERO;
            if (crpUrechargelistQueryResult != null && CollectionUtils.isNotEmpty((Collection)crpUrechargelistQueryResult.getList())) {
                for (CrpUrechargelist crpUrechargelist : crpUrechargelistQueryResult.getList()) {
                    if (!StringUtils.isNotBlank((String)crpUrechargelist.getRechargeUrl4())) continue;
                    if ("1".equals(crpUrechargelist.getUrechargelistDir())) {
                        reduce = reduce.add(new BigDecimal(crpUrechargelist.getRechargeUrl4()));
                        continue;
                    }
                    if (!"0".equals(crpUrechargelist.getUrechargelistDir())) continue;
                    reduce = reduce.subtract(new BigDecimal(crpUrechargelist.getRechargeUrl4()));
                }
            }
            BigDecimal rechargeBmoney = BigDecimal.ZERO;
            BigDecimal rechargeUmoney = BigDecimal.ZERO;
            if (crpUrecharge.getRechargeUmoney() != null) {
                rechargeUmoney = crpUrecharge.getRechargeUmoney();
            }
            rechargeBmoney = reduce.compareTo(BigDecimal.ZERO) == 0 ? rechargeUmoney : (reduce.compareTo(rechargeUmoney) >= 0 ? BigDecimal.ZERO : rechargeUmoney.subtract(reduce));
            if (crpUrecharge.getRechargeBmoney() != null && rechargeBmoney.compareTo(crpUrecharge.getRechargeBmoney()) == 0) continue;
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            map2.put("rechargeBmoney", rechargeBmoney);
            this.crpUrechargeService.updateCrpUrechargeStateByCodeBeoverdue(crpUrecharge.getTenantCode(), crpUrecharge.getUrechargeCode(), crpUrecharge.getDataState(), null, map2);
        }
        return null;
    }

    private void doOverDue(Date startDate, Date endDate, CrpUrecharge crpUrecharge) {
        HashMap<String, Object> crpUrechargelistMap = new HashMap<String, Object>();
        crpUrechargelistMap.put("fchannelClassifyCode", "GCRP,CRP");
        crpUrechargelistMap.put("urechargeCode", crpUrecharge.getUrechargeCode());
        crpUrechargelistMap.put("rechargeEndQstart", startDate);
        crpUrechargelistMap.put("rechargeEndQend", endDate);
        QueryResult<CrpUrechargelist> crpUrechargelistQueryResult = this.crpUrechargelistService.queryCrpUrechargelistPage(crpUrechargelistMap);
        BigDecimal reduce = BigDecimal.ZERO;
        if (crpUrechargelistQueryResult != null && CollectionUtils.isNotEmpty((Collection)crpUrechargelistQueryResult.getList())) {
            for (CrpUrechargelist crpUrechargelist : crpUrechargelistQueryResult.getList()) {
                if (!StringUtils.isNotBlank((String)crpUrechargelist.getRechargeUrl4())) continue;
                if ("1".equals(crpUrechargelist.getUrechargelistDir())) {
                    reduce = reduce.add(new BigDecimal(crpUrechargelist.getRechargeUrl4()));
                    continue;
                }
                if (!"0".equals(crpUrechargelist.getUrechargelistDir())) continue;
                reduce = reduce.subtract(new BigDecimal(crpUrechargelist.getRechargeUrl4()));
            }
        }
        BigDecimal rechargeBmoney = BigDecimal.ZERO;
        BigDecimal rechargeUmoney = BigDecimal.ZERO;
        if (crpUrecharge.getRechargeUmoney() != null) {
            rechargeUmoney = crpUrecharge.getRechargeUmoney();
        }
        rechargeBmoney = reduce.compareTo(BigDecimal.ZERO) == 0 ? rechargeUmoney : (reduce.compareTo(rechargeUmoney) >= 0 ? BigDecimal.ZERO : rechargeUmoney.subtract(reduce));
        if (crpUrecharge.getRechargeBmoney() != null && rechargeBmoney.compareTo(crpUrecharge.getRechargeBmoney()) == 0) {
            return;
        }
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("rechargeBmoney", rechargeBmoney);
        this.crpUrechargeService.updateCrpUrechargeStateByCodeBeoverdue(crpUrecharge.getTenantCode(), crpUrecharge.getUrechargeCode(), crpUrecharge.getDataState(), null, map2);
    }

    public void delContractSettl(CrpUrechargelistDomain crpUrechargelistDomain) {
        if (null == crpUrechargelistDomain) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.delContractSettl", (Object)"is nulll");
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", crpUrechargelistDomain.getRechargeOpno());
        map.put("contractSettlBlance", "DCRP");
        map.put("tenantCode", crpUrechargelistDomain.getTenantCode());
        QueryResult<OcContractSettl> ocContractSettlQueryResult = this.queryContractSettlPage(map);
        if (ListUtil.isEmpty((Collection)ocContractSettlQueryResult.getList())) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.delContractSettlmap", map);
            return;
        }
        String apiCode = "oc.contract.delContractSettlByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("contractSettlBillcode", ((OcContractSettl)ocContractSettlQueryResult.getList().get(0)).getContractSettlBillcode());
        mapStr.put("tenantCode", crpUrechargelistDomain.getTenantCode());
        try {
            paramMap.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
            this.internalInvoke(apiCode, paramMap);
        }
        catch (ApiException e) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.saveContractSettlBatch.e" + JsonUtil.buildNormalBinder().toJson(paramMap), (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.saveContractSettlBatch.e1" + JsonUtil.buildNormalBinder().toJson(paramMap), (Throwable)e);
        }
    }

    protected QueryResult<OcContractSettl> queryContractSettlPage(Map<String, Object> map) {
        if (null == map) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.queryContractSettlPage.map");
            return null;
        }
        String apiCode = "oc.contract.queryContractSettlPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject(apiCode, paramMap, OcContractSettl.class);
    }

    private List<CrpChannelsend> handlerCrpRechargeB2B(CrpRecharge crpRecharge) {
        if (null == crpRecharge) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.handlerCrpRecharge.crpRecharge", (Object)"crpRecharge is null");
            return null;
        }
        if (crpRecharge.getDataState() != 2 && crpRecharge.getRechargeState().intValue() != CrpConstants.RECHARGE_STATE_0.intValue()) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.handlerCrpRecharge.crpRecharge.dataState", (Object)JsonUtil.buildNormalBinder().toJson((Object)crpRecharge));
            return null;
        }
        CrpUrechargelistDomain crpUrechargelistDomain = new CrpUrechargelistDomain();
        crpUrechargelistDomain.setRechargeOpcode(crpRecharge.getRechargeOpcode());
        BigDecimal rechargeMoney = BigDecimal.ZERO;
        try {
            BeanUtils.copyAllPropertys((Object)crpUrechargelistDomain, (Object)crpRecharge);
            BigDecimal money = BigDecimal.ZERO;
            crpUrechargelistDomain.setRechargeAllmoney(crpRecharge.getRechargeMoney().add(money));
            if ("0".equals(crpRecharge.getRechargeType()) || "1".equals(crpRecharge.getRechargeType())) {
                if (StringUtils.isNotBlank((String)crpRecharge.getRechargeName10())) {
                    crpUrechargelistDomain.setRechargeSmoney(new BigDecimal(crpRecharge.getRechargeName10()));
                } else {
                    crpUrechargelistDomain.setRechargeSmoney(crpRecharge.getRechargeMoney());
                }
            } else {
                crpUrechargelistDomain.setRechargeSmoney(crpRecharge.getRechargeMoney().add(money));
            }
            rechargeMoney = crpRecharge.getRechargeMoney();
            crpUrechargelistDomain.setRechargeUrl4(crpRecharge.getRechargeMoney().toPlainString());
            crpUrechargelistDomain.setUrechargelistDir("0");
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.handlerCrpRecharge", (Throwable)e);
        }
        String rechargeType = crpRecharge.getRechargeType();
        if ("20".equals(rechargeType)) {
            crpRecharge.setRechargeType("0");
        }
        if ("21".equals(rechargeType)) {
            crpRecharge.setRechargeType("1");
        }
        crpUrechargelistDomain.setRechargeType(crpRecharge.getRechargeType());
        String urechargeCode = this.crpUrechargeService.saveApplyforOrUpdateCrpUrechargeB2B(crpUrechargelistDomain);
        crpUrechargelistDomain.setRechargeType(rechargeType);
        crpUrechargelistDomain.setUrechargeCode(urechargeCode);
        List<CrpChannelsend> channelsends = this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelistDomain);
        return channelsends;
    }

    @Override
    public String updateCrpRechargeListByContractB2B(final CrpUrechargelistDomain crpUrechargelistDomain) throws ApiException {
        BigDecimal subtract;
        BigDecimal rechargeUrl1;
        BigDecimal rechargeUrl4;
        HashMap<String, Object> map;
        QueryResult<CrpUrechargelist> crpUrechargelistQueryResult;
        BigDecimal bigDecimal;
        BigDecimal rechargeUmoney;
        this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeListByContractB2B.crpUrechargelistDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)crpUrechargelistDomain));
        if (null == crpUrechargelistDomain) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeListByContractB2B.crpUrechargelistDomain", (Object)"crpUrechargelistDomain is null");
            return "error";
        }
        if (null != crpUrechargelistDomain.getRechargeSmoney() && crpUrechargelistDomain.getRechargeSmoney().compareTo(BigDecimal.ZERO) != 1) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeListByContractB2B.queryResult", (Object)crpUrechargelistDomain.getRechargeOpcode());
            return "error";
        }
        HashMap<String, Object> crpUmap = new HashMap<String, Object>(){
            {
                this.put("tenantCode", crpUrechargelistDomain.getTenantCode());
                this.put("urechargeCode", crpUrechargelistDomain.getUrechargeCode());
            }
        };
        QueryResult<CrpUrecharge> crpUrechargeQuery = new QueryResult<CrpUrecharge>();
        if ("GCRP".equals(crpUrechargelistDomain.getFchannelClassifyCode()) || "CRP".equals(crpUrechargelistDomain.getFchannelClassifyCode())) {
            crpUrechargeQuery = this.crpUrechargeService.queryCrpUrechargePageNew((Map<String, Object>)crpUmap);
        } else if ("DCRP".equals(crpUrechargelistDomain.getFchannelClassifyCode())) {
            crpUrechargeQuery = this.crpUrechargeService.queryCrpUrechargePage((Map<String, Object>)crpUmap);
        }
        if (null == crpUrechargeQuery || ListUtil.isEmpty((Collection)crpUrechargeQuery.getList())) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeListByContractB2B.crpUrechargeQuery", (Object)crpUmap);
            return "error";
        }
        if (("DCRP".equals(crpUrechargelistDomain.getFchannelClassifyCode()) || "GCRP".equals(crpUrechargelistDomain.getFchannelClassifyCode()) || "CRP".equals(crpUrechargelistDomain.getFchannelClassifyCode())) && StringUtils.isBlank((String)crpUrechargelistDomain.getRechargeOpno1())) {
            crpUrechargelistDomain.setRechargeOpno1(crpUrechargelistDomain.getUserinfoCode());
        }
        CrpUrecharge urecharge = (CrpUrecharge)crpUrechargeQuery.getList().get(0);
        crpUrechargelistDomain.setChannelCode(urecharge.getChannelCode());
        if ("GCRP".equals(crpUrechargelistDomain.getFchannelClassifyCode()) || "CRP".equals(crpUrechargelistDomain.getFchannelClassifyCode())) {
            crpUrechargelistDomain.setRechargeName1(urecharge.getRechargeName1());
            crpUrechargelistDomain.setRechargeName3(urecharge.getRechargeName3());
        }
        if (null == (rechargeUmoney = urecharge.getRechargeUmoney())) {
            rechargeUmoney = BigDecimal.ZERO;
        }
        BigDecimal sMoney = crpUrechargelistDomain.getRechargeSmoney();
        if ("DCRP".equals(crpUrechargelistDomain.getFchannelClassifyCode()) && "6".equals(crpUrechargelistDomain.getRechargeType())) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeListByContractB2B.OA", (Object)JsonUtil.buildNormalBinder().toJson((Object)crpUrechargelistDomain));
        } else if (("CRP".equals(crpUrechargelistDomain.getFchannelClassifyCode()) || "GCRP".equals(crpUrechargelistDomain.getFchannelClassifyCode()) || "DCRP".equals(crpUrechargelistDomain.getFchannelClassifyCode())) && "0".equals(crpUrechargelistDomain.getUrechargelistDir()) && !"0".equals(crpUrechargelistDomain.getRechargeType())) {
            BigDecimal sumMoney;
            List collect;
            QueryResult<CrpUrechargelist> crpUrechargelistQueryResult2;
            HashMap<String, Object> map1;
            if ("CRP".equals(crpUrechargelistDomain.getFchannelClassifyCode()) || "GCRP".equals(crpUrechargelistDomain.getFchannelClassifyCode())) {
                map1 = new HashMap<String, Object>();
                map1.put("urechargeCode", urecharge.getUrechargeCode());
                map1.put("urechargelistDir", "1");
                map1.put("fchannelClassifyCode", "GCRP,CRP");
                if (StringUtils.isNotBlank((String)urecharge.getRechargeUrl2()) && "Yes".equals(urecharge.getRechargeUrl2())) {
                    if ("GCRP".equals(crpUrechargelistDomain.getFchannelClassifyCode())) {
                        map1.put("rechargeOpno1", crpUrechargelistDomain.getRechargeOpno1());
                    }
                    map1.put("fchannelClassifyCode", crpUrechargelistDomain.getFchannelClassifyCode());
                }
                if ((crpUrechargelistQueryResult2 = this.crpUrechargelistService.queryCrpUrechargelistPage(map1)) != null && CollectionUtils.isNotEmpty((Collection)crpUrechargelistQueryResult2.getList())) {
                    collect = crpUrechargelistQueryResult2.getList().stream().filter(u -> u.getDataState() == 2 || u.getDataState() == 98).collect(Collectors.toList());
                    if (collect != null && collect.size() > 0) {
                        sumMoney = BigDecimal.ZERO;
                        for (CrpUrechargelist crpUrechargelistReDomain : collect) {
                            bigDecimal = new BigDecimal(crpUrechargelistReDomain.getRechargeUrl4());
                            if (StringUtils.isNotBlank((String)crpUrechargelistReDomain.getRechargeUrl1())) {
                                bigDecimal = bigDecimal.subtract(new BigDecimal(crpUrechargelistReDomain.getRechargeUrl1()));
                            }
                            sumMoney = sumMoney.add(bigDecimal);
                        }
                        if (sumMoney.compareTo(BigDecimal.ZERO) <= 0) {
                            sumMoney = BigDecimal.ZERO;
                        }
                        rechargeUmoney = sumMoney;
                    }
                } else if (StringUtils.isNotBlank((String)urecharge.getRechargeUrl2()) && "Yes".equals(urecharge.getRechargeUrl2()) && "GCRP".equals(crpUrechargelistDomain.getFchannelClassifyCode())) {
                    rechargeUmoney = BigDecimal.ZERO;
                    this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeListByContractB2B.rechargeUmoneyStr", (Object)(sMoney + "===" + JsonUtil.buildNormalBinder().toJson((Object)crpUrechargelistDomain)));
                }
            }
            if ("DCRP".equals(crpUrechargelistDomain.getFchannelClassifyCode()) && !"6".equals(crpUrechargelistDomain.getRechargeType())) {
                map1 = new HashMap();
                map1.put("urechargeCode", urecharge.getUrechargeCode());
                map1.put("fchannelClassifyCode", "DCRP");
                map1.put("rechargeOpno1", crpUrechargelistDomain.getRechargeOpno1());
                map1.put("urechargelistDir", "1");
                crpUrechargelistQueryResult2 = this.crpUrechargelistService.queryCrpUrechargelistPage(map1);
                if (crpUrechargelistQueryResult2 != null && CollectionUtils.isNotEmpty((Collection)crpUrechargelistQueryResult2.getList())) {
                    collect = crpUrechargelistQueryResult2.getList().stream().filter(u -> u.getDataState() == 2 || u.getDataState() == 98).collect(Collectors.toList());
                    if (collect != null && collect.size() > 0) {
                        sumMoney = BigDecimal.ZERO;
                        for (CrpUrechargelist crpUrechargelistReDomain : collect) {
                            bigDecimal = new BigDecimal(crpUrechargelistReDomain.getRechargeUrl4());
                            if (StringUtils.isNotBlank((String)crpUrechargelistReDomain.getRechargeUrl1())) {
                                bigDecimal = bigDecimal.subtract(new BigDecimal(crpUrechargelistReDomain.getRechargeUrl1()));
                            }
                            sumMoney = sumMoney.add(bigDecimal);
                        }
                        this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeListByContractB2B.updateCrpRechargeListByContractB2B", (Object)(sumMoney + "==" + sMoney + "===" + JsonUtil.buildNormalBinder().toJson((Object)crpUrechargelistDomain)));
                        if (sumMoney.compareTo(BigDecimal.ZERO) <= 0) {
                            sumMoney = BigDecimal.ZERO;
                        }
                        rechargeUmoney = sumMoney;
                    } else {
                        rechargeUmoney = BigDecimal.ZERO;
                        this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeListByContractB2B.updateCrpRechargeListByContractB2BrechargeUmoney", (Object)(sMoney + "===" + JsonUtil.buildNormalBinder().toJson((Object)crpUrechargelistDomain)));
                    }
                }
            }
            if (rechargeUmoney.compareTo(BigDecimal.ZERO) == 0) {
                this.refundBalance(crpUrechargelistDomain, sMoney);
                return "success";
            }
            if (sMoney.compareTo(rechargeUmoney) > 0) {
                BigDecimal subtract2 = sMoney.subtract(rechargeUmoney);
                this.refundBalance(crpUrechargelistDomain, subtract2);
                crpUrechargelistDomain.setRechargeSmoney(rechargeUmoney);
                sMoney = rechargeUmoney;
            }
        }
        if (EmptyUtil.isEmpty((Object)urecharge.getRechargeSmoney())) {
            urecharge.setRechargeSmoney(BigDecimal.ZERO);
        }
        if ("1".equals(crpUrechargelistDomain.getUrechargelistDir())) {
            if (urecharge.getRechargeSmoney().compareTo(sMoney) == -1) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeListByContractB2B.sMoney", (Object)("rechargeOpcode:" + crpUrechargelistDomain.getRechargeOpcode() + "sMoney:" + sMoney + "rechargeSmoney:" + urecharge.getRechargeSmoney()));
                return "error";
            }
            crpUrechargelistDomain.setRechargeSmoney(urecharge.getRechargeSmoney().subtract(sMoney));
        } else if ("0".equals(crpUrechargelistDomain.getUrechargelistDir())) {
            crpUrechargelistDomain.setRechargeSmoney(urecharge.getRechargeSmoney().add(sMoney));
        }
        Date date = new Date();
        crpUrechargelistDomain.setRechargeStart(date);
        if ("0".equals(urecharge.getRechargeType()) && "1".equals(crpUrechargelistDomain.getUrechargelistDir())) {
            Calendar calendar;
            String rechargeName9 = urecharge.getRechargeName9();
            if ("1".equals(rechargeName9)) {
                crpUrechargelistDomain.setRechargeEnd(CrpRechargeServiceImpl.createSigalMonthEnd(urecharge, date));
                calendar = Calendar.getInstance();
                calendar.setTime(date);
                int currentMonth = calendar.get(2) + 1;
                crpUrechargelistDomain.setRechargeOpno3(DateUtils.getYear((Date)date) + "\u5e74" + currentMonth + "\u6708");
            } else if ("2".equals(rechargeName9)) {
                crpUrechargelistDomain.setRechargeEnd(CrpRechargeServiceImpl.createDoubleMonthEnd(urecharge, date));
                calendar = Calendar.getInstance();
                calendar.setTime(date);
                int currentMonth = calendar.get(2) + 1;
                if (currentMonth % 2 == 0) {
                    crpUrechargelistDomain.setRechargeOpno3(DateUtils.getYear((Date)date) + "\u5e74" + (currentMonth - 1) + "-" + currentMonth + "\u6708");
                } else {
                    crpUrechargelistDomain.setRechargeOpno3(DateUtils.getYear((Date)date) + "\u5e74" + currentMonth + "-" + (currentMonth + 1) + "\u6708");
                }
            } else if ("3".equals(rechargeName9)) {
                crpUrechargelistDomain.setRechargeEnd(CrpRechargeServiceImpl.createThreeMonthEnd(urecharge, date));
                calendar = Calendar.getInstance();
                calendar.setTime(date);
                int currentMonth = calendar.get(2) + 1;
                if (currentMonth % 3 == 0) {
                    crpUrechargelistDomain.setRechargeOpno3(DateUtils.getYear((Date)date) + "\u5e74" + (currentMonth - 2) + "-" + currentMonth + "\u6708");
                } else if (currentMonth % 3 == 1) {
                    crpUrechargelistDomain.setRechargeOpno3(DateUtils.getYear((Date)date) + "\u5e74" + currentMonth + "-" + (currentMonth + 2) + "\u6708");
                } else {
                    crpUrechargelistDomain.setRechargeOpno3(DateUtils.getYear((Date)date) + "\u5e74" + (currentMonth - 1) + "-" + (currentMonth + 1) + "\u6708");
                }
            } else if ("4".equals(rechargeName9)) {
                crpUrechargelistDomain.setRechargeEnd(CrpRechargeServiceImpl.createSixMonthEnd(urecharge, date));
                calendar = Calendar.getInstance();
                calendar.setTime(date);
                int currentMonth = calendar.get(2) + 1;
                if (currentMonth / 6 >= 1) {
                    crpUrechargelistDomain.setRechargeOpno3(DateUtils.getYear((Date)date) + "\u5e74" + currentMonth + "-12\u6708");
                } else {
                    crpUrechargelistDomain.setRechargeOpno3(DateUtils.getYear((Date)date) + "\u5e74" + currentMonth + "-6\u6708");
                }
            } else if ("5".equals(rechargeName9)) {
                crpUrechargelistDomain.setRechargeEnd(CrpRechargeServiceImpl.createYearEnd(urecharge, date));
                calendar = Calendar.getInstance();
                calendar.setTime(date);
                crpUrechargelistDomain.setRechargeOpno3(DateUtils.getYear((Date)date) + "\u5e741-12\u6708");
            } else {
                this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpRechargeListByContractB2B.rechargeName9.checkfalse", (Object)JsonUtil.buildNormalBinder().toJson((Object)crpUrechargelistDomain));
                return "error";
            }
            crpUrechargelistDomain.setRechargePeriod(Integer.valueOf(DateUtils.getDateString((Date)crpUrechargelistDomain.getRechargeEnd(), (String)"yyyyMM")));
        }
        if ("0".equals(crpUrechargelistDomain.getUrechargelistDir()) && "4".equals(crpUrechargelistDomain.getRechargeType()) && ("CRP".equals(crpUrechargelistDomain.getFchannelClassifyCode()) || "GCRP".equals(crpUrechargelistDomain.getFchannelClassifyCode()) || "DCRP".equals(crpUrechargelistDomain.getFchannelClassifyCode())) && StringUtils.isNotBlank((String)crpUrechargelistDomain.getFchannelPmodeCode())) {
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("rechargeOpcode", crpUrechargelistDomain.getFchannelPmodeCode());
            crpUrechargelistQueryResult = this.crpUrechargelistService.queryCrpUrechargelistPage(map1);
            if (crpUrechargelistQueryResult != null && CollectionUtils.isNotEmpty((Collection)crpUrechargelistQueryResult.getList())) {
                CrpUrechargelist crpUrechargelist = (CrpUrechargelist)crpUrechargelistQueryResult.getList().get(0);
                String rechargeUrl12 = crpUrechargelist.getRechargeUrl1();
                BigDecimal add = sMoney;
                if (StringUtils.isNotBlank((String)rechargeUrl12)) {
                    bigDecimal = new BigDecimal(rechargeUrl12);
                    add = add.add(bigDecimal);
                }
                if (add.compareTo(new BigDecimal(crpUrechargelist.getRechargeUrl4())) == 0) {
                    crpUrechargelist.setDataState(99);
                } else {
                    crpUrechargelist.setDataState(98);
                }
                crpUrechargelist.setRechargeUrl1(add.toPlainString());
                this.crpUrechargelistMapper.updateByPrimaryKeySelective(crpUrechargelist);
            }
        }
        crpUrechargelistDomain.setRechargeAllmoney(urecharge.getRechargeSmoney());
        crpUrechargelistDomain.setUrechargeCode(urecharge.getUrechargeCode());
        crpUrechargelistDomain.setUserinfoCode(urecharge.getUserinfoCode());
        if (StringUtils.isBlank((String)crpUrechargelistDomain.getUserinfoName())) {
            crpUrechargelistDomain.setUserinfoName(urecharge.getUserinfoName());
        }
        crpUrechargelistDomain.setChannelCode(urecharge.getChannelCode());
        crpUrechargelistDomain.setChannelName(urecharge.getChannelName());
        crpUrechargelistDomain.setRechargeUrl4(sMoney.toPlainString());
        this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelistDomain);
        crpUrechargelistDomain.setRechargeSmoney(sMoney);
        this.crpUrechargeService.saveOrUpdateCrpUrechargeB2B(crpUrechargelistDomain);
        this.crpUrechargelistService.updateCrpUrechargelistStateByCode(crpUrechargelistDomain.getTenantCode(), crpUrechargelistDomain.getUrechargelistCode(), 2, 0, null);
        if ("0".equals(crpUrechargelistDomain.getUrechargelistDir()) && "2".equals(crpUrechargelistDomain.getRechargeType()) && "CRP".equals(crpUrechargelistDomain.getFchannelClassifyCode()) && StringUtils.isNotBlank((String)crpUrechargelistDomain.getRechargeOpno2())) {
            map = new HashMap<String, Object>();
            map.put("urechargeCode", urecharge.getUrechargeCode());
            map.put("dataStateStr", "2,98");
            map.put("urechargelistDir", "1");
            map.put("fchannelClassifyCode", "GCRP,CRP");
            if (!"all".equals(crpUrechargelistDomain.getRechargeOpno2())) {
                map.put("rechargeOpno3", crpUrechargelistDomain.getRechargeOpno2());
            }
            if ((crpUrechargelistQueryResult = this.crpUrechargelistService.queryCrpUrechargelistPage(map)) != null && CollectionUtils.isNotEmpty((Collection)crpUrechargelistQueryResult.getList())) {
                for (CrpUrechargelist crpUrechargelist : crpUrechargelistQueryResult.getList()) {
                    if (sMoney.compareTo(BigDecimal.ZERO) == 0) break;
                    rechargeUrl4 = BigDecimal.ZERO;
                    rechargeUrl1 = BigDecimal.ZERO;
                    if (StringUtils.isNotBlank((String)crpUrechargelist.getRechargeUrl4())) {
                        rechargeUrl4 = new BigDecimal(crpUrechargelist.getRechargeUrl4()).setScale(8, RoundingMode.HALF_UP);
                    }
                    if (StringUtils.isNotBlank((String)crpUrechargelist.getRechargeUrl1())) {
                        rechargeUrl1 = new BigDecimal(crpUrechargelist.getRechargeUrl1()).setScale(8, RoundingMode.HALF_UP);
                    }
                    subtract = rechargeUrl4.subtract(rechargeUrl1);
                    BigDecimal repay = sMoney.subtract(subtract);
                    HashMap<String, Object> map1 = new HashMap<String, Object>();
                    int dataState = 2;
                    if (repay.compareTo(BigDecimal.ZERO) >= 0) {
                        map1.put("rechargeUrl1", rechargeUrl4);
                        dataState = 99;
                        sMoney = repay;
                    } else {
                        dataState = 98;
                        map1.put("rechargeUrl1", sMoney);
                        sMoney = BigDecimal.ZERO;
                    }
                    if (crpUrechargelist.getDataState() == dataState) continue;
                    this.crpUrechargelistService.updateCrpUrechargelistState(crpUrechargelist.getUrechargelistId(), dataState, crpUrechargelist.getDataState(), map1);
                }
            }
        }
        if ("0".equals(crpUrechargelistDomain.getUrechargelistDir()) && "2".equals(crpUrechargelistDomain.getRechargeType()) && "DCRP".equals(crpUrechargelistDomain.getFchannelClassifyCode()) && StringUtils.isNotBlank((String)crpUrechargelistDomain.getRechargeOpno2())) {
            map = new HashMap();
            map.put("urechargeCode", urecharge.getUrechargeCode());
            map.put("dataStateStr", "2,98");
            map.put("urechargelistDir", "1");
            map.put("fchannelClassifyCode", "DCRP");
            map.put("rechargeOpno1", crpUrechargelistDomain.getRechargeOpno1());
            crpUrechargelistQueryResult = this.crpUrechargelistService.queryCrpUrechargelistPage(map);
            if (crpUrechargelistQueryResult != null && CollectionUtils.isNotEmpty((Collection)crpUrechargelistQueryResult.getList())) {
                for (CrpUrechargelist crpUrechargelist : crpUrechargelistQueryResult.getList()) {
                    if (sMoney.compareTo(BigDecimal.ZERO) == 0) break;
                    rechargeUrl4 = BigDecimal.ZERO;
                    if (StringUtils.isNotBlank((String)crpUrechargelist.getRechargeUrl4())) {
                        rechargeUrl4 = new BigDecimal(crpUrechargelist.getRechargeUrl4()).setScale(8, RoundingMode.HALF_UP);
                    }
                    rechargeUrl1 = BigDecimal.ZERO;
                    if (StringUtils.isNotBlank((String)crpUrechargelist.getRechargeUrl1())) {
                        rechargeUrl1 = new BigDecimal(crpUrechargelist.getRechargeUrl1()).setScale(8, RoundingMode.HALF_UP);
                    }
                    rechargeUrl4 = rechargeUrl4.subtract(rechargeUrl1);
                    subtract = sMoney.subtract(rechargeUrl4);
                    HashMap<String, Object> map1 = new HashMap<String, Object>();
                    if (subtract.compareTo(BigDecimal.ZERO) >= 0) {
                        map1.put("rechargeUrl1", rechargeUrl1.add(rechargeUrl4));
                        sMoney = subtract;
                        this.crpUrechargelistService.updateCrpUrechargelistState(crpUrechargelist.getUrechargelistId(), 99, crpUrechargelist.getDataState(), map1);
                        continue;
                    }
                    map1.put("rechargeUrl1", rechargeUrl1.add(sMoney));
                    sMoney = BigDecimal.ZERO;
                    this.logger.error("service.crp.CrpRechargeServiceImpl.updateCrpUrechargelistState2", (Object)(crpUrechargelistDomain.getRechargeOpno2() + "___" + urecharge.getUrechargeCode() + "___" + crpUrechargelistDomain.getRechargeSmoney() + "___" + sMoney + "___" + subtract));
                    this.crpUrechargelistService.updateCrpUrechargelistState(crpUrechargelist.getUrechargelistId(), 98, crpUrechargelist.getDataState(), map1);
                }
            }
        }
        return "success";
    }

    public static void main(String[] args) {
        BigDecimal bigDecimal = new BigDecimal("22.20000000");
        System.out.println(bigDecimal);
    }

    private static Date createYearEnd(CrpUrecharge urecharge, Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, 1);
        calendar.set(2, 0);
        String rechargeName8 = urecharge.getRechargeName8();
        if (StringUtils.isBlank((String)rechargeName8)) {
            rechargeName8 = "1";
        }
        calendar.set(5, Integer.valueOf(rechargeName8));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        Date dateAtMidnight = calendar.getTime();
        return dateAtMidnight;
    }

    private static Date createSixMonthEnd(CrpUrecharge urecharge, Date date) {
        String rechargeName8;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int currentMonth = calendar.get(2) + 1;
        calendar.set(2, 6);
        if (currentMonth >= 6) {
            calendar.add(1, 1);
            calendar.set(2, 1);
        }
        if (StringUtils.isBlank((String)(rechargeName8 = urecharge.getRechargeName8()))) {
            rechargeName8 = "1";
        }
        calendar.set(5, Integer.valueOf(rechargeName8));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        Date dateAtMidnight = calendar.getTime();
        return dateAtMidnight;
    }

    public static Date createThreeMonthEnd(CrpUrecharge urecharge, Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int currentMonth = calendar.get(2) + 1;
        Date date1 = DateUtils.addMonths((Date)date, (int)1);
        date1 = currentMonth % 3 == 1 ? DateUtils.addMonths((Date)date, (int)3) : DateUtils.addMonths((Date)date, (int)2);
        String rechargeName8 = urecharge.getRechargeName8();
        if (StringUtils.isBlank((String)rechargeName8)) {
            rechargeName8 = "1";
        }
        calendar.setTime(date1);
        calendar.set(5, Integer.valueOf(rechargeName8));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        Date dateAtMidnight = calendar.getTime();
        return dateAtMidnight;
    }

    public static Date createDoubleMonthEnd(CrpUrecharge urecharge, Date date) {
        String rechargeName8;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int currentMonth = calendar.get(2) + 1;
        Date date1 = DateUtils.addMonths((Date)date, (int)2);
        if (currentMonth % 2 != 0) {
            date1 = DateUtils.addMonths((Date)date, (int)1);
        }
        if (StringUtils.isBlank((String)(rechargeName8 = urecharge.getRechargeName8()))) {
            rechargeName8 = "1";
        }
        calendar.setTime(date1);
        calendar.set(5, Integer.valueOf(rechargeName8));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        Date dateAtMidnight = calendar.getTime();
        return dateAtMidnight;
    }

    private static Date createSigalMonthEnd(CrpUrecharge urecharge, Date date) {
        String rechargeName8 = urecharge.getRechargeName8();
        if (StringUtils.isBlank((String)rechargeName8)) {
            rechargeName8 = "1";
        }
        Date date1 = DateUtils.addMonths((Date)date, (int)1);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date1);
        calendar.set(5, Integer.valueOf(rechargeName8));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        Date dateAtMidnight = calendar.getTime();
        return dateAtMidnight;
    }

    public void refundBalancegd(CrpUrechargelistDomain crpUrechargelistDomain, BigDecimal vdMoney, String userinfoCode) {
        this.logger.error("service.crp.CrpRechargeServiceImpl.refundBalancegd.refundBalancegd.", (Object)(JsonUtil.buildNormalBinder().toJson((Object)crpUrechargelistDomain) + "vdMoney" + vdMoney + "userinfoCode" + userinfoCode));
        if (null == crpUrechargelistDomain || StringUtils.isBlank((String)userinfoCode)) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.refundBalancegd.refundBalancegd.isnull", (Object)(JsonUtil.buildNormalBinder().toJson((Object)crpUrechargelistDomain) + "vdMoney" + vdMoney + "userinfoCode" + userinfoCode));
            return;
        }
        if (vdMoney.compareTo(BigDecimal.ZERO) > 0) {
            String typestr = MessageEnum.getMessage(crpUrechargelistDomain.getChannelCode(), "01");
            String type = userinfoCode.substring(0, 1);
            String basic = type + typestr;
            HashMap<String, String> map1 = new HashMap<String, String>();
            map1.put("type", "01");
            map1.put("merchantCode", userinfoCode);
            map1.put("faccountType", basic);
            HashMap<String, String> invokeMap1 = new HashMap<String, String>();
            invokeMap1.put("map", JsonUtil.buildNonNullBinder().toJson(map1));
            QueryResult quresult1 = this.getQueryResutl("vd.faccount.queryOuterFaccountInfoPage", invokeMap1, VdFaccountInfo.class);
            if (quresult1 == null || ListUtil.isEmpty((Collection)quresult1.getList())) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.refundBalancegd.setMerchant.1", (Object)("\u672a\u67e5\u8be2\u5230\u8d26\u6237\u4fe1\u606f!" + ((Object)invokeMap1).toString()));
                return;
            }
            String faccountOuterNo = ((VdFaccountInfo)quresult1.getList().get(0)).getFaccountOuterNo();
            CpRechargeDomain rechargeDomain = new CpRechargeDomain();
            rechargeDomain.setFundType("01");
            rechargeDomain.setRechargeType("01");
            rechargeDomain.setFchannelClassifyCode("AKB2BTK");
            rechargeDomain.setUserinfoCode(userinfoCode);
            rechargeDomain.setFaccountId(faccountOuterNo);
            rechargeDomain.setUserbankNo(faccountOuterNo);
            rechargeDomain.setRechargeUname("DTC01");
            if ("4".equals(crpUrechargelistDomain.getRechargeType())) {
                rechargeDomain.setRechargeUname("SHC01");
            }
            rechargeDomain.setRechargeOpcode(crpUrechargelistDomain.getRechargeOpcode());
            rechargeDomain.setFchannelCode("ctest");
            rechargeDomain.setAppmanageIcode("1");
            rechargeDomain.setTenantCode(crpUrechargelistDomain.getTenantCode());
            rechargeDomain.setFchannelPmodeCode("web");
            if (StringUtils.isBlank((String)rechargeDomain.getRechargeType())) {
                rechargeDomain.setRechargeType("01");
            }
            if (StringUtils.isBlank((String)rechargeDomain.getRechargeMode())) {
                rechargeDomain.setRechargeMode("1");
            }
            rechargeDomain.setRechargeMoney(vdMoney);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            try {
                paramMap.put("cpRechargeDomain", JsonUtil.buildNormalBinder().toJson((Object)rechargeDomain));
                this.internalInvoke("cp.recharge.saveRechargeOneNew", paramMap);
            }
            catch (ApiException e) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.refundBalancegd.e" + JsonUtil.buildNormalBinder().toJson(paramMap), (Throwable)e);
            }
            catch (Exception e) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.refundBalancegd.e1" + JsonUtil.buildNormalBinder().toJson(paramMap), (Throwable)e);
            }
        }
    }

    public void setCrpUrechargeconfMapper(CrpUrechargeconfMapper crpUrechargeconfMapper) {
        this.crpUrechargeconfMapper = crpUrechargeconfMapper;
    }

    public void refundBalance(CrpUrechargelistDomain crpUrechargelistDomain, BigDecimal vdMoney) {
        this.logger.error("service.crp.CrpRechargeServiceImpl.refundBalance.refundBalance.", (Object)(JsonUtil.buildNormalBinder().toJson((Object)crpUrechargelistDomain) + "vdMoney" + vdMoney));
        if (null == crpUrechargelistDomain) {
            this.logger.error("service.crp.CrpRechargeServiceImpl.refundBalance.refundBalance.1", (Object)"is null");
            return;
        }
        if (vdMoney.compareTo(BigDecimal.ZERO) > 0) {
            HashMap<String, String> map1 = new HashMap<String, String>();
            String userinfoCode = crpUrechargelistDomain.getUserinfoCode();
            map1.put("type", "01");
            map1.put("merchantCode", userinfoCode);
            map1.put("tenantCode", crpUrechargelistDomain.getTenantCode());
            map1.put("channelCode", crpUrechargelistDomain.getChannelCode());
            HashMap<String, String> invokeMap1 = new HashMap<String, String>();
            invokeMap1.put("map", JsonUtil.buildNonNullBinder().toJson(map1));
            QueryResult quresult1 = this.getQueryResutl("vd.faccount.queryOuterFaccountInfoPage", invokeMap1, VdFaccountInfo.class);
            if (quresult1 == null || ListUtil.isEmpty((Collection)quresult1.getList())) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.refundBalance.setMerchant.1", (Object)("\u672a\u67e5\u8be2\u5230\u8d26\u6237\u4fe1\u606f!" + ((Object)invokeMap1).toString()));
                return;
            }
            String faccountOuterNo = ((VdFaccountInfo)quresult1.getList().get(0)).getFaccountOuterNo();
            CpRechargeDomain rechargeDomain = new CpRechargeDomain();
            rechargeDomain.setFundType("01");
            rechargeDomain.setRechargeType("01");
            rechargeDomain.setFchannelClassifyCode("AKB2BTK");
            rechargeDomain.setUserinfoCode(userinfoCode);
            rechargeDomain.setFaccountId(faccountOuterNo);
            rechargeDomain.setUserbankNo(faccountOuterNo);
            rechargeDomain.setRechargeOpcode(crpUrechargelistDomain.getRechargeOpcode());
            rechargeDomain.setFchannelCode("ctest");
            rechargeDomain.setAppmanageIcode("1");
            rechargeDomain.setRechargeUname("DTC01");
            if ("4".equals(crpUrechargelistDomain.getRechargeType())) {
                rechargeDomain.setRechargeUname("SHC01");
            }
            rechargeDomain.setTenantCode(crpUrechargelistDomain.getTenantCode());
            rechargeDomain.setFchannelPmodeCode("web");
            if (StringUtils.isBlank((String)rechargeDomain.getRechargeType())) {
                rechargeDomain.setRechargeType("01");
            }
            if (StringUtils.isBlank((String)rechargeDomain.getRechargeMode())) {
                rechargeDomain.setRechargeMode("1");
            }
            rechargeDomain.setRechargeMoney(vdMoney);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            try {
                paramMap.put("cpRechargeDomain", JsonUtil.buildNormalBinder().toJson((Object)rechargeDomain));
                this.internalInvoke("cp.recharge.saveRechargeOneNew", paramMap);
            }
            catch (ApiException e) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.refundBalance.e" + JsonUtil.buildNormalBinder().toJson(paramMap), (Throwable)e);
            }
            catch (Exception e) {
                this.logger.error("service.crp.CrpRechargeServiceImpl.refundBalance.e1" + JsonUtil.buildNormalBinder().toJson(paramMap), (Throwable)e);
            }
        }
    }
}

