/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.logistics.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.logistics.dao.WlPessrulMapper;
import com.yqbsoft.laser.service.logistics.domain.WlPessrulDomain;
import com.yqbsoft.laser.service.logistics.domain.WlPessrulReDomain;
import com.yqbsoft.laser.service.logistics.model.WlPessrul;
import com.yqbsoft.laser.service.logistics.service.WlPessrulService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WlPessrulServiceImpl
extends BaseServiceImpl
implements WlPessrulService {
    private static final String SYS_CODE = "wl.LOGISTICS.WlPessrulServiceImpl";
    private WlPessrulMapper wlPessrulMapper;

    public void setWlPessrulMapper(WlPessrulMapper wlPessrulMapper) {
        this.wlPessrulMapper = wlPessrulMapper;
    }

    private Date getSysDate() {
        try {
            return this.wlPessrulMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlPessrulServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkpessrul(WlPessrulDomain wlPessrulDomain) {
        if (null == wlPessrulDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)wlPessrulDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setpessrulDefault(WlPessrul wlPessrul) {
        if (null == wlPessrul) {
            return;
        }
        if (null == wlPessrul.getDataState()) {
            wlPessrul.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == wlPessrul.getGmtCreate()) {
            wlPessrul.setGmtCreate(date);
        }
        wlPessrul.setGmtModified(date);
        if (StringUtils.isBlank((String)wlPessrul.getPessrulCode())) {
            wlPessrul.setPessrulCode(this.getNo(null, "WlPessrul", "wlPessrul", wlPessrul.getTenantCode()));
        }
    }

    private int getpessrulMaxCode() {
        int code = 0;
        try {
            return this.wlPessrulMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlPessrulServiceImpl.getpessrulMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setpessrulUpdataDefault(WlPessrul wlPessrul) {
        if (null == wlPessrul) {
            return;
        }
        wlPessrul.setGmtModified(this.getSysDate());
    }

    private void savepessrulModel(WlPessrul wlPessrul) throws ApiException {
        if (null == wlPessrul) {
            return;
        }
        try {
            this.wlPessrulMapper.insertSelective(wlPessrul);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlPessrulServiceImpl.savepessrulModel.ex", (Throwable)e);
        }
    }

    private void savepessrulBatchModel(List<WlPessrul> wlPessrulList) throws ApiException {
        if (null == wlPessrulList || wlPessrulList.isEmpty()) {
            return;
        }
        try {
            this.wlPessrulMapper.insertBatch(wlPessrulList);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlPessrulServiceImpl.savepessrulBatchModel.ex", (Throwable)e);
        }
    }

    private WlPessrul getpessrulModelById(Integer pessrulId) {
        if (null == pessrulId) {
            return null;
        }
        try {
            return this.wlPessrulMapper.selectByPrimaryKey(pessrulId);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlPessrulServiceImpl.getpessrulModelById", (Throwable)e);
            return null;
        }
    }

    private WlPessrul getpessrulModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.wlPessrulMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlPessrulServiceImpl.getpessrulModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delpessrulModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.wlPessrulMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlPessrulServiceImpl.delpessrulModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlPessrulServiceImpl.delpessrulModelByCode.num");
        }
    }

    private void deletepessrulModel(Integer pessrulId) throws ApiException {
        if (null == pessrulId) {
            return;
        }
        int i = 0;
        try {
            i = this.wlPessrulMapper.deleteByPrimaryKey(pessrulId);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlPessrulServiceImpl.deletepessrulModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlPessrulServiceImpl.deletepessrulModel.num");
        }
    }

    private void updatepessrulModel(WlPessrul wlPessrul) throws ApiException {
        if (null == wlPessrul) {
            return;
        }
        int i = 0;
        try {
            i = this.wlPessrulMapper.updateByPrimaryKeySelective(wlPessrul);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlPessrulServiceImpl.updatepessrulModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlPessrulServiceImpl.updatepessrulModel.num");
        }
    }

    private void updateStatepessrulModel(Integer pessrulId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == pessrulId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pessrulId", pessrulId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.wlPessrulMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlPessrulServiceImpl.updateStatepessrulModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlPessrulServiceImpl.updateStatepessrulModel.null");
        }
    }

    private void updateStatepessrulModelByCode(String tenantCode, String pessrulCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)pessrulCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pessrulCode", pessrulCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.wlPessrulMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlPessrulServiceImpl.updateStatepessrulModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlPessrulServiceImpl.updateStatepessrulModelByCode.null");
        }
    }

    private WlPessrul makepessrul(WlPessrulDomain wlPessrulDomain, WlPessrul wlPessrul) {
        if (null == wlPessrulDomain) {
            return null;
        }
        if (null == wlPessrul) {
            wlPessrul = new WlPessrul();
        }
        try {
            BeanUtils.copyAllPropertys((Object)wlPessrul, (Object)wlPessrulDomain);
            return wlPessrul;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlPessrulServiceImpl.makepessrul", (Throwable)e);
            return null;
        }
    }

    private WlPessrulReDomain makeWlPessrulReDomain(WlPessrul wlPessrul) {
        if (null == wlPessrul) {
            return null;
        }
        WlPessrulReDomain wlPessrulReDomain = new WlPessrulReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)wlPessrulReDomain, (Object)wlPessrul);
            return wlPessrulReDomain;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlPessrulServiceImpl.makeWlPessrulReDomain", (Throwable)e);
            return null;
        }
    }

    private List<WlPessrul> querypessrulModelPage(Map<String, Object> parammap) {
        try {
            return this.wlPessrulMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlPessrulServiceImpl.querypessrulModel", (Throwable)e);
            return null;
        }
    }

    private int countpessrul(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.wlPessrulMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlPessrulServiceImpl.countpessrul", (Throwable)e);
        }
        return i;
    }

    private WlPessrul createWlPessrul(WlPessrulDomain wlPessrulDomain) {
        String msg = this.checkpessrul(wlPessrulDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlPessrulServiceImpl.savepessrul.checkpessrul", msg);
        }
        WlPessrul wlPessrul = this.makepessrul(wlPessrulDomain, null);
        this.setpessrulDefault(wlPessrul);
        return wlPessrul;
    }

    @Override
    public String savepessrul(WlPessrulDomain wlPessrulDomain) throws ApiException {
        WlPessrul wlPessrul = this.createWlPessrul(wlPessrulDomain);
        this.savepessrulModel(wlPessrul);
        return wlPessrul.getPessrulCode();
    }

    @Override
    public String savepessrulBatch(List<WlPessrulDomain> wlPessrulDomainList) throws ApiException {
        if (null == wlPessrulDomainList || wlPessrulDomainList.isEmpty()) {
            return null;
        }
        ArrayList<WlPessrul> wlPessrulList = new ArrayList<WlPessrul>();
        String code = "";
        for (WlPessrulDomain wlPessrulDomain : wlPessrulDomainList) {
            WlPessrul wlPessrul = this.createWlPessrul(wlPessrulDomain);
            code = wlPessrul.getPessrulCode();
            wlPessrulList.add(wlPessrul);
        }
        this.savepessrulBatchModel(wlPessrulList);
        return code;
    }

    @Override
    public void updatepessrulState(Integer pessrulId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == pessrulId) {
            return;
        }
        this.updateStatepessrulModel(pessrulId, dataState, oldDataState, map);
    }

    @Override
    public void updatepessrulStateByCode(String tenantCode, String pessrulCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)pessrulCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatepessrulModelByCode(tenantCode, pessrulCode, dataState, oldDataState, map);
    }

    @Override
    public void updatepessrul(WlPessrulDomain wlPessrulDomain) throws ApiException {
        String msg = this.checkpessrul(wlPessrulDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlPessrulServiceImpl.updatepessrul.checkpessrul", msg);
        }
        WlPessrul oldWlPessrul = this.getpessrulModelById(wlPessrulDomain.getPessrulId());
        if (null == oldWlPessrul) {
            throw new ApiException("wl.LOGISTICS.WlPessrulServiceImpl.updatepessrul.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WlPessrul wlPessrul = this.makepessrul(wlPessrulDomain, oldWlPessrul);
        this.setpessrulUpdataDefault(wlPessrul);
        this.updatepessrulModel(wlPessrul);
    }

    @Override
    public WlPessrul getpessrul(Integer pessrulId) {
        if (null == pessrulId) {
            return null;
        }
        return this.getpessrulModelById(pessrulId);
    }

    @Override
    public void deletepessrul(Integer pessrulId) throws ApiException {
        if (null == pessrulId) {
            return;
        }
        this.deletepessrulModel(pessrulId);
    }

    @Override
    public QueryResult<WlPessrul> querypessrulPage(Map<String, Object> map) {
        List<WlPessrul> wlPessrulList = this.querypessrulModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countpessrul(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(wlPessrulList);
        return queryResult;
    }

    @Override
    public WlPessrul getpessrulByCode(String tenantCode, String pessrulCode) throws ApiException {
        if (StringUtils.isBlank((String)pessrulCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pessrulCode", pessrulCode);
        return this.getpessrulModelByCode(map);
    }

    @Override
    public void deletepessrulByCode(String tenantCode, String pessrulCode) throws ApiException {
        if (StringUtils.isBlank((String)pessrulCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pessrulCode", pessrulCode);
        this.delpessrulModelByCode(map);
    }
}

