/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.organize.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.organize.dao.OrgDepartYigoMapper;
import com.yqbsoft.laser.service.organize.domain.OrgDepartYigoDomain;
import com.yqbsoft.laser.service.organize.domain.OrgDepartYigoReDomain;
import com.yqbsoft.laser.service.organize.model.OrgDepartYigo;
import com.yqbsoft.laser.service.organize.service.OrgDepartYigoService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OrgDepartYigoServiceImpl
extends BaseServiceImpl
implements OrgDepartYigoService {
    private static final String SYS_CODE = "org.OrgDepartYigoServiceImpl";
    private OrgDepartYigoMapper orgDepartYigoMapper;

    public void setOrgDepartYigoMapper(OrgDepartYigoMapper orgDepartYigoMapper) {
        this.orgDepartYigoMapper = orgDepartYigoMapper;
    }

    private Date getSysDate() {
        try {
            return new Date();
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartYigoServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOrgDepartYigo(OrgDepartYigoDomain orgDepartYigoDomain) {
        if (null == orgDepartYigoDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)orgDepartYigoDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOrgDepartYigoDefault(OrgDepartYigo orgDepartYigo) {
        if (null == orgDepartYigo) {
            return;
        }
        if (null == orgDepartYigo.getDataState()) {
            orgDepartYigo.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == orgDepartYigo.getGmtCreate()) {
            orgDepartYigo.setGmtCreate(date);
        }
        orgDepartYigo.setGmtModified(date);
        if (StringUtils.isBlank((String)orgDepartYigo.getDepartCode())) {
            orgDepartYigo.setDepartCode(this.getNo(null, "OrgDepartYigo", "orgDepartYigo", orgDepartYigo.getTenantCode()));
        }
    }

    private int getOrgDepartYigoMaxCode() {
        int code = 0;
        try {
            return this.orgDepartYigoMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartYigoServiceImpl.getOrgDepartYigoMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOrgDepartYigoUpdataDefault(OrgDepartYigo orgDepartYigo) {
        if (null == orgDepartYigo) {
            return;
        }
        orgDepartYigo.setGmtModified(this.getSysDate());
    }

    private void saveOrgDepartYigoModel(OrgDepartYigo orgDepartYigo) throws ApiException {
        if (null == orgDepartYigo) {
            return;
        }
        try {
            this.orgDepartYigoMapper.insert(orgDepartYigo);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartYigoServiceImpl.saveOrgDepartYigoModel.ex", (Throwable)e);
        }
    }

    private void saveOrgDepartYigoBatchModel(List<OrgDepartYigo> orgDepartYigoList) throws ApiException {
        if (null == orgDepartYigoList || orgDepartYigoList.isEmpty()) {
            return;
        }
        try {
            this.orgDepartYigoMapper.insertBatch(orgDepartYigoList);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartYigoServiceImpl.saveOrgDepartYigoBatchModel.ex", (Throwable)e);
        }
    }

    private OrgDepartYigo getOrgDepartYigoModelById(Integer departId) {
        if (null == departId) {
            return null;
        }
        try {
            return this.orgDepartYigoMapper.selectByPrimaryKey(departId);
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartYigoServiceImpl.getOrgDepartYigoModelById", (Throwable)e);
            return null;
        }
    }

    private OrgDepartYigo getOrgDepartYigoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.orgDepartYigoMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartYigoServiceImpl.getOrgDepartYigoModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOrgDepartYigoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.orgDepartYigoMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartYigoServiceImpl.delOrgDepartYigoModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgDepartYigoServiceImpl.delOrgDepartYigoModelByCode.num");
        }
    }

    private void deleteOrgDepartYigoModel(Integer departId) throws ApiException {
        if (null == departId) {
            return;
        }
        int i = 0;
        try {
            i = this.orgDepartYigoMapper.deleteByPrimaryKey(departId);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartYigoServiceImpl.deleteOrgDepartYigoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgDepartYigoServiceImpl.deleteOrgDepartYigoModel.num");
        }
    }

    private void updateOrgDepartYigoModel(OrgDepartYigo orgDepartYigo) throws ApiException {
        if (null == orgDepartYigo) {
            return;
        }
        int i = 0;
        try {
            i = this.orgDepartYigoMapper.updateByPrimaryKey(orgDepartYigo);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartYigoServiceImpl.updateOrgDepartYigoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgDepartYigoServiceImpl.updateOrgDepartYigoModel.num");
        }
    }

    private void updateStateOrgDepartYigoModel(Integer departId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == departId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("departId", departId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.orgDepartYigoMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartYigoServiceImpl.updateStateOrgDepartYigoModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgDepartYigoServiceImpl.updateStateOrgDepartYigoModel.null");
        }
    }

    private void updateStateOrgDepartYigoModelByCode(String tenantCode, String departCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)departCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("departCode", departCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.orgDepartYigoMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartYigoServiceImpl.updateStateOrgDepartYigoModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgDepartYigoServiceImpl.updateStateOrgDepartYigoModelByCode.null");
        }
    }

    private OrgDepartYigo makeOrgDepartYigo(OrgDepartYigoDomain orgDepartYigoDomain, OrgDepartYigo orgDepartYigo) {
        if (null == orgDepartYigoDomain) {
            return null;
        }
        if (null == orgDepartYigo) {
            orgDepartYigo = new OrgDepartYigo();
        }
        try {
            BeanUtils.copyAllPropertys((Object)orgDepartYigo, (Object)orgDepartYigoDomain);
            return orgDepartYigo;
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartYigoServiceImpl.makeOrgDepartYigo", (Throwable)e);
            return null;
        }
    }

    private OrgDepartYigoReDomain makeOrgDepartYigoReDomain(OrgDepartYigo orgDepartYigo) {
        if (null == orgDepartYigo) {
            return null;
        }
        OrgDepartYigoReDomain orgDepartYigoReDomain = new OrgDepartYigoReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)orgDepartYigoReDomain, (Object)orgDepartYigo);
            return orgDepartYigoReDomain;
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartYigoServiceImpl.makeOrgDepartYigoReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OrgDepartYigo> queryOrgDepartYigoModelPage(Map<String, Object> parammap) {
        try {
            return this.orgDepartYigoMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartYigoServiceImpl.queryOrgDepartYigoModel", (Throwable)e);
            return null;
        }
    }

    private int countOrgDepartYigo(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.orgDepartYigoMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartYigoServiceImpl.countOrgDepartYigo", (Throwable)e);
        }
        return i;
    }

    private OrgDepartYigo createOrgDepartYigo(OrgDepartYigoDomain orgDepartYigoDomain) {
        String msg = this.checkOrgDepartYigo(orgDepartYigoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgDepartYigoServiceImpl.saveOrgDepartYigo.checkOrgDepartYigo", msg);
        }
        OrgDepartYigo orgDepartYigo = this.makeOrgDepartYigo(orgDepartYigoDomain, null);
        this.setOrgDepartYigoDefault(orgDepartYigo);
        return orgDepartYigo;
    }

    @Override
    public String saveOrgDepartYigo(OrgDepartYigoDomain orgDepartYigoDomain) throws ApiException {
        OrgDepartYigo orgDepartYigo = this.createOrgDepartYigo(orgDepartYigoDomain);
        this.saveOrgDepartYigoModel(orgDepartYigo);
        return orgDepartYigo.getDepartCode();
    }

    @Override
    public String saveOrgDepartYigoBatch(List<OrgDepartYigoDomain> orgDepartYigoDomainList) throws ApiException {
        if (null == orgDepartYigoDomainList || orgDepartYigoDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OrgDepartYigo> orgDepartYigoList = new ArrayList<OrgDepartYigo>();
        String code = "";
        for (OrgDepartYigoDomain orgDepartYigoDomain : orgDepartYigoDomainList) {
            OrgDepartYigo orgDepartYigo = this.createOrgDepartYigo(orgDepartYigoDomain);
            code = orgDepartYigo.getDepartCode();
            orgDepartYigoList.add(orgDepartYigo);
        }
        this.saveOrgDepartYigoBatchModel(orgDepartYigoList);
        return code;
    }

    @Override
    public void updateOrgDepartYigoState(Integer departId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == departId) {
            return;
        }
        this.updateStateOrgDepartYigoModel(departId, dataState, oldDataState, map);
    }

    @Override
    public void updateOrgDepartYigoStateByCode(String tenantCode, String departCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)departCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOrgDepartYigoModelByCode(tenantCode, departCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOrgDepartYigo(OrgDepartYigoDomain orgDepartYigoDomain) throws ApiException {
        String msg = this.checkOrgDepartYigo(orgDepartYigoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgDepartYigoServiceImpl.updateOrgDepartYigo.checkOrgDepartYigo", msg);
        }
        OrgDepartYigo oldOrgDepartYigo = this.getOrgDepartYigoModelById(orgDepartYigoDomain.getDepartId());
        if (null == oldOrgDepartYigo) {
            throw new ApiException("org.OrgDepartYigoServiceImpl.updateOrgDepartYigo.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OrgDepartYigo orgDepartYigo = this.makeOrgDepartYigo(orgDepartYigoDomain, oldOrgDepartYigo);
        this.setOrgDepartYigoUpdataDefault(orgDepartYigo);
        this.updateOrgDepartYigoModel(orgDepartYigo);
    }

    @Override
    public OrgDepartYigo getOrgDepartYigo(Integer departId) {
        if (null == departId) {
            return null;
        }
        return this.getOrgDepartYigoModelById(departId);
    }

    @Override
    public void deleteOrgDepartYigo(Integer departId) throws ApiException {
        if (null == departId) {
            return;
        }
        this.deleteOrgDepartYigoModel(departId);
    }

    @Override
    public QueryResult<OrgDepartYigo> queryOrgDepartYigoPage(Map<String, Object> map) {
        List<OrgDepartYigo> orgDepartYigoList = this.queryOrgDepartYigoModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOrgDepartYigo(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(orgDepartYigoList);
        return queryResult;
    }

    @Override
    public OrgDepartYigo getOrgDepartYigoByCode(String tenantCode, String departCode) throws ApiException {
        if (StringUtils.isBlank((String)departCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("departCode", departCode);
        return this.getOrgDepartYigoModelByCode(map);
    }

    @Override
    public void deleteOrgDepartYigoByCode(String tenantCode, String departCode) throws ApiException {
        if (StringUtils.isBlank((String)departCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("departCode", departCode);
        this.delOrgDepartYigoModelByCode(map);
    }
}

