/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.payengine.service.impl;

import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.payengine.domain.PayClearInfoQ;
import com.yqbsoft.laser.service.payengine.domain.PePaymentDomain;
import com.yqbsoft.laser.service.payengine.domain.PePaymentOrderDomain;
import com.yqbsoft.laser.service.payengine.model.PePaymentParticipant;
import com.yqbsoft.laser.service.payengine.model.PeProtClearinfo;
import com.yqbsoft.laser.service.payengine.model.PeProtEtc;
import com.yqbsoft.laser.service.payengine.service.impl.ClearInfoService;
import com.yqbsoft.laser.service.payengine.service.impl.PeProtEtcServiceImpl;
import com.yqbsoft.laser.service.suppercore.sync.AbstractEtcInfoThread;
import java.util.HashMap;
import java.util.List;

public class ClearInfoPutThread
extends AbstractEtcInfoThread {
    public static final String SYS_CODE = "pe.ClearInfoPutThread";
    private ClearInfoService clearInfoService;
    private List<PeProtClearinfo> list;

    ClearInfoPutThread(ClearInfoService clearInfoService, List<PeProtClearinfo> list) {
        this.clearInfoService = clearInfoService;
        this.list = list;
    }

    public void run() {
        try {
            this.off(this.list);
        }
        catch (Exception e) {
            this.logger.error("pe.ClearInfoPutThread.run.e", (Throwable)e);
        }
    }

    public void off(List<PeProtClearinfo> list) {
        if (null == list || list.isEmpty()) {
            return;
        }
        PayClearInfoQ payClearInfoQ = null;
        PePaymentDomain pePaymentDomain = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        QueryResult<PePaymentParticipant> participantResult = null;
        HashMap<String, PayClearInfoQ> paymentMap = new HashMap<String, PayClearInfoQ>();
        PayClearInfoQ payClearInfoQExit = null;
        PePaymentOrderDomain pePaymentOrderDomain = null;
        for (PeProtClearinfo peProtClearinfo : list) {
            map.put("tenantCode", peProtClearinfo.getTenantCode());
            payClearInfoQ = new PayClearInfoQ();
            payClearInfoQExit = (PayClearInfoQ)paymentMap.get(peProtClearinfo.getPaymentSeqno() + "-" + peProtClearinfo.getTenantCode());
            if (null != payClearInfoQExit) {
                payClearInfoQ.setPePaymentDomain(payClearInfoQExit.getPePaymentDomain());
                payClearInfoQ.setParticipantList(payClearInfoQExit.getParticipantList());
            } else {
                paymentMap.put(peProtClearinfo.getPaymentSeqno() + "-" + peProtClearinfo.getTenantCode(), payClearInfoQ);
                pePaymentDomain = this.clearInfoService.getPePaymentService().getPaymentByCode(peProtClearinfo.getPaymentSeqno(), peProtClearinfo.getTenantCode());
                if (null == pePaymentDomain) {
                    this.logger.error("pe.ClearInfoPutThread.off.pePaymentDomain");
                    continue;
                }
                map.put("paymentSeqno", peProtClearinfo.getPaymentSeqno());
                participantResult = this.clearInfoService.getPePaymentService().queryPaymentParticipantPage(map);
                if (null == participantResult || null == participantResult.getRows() || participantResult.getRows().isEmpty()) {
                    this.logger.error("pe.ClearInfoPutThread.off.participantResult");
                    continue;
                }
                payClearInfoQ.setPePaymentDomain(pePaymentDomain);
                payClearInfoQ.setParticipantList(participantResult.getRows());
            }
            pePaymentOrderDomain = this.clearInfoService.getPePaymentService().getPaymentOrderByCode(peProtClearinfo.getPaymentOrderSeqno(), peProtClearinfo.getTenantCode());
            payClearInfoQ.setPeProtClearinfo(peProtClearinfo);
            payClearInfoQ.setPePaymentOrderDomain(pePaymentOrderDomain);
            PeProtEtc peProtEtc = (PeProtEtc)DisUtil.getMapJson((String)PeProtEtcServiceImpl.CACHE_KEY_ETC, (String)(peProtClearinfo.getProtEtcCode() + "-" + peProtClearinfo.getTenantCode()), PeProtEtc.class);
            if (null == peProtEtc) {
                peProtEtc = (PeProtEtc)DisUtil.getMapJson((String)PeProtEtcServiceImpl.CACHE_KEY_ETC, (String)(peProtClearinfo.getProtEtcCode() + "-00000000"), PeProtEtc.class);
            }
            if (null == peProtEtc) {
                this.logger.error("pe.ClearInfoPutThread.off.peProtEtc");
                continue;
            }
            payClearInfoQ.setPeProtEtc(peProtEtc);
            payClearInfoQ.setClearAsync(peProtClearinfo.isClearAsync());
            this.logger.debug("pe.ClearInfoPutThread.off.put", (Object)payClearInfoQ.getPeProtClearinfo().getProtClearinfoSeqno());
            this.clearInfoService.putQueue(payClearInfoQ);
        }
    }
}

