/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.paytradeengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.paytradeengine.Integration.CmChannelClearIntegration;
import com.yqbsoft.laser.service.paytradeengine.PteConstants;
import com.yqbsoft.laser.service.paytradeengine.core.PteBalanceCore;
import com.yqbsoft.laser.service.paytradeengine.domain.CmChannelClear;
import com.yqbsoft.laser.service.paytradeengine.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.OcContractReDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.OcContractSettlDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.OcPackageDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalanceopDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalanceopGoodsDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.PteBalanceopPmgoodsDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.paytradeengine.domain.ShShsettlList;
import com.yqbsoft.laser.service.paytradeengine.enumc.DicPaypdCodeEnum;
import com.yqbsoft.laser.service.paytradeengine.enumc.PromotionSavgEnum;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalance;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalanceop;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalanceopGoods;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalanceopPmgoods;
import com.yqbsoft.laser.service.paytradeengine.model.PteBalanceopPmgoodslist;
import com.yqbsoft.laser.service.paytradeengine.model.PteChannelsend;
import com.yqbsoft.laser.service.paytradeengine.model.PtePtrade;
import com.yqbsoft.laser.service.paytradeengine.model.dto.enums.BusinessTypeEnum;
import com.yqbsoft.laser.service.paytradeengine.model.dto.req.QueryBalanceBatchReqDTO;
import com.yqbsoft.laser.service.paytradeengine.model.dto.res.QueryBalanceBatchResDTO;
import com.yqbsoft.laser.service.paytradeengine.send.SendBalancePutThread;
import com.yqbsoft.laser.service.paytradeengine.send.SendPutThread;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceBaseBusService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceBaseService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceopGoodsService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceopPmgoodslistService;
import com.yqbsoft.laser.service.paytradeengine.service.PteBalanceopService;
import com.yqbsoft.laser.service.paytradeengine.service.PtePtradeService;
import com.yqbsoft.laser.service.paytradeengine.service.biz.PteBalanceBaseServiceBiz;
import com.yqbsoft.laser.service.paytradeengine.service.convert.PteBalanceBaseConvert;
import com.yqbsoft.laser.service.paytradeengine.service.impl.PteBalanceopServiceImpl;
import com.yqbsoft.laser.service.paytradeengine.service.impl.PteChannelsendServiceImpl;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PteBalanceBaseServiceImpl
extends BaseServiceImpl
implements PteBalanceBaseService {
    private static final Logger log = LoggerFactory.getLogger(PteBalanceBaseServiceImpl.class);
    private static final String SYS_CODE = "pte.PteBalanceBaseServiceImpl";
    @Autowired
    private PteBalanceBaseBusService pteBalanceBaseBusService;
    @Autowired
    private PteBalanceService pteBalanceService;
    @Autowired
    private PteBalanceopService pteBalanceopService;
    @Autowired
    private PteBalanceopGoodsService pteBalanceopGoodsService;
    @Autowired
    private CmChannelClearIntegration cmChannelClearIntegration;
    @Autowired
    private PtePtradeService ptePtradeService;
    @Autowired
    private PteBalanceBaseServiceBiz pteBalanceBaseServiceBiz;
    @Autowired
    private PteBalanceopPmgoodslistService pteBalanceopPmgoodslistService;
    @Autowired
    private PteBalanceCore pteBalanceCore;

    @Override
    public String sendBalanceopToBalanceamt(PteBalanceop pteBalanceop) {
        if (null == pteBalanceop) {
            return "error";
        }
        return this.sendBalanceopToBalanceamt(pteBalanceop, null);
    }

    private String sendBalanceopToBalanceamt(PteBalanceop pteBalanceop, Map<String, Object> map) {
        if (null == pteBalanceop) {
            return "error";
        }
        List<PteChannelsend> pteBalancelist = this.pteBalanceopService.saveBalanceopToBalancelist(pteBalanceop, map);
        if (ListUtil.isNotEmpty(pteBalancelist)) {
            PteChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PteChannelsendServiceImpl.getSendService(), pteBalancelist));
        }
        return "success";
    }

    @Override
    public String sendBalanceAmt(String balanceopCode, String tenantCode, Map<String, Object> map) {
        PteBalanceop pteBalanceop = this.pteBalanceopService.getBalanceopByCode(tenantCode, balanceopCode);
        if (null == pteBalanceop) {
            log.error("pte.PteBalanceBaseServiceImpl.sendBalanceAmt.pteBalanceop");
            return "error";
        }
        return this.sendBalanceopToBalanceamt(pteBalanceop, map);
    }

    @Override
    public String sendBalanceopToBalanceamtRebate(PteBalanceop PteBalanceop2) {
        if (null == PteBalanceop2) {
            return "error";
        }
        return this.sendBalanceopToBalanceamtRebate(PteBalanceop2, null);
    }

    private String sendBalanceopToBalanceamtRebate(PteBalanceop PteBalanceop2, Map<String, Object> map) {
        if (null == PteBalanceop2) {
            return "error";
        }
        List<PteChannelsend> pteBalancelist = this.pteBalanceopService.sendBalanceopToBalancelistRebate(PteBalanceop2, map);
        if (ListUtil.isNotEmpty(pteBalancelist)) {
            PteChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PteChannelsendServiceImpl.getSendService(), pteBalancelist));
        }
        return "success";
    }

    @Override
    public String sendSaveBalanceop(PteBalanceopDomain pteBalanceopDomain) {
        if (null == pteBalanceopDomain) {
            return "error";
        }
        if (StringUtils.isBlank((String)pteBalanceopDomain.getMemberCode())) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.sendSaveBalanceop", (Object)JsonUtil.buildNormalBinder().toJson((Object)pteBalanceopDomain));
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", pteBalanceopDomain.getTenantCode());
        map.put("balanceType", pteBalanceopDomain.getBalanceType());
        map.put("dataState", 0);
        QueryResult<PteBalance> pteBalanceQueryResult = this.pteBalanceService.queryBalancePage(map);
        PteBalance pteBalance = null;
        if (null == pteBalanceQueryResult || !ListUtil.isNotEmpty((Collection)pteBalanceQueryResult.getList())) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.queryBalancePage.null", (Object)JsonUtil.buildNormalBinder().toJson(map));
            return "error";
        }
        pteBalance = (PteBalance)pteBalanceQueryResult.getList().get(0);
        if (PteConstants.BALANCE_FEE_STATE_OPEN.equals(pteBalance.getBalanceFeestate())) {
            if ("0".equals(pteBalance.getBalanceFeetype()) && null != pteBalance.getBalanceFee()) {
                pteBalanceopDomain.setBalanceopFee(pteBalance.getBalanceFee());
            } else if ("1".equals(pteBalance.getBalanceFeetype()) && null != pteBalance.getBalanceFee() && null != pteBalanceopDomain.getBalanceopAmount()) {
                pteBalanceopDomain.setBalanceopFee(pteBalanceopDomain.getBalanceopAmount().multiply(pteBalance.getBalanceFee()));
            }
        } else {
            pteBalanceopDomain.setBalanceopFee(BigDecimal.ZERO);
        }
        if ("0".equals(pteBalance.getBalanceAmounttype()) && null != pteBalance.getBalanceAmount()) {
            pteBalanceopDomain.setBalanceopAmount(pteBalance.getBalanceAmount());
        } else if ("1".equals(pteBalance.getBalanceAmounttype()) && null != pteBalance.getBalanceAmount() && null != pteBalanceopDomain.getBalanceopAmount()) {
            pteBalanceopDomain.setBalanceopAmount(pteBalanceopDomain.getBalanceopAmount().multiply(pteBalance.getBalanceAmount()));
        }
        pteBalanceopDomain.setBalanceBank(pteBalance.getBalanceBank());
        pteBalanceopDomain.setBalanceType(pteBalance.getBalanceType());
        ArrayList<PteBalanceopDomain> pteBalanceopDomains = new ArrayList<PteBalanceopDomain>();
        pteBalanceopDomains.add(pteBalanceopDomain);
        List<PteBalanceop> list = this.pteBalanceopService.savePteBalanceoplistBatchRe(pteBalanceopDomains);
        if (ListUtil.isNotEmpty(list)) {
            PteBalanceopServiceImpl.getSendService().addPutPool(new SendBalancePutThread(PteBalanceopServiceImpl.getSendService(), list));
        } else {
            this.logger.error("pte.PteBalanceBaseServiceImpl.sendSaveBalanceop.list", (Object)JsonUtil.buildNormalBinder().toJson(pteBalanceopDomains));
        }
        return "success";
    }

    private void setYZFInfo(PteBalanceopDomain pteBalanceopDomain, String OrderCode, String code) {
        QueryResult<CmChannelClear> queryResult = this.cmChannelClearIntegration.getYZFTradeInfo(pteBalanceopDomain.getTenantCode(), OrderCode, code);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("\u83b7\u53d6\u7ffc\u652f\u4ed8\u4ea4\u6613\u53f7\u7b49\u4fe1\u606f\u5931\u8d25,\u8ba2\u5355\u53f7", (Object)pteBalanceopDomain.getBusinessOrder());
            return;
        }
        if (code.equals(DicPaypdCodeEnum.PD01.getCode())) {
            String yzfPaymentChannel = ((CmChannelClear)queryResult.getList().get(0)).getChannelClearFchannel();
            pteBalanceopDomain.setBusinessDes(yzfPaymentChannel);
        }
        String yzfTradeNo = ((CmChannelClear)queryResult.getList().get(0)).getOrderBankseq();
        Date payTime = ((CmChannelClear)queryResult.getList().get(0)).getChannelAcceptDate();
        pteBalanceopDomain.setBusinessDes3(yzfTradeNo);
        pteBalanceopDomain.setGmtPaid(payTime);
    }

    public static void main(String[] args) {
        String[] split = "skuNo=".split("\\=");
        System.out.println(split);
    }

    @Override
    public String sendSaveBalanceopRebate(PteBalanceopDomain pteBalanceopDomain) {
        if (null == pteBalanceopDomain) {
            return "error";
        }
        if (StringUtils.isBlank((String)pteBalanceopDomain.getMemberCode())) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.sendSaveBalanceop", (Object)JsonUtil.buildNormalBinder().toJson((Object)pteBalanceopDomain));
            return "error";
        }
        ArrayList<PteBalanceopDomain> pteBalanceopDomains = new ArrayList<PteBalanceopDomain>();
        pteBalanceopDomains.add(pteBalanceopDomain);
        List<PteBalanceop> list = this.pteBalanceopService.savePteBalanceoplistBatchRe(pteBalanceopDomains);
        if (ListUtil.isNotEmpty(list)) {
            PteBalanceopServiceImpl.getSendService().addPutPool(new SendBalancePutThread(PteBalanceopServiceImpl.getSendService(), list));
        } else {
            this.logger.error("pte.PteBalanceBaseServiceImpl.sendSaveBalanceop.list", (Object)JsonUtil.buildNormalBinder().toJson(pteBalanceopDomains));
        }
        return "success";
    }

    @Override
    public String sendShsettlListToBalanceop(ShShsettlList shShsettlList) {
        this.logger.error("pte.PteBalanceBaseServiceImpl.sendShsettlListToBalanceop.shShsettlList", (Object)JsonUtil.buildNormalBinder().toJson((Object)shShsettlList));
        if (null == shShsettlList) {
            return "error";
        }
        PteBalanceopDomain pteBalanceopDomain = new PteBalanceopDomain();
        pteBalanceopDomain.setBalanceopAmount(shShsettlList.getShsettlListAmt());
        pteBalanceopDomain.setOrderOamount(shShsettlList.getShsettlOplistOpamt());
        pteBalanceopDomain.setBalanceType("shsettl");
        pteBalanceopDomain.setMemberCode(shShsettlList.getMemberBcode());
        pteBalanceopDomain.setMemberName(shShsettlList.getMemberBname());
        pteBalanceopDomain.setMemberBcode(shShsettlList.getMemberCcode());
        pteBalanceopDomain.setMemberBname(shShsettlList.getMemberCname());
        pteBalanceopDomain.setTenantCode(shShsettlList.getTenantCode());
        pteBalanceopDomain.setBusinessOrderno(shShsettlList.getShsettlOplistOp());
        this.sendSaveBalanceop(pteBalanceopDomain);
        return "success";
    }

    @Override
    public String sendSgOccontractPoolSendgoods(OcContractReDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain) {
            return "error";
        }
        PteBalanceopDomain pteBalanceopDomain = new PteBalanceopDomain();
        pteBalanceopDomain.setBalanceopAmount(ocContractDomain.getDataBmoney());
        pteBalanceopDomain.setOrderOamount(ocContractDomain.getContractInmoney());
        pteBalanceopDomain.setBalanceType("oc");
        pteBalanceopDomain.setMemberCode(ocContractDomain.getMemberBcode());
        pteBalanceopDomain.setMemberName(ocContractDomain.getMemberBname());
        pteBalanceopDomain.setMemberBcode(ocContractDomain.getMemberCcode());
        pteBalanceopDomain.setMemberBname(ocContractDomain.getMemberCname());
        pteBalanceopDomain.setTenantCode(ocContractDomain.getTenantCode());
        pteBalanceopDomain.setBusinessOrderno(ocContractDomain.getContractBbillcode());
        pteBalanceopDomain.setBusinessOrder(ocContractDomain.getContractBillcode());
        pteBalanceopDomain.setBalanceopExtension(JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractDomain));
        this.sendSaveBalanceop(pteBalanceopDomain);
        return "success";
    }

    @Override
    public String sendOccontractRebate(OcContractReDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain) {
            return "error";
        }
        List<OcContractSettlDomain> ocContractSettlList = ocContractDomain.getOcContractSettlList();
        if (ListUtil.isEmpty(ocContractSettlList)) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.sendOccontractRebate ", (Object)("ocContractSettlList is null-" + ocContractDomain.getContractBillcode()));
            return "success";
        }
        BigDecimal balanceopAmount = BigDecimal.ZERO;
        String userinfoOcde = "";
        for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlList) {
            if ("RebateNum".equals(ocContractSettlDomain.getContractSettlBlance())) {
                balanceopAmount = ocContractSettlDomain.getContractSettlGmoney();
            }
            if (!"UserinfoOcode".equals(ocContractSettlDomain.getContractSettlBlance())) continue;
            userinfoOcde = ocContractSettlDomain.getContractSettlOpemo();
        }
        if (StringUtils.isBlank((String)userinfoOcde)) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.sendOccontractRebate ", (Object)"userinfoOcde is null");
            return "success";
        }
        PteBalanceopDomain pteBalanceopDomain = new PteBalanceopDomain();
        pteBalanceopDomain.setBalanceopAmount(balanceopAmount);
        pteBalanceopDomain.setOrderOamount(ocContractDomain.getContractInmoney());
        pteBalanceopDomain.setOrderPrice(ocContractDomain.getContractMoney());
        pteBalanceopDomain.setBalanceType("rebate");
        pteBalanceopDomain.setMemberCode(ocContractDomain.getMemberCode());
        pteBalanceopDomain.setMemberName(ocContractDomain.getMemberName());
        pteBalanceopDomain.setMemberBcode(ocContractDomain.getMemberBcode());
        pteBalanceopDomain.setMemberBname(ocContractDomain.getMemberBname());
        pteBalanceopDomain.setTenantCode(ocContractDomain.getTenantCode());
        pteBalanceopDomain.setBusinessOrderno(ocContractDomain.getContractBbillcode());
        pteBalanceopDomain.setBusinessOrder(ocContractDomain.getContractBillcode());
        pteBalanceopDomain.setBalanceopExtension(JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractDomain));
        pteBalanceopDomain.setBalanceBank("1");
        pteBalanceopDomain.setPtradeType("06");
        pteBalanceopDomain.setOpuserCode(userinfoOcde);
        this.sendSaveBalanceopRebate(pteBalanceopDomain);
        return "success";
    }

    @Override
    public String sendBalanceRefundSupper(OcRefundReDomain ocRefundDomain) throws ApiException {
        List opGoodsDOList;
        if (null == ocRefundDomain) {
            return "error";
        }
        this.logger.debug("pte.PteBalanceBaseServiceImplsendBalanceRefundSupper.param", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        Map<String, PteBalanceopGoods> pteBalanceopGoodsMap = this.pteBalanceBaseServiceBiz.getRefundPlatDIv(ocRefundDomain);
        if (null == pteBalanceopGoodsMap || pteBalanceopGoodsMap.isEmpty()) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.sendBalanceRefundSupper.pteBalanceopGoodsMap");
        }
        if (ListUtil.isEmpty(opGoodsDOList = PteBalanceBaseConvert.refundOpGoodsDTO2DO(ocRefundDomain, pteBalanceopGoodsMap))) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.sendBalanceRefundSupper.opGoodsDOList");
            return "error";
        }
        List<PteBalanceopPmgoodsDomain> opPmGoodsDOList = PteBalanceBaseConvert.refundOpPmGoodsDTO2DO(ocRefundDomain.getOcRefundGoodsDomainList());
        this.calculatePromotionCost(opPmGoodsDOList);
        HashMap<String, ArrayList<PteBalanceopGoodsDomain>> opGoodsDOListMap = new HashMap<String, ArrayList<PteBalanceopGoodsDomain>>();
        for (PteBalanceopGoodsDomain pteBalanceopGoodsDomain : opGoodsDOList) {
            ArrayList<PteBalanceopGoodsDomain> opGoodsDOListCcode = (ArrayList<PteBalanceopGoodsDomain>)opGoodsDOListMap.get(pteBalanceopGoodsDomain.getMemberCcode());
            if (null == opGoodsDOListCcode) {
                opGoodsDOListCcode = new ArrayList<PteBalanceopGoodsDomain>();
                opGoodsDOListMap.put(pteBalanceopGoodsDomain.getMemberCcode(), opGoodsDOListCcode);
            }
            opGoodsDOListCcode.add(pteBalanceopGoodsDomain);
        }
        for (String key : opGoodsDOListMap.keySet()) {
            opGoodsDOList = (List)opGoodsDOListMap.get(key);
            PteBalanceopDomain opDo = PteBalanceBaseConvert.refundOpDTO2DO(ocRefundDomain, opPmGoodsDOList, opGoodsDOList, true);
            this.setYZFInfo(opDo, opDo.getRefundOrderCode(), DicPaypdCodeEnum.PD09.getCode());
            opDo.setGmtPaid(null);
            opDo.setDataState(PteConstants.BalanceopData_State2);
            try {
                List<PteChannelsend> pteBalancelist = this.pteBalanceCore.refundBalanceSave(pteBalanceopGoodsMap, opGoodsDOList, opPmGoodsDOList, opDo, true);
                if (!ListUtil.isNotEmpty(pteBalancelist)) continue;
                PteChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PteChannelsendServiceImpl.getSendService(), pteBalancelist));
            }
            catch (Exception e) {
                throw new ApiException("pte.PteBalanceBaseServiceImplsendBalanceRefundSupper.e", ocRefundDomain.getRefundCode(), (Throwable)e);
            }
        }
        this.logger.debug("pte.PteBalanceBaseServiceImplsendBalanceRefundSupper.success", (Object)ocRefundDomain.getRefundCode());
        return "success";
    }

    @Override
    public String sendBalanceRefund(OcRefundReDomain ocRefundDomain) throws ApiException {
        if (null == ocRefundDomain) {
            return "error";
        }
        this.logger.debug("sendBalanceRefund\u53cd\u4ea4\u6613\u5165\u53c2\uff1a" + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        Map<String, PteBalanceopGoods> pteBalanceopGoodsMap = this.pteBalanceBaseServiceBiz.getRefundPlatDIv(ocRefundDomain);
        if (null == pteBalanceopGoodsMap || pteBalanceopGoodsMap.isEmpty()) {
            this.logger.error("Querry pteBalanceopGoods is null");
            return "error";
        }
        List<PteBalanceopGoodsDomain> opGoodsDOList = PteBalanceBaseConvert.refundOpGoodsDTO2DO(ocRefundDomain, pteBalanceopGoodsMap);
        List<PteBalanceopPmgoodsDomain> opPmGoodsDOList = PteBalanceBaseConvert.refundOpPmGoodsDTO2DO(ocRefundDomain.getOcRefundGoodsDomainList());
        this.calculatePromotionCost(opPmGoodsDOList);
        PteBalanceopDomain opDo = PteBalanceBaseConvert.refundOpDTO2DO(ocRefundDomain, opPmGoodsDOList, opGoodsDOList, false);
        this.setYZFInfo(opDo, opDo.getRefundOrderCode(), DicPaypdCodeEnum.PD09.getCode());
        opDo.setGmtPaid(null);
        opDo.setDataState(PteConstants.BalanceopData_State2);
        try {
            List<PteChannelsend> pteBalancelist = this.pteBalanceCore.refundBalanceSave(pteBalanceopGoodsMap, opGoodsDOList, opPmGoodsDOList, opDo, true);
            if (ListUtil.isNotEmpty(pteBalancelist)) {
                PteChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PteChannelsendServiceImpl.getSendService(), pteBalancelist));
            }
        }
        catch (Exception e) {
            throw new ApiException("Failed to save BalanceRefund, refund saved rollback, refundCode:{}", ocRefundDomain.getRefundCode(), (Throwable)e);
        }
        this.logger.debug("sendBalanceRefund success,refundCode:", (Object)ocRefundDomain.getRefundCode());
        return "success";
    }

    private void calculatePromotionCost(List<PteBalanceopPmgoodsDomain> opPmGoodsDOList) {
        if (null == opPmGoodsDOList) {
            return;
        }
        block0: for (PteBalanceopPmgoodsDomain pmDO : opPmGoodsDOList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (null == pmDO) continue;
            map.put("contractGoodsCode", pmDO.getContractGoodsCode());
            map.put("contractSettlOpno", pmDO.getContractSettlOpno());
            QueryResult<PteBalanceopPmgoodslist> result = this.pteBalanceopPmgoodslistService.queryBalanceopPmgoodslistPage(map);
            if (null == result || !ListUtil.isNotEmpty((Collection)result.getList())) continue;
            for (PteBalanceopPmgoodslist pmGoodsList : result.getList()) {
                if (!PromotionSavgEnum.PLAT.getCode().equals(pmGoodsList.getPromotionSavgOtype())) continue;
                pmDO.setOrderPlatAmt(pmDO.getContractSettlPmoney().multiply(pmGoodsList.getPromotionSavgRa()).divide(BigDecimal.valueOf(100L), 2, RoundingMode.DOWN));
                pmDO.setOrderMerAmt(pmDO.getContractSettlPmoney().subtract(pmDO.getOrderPlatAmt()));
                pmDO.setContractPmode(pmGoodsList.getContractPmode());
                log.debug("GoodsCode:{},\u5546\u5bb6\u5206\u644a\uff1a{}\uff0c\u5e73\u53f0\u5206\u644a\uff1a{}", new Object[]{pmDO.getContractGoodsCode(), pmDO.getOrderMerAmt(), pmDO.getOrderPlatAmt()});
                continue block0;
            }
        }
    }

    @Override
    public String sendBalance(OcContractReDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain || StringUtils.isBlank((String)ocContractDomain.getMemberCode())) {
            log.error("pte.PteBalanceBaseServiceImpl.sendBalance.null");
            return "error";
        }
        String msg = this.pteBalanceBaseServiceBiz.sendBalance(ocContractDomain, false);
        if (StringUtils.isBlank((String)msg)) {
            return "error";
        }
        return "success";
    }

    @Override
    public String sendBalanceBySupperToAmt(OcContractReDomain ocContractDomain) throws ApiException {
        List<OcContractGoodsDomain> supplierList;
        if (null == ocContractDomain || StringUtils.isBlank((String)ocContractDomain.getMemberCode()) || ListUtil.isEmpty(ocContractDomain.getPackageList())) {
            log.error("pte.PteBalanceBaseServiceImpl.sendBalanceBySupperToAmt.null");
            return "error";
        }
        HashMap<String, ArrayList<OcContractGoodsDomain>> supplierMap = new HashMap<String, ArrayList<OcContractGoodsDomain>>();
        for (OcPackageDomain ocPackageDomain : ocContractDomain.getPackageList()) {
            for (OcContractGoodsDomain ocContractGoodsDomain : ocPackageDomain.getContractGoodsList()) {
                supplierList = (List)supplierMap.get(ocContractGoodsDomain.getMemberCcode());
                if (null == supplierList) {
                    supplierList = new ArrayList<OcContractGoodsDomain>();
                    supplierMap.put(ocContractGoodsDomain.getMemberCcode(), (ArrayList<OcContractGoodsDomain>)supplierList);
                }
                supplierList.add(ocContractGoodsDomain);
            }
        }
        ArrayList<OcContractReDomain> supplierOcContractDomainList = new ArrayList<OcContractReDomain>();
        for (String key : supplierMap.keySet()) {
            supplierList = (ArrayList<OcContractGoodsDomain>)supplierMap.get(key);
            BigDecimal dataMoney = BigDecimal.ZERO;
            BigDecimal num = BigDecimal.ZERO;
            BigDecimal weight = BigDecimal.ZERO;
            OcContractReDomain supplierOcContractDomain = new OcContractReDomain();
            try {
                BeanUtils.copyAllPropertys((Object)supplierOcContractDomain, (Object)ocContractDomain);
            }
            catch (Exception exception) {
                // empty catch block
            }
            supplierOcContractDomainList.add(supplierOcContractDomain);
            for (OcContractGoodsDomain ocContractGoodsDomain : supplierList) {
                if (null == ocContractGoodsDomain.getPricesetNprice1()) {
                    ocContractGoodsDomain.setPricesetNprice1(BigDecimal.ZERO);
                }
                if (null == ocContractGoodsDomain.getGoodsCamount()) {
                    ocContractGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
                }
                if (null == ocContractGoodsDomain.getGoodsCweight()) {
                    ocContractGoodsDomain.setGoodsCweight(BigDecimal.ZERO);
                }
                dataMoney = dataMoney.add(ocContractGoodsDomain.getGoodsCamount().multiply(ocContractGoodsDomain.getPricesetNprice1()));
                num = num.add(ocContractGoodsDomain.getGoodsCamount());
                weight = weight.add(ocContractGoodsDomain.getGoodsCweight());
                supplierOcContractDomain.setMemberCode(ocContractGoodsDomain.getMemberCcode());
                supplierOcContractDomain.setMemberCname(ocContractGoodsDomain.getMemberCname());
            }
            supplierOcContractDomain.setDataBmoney(dataMoney);
            supplierOcContractDomain.setDataBnum(num);
            supplierOcContractDomain.setDataBweight(weight);
            ArrayList<OcPackageDomain> packageList = new ArrayList<OcPackageDomain>();
            OcPackageDomain ocPackageDomain = new OcPackageDomain();
            ocPackageDomain.setContractGoodsList(supplierList);
            packageList.add(ocPackageDomain);
            supplierOcContractDomain.setPackageList(packageList);
        }
        List<PteChannelsend> pteBalancelist = this.pteBalanceBaseBusService.saveBalanceBatch(supplierOcContractDomainList, true, true);
        if (ListUtil.isNotEmpty(pteBalancelist)) {
            PteChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PteChannelsendServiceImpl.getSendService(), pteBalancelist));
        }
        return "success";
    }

    @Override
    public String sendBalanceToAmt(OcContractReDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain || StringUtils.isBlank((String)ocContractDomain.getMemberCode())) {
            log.error("pte.PteBalanceBaseServiceImpl.sendBalanceToAmt.null");
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ocContractDomain.getTenantCode());
        map.put("businessOrder", ocContractDomain.getContractBillcode());
        map.put("balanceType", BusinessTypeEnum.OC_ORDER.getCode());
        QueryResult<PteBalanceop> queryResult = this.pteBalanceopService.queryBalanceopPage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            ArrayList<OcContractReDomain> ocContractDomainList = new ArrayList<OcContractReDomain>();
            ocContractDomainList.add(ocContractDomain);
            List<PteChannelsend> pteBalancelist = this.pteBalanceBaseBusService.saveBalanceBatch(ocContractDomainList, true, false);
            if (ListUtil.isNotEmpty(pteBalancelist)) {
                PteChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PteChannelsendServiceImpl.getSendService(), pteBalancelist));
            }
            return "success";
        }
        return this.sendBalanceopToBalanceamt((PteBalanceop)queryResult.getList().get(0), map);
    }

    @Override
    public String sendBalanceToOk(OcContractReDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain || StringUtils.isBlank((String)ocContractDomain.getMemberCode())) {
            log.error("pte.PteBalanceBaseServiceImpl.sendBalanceToOk.null");
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ocContractDomain.getTenantCode());
        map.put("businessOrder", ocContractDomain.getContractBillcode());
        map.put("balanceType", BusinessTypeEnum.OC_ORDER.getCode());
        QueryResult<PteBalanceop> queryResult = this.pteBalanceopService.queryBalanceopPage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            ArrayList<OcContractReDomain> ocContractDomainList = new ArrayList<OcContractReDomain>();
            ocContractDomainList.add(ocContractDomain);
            List<PteChannelsend> pteBalancelist = this.pteBalanceBaseBusService.saveBalanceOk(ocContractDomainList, false);
            if (ListUtil.isNotEmpty(pteBalancelist)) {
                PteChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PteChannelsendServiceImpl.getSendService(), pteBalancelist));
            }
            return "success";
        }
        this.pteBalanceopService.updateBalanceopStateByCode(((PteBalanceop)queryResult.getList().get(0)).getTenantCode(), ((PteBalanceop)queryResult.getList().get(0)).getBalanceopCode(), PteConstants.BalanceopData_State1, ((PteBalanceop)queryResult.getList().get(0)).getDataState(), map);
        return "success";
    }

    @Override
    public String sendBalanceSgSendgoodsBySupperToAmt(SgSendgoodsReDomain sgSendgoodsDomain) throws ApiException {
        if (null == sgSendgoodsDomain || StringUtils.isBlank((String)sgSendgoodsDomain.getMemberCcode())) {
            log.error("pte.PteBalanceBaseServiceImpl.sendBalanceSgSendgoodsBySupperToAmt.null");
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", sgSendgoodsDomain.getTenantCode());
        map.put("businessOrder", sgSendgoodsDomain.getSendgoodsCode());
        map.put("balanceType", BusinessTypeEnum.OC_SENDSUPPER.getCode());
        QueryResult<PteBalanceop> queryResult = this.pteBalanceopService.queryBalanceopPage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            String balanceopCode = this.pteBalanceBaseServiceBiz.sendBalance(sgSendgoodsDomain, true);
            if (StringUtils.isBlank((String)balanceopCode)) {
                log.error("pte.PteBalanceBaseServiceImpl.sendBalanceSgSendgoodsBySupperToAmt.balanceopCode");
                return "error";
            }
            return this.sendBalanceAmt(balanceopCode, sgSendgoodsDomain.getTenantCode(), null);
        }
        return this.sendBalanceopToBalanceamt((PteBalanceop)queryResult.getList().get(0), map);
    }

    @Override
    public String sendBalanceSgSendgoodsBySupper(SgSendgoodsReDomain sgSendgoodsDomain) throws ApiException {
        if (null == sgSendgoodsDomain || StringUtils.isBlank((String)sgSendgoodsDomain.getMemberCcode())) {
            log.error("pte.PteBalanceBaseServiceImpl.sendBalanceSgSendgoodsBySupper.null");
            return "error";
        }
        String msg = this.pteBalanceBaseServiceBiz.sendBalance(sgSendgoodsDomain, true);
        if (StringUtils.isBlank((String)msg)) {
            return "error";
        }
        return "success";
    }

    @Override
    public String sendBalanceSgSendgoods(SgSendgoodsReDomain sgSendgoodsDomain) throws ApiException {
        if (null == sgSendgoodsDomain || StringUtils.isBlank((String)sgSendgoodsDomain.getMemberCode())) {
            log.error("pte.PteBalanceBaseServiceImpl.sendBalanceSgSendgoods.null");
            return "error";
        }
        String msg = this.pteBalanceBaseServiceBiz.sendBalance(sgSendgoodsDomain, false);
        if (StringUtils.isBlank((String)msg)) {
            return "error";
        }
        return "success";
    }

    @Override
    public String sendBalanceSgSendgoodsToAmt(SgSendgoodsReDomain sgSendgoodsDomain) throws ApiException {
        if (null == sgSendgoodsDomain || StringUtils.isBlank((String)sgSendgoodsDomain.getMemberCode())) {
            log.error("pte.PteBalanceBaseServiceImpl.sendBalanceSgSendgoodsToAmt.null");
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", sgSendgoodsDomain.getTenantCode());
        map.put("businessOrder", sgSendgoodsDomain.getSendgoodsCode());
        map.put("balanceType", BusinessTypeEnum.OC_SEND.getCode());
        QueryResult<PteBalanceop> queryResult = this.pteBalanceopService.queryBalanceopPage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            String balanceopCode = this.pteBalanceBaseServiceBiz.sendBalance(sgSendgoodsDomain, false);
            if (StringUtils.isBlank((String)balanceopCode)) {
                log.error("pte.PteBalanceBaseServiceImpl.sendBalanceSgSendgoodsToAmt.balanceopCode");
                return "error";
            }
            return this.sendBalanceAmt(balanceopCode, sgSendgoodsDomain.getTenantCode(), null);
        }
        return this.sendBalanceopToBalanceamt((PteBalanceop)queryResult.getList().get(0), map);
    }

    @Override
    public String sendBalanceStart(OcContractReDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain) {
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ocContractDomain.getTenantCode());
        map.put("businessOrder", ocContractDomain.getContractBillcode());
        map.put("balanceType", BusinessTypeEnum.OC_ORDER.getCode());
        map.put("dataState", String.valueOf(PteConstants.BalanceopData_State0));
        QueryResult<PteBalanceop> queryResult = this.pteBalanceopService.queryBalanceopPage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            return "error";
        }
        PteBalanceop pteBalanceop = (PteBalanceop)queryResult.getList().get(0);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String balanceopExtensionStr = this.getBalanceopExtensionStr(pteBalanceop, ocContractDomain);
        if (StringUtils.isNotBlank((String)balanceopExtensionStr)) {
            paramMap.put("balanceopExtension", balanceopExtensionStr);
        }
        this.pteBalanceopService.updateBalanceopState(pteBalanceop.getBalanceopId(), PteConstants.BalanceopData_State1, pteBalanceop.getDataState(), paramMap);
        return "success";
    }

    private String getBalanceopExtensionStr(PteBalanceop pteBalanceop, OcContractReDomain ocContractDomain) {
        String balanceopExtension = pteBalanceop.getBalanceopExtension();
        String balanceopExtensionStr = "";
        if (StringUtils.isNotBlank((String)balanceopExtension)) {
            HashMap<String, String> balanceopExtensionMap = JsonUtil.buildNormalBinder().getJsonToMap(balanceopExtension, String.class, Object.class);
            if (null == balanceopExtensionMap) {
                balanceopExtensionMap = new HashMap<String, String>();
            }
            balanceopExtensionMap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
            balanceopExtensionStr = JsonUtil.buildNormalBinder().toJson(balanceopExtensionMap);
        }
        return balanceopExtensionStr;
    }

    @Override
    public void queryBalanceJob() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("balanceType", BusinessTypeEnum.OC_ORDER.getCode());
        map.put("gmtPaidQend", new Date());
        map.put("dataState", String.valueOf(PteConstants.BalanceopData_State2));
        QueryResult<PteBalanceop> queryResult = this.pteBalanceopService.queryBalanceopPage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            return;
        }
        for (PteBalanceop pteBalanceop : queryResult.getList()) {
            this.pteBalanceopService.updateBalanceopState(pteBalanceop.getBalanceopId(), PteConstants.BalanceopData_State3, pteBalanceop.getDataState(), null);
        }
    }

    @Override
    public String sendBalanceEnd(OcContractReDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain) {
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ocContractDomain.getTenantCode());
        map.put("businessOrder", ocContractDomain.getContractBillcode());
        map.put("balanceType", BusinessTypeEnum.OC_ORDER.getCode());
        QueryResult<PteBalanceop> queryResult = this.pteBalanceopService.queryBalanceopPage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList()) || queryResult.getList().size() > 1) {
            return "error";
        }
        PteBalanceop pteBalanceop = (PteBalanceop)queryResult.getList().get(0);
        BigDecimal balanceopFee = pteBalanceop.getBalanceopFee();
        if (null == balanceopFee) {
            balanceopFee = BigDecimal.ZERO;
        }
        PteBalanceopDomain pteBalanceopDomain = new PteBalanceopDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pteBalanceopDomain, (Object)pteBalanceop);
        }
        catch (Exception e) {
            this.logger.error("pte.PteBalanceBaseServiceImpl.sendBalanceEnd.makeBalanceOp:", (Throwable)e);
        }
        if (null == pteBalanceop.getBalanceopFee()) {
            pteBalanceop.setBalanceopFee(BigDecimal.ZERO);
        }
        if (pteBalanceop.getBalanceopFee().compareTo(balanceopFee) != 0) {
            pteBalanceop.setBalanceopFee(balanceopFee);
        }
        pteBalanceopDomain.setTenantCode(ocContractDomain.getTenantCode());
        pteBalanceopDomain.setBusinessOrder(ocContractDomain.getContractBillcode());
        pteBalanceopDomain.setBusinessOrderno(ocContractDomain.getContractBbillcode());
        this.setYZFInfo(pteBalanceopDomain, pteBalanceopDomain.getBusinessOrderno(), DicPaypdCodeEnum.PD01.getCode());
        if (pteBalanceopDomain.getGmtPaid() == null && ocContractDomain.getPtradeSeqno() != null) {
            HashMap<String, Object> pteMap = new HashMap<String, Object>();
            pteMap.put("ptradeSeqno", ocContractDomain.getPtradeSeqno());
            pteMap.put("tenantCode", ocContractDomain.getTenantCode());
            QueryResult<PtePtrade> ptePtradeQueryResult = this.ptePtradeService.queryPtradePage(pteMap);
            if (ptePtradeQueryResult != null && !ptePtradeQueryResult.getList().isEmpty()) {
                PtePtrade ptePtrade = (PtePtrade)ptePtradeQueryResult.getList().get(0);
                pteBalanceopDomain.setGmtPaid(ptePtrade.getGmtPaid());
            }
        }
        this.pteBalanceopService.updateBalanceop(pteBalanceopDomain);
        HashMap<String, Object> stateMap = new HashMap<String, Object>();
        String balanceopExtensionStr = this.getBalanceopExtensionStr(pteBalanceop, ocContractDomain);
        if (StringUtils.isNotBlank((String)balanceopExtensionStr)) {
            stateMap.put("ocContractDomain", balanceopExtensionStr);
        }
        stateMap.put("GmtModified", new Date());
        this.pteBalanceopService.updateBalanceopState(pteBalanceop.getBalanceopId(), PteConstants.BalanceopData_State2, pteBalanceop.getDataState(), stateMap);
        return "success";
    }

    private static Date getDate(int day) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, day);
        return c.getTime();
    }

    @Override
    public QueryResult<QueryBalanceBatchResDTO> queryBalanceBatch(QueryBalanceBatchReqDTO queryBalanceBatchReqDTO) {
        QueryResult result = new QueryResult();
        this.logger.info("queryBalanceBatch \u5165\u53c2\uff1a" + JsonUtil.buildNormalBinder().toJson((Object)queryBalanceBatchReqDTO));
        QueryResult<PteBalanceop> opRes = this.pteBalanceBaseServiceBiz.pteBalanceOpQuery(queryBalanceBatchReqDTO);
        if (null == opRes) {
            this.logger.info("\u67e5\u8be2op\u7ed3\u679c\u4e3a\u7a7a");
            result.setList(new ArrayList());
            SupPageTools supPageTools = new SupPageTools();
            supPageTools.setPageSize(queryBalanceBatchReqDTO.getPageSize().intValue());
            supPageTools.setPageNo(queryBalanceBatchReqDTO.getCurrentPage().intValue());
            supPageTools.setRecordCount(0);
            result.setPageTools(supPageTools);
            return result;
        }
        List<String> billCodeList = PteBalanceBaseConvert.getBillCodeList(opRes.getList());
        List<PteBalanceopGoods> opGoodsRes = this.pteBalanceBaseServiceBiz.pteBalanceOpGoodsQuery(billCodeList);
        List<PteBalanceopPmgoods> opPmGoodsRes = this.pteBalanceBaseServiceBiz.pteBalanceOpPmGoodsQuery(billCodeList);
        List<QueryBalanceBatchResDTO> queryBalanceBatchResDTOS = PteBalanceBaseConvert.convertQueryBO2DTO(opRes.getList(), opGoodsRes, opPmGoodsRes);
        result.setList(queryBalanceBatchResDTOS);
        opRes.getPageTools().setPageSize(queryBalanceBatchReqDTO.getPageSize().intValue());
        opRes.getPageTools().setPageNo(queryBalanceBatchReqDTO.getCurrentPage().intValue());
        result.setPageTools(opRes.getPageTools());
        System.out.println("queryBalanceBatch \u51fa\u53c2\uff1a" + JsonUtil.buildNormalBinder().toJson((Object)result));
        return result;
    }

    @Override
    public QueryResult<QueryBalanceBatchResDTO> exportBalanceBatch(Map<String, Object> map) {
        log.info("exportBalanceBatch\u5165\u53c2\uff1a{}", map);
        QueryBalanceBatchReqDTO queryBalanceBatchReqDTO = new QueryBalanceBatchReqDTO();
        queryBalanceBatchReqDTO.setMemberCode((String)map.get("memberCode"));
        queryBalanceBatchReqDTO.setBusinessType((String)map.get("businessType"));
        queryBalanceBatchReqDTO.setShoppingCartOrderNo((String)map.get("shoppingCartOrderNo"));
        queryBalanceBatchReqDTO.setBusinessOrder((String)map.get("businessOrder"));
        queryBalanceBatchReqDTO.setYzfOrderNo((String)map.get("yzfOrderNo"));
        queryBalanceBatchReqDTO.setBuyerMobileNum((String)map.get("buyerMobileNum"));
        queryBalanceBatchReqDTO.setOperator((String)map.get("operator"));
        queryBalanceBatchReqDTO.setCurrentPage((Integer)map.get("page"));
        queryBalanceBatchReqDTO.setPageSize((Integer)map.get("rows"));
        try {
            Date startDate = new Date();
            Date endDate = new Date();
            Date operationTimeDate = new Date();
            if (null != map.get("startDate")) {
                startDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse((String)map.get("startDate"));
                queryBalanceBatchReqDTO.setStartDate(startDate);
            }
            if (null != map.get("endDate")) {
                endDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse((String)map.get("endDate"));
                queryBalanceBatchReqDTO.setEndDate(endDate);
            }
            if (null != map.get("operationTime")) {
                operationTimeDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse((String)map.get("operationTime"));
                queryBalanceBatchReqDTO.setOperationTime(operationTimeDate);
            }
        }
        catch (Exception e) {
            log.info("exportBalanceBatch\u8f6c\u6362\u65e5\u671f\u5931\u8d25\uff1a{}", (Throwable)e);
        }
        QueryResult<QueryBalanceBatchResDTO> result = this.queryBalanceBatch(queryBalanceBatchReqDTO);
        this.logger.info("exportBalanceBatch\u5165\u53c2\uff1a" + result);
        return result;
    }

    @Override
    public String sendUpdateBalance(PteBalanceopDomain pteBalanceopDomain) {
        return this.pteBalanceopService.updateBalanceopToBalance(pteBalanceopDomain);
    }

    @Override
    public String sendSaveBalanceopToBalancelistBatch(List<String> balanceopCodeList, String tenantCode, Map<String, Object> map) throws ApiException {
        List<PteChannelsend> pteBalancelist = this.pteBalanceopService.saveBalanceopToBalancelistBatch(balanceopCodeList, tenantCode, map);
        if (ListUtil.isNotEmpty(pteBalancelist)) {
            PteChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(PteChannelsendServiceImpl.getSendService(), pteBalancelist));
        }
        return "success";
    }

    @Override
    public String sendUpdateBalanceopStateByBachCode(List<String> balanceopCodeList, String tenantCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.pteBalanceopService.updateBalanceopStateByBachCode(balanceopCodeList, tenantCode, dataState, oldDataState, map);
        return "success";
    }
}

