/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pg.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pg.dao.PgGconfirmMapper;
import com.yqbsoft.laser.service.pg.domain.PgConditionDomain;
import com.yqbsoft.laser.service.pg.domain.PgGcfmgoodsDomain;
import com.yqbsoft.laser.service.pg.domain.PgGcfmpackimgsDomain;
import com.yqbsoft.laser.service.pg.domain.PgGcfmpacksizeDomain;
import com.yqbsoft.laser.service.pg.domain.PgGconfirmDomain;
import com.yqbsoft.laser.service.pg.domain.PgGconfirmReDomain;
import com.yqbsoft.laser.service.pg.model.PgGConfirmByCondtion;
import com.yqbsoft.laser.service.pg.model.PgGconfirm;
import com.yqbsoft.laser.service.pg.service.PgGcfmgoodsService;
import com.yqbsoft.laser.service.pg.service.PgGcfmpackimgsService;
import com.yqbsoft.laser.service.pg.service.PgGcfmpacksizeService;
import com.yqbsoft.laser.service.pg.service.PgGconfirmService;
import com.yqbsoft.laser.service.pg.tool.PickUtils;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PgGconfirmServiceImpl
extends BaseServiceImpl
implements PgGconfirmService {
    private static final String SYS_CODE = "pg.PICK.PgGconfirmServiceImpl";
    private PgGconfirmMapper pgGconfirmMapper;
    private PgGcfmpackimgsService pgGcfmpackimgsService;
    private PgGcfmpacksizeService pgGcfmpacksizeService;
    private PgGcfmgoodsService pgGcfmgoodsService;

    public void setPgGcfmpacksizeService(PgGcfmpacksizeService pgGcfmpacksizeService) {
        this.pgGcfmpacksizeService = pgGcfmpacksizeService;
    }

    public void setPgGcfmgoodsService(PgGcfmgoodsService pgGcfmgoodsService) {
        this.pgGcfmgoodsService = pgGcfmgoodsService;
    }

    public void setPgGcfmpackimgsService(PgGcfmpackimgsService pgGcfmpackimgsService) {
        this.pgGcfmpackimgsService = pgGcfmpackimgsService;
    }

    public void setPgGconfirmMapper(PgGconfirmMapper pgGconfirmMapper) {
        this.pgGconfirmMapper = pgGconfirmMapper;
    }

    private Date getSysDate() {
        try {
            return this.pgGconfirmMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGconfirmServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGconfirm(PgGconfirmDomain pgGconfirmDomain) {
        if (null == pgGconfirmDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pgGconfirmDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGconfirmDefault(PgGconfirm pgGconfirm) {
        if (null == pgGconfirm) {
            return;
        }
        if (null == pgGconfirm.getDataState()) {
            pgGconfirm.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pgGconfirm.getGmtCreate()) {
            pgGconfirm.setGmtCreate(date);
        }
        pgGconfirm.setGmtModified(date);
        if (StringUtils.isBlank((String)pgGconfirm.getGconfirmCode())) {
            pgGconfirm.setGconfirmCode(this.getNo(null, "PgGconfirm", "pgGconfirm", pgGconfirm.getTenantCode()));
        }
    }

    private int getGconfirmMaxCode() {
        int code = 0;
        try {
            return this.pgGconfirmMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGconfirmServiceImpl.getGconfirmMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGconfirmUpdataDefault(PgGconfirm pgGconfirm) {
        if (null == pgGconfirm) {
            return;
        }
        pgGconfirm.setGmtModified(this.getSysDate());
    }

    private void saveGconfirmModel(PgGconfirm pgGconfirm) throws ApiException {
        if (null == pgGconfirm) {
            return;
        }
        try {
            this.pgGconfirmMapper.insertSelective(pgGconfirm);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGconfirmServiceImpl.saveGconfirmModel.ex", (Throwable)e);
        }
    }

    private void saveGconfirmBatchModel(List<PgGconfirm> pgGconfirmList) throws ApiException {
        if (null == pgGconfirmList || pgGconfirmList.isEmpty()) {
            return;
        }
        try {
            this.pgGconfirmMapper.insertBatch(pgGconfirmList);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGconfirmServiceImpl.saveGconfirmBatchModel.ex", (Throwable)e);
        }
    }

    private PgGconfirm getGconfirmModelById(Integer gconfirmId) {
        if (null == gconfirmId) {
            return null;
        }
        try {
            return this.pgGconfirmMapper.selectByPrimaryKey(gconfirmId);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGconfirmServiceImpl.getGconfirmModelById", (Throwable)e);
            return null;
        }
    }

    private PgGconfirm getGconfirmModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pgGconfirmMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGconfirmServiceImpl.getGconfirmModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGconfirmModelByCode(Map<String, Object> map) {
        int i = 0;
        if (null == map || map.isEmpty()) {
            this.logger.error("pg.PICK.PgGconfirmServiceImpl.delGconfirmModelByCode", (Object)"params is null");
            return;
        }
        try {
            i = this.pgGconfirmMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGconfirmServiceImpl.delGconfirmModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgGconfirmServiceImpl.delGconfirmModelByCode.num");
        }
    }

    private void deleteGconfirmModel(Integer gconfirmId) throws ApiException {
        if (null == gconfirmId) {
            return;
        }
        int i = 0;
        try {
            i = this.pgGconfirmMapper.deleteByPrimaryKey(gconfirmId);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGconfirmServiceImpl.deleteGconfirmModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgGconfirmServiceImpl.deleteGconfirmModel.num");
        }
    }

    private void updateGconfirmModel(PgGconfirm pgGconfirm) throws ApiException {
        if (null == pgGconfirm) {
            return;
        }
        int i = 0;
        try {
            i = this.pgGconfirmMapper.updateByPrimaryKey(pgGconfirm);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGconfirmServiceImpl.updateGconfirmModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgGconfirmServiceImpl.updateGconfirmModel.num");
        }
    }

    private void updateStateGconfirmModel(Integer gconfirmId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == gconfirmId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gconfirmId", gconfirmId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgGconfirmMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGconfirmServiceImpl.updateStateGconfirmModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgGconfirmServiceImpl.updateStateGconfirmModel.null");
        }
    }

    private void updateStateGconfirmModelByCode(String tenantCode, String gconfirmCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)gconfirmCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("gconfirmCode", gconfirmCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgGconfirmMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGconfirmServiceImpl.updateStateGconfirmModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgGconfirmServiceImpl.updateStateGconfirmModelByCode.null");
        }
    }

    private PgGconfirm makeGconfirm(PgGconfirmDomain pgGconfirmDomain, PgGconfirm pgGconfirm) {
        if (null == pgGconfirmDomain) {
            return null;
        }
        if (null == pgGconfirm) {
            pgGconfirm = new PgGconfirm();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pgGconfirm, (Object)pgGconfirmDomain);
            return pgGconfirm;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGconfirmServiceImpl.makeGconfirm", (Throwable)e);
            return null;
        }
    }

    private PgGconfirmReDomain makePgGconfirmReDomain(PgGconfirm pgGconfirm) {
        if (null == pgGconfirm) {
            return null;
        }
        PgGconfirmReDomain pgGconfirmReDomain = new PgGconfirmReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pgGconfirmReDomain, (Object)pgGconfirm);
            return pgGconfirmReDomain;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGconfirmServiceImpl.makePgGconfirmReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PgGconfirm> queryGconfirmModelPage(Map<String, Object> parammap) {
        try {
            return this.pgGconfirmMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGconfirmServiceImpl.queryGconfirmModel", (Throwable)e);
            return null;
        }
    }

    private int countGconfirm(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pgGconfirmMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGconfirmServiceImpl.countGconfirm", (Throwable)e);
        }
        return i;
    }

    private int countGconfirmOrgoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pgGconfirmMapper.countGconfirmOrgoods(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGconfirmServiceImpl.countGconfirm", (Throwable)e);
        }
        return i;
    }

    private PgGconfirm createPgGconfirm(PgGconfirmDomain pgGconfirmDomain) {
        String msg = this.checkGconfirm(pgGconfirmDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgGconfirmServiceImpl.saveGconfirm.checkGconfirm", msg);
        }
        PgGconfirm pgGconfirm = this.makeGconfirm(pgGconfirmDomain, null);
        this.setGconfirmDefault(pgGconfirm);
        return pgGconfirm;
    }

    @Override
    public String saveGconfirm(PgGconfirmDomain pgGconfirmDomain) throws ApiException {
        PgGconfirm pgGconfirm = this.createPgGconfirm(pgGconfirmDomain);
        this.saveGconfirmModel(pgGconfirm);
        return pgGconfirm.getGconfirmCode();
    }

    @Override
    public String saveGconfirmBatch(List<PgGconfirmDomain> pgGconfirmDomainList) throws ApiException {
        if (null == pgGconfirmDomainList || pgGconfirmDomainList.isEmpty()) {
            this.logger.error("pg.PICK.PgGconfirmServiceImpl.saveGconfirmBatch", (Object)"params is null");
            return null;
        }
        String code = "";
        this.delGconfirmModelByConditionCode(pgGconfirmDomainList.get(0).getTenantCode(), pgGconfirmDomainList.get(0).getConditionCode());
        ArrayList<PgGcfmgoodsDomain> pgGcfmgoodsDomainLists = new ArrayList<PgGcfmgoodsDomain>(200);
        ArrayList<PgGcfmpacksizeDomain> cfmPackSizeLists = new ArrayList<PgGcfmpacksizeDomain>(10);
        ArrayList<PgGconfirm> pgGconfirmList = new ArrayList<PgGconfirm>(10);
        for (PgGconfirmDomain pgGconfirmDomain : pgGconfirmDomainList) {
            PgGconfirm pgGconfirm = this.createPgGconfirm(pgGconfirmDomain);
            code = pgGconfirm.getGconfirmCode();
            if (ListUtil.isNotEmpty(pgGconfirmDomain.getPgGcfmgoodsDomainList())) {
                for (PgGcfmgoodsDomain pgGcfmgoodsDomain : pgGconfirmDomain.getPgGcfmgoodsDomainList()) {
                    pgGcfmgoodsDomain.setTenantCode(pgGconfirmDomain.getTenantCode());
                    pgGcfmgoodsDomain.setGconfirmCode(code);
                    pgGcfmgoodsDomain.setUserCode(pgGconfirmDomain.getUserCode());
                }
                pgGcfmgoodsDomainLists.addAll(pgGconfirmDomain.getPgGcfmgoodsDomainList());
                Double[] pageSize = PickUtils.calculateGroupPackSize(pgGconfirmDomain.getPgGcfmgoodsDomainList());
                PgGcfmpacksizeDomain cfmPackSize = new PgGcfmpacksizeDomain();
                cfmPackSize.setGcfmpacksizeLength(new BigDecimal(pageSize[0]).setScale(0, 0));
                cfmPackSize.setGcfmpacksizeWide(new BigDecimal(pageSize[1]).setScale(0, 0));
                cfmPackSize.setGcfmpacksizeHigh(new BigDecimal(pageSize[2]).setScale(0, 0));
                cfmPackSize.setTenantCode(pgGconfirmDomain.getTenantCode());
                cfmPackSize.setGconfirmCode(code);
                cfmPackSize.setUserCode(pgGconfirmDomain.getUserCode());
                ArrayList<PgGcfmpacksizeDomain> cfmPackSizeList = new ArrayList<PgGcfmpacksizeDomain>(1);
                cfmPackSizeList.add(cfmPackSize);
                pgGconfirmDomain.setPgGcfmpacksizeDomainList(cfmPackSizeList);
            }
            cfmPackSizeLists.addAll(pgGconfirmDomain.getPgGcfmpacksizeDomainList());
            pgGconfirmList.add(pgGconfirm);
        }
        this.pgGcfmgoodsService.saveGcfmgoodsBatch(pgGcfmgoodsDomainLists);
        this.pgGcfmpacksizeService.saveGcfmpacksizeBatch(cfmPackSizeLists);
        this.saveGconfirmBatchModel(pgGconfirmList);
        return code;
    }

    private void delGconfirmModelByConditionCode(String tenantCode, String conditionCode) {
        if (StringUtils.isBlank((String)conditionCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("pg.PICK.PgGconfirmServiceImpl.delGconfirmModelByConditionCode", (Object)"conditionCode or tenantCode is null");
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("conditionCode", conditionCode);
        this.pgGconfirmMapper.delByConditionCode(map);
    }

    @Override
    public void updateGconfirmState(Integer gconfirmId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == gconfirmId) {
            return;
        }
        this.updateStateGconfirmModel(gconfirmId, dataState, oldDataState, map);
    }

    @Override
    public void updateGconfirmStateByCode(String tenantCode, String gconfirmCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)gconfirmCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateGconfirmModelByCode(tenantCode, gconfirmCode, dataState, oldDataState, map);
    }

    @Override
    public void updateGconfirm(PgGconfirmDomain pgGconfirmDomain) throws ApiException {
        String msg = this.checkGconfirm(pgGconfirmDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgGconfirmServiceImpl.updateGconfirm.checkGconfirm", msg);
        }
        PgGconfirm oldPgGconfirm = this.getGconfirmModelById(pgGconfirmDomain.getGconfirmId());
        if (null == oldPgGconfirm) {
            throw new ApiException("pg.PICK.PgGconfirmServiceImpl.updateGconfirm.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PgGconfirm pgGconfirm = this.makeGconfirm(pgGconfirmDomain, oldPgGconfirm);
        this.setGconfirmUpdataDefault(pgGconfirm);
        this.updateGconfirmModel(pgGconfirm);
    }

    @Override
    public PgGconfirm getGconfirm(Integer gconfirmId) {
        if (null == gconfirmId) {
            return null;
        }
        return this.getGconfirmModelById(gconfirmId);
    }

    @Override
    public void deleteGconfirm(Integer gconfirmId) throws ApiException {
        if (null == gconfirmId) {
            return;
        }
        this.deleteGconfirmModel(gconfirmId);
    }

    @Override
    public QueryResult<PgGconfirm> queryGconfirmPage(Map<String, Object> map) {
        List<PgGconfirm> pgGconfirmList = this.queryGconfirmModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGconfirm(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pgGconfirmList);
        return queryResult;
    }

    @Override
    public PgGconfirm getGconfirmByCode(String tenantCode, String gconfirmCode) throws ApiException {
        if (StringUtils.isBlank((String)gconfirmCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("gconfirmCode", gconfirmCode);
        return this.getGconfirmModelByCode(map);
    }

    @Override
    public void deleteGconfirmByCode(String tenantCode, String gconfirmCode) throws ApiException {
        if (StringUtils.isBlank((String)gconfirmCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("gconfirmCode", gconfirmCode);
        this.delGconfirmModelByCode(map);
    }

    @Override
    public String saveGconfirmByCondition(PgConditionDomain pgConditionDomain) throws ApiException {
        if (null == pgConditionDomain || StringUtils.isBlank((String)pgConditionDomain.getConditionCode())) {
            this.logger.error("pg.PICK.PgGconfirmServiceImpl.saveGconfirmByCondition", (Object)"pgConditionDomain-is-null");
            return null;
        }
        this.logger.info("pg.PICK.PgGconfirmServiceImpl.saveGconfirmByCondition", (Object)JsonUtil.buildNormalBinder().toJson((Object)pgConditionDomain));
        String tenantCode = pgConditionDomain.getTenantCode();
        String userCode = pgConditionDomain.getUserCode();
        String conditionCode = pgConditionDomain.getConditionCode();
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)userCode) || StringUtils.isBlank((String)conditionCode)) {
            this.logger.error("pg.PICK.PgGconfirmServiceImpl.saveGconfirmByCondition", (Object)"tenantCode-userCode-conditionCode-is-null");
            return null;
        }
        if (ListUtil.isNotEmpty(pgConditionDomain.getPgGconfirmDomainList())) {
            for (PgGconfirmDomain pgGconfirmDomain : pgConditionDomain.getPgGconfirmDomainList()) {
                pgGconfirmDomain.setTenantCode(tenantCode);
                pgGconfirmDomain.setUserCode(userCode);
                pgGconfirmDomain.setConditionCode(conditionCode);
            }
            this.saveGconfirmBatch(pgConditionDomain.getPgGconfirmDomainList());
        }
        if (ListUtil.isNotEmpty(pgConditionDomain.getPgGcfmpackimgsDomainList())) {
            ArrayList<PgGcfmpackimgsDomain> pgGcfmpackimgsDomainList = new ArrayList<PgGcfmpackimgsDomain>(10);
            for (PgGcfmpackimgsDomain pgGcfmpackimgsDomain : pgConditionDomain.getPgGcfmpackimgsDomainList()) {
                pgGcfmpackimgsDomain.setTenantCode(tenantCode);
                pgGcfmpackimgsDomain.setUserCode(userCode);
                pgGcfmpackimgsDomain.setConditionCode(conditionCode);
                pgGcfmpackimgsDomainList.add(pgGcfmpackimgsDomain);
            }
            this.delPackingModelByConditionCode(tenantCode, conditionCode);
            this.pgGcfmpackimgsService.saveGcfmpackimgsBatch(pgGcfmpackimgsDomainList);
        }
        return conditionCode;
    }

    private void delPackingModelByConditionCode(String tenantCode, String conditionCode) {
        if (StringUtils.isBlank((String)conditionCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("pg.PICK.PgGconfirmServiceImpl.delGconfirmModelByConditionCode", (Object)"conditionCode or tenantCode is null");
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("conditionCode", conditionCode);
        this.pgGconfirmMapper.delPackimgByConditionCode(map);
    }

    @Override
    public QueryResult<PgGconfirm> queryGconfirmPageOrGoods(Map<String, Object> map) {
        List<PgGconfirm> pgGconfirmList = this.queryGconfirmPageOrGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGconfirmOrgoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pgGconfirmList);
        return queryResult;
    }

    @Override
    public QueryResult<PgGConfirmByCondtion> queryGconfirmByContidion(Map<String, Object> map) {
        List<PgGConfirmByCondtion> pgGConfirmByCondtionList = this.queryGconfirmByContidionModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGconfirmByContidion(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pgGConfirmByCondtionList);
        return queryResult;
    }

    private int countGconfirmByContidion(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pgGconfirmMapper.countGconfirmByContidion(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGconfirmServiceImpl.countGconfirm", (Throwable)e);
        }
        return i;
    }

    private List<PgGConfirmByCondtion> queryGconfirmByContidionModelPage(Map<String, Object> parammap) {
        try {
            return this.pgGconfirmMapper.queryGconfirmByContidionModelPage(parammap);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGconfirmServiceImpl.queryGconfirmModel", (Throwable)e);
            return null;
        }
    }

    private List<PgGconfirm> queryGconfirmPageOrGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.pgGconfirmMapper.queryGconfirmPageOrGoodsModelPage(parammap);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGconfirmServiceImpl.queryGconfirmModel", (Throwable)e);
            return null;
        }
    }
}

