/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pg.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pg.dao.PgGroupMapper;
import com.yqbsoft.laser.service.pg.domain.PgGgoodsDomain;
import com.yqbsoft.laser.service.pg.domain.PgGroupDomain;
import com.yqbsoft.laser.service.pg.domain.PgGroupReDomain;
import com.yqbsoft.laser.service.pg.model.PgGroup;
import com.yqbsoft.laser.service.pg.service.PgGgoodsService;
import com.yqbsoft.laser.service.pg.service.PgGroupService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PgGroupServiceImpl
extends BaseServiceImpl
implements PgGroupService {
    private static final String SYS_CODE = "pg.PICK.PgGroupServiceImpl";
    private PgGroupMapper pgGroupMapper;
    private PgGgoodsService pgGgoodsService;

    public void setPgGroupMapper(PgGroupMapper pgGroupMapper) {
        this.pgGroupMapper = pgGroupMapper;
    }

    public void setPgGgoodsService(PgGgoodsService pgGgoodsService) {
        this.pgGgoodsService = pgGgoodsService;
    }

    private Date getSysDate() {
        try {
            return this.pgGroupMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGroupServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGroup(PgGroupDomain pgGroupDomain) {
        if (null == pgGroupDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pgGroupDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGroupDefault(PgGroup pgGroup) {
        if (null == pgGroup) {
            return;
        }
        if (null == pgGroup.getDataState()) {
            pgGroup.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pgGroup.getGmtCreate()) {
            pgGroup.setGmtCreate(date);
        }
        pgGroup.setGmtModified(date);
        if (StringUtils.isBlank((String)pgGroup.getGroupCode())) {
            pgGroup.setGroupCode(this.getNo(null, "PgGroup", "pgGroup", pgGroup.getTenantCode()));
        }
    }

    private int getGroupMaxCode() {
        int code = 0;
        try {
            return this.pgGroupMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGroupServiceImpl.getGroupMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGroupUpdataDefault(PgGroup pgGroup) {
        if (null == pgGroup) {
            return;
        }
        pgGroup.setGmtModified(this.getSysDate());
    }

    private String saveGroupModel(PgGroup pgGroup) throws ApiException {
        if (null == pgGroup) {
            return null;
        }
        try {
            this.pgGroupMapper.insert(pgGroup);
            return pgGroup.getGroupCode();
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGroupServiceImpl.saveGroupModel.ex", (Throwable)e);
        }
    }

    private void saveGroupBatchModel(List<PgGroup> pgGroupList) throws ApiException {
        if (null == pgGroupList || pgGroupList.isEmpty()) {
            return;
        }
        try {
            this.pgGroupMapper.insertBatch(pgGroupList);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGroupServiceImpl.saveGroupBatchModel.ex", (Throwable)e);
        }
    }

    private PgGroup getGroupModelById(Integer groupId) {
        if (null == groupId) {
            return null;
        }
        try {
            return this.pgGroupMapper.selectByPrimaryKey(groupId);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGroupServiceImpl.getGroupModelById", (Throwable)e);
            return null;
        }
    }

    private PgGroup getGroupModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pgGroupMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGroupServiceImpl.getGroupModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGroupModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pgGroupMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGroupServiceImpl.delGroupModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgGroupServiceImpl.delGroupModelByCode.num");
        }
    }

    private void deleteGroupModel(Integer groupId) throws ApiException {
        if (null == groupId) {
            return;
        }
        int i = 0;
        try {
            i = this.pgGroupMapper.deleteByPrimaryKey(groupId);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGroupServiceImpl.deleteGroupModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgGroupServiceImpl.deleteGroupModel.num");
        }
    }

    private void updateGroupModel(PgGroup pgGroup) throws ApiException {
        if (null == pgGroup) {
            return;
        }
        int i = 0;
        try {
            i = this.pgGroupMapper.updateByPrimaryKey(pgGroup);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGroupServiceImpl.updateGroupModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgGroupServiceImpl.updateGroupModel.num");
        }
    }

    private void updateStateGroupModel(Integer groupId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == groupId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("groupId", groupId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgGroupMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGroupServiceImpl.updateStateGroupModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgGroupServiceImpl.updateStateGroupModel.null");
        }
    }

    private void updateStateGroupModelByCode(String tenantCode, String groupCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)groupCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("groupCode", groupCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgGroupMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGroupServiceImpl.updateStateGroupModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgGroupServiceImpl.updateStateGroupModelByCode.null");
        }
    }

    private PgGroup makeGroup(PgGroupDomain pgGroupDomain, PgGroup pgGroup) {
        if (null == pgGroupDomain) {
            this.logger.error("pg.PICK.PgGroupServiceImpl.makeGroup", (Object)"pgGroupDomain is null");
            return null;
        }
        if (null == pgGroup) {
            pgGroup = new PgGroup();
        }
        try {
            if (StringUtils.isBlank((String)pgGroupDomain.getGroupTitle()) || pgGroupDomain.getGroupTitle().equals(pgGroup.getGroupTitle())) {
                pgGroupDomain.setGroupTitle("\u4ef7\u503c" + PgGroupServiceImpl.sumGoodsPrice(pgGroupDomain.getPgGgoodsDomainList()) + "\u5143\u7684" + PgGroupServiceImpl.sumGoodSize(pgGroupDomain.getPgGgoodsDomainList()) + "ML\u6d17\u62a4\u5927\u793c\u5305");
            }
            BeanUtils.copyAllPropertys((Object)pgGroup, (Object)pgGroupDomain);
            return pgGroup;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGroupServiceImpl.makeGroup", (Throwable)e);
            return null;
        }
    }

    private static BigDecimal sumGoodsPrice(List<PgGgoodsDomain> pgGgoodsDomainList) {
        return pgGgoodsDomainList.stream().map(PgGgoodsDomain::getPricesetNprice).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(0, 4);
    }

    private static BigDecimal sumGoodSize(List<PgGgoodsDomain> pgGgoodsDomainList) {
        return pgGgoodsDomainList.stream().map(p -> {
            if (p.getLabelSize() == null) {
                p.setLabelSize(BigDecimal.ZERO);
            }
            if ("KG".equals(p.getLabelSizeUnit())) {
                p.setLabelSize(p.getLabelSize().multiply(new BigDecimal("1000")));
                p.setLabelSizeUnit("G");
            } else if ("L".equals(p.getLabelSizeUnit())) {
                p.setLabelSize(p.getLabelSize().multiply(new BigDecimal("1000")));
                p.setLabelSizeUnit("ML");
            } else if (!"G".equals(p.getLabelSizeUnit()) && !"ML".equals(p.getLabelSizeUnit())) {
                p.setLabelSize(BigDecimal.ZERO);
            }
            return p.getLabelSize();
        }).reduce(BigDecimal::add).get().setScale(0, 0);
    }

    private PgGroupReDomain makePgGroupReDomain(PgGroup pgGroup) {
        if (null == pgGroup) {
            return null;
        }
        PgGroupReDomain pgGroupReDomain = new PgGroupReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pgGroupReDomain, (Object)pgGroup);
            return pgGroupReDomain;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGroupServiceImpl.makePgGroupReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PgGroup> queryGroupModelPage(Map<String, Object> parammap) {
        try {
            return this.pgGroupMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGroupServiceImpl.queryGroupModel", (Throwable)e);
            return null;
        }
    }

    private int countGroup(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pgGroupMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGroupServiceImpl.countGroup", (Throwable)e);
        }
        return i;
    }

    private PgGroup createPgGroup(PgGroupDomain pgGroupDomain) {
        String msg = this.checkGroup(pgGroupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgGroupServiceImpl.saveGroup.checkGroup", msg);
        }
        BigDecimal sumSize = pgGroupDomain.getSumSize();
        if (sumSize == null || BigDecimal.ZERO.compareTo(sumSize) >= 0) {
            pgGroupDomain.setGroupTitle("\u4ef7\u503c" + pgGroupDomain.getGroupLevel() + "\u5143\u7684\u6d17\u62a4\u5927\u793c\u5305");
        }
        PgGroup pgGroup = this.makeGroup(pgGroupDomain, null);
        this.setGroupDefault(pgGroup);
        return pgGroup;
    }

    @Override
    public String saveGroup(PgGroupDomain pgGroupDomain) throws ApiException {
        PgGroup pgGroup = this.createPgGroup(pgGroupDomain);
        String groupCode = this.saveGroupModel(pgGroup);
        this.saveGgoodsBatch(pgGroupDomain.getPgGgoodsDomainList(), groupCode);
        return pgGroup.getGroupCode();
    }

    private void saveGgoodsBatch(List<PgGgoodsDomain> pgGgoodsDomainList, String groupCode) {
        pgGgoodsDomainList.stream().forEach(p -> p.setGroupCode(groupCode));
        this.pgGgoodsService.saveGgoodsBatch(pgGgoodsDomainList);
    }

    @Override
    public String saveGroupBatch(List<PgGroupDomain> pgGroupDomainList) throws ApiException {
        if (null == pgGroupDomainList || pgGroupDomainList.isEmpty()) {
            return null;
        }
        int a = 0;
        ArrayList<PgGroup> pgGroupList = new ArrayList<PgGroup>(10);
        ArrayList<PgGgoodsDomain> pgGgoodsList = new ArrayList<PgGgoodsDomain>(200);
        for (PgGroupDomain pgGroupDomain : pgGroupDomainList) {
            PgGroup pgGroup = this.createPgGroup(pgGroupDomain);
            pgGroupList.add(pgGroup);
            List<PgGgoodsDomain> pgGgoodsDomainList = pgGroupDomain.getPgGgoodsDomainList();
            pgGgoodsDomainList.stream().forEach(p -> p.setGroupCode(pgGroup.getGroupCode()));
            pgGgoodsList.addAll(pgGgoodsDomainList);
            ++a;
        }
        this.saveGroupBatchModel(pgGroupList);
        this.pgGgoodsService.saveGgoodsBatch(pgGgoodsList);
        return String.valueOf(a);
    }

    @Override
    public void updateGroupState(Integer groupId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == groupId) {
            return;
        }
        this.updateStateGroupModel(groupId, dataState, oldDataState, map);
    }

    @Override
    public void updateGroupStateByCode(String tenantCode, String groupCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)groupCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateGroupModelByCode(tenantCode, groupCode, dataState, oldDataState, map);
    }

    @Override
    public void updateGroup(PgGroupDomain pgGroupDomain) throws ApiException {
        String msg = this.checkGroup(pgGroupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgGroupServiceImpl.updateGroup.checkGroup", msg);
        }
        PgGroup oldPgGroup = this.getGroupModelById(pgGroupDomain.getGroupId());
        if (null == oldPgGroup) {
            throw new ApiException("pg.PICK.PgGroupServiceImpl.updateGroup.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PgGroup pgGroup = this.makeGroup(pgGroupDomain, oldPgGroup);
        this.setGroupUpdataDefault(pgGroup);
        this.updateGroupModel(pgGroup);
    }

    @Override
    public PgGroup getGroup(Integer groupId) {
        if (null == groupId) {
            return null;
        }
        return this.getGroupModelById(groupId);
    }

    @Override
    public void deleteGroup(Integer groupId) throws ApiException {
        if (null == groupId) {
            return;
        }
        this.deleteGroupModel(groupId);
    }

    @Override
    public QueryResult<PgGroup> queryGroupPage(Map<String, Object> map) {
        List<PgGroup> pgGroupList = this.queryGroupModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGroup(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pgGroupList);
        return queryResult;
    }

    @Override
    public PgGroup getGroupByCode(String tenantCode, String groupCode) throws ApiException {
        if (StringUtils.isBlank((String)groupCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("groupCode", groupCode);
        return this.getGroupModelByCode(map);
    }

    @Override
    public void deleteGroupByCode(String tenantCode, String groupCode) throws ApiException {
        if (StringUtils.isBlank((String)groupCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("groupCode", groupCode);
        this.delGroupModelByCode(map);
    }
}

