/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pg.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pg.dao.PgGruleMapper;
import com.yqbsoft.laser.service.pg.domain.PgGruleDomain;
import com.yqbsoft.laser.service.pg.domain.PgGruleReDomain;
import com.yqbsoft.laser.service.pg.model.PgGrule;
import com.yqbsoft.laser.service.pg.service.PgGruleService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PgGruleServiceImpl
extends BaseServiceImpl
implements PgGruleService {
    private static final String SYS_CODE = "pg.PICK.PgGruleServiceImpl";
    private PgGruleMapper pgGruleMapper;

    public void setPgGruleMapper(PgGruleMapper pgGruleMapper) {
        this.pgGruleMapper = pgGruleMapper;
    }

    private Date getSysDate() {
        try {
            return this.pgGruleMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGruleServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGrule(PgGruleDomain pgGruleDomain) {
        if (null == pgGruleDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pgGruleDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGruleDefault(PgGrule pgGrule) {
        if (null == pgGrule) {
            return;
        }
        if (null == pgGrule.getDataState()) {
            pgGrule.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pgGrule.getGmtCreate()) {
            pgGrule.setGmtCreate(date);
        }
        pgGrule.setGmtModified(date);
        if (StringUtils.isBlank((String)pgGrule.getGruleCode())) {
            pgGrule.setGruleCode(this.getNo(null, "PgGrule", "pgGrule", pgGrule.getTenantCode()));
        }
    }

    private int getGruleMaxCode() {
        int code = 0;
        try {
            return this.pgGruleMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGruleServiceImpl.getGruleMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGruleUpdataDefault(PgGrule pgGrule) {
        if (null == pgGrule) {
            return;
        }
        pgGrule.setGmtModified(this.getSysDate());
    }

    private void saveGruleModel(PgGrule pgGrule) throws ApiException {
        if (null == pgGrule) {
            return;
        }
        try {
            this.pgGruleMapper.insert(pgGrule);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGruleServiceImpl.saveGruleModel.ex", (Throwable)e);
        }
    }

    private void saveGruleBatchModel(List<PgGrule> pgGruleList) throws ApiException {
        if (null == pgGruleList || pgGruleList.isEmpty()) {
            return;
        }
        try {
            this.pgGruleMapper.insertBatch(pgGruleList);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGruleServiceImpl.saveGruleBatchModel.ex", (Throwable)e);
        }
    }

    private PgGrule getGruleModelById(Integer gruleId) {
        if (null == gruleId) {
            return null;
        }
        try {
            return this.pgGruleMapper.selectByPrimaryKey(gruleId);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGruleServiceImpl.getGruleModelById", (Throwable)e);
            return null;
        }
    }

    private PgGrule getGruleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pgGruleMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGruleServiceImpl.getGruleModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGruleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pgGruleMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGruleServiceImpl.delGruleModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgGruleServiceImpl.delGruleModelByCode.num");
        }
    }

    private void deleteGruleModel(Integer gruleId) throws ApiException {
        if (null == gruleId) {
            return;
        }
        int i = 0;
        try {
            i = this.pgGruleMapper.deleteByPrimaryKey(gruleId);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGruleServiceImpl.deleteGruleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgGruleServiceImpl.deleteGruleModel.num");
        }
    }

    private void updateGruleModel(PgGrule pgGrule) throws ApiException {
        if (null == pgGrule) {
            return;
        }
        int i = 0;
        try {
            i = this.pgGruleMapper.updateByPrimaryKey(pgGrule);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGruleServiceImpl.updateGruleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgGruleServiceImpl.updateGruleModel.num");
        }
    }

    private void updateStateGruleModel(Integer gruleId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == gruleId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gruleId", gruleId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgGruleMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGruleServiceImpl.updateStateGruleModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgGruleServiceImpl.updateStateGruleModel.null");
        }
    }

    private void updateStateGruleModelByCode(String tenantCode, String gruleCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)gruleCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("gruleCode", gruleCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgGruleMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgGruleServiceImpl.updateStateGruleModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgGruleServiceImpl.updateStateGruleModelByCode.null");
        }
    }

    private PgGrule makeGrule(PgGruleDomain pgGruleDomain, PgGrule pgGrule) {
        if (null == pgGruleDomain) {
            return null;
        }
        if (null == pgGrule) {
            pgGrule = new PgGrule();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pgGrule, (Object)pgGruleDomain);
            return pgGrule;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGruleServiceImpl.makeGrule", (Throwable)e);
            return null;
        }
    }

    private PgGruleReDomain makePgGruleReDomain(PgGrule pgGrule) {
        if (null == pgGrule) {
            return null;
        }
        PgGruleReDomain pgGruleReDomain = new PgGruleReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pgGruleReDomain, (Object)pgGrule);
            return pgGruleReDomain;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGruleServiceImpl.makePgGruleReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PgGrule> queryGruleModelPage(Map<String, Object> parammap) {
        try {
            return this.pgGruleMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGruleServiceImpl.queryGruleModel", (Throwable)e);
            return null;
        }
    }

    private int countGrule(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pgGruleMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgGruleServiceImpl.countGrule", (Throwable)e);
        }
        return i;
    }

    private PgGrule createPgGrule(PgGruleDomain pgGruleDomain) {
        String msg = this.checkGrule(pgGruleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgGruleServiceImpl.saveGrule.checkGrule", msg);
        }
        PgGrule pgGrule = this.makeGrule(pgGruleDomain, null);
        this.setGruleDefault(pgGrule);
        return pgGrule;
    }

    @Override
    public String saveGrule(PgGruleDomain pgGruleDomain) throws ApiException {
        PgGrule pgGrule = this.createPgGrule(pgGruleDomain);
        this.saveGruleModel(pgGrule);
        return pgGrule.getGruleCode();
    }

    @Override
    public String saveGruleBatch(List<PgGruleDomain> pgGruleDomainList) throws ApiException {
        if (null == pgGruleDomainList || pgGruleDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PgGrule> pgGruleList = new ArrayList<PgGrule>();
        String code = "";
        for (PgGruleDomain pgGruleDomain : pgGruleDomainList) {
            PgGrule pgGrule = this.createPgGrule(pgGruleDomain);
            code = pgGrule.getGruleCode();
            pgGruleList.add(pgGrule);
        }
        this.saveGruleBatchModel(pgGruleList);
        return code;
    }

    @Override
    public void updateGruleState(Integer gruleId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == gruleId) {
            return;
        }
        this.updateStateGruleModel(gruleId, dataState, oldDataState, map);
    }

    @Override
    public void updateGruleStateByCode(String tenantCode, String gruleCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)gruleCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateGruleModelByCode(tenantCode, gruleCode, dataState, oldDataState, map);
    }

    @Override
    public void updateGrule(PgGruleDomain pgGruleDomain) throws ApiException {
        String msg = this.checkGrule(pgGruleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgGruleServiceImpl.updateGrule.checkGrule", msg);
        }
        PgGrule oldPgGrule = this.getGruleModelById(pgGruleDomain.getGruleId());
        if (null == oldPgGrule) {
            throw new ApiException("pg.PICK.PgGruleServiceImpl.updateGrule.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PgGrule pgGrule = this.makeGrule(pgGruleDomain, oldPgGrule);
        this.setGruleUpdataDefault(pgGrule);
        this.updateGruleModel(pgGrule);
    }

    @Override
    public PgGrule getGrule(Integer gruleId) {
        if (null == gruleId) {
            return null;
        }
        return this.getGruleModelById(gruleId);
    }

    @Override
    public void deleteGrule(Integer gruleId) throws ApiException {
        if (null == gruleId) {
            return;
        }
        this.deleteGruleModel(gruleId);
    }

    @Override
    public QueryResult<PgGrule> queryGrulePage(Map<String, Object> map) {
        List<PgGrule> pgGruleList = this.queryGruleModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGrule(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pgGruleList);
        return queryResult;
    }

    @Override
    public PgGrule getGruleByCode(String tenantCode, String gruleCode) throws ApiException {
        if (StringUtils.isBlank((String)gruleCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("gruleCode", gruleCode);
        return this.getGruleModelByCode(map);
    }

    @Override
    public void deleteGruleByCode(String tenantCode, String gruleCode) throws ApiException {
        if (StringUtils.isBlank((String)gruleCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("gruleCode", gruleCode);
        this.delGruleModelByCode(map);
    }
}

