/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pg.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pg.PgConstants;
import com.yqbsoft.laser.service.pg.dao.PgLabelMapper;
import com.yqbsoft.laser.service.pg.domain.PgLabelDomain;
import com.yqbsoft.laser.service.pg.domain.PgLabelReDomain;
import com.yqbsoft.laser.service.pg.model.PgLabel;
import com.yqbsoft.laser.service.pg.service.PgLabelService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PgLabelServiceImpl
extends BaseServiceImpl
implements PgLabelService {
    private static final String SYS_CODE = "pg.PICK.PgLabelServiceImpl";
    private PgLabelMapper pgLabelMapper;
    private static List<PgLabelDomain> pgLabelDomainListCache = null;

    public void setPgLabelMapper(PgLabelMapper pgLabelMapper) {
        this.pgLabelMapper = pgLabelMapper;
    }

    private Date getSysDate() {
        try {
            return this.pgLabelMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgLabelServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkLabel(PgLabelDomain pgLabelDomain) {
        if (null == pgLabelDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pgLabelDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setLabelDefault(PgLabel pgLabel) {
        if (null == pgLabel) {
            return;
        }
        if (null == pgLabel.getDataState()) {
            pgLabel.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pgLabel.getGmtCreate()) {
            pgLabel.setGmtCreate(date);
        }
        if (null == pgLabel.getNumberOfReviews()) {
            pgLabel.setNumberOfReviews(0);
        }
        pgLabel.setGmtModified(date);
        if (StringUtils.isBlank((String)pgLabel.getLabelCode())) {
            pgLabel.setLabelCode(this.getNo(null, "PgLabel", "pgLabel", pgLabel.getTenantCode()));
        }
    }

    private int getLabelMaxCode() {
        int code = 0;
        try {
            return this.pgLabelMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgLabelServiceImpl.getLabelMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setLabelUpdataDefault(PgLabel pgLabel) {
        if (null == pgLabel) {
            return;
        }
        pgLabel.setGmtModified(this.getSysDate());
    }

    private void saveLabelModel(PgLabel pgLabel) throws ApiException {
        if (null == pgLabel) {
            return;
        }
        try {
            this.pgLabelMapper.insert(pgLabel);
            pgLabelDomainListCache = null;
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgLabelServiceImpl.saveLabelModel.ex", (Throwable)e);
        }
    }

    @Override
    public void saveLabelBatchModel(List<PgLabel> pgLabelList) throws ApiException {
        if (null == pgLabelList || pgLabelList.isEmpty()) {
            return;
        }
        try {
            this.pgLabelMapper.insertBatch(pgLabelList);
            pgLabelDomainListCache = null;
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgLabelServiceImpl.saveLabelBatchModel.ex", (Throwable)e);
        }
    }

    @Override
    public void updateLabelBatchForPrice(List<PgLabel> pgLabelList) throws ApiException {
        if (null == pgLabelList || pgLabelList.isEmpty()) {
            return;
        }
        try {
            this.pgLabelMapper.updateLabelBatchForPrice(pgLabelList);
            pgLabelDomainListCache = null;
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgLabelServiceImpl.updateLabelBatchForPrice.ex", (Throwable)e);
        }
    }

    private PgLabel getLabelModelById(Integer labelId) {
        if (null == labelId) {
            return null;
        }
        try {
            return this.pgLabelMapper.selectByPrimaryKey(labelId);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgLabelServiceImpl.getLabelModelById", (Throwable)e);
            return null;
        }
    }

    private PgLabel getLabelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pgLabelMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgLabelServiceImpl.getLabelModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delLabelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pgLabelMapper.delByCode(map);
            pgLabelDomainListCache = null;
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgLabelServiceImpl.delLabelModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgLabelServiceImpl.delLabelModelByCode.num");
        }
    }

    private void deleteLabelModel(Integer labelId) throws ApiException {
        if (null == labelId) {
            return;
        }
        int i = 0;
        try {
            i = this.pgLabelMapper.deleteByPrimaryKey(labelId);
            pgLabelDomainListCache = null;
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgLabelServiceImpl.deleteLabelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgLabelServiceImpl.deleteLabelModel.num");
        }
    }

    private void updateLabelModel(PgLabel pgLabel) throws ApiException {
        if (null == pgLabel) {
            return;
        }
        int i = 0;
        try {
            i = this.pgLabelMapper.updateByPrimaryKey(pgLabel);
            pgLabelDomainListCache = null;
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgLabelServiceImpl.updateLabelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgLabelServiceImpl.updateLabelModel.num");
        }
    }

    private void updateStateLabelModel(Integer labelId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == labelId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("labelId", labelId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgLabelMapper.updateStateByPrimaryKey(map);
            pgLabelDomainListCache = null;
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgLabelServiceImpl.updateStateLabelModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgLabelServiceImpl.updateStateLabelModel.null");
        }
    }

    private void updateStateLabelModelByCode(String tenantCode, String labelCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)labelCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("labelCode", labelCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgLabelMapper.updateStateByCode(map);
            pgLabelDomainListCache = null;
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgLabelServiceImpl.updateStateLabelModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgLabelServiceImpl.updateStateLabelModelByCode.null");
        }
    }

    private PgLabel makeLabel(PgLabelDomain pgLabelDomain, PgLabel pgLabel) {
        if (null == pgLabelDomain) {
            return null;
        }
        if (null == pgLabel) {
            pgLabel = new PgLabel();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)pgLabel, (Object)pgLabelDomain);
            return pgLabel;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgLabelServiceImpl.makeLabel", (Throwable)e);
            return null;
        }
    }

    private PgLabelReDomain makePgLabelReDomain(PgLabel pgLabel) {
        if (null == pgLabel) {
            return null;
        }
        PgLabelReDomain pgLabelReDomain = new PgLabelReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pgLabelReDomain, (Object)pgLabel);
            if (pgLabelReDomain.getNumberOfReviews() == null) {
                pgLabelReDomain.setNumberOfReviews(0);
            }
            return pgLabelReDomain;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgLabelServiceImpl.makePgLabelReDomain", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<PgLabel> queryLabelModelPage(Map<String, Object> parammap) {
        try {
            return this.pgLabelMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgLabelServiceImpl.queryLabelModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public void deleteLabels(List<Integer> labelIdList) {
        if (labelIdList == null || labelIdList.isEmpty()) {
            return;
        }
        try {
            this.pgLabelMapper.deleteLabelByIds(labelIdList);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgLabelServiceImpl.deleteLabels", (Throwable)e);
        }
    }

    private int countLabel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pgLabelMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgLabelServiceImpl.countLabel", (Throwable)e);
        }
        return i;
    }

    private PgLabel createPgLabel(PgLabelDomain pgLabelDomain) {
        String msg = this.checkLabel(pgLabelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgLabelServiceImpl.saveLabel.checkLabel", msg);
        }
        PgLabel pgLabel = this.makeLabel(pgLabelDomain, null);
        this.setLabelDefault(pgLabel);
        return pgLabel;
    }

    @Override
    public String saveLabel(PgLabelDomain pgLabelDomain) throws ApiException {
        PgLabel pgLabel = this.createPgLabel(pgLabelDomain);
        this.saveLabelModel(pgLabel);
        return pgLabel.getLabelCode();
    }

    @Override
    public String saveLabelBatch(List<PgLabelDomain> pgLabelDomainList) throws ApiException {
        if (null == pgLabelDomainList || pgLabelDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PgLabel> pgLabelList = new ArrayList<PgLabel>();
        String code = "";
        for (PgLabelDomain pgLabelDomain : pgLabelDomainList) {
            PgLabel pgLabel = this.createPgLabel(pgLabelDomain);
            code = pgLabel.getLabelCode();
            pgLabelList.add(pgLabel);
        }
        this.saveLabelBatchModel(pgLabelList);
        return code;
    }

    @Override
    public void updateLabelState(Integer labelId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == labelId) {
            return;
        }
        this.updateStateLabelModel(labelId, dataState, oldDataState, map);
    }

    @Override
    public void updateLabelStateByCode(String tenantCode, String labelCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)labelCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateLabelModelByCode(tenantCode, labelCode, dataState, oldDataState, map);
    }

    @Override
    public void updateLabel(PgLabelDomain pgLabelDomain) throws ApiException {
        String msg = this.checkLabel(pgLabelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgLabelServiceImpl.updateLabel.checkLabel", msg);
        }
        PgLabel oldPgLabel = this.getLabelModelById(pgLabelDomain.getLabelId());
        if (null == oldPgLabel) {
            throw new ApiException("pg.PICK.PgLabelServiceImpl.updateLabel.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PgLabel pgLabel = this.makeLabel(pgLabelDomain, oldPgLabel);
        this.setLabelUpdataDefault(pgLabel);
        this.updateLabelModel(pgLabel);
    }

    @Override
    public PgLabel getLabel(Integer labelId) {
        if (null == labelId) {
            return null;
        }
        return this.getLabelModelById(labelId);
    }

    @Override
    public void deleteLabel(Integer labelId) throws ApiException {
        if (null == labelId) {
            return;
        }
        this.deleteLabelModel(labelId);
    }

    @Override
    public QueryResult<PgLabel> queryLabelPage(Map<String, Object> map) {
        List<PgLabel> pgLabelList = this.queryLabelModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countLabel(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pgLabelList);
        return queryResult;
    }

    @Override
    public PgLabel getLabelByCode(String tenantCode, String labelCode) throws ApiException {
        if (StringUtils.isBlank((String)labelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("labelCode", labelCode);
        return this.getLabelModelByCode(map);
    }

    @Override
    public void deleteLabelByCode(String tenantCode, String labelCode) throws ApiException {
        if (StringUtils.isBlank((String)labelCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("labelCode", labelCode);
        this.delLabelModelByCode(map);
    }

    @Override
    public List<PgLabelDomain> queryLabelList(Map<String, Object> map) {
        if (pgLabelDomainListCache == null || map.get("pg.goods.cache").equals(PgConstants.GOODS_CACHE_0)) {
            List<PgLabel> pgLabelList = this.queryLabelModelPage(map);
            pgLabelDomainListCache = pgLabelList.stream().map(p -> this.makePgLabelReDomain((PgLabel)p)).collect(Collectors.toList());
        }
        return pgLabelDomainListCache;
    }

    @Override
    public void queryLabelLoadCache(Map<String, Object> map) {
        List<PgLabel> pgLabelList = this.queryLabelModelPage(map);
        pgLabelDomainListCache = pgLabelList.stream().map(p -> this.makePgLabelReDomain((PgLabel)p)).collect(Collectors.toList());
    }

    @Override
    public void updateLabelBySku(PgLabelDomain pgLabelDomain) throws ApiException {
        this.updateLabelBySkuModel(pgLabelDomain);
    }

    @Override
    public String updateJdPriceBatch(List<PgLabelDomain> pgLabelDomainList) throws ApiException {
        this.logger.error(".updateJdPriceBatch.pgLabelDomainList", (Object)JsonUtil.buildNormalBinder().toJson(pgLabelDomainList));
        if (null == pgLabelDomainList || pgLabelDomainList.isEmpty()) {
            this.logger.error(".updateJdPriceBatch", (Object)"pgLabelDomainList is null");
            return null;
        }
        ArrayList<PgLabel> pgLabelList = new ArrayList<PgLabel>();
        String code = "";
        for (PgLabelDomain pgLabelDomain : pgLabelDomainList) {
            PgLabel pgLabel = this.createPgLabel(pgLabelDomain);
            code = pgLabel.getSkuCode();
            if (!StringUtils.isNotBlank((String)pgLabel.getSkuCode()) || pgLabel.getLabelJdprice() == null) continue;
            pgLabelList.add(pgLabel);
        }
        this.pgLabelMapper.updateBatch(pgLabelList);
        return code;
    }

    @Override
    public String updateLabelBatch(List<PgLabelDomain> pgLabelDomainList) throws ApiException {
        if (null == pgLabelDomainList || pgLabelDomainList.isEmpty()) {
            this.logger.error(".updateLabelBySkuBatch", (Object)"pgLabelDomainList is null");
            return null;
        }
        ArrayList<PgLabel> pgLabelList = new ArrayList<PgLabel>();
        String code = "";
        for (PgLabelDomain pgLabelDomain : pgLabelDomainList) {
            PgLabel pgLabel = this.createPgLabel(pgLabelDomain);
            code = pgLabel.getSkuCode();
            if (!this.checkLabelData(pgLabelDomain)) continue;
            pgLabelList.add(pgLabel);
        }
        this.pgLabelMapper.updateBatchBySkuList(pgLabelList);
        return code;
    }

    private boolean checkLabelData(PgLabelDomain pgLabelDomain) {
        Boolean flag = true;
        if (null == pgLabelDomain || StringUtils.isBlank((String)pgLabelDomain.getSkuCode())) {
            flag = false;
        }
        if (StringUtils.isBlank((String)pgLabelDomain.getLabelSpaced()) && StringUtils.isBlank((String)pgLabelDomain.getLabelUserlabel()) && StringUtils.isBlank((String)pgLabelDomain.getLabelSeasonlabel()) && StringUtils.isBlank((String)pgLabelDomain.getLabelEb()) && EmptyUtil.isEmpty((Object)pgLabelDomain.getLabelGflabel()) && EmptyUtil.isEmpty((Object)pgLabelDomain.getLabelTtlabel()) && EmptyUtil.isEmpty((Object)pgLabelDomain.getLabelAkbdlabel()) && EmptyUtil.isEmpty((Object)pgLabelDomain.getGoodsRemark())) {
            flag = false;
        }
        return flag;
    }

    private void updateLabelBySkuModel(PgLabelDomain pgLabel) throws ApiException {
        if (null == pgLabel) {
            return;
        }
        int i = 0;
        try {
            i = this.pgLabelMapper.updateLabelBySkuModel(pgLabel);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgLabelServiceImpl.updateLabelBySkuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgLabelServiceImpl.updateLabelBySkuModel.num");
        }
    }
}

