/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pg.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pg.dao.PgProductMasterCdlMapper;
import com.yqbsoft.laser.service.pg.domain.PgProductMasterCdlDomain;
import com.yqbsoft.laser.service.pg.domain.PgProductMasterCdlReDomain;
import com.yqbsoft.laser.service.pg.domain.QstPriceTrackingListDomain;
import com.yqbsoft.laser.service.pg.model.PgLabel;
import com.yqbsoft.laser.service.pg.model.PgProductMasterCdl;
import com.yqbsoft.laser.service.pg.service.PgLabelService;
import com.yqbsoft.laser.service.pg.service.PgProductMasterCdlService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PgProductMasterCdlServiceImpl
extends BaseServiceImpl
implements PgProductMasterCdlService {
    private static final String SYS_CODE = "pg.PICK.PgProductMasterCdlServiceImpl";
    private PgProductMasterCdlMapper pgProductMasterCdlMapper;
    private PgLabelService pgLabelService;

    public void setPgLabelService(PgLabelService pgLabelService) {
        this.pgLabelService = pgLabelService;
    }

    public void setPgProductMasterCdlMapper(PgProductMasterCdlMapper pgProductMasterCdlMapper) {
        this.pgProductMasterCdlMapper = pgProductMasterCdlMapper;
    }

    private Date getSysDate() {
        try {
            return this.pgProductMasterCdlMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgProductMasterCdlServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkProductMasterCdl(PgProductMasterCdlDomain pgProductMasterCdlDomain) {
        if (null == pgProductMasterCdlDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pgProductMasterCdlDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setProductMasterCdlDefault(PgProductMasterCdl pgProductMasterCdl) {
        if (null == pgProductMasterCdl) {
            return;
        }
        if (null == pgProductMasterCdl.getDataState()) {
            pgProductMasterCdl.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pgProductMasterCdl.getGmtCreate()) {
            pgProductMasterCdl.setGmtCreate(date);
        }
        pgProductMasterCdl.setGmtModified(date);
        if (StringUtils.isBlank((String)pgProductMasterCdl.getCode())) {
            pgProductMasterCdl.setCode(this.getNo(null, "PgProductMasterCdl", "pgProductMasterCdl", pgProductMasterCdl.getTenantCode()));
        }
    }

    private int getProductMasterCdlMaxCode() {
        int code = 0;
        try {
            return this.pgProductMasterCdlMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgProductMasterCdlServiceImpl.getProductMasterCdlMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProductMasterCdlUpdataDefault(PgProductMasterCdl pgProductMasterCdl) {
        if (null == pgProductMasterCdl) {
            return;
        }
        pgProductMasterCdl.setGmtModified(this.getSysDate());
    }

    private void saveProductMasterCdlModel(PgProductMasterCdl pgProductMasterCdl) throws ApiException {
        if (null == pgProductMasterCdl) {
            return;
        }
        try {
            this.pgProductMasterCdlMapper.insert(pgProductMasterCdl);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgProductMasterCdlServiceImpl.saveProductMasterCdlModel.ex", (Throwable)e);
        }
    }

    private void saveProductMasterCdlBatchModel(List<PgProductMasterCdl> pgProductMasterCdlList) throws ApiException {
        if (null == pgProductMasterCdlList || pgProductMasterCdlList.isEmpty()) {
            return;
        }
        try {
            this.pgProductMasterCdlMapper.insertBatch(pgProductMasterCdlList);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgProductMasterCdlServiceImpl.saveProductMasterCdlBatchModel.ex", (Throwable)e);
        }
    }

    private PgProductMasterCdl getProductMasterCdlModelById(Integer id) {
        if (null == id) {
            return null;
        }
        try {
            return this.pgProductMasterCdlMapper.selectByPrimaryKey(id);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgProductMasterCdlServiceImpl.getProductMasterCdlModelById", (Throwable)e);
            return null;
        }
    }

    private PgProductMasterCdl getProductMasterCdlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pgProductMasterCdlMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgProductMasterCdlServiceImpl.getProductMasterCdlModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delProductMasterCdlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pgProductMasterCdlMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgProductMasterCdlServiceImpl.delProductMasterCdlModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgProductMasterCdlServiceImpl.delProductMasterCdlModelByCode.num");
        }
    }

    private void deleteProductMasterCdlModel(Integer id) throws ApiException {
        if (null == id) {
            return;
        }
        int i = 0;
        try {
            i = this.pgProductMasterCdlMapper.deleteByPrimaryKey(id);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgProductMasterCdlServiceImpl.deleteProductMasterCdlModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgProductMasterCdlServiceImpl.deleteProductMasterCdlModel.num");
        }
    }

    private void updateProductMasterCdlModel(PgProductMasterCdl pgProductMasterCdl) throws ApiException {
        if (null == pgProductMasterCdl) {
            return;
        }
        int i = 0;
        try {
            i = this.pgProductMasterCdlMapper.updateByPrimaryKey(pgProductMasterCdl);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgProductMasterCdlServiceImpl.updateProductMasterCdlModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgProductMasterCdlServiceImpl.updateProductMasterCdlModel.num");
        }
    }

    private void updateStateProductMasterCdlModel(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == id || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgProductMasterCdlMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgProductMasterCdlServiceImpl.updateStateProductMasterCdlModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgProductMasterCdlServiceImpl.updateStateProductMasterCdlModel.null");
        }
    }

    private void updateStateProductMasterCdlModelByCode(String tenantCode, String code, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)code) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("code", code);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgProductMasterCdlMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgProductMasterCdlServiceImpl.updateStateProductMasterCdlModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgProductMasterCdlServiceImpl.updateStateProductMasterCdlModelByCode.null");
        }
    }

    private PgProductMasterCdl makeProductMasterCdl(PgProductMasterCdlDomain pgProductMasterCdlDomain, PgProductMasterCdl pgProductMasterCdl) {
        if (null == pgProductMasterCdlDomain) {
            return null;
        }
        if (null == pgProductMasterCdl) {
            pgProductMasterCdl = new PgProductMasterCdl();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pgProductMasterCdl, (Object)pgProductMasterCdlDomain);
            return pgProductMasterCdl;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgProductMasterCdlServiceImpl.makeProductMasterCdl", (Throwable)e);
            return null;
        }
    }

    private PgProductMasterCdlReDomain makePgProductMasterCdlReDomain(PgProductMasterCdl pgProductMasterCdl) {
        if (null == pgProductMasterCdl) {
            return null;
        }
        PgProductMasterCdlReDomain pgProductMasterCdlReDomain = new PgProductMasterCdlReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pgProductMasterCdlReDomain, (Object)pgProductMasterCdl);
            return pgProductMasterCdlReDomain;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgProductMasterCdlServiceImpl.makePgProductMasterCdlReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PgProductMasterCdl> queryProductMasterCdlModelPage(Map<String, Object> parammap) {
        try {
            return this.pgProductMasterCdlMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgProductMasterCdlServiceImpl.queryProductMasterCdlModel", (Throwable)e);
            return null;
        }
    }

    private int countProductMasterCdl(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pgProductMasterCdlMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgProductMasterCdlServiceImpl.countProductMasterCdl", (Throwable)e);
        }
        return i;
    }

    private PgProductMasterCdl createPgProductMasterCdl(PgProductMasterCdlDomain pgProductMasterCdlDomain) {
        String msg = this.checkProductMasterCdl(pgProductMasterCdlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgProductMasterCdlServiceImpl.saveProductMasterCdl.checkProductMasterCdl", msg);
        }
        PgProductMasterCdl pgProductMasterCdl = this.makeProductMasterCdl(pgProductMasterCdlDomain, null);
        this.setProductMasterCdlDefault(pgProductMasterCdl);
        return pgProductMasterCdl;
    }

    @Override
    public String saveProductMasterCdl(PgProductMasterCdlDomain pgProductMasterCdlDomain) throws ApiException {
        PgProductMasterCdl pgProductMasterCdl = this.createPgProductMasterCdl(pgProductMasterCdlDomain);
        this.saveProductMasterCdlModel(pgProductMasterCdl);
        return pgProductMasterCdl.getCode();
    }

    @Override
    public String saveProductMasterCdlBatch(List<PgProductMasterCdlDomain> pgProductMasterCdlDomainList) throws ApiException {
        if (null == pgProductMasterCdlDomainList || pgProductMasterCdlDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PgProductMasterCdl> pgProductMasterCdlList = new ArrayList<PgProductMasterCdl>();
        String code = "";
        for (PgProductMasterCdlDomain pgProductMasterCdlDomain : pgProductMasterCdlDomainList) {
            PgProductMasterCdl pgProductMasterCdl = this.createPgProductMasterCdl(pgProductMasterCdlDomain);
            code = pgProductMasterCdl.getCode();
            pgProductMasterCdlList.add(pgProductMasterCdl);
        }
        this.saveProductMasterCdlBatchModel(pgProductMasterCdlList);
        return code;
    }

    @Override
    public void updateProductMasterCdlState(Integer id, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == id) {
            return;
        }
        this.updateStateProductMasterCdlModel(id, dataState, oldDataState, map);
    }

    @Override
    public void updateProductMasterCdlStateByCode(String tenantCode, String code, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)code) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateProductMasterCdlModelByCode(tenantCode, code, dataState, oldDataState, map);
    }

    @Override
    public void updateProductMasterCdl(PgProductMasterCdlDomain pgProductMasterCdlDomain) throws ApiException {
        String msg = this.checkProductMasterCdl(pgProductMasterCdlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgProductMasterCdlServiceImpl.updateProductMasterCdl.checkProductMasterCdl", msg);
        }
        PgProductMasterCdl oldPgProductMasterCdl = this.getProductMasterCdlModelById(pgProductMasterCdlDomain.getId());
        if (null == oldPgProductMasterCdl) {
            throw new ApiException("pg.PICK.PgProductMasterCdlServiceImpl.updateProductMasterCdl.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PgProductMasterCdl pgProductMasterCdl = this.makeProductMasterCdl(pgProductMasterCdlDomain, oldPgProductMasterCdl);
        this.setProductMasterCdlUpdataDefault(pgProductMasterCdl);
        this.updateProductMasterCdlModel(pgProductMasterCdl);
    }

    @Override
    public PgProductMasterCdl getProductMasterCdl(Integer id) {
        if (null == id) {
            return null;
        }
        return this.getProductMasterCdlModelById(id);
    }

    @Override
    public void deleteProductMasterCdl(Integer id) throws ApiException {
        if (null == id) {
            return;
        }
        this.deleteProductMasterCdlModel(id);
    }

    @Override
    public QueryResult<PgProductMasterCdl> queryProductMasterCdlPage(Map<String, Object> map) {
        List<PgProductMasterCdl> pgProductMasterCdlList = this.queryProductMasterCdlModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProductMasterCdl(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pgProductMasterCdlList);
        return queryResult;
    }

    @Override
    public PgProductMasterCdl getProductMasterCdlByCode(String tenantCode, String code) throws ApiException {
        if (StringUtils.isBlank((String)code) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("code", code);
        return this.getProductMasterCdlModelByCode(map);
    }

    @Override
    public void deleteProductMasterCdlByCode(String tenantCode, String code) throws ApiException {
        if (StringUtils.isBlank((String)code) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("code", code);
        this.delProductMasterCdlModelByCode(map);
    }

    @Override
    public void saveMasterToYiMian() throws ApiException {
        List<PgLabel> pgLabelList = this.pgLabelService.queryLabelModelPage(null);
        this.logger.info(".saveMasterToYiMian", (Object)("pgLabelList.size=" + pgLabelList.size()));
        List collectSellBarcode = pgLabelList.stream().map(p -> p.getSellBarcode()).collect(Collectors.toList());
        List<PgProductMasterCdl> masterCdlList = this.pgProductMasterCdlMapper.getListForBlackList();
        this.logger.info(".saveMasterToYiMian", (Object)("masterCdlList.size=" + masterCdlList.size()));
        List collectMaster = masterCdlList.stream().filter(p -> {
            if ((!this.isBlockList(p.getCategoryCn(), p.getBrandCn()) || this.isWhiteList(p.getBrandCn())) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)p.getRpcCode())) {
                for (String s : collectSellBarcode) {
                    if (!this.toList(p.getGtinCode()).contains(s)) continue;
                    return true;
                }
            }
            return false;
        }).map(p -> {
            p.setFpcCode(this.getMaxFpcCode(p.getFpcCode()));
            p.setRpcCode(this.replaceStr(p.getRpcCode()));
            return p;
        }).distinct().collect(Collectors.toList());
        this.logger.info(".saveMasterToYiMian", (Object)("collectMaster.size=" + collectMaster.size()));
        Map latestStations = collectMaster.parallelStream().collect(Collectors.toMap(PgProductMasterCdl::getRpcCode, Function.identity(), (c1, c2) -> c1.getGmtCreate().after(c2.getGmtCreate()) ? c1 : c2));
        ArrayList masterCdls = new ArrayList(latestStations.values());
        List<QstPriceTrackingListDomain> priceTrackingList = masterCdls.stream().map(p -> this.toTrackingData((PgProductMasterCdl)p)).collect(Collectors.toList());
        this.logger.info(".saveMasterToYiMian", (Object)("priceTrackingList.size=" + priceTrackingList.size()));
        this.qstPriceTrackingSaveBatch(priceTrackingList);
    }

    private boolean isWhiteList(String brandCn) {
        if ("\u6c99\u5ba3".equals(brandCn) || "\u6025\u62a4\u7f8e\u4eba".equals(brandCn) || "\u6d77\u808c\u6e90".equals(brandCn) || "\u6b27\u4ed5\u6d3e".equals(brandCn) || "\u690d\u611f\u54f2\u5b66".equals(brandCn) || "L".equals(brandCn) || "\u6025\u6551\u7f8e\u4eba".equals(brandCn) || "\u606f\u53ef\u8212".equals(brandCn) || "\u5e2e\u5ead".equals(brandCn)) {
            return false;
        }
        String[] strs = new String[]{"Joy", "\u98ce\u500d\u6e05"};
        return Arrays.asList(strs).contains(brandCn);
    }

    private void qstPriceTrackingSaveBatch(List<QstPriceTrackingListDomain> priceTrackingList) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("qstPriceTrackingListDomainList", JsonUtil.buildNormalBinder().toJson(priceTrackingList));
            this.internalInvoke("pg.qstPriceTrackingList.savetPriceTrackingListBatch", params);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgProductMasterCdlServiceImpl.qstPriceTrackingSaveBatch", (Throwable)e);
        }
    }

    private QstPriceTrackingListDomain toTrackingData(PgProductMasterCdl p) {
        QstPriceTrackingListDomain track = new QstPriceTrackingListDomain();
        track.setBarcode(p.getFpcItemBarcode());
        track.setBrand(p.getBrandCn());
        track.setCategory(p.getCategoryCn());
        track.setPlatform("JD");
        track.setFpcCode(p.getFpcCode());
        track.setRpcCode(p.getRpcCode());
        track.setRpcName(p.getRpcProductName());
        track.setUpdateTime(new Date());
        return track;
    }

    private boolean isBlockList(String str, String brandCn) {
        if ("\u6c99\u5ba3".equals(brandCn)) {
            return true;
        }
        String[] strs = new String[]{"N/A", "\u5bb6\u5c45\u62a4\u7406", "\u62a4\u80a4\u54c1\u7c7b"};
        return Arrays.asList(strs).contains(str);
    }

    private String replaceStr(String rpcCode) {
        rpcCode = rpcCode.replace(" ", "");
        rpcCode = rpcCode.replace("\u00a0", "");
        return rpcCode;
    }

    private String getMaxFpcCode(String str) {
        return Collections.max(this.toList(str));
    }

    private List<String> toList(String Str) {
        return Arrays.asList(org.apache.commons.lang3.StringUtils.split((String)Str, (String)","));
    }
}

