/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pg.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pg.dao.PgRuleMapper;
import com.yqbsoft.laser.service.pg.domain.PgRuleDomain;
import com.yqbsoft.laser.service.pg.domain.PgRuleReDomain;
import com.yqbsoft.laser.service.pg.model.PgRule;
import com.yqbsoft.laser.service.pg.service.PgRuleService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PgRuleServiceImpl
extends BaseServiceImpl
implements PgRuleService {
    private static final String SYS_CODE = "pg.PICK.PgRuleServiceImpl";
    private PgRuleMapper pgRuleMapper;

    public void setPgRuleMapper(PgRuleMapper pgRuleMapper) {
        this.pgRuleMapper = pgRuleMapper;
    }

    private Date getSysDate() {
        try {
            return this.pgRuleMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgRuleServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRule(PgRuleDomain pgRuleDomain) {
        if (null == pgRuleDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pgRuleDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRuleDefault(PgRule pgRule) {
        if (null == pgRule) {
            return;
        }
        if (null == pgRule.getDataState()) {
            pgRule.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pgRule.getGmtCreate()) {
            pgRule.setGmtCreate(date);
        }
        pgRule.setGmtModified(date);
        if (StringUtils.isBlank((String)pgRule.getRuleCode())) {
            pgRule.setRuleCode(this.getNo(null, "PgRule", "pgRule", pgRule.getTenantCode()));
        }
    }

    private int getRuleMaxCode() {
        int code = 0;
        try {
            return this.pgRuleMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgRuleServiceImpl.getRuleMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRuleUpdataDefault(PgRule pgRule) {
        if (null == pgRule) {
            return;
        }
        pgRule.setGmtModified(this.getSysDate());
    }

    private void saveRuleModel(PgRule pgRule) throws ApiException {
        if (null == pgRule) {
            return;
        }
        try {
            this.pgRuleMapper.insert(pgRule);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgRuleServiceImpl.saveRuleModel.ex", (Throwable)e);
        }
    }

    private void saveRuleBatchModel(List<PgRule> pgRuleList) throws ApiException {
        if (null == pgRuleList || pgRuleList.isEmpty()) {
            return;
        }
        try {
            this.pgRuleMapper.insertBatch(pgRuleList);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgRuleServiceImpl.saveRuleBatchModel.ex", (Throwable)e);
        }
    }

    private PgRule getRuleModelById(Integer ruleId) {
        if (null == ruleId) {
            return null;
        }
        try {
            return this.pgRuleMapper.selectByPrimaryKey(ruleId);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgRuleServiceImpl.getRuleModelById", (Throwable)e);
            return null;
        }
    }

    private PgRule getRuleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pgRuleMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgRuleServiceImpl.getRuleModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRuleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pgRuleMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgRuleServiceImpl.delRuleModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgRuleServiceImpl.delRuleModelByCode.num");
        }
    }

    private void deleteRuleModel(Integer ruleId) throws ApiException {
        if (null == ruleId) {
            return;
        }
        int i = 0;
        try {
            i = this.pgRuleMapper.deleteByPrimaryKey(ruleId);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgRuleServiceImpl.deleteRuleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgRuleServiceImpl.deleteRuleModel.num");
        }
    }

    private void updateRuleModel(PgRule pgRule) throws ApiException {
        if (null == pgRule) {
            return;
        }
        int i = 0;
        try {
            i = this.pgRuleMapper.updateByPrimaryKey(pgRule);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgRuleServiceImpl.updateRuleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgRuleServiceImpl.updateRuleModel.num");
        }
    }

    private void updateStateRuleModel(Integer ruleId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ruleId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ruleId", ruleId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgRuleMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgRuleServiceImpl.updateStateRuleModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgRuleServiceImpl.updateStateRuleModel.null");
        }
    }

    private void updateStateRuleModelByCode(String tenantCode, String ruleCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ruleCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ruleCode", ruleCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgRuleMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgRuleServiceImpl.updateStateRuleModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgRuleServiceImpl.updateStateRuleModelByCode.null");
        }
    }

    private PgRule makeRule(PgRuleDomain pgRuleDomain, PgRule pgRule) {
        if (null == pgRuleDomain) {
            return null;
        }
        if (null == pgRule) {
            pgRule = new PgRule();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pgRule, (Object)pgRuleDomain);
            return pgRule;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgRuleServiceImpl.makeRule", (Throwable)e);
            return null;
        }
    }

    private PgRuleReDomain makePgRuleReDomain(PgRule pgRule) {
        if (null == pgRule) {
            return null;
        }
        PgRuleReDomain pgRuleReDomain = new PgRuleReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pgRuleReDomain, (Object)pgRule);
            return pgRuleReDomain;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgRuleServiceImpl.makePgRuleReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PgRule> queryRuleModelPage(Map<String, Object> parammap) {
        try {
            return this.pgRuleMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgRuleServiceImpl.queryRuleModel", (Throwable)e);
            return null;
        }
    }

    private int countRule(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pgRuleMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgRuleServiceImpl.countRule", (Throwable)e);
        }
        return i;
    }

    private PgRule createPgRule(PgRuleDomain pgRuleDomain) {
        String msg = this.checkRule(pgRuleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgRuleServiceImpl.saveRule.checkRule", msg);
        }
        PgRule pgRule = this.makeRule(pgRuleDomain, null);
        this.setRuleDefault(pgRule);
        return pgRule;
    }

    @Override
    public String saveRule(PgRuleDomain pgRuleDomain) throws ApiException {
        PgRule pgRule = this.createPgRule(pgRuleDomain);
        this.saveRuleModel(pgRule);
        return pgRule.getRuleCode();
    }

    @Override
    public String saveRuleBatch(List<PgRuleDomain> pgRuleDomainList) throws ApiException {
        if (null == pgRuleDomainList || pgRuleDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PgRule> pgRuleList = new ArrayList<PgRule>();
        String code = "";
        for (PgRuleDomain pgRuleDomain : pgRuleDomainList) {
            PgRule pgRule = this.createPgRule(pgRuleDomain);
            code = pgRule.getRuleCode();
            pgRuleList.add(pgRule);
        }
        this.saveRuleBatchModel(pgRuleList);
        return code;
    }

    @Override
    public void updateRuleState(Integer ruleId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == ruleId) {
            return;
        }
        this.updateStateRuleModel(ruleId, dataState, oldDataState, map);
    }

    @Override
    public void updateRuleStateByCode(String tenantCode, String ruleCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)ruleCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateRuleModelByCode(tenantCode, ruleCode, dataState, oldDataState, map);
    }

    @Override
    public void updateRule(PgRuleDomain pgRuleDomain) throws ApiException {
        String msg = this.checkRule(pgRuleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgRuleServiceImpl.updateRule.checkRule", msg);
        }
        PgRule oldPgRule = this.getRuleModelById(pgRuleDomain.getRuleId());
        if (null == oldPgRule) {
            throw new ApiException("pg.PICK.PgRuleServiceImpl.updateRule.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PgRule pgRule = this.makeRule(pgRuleDomain, oldPgRule);
        this.setRuleUpdataDefault(pgRule);
        this.updateRuleModel(pgRule);
    }

    @Override
    public PgRule getRule(Integer ruleId) {
        if (null == ruleId) {
            return null;
        }
        return this.getRuleModelById(ruleId);
    }

    @Override
    public void deleteRule(Integer ruleId) throws ApiException {
        if (null == ruleId) {
            return;
        }
        this.deleteRuleModel(ruleId);
    }

    @Override
    public QueryResult<PgRule> queryRulePage(Map<String, Object> map) {
        List<PgRule> pgRuleList = this.queryRuleModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRule(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pgRuleList);
        return queryResult;
    }

    @Override
    public PgRule getRuleByCode(String tenantCode, String ruleCode) throws ApiException {
        if (StringUtils.isBlank((String)ruleCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ruleCode", ruleCode);
        return this.getRuleModelByCode(map);
    }

    @Override
    public void deleteRuleByCode(String tenantCode, String ruleCode) throws ApiException {
        if (StringUtils.isBlank((String)ruleCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ruleCode", ruleCode);
        this.delRuleModelByCode(map);
    }
}

