/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pg.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.pg.dao.PgSettingMapper;
import com.yqbsoft.laser.service.pg.domain.PgSettingDomain;
import com.yqbsoft.laser.service.pg.domain.PgSettingReDomain;
import com.yqbsoft.laser.service.pg.domain.UmUserDomainBean;
import com.yqbsoft.laser.service.pg.model.PgSetting;
import com.yqbsoft.laser.service.pg.service.PgSettingService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PgSettingServiceImpl
extends BaseServiceImpl
implements PgSettingService {
    private static final String SYS_CODE = "pg.PICK.PgSettingServiceImpl";
    private PgSettingMapper pgSettingMapper;

    public void setPgSettingMapper(PgSettingMapper pgSettingMapper) {
        this.pgSettingMapper = pgSettingMapper;
    }

    private Date getSysDate() {
        try {
            return this.pgSettingMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgSettingServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSetting(PgSettingDomain pgSettingDomain) {
        if (null == pgSettingDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)pgSettingDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSettingDefault(PgSetting pgSetting) {
        if (null == pgSetting) {
            return;
        }
        if (null == pgSetting.getDataState()) {
            pgSetting.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == pgSetting.getGmtCreate()) {
            pgSetting.setGmtCreate(date);
        }
        pgSetting.setGmtModified(date);
        if (StringUtils.isBlank((String)pgSetting.getSettingCode())) {
            pgSetting.setSettingCode(this.getNo(null, "PgSetting", "pgSetting", pgSetting.getTenantCode()));
        }
    }

    private int getSettingMaxCode() {
        int code = 0;
        try {
            return this.pgSettingMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgSettingServiceImpl.getSettingMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSettingUpdataDefault(PgSetting pgSetting) {
        if (null == pgSetting) {
            return;
        }
        pgSetting.setGmtModified(this.getSysDate());
    }

    private void saveSettingModel(PgSetting pgSetting) throws ApiException {
        if (null == pgSetting) {
            return;
        }
        try {
            this.pgSettingMapper.insert(pgSetting);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgSettingServiceImpl.saveSettingModel.ex", (Throwable)e);
        }
    }

    private void saveSettingBatchModel(List<PgSetting> pgSettingList) throws ApiException {
        if (null == pgSettingList || pgSettingList.isEmpty()) {
            return;
        }
        try {
            this.pgSettingMapper.insertBatch(pgSettingList);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgSettingServiceImpl.saveSettingBatchModel.ex", (Throwable)e);
        }
    }

    private PgSetting getSettingModelById(Integer settingId) {
        if (null == settingId) {
            return null;
        }
        try {
            return this.pgSettingMapper.selectByPrimaryKey(settingId);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgSettingServiceImpl.getSettingModelById", (Throwable)e);
            return null;
        }
    }

    private PgSetting getSettingModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.pgSettingMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgSettingServiceImpl.getSettingModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSettingModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.pgSettingMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgSettingServiceImpl.delSettingModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgSettingServiceImpl.delSettingModelByCode.num");
        }
    }

    private void deleteSettingModel(Integer settingId) throws ApiException {
        if (null == settingId) {
            return;
        }
        int i = 0;
        try {
            i = this.pgSettingMapper.deleteByPrimaryKey(settingId);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgSettingServiceImpl.deleteSettingModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgSettingServiceImpl.deleteSettingModel.num");
        }
    }

    private void updateSettingModel(PgSetting pgSetting) throws ApiException {
        if (null == pgSetting) {
            return;
        }
        int i = 0;
        try {
            i = this.pgSettingMapper.updateByPrimaryKey(pgSetting);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgSettingServiceImpl.updateSettingModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pg.PICK.PgSettingServiceImpl.updateSettingModel.num");
        }
    }

    private void updateStateSettingModel(Integer settingId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == settingId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("settingId", settingId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgSettingMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgSettingServiceImpl.updateStateSettingModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgSettingServiceImpl.updateStateSettingModel.null");
        }
    }

    private void updateStateSettingModelByCode(String tenantCode, String settingCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)settingCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("settingCode", settingCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.pgSettingMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pg.PICK.PgSettingServiceImpl.updateStateSettingModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pg.PICK.PgSettingServiceImpl.updateStateSettingModelByCode.null");
        }
    }

    private PgSetting makeSetting(PgSettingDomain pgSettingDomain, PgSetting pgSetting) {
        if (null == pgSettingDomain) {
            return null;
        }
        if (null == pgSetting) {
            pgSetting = new PgSetting();
        }
        try {
            BeanUtils.copyAllPropertys((Object)pgSetting, (Object)pgSettingDomain);
            return pgSetting;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgSettingServiceImpl.makeSetting", (Throwable)e);
            return null;
        }
    }

    private PgSettingReDomain makePgSettingReDomain(PgSetting pgSetting) {
        if (null == pgSetting) {
            return null;
        }
        PgSettingReDomain pgSettingReDomain = new PgSettingReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)pgSettingReDomain, (Object)pgSetting);
            return pgSettingReDomain;
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgSettingServiceImpl.makePgSettingReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PgSetting> querySettingModelPage(Map<String, Object> parammap) {
        try {
            return this.pgSettingMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgSettingServiceImpl.querySettingModel", (Throwable)e);
            return null;
        }
    }

    private int countSetting(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pgSettingMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgSettingServiceImpl.countSetting", (Throwable)e);
        }
        return i;
    }

    private PgSetting createPgSetting(PgSettingDomain pgSettingDomain) {
        String msg = this.checkSetting(pgSettingDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgSettingServiceImpl.saveSetting.checkSetting", msg);
        }
        PgSetting pgSetting = this.makeSetting(pgSettingDomain, null);
        this.setSettingDefault(pgSetting);
        return pgSetting;
    }

    @Override
    public String saveSetting(PgSettingDomain pgSettingDomain) throws ApiException {
        PgSetting pgSetting = this.createPgSetting(pgSettingDomain);
        this.saveSettingModel(pgSetting);
        return pgSetting.getSettingCode();
    }

    @Override
    public String saveSettingBatch(List<PgSettingDomain> pgSettingDomainList) throws ApiException {
        if (null == pgSettingDomainList || pgSettingDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PgSetting> pgSettingList = new ArrayList<PgSetting>();
        String code = "";
        for (PgSettingDomain pgSettingDomain : pgSettingDomainList) {
            PgSetting pgSetting = this.createPgSetting(pgSettingDomain);
            code = pgSetting.getSettingCode();
            pgSettingList.add(pgSetting);
        }
        this.saveSettingBatchModel(pgSettingList);
        return code;
    }

    @Override
    public void updateSettingState(Integer settingId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == settingId) {
            return;
        }
        this.updateStateSettingModel(settingId, dataState, oldDataState, map);
    }

    @Override
    public void updateSettingStateByCode(String tenantCode, String settingCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)settingCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateSettingModelByCode(tenantCode, settingCode, dataState, oldDataState, map);
    }

    @Override
    public void updateSetting(PgSettingDomain pgSettingDomain) throws ApiException {
        String msg = this.checkSetting(pgSettingDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pg.PICK.PgSettingServiceImpl.updateSetting.checkSetting", msg);
        }
        PgSetting oldPgSetting = this.getSettingModelById(pgSettingDomain.getSettingId());
        if (null == oldPgSetting) {
            throw new ApiException("pg.PICK.PgSettingServiceImpl.updateSetting.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PgSetting pgSetting = this.makeSetting(pgSettingDomain, oldPgSetting);
        this.setSettingUpdataDefault(pgSetting);
        this.updateSettingModel(pgSetting);
    }

    @Override
    public PgSetting getSetting(Integer settingId) {
        if (null == settingId) {
            return null;
        }
        return this.getSettingModelById(settingId);
    }

    @Override
    public void deleteSetting(Integer settingId) throws ApiException {
        if (null == settingId) {
            return;
        }
        this.deleteSettingModel(settingId);
    }

    @Override
    public QueryResult<PgSetting> querySettingPage(Map<String, Object> map) {
        List<PgSetting> pgSettingList = this.querySettingModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSetting(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(pgSettingList);
        return queryResult;
    }

    @Override
    public PgSetting getSettingByCode(String tenantCode, String settingCode) throws ApiException {
        if (StringUtils.isBlank((String)settingCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("settingCode", settingCode);
        return this.getSettingModelByCode(map);
    }

    @Override
    public void deleteSettingByCode(String tenantCode, String settingCode) throws ApiException {
        if (StringUtils.isBlank((String)settingCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("settingCode", settingCode);
        this.delSettingModelByCode(map);
    }

    @Override
    public PgSettingDomain getSettingDomainByCode(String tenantCode, String settingCode) throws ApiException {
        if (StringUtils.isBlank((String)settingCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("settingCode", settingCode);
        return this.makePgSettingReDomain(this.getSettingModelByCode(map));
    }

    @Override
    public QueryResult<UmUserDomainBean> queryUserAndUserInfoPage(Map<String, Object> map) {
        List<UmUserDomainBean> umUserList = this.queryUserModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUser(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umUserList);
        return queryResult;
    }

    private List<UmUserDomainBean> queryUserModelPage(Map<String, Object> parammap) {
        try {
            return this.pgSettingMapper.queryUserModelPage(parammap);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgSettingServiceImpl.queryUserModel", (Throwable)e);
            return null;
        }
    }

    private int countUser(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.pgSettingMapper.countUser(map);
        }
        catch (Exception e) {
            this.logger.error("pg.PICK.PgSettingServiceImpl.countUser", (Throwable)e);
        }
        return i;
    }
}

