/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pg.tool.ws.model;

import com.yqbsoft.laser.service.pg.tool.ws.entity.Instance;
import com.yqbsoft.laser.service.pg.tool.ws.entity.PlacePoint;
import com.yqbsoft.laser.service.pg.tool.ws.entity.PlaceSquare;
import com.yqbsoft.laser.service.pg.tool.ws.entity.Solution;
import com.yqbsoft.laser.service.pg.tool.ws.entity.Square;
import com.yqbsoft.laser.service.pg.tool.ws.model.TabuMapTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

public class TabuSearch02 {
    public final int MAX_GEN = 10;
    public final int N = 200;
    public int sqNum;
    public HashMap<String, TabuMapTree> tabuTreeMap = new HashMap();
    public List<Square> initGhh;
    public List<Square> bestGh;
    public List<Square> LocalGh;
    public List<Square> tempGh;
    public int bestT;
    public Solution bestSolution;
    public Solution LocalSolution;
    public Solution tempSolution;
    public int t;
    public Random random;
    public Instance instance;
    double L;
    double W;

    public TabuSearch02(Instance instance) throws Exception {
        this.instance = instance;
        this.initGhh = new ArrayList<Square>(instance.getSquareList());
        this.random = new Random(System.currentTimeMillis());
        this.L = instance.getL();
        this.W = instance.getW();
        this.sqNum = this.initGhh.size();
    }

    public Solution search() throws Exception {
        long start = System.currentTimeMillis();
        this.getInitSolution();
        System.out.println(this.bestSolution.getRate());
        while (this.t <= 10) {
            this.LocalSolution = new Solution();
            this.LocalSolution.setRate(0.0);
            for (int n = 0; n <= 200; ++n) {
                this.tempGh = this.generateNewGh(new ArrayList<Square>(this.initGhh), new ArrayList<Square>(this.tempGh));
                if (this.judge(this.tempGh)) continue;
                this.enterTabooList(this.tempGh);
                this.tempSolution = this.evaluate(new ArrayList<Square>(this.tempGh));
                if (!(this.tempSolution.getRate() > this.LocalSolution.getRate())) continue;
                this.LocalGh = new ArrayList<Square>(this.tempGh);
                this.LocalSolution = this.tempSolution;
            }
            if (this.LocalSolution.getRate() > this.bestSolution.getRate()) {
                this.bestT = this.t;
                this.bestGh = new ArrayList<Square>(this.LocalGh);
                this.bestSolution = this.LocalSolution;
            }
            this.initGhh = new ArrayList<Square>(this.LocalGh);
            ++this.t;
            System.out.println("\u5f53\u524d\u8fed\u4ee3\u6b21\u6570\u4e3a\uff1a" + this.t + ",\u5f53\u524d\u6700\u4f73\u5229\u7528\u7387\u4e3a\uff1a" + this.bestSolution.getRate());
        }
        System.out.println("\u6700\u4f73\u8fed\u4ee3\u6b21\u6570:" + this.bestT);
        System.out.println("\u6700\u4f73\u5229\u7528\u7387\u4e3a:" + this.bestSolution.getRate());
        System.out.println("\u7528\u65f6\uff1a" + (System.currentTimeMillis() - start) + "ms");
        return this.bestSolution;
    }

    public Solution evaluate(List<Square> squareList) {
        Solution solution = new Solution();
        solution.setInstance(this.instance);
        solution.setSquareList(new ArrayList<Square>(squareList));
        ArrayList<PlaceSquare> placeSquareList = new ArrayList<PlaceSquare>();
        ArrayList<PlacePoint> placePointList = new ArrayList<PlacePoint>();
        placePointList.add(new PlacePoint(0.0, 0.0, this.L));
        int i = 0;
        while (i < placePointList.size()) {
            PlacePoint placePoint = (PlacePoint)placePointList.get(i);
            double maxMark = -1.0;
            int maxIndex = -1;
            double isRotate = -1.0;
            double curMarks = -1.0;
            for (int j = 0; j < squareList.size(); ++j) {
                Square square = squareList.get(j);
                double[] arr = this.getMarks(placePoint, square, placeSquareList);
                double is_rotate = arr[0];
                curMarks = arr[1];
                if (!(curMarks > 0.0) || !(curMarks > maxMark)) continue;
                maxMark = curMarks;
                maxIndex = j;
                isRotate = is_rotate;
            }
            if (maxIndex < 0 && i < placePointList.size()) {
                ++i;
                continue;
            }
            if (maxIndex < 0 && i >= placePointList.size()) break;
            Square square = squareList.remove(maxIndex);
            double l = square.getL();
            double w = square.getW();
            if (isRotate > 0.0) {
                square.setL(w);
                square.setW(l);
            }
            placePointList.remove(i);
            placeSquareList.add(new PlaceSquare(placePoint.getX(), placePoint.getY(), square.getL(), square.getW()));
            double surplus = placePoint.getLen() - square.getL();
            if (surplus > 0.0) {
                placePointList.add(new PlacePoint(placePoint.getX() + square.getL(), placePoint.getY(), surplus));
            }
            placePointList.add(new PlacePoint(placePoint.getX(), placePoint.getY() + square.getW(), square.getL()));
            Collections.sort(placePointList);
            i = 0;
            if (!(isRotate > 0.0)) continue;
            square.setL(l);
            square.setW(w);
        }
        solution.setPlaceSquareList(new ArrayList<PlaceSquare>(placeSquareList));
        double rate = 0.0;
        double s = 0.0;
        for (PlaceSquare placeSquare : placeSquareList) {
            s += placeSquare.getL() * placeSquare.getW();
        }
        rate = s / (this.L * this.W);
        solution.setRate(rate);
        return solution;
    }

    private double[] getMarks(PlacePoint placePoint, Square square, List<PlaceSquare> placeSquareList) {
        double delta = 0.0;
        double mark1 = -1.0;
        double mark2 = -1.0;
        PlaceSquare placeSquare = new PlaceSquare(placePoint.getX(), placePoint.getY(), square.getL(), square.getW());
        if (this.isOverlap(placeSquareList, placeSquare)) {
            mark1 = -1.0;
        } else {
            delta = Math.abs(placePoint.getLen() - square.getL());
            mark1 = 1.0 - delta / placePoint.getLen();
        }
        mark2 = -1.0;
        if (this.instance.isRotateEnable() && !this.isOverlap(placeSquareList, placeSquare = new PlaceSquare(placePoint.getX(), placePoint.getY(), square.getW(), square.getL()))) {
            delta = Math.abs(placePoint.getLen() - square.getW());
            mark2 = 1.0 - delta / placePoint.getLen();
        }
        if (mark1 >= mark2) {
            return new double[]{-1.0, (int)(mark1 * 10.0)};
        }
        return new double[]{1.0, (int)(mark2 * 10.0)};
    }

    public boolean isOverlap(List<PlaceSquare> placeSquareList, PlaceSquare tempPlaceSquare) {
        if (tempPlaceSquare.getL() > this.L || tempPlaceSquare.getW() > this.W) {
            return true;
        }
        if (tempPlaceSquare.getX() + tempPlaceSquare.getL() > this.L || tempPlaceSquare.getY() + tempPlaceSquare.getW() > this.W) {
            return true;
        }
        for (PlaceSquare placeSquare : placeSquareList) {
            if (placeSquare.getX() == tempPlaceSquare.getX() && placeSquare.getY() == tempPlaceSquare.getY()) {
                placeSquareList.remove(placeSquare);
                return true;
            }
            if (!this.isOverlap2(placeSquare, tempPlaceSquare)) continue;
            return true;
        }
        return false;
    }

    public boolean isOverlap2(PlaceSquare placeSquare, PlaceSquare tempPlaceSquare) {
        double x1 = Math.max(placeSquare.getX(), tempPlaceSquare.getX());
        double y1 = Math.max(placeSquare.getY(), tempPlaceSquare.getY());
        double x2 = Math.min(placeSquare.getX() + placeSquare.getL(), tempPlaceSquare.getX() + tempPlaceSquare.getL());
        double y2 = Math.min(placeSquare.getY() + placeSquare.getW(), tempPlaceSquare.getY() + tempPlaceSquare.getW());
        return !(x1 >= x2) && !(y1 >= y2);
    }

    public void getInitSolution() throws Exception {
        Collections.shuffle(this.initGhh);
        this.tempSolution = this.bestSolution = this.evaluate(new ArrayList<Square>(this.initGhh));
        this.bestGh = new ArrayList<Square>(this.initGhh);
        this.tempGh = new ArrayList<Square>(this.initGhh);
        this.LocalGh = new ArrayList<Square>(this.initGhh);
    }

    public void enterTabooList(List<Square> squareList) {
        Square square;
        String id;
        if (this.tabuTreeMap == null) {
            this.tabuTreeMap = new HashMap();
        }
        if (this.tabuTreeMap.containsKey(id = (square = squareList.get(0)).getId())) {
            this.tabuTreeMap.get(id).add(new ArrayList<Square>(squareList), 1);
        } else {
            TabuMapTree tabuMapTree = new TabuMapTree();
            tabuMapTree.setNodeSquare(square);
            tabuMapTree.add(new ArrayList<Square>(squareList), 1);
            this.tabuTreeMap.put(id, tabuMapTree);
        }
    }

    public List<Square> generateNewGh(List<Square> localGh, List<Square> tempGh) {
        tempGh = new ArrayList<Square>(localGh);
        for (int i = 0; i < 6; ++i) {
            int r1 = 0;
            int r2 = 0;
            while (r1 == r2) {
                r1 = this.random.nextInt(tempGh.size());
                r2 = this.random.nextInt(tempGh.size());
            }
            Square temp = tempGh.get(r1);
            tempGh.set(r1, tempGh.get(r2));
            tempGh.set(r2, temp);
        }
        return new ArrayList<Square>(tempGh);
    }

    public boolean judge(List<Square> Gh) {
        Square square = Gh.get(0);
        if (this.tabuTreeMap.containsKey(square.getId())) {
            return this.tabuTreeMap.get(square.getId()).contains(Gh, 1);
        }
        return false;
    }

    public boolean isEq(Square square1, Square square2) {
        return square1.getId().equals(square2.getId());
    }

    public int getMAX_GEN() {
        return this.MAX_GEN;
    }

    public int getN() {
        return this.N;
    }

    public int getSqNum() {
        return this.sqNum;
    }

    public HashMap<String, TabuMapTree> getTabuTreeMap() {
        return this.tabuTreeMap;
    }

    public List<Square> getInitGhh() {
        return this.initGhh;
    }

    public List<Square> getBestGh() {
        return this.bestGh;
    }

    public List<Square> getLocalGh() {
        return this.LocalGh;
    }

    public List<Square> getTempGh() {
        return this.tempGh;
    }

    public int getBestT() {
        return this.bestT;
    }

    public Solution getBestSolution() {
        return this.bestSolution;
    }

    public Solution getLocalSolution() {
        return this.LocalSolution;
    }

    public Solution getTempSolution() {
        return this.tempSolution;
    }

    public int getT() {
        return this.t;
    }

    public Random getRandom() {
        return this.random;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public double getL() {
        return this.L;
    }

    public double getW() {
        return this.W;
    }

    public void setSqNum(int sqNum) {
        this.sqNum = sqNum;
    }

    public void setTabuTreeMap(HashMap<String, TabuMapTree> tabuTreeMap) {
        this.tabuTreeMap = tabuTreeMap;
    }

    public void setInitGhh(List<Square> initGhh) {
        this.initGhh = initGhh;
    }

    public void setBestGh(List<Square> bestGh) {
        this.bestGh = bestGh;
    }

    public void setLocalGh(List<Square> LocalGh) {
        this.LocalGh = LocalGh;
    }

    public void setTempGh(List<Square> tempGh) {
        this.tempGh = tempGh;
    }

    public void setBestT(int bestT) {
        this.bestT = bestT;
    }

    public void setBestSolution(Solution bestSolution) {
        this.bestSolution = bestSolution;
    }

    public void setLocalSolution(Solution LocalSolution) {
        this.LocalSolution = LocalSolution;
    }

    public void setTempSolution(Solution tempSolution) {
        this.tempSolution = tempSolution;
    }

    public void setT(int t) {
        this.t = t;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public void setInstance(Instance instance) {
        this.instance = instance;
    }

    public void setL(double L) {
        this.L = L;
    }

    public void setW(double W) {
        this.W = W;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TabuSearch02)) {
            return false;
        }
        TabuSearch02 other = (TabuSearch02)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMAX_GEN() != other.getMAX_GEN()) {
            return false;
        }
        if (this.getN() != other.getN()) {
            return false;
        }
        if (this.getSqNum() != other.getSqNum()) {
            return false;
        }
        HashMap<String, TabuMapTree> this$tabuTreeMap = this.getTabuTreeMap();
        HashMap<String, TabuMapTree> other$tabuTreeMap = other.getTabuTreeMap();
        if (this$tabuTreeMap == null ? other$tabuTreeMap != null : !((Object)this$tabuTreeMap).equals(other$tabuTreeMap)) {
            return false;
        }
        List<Square> this$initGhh = this.getInitGhh();
        List<Square> other$initGhh = other.getInitGhh();
        if (this$initGhh == null ? other$initGhh != null : !((Object)this$initGhh).equals(other$initGhh)) {
            return false;
        }
        List<Square> this$bestGh = this.getBestGh();
        List<Square> other$bestGh = other.getBestGh();
        if (this$bestGh == null ? other$bestGh != null : !((Object)this$bestGh).equals(other$bestGh)) {
            return false;
        }
        List<Square> this$LocalGh = this.getLocalGh();
        List<Square> other$LocalGh = other.getLocalGh();
        if (this$LocalGh == null ? other$LocalGh != null : !((Object)this$LocalGh).equals(other$LocalGh)) {
            return false;
        }
        List<Square> this$tempGh = this.getTempGh();
        List<Square> other$tempGh = other.getTempGh();
        if (this$tempGh == null ? other$tempGh != null : !((Object)this$tempGh).equals(other$tempGh)) {
            return false;
        }
        if (this.getBestT() != other.getBestT()) {
            return false;
        }
        Solution this$bestSolution = this.getBestSolution();
        Solution other$bestSolution = other.getBestSolution();
        if (this$bestSolution == null ? other$bestSolution != null : !((Object)this$bestSolution).equals(other$bestSolution)) {
            return false;
        }
        Solution this$LocalSolution = this.getLocalSolution();
        Solution other$LocalSolution = other.getLocalSolution();
        if (this$LocalSolution == null ? other$LocalSolution != null : !((Object)this$LocalSolution).equals(other$LocalSolution)) {
            return false;
        }
        Solution this$tempSolution = this.getTempSolution();
        Solution other$tempSolution = other.getTempSolution();
        if (this$tempSolution == null ? other$tempSolution != null : !((Object)this$tempSolution).equals(other$tempSolution)) {
            return false;
        }
        if (this.getT() != other.getT()) {
            return false;
        }
        Random this$random = this.getRandom();
        Random other$random = other.getRandom();
        if (this$random == null ? other$random != null : !this$random.equals(other$random)) {
            return false;
        }
        Instance this$instance = this.getInstance();
        Instance other$instance = other.getInstance();
        if (this$instance == null ? other$instance != null : !((Object)this$instance).equals(other$instance)) {
            return false;
        }
        if (Double.compare(this.getL(), other.getL()) != 0) {
            return false;
        }
        return Double.compare(this.getW(), other.getW()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof TabuSearch02;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMAX_GEN();
        result = result * 59 + this.getN();
        result = result * 59 + this.getSqNum();
        HashMap<String, TabuMapTree> $tabuTreeMap = this.getTabuTreeMap();
        result = result * 59 + ($tabuTreeMap == null ? 43 : ((Object)$tabuTreeMap).hashCode());
        List<Square> $initGhh = this.getInitGhh();
        result = result * 59 + ($initGhh == null ? 43 : ((Object)$initGhh).hashCode());
        List<Square> $bestGh = this.getBestGh();
        result = result * 59 + ($bestGh == null ? 43 : ((Object)$bestGh).hashCode());
        List<Square> $LocalGh = this.getLocalGh();
        result = result * 59 + ($LocalGh == null ? 43 : ((Object)$LocalGh).hashCode());
        List<Square> $tempGh = this.getTempGh();
        result = result * 59 + ($tempGh == null ? 43 : ((Object)$tempGh).hashCode());
        result = result * 59 + this.getBestT();
        Solution $bestSolution = this.getBestSolution();
        result = result * 59 + ($bestSolution == null ? 43 : ((Object)$bestSolution).hashCode());
        Solution $LocalSolution = this.getLocalSolution();
        result = result * 59 + ($LocalSolution == null ? 43 : ((Object)$LocalSolution).hashCode());
        Solution $tempSolution = this.getTempSolution();
        result = result * 59 + ($tempSolution == null ? 43 : ((Object)$tempSolution).hashCode());
        result = result * 59 + this.getT();
        Random $random = this.getRandom();
        result = result * 59 + ($random == null ? 43 : $random.hashCode());
        Instance $instance = this.getInstance();
        result = result * 59 + ($instance == null ? 43 : ((Object)$instance).hashCode());
        long $L = Double.doubleToLongBits(this.getL());
        result = result * 59 + (int)($L >>> 32 ^ $L);
        long $W = Double.doubleToLongBits(this.getW());
        result = result * 59 + (int)($W >>> 32 ^ $W);
        return result;
    }

    public String toString() {
        return "TabuSearch02(MAX_GEN=" + this.getMAX_GEN() + ", N=" + this.getN() + ", sqNum=" + this.getSqNum() + ", tabuTreeMap=" + this.getTabuTreeMap() + ", initGhh=" + this.getInitGhh() + ", bestGh=" + this.getBestGh() + ", LocalGh=" + this.getLocalGh() + ", tempGh=" + this.getTempGh() + ", bestT=" + this.getBestT() + ", bestSolution=" + this.getBestSolution() + ", LocalSolution=" + this.getLocalSolution() + ", tempSolution=" + this.getTempSolution() + ", t=" + this.getT() + ", random=" + this.getRandom() + ", instance=" + this.getInstance() + ", L=" + this.getL() + ", W=" + this.getW() + ")";
    }
}

