/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pg.tool.ws.util;

import com.yqbsoft.laser.service.pg.domain.PgGcfmgoodsDomain;
import com.yqbsoft.laser.service.pg.tool.ws.entity.Instance;
import com.yqbsoft.laser.service.pg.tool.ws.entity.Square;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public class ReadDataUtil {
    public Instance getInstance(String path) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(path));
        String input = null;
        Instance instance = new Instance();
        ArrayList<Square> squareList = new ArrayList<Square>();
        boolean isFirstLine = true;
        while ((input = bufferedReader.readLine()) != null) {
            String[] split = input.split(" ");
            if (isFirstLine) {
                instance.setL(Double.parseDouble(split[0]));
                instance.setW(Double.parseDouble(split[1]));
                if (split[2].equals("1")) {
                    instance.setRotateEnable(true);
                } else {
                    instance.setRotateEnable(false);
                }
                isFirstLine = false;
                continue;
            }
            squareList.add(new Square(UUID.randomUUID().toString(), Double.parseDouble(split[0]), Double.parseDouble(split[1])));
        }
        instance.setSquareList(squareList);
        return instance;
    }

    public Instance getInstance(List<PgGcfmgoodsDomain> pgLabelList, boolean b) throws IOException {
        Instance instance = new Instance();
        ArrayList<Square> squareList = new ArrayList<Square>();
        ArrayList<Double> areas = new ArrayList<Double>();
        double maxLength = 0.0;
        double maxHigh = 0.0;
        double tempH = 0.0;
        for (PgGcfmgoodsDomain pgLabel : pgLabelList) {
            Double[] places;
            if (!b) {
                this.inventSize(pgLabel);
            }
            if ((places = ReadDataUtil.doubleSort(pgLabel)) == null || places.length == 0) continue;
            tempH = places[0];
            squareList.add(new Square(UUID.randomUUID().toString(), places[1], places[2]));
            double v = places[1] * places[2];
            areas.add(v);
            maxLength = places[1] > places[2] ? places[1] : places[2];
            maxHigh = tempH > maxHigh ? tempH : maxHigh;
        }
        if (areas == null || areas.size() == 0) {
            return null;
        }
        double areaSum = areas.stream().mapToDouble(Double::doubleValue).sum();
        double sqrt = Math.sqrt(areaSum * 10.0 / 7.0);
        sqrt = sqrt > maxLength ? sqrt : maxLength;
        instance.setH(maxHigh);
        instance.setL(sqrt);
        instance.setW(sqrt);
        instance.setRotateEnable(true);
        instance.setSquareList(squareList);
        return instance;
    }

    private PgGcfmgoodsDomain inventSize(PgGcfmgoodsDomain pgLabel) {
        pgLabel.setLabelLength(ReadDataUtil.getRandomPacket(10.0, 150.0));
        pgLabel.setLabelWide(ReadDataUtil.getRandomPacket(10.0, 100.0));
        pgLabel.setLabelHigh(ReadDataUtil.getRandomPacket(10.0, 200.0));
        return pgLabel;
    }

    public static BigDecimal getRandomPacket(double min, double max) {
        BigDecimal db = new BigDecimal(Math.random() * (max - min) + min);
        return db.setScale(2, 1);
    }

    private static Double[] doubleSort(PgGcfmgoodsDomain pgLabel) {
        BigDecimal labelLength = pgLabel.getLabelLength();
        BigDecimal labelWide = pgLabel.getLabelWide();
        BigDecimal labelHigh = pgLabel.getLabelHigh();
        if (labelLength == null || labelWide == null || labelHigh == null) {
            return null;
        }
        Double pLength = Double.parseDouble(labelLength.toString());
        Double pWide = Double.parseDouble(labelWide.toString());
        Double pHigh = Double.parseDouble(labelHigh.toString());
        Double[] coll = new Double[]{pLength, pWide, pHigh};
        Arrays.sort(coll, (s1, s2) -> Double.compare(s2, s1));
        return coll;
    }
}

