/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.portal.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.portal.dao.CmsReleaseDetailsMapper;
import com.yqbsoft.laser.service.portal.domain.CmsReleaseDetailsDomain;
import com.yqbsoft.laser.service.portal.model.CmsAdvertise;
import com.yqbsoft.laser.service.portal.model.CmsPlayPlan;
import com.yqbsoft.laser.service.portal.model.CmsReleaseDetails;
import com.yqbsoft.laser.service.portal.service.CmsAdvertiseService;
import com.yqbsoft.laser.service.portal.service.CmsPlayPlanService;
import com.yqbsoft.laser.service.portal.service.CmsReleaseDetailsService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CmsReleaseDetailsServiceImpl
extends BaseServiceImpl
implements CmsReleaseDetailsService {
    public static final String SYS_CODE = "cms.CmsReleaseDetailsServiceImpl";
    private CmsReleaseDetailsMapper cmsReleaseDetailsMapper;
    private CmsAdvertiseService cmsAdvertiseService;
    private CmsPlayPlanService cmsPlayPlanService;

    public void setCmsReleaseDetailsMapper(CmsReleaseDetailsMapper cmsReleaseDetailsMapper) {
        this.cmsReleaseDetailsMapper = cmsReleaseDetailsMapper;
    }

    private Date getSysDate() {
        try {
            return this.cmsReleaseDetailsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsReleaseDetailsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkReleaseDetails(CmsReleaseDetailsDomain cmsReleaseDetailsDomain) {
        if (null == cmsReleaseDetailsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setReleaseDetailsDefault(CmsReleaseDetails cmsReleaseDetails) {
        if (null == cmsReleaseDetails) {
            return;
        }
        if (null == cmsReleaseDetails.getDataState()) {
            cmsReleaseDetails.setDataState(0);
        }
        if (null == cmsReleaseDetails.getGmtCreate()) {
            cmsReleaseDetails.setGmtCreate(this.getSysDate());
        }
        cmsReleaseDetails.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cmsReleaseDetails.getReleaseDetailsCode())) {
            cmsReleaseDetails.setReleaseDetailsCode(this.createUUIDString());
        }
    }

    private int getReleaseDetailsMaxCode() {
        int code = 0;
        try {
            return this.cmsReleaseDetailsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsReleaseDetailsServiceImpl.getReleaseDetailsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setReleaseDetailsUpdataDefault(CmsReleaseDetails cmsReleaseDetails) {
        if (null == cmsReleaseDetails) {
            return;
        }
        cmsReleaseDetails.setGmtModified(this.getSysDate());
    }

    private void saveReleaseDetailsModel(CmsReleaseDetails cmsReleaseDetails) throws ApiException {
        if (null == cmsReleaseDetails) {
            return;
        }
        try {
            this.cmsReleaseDetailsMapper.insert(cmsReleaseDetails);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsReleaseDetailsServiceImpl.saveReleaseDetailsModel.ex", (Throwable)e);
        }
    }

    private CmsReleaseDetails getReleaseDetailsModelById(Integer releaseDetailsId) {
        if (null == releaseDetailsId) {
            return null;
        }
        try {
            return this.cmsReleaseDetailsMapper.selectByPrimaryKey(releaseDetailsId);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsReleaseDetailsServiceImpl.getReleaseDetailsModelById", (Throwable)e);
            return null;
        }
    }

    public CmsReleaseDetails getReleaseDetailsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmsReleaseDetailsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsReleaseDetailsServiceImpl.getReleaseDetailsModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delReleaseDetailsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsReleaseDetailsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsReleaseDetailsServiceImpl.delReleaseDetailsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsReleaseDetailsServiceImpl.delReleaseDetailsModelByCode.num");
        }
    }

    private void deleteReleaseDetailsModel(Integer releaseDetailsId) throws ApiException {
        if (null == releaseDetailsId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsReleaseDetailsMapper.deleteByPrimaryKey(releaseDetailsId);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsReleaseDetailsServiceImpl.deleteReleaseDetailsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsReleaseDetailsServiceImpl.deleteReleaseDetailsModel.num");
        }
    }

    private void updateReleaseDetailsModel(CmsReleaseDetails cmsReleaseDetails) throws ApiException {
        if (null == cmsReleaseDetails) {
            return;
        }
        try {
            this.cmsReleaseDetailsMapper.updateByPrimaryKeySelective(cmsReleaseDetails);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsReleaseDetailsServiceImpl.updateReleaseDetailsModel.ex", (Throwable)e);
        }
    }

    private void updateStateReleaseDetailsModel(Integer releaseDetailsId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == releaseDetailsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("releaseDetailsId", releaseDetailsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cmsReleaseDetailsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsReleaseDetailsServiceImpl.updateStateReleaseDetailsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsReleaseDetailsServiceImpl.updateStateReleaseDetailsModel.null");
        }
    }

    private CmsReleaseDetails makeReleaseDetails(CmsReleaseDetailsDomain cmsReleaseDetailsDomain, CmsReleaseDetails cmsReleaseDetails) {
        if (null == cmsReleaseDetailsDomain) {
            return null;
        }
        if (null == cmsReleaseDetails) {
            cmsReleaseDetails = new CmsReleaseDetails();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)cmsReleaseDetails, (Object)cmsReleaseDetailsDomain);
            return cmsReleaseDetails;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsReleaseDetailsServiceImpl.makeReleaseDetails", (Throwable)e);
            return null;
        }
    }

    private List<CmsReleaseDetails> queryReleaseDetailsModelPage(Map<String, Object> parammap) {
        try {
            return this.cmsReleaseDetailsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsReleaseDetailsServiceImpl.queryReleaseDetailsModel", (Throwable)e);
            return null;
        }
    }

    private int countReleaseDetails(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmsReleaseDetailsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsReleaseDetailsServiceImpl.countReleaseDetails", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveReleaseDetails(CmsReleaseDetailsDomain cmsReleaseDetailsDomain) throws ApiException {
        String msg = this.checkReleaseDetails(cmsReleaseDetailsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsReleaseDetailsServiceImpl.saveReleaseDetails.checkReleaseDetails", msg);
        }
        CmsReleaseDetails cmsReleaseDetails = this.makeReleaseDetails(cmsReleaseDetailsDomain, null);
        this.setReleaseDetailsDefault(cmsReleaseDetails);
        this.saveReleaseDetailsModel(cmsReleaseDetails);
        return cmsReleaseDetails.getReleaseDetailsCode();
    }

    @Override
    public void updateReleaseDetailsState(Integer releaseDetailsId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateReleaseDetailsModel(releaseDetailsId, dataState, oldDataState);
    }

    @Override
    public void updateReleaseDetails(CmsReleaseDetailsDomain cmsReleaseDetailsDomain) throws ApiException {
        String msg = this.checkReleaseDetails(cmsReleaseDetailsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsReleaseDetailsServiceImpl.updateReleaseDetails.checkReleaseDetails", msg);
        }
        CmsReleaseDetails oldCmsReleaseDetails = null;
        if (cmsReleaseDetailsDomain.getReleaseDetailsId() == null || cmsReleaseDetailsDomain.getReleaseDetailsId() == 0) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("releaseDetailsCode", cmsReleaseDetailsDomain.getReleaseDetailsCode());
            map.put("tenantCode", cmsReleaseDetailsDomain.getTenantCode());
            oldCmsReleaseDetails = this.getReleaseDetailsModelByCode(map);
        } else {
            oldCmsReleaseDetails = this.getReleaseDetailsModelById(cmsReleaseDetailsDomain.getReleaseDetailsId());
        }
        if (null == oldCmsReleaseDetails) {
            throw new ApiException("cms.CmsReleaseDetailsServiceImpl.updateReleaseDetails.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CmsReleaseDetails cmsReleaseDetails = this.makeReleaseDetails(cmsReleaseDetailsDomain, oldCmsReleaseDetails);
        this.setReleaseDetailsUpdataDefault(cmsReleaseDetails);
        this.updateReleaseDetailsModel(cmsReleaseDetails);
    }

    @Override
    public CmsReleaseDetails getReleaseDetails(Integer releaseDetailsId) {
        return this.getReleaseDetailsModelById(releaseDetailsId);
    }

    @Override
    public void deleteReleaseDetails(Integer releaseDetailsId) throws ApiException {
        this.deleteReleaseDetailsModel(releaseDetailsId);
    }

    @Override
    public QueryResult<CmsReleaseDetails> queryReleaseDetailsPage(Map<String, Object> map) {
        List<CmsReleaseDetails> cmsReleaseDetailsList = this.queryReleaseDetailsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countReleaseDetails(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmsReleaseDetailsList);
        return queryResult;
    }

    @Override
    public CmsReleaseDetails getReleaseDetailsByCode(Map<String, Object> map) {
        return this.getReleaseDetailsModelByCode(map);
    }

    @Override
    public void delReleaseDetailsByCode(Map<String, Object> map) throws ApiException {
        this.delReleaseDetailsModelByCode(map);
    }

    private void sendMnsCms(String acceptCode, String acceptName, String tenantCode, Map<String, Object> contentMap) {
        contentMap.put("datetime", DateUtil.getDateStr((String)"yyyy-MM-dd HH:mm:ss"));
        ConcurrentHashMap<String, String> mnsMap = new ConcurrentHashMap<String, String>();
        String mnsconfigBusType = "2";
        mnsMap.put("mnslistSubject", "\u5e7f\u544a\u6295\u653e\u63a8\u9001");
        mnsMap.put("mnslistSource", "0");
        mnsMap.put("mnslistBusType", mnsconfigBusType);
        mnsMap.put("mnslistBusName", "\u5e7f\u544a\u6295\u653e\u63a8\u9001");
        mnsMap.put("mnslistExp", this.getMnslistExp(contentMap, "sys", "sys", acceptCode, acceptName, "1", "1", DateUtil.getDateStr((String)"yyyy-MM-dd HH:mm:ss"), mnsconfigBusType));
        mnsMap.put("tenantCode", tenantCode);
        ConcurrentHashMap<String, String> sendMap = new ConcurrentHashMap<String, String>();
        sendMap.put("mnsMnslistDomainBean", JsonUtil.buildNormalBinder().toJson(mnsMap));
        this.inAsyncInvoke("mns.mns.saveSendMnslist", sendMap);
    }

    private String getMnslistExp(Map<String, Object> contentMap, String imsgSuserCode, String imsgSuserName, String acceptCode, String acceptName, String pushObjType, String pushmsgJpushType, String pushSendDate, String businessObject) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.putAll(contentMap);
        ArrayList receiverList = new ArrayList();
        HashMap<String, String> parm = new HashMap<String, String>();
        parm.put("code", acceptCode);
        parm.put("name", acceptName);
        receiverList.add(parm);
        HashMap<String, String> expMap = new HashMap<String, String>();
        expMap.put("receiverList", JsonUtil.buildNormalBinder().toJson(receiverList));
        expMap.put("pushmsgType", pushObjType);
        expMap.put("pushmsgJpushType", pushmsgJpushType);
        expMap.put("pushmsgSenddate", pushSendDate);
        expMap.put("imsgSuserCode", imsgSuserCode);
        expMap.put("imsgSuserName", imsgSuserName);
        expMap.put("mnsconfigBusType", businessObject);
        expMap.put("paramMap", JsonUtil.buildNormalBinder().toJson(paramMap));
        return JsonUtil.buildNonDefaultBinder().toJson(expMap);
    }

    @Override
    public int saveReleaseDetailsBatch(List<CmsReleaseDetailsDomain> list) throws ApiException {
        ArrayList<CmsReleaseDetails> cmsReleaseDetailss = new ArrayList<CmsReleaseDetails>();
        boolean currentPush = false;
        for (CmsReleaseDetailsDomain cmsReleaseDetailsDomain : list) {
            String msg = this.checkReleaseDetails(cmsReleaseDetailsDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                throw new ApiException("cms.CmsReleaseDetailsServiceImpl.saveReleaseDetailsBatch.checkReleaseDetails", msg);
            }
            CmsReleaseDetails cmsReleaseDetails = this.makeReleaseDetails(cmsReleaseDetailsDomain, null);
            this.setReleaseDetailsDefault(cmsReleaseDetails);
            cmsReleaseDetailss.add(cmsReleaseDetails);
            if (currentPush || cmsReleaseDetailsDomain.getReleaseType() != 1) continue;
            currentPush = true;
        }
        int i = this.saveReleaseDetailsBatchModel(cmsReleaseDetailss);
        if (currentPush) {
            this.sendRelease(cmsReleaseDetailss);
        }
        return i;
    }

    private int saveReleaseDetailsBatchModel(List<CmsReleaseDetails> cmsReleaseDetailss) {
        if (null == cmsReleaseDetailss || cmsReleaseDetailss.size() == 0) {
            return 0;
        }
        try {
            return this.cmsReleaseDetailsMapper.insertBatch(cmsReleaseDetailss);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsReleaseDetailsServiceImpl.saveReleaseDetailsBatchModel.ex", (Throwable)e);
        }
    }

    @Override
    public void taskReleaseDetailsCms() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataState", 1);
        List<CmsReleaseDetails> list = this.queryReleaseDetailsModelPage(map);
        this.sendRelease(list);
    }

    private void taskNeedParam(Map<String, Object> map) {
        String[] formats;
        String intervalMethod = DisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-cmsjupsh-interval");
        String dateshowformat = "yyyy-MM-dd";
        map.put("dataFormat", "%Y-%m-%d");
        if (!StringUtils.isEmpty((String)intervalMethod) && (formats = intervalMethod.split("\\|")) != null && formats.length >= 2) {
            dateshowformat = formats[0];
            map.put("dataFormat", formats[1]);
        }
        map.put("advelinkReleasetimeDay", DateUtil.getDateStr((String)dateshowformat));
    }

    private void sendRelease(List<CmsReleaseDetails> list) {
        if (ListUtil.isNotEmpty(list)) {
            QueryResult<CmsAdvertise> cmsAdvertiseResult;
            HashMap<String, Object> map = new HashMap<String, Object>();
            HashSet<String> cmsAdvertiseCodes = new HashSet<String>();
            for (CmsReleaseDetails cmsReleaseDetails : list) {
                if (StringUtils.isEmpty((String)cmsReleaseDetails.getAdvertiseCode())) continue;
                cmsAdvertiseCodes.add(cmsReleaseDetails.getAdvertiseCode());
            }
            map.clear();
            map.put("cmsAdvertiseCodes", cmsAdvertiseCodes);
            if (ListUtil.isNotEmpty(cmsAdvertiseCodes) && (cmsAdvertiseResult = this.cmsAdvertiseService.queryadvertisePage(map)) != null && ListUtil.isNotEmpty((Collection)cmsAdvertiseResult.getList())) {
                List cmsAdvertises = cmsAdvertiseResult.getList();
                this.sendCmsMores(cmsAdvertises, list);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sendCmsMores(List<CmsAdvertise> cmsAdvertises, List<CmsReleaseDetails> list) {
        boolean bl;
        HashMap<String, String> elevator = new HashMap<String, String>();
        HashSet<String> advertiseCodes = new HashSet<String>();
        for (CmsReleaseDetails cmsReleaseDetails : list) {
            elevator.put(cmsReleaseDetails.getOtherBillon(), cmsReleaseDetails.getTenantCode());
            advertiseCodes.add(cmsReleaseDetails.getAdvertiseCode());
        }
        HashMap elevatorMap = new HashMap();
        for (Map.Entry entry : elevator.entrySet()) {
            HashMap tempMap = new HashMap();
            for (CmsReleaseDetails cmsReleaseDetails : list) {
                if (!((String)entry.getKey()).equals(cmsReleaseDetails.getOtherBillon())) continue;
                tempMap.put(cmsReleaseDetails.getAdvertiseCode(), cmsReleaseDetails.getTenantCode());
            }
            elevatorMap.put(entry.getKey(), tempMap);
        }
        boolean bl2 = false;
        String string = "";
        for (Map.Entry entry : elevatorMap.entrySet()) {
            void var7_12;
            Map advertiseMaps = (Map)entry.getValue();
            ArrayList contentList = new ArrayList();
            for (Map.Entry advertiseMap : advertiseMaps.entrySet()) {
                String string2 = (String)advertiseMap.getValue();
                for (CmsAdvertise temp : cmsAdvertises) {
                    if (!((String)advertiseMap.getKey()).equals(temp.getAdvertiseCode())) continue;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("advertiseCode", temp.getAdvertiseCode());
                    map.put("advertiseTitle", temp.getAdvertiseNameNow());
                    map.put("advertiseType", temp.getAdvertiseTypeNow());
                    map.put("advertiseRemark", temp.getAdvertiseRemarkNow());
                    map.put("advertiseUrl", temp.getAdvertiseUrlNow());
                    map.put("advelinkReleasetime", temp.getAdvelinkReleasetime());
                    map.put("releaseday", temp.getReleaseday());
                    contentList.add(map);
                }
            }
            HashMap<String, Object> contentMap = new HashMap<String, Object>();
            contentMap.put("content", "\u5e7f\u544a\u6295\u653e");
            contentMap.put("cmsAdvertises", JsonUtil.buildNonDefaultBinder().toJson(contentList));
            this.sendMnsCms((String)entry.getKey(), "\u5e7f\u544a\u63a5\u6536\u7ec8\u7aef\u53f7", (String)var7_12, contentMap);
            if (bl) continue;
            bl = true;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (bl && ListUtil.isNotEmpty(advertiseCodes)) {
            map.put("advertiseCodes", advertiseCodes);
            this.updateCmsNotReleaseModel(map);
        }
    }

    private void sendCmsSignle(List<CmsAdvertise> cmsAdvertises, List<CmsReleaseDetails> list) {
        boolean sendFlag = false;
        HashSet<String> advertiseCodes = new HashSet<String>();
        HashMap cmsMain = new HashMap();
        for (CmsAdvertise cmsAdvertise : cmsAdvertises) {
            HashMap<String, Object> cmsMainObj = new HashMap<String, Object>();
            cmsMainObj.put("advertiseCode", cmsAdvertise.getAdvertiseCode());
            cmsMainObj.put("advertiseType", cmsAdvertise.getAdvertiseTypeNow());
            cmsMainObj.put("advertiseRemark", cmsAdvertise.getAdvertiseRemarkNow());
            cmsMainObj.put("advertiseUrl", cmsAdvertise.getAdvertiseUrlNow());
            cmsMainObj.put("releaseday", cmsAdvertise.getReleaseday());
            cmsMainObj.put("content", cmsAdvertise.getAdvertiseNameNow());
            cmsMain.put(cmsAdvertise.getAdvertiseCode(), cmsMainObj);
            advertiseCodes.add(cmsAdvertise.getAdvertiseCode());
        }
        HashMap<String, Object> contentMap = new HashMap<String, Object>();
        for (CmsReleaseDetails cmsReleaseDetails : list) {
            for (Map.Entry entry : cmsMain.entrySet()) {
                if (!((String)entry.getKey()).equals(cmsReleaseDetails.getAdvertiseCode())) continue;
                Map entryVal = (Map)entry.getValue();
                contentMap.putAll(entryVal);
                break;
            }
            this.sendMnsCms(cmsReleaseDetails.getOtherBillon(), "\u5e7f\u544a\u63a5\u6536\u7ec8\u7aef\u53f7", cmsReleaseDetails.getTenantCode(), contentMap);
            sendFlag = true;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (sendFlag && ListUtil.isNotEmpty(advertiseCodes)) {
            hashMap.put("advertiseCodes", advertiseCodes);
            this.updateCmsNotReleaseModel(hashMap);
        }
    }

    public void updateCmsNotReleaseModel(Map<String, Object> map) {
        try {
            this.cmsReleaseDetailsMapper.updateCmsNotRelease(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsReleaseDetailsServiceImpl.updateCmsNotReleaseModel.ex", (Throwable)e);
        }
    }

    public void setCmsAdvertiseService(CmsAdvertiseService cmsAdvertiseService) {
        this.cmsAdvertiseService = cmsAdvertiseService;
    }

    @Override
    public void updateFlushReleaseDetailsCms() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("flag", true);
        map.put("dataFormat", true);
        map.put("advelinkReleasetimeDay", true);
        this.taskNeedParam(map);
        List<CmsReleaseDetails> list = this.queryReleaseDetailsModelPage(map);
        int count = this.updateReleaseStateModel(map);
        if (count == list.size()) {
            this.sendRelease(list);
        }
        map.clear();
        map.put("flag", false);
        this.updateReleaseStateModel(map);
    }

    private int updateReleaseStateModel(Map<String, Object> map) {
        try {
            return this.cmsReleaseDetailsMapper.updateReleaseState(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsReleaseDetailsServiceImpl.updateReleaseStateModel.ex", (Object)"\u5b9a\u65f6\u5237\u65b0\u5e7f\u544a\u72b6\u6001\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5");
            return 0;
        }
    }

    @Override
    public List<CmsReleaseDetails> queryReleaseDetailsList(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        String relationType = "1";
        if (map.containsKey("relationType") && map.get("relationType") != null) {
            relationType = String.valueOf(map.get("relationType"));
        }
        List<CmsReleaseDetails> cmsReleaseDetailsList = this.queryReleaseDetailsModelPage(map);
        HashSet<String> set = new HashSet<String>();
        HashMap<String, CmsReleaseDetails> detailsMap = new HashMap<String, CmsReleaseDetails>();
        for (CmsReleaseDetails detailsTemp : cmsReleaseDetailsList) {
            set.add(detailsTemp.getAdvertiseCode());
            String key = detailsTemp.getAdvertiseCode() + "-";
            key = "1".equals(relationType) ? key + detailsTemp.getOtherBillon() : key + detailsTemp.getAreaCode();
            detailsMap.put(key, detailsTemp);
        }
        Integer flag = 0;
        if (map.containsKey("filterTime")) {
            flag = Integer.valueOf(String.valueOf(map.get("filterTime")));
        }
        String relationBillon = "";
        if (map.containsKey("relationBillon")) {
            relationBillon = String.valueOf(map.get("relationBillon"));
        }
        if (flag == 1) {
            HashMap<String, CmsReleaseDetails> addMap = new HashMap<String, CmsReleaseDetails>();
            if (ListUtil.isNotEmpty(set)) {
                List<CmsPlayPlan> playPlanList;
                map.put("advertiseCodes", set);
                map.put("relationType", relationType);
                if (StringUtils.isNotBlank((String)relationBillon)) {
                    map.put("relationBillon", relationBillon);
                }
                if (ListUtil.isNotEmpty(playPlanList = this.cmsPlayPlanService.queryPlayPlanList(map))) {
                    HashSet<String> strs = new HashSet<String>();
                    for (CmsPlayPlan cmsPlayPlan : playPlanList) {
                        Integer cycleType;
                        String endCycleStr;
                        String key = cmsPlayPlan.getAdvertiseCode() + "-" + cmsPlayPlan.getRelationBillon();
                        CmsReleaseDetails cmsRelease = (CmsReleaseDetails)detailsMap.get(key);
                        if (cmsRelease == null) continue;
                        strs.add(key);
                        String beginCycleStr = cmsPlayPlan.getBeginCycle();
                        boolean has = this.validateHasCurrent(beginCycleStr, endCycleStr = cmsPlayPlan.getEndCycle(), cycleType = cmsPlayPlan.getCycleType());
                        if (!has) continue;
                        addMap.put(key, cmsRelease);
                    }
                    for (String key : strs) {
                        detailsMap.remove(key);
                    }
                }
            }
            if (MapUtil.isNotEmpty(addMap)) {
                detailsMap.putAll(addMap);
            }
        }
        if (MapUtil.isNotEmpty(detailsMap)) {
            ArrayList<CmsReleaseDetails> list = new ArrayList<CmsReleaseDetails>();
            for (Map.Entry entry : detailsMap.entrySet()) {
                list.add((CmsReleaseDetails)entry.getValue());
            }
            return list;
        }
        return cmsReleaseDetailsList;
    }

    private boolean validateHasCurrent(String beginCycleStr, String endCycleStr, Integer cycleType) {
        int monthDay;
        boolean flag = false;
        int beginCycle = Integer.valueOf(beginCycleStr);
        int endCycle = Integer.valueOf(endCycleStr);
        if (cycleType == 1) {
            int hour = DateUtils.getHour((Date)new Date());
            if (beginCycle <= hour && hour < endCycle) {
                return true;
            }
        } else if (cycleType == 2) {
            int week = DateUtils.getWeek((Date)new Date());
            if (beginCycle <= --week && week < endCycle) {
                return true;
            }
        } else if (cycleType == 3 && beginCycle <= (monthDay = DateUtils.getMonthDay((Date)new Date())) && monthDay < endCycle) {
            return true;
        }
        return flag;
    }

    public CmsPlayPlanService getCmsPlayPlanService() {
        return this.cmsPlayPlanService;
    }

    public void setCmsPlayPlanService(CmsPlayPlanService cmsPlayPlanService) {
        this.cmsPlayPlanService = cmsPlayPlanService;
    }
}

