/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.portal.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.portal.dao.CmsTginfoMapper;
import com.yqbsoft.laser.service.portal.domain.CmsContlistDomain;
import com.yqbsoft.laser.service.portal.domain.CmsConttitleDomain;
import com.yqbsoft.laser.service.portal.domain.CmsTginfoDomain;
import com.yqbsoft.laser.service.portal.domain.CmsTginfoMenuDomain;
import com.yqbsoft.laser.service.portal.domain.DisChannelDomain;
import com.yqbsoft.laser.service.portal.domain.TmProappEnvDomain;
import com.yqbsoft.laser.service.portal.domain.TmProappMenuReDomain;
import com.yqbsoft.laser.service.portal.domain.UmUser;
import com.yqbsoft.laser.service.portal.domain.UmUserinfo;
import com.yqbsoft.laser.service.portal.model.CmsContlist;
import com.yqbsoft.laser.service.portal.model.CmsConttitle;
import com.yqbsoft.laser.service.portal.model.CmsTginfo;
import com.yqbsoft.laser.service.portal.model.CmsTginfoMenu;
import com.yqbsoft.laser.service.portal.service.CmsConttitleService;
import com.yqbsoft.laser.service.portal.service.CmsTginfoMenuService;
import com.yqbsoft.laser.service.portal.service.CmsTginfoService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CmsTginfoServiceImpl
extends BaseServiceImpl
implements CmsTginfoService {
    public static final String SYS_CODE = "cms.CmsTginfoServiceImpl";
    private CmsTginfoMapper cmsTginfoMapper;
    private CmsTginfoMenuService cmsTginfoMenuService;
    CmsConttitleService cmsConttitleService;
    String apiCode = "tm.proapp.queryMenuHtmlByProapp";
    private static String DDF_KEY = "DdFalgSetting-key";
    private static String tenant_Code = "00000000";
    private static String Proapp_Menu = "proappMenu";
    private static final ExecutorService pool = Executors.newFixedThreadPool(2);
    String envapiCode = "tm.proapp.queryProappEnvPage";

    public void setCmsTginfoMapper(CmsTginfoMapper cmsTginfoMapper) {
        this.cmsTginfoMapper = cmsTginfoMapper;
    }

    public CmsTginfoMenuService getCmsTginfoMenuService() {
        return this.cmsTginfoMenuService;
    }

    public void setCmsTginfoMenuService(CmsTginfoMenuService cmsTginfoMenuService) {
        this.cmsTginfoMenuService = cmsTginfoMenuService;
    }

    public void setCmsConttitleService(CmsConttitleService cmsConttitleService) {
        this.cmsConttitleService = cmsConttitleService;
    }

    private Date getSysDate() {
        try {
            return this.cmsTginfoMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkTginfo(CmsTginfoDomain cmsTginfoDomain) {
        if (null == cmsTginfoDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cmsTginfoDomain.getOauthEnvCode())) {
            msg = msg + "OauthEnvCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cmsTginfoDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cmsTginfoDomain.getTginfoExchangeurl()) && StringUtils.isBlank((String)cmsTginfoDomain.getTginfoCompanyurl())) {
            msg = msg + cmsTginfoDomain.getProappCode() + " TginfoCompanyurl\u3001TginfoExchangeurl\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setTginfoDefault(CmsTginfo cmsTginfo) {
        if (null == cmsTginfo) {
            return;
        }
        if (null == cmsTginfo.getDataState()) {
            cmsTginfo.setDataState(0);
        }
        if (null == cmsTginfo.getGmtCreate()) {
            cmsTginfo.setGmtCreate(this.getSysDate());
        }
        cmsTginfo.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cmsTginfo.getTginfoCode())) {
            cmsTginfo.setTginfoCode(this.createUUIDString());
        }
    }

    private int getTginfoMaxCode() {
        int code = 0;
        try {
            return this.cmsTginfoMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoServiceImpl.getTginfoMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTginfoUpdataDefault(CmsTginfo cmsTginfo) {
        if (null == cmsTginfo) {
            return;
        }
        cmsTginfo.setGmtModified(this.getSysDate());
    }

    private void saveTginfoModel(CmsTginfo cmsTginfo) throws ApiException {
        if (null == cmsTginfo) {
            return;
        }
        try {
            this.cmsTginfoMapper.insert(cmsTginfo);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoServiceImpl.saveTginfoModel.ex", (Throwable)e);
        }
    }

    private CmsTginfo getTginfoModelById(Integer tginfoId) {
        if (null == tginfoId) {
            return null;
        }
        try {
            return this.cmsTginfoMapper.selectByPrimaryKey(tginfoId);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoServiceImpl.getTginfoModelById", (Throwable)e);
            return null;
        }
    }

    public CmsTginfo getTginfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmsTginfoMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoServiceImpl.getTginfoModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delTginfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsTginfoMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoServiceImpl.delTginfoModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsTginfoServiceImpl.delTginfoModelByCode.num");
        }
    }

    private void deleteTginfoModel(Integer tginfoId) throws ApiException {
        if (null == tginfoId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsTginfoMapper.deleteByPrimaryKey(tginfoId);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoServiceImpl.deleteTginfoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsTginfoServiceImpl.deleteTginfoModel.num");
        }
    }

    private void updateTginfoModel(CmsTginfo cmsTginfo) throws ApiException {
        if (null == cmsTginfo) {
            return;
        }
        try {
            this.cmsTginfoMapper.updateByPrimaryKeySelective(cmsTginfo);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoServiceImpl.updateTginfoModel.ex", (Throwable)e);
        }
    }

    private void updateStateTginfoModel(Integer tginfoId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == tginfoId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tginfoId", tginfoId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cmsTginfoMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoServiceImpl.updateStateTginfoModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsTginfoServiceImpl.updateStateTginfoModel.null");
        }
    }

    private CmsTginfo makeTginfo(CmsTginfoDomain cmsTginfoDomain, CmsTginfo cmsTginfo) {
        if (null == cmsTginfoDomain) {
            return null;
        }
        if (null == cmsTginfo) {
            cmsTginfo = new CmsTginfo();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmsTginfo, (Object)cmsTginfoDomain);
            return cmsTginfo;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoServiceImpl.makeTginfo", (Throwable)e);
            return null;
        }
    }

    private void makeTgInfoChannelCode(CmsTginfoDomain cmsTginfoDomain, CmsTginfo cmsTginfo) {
        DisChannelDomain channelDomain = (DisChannelDomain)SupDisUtil.getMapJson((String)"DisChannel-memberCode", (String)(cmsTginfoDomain.getMemberCode() + "-0-" + cmsTginfoDomain.getTenantCode()), DisChannelDomain.class);
        if (channelDomain != null && StringUtils.isNotBlank((String)channelDomain.getChannelCode())) {
            cmsTginfo.setChannelCode(channelDomain.getChannelCode());
            cmsTginfo.setChannelName(channelDomain.getChannelName());
        }
    }

    private List<CmsTginfo> queryTginfoModelPage(Map<String, Object> parammap) {
        try {
            return this.cmsTginfoMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoServiceImpl.queryTginfoModel", (Throwable)e);
            return null;
        }
    }

    private int countTginfo(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmsTginfoMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoServiceImpl.countTginfo", (Throwable)e);
        }
        return i;
    }

    private void saveTginfoBatchModel(List<CmsTginfo> cmsTginfoList) throws ApiException {
        if (null == cmsTginfoList || cmsTginfoList.isEmpty()) {
            return;
        }
        try {
            this.cmsTginfoMapper.insertBatch(cmsTginfoList);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoServiceImpl.saveTginfoBatchModel.ex", (Throwable)e);
        }
    }

    @Override
    public String saveTginfo(CmsTginfoDomain cmsTginfoDomain) throws ApiException {
        List<CmsTginfo> list;
        String msg = this.checkTginfo(cmsTginfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsTginfoServiceImpl.saveTginfo.checkTginfo", msg);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", cmsTginfoDomain.getTenantCode());
        map.put("proappCode", cmsTginfoDomain.getProappCode());
        map.put("channelCode", cmsTginfoDomain.getChannelCode());
        map.put("memberCode", cmsTginfoDomain.getMemberCode());
        map.put("memberMcode", cmsTginfoDomain.getMemberMcode());
        boolean saveflag = true;
        CmsTginfo oldCmsTginfo = null;
        CmsTginfo cmsTginfo = null;
        if (StringUtils.isNotBlank((String)cmsTginfoDomain.getProappCode()) && ListUtil.isNotEmpty(list = this.queryTginfoModelPage(map))) {
            saveflag = false;
            oldCmsTginfo = list.get(0);
        }
        String code = "";
        this.logger.error("cms.CmsTginfoServiceImplsaveTginfo.saveflag", (Object)(saveflag + "cmsTginfo=" + JsonUtil.buildNonNullBinder().toJson((Object)cmsTginfoDomain)));
        if (saveflag) {
            cmsTginfo = this.makeTginfo(cmsTginfoDomain, null);
            this.makeTgInfoChannelCode(cmsTginfoDomain, cmsTginfo);
            this.setTginfoDefault(cmsTginfo);
            this.saveTginfoModel(cmsTginfo);
            this.logger.error("cms.CmsTginfoServiceImplsaveTginfo.cmsTginfo", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)cmsTginfo));
            code = cmsTginfo.getTginfoCode();
        } else {
            code = oldCmsTginfo.getTginfoCode();
            cmsTginfo = this.makeTginfo(cmsTginfoDomain, oldCmsTginfo);
            this.setTginfoUpdataDefault(cmsTginfo);
            this.updateTginfoModel(cmsTginfo);
            cmsTginfo.setTginfoCode(code);
            this.logger.error("cms.CmsTginfoServiceImplsaveTginfo.cmsTginfo", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)cmsTginfo));
        }
        this.updateCache(cmsTginfo);
        this.savemenu(code, cmsTginfo.getProappCode(), cmsTginfo.getTenantCode());
        return code;
    }

    @Override
    public String saveTginfoAndChannel(CmsTginfoDomain cmsTginfoDomain) throws ApiException {
        List<CmsTginfo> list;
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("cmsTginfoDomain", JsonUtil.buildNormalBinder().toJson((Object)cmsTginfoDomain));
        String channelCode = this.internalInvoke("dis.channelsendBase.sendSaveChannleTginfo", param);
        if (StringUtils.isBlank((String)channelCode)) {
            throw new ApiException("cms.CmsTginfoServiceImpl.saveTginfo.makeDisChannel", "\u6e20\u9053\u521b\u5efa\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        cmsTginfoDomain.setChannelCode(channelCode);
        String msg = this.checkTginfo(cmsTginfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsTginfoServiceImpl.saveTginfo.checkTginfo", msg);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", cmsTginfoDomain.getTenantCode());
        map.put("proappCode", cmsTginfoDomain.getProappCode());
        map.put("channelCode", cmsTginfoDomain.getChannelCode());
        map.put("memberCode", cmsTginfoDomain.getMemberCode());
        map.put("memberMcode", cmsTginfoDomain.getMemberMcode());
        boolean saveflag = true;
        CmsTginfo oldCmsTginfo = null;
        CmsTginfo cmsTginfo = null;
        if (StringUtils.isNotBlank((String)cmsTginfoDomain.getProappCode()) && ListUtil.isNotEmpty(list = this.queryTginfoModelPage(map))) {
            saveflag = false;
            oldCmsTginfo = list.get(0);
        }
        String code = "";
        if (saveflag) {
            cmsTginfo = this.makeTginfo(cmsTginfoDomain, null);
            this.setTginfoDefault(cmsTginfo);
            this.saveTginfoModel(cmsTginfo);
            code = cmsTginfo.getTginfoCode();
        } else {
            code = oldCmsTginfo.getTginfoCode();
            cmsTginfo = this.makeTginfo(cmsTginfoDomain, oldCmsTginfo);
            this.setTginfoUpdataDefault(cmsTginfo);
            this.updateTginfoModel(cmsTginfo);
            cmsTginfo.setTginfoCode(code);
        }
        this.updateCache(cmsTginfo);
        this.savemenu(code, cmsTginfo.getProappCode(), cmsTginfo.getTenantCode());
        return code;
    }

    private String getUrl(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        String value = SupDisUtil.getMap((String)DDF_KEY, (String)field);
        if (StringUtils.isEmpty((String)value)) {
            field = tenant_Code.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
            value = SupDisUtil.getMap((String)DDF_KEY, (String)field);
        }
        return value;
    }

    private void savemenu(String tginfoCode, String proappCode, String tenantCode) {
        if (StringUtils.isBlank((String)proappCode) || StringUtils.isBlank((String)tginfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        String url = this.getUrl(tenantCode, Proapp_Menu, Proapp_Menu);
        boolean flag = false;
        if (StringUtils.isNotBlank((String)url)) {
            String[] split;
            for (String proappCpdeStr : split = url.split(",")) {
                if (!proappCpdeStr.equals(proappCode)) continue;
                flag = true;
            }
        }
        this.logger.error("cms.CmsTginfoServiceImplsavemenu.flag", (Object)("flag=" + flag + "tginfoCode=" + tginfoCode + "proappCode=" + proappCode));
        if (flag) {
            this.sendsavemenunew(tginfoCode, proappCode, tenantCode);
        } else {
            this.savemenuOld(tginfoCode, proappCode, tenantCode);
        }
    }

    private void sendsavemenunew(final String tginfoCode, final String proappCode, final String tenantCode) {
        if (null != pool && StringUtils.isNotBlank((String)tginfoCode) && StringUtils.isNotBlank((String)proappCode) && StringUtils.isNotBlank((String)tenantCode)) {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    CmsTginfoServiceImpl.this.savemenunew(tginfoCode, proappCode, tenantCode);
                }
            });
        }
    }

    private void savemenunew(String tginfoCode, String proappCode, String tenantCode) {
        this.logger.error("cms.CmsTginfoServiceImpl.savemenunew-->", (Object)(tenantCode + "-" + proappCode + "-" + tenantCode));
        if (StringUtils.isBlank((String)proappCode) || StringUtils.isBlank((String)tginfoCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("cms.CmsTginfoServiceImpl.initTginfoMenu", (Object)"tginfo is null");
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        param.put("tginfoCode", tginfoCode);
        QueryResult<CmsTginfoMenu> cmsTginfoMenuQueryResult = this.cmsTginfoMenuService.queryTginfoMenuPage(param);
        if (ListUtil.isNotEmpty((Collection)cmsTginfoMenuQueryResult.getList())) {
            this.logger.error("cms.CmsTginfoServiceImpl.initTginfoMenu", (Object)JsonUtil.buildNormalBinder().toJson(param));
            return;
        }
        param = new HashMap();
        param.put("tenantCode", tenant_Code);
        param.put("tginfoCode", proappCode);
        cmsTginfoMenuQueryResult = this.cmsTginfoMenuService.queryTginfoMenuPage(param);
        if (ListUtil.isEmpty((Collection)cmsTginfoMenuQueryResult.getList())) {
            this.logger.error("cms.CmsTginfoServiceImpl.initTginfoMenu1", (Object)JsonUtil.buildNormalBinder().toJson(param));
            return;
        }
        List cmsTginfoMenus = cmsTginfoMenuQueryResult.getList();
        List<CmsTginfoMenu> cmsTginfoMenus1 = null;
        HashMap<String, ArrayList<CmsTginfoMenu>> parentMenu = new HashMap<String, ArrayList<CmsTginfoMenu>>();
        for (CmsTginfoMenu cmsTginfoMenu : cmsTginfoMenus) {
            if (StringUtils.isNotBlank((String)cmsTginfoMenu.getTginfoMenuPcode()) && !"-1".equals(cmsTginfoMenu.getTginfoMenuPcode())) {
                cmsTginfoMenus1 = (List)parentMenu.get(cmsTginfoMenu.getTginfoMenuPcode());
                if (null != cmsTginfoMenus1) {
                    cmsTginfoMenus1.add(cmsTginfoMenu);
                    parentMenu.put(cmsTginfoMenu.getTginfoMenuPcode(), (ArrayList<CmsTginfoMenu>)cmsTginfoMenus1);
                    continue;
                }
                cmsTginfoMenus1 = new ArrayList();
                cmsTginfoMenus1.add(cmsTginfoMenu);
                parentMenu.put(cmsTginfoMenu.getTginfoMenuPcode(), (ArrayList<CmsTginfoMenu>)cmsTginfoMenus1);
                continue;
            }
            cmsTginfoMenus1 = (ArrayList<CmsTginfoMenu>)parentMenu.get("-1");
            if (null == cmsTginfoMenus1) {
                cmsTginfoMenus1 = new ArrayList<CmsTginfoMenu>();
                cmsTginfoMenus1.add(cmsTginfoMenu);
                parentMenu.put("-1", (ArrayList<CmsTginfoMenu>)cmsTginfoMenus1);
                continue;
            }
            cmsTginfoMenus1.add(cmsTginfoMenu);
            parentMenu.put("-1", (ArrayList<CmsTginfoMenu>)cmsTginfoMenus1);
        }
        if (MapUtil.isNotEmpty(parentMenu)) {
            List cmsTginfoMenus2 = (List)parentMenu.get("-1");
            for (CmsTginfoMenu cmsTginfoMenu : cmsTginfoMenus2) {
                List cmsTginfoMenus3;
                String parantCode = this.createUUIDString();
                String code = cmsTginfoMenu.getTginfoMenuCode();
                param = new HashMap();
                param.put("tenantCode", cmsTginfoMenu.getTenantCode());
                param.put("tginfoMenuCode", code);
                QueryResult<CmsConttitle> cmsConttitleQueryResult = this.cmsConttitleService.queryConttitlePage(param);
                List query = cmsConttitleQueryResult.getList();
                cmsTginfoMenu.setTginfoMenuId(null);
                cmsTginfoMenu.setTginfoMenuCode(parantCode);
                cmsTginfoMenu.setTenantCode(tenantCode);
                cmsTginfoMenu.setTginfoCode(tginfoCode);
                this.setTginfoMenuDefault(cmsTginfoMenu);
                this.saveTginfoMenuModel(this.makeCmsTginfoMenuDomain(cmsTginfoMenu, null));
                if (ListUtil.isNotEmpty((Collection)query)) {
                    for (CmsConttitle cmsConttitle : query) {
                        cmsConttitle.setConttitleId(null);
                        cmsConttitle.setConttitleCode(null);
                        cmsConttitle.setTenantCode(tenantCode);
                        cmsConttitle.setTginfoMenuCode(cmsTginfoMenu.getTginfoMenuCode());
                        this.setConttitleDefault(cmsConttitle);
                        this.saveConttitleModel(this.makeCmsConttitleDomain(cmsConttitle, null));
                    }
                }
                if (!ListUtil.isNotEmpty((Collection)(cmsTginfoMenus3 = (List)parentMenu.get(code)))) continue;
                for (CmsTginfoMenu tginfoMenu : cmsTginfoMenus3) {
                    String ziCode = this.createUUIDString();
                    param = new HashMap();
                    param.put("tenantCode", tginfoMenu.getTenantCode());
                    param.put("tginfoMenuCode", tginfoMenu.getTginfoMenuCode());
                    cmsConttitleQueryResult = this.cmsConttitleService.queryConttitlePage(param);
                    query = cmsConttitleQueryResult.getList();
                    tginfoMenu.setTginfoMenuId(null);
                    tginfoMenu.setTginfoMenuCode(ziCode);
                    tginfoMenu.setTginfoMenuPcode(parantCode);
                    tginfoMenu.setTenantCode(tenantCode);
                    tginfoMenu.setTginfoCode(tginfoCode);
                    this.setTginfoMenuDefault(tginfoMenu);
                    this.saveTginfoMenuModel(this.makeCmsTginfoMenuDomain(tginfoMenu, null));
                    if (!ListUtil.isNotEmpty((Collection)query)) continue;
                    for (CmsConttitle cmsConttitle : query) {
                        cmsConttitle.setConttitleId(null);
                        cmsConttitle.setConttitleCode(null);
                        cmsConttitle.setTenantCode(tenantCode);
                        cmsConttitle.setTginfoMenuCode(ziCode);
                        this.setConttitleDefault(cmsConttitle);
                        this.saveConttitleModel(this.makeCmsConttitleDomain(cmsConttitle, null));
                    }
                }
            }
        }
    }

    private void setConttitleDefault(CmsConttitle cmsConttitle) {
        if (null == cmsConttitle) {
            return;
        }
        if (null == cmsConttitle.getDataState()) {
            cmsConttitle.setDataState(0);
        }
        if (null == cmsConttitle.getGmtCreate()) {
            cmsConttitle.setGmtCreate(this.getSysDate());
        }
        cmsConttitle.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cmsConttitle.getConttitleCode())) {
            cmsConttitle.setConttitleCode(this.createUUIDString());
        }
    }

    private void setContlistDefault(CmsContlist cmsContlist) {
        if (null == cmsContlist) {
            return;
        }
        if (null == cmsContlist.getDataState()) {
            cmsContlist.setDataState(0);
        }
        if (null == cmsContlist.getGmtCreate()) {
            cmsContlist.setGmtCreate(this.getSysDate());
        }
        cmsContlist.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cmsContlist.getConttitleCode())) {
            cmsContlist.setConttitleCode(this.createUUIDString());
        }
    }

    private void setTginfoMenuDefault(CmsTginfoMenu cmsTginfoMenu) {
        if (null == cmsTginfoMenu) {
            return;
        }
        if (null == cmsTginfoMenu.getDataState()) {
            cmsTginfoMenu.setDataState(0);
        }
        if (null == cmsTginfoMenu.getGmtCreate()) {
            cmsTginfoMenu.setGmtCreate(this.getSysDate());
        }
        cmsTginfoMenu.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cmsTginfoMenu.getTginfoMenuCode())) {
            cmsTginfoMenu.setTginfoMenuCode(this.createUUIDString());
        }
    }

    private CmsConttitleDomain makeCmsConttitleDomain(CmsConttitle cmsConttitle, CmsConttitleDomain cmsConttitleDomain) {
        if (null == cmsConttitle) {
            return null;
        }
        if (null == cmsConttitleDomain) {
            cmsConttitleDomain = new CmsConttitleDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmsConttitleDomain, (Object)cmsConttitle);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cmsConttitleDomain;
    }

    private CmsContlistDomain makeCmsContlistDomain(CmsContlist cmsContlist, CmsContlistDomain cmsContlistDomain) {
        if (null == cmsContlist) {
            return null;
        }
        if (null == cmsContlistDomain) {
            cmsContlistDomain = new CmsContlistDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmsContlistDomain, (Object)cmsContlist);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cmsContlistDomain;
    }

    private CmsTginfoMenuDomain makeCmsTginfoMenuDomain(CmsTginfoMenu cmsTginfoMenu, CmsTginfoMenuDomain cmsTginfoMenuDomain) {
        if (null == cmsTginfoMenu) {
            return null;
        }
        if (null == cmsTginfoMenuDomain) {
            cmsTginfoMenuDomain = new CmsTginfoMenuDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmsTginfoMenuDomain, (Object)cmsTginfoMenu);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cmsTginfoMenuDomain;
    }

    private void saveTginfoMenuModel(CmsTginfoMenuDomain cmsTginfoMenuDomain) throws ApiException {
        if (null == cmsTginfoMenuDomain) {
            return;
        }
        try {
            this.cmsTginfoMenuService.saveTginfoMenu(cmsTginfoMenuDomain);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoServiceImpl.saveTginfoMenuModel.ex", (Throwable)e);
        }
    }

    private void saveTginfoMenuModel(CmsTginfoMenu cmsTginfoMenu) throws ApiException {
        if (null == cmsTginfoMenu) {
            return;
        }
        try {
            this.cmsTginfoMenuService.saveTginfoMenuMode(cmsTginfoMenu);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoServiceImpl.saveTginfoMenuModel.ex", (Throwable)e);
        }
    }

    private void saveConttitleModel(CmsConttitleDomain cmsConttitleDomain) throws ApiException {
        if (null == cmsConttitleDomain) {
            return;
        }
        try {
            this.cmsConttitleService.saveConttitle(cmsConttitleDomain);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoServiceImpl.saveConttitleModel.ex", (Throwable)e);
        }
    }

    private void saveConttitleModel(CmsConttitle cmsConttitle) throws ApiException {
        if (null == cmsConttitle) {
            return;
        }
        try {
            this.cmsConttitleService.saveConttitleMode(cmsConttitle);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsTginfoServiceImpl.saveConttitleModel.ex", (Throwable)e);
        }
    }

    private void savemenuOld(String tginfoCode, String proappCode, String tenantCode) {
        this.logger.error("cms.CmsTginfoServiceImpl.savemenuOld-->", (Object)(tenantCode + "-" + proappCode + "-" + tginfoCode));
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("proappCode", proappCode);
        param.put("tenantCode", tenantCode);
        String json = this.internalInvoke(this.apiCode, param);
        if (StringUtils.isBlank((String)json)) {
            this.logger.error("cms.CmsTginfoServiceImpl.savemenu.json", (Object)((Object)param).toString());
            return;
        }
        this.logger.error(SYS_CODE + this.apiCode, (Object)json);
        List tmProappMenuReDomainList = JsonUtil.buildNormalBinder().getJsonToList(json, TmProappMenuReDomain.class);
        if (ListUtil.isEmpty((Collection)tmProappMenuReDomainList)) {
            this.logger.error("cms.CmsTginfoServiceImpl.savemenu.tmProappMenuReDomainList", (Object)((Object)param).toString());
            return;
        }
        this.makeMenuList(tginfoCode, tmProappMenuReDomainList, "-1");
    }

    private void makeMenuList(String tginfoCode, List<TmProappMenuReDomain> tmProappMenuReDomainList, String proappMenuPcode) {
        if (ListUtil.isEmpty(tmProappMenuReDomainList)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (TmProappMenuReDomain tmProappMenuReDomain : tmProappMenuReDomainList) {
            map.put("tenantCode", tmProappMenuReDomain.getTenantCode());
            map.put("tginfoCode", tginfoCode);
            map.put("tginfoMenuCode", tmProappMenuReDomain.getProappMenuCode());
            this.logger.error("cms.CmsTginfoServiceImpl.queryTginfoMenuPage", (Object)("map=" + map + "tmProappMenuReDomain=" + JsonUtil.buildNonNullBinder().toJson((Object)tmProappMenuReDomain)));
            QueryResult<CmsTginfoMenu> qlist = this.cmsTginfoMenuService.queryTginfoMenuPage(map);
            this.logger.error("cms.CmsTginfoServiceImpl.queryTginfoMenuPage", (Object)("result:" + JsonUtil.buildNonNullBinder().toJson(qlist)));
            if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) continue;
            CmsTginfoMenuDomain cmsTginfoMenuDomain = this.makeMenu(tginfoCode, tmProappMenuReDomain);
            String tginfoMenuCode = this.cmsTginfoMenuService.saveTginfoMenu(cmsTginfoMenuDomain);
            this.cmsTginfoMenuService.updateTginfoMenuStateByCode(tmProappMenuReDomain.getTenantCode(), tginfoMenuCode, 2, null);
            this.makeMenuList(tginfoCode, tmProappMenuReDomain.getChildren(), tginfoMenuCode);
        }
    }

    private CmsTginfoMenuDomain makeMenu(String tginfoCode, TmProappMenuReDomain tmProappMenuReDomain) {
        if (null == tmProappMenuReDomain) {
            return null;
        }
        CmsTginfoMenuDomain cmsTginfoMenuDomain = new CmsTginfoMenuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cmsTginfoMenuDomain, (Object)tmProappMenuReDomain);
            cmsTginfoMenuDomain.setTginfoCode(tginfoCode);
            cmsTginfoMenuDomain.setTginfoMenuCode(tmProappMenuReDomain.getProappMenuCode());
            cmsTginfoMenuDomain.setTginfoMenuPcode(tmProappMenuReDomain.getProappMenuPcode());
            cmsTginfoMenuDomain.setTginfoMenuName(tmProappMenuReDomain.getProappMenuName());
            cmsTginfoMenuDomain.setDataState(2);
            if (StringUtils.isBlank((String)cmsTginfoMenuDomain.getTginfoMenuName())) {
                cmsTginfoMenuDomain.setTginfoMenuName(tmProappMenuReDomain.getProappCode());
            }
            cmsTginfoMenuDomain.setTginfoMenuOrder(tmProappMenuReDomain.getProappMenuOrder());
            cmsTginfoMenuDomain.setTginfoMenuRemark(tmProappMenuReDomain.getProappMenuRemark());
            return cmsTginfoMenuDomain;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String saveTginfoBatch(List<CmsTginfoDomain> cmsTginfoDomainList) {
        if (null == cmsTginfoDomainList || cmsTginfoDomainList.isEmpty()) {
            return null;
        }
        String code = "";
        for (CmsTginfoDomain cmsTginfoDomain : cmsTginfoDomainList) {
            code = this.saveTginfo(cmsTginfoDomain);
        }
        return code;
    }

    @Override
    public List<String> queryProappCode(Map<String, Object> map) {
        if (StringUtils.isBlank((String)((String)map.get("tenantCode")))) {
            throw new ApiException("cms.CmsTginfoServiceImpl.queryProappCode", "tenantCode is null ");
        }
        if (StringUtils.isBlank((String)((String)map.get("channelCode")))) {
            throw new ApiException("cms.CmsTginfoServiceImpl.queryProappCode", "channelCode is null ");
        }
        return this.queryProappCodeModel(map);
    }

    private List<String> queryProappCodeModel(Map<String, Object> map) {
        try {
            return this.cmsTginfoMapper.queryProappCode(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsTginfoServiceImpl.queryProappCodeModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public void updateTginfoState(Integer tginfoId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateTginfoModel(tginfoId, dataState, oldDataState);
        CmsTginfo cmsTginfo = this.getTginfo(tginfoId);
        if (-1 == dataState) {
            this.delCache(cmsTginfo);
        } else {
            this.updateCache(cmsTginfo);
        }
    }

    @Override
    public void updateTginfo(CmsTginfoDomain cmsTginfoDomain) throws ApiException {
        String msg = this.checkTginfo(cmsTginfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsTginfoServiceImpl.updateTginfo.checkTginfo", msg);
        }
        CmsTginfo oldCmsTginfo = this.getTginfoModelById(cmsTginfoDomain.getTginfoId());
        if (null == oldCmsTginfo) {
            throw new ApiException("cms.CmsTginfoServiceImpl.updateTginfo.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        String tginfoCode = oldCmsTginfo.getTginfoCode();
        String proappCode = cmsTginfoDomain.getProappCode();
        if (StringUtils.isBlank((String)proappCode)) {
            proappCode = oldCmsTginfo.getProappCode();
        }
        CmsTginfo cmsTginfo = this.makeTginfo(cmsTginfoDomain, oldCmsTginfo);
        this.setTginfoUpdataDefault(cmsTginfo);
        this.updateTginfoModel(cmsTginfo);
        oldCmsTginfo = this.getTginfoModelById(cmsTginfoDomain.getTginfoId());
        this.savemenu(tginfoCode, proappCode, oldCmsTginfo.getTenantCode());
        this.updateCache(oldCmsTginfo);
    }

    @Override
    public CmsTginfo getTginfo(Integer tginfoId) {
        return this.getTginfoModelById(tginfoId);
    }

    @Override
    public void deleteTginfo(Integer tginfoId) throws ApiException {
        this.deleteTginfoModel(tginfoId);
        CmsTginfo tginfo = this.getTginfoModelById(tginfoId);
        this.delCache(tginfo);
    }

    @Override
    public QueryResult<CmsTginfo> queryTginfoPage(Map<String, Object> map) {
        List<CmsTginfo> cmsTginfoList = this.queryTginfoModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTginfo(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmsTginfoList);
        return queryResult;
    }

    @Override
    public CmsTginfo getTginfoByCode(Map<String, Object> map) {
        return this.getTginfoModelByCode(map);
    }

    @Override
    public void delTginfoByCode(Map<String, Object> map) throws ApiException {
        this.delTginfoModelByCode(map);
        CmsTginfo tginfo = this.getTginfoModelByCode(map);
        this.delCache(tginfo);
    }

    private void delCache(CmsTginfo tginfo) {
        if (null == tginfo) {
            return;
        }
        DisUtil.delMap((String)"cms_tginfo_cache", (String[])new String[]{tginfo.getTginfoCode() + "-" + tginfo.getTenantCode()});
        DisUtil.delMap((String)"cms_tginfo_cache_all", (String[])new String[]{tginfo.getProappCode() + "-" + tginfo.getMemberCode() + "-" + tginfo.getTenantCode()});
        if (StringUtils.isNotBlank((String)tginfo.getTginfoCompanyurl())) {
            DisUtil.delMap((String)"CmsTginfo-domain", (String[])new String[]{tginfo.getTginfoCompanyurl() + "-*-" + tginfo.getOauthEnvCode()});
        }
        if (StringUtils.isNotBlank((String)tginfo.getTginfoExchangeurl())) {
            DisUtil.delMap((String)"CmsTginfo-domain", (String[])new String[]{tginfo.getTginfoExchangeurl() + "-*-" + tginfo.getOauthEnvCode()});
        }
        DisUtil.delMap((String)"CmsTginfo-mem", (String[])new String[]{tginfo.getTginfoCode() + "-" + tginfo.getTenantCode()});
    }

    private void updateCache(CmsTginfo tginfo) {
        String domain;
        this.logger.error("cms.CmsTginfoServiceImplupdateCache", (Object)JsonUtil.buildNonNullBinder().toJson((Object)tginfo));
        if (null == tginfo) {
            return;
        }
        if (StringUtils.isNotBlank((String)tginfo.getTginfoCompanyurl())) {
            if (StringUtils.isNotBlank((String)tginfo.getTginfoCompanyurl()) && tginfo.getTginfoCompanyurl().indexOf("{domain}") >= 0) {
                domain = DisUtil.getRemotMap((String)"tmtenant-code_dmain", (String)(tginfo.getTenantCode() + "-domain"));
                if (null == domain) {
                    domain = "";
                }
                tginfo.setTginfoCompanyurl(tginfo.getTginfoCompanyurl().replace("{domain}", domain));
            }
            if (StringUtils.isNotBlank((String)tginfo.getTginfoCompanyurl()) && tginfo.getTginfoCompanyurl().indexOf("{domain0}") >= 0) {
                domain = DisUtil.getRemotMap((String)"tmtenant-code_dmain", (String)(tginfo.getTenantCode() + "-domain0"));
                if (null == domain) {
                    domain = "";
                }
                tginfo.setTginfoCompanyurl(tginfo.getTginfoCompanyurl().replace("{domain0}", domain));
            }
            if (StringUtils.isNotBlank((String)tginfo.getTginfoCompanyurl()) && tginfo.getTginfoCompanyurl().indexOf("{domain1}") >= 0) {
                domain = DisUtil.getRemotMap((String)"tmtenant-code_dmain", (String)(tginfo.getTenantCode() + "-domain1"));
                if (null == domain) {
                    domain = "";
                }
                tginfo.setTginfoCompanyurl(tginfo.getTginfoCompanyurl().replace("{domain1}", domain));
            }
            DisUtil.setMap((String)"CmsTginfo-domain", (String)(tginfo.getTginfoCompanyurl() + "-*-" + tginfo.getOauthEnvCode()), (String)(tginfo.getProappCode() + "," + tginfo.getTenantCode() + "," + tginfo.getTginfoCode()));
            this.updateDomainCache(tginfo.getTginfoCompanyurl());
            this.updateDomainCache1(tginfo.getTginfoCompanyurl());
        }
        if (StringUtils.isNotBlank((String)tginfo.getTginfoExchangeurl())) {
            if (StringUtils.isNotBlank((String)tginfo.getTginfoExchangeurl()) && tginfo.getTginfoExchangeurl().indexOf("{domain}") >= 0) {
                domain = DisUtil.getRemotMap((String)"tmtenant-code_dmain", (String)(tginfo.getTenantCode() + "-domain"));
                if (null == domain) {
                    domain = "";
                }
                tginfo.setTginfoExchangeurl(tginfo.getTginfoExchangeurl().replace("{domain}", domain));
            }
            if (StringUtils.isNotBlank((String)tginfo.getTginfoExchangeurl()) && tginfo.getTginfoExchangeurl().indexOf("{domain0}") >= 0) {
                domain = DisUtil.getRemotMap((String)"tmtenant-code_dmain", (String)(tginfo.getTenantCode() + "-domain0"));
                if (null == domain) {
                    domain = "";
                }
                tginfo.setTginfoExchangeurl(tginfo.getTginfoExchangeurl().replace("{domain0}", domain));
            }
            if (StringUtils.isNotBlank((String)tginfo.getTginfoExchangeurl()) && tginfo.getTginfoExchangeurl().indexOf("{domain1}") >= 0) {
                domain = DisUtil.getRemotMap((String)"tmtenant-code_dmain", (String)(tginfo.getTenantCode() + "-domain1"));
                if (null == domain) {
                    domain = "";
                }
                tginfo.setTginfoExchangeurl(tginfo.getTginfoExchangeurl().replace("{domain1}", domain));
            }
            DisUtil.setMap((String)"CmsTginfo-domain", (String)(tginfo.getTginfoExchangeurl() + "-*-" + tginfo.getOauthEnvCode()), (String)(tginfo.getProappCode() + "," + tginfo.getTenantCode() + "," + tginfo.getTginfoCode()));
            this.updateDomainCache(tginfo.getTginfoExchangeurl());
            this.updateDomainCache1(tginfo.getTginfoExchangeurl());
        }
        DisUtil.setMap((String)"cms_tginfo_cache", (String)(tginfo.getTginfoCode() + "-" + tginfo.getTenantCode()), (String)JsonUtil.buildNonNullBinder().toJson((Object)tginfo));
        if (StringUtils.isNotBlank((String)tginfo.getMemberCode())) {
            DisUtil.setMap((String)"cms_tginfo_cache_all", (String)(tginfo.getProappCode() + "-" + tginfo.getMemberCode() + "-" + tginfo.getTenantCode()), (String)JsonUtil.buildNonNullBinder().toJson((Object)tginfo));
            DisUtil.setMap((String)"CmsTginfo-mem", (String)(tginfo.getTginfoCode() + "-" + tginfo.getTenantCode()), (String)tginfo.getMemberCode());
        }
    }

    private void updateDomainCache1(String domain) {
        if (StringUtils.isBlank((String)domain)) {
            return;
        }
        if (domain.indexOf("-") <= 0) {
            return;
        }
        String domainKey = domain.substring(domain.indexOf("-") + 1);
        CmsTginfoServiceImpl.updateDomainCacheNext1(domainKey, domain);
    }

    private void updateDomainCache(String domain) {
        if (StringUtils.isBlank((String)domain)) {
            return;
        }
        if (domain.indexOf(".") <= 0) {
            return;
        }
        String domainKey = domain.substring(domain.indexOf(".") + 1);
        CmsTginfoServiceImpl.updateDomainCacheNext(domainKey, domain);
    }

    private static void updateDomainCacheNext1(String domainKey, String domain) {
        if (StringUtils.isBlank((String)domainKey)) {
            return;
        }
        String cache = DisUtil.getRemot((String)("-" + domainKey));
        if (StringUtils.isNotBlank((String)cache)) {
            DisUtil.set((String)domain, (String)cache);
            return;
        }
        if (domainKey.indexOf("-") <= 0) {
            return;
        }
        domainKey = domainKey.substring(domainKey.indexOf("-") + 1);
        CmsTginfoServiceImpl.updateDomainCacheNext1(domainKey, domain);
    }

    private static void updateDomainCacheNext(String domainKey, String domain) {
        if (StringUtils.isBlank((String)domainKey)) {
            return;
        }
        String cache = DisUtil.getRemot((String)domainKey);
        if (StringUtils.isNotBlank((String)cache)) {
            DisUtil.set((String)domain, (String)cache);
            return;
        }
        if (domainKey.indexOf(".") <= 0) {
            return;
        }
        domainKey = domainKey.substring(domainKey.indexOf(".") + 1);
        CmsTginfoServiceImpl.updateDomainCacheNext(domainKey, domain);
    }

    public static void main(String[] args) {
        String domain = "test-bmall.cailt.com";
        String domainKey = domain.substring(domain.indexOf("-"));
        System.out.println(domainKey);
    }

    @Override
    public void loadcache() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<CmsTginfo> cmsTginfoList = this.queryTginfoModelPage(map);
        if (cmsTginfoList == null || cmsTginfoList.isEmpty()) {
            DisUtil.delVer((String)"cms_tginfo_cache");
            DisUtil.delVer((String)"cms_tginfo_cache_all");
            DisUtil.delVer((String)"CmsTginfo-domain");
            DisUtil.delVer((String)"CmsTginfo-mem");
            return;
        }
        HashMap<String, String> mmap = new HashMap<String, String>();
        HashMap<String, String> mmap2 = new HashMap<String, String>();
        HashMap<String, String> mmap3 = new HashMap<String, String>();
        HashMap<String, String> mmap4 = new HashMap<String, String>();
        HashMap<String, String> mmap5 = new HashMap<String, String>();
        for (CmsTginfo tginfo : cmsTginfoList) {
            String domain;
            if (null == tginfo.getDataState()) {
                tginfo.setDataState(0);
            }
            if (tginfo.getDataState() == -1) continue;
            mmap.put(tginfo.getTginfoCode() + "-" + tginfo.getTenantCode(), JsonUtil.buildNonNullBinder().toJson((Object)tginfo));
            mmap2.put(tginfo.getProappCode() + "-" + tginfo.getMemberCode() + "-" + tginfo.getTenantCode(), JsonUtil.buildNonNullBinder().toJson((Object)tginfo));
            mmap5.put(StringUtils.isBlank((String)tginfo.getMemberMcode()) ? tginfo.getMemberCode() : tginfo.getMemberMcode() + "-" + tginfo.getTenantCode() + "-" + tginfo.getTenantCode(), JsonUtil.buildNonNullBinder().toJson((Object)tginfo));
            if (StringUtils.isNotBlank((String)tginfo.getTginfoCompanyurl())) {
                if (StringUtils.isNotBlank((String)tginfo.getTginfoCompanyurl()) && tginfo.getTginfoCompanyurl().indexOf("{domain}") >= 0) {
                    domain = DisUtil.getRemotMap((String)"tmtenant-code_dmain", (String)(tginfo.getTenantCode() + "-domain"));
                    if (null == domain) {
                        domain = "";
                    }
                    tginfo.setTginfoCompanyurl(tginfo.getTginfoCompanyurl().replace("{domain}", domain));
                }
                if (StringUtils.isNotBlank((String)tginfo.getTginfoCompanyurl()) && tginfo.getTginfoCompanyurl().indexOf("{domain0}") >= 0) {
                    domain = DisUtil.getRemotMap((String)"tmtenant-code_dmain", (String)(tginfo.getTenantCode() + "-domain0"));
                    if (null == domain) {
                        domain = "";
                    }
                    tginfo.setTginfoCompanyurl(tginfo.getTginfoCompanyurl().replace("{domain0}", domain));
                }
                if (StringUtils.isNotBlank((String)tginfo.getTginfoCompanyurl()) && tginfo.getTginfoCompanyurl().indexOf("{domain1}") >= 0) {
                    domain = DisUtil.getRemotMap((String)"tmtenant-code_dmain", (String)(tginfo.getTenantCode() + "-domain1"));
                    if (null == domain) {
                        domain = "";
                    }
                    tginfo.setTginfoCompanyurl(tginfo.getTginfoCompanyurl().replace("{domain1}", domain));
                }
                this.updateDomainCache(tginfo.getTginfoCompanyurl());
                this.updateDomainCache1(tginfo.getTginfoCompanyurl());
                mmap3.put(tginfo.getTginfoCompanyurl() + "-*-" + tginfo.getOauthEnvCode(), tginfo.getProappCode() + "," + tginfo.getTenantCode() + "," + tginfo.getTginfoCode() + "," + tginfo.getMemberCode());
            }
            if (StringUtils.isNotBlank((String)tginfo.getTginfoExchangeurl())) {
                if (StringUtils.isNotBlank((String)tginfo.getTginfoExchangeurl()) && tginfo.getTginfoExchangeurl().indexOf("{domain}") >= 0) {
                    domain = DisUtil.getRemotMap((String)"tmtenant-code_dmain", (String)(tginfo.getTenantCode() + "-domain"));
                    if (null == domain) {
                        domain = "";
                    }
                    tginfo.setTginfoExchangeurl(tginfo.getTginfoExchangeurl().replace("{domain}", domain));
                }
                if (StringUtils.isNotBlank((String)tginfo.getTginfoExchangeurl()) && tginfo.getTginfoExchangeurl().indexOf("{domain0}") >= 0) {
                    domain = DisUtil.getRemotMap((String)"tmtenant-code_dmain", (String)(tginfo.getTenantCode() + "-domain0"));
                    if (null == domain) {
                        domain = "";
                    }
                    tginfo.setTginfoExchangeurl(tginfo.getTginfoExchangeurl().replace("{domain0}", domain));
                }
                if (StringUtils.isNotBlank((String)tginfo.getTginfoExchangeurl()) && tginfo.getTginfoExchangeurl().indexOf("{domain1}") >= 0) {
                    domain = DisUtil.getRemotMap((String)"tmtenant-code_dmain", (String)(tginfo.getTenantCode() + "-domain1"));
                    if (null == domain) {
                        domain = "";
                    }
                    tginfo.setTginfoExchangeurl(tginfo.getTginfoExchangeurl().replace("{domain1}", domain));
                }
                this.updateDomainCache(tginfo.getTginfoExchangeurl());
                this.updateDomainCache1(tginfo.getTginfoExchangeurl());
                mmap3.put(tginfo.getTginfoExchangeurl() + "-*-" + tginfo.getOauthEnvCode(), tginfo.getProappCode() + "," + tginfo.getTenantCode() + "," + tginfo.getTginfoCode() + "," + tginfo.getMemberCode());
            }
            if (!StringUtils.isNotBlank((String)tginfo.getMemberCode())) continue;
            mmap4.put(tginfo.getTginfoCode() + "-" + tginfo.getTenantCode(), tginfo.getMemberCode());
        }
        DisUtil.setMap((String)"cms_tginfo_cache", mmap);
        DisUtil.setMap((String)"cms_tginfo_cache_all", mmap2);
        DisUtil.setMap((String)"CmsTginfo-domain", mmap3);
        DisUtil.setMap((String)"CmsTginfo-mem", mmap4);
    }

    @Override
    public String saveTginfoChannel(DisChannelDomain disChannel) {
        if (null == disChannel) {
            return "";
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", disChannel.getTenantCode());
        paramMap.put("proappSort", "2");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult qtp = this.sendReSupObject(this.envapiCode, map, TmProappEnvDomain.class);
        if (null == qtp || ListUtil.isEmpty((Collection)qtp.getList())) {
            return "\u4ea7\u54c1\u672a\u8bbe\u7f6e";
        }
        ArrayList<CmsTginfoDomain> cmsTginfoDomainList = new ArrayList<CmsTginfoDomain>();
        for (TmProappEnvDomain tmProappEnvDomain : qtp.getList()) {
            CmsTginfoDomain cmsTginfoDomain = new CmsTginfoDomain();
            cmsTginfoDomain.setChannelCode(disChannel.getChannelCode());
            cmsTginfoDomain.setMemberCode(disChannel.getMemberCode());
            cmsTginfoDomain.setMemberName(disChannel.getMemberName());
            cmsTginfoDomain.setGoodsClass(disChannel.getGoodsClass());
            cmsTginfoDomain.setOauthEnvCode(DisUtil.getMap((String)"TmProapp-ProappCode", (String)(tmProappEnvDomain.getProappCode() + "-" + "00000000")));
            cmsTginfoDomain.setProappCode(tmProappEnvDomain.getProappCode());
            cmsTginfoDomain.setTenantCode(disChannel.getTenantCode());
            if (StringUtils.isBlank((String)disChannel.getTginfoCode())) {
                disChannel.setTginfoCode(StringUtils.isBlank((String)disChannel.getMemberCcode()) ? disChannel.getMemberCode() : disChannel.getMemberCcode());
            }
            cmsTginfoDomain.setTginfoCompanyurl(StringUtils.isBlank((String)disChannel.getTginfoCode()) ? disChannel.getChannelCode() : disChannel.getTginfoCode() + "." + tmProappEnvDomain.getProappEnvDomain());
            cmsTginfoDomain.setTginfoExchangeurl(cmsTginfoDomain.getTginfoCompanyurl());
            cmsTginfoDomain.setTginfoName(disChannel.getChannelName());
            cmsTginfoDomain.setTginfoType(2);
            cmsTginfoDomainList.add(cmsTginfoDomain);
        }
        this.saveTginfoBatch(cmsTginfoDomainList);
        return "success";
    }

    @Override
    public String saveTginfoChannelPlus(DisChannelDomain disChannel) {
        this.logger.info("=========================**======================");
        if (null == disChannel) {
            return "";
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", disChannel.getTenantCode());
        paramMap.put("proappSort", "2");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult qtp = this.sendReSupObject(this.envapiCode, map, TmProappEnvDomain.class);
        if (null == qtp || ListUtil.isEmpty((Collection)qtp.getList())) {
            return "\u4ea7\u54c1\u672a\u8bbe\u7f6e";
        }
        ArrayList<CmsTginfoDomain> cmsTginfoDomainList = new ArrayList<CmsTginfoDomain>();
        if (StringUtils.isBlank((String)disChannel.getTginfoCode())) {
            String result = this.internalInvoke("um.user.getUserinfoByCode", this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{disChannel.getMemberCode(), disChannel.getTenantCode()}));
            UmUserinfo umUserinfo = (UmUserinfo)JsonUtil.buildNormalBinder().getJsonToObject(result, UmUserinfo.class);
            if (null != umUserinfo) {
                disChannel.setTginfoCode(umUserinfo.getWebSiteUrl());
            }
        }
        for (TmProappEnvDomain tmProappEnvDomain : qtp.getList()) {
            CmsTginfoDomain cmsTginfoDomain = new CmsTginfoDomain();
            cmsTginfoDomain.setChannelCode(disChannel.getChannelCode());
            cmsTginfoDomain.setMemberCode(disChannel.getMemberCode());
            cmsTginfoDomain.setMemberName(disChannel.getMemberName());
            cmsTginfoDomain.setGoodsClass(disChannel.getGoodsClass());
            cmsTginfoDomain.setOauthEnvCode(DisUtil.getMap((String)"TmProapp-ProappCode", (String)(tmProappEnvDomain.getProappCode() + "-" + "00000000")));
            cmsTginfoDomain.setProappCode(tmProappEnvDomain.getProappCode());
            cmsTginfoDomain.setTenantCode(disChannel.getTenantCode());
            cmsTginfoDomain.setTginfoCompanyurl(StringUtils.isBlank((String)disChannel.getTginfoCode()) ? disChannel.getChannelCode() : disChannel.getTginfoCode() + tmProappEnvDomain.getProappEnvDomain());
            cmsTginfoDomain.setTginfoExchangeurl(cmsTginfoDomain.getTginfoCompanyurl());
            cmsTginfoDomain.setTginfoName(disChannel.getChannelName());
            cmsTginfoDomain.setTginfoType(2);
            cmsTginfoDomainList.add(cmsTginfoDomain);
        }
        this.saveTginfoBatch(cmsTginfoDomainList);
        return "success";
    }

    @Override
    public String saveTginfoUserinfo(UmUserinfo umUserinfo, UmUser umUser, String optype) throws ApiException {
        if (null == umUserinfo || StringUtils.isBlank((String)umUserinfo.getWebSiteUrl())) {
            return "error";
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", umUserinfo.getTenantCode());
        paramMap.put("proappSort", "2");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult qtp = this.sendReSupObject(this.envapiCode, map, TmProappEnvDomain.class);
        if (null == qtp || ListUtil.isEmpty((Collection)qtp.getList())) {
            return "\u4ea7\u54c1\u672a\u8bbe\u7f6e";
        }
        ArrayList<CmsTginfoDomain> cmsTginfoDomainList = new ArrayList<CmsTginfoDomain>();
        for (TmProappEnvDomain tmProappEnvDomain : qtp.getList()) {
            CmsTginfoDomain cmsTginfoDomain = new CmsTginfoDomain();
            cmsTginfoDomain.setMemberCode(umUserinfo.getUserinfoCode());
            cmsTginfoDomain.setMemberName(umUserinfo.getUserinfoCompname());
            cmsTginfoDomain.setOauthEnvCode(DisUtil.getMap((String)"TmProapp-ProappCode", (String)(tmProappEnvDomain.getProappCode() + "-" + "00000000")));
            cmsTginfoDomain.setProappCode(tmProappEnvDomain.getProappCode());
            cmsTginfoDomain.setTenantCode(umUserinfo.getTenantCode());
            cmsTginfoDomain.setTginfoCompanyurl(umUserinfo.getWebSiteUrl() + "." + tmProappEnvDomain.getProappEnvDomain());
            cmsTginfoDomain.setTginfoExchangeurl(cmsTginfoDomain.getTginfoCompanyurl());
            cmsTginfoDomain.setTginfoName(umUserinfo.getUserinfoCompname());
            cmsTginfoDomain.setTginfoType(2);
            cmsTginfoDomainList.add(cmsTginfoDomain);
        }
        this.saveTginfoBatch(cmsTginfoDomainList);
        return "success";
    }

    @Override
    public String saveTginfoUserinfoPlus(UmUserinfo umUserinfo, UmUser umUser, String optype) throws ApiException {
        if (null == umUserinfo || StringUtils.isBlank((String)umUserinfo.getWebSiteUrl())) {
            return "error";
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", umUserinfo.getTenantCode());
        paramMap.put("proappSort", "2");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult qtp = this.sendReSupObject(this.envapiCode, map, TmProappEnvDomain.class);
        if (null == qtp || ListUtil.isEmpty((Collection)qtp.getList())) {
            return "\u4ea7\u54c1\u672a\u8bbe\u7f6e";
        }
        ArrayList<CmsTginfoDomain> cmsTginfoDomainList = new ArrayList<CmsTginfoDomain>();
        for (TmProappEnvDomain tmProappEnvDomain : qtp.getList()) {
            CmsTginfoDomain cmsTginfoDomain = new CmsTginfoDomain();
            cmsTginfoDomain.setMemberCode(umUserinfo.getUserinfoCode());
            cmsTginfoDomain.setMemberName(umUserinfo.getUserinfoCompname());
            cmsTginfoDomain.setOauthEnvCode(DisUtil.getMap((String)"TmProapp-ProappCode", (String)(tmProappEnvDomain.getProappCode() + "-" + "00000000")));
            cmsTginfoDomain.setProappCode(tmProappEnvDomain.getProappCode());
            cmsTginfoDomain.setTenantCode(umUserinfo.getTenantCode());
            cmsTginfoDomain.setTginfoCompanyurl(umUserinfo.getWebSiteUrl() + tmProappEnvDomain.getProappEnvDomain());
            cmsTginfoDomain.setTginfoExchangeurl(cmsTginfoDomain.getTginfoCompanyurl());
            cmsTginfoDomain.setTginfoName(umUserinfo.getUserinfoCompname());
            cmsTginfoDomain.setTginfoType(2);
            cmsTginfoDomainList.add(cmsTginfoDomain);
        }
        this.saveTginfoBatch(cmsTginfoDomainList);
        return "success";
    }

    @Override
    public String saveTginfoMenu(UmUserinfo umUserinfo, UmUser umUser, String optype) throws ApiException {
        if (null == umUserinfo) {
            this.logger.error("cms.CmsTginfoServiceImpl.saveTginfoMenu is null");
            return "error";
        }
        String tenantCode = umUserinfo.getTenantCode();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        param.put("memo", "plat");
        QueryResult<CmsTginfoMenu> cmsTginfoMenuQueryResult = this.cmsTginfoMenuService.queryTginfoMenuPage(param);
        if (ListUtil.isEmpty((Collection)cmsTginfoMenuQueryResult.getList())) {
            this.logger.error("cms.CmsTginfoServiceImpl.saveTginfoMenu", (Object)JsonUtil.buildNormalBinder().toJson(param));
            return "error";
        }
        ConcurrentHashMap map = new ConcurrentHashMap();
        List cmsTginfoMenus = cmsTginfoMenuQueryResult.getList();
        for (CmsTginfoMenu cmsTginfoMenu : cmsTginfoMenus) {
            List<CmsTginfoMenu> cmsTginfoMenus1;
            if (null == map.get(cmsTginfoMenu.getTginfoCode())) {
                cmsTginfoMenus1 = new ArrayList<CmsTginfoMenu>();
                cmsTginfoMenus1.add(cmsTginfoMenu);
                map.put(cmsTginfoMenu.getTginfoCode(), cmsTginfoMenus1);
                continue;
            }
            cmsTginfoMenus1 = (List)map.get(cmsTginfoMenu.getTginfoCode());
            cmsTginfoMenus1.add(cmsTginfoMenu);
        }
        if (MapUtil.isEmpty(map)) {
            this.logger.error("cms.CmsTginfoServiceImpl.saveTginfoMenu map is null");
            return "success";
        }
        Set keys = map.keySet();
        if (ListUtil.isEmpty((Collection)keys)) {
            this.logger.error("cms.CmsTginfoServiceImpl.saveTginfoMenu map set is null");
            return "success";
        }
        for (String key : keys) {
            StringBuilder tginfoCodeStr = new StringBuilder();
            String[] strs = key.split("-");
            if (2 != strs.length) continue;
            tginfoCodeStr.append(strs[0]).append("-").append(umUserinfo.getUserinfoCode());
            this.saveNewTginfoMenu(tenantCode, tginfoCodeStr.toString(), (List)map.get(key), "0");
        }
        return "success";
    }

    private void saveNewTginfoMenu(String tenantCode, String tginfoCode, List<CmsTginfoMenu> cmsTginfoMenus, String type) {
        List<CmsTginfoMenu> cmsTginfoMenus1 = null;
        ConcurrentHashMap<String, List<CmsTginfoMenu>> parentMenu = new ConcurrentHashMap<String, List<CmsTginfoMenu>>();
        for (CmsTginfoMenu cmsTginfoMenu : cmsTginfoMenus) {
            if (StringUtils.isNotBlank((String)cmsTginfoMenu.getTginfoMenuPcode()) && !"-1".equals(cmsTginfoMenu.getTginfoMenuPcode())) {
                cmsTginfoMenus1 = (List)parentMenu.get(cmsTginfoMenu.getTginfoMenuPcode());
                if (null != cmsTginfoMenus1) {
                    cmsTginfoMenus1.add(cmsTginfoMenu);
                    parentMenu.put(cmsTginfoMenu.getTginfoMenuPcode(), cmsTginfoMenus1);
                    continue;
                }
                cmsTginfoMenus1 = new ArrayList();
                cmsTginfoMenus1.add(cmsTginfoMenu);
                parentMenu.put(cmsTginfoMenu.getTginfoMenuPcode(), cmsTginfoMenus1);
                continue;
            }
            cmsTginfoMenus1 = (ArrayList<CmsTginfoMenu>)parentMenu.get("-1");
            if (null == cmsTginfoMenus1) {
                cmsTginfoMenus1 = new ArrayList<CmsTginfoMenu>();
                cmsTginfoMenus1.add(cmsTginfoMenu);
                parentMenu.put("-1", cmsTginfoMenus1);
                continue;
            }
            cmsTginfoMenus1.add(cmsTginfoMenu);
            parentMenu.put("-1", cmsTginfoMenus1);
        }
        this.logger.error("cms.CmsTginfoServiceImpl=====>parentMenu", (Object)JsonUtil.buildNormalBinder().toJson(parentMenu));
        if (MapUtil.isNotEmpty(parentMenu)) {
            List cmsTginfoMenus2 = (List)parentMenu.get("-1");
            for (CmsTginfoMenu cmsTginfoMenu : cmsTginfoMenus2) {
                String parantCode = this.createUUIDString();
                String code = cmsTginfoMenu.getTginfoMenuCode();
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("tenantCode", cmsTginfoMenu.getTenantCode());
                param.put("tginfoMenuCode", code);
                QueryResult<CmsConttitle> cmsConttitleQueryResult = this.cmsConttitleService.queryConttitlePage(param);
                List query = cmsConttitleQueryResult.getList();
                cmsTginfoMenu.setTginfoMenuId(null);
                cmsTginfoMenu.setTginfoMenuCode(parantCode);
                cmsTginfoMenu.setTenantCode(tenantCode);
                cmsTginfoMenu.setTginfoCode(tginfoCode);
                this.setTginfoMenuDefault(cmsTginfoMenu);
                this.saveTginfoMenuModel(cmsTginfoMenu);
                if (ListUtil.isNotEmpty((Collection)query)) {
                    for (CmsConttitle cmsConttitle : query) {
                        String conpranetCode = cmsConttitle.getConttitleCode();
                        cmsConttitle.setConttitleId(null);
                        cmsConttitle.setConttitleCode(null);
                        cmsConttitle.setTenantCode(tenantCode);
                        cmsConttitle.setTginfoMenuCode(cmsTginfoMenu.getTginfoMenuCode());
                        this.setConttitleDefault(cmsConttitle);
                        this.saveConttitleModel(cmsConttitle);
                        if (StringUtils.isBlank((String)type)) {
                            type = "0";
                        }
                        if (!"1".equals(type)) continue;
                        param = new HashMap();
                        param.put("tenantCode", tenantCode);
                        param.put("conttitleCode", conpranetCode);
                        QueryResult<CmsContlist> cmsContlistQueryResult = this.cmsConttitleService.queryContlistPage(param);
                        if (!ListUtil.isNotEmpty((Collection)cmsContlistQueryResult.getList())) continue;
                        for (CmsContlist cmsContlist : cmsContlistQueryResult.getList()) {
                            cmsContlist.setContlistId(null);
                            cmsContlist.setContlistCode(null);
                            cmsContlist.setTginfoMenuCode(cmsTginfoMenu.getTginfoMenuCode());
                            cmsContlist.setConttitleCode(cmsConttitle.getConttitleCode());
                            this.setContlistDefault(cmsContlist);
                            this.cmsConttitleService.saveContlistMode(cmsContlist);
                        }
                    }
                }
                this.makeSaveChild(parentMenu, code, tenantCode, parantCode, tginfoCode, type);
            }
        }
    }

    private void makeSaveChild(ConcurrentHashMap<String, List<CmsTginfoMenu>> parentMenu, String code, String tenantCode, String parantCode, String tginfoCode, String type) {
        List<CmsTginfoMenu> cmsTginfoMenus3 = parentMenu.get(code);
        this.logger.error("cms.CmsTginfoServiceImpl=====>cmsTginfoMenus3", (Object)JsonUtil.buildNormalBinder().toJson(cmsTginfoMenus3));
        if (ListUtil.isNotEmpty(cmsTginfoMenus3)) {
            for (CmsTginfoMenu tginfoMenu : cmsTginfoMenus3) {
                String ziCode = this.createUUIDString();
                code = tginfoMenu.getTginfoMenuCode();
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("tenantCode", tginfoMenu.getTenantCode());
                param.put("tginfoMenuCode", tginfoMenu.getTginfoMenuCode());
                QueryResult<CmsConttitle> cmsConttitleQueryResult = this.cmsConttitleService.queryConttitlePage(param);
                List query = cmsConttitleQueryResult.getList();
                tginfoMenu.setTginfoMenuId(null);
                tginfoMenu.setTginfoMenuCode(ziCode);
                tginfoMenu.setTginfoMenuPcode(parantCode);
                tginfoMenu.setTenantCode(tenantCode);
                tginfoMenu.setTginfoCode(tginfoCode);
                this.setTginfoMenuDefault(tginfoMenu);
                this.saveTginfoMenuModel(tginfoMenu);
                if (!ListUtil.isNotEmpty((Collection)query)) continue;
                for (CmsConttitle cmsConttitle : query) {
                    String conpranetCode = cmsConttitle.getConttitleCode();
                    cmsConttitle.setConttitleId(null);
                    cmsConttitle.setConttitleCode(null);
                    cmsConttitle.setTenantCode(tenantCode);
                    cmsConttitle.setTginfoMenuCode(ziCode);
                    this.setConttitleDefault(cmsConttitle);
                    this.saveConttitleModel(cmsConttitle);
                    if (StringUtils.isBlank((String)type)) {
                        type = "0";
                    }
                    if (!"1".equals(type)) continue;
                    param = new HashMap();
                    param.put("tenantCode", tenantCode);
                    param.put("conttitleCode", conpranetCode);
                    QueryResult<CmsContlist> cmsContlistQueryResult = this.cmsConttitleService.queryContlistPage(param);
                    if (!ListUtil.isNotEmpty((Collection)cmsContlistQueryResult.getList())) continue;
                    for (CmsContlist cmsContlist : cmsContlistQueryResult.getList()) {
                        cmsContlist.setContlistId(null);
                        cmsContlist.setContlistCode(null);
                        cmsContlist.setTginfoMenuCode(ziCode);
                        cmsContlist.setConttitleCode(cmsConttitle.getConttitleCode());
                        this.setContlistDefault(cmsContlist);
                        this.cmsConttitleService.saveContlistMode(cmsContlist);
                    }
                }
            }
        }
    }

    @Override
    public void saveTginfoMenuByProappCode(String proappCode, String tenantCode, String userinfoCode) throws ApiException {
        if (StringUtils.isBlank((String)proappCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)userinfoCode)) {
            throw new ApiException("\u53c2\u6570\u5f02\u5e38");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        param.put("tginfoCode", proappCode + "-" + userinfoCode);
        QueryResult<CmsTginfoMenu> cmsTginfoMenuQueryResult = this.cmsTginfoMenuService.queryTginfoMenuPage(param);
        if (ListUtil.isEmpty((Collection)cmsTginfoMenuQueryResult.getList())) {
            this.saveUserinfoTginfoMenu(tenantCode, proappCode, userinfoCode, "1");
        } else {
            this.deleteUserinfoTginfoMenu(cmsTginfoMenuQueryResult.getList());
            this.saveUserinfoTginfoMenu(tenantCode, proappCode, userinfoCode, "1");
        }
    }

    private void deleteUserinfoTginfoMenu(List<CmsTginfoMenu> cmsTginfoMenuList) {
        for (CmsTginfoMenu cmsTginfoMenu : cmsTginfoMenuList) {
            this.cmsTginfoMenuService.deleteTginfoMenuByCode(cmsTginfoMenu.getTenantCode(), cmsTginfoMenu.getTginfoMenuCode());
            this.cmsConttitleService.deleteConttitleByTginfoMenuCode(cmsTginfoMenu.getTenantCode(), cmsTginfoMenu.getTginfoMenuCode());
            this.cmsConttitleService.deleteConttitlelistByTginfoMenuCode(cmsTginfoMenu.getTenantCode(), cmsTginfoMenu.getTginfoMenuCode());
        }
    }

    private void saveUserinfoTginfoMenu(String tenantCode, String proappCode, String userinfoCode, String type) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        param.put("tginfoCode", proappCode + "-plat");
        QueryResult<CmsTginfoMenu> cmsTginfoMenuQueryResult = this.cmsTginfoMenuService.queryTginfoMenuPage(param);
        if (ListUtil.isEmpty((Collection)cmsTginfoMenuQueryResult.getList())) {
            throw new ApiException("\u5e73\u53f0\u6a21\u677f\u672a\u914d\u7f6e", proappCode);
        }
        String tginfoCodeStr = proappCode + "-" + userinfoCode;
        this.saveNewTginfoMenu(tenantCode, tginfoCodeStr, cmsTginfoMenuQueryResult.getList(), type);
    }
}

