/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.potential.dao.PtPotentialSendMapper;
import com.yqbsoft.laser.service.potential.domain.PtPotentialSendDomain;
import com.yqbsoft.laser.service.potential.domain.PtPotentialSendReDomain;
import com.yqbsoft.laser.service.potential.model.PtPotentialSend;
import com.yqbsoft.laser.service.potential.service.PtPotentialSendService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PtPotentialSendServiceImpl
extends BaseServiceImpl
implements PtPotentialSendService {
    private static final String SYS_CODE = "pt.POTENTIAL.PtPotentialSendServiceImpl";
    private PtPotentialSendMapper ptPotentialSendMapper;

    public void setPtPotentialSendMapper(PtPotentialSendMapper ptPotentialSendMapper) {
        this.ptPotentialSendMapper = ptPotentialSendMapper;
    }

    private Date getSysDate() {
        try {
            return this.ptPotentialSendMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtPotentialSendServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPtPotentialSend(PtPotentialSendDomain ptPotentialSendDomain) {
        if (null == ptPotentialSendDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ptPotentialSendDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPtPotentialSendDefault(PtPotentialSend ptPotentialSend) {
        if (null == ptPotentialSend) {
            return;
        }
        if (null == ptPotentialSend.getDataState()) {
            ptPotentialSend.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ptPotentialSend.getGmtCreate()) {
            ptPotentialSend.setGmtCreate(date);
        }
        ptPotentialSend.setGmtModified(date);
        if (StringUtils.isBlank((String)ptPotentialSend.getPotentialsendCode())) {
            ptPotentialSend.setPotentialsendCode(this.getNo(null, "PtPotentialSend", "ptPotentialSend", ptPotentialSend.getTenantCode()));
        }
    }

    private int getPtPotentialSendMaxCode() {
        int code = 0;
        try {
            return this.ptPotentialSendMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtPotentialSendServiceImpl.getPtPotentialSendMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPtPotentialSendUpdataDefault(PtPotentialSend ptPotentialSend) {
        if (null == ptPotentialSend) {
            return;
        }
        ptPotentialSend.setGmtModified(this.getSysDate());
    }

    private void savePtPotentialSendModel(PtPotentialSend ptPotentialSend) throws ApiException {
        if (null == ptPotentialSend) {
            return;
        }
        try {
            this.ptPotentialSendMapper.insert(ptPotentialSend);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtPotentialSendServiceImpl.savePtPotentialSendModel.ex", (Throwable)e);
        }
    }

    private void savePtPotentialSendBatchModel(List<PtPotentialSend> ptPotentialSendList) throws ApiException {
        if (null == ptPotentialSendList || ptPotentialSendList.isEmpty()) {
            return;
        }
        try {
            this.ptPotentialSendMapper.insertBatch(ptPotentialSendList);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtPotentialSendServiceImpl.savePtPotentialSendBatchModel.ex", (Throwable)e);
        }
    }

    private PtPotentialSend getPtPotentialSendModelById(Integer potentialsendId) {
        if (null == potentialsendId) {
            return null;
        }
        try {
            return this.ptPotentialSendMapper.selectByPrimaryKey(potentialsendId);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtPotentialSendServiceImpl.getPtPotentialSendModelById", (Throwable)e);
            return null;
        }
    }

    private PtPotentialSend getPtPotentialSendModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptPotentialSendMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtPotentialSendServiceImpl.getPtPotentialSendModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPtPotentialSendModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptPotentialSendMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtPotentialSendServiceImpl.delPtPotentialSendModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtPotentialSendServiceImpl.delPtPotentialSendModelByCode.num");
        }
    }

    private void deletePtPotentialSendModel(Integer potentialsendId) throws ApiException {
        if (null == potentialsendId) {
            return;
        }
        int i = 0;
        try {
            i = this.ptPotentialSendMapper.deleteByPrimaryKey(potentialsendId);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtPotentialSendServiceImpl.deletePtPotentialSendModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtPotentialSendServiceImpl.deletePtPotentialSendModel.num");
        }
    }

    private void updatePtPotentialSendModel(PtPotentialSend ptPotentialSend) throws ApiException {
        if (null == ptPotentialSend) {
            return;
        }
        int i = 0;
        try {
            i = this.ptPotentialSendMapper.updateByPrimaryKey(ptPotentialSend);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtPotentialSendServiceImpl.updatePtPotentialSendModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtPotentialSendServiceImpl.updatePtPotentialSendModel.num");
        }
    }

    private void updateStatePtPotentialSendModel(Integer potentialsendId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == potentialsendId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("potentialsendId", potentialsendId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptPotentialSendMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtPotentialSendServiceImpl.updateStatePtPotentialSendModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtPotentialSendServiceImpl.updateStatePtPotentialSendModel.null");
        }
    }

    private void updateStatePtPotentialSendModelByCode(String tenantCode, String potentialsendCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)potentialsendCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("potentialsendCode", potentialsendCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptPotentialSendMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtPotentialSendServiceImpl.updateStatePtPotentialSendModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtPotentialSendServiceImpl.updateStatePtPotentialSendModelByCode.null");
        }
    }

    private PtPotentialSend makePtPotentialSend(PtPotentialSendDomain ptPotentialSendDomain, PtPotentialSend ptPotentialSend) {
        if (null == ptPotentialSendDomain) {
            return null;
        }
        if (null == ptPotentialSend) {
            ptPotentialSend = new PtPotentialSend();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptPotentialSend, (Object)ptPotentialSendDomain);
            return ptPotentialSend;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtPotentialSendServiceImpl.makePtPotentialSend", (Throwable)e);
            return null;
        }
    }

    private PtPotentialSendReDomain makePtPotentialSendReDomain(PtPotentialSend ptPotentialSend) {
        if (null == ptPotentialSend) {
            return null;
        }
        PtPotentialSendReDomain ptPotentialSendReDomain = new PtPotentialSendReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ptPotentialSendReDomain, (Object)ptPotentialSend);
            return ptPotentialSendReDomain;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtPotentialSendServiceImpl.makePtPotentialSendReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PtPotentialSend> queryPtPotentialSendModelPage(Map<String, Object> parammap) {
        try {
            return this.ptPotentialSendMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtPotentialSendServiceImpl.queryPtPotentialSendModel", (Throwable)e);
            return null;
        }
    }

    private int countPtPotentialSend(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptPotentialSendMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtPotentialSendServiceImpl.countPtPotentialSend", (Throwable)e);
        }
        return i;
    }

    private PtPotentialSend createPtPotentialSend(PtPotentialSendDomain ptPotentialSendDomain) {
        String msg = this.checkPtPotentialSend(ptPotentialSendDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtPotentialSendServiceImpl.savePtPotentialSend.checkPtPotentialSend", msg);
        }
        PtPotentialSend ptPotentialSend = this.makePtPotentialSend(ptPotentialSendDomain, null);
        this.setPtPotentialSendDefault(ptPotentialSend);
        return ptPotentialSend;
    }

    @Override
    public String savePtPotentialSend(PtPotentialSendDomain ptPotentialSendDomain) throws ApiException {
        PtPotentialSend ptPotentialSend = this.createPtPotentialSend(ptPotentialSendDomain);
        this.savePtPotentialSendModel(ptPotentialSend);
        return ptPotentialSend.getPotentialsendCode();
    }

    @Override
    public String savePtPotentialSendBatch(List<PtPotentialSendDomain> ptPotentialSendDomainList) throws ApiException {
        if (null == ptPotentialSendDomainList || ptPotentialSendDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PtPotentialSend> ptPotentialSendList = new ArrayList<PtPotentialSend>();
        String code = "";
        for (PtPotentialSendDomain ptPotentialSendDomain : ptPotentialSendDomainList) {
            PtPotentialSend ptPotentialSend = this.createPtPotentialSend(ptPotentialSendDomain);
            code = ptPotentialSend.getPotentialsendCode();
            ptPotentialSendList.add(ptPotentialSend);
        }
        this.savePtPotentialSendBatchModel(ptPotentialSendList);
        return code;
    }

    @Override
    public void updatePtPotentialSendState(Integer potentialsendId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == potentialsendId) {
            return;
        }
        this.updateStatePtPotentialSendModel(potentialsendId, dataState, oldDataState, map);
    }

    @Override
    public void updatePtPotentialSendStateByCode(String tenantCode, String potentialsendCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)potentialsendCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePtPotentialSendModelByCode(tenantCode, potentialsendCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePtPotentialSend(PtPotentialSendDomain ptPotentialSendDomain) throws ApiException {
        String msg = this.checkPtPotentialSend(ptPotentialSendDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtPotentialSendServiceImpl.updatePtPotentialSend.checkPtPotentialSend", msg);
        }
        PtPotentialSend oldPtPotentialSend = this.getPtPotentialSendModelById(ptPotentialSendDomain.getPotentialsendId());
        if (null == oldPtPotentialSend) {
            throw new ApiException("pt.POTENTIAL.PtPotentialSendServiceImpl.updatePtPotentialSend.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtPotentialSend ptPotentialSend = this.makePtPotentialSend(ptPotentialSendDomain, oldPtPotentialSend);
        this.setPtPotentialSendUpdataDefault(ptPotentialSend);
        this.updatePtPotentialSendModel(ptPotentialSend);
    }

    @Override
    public PtPotentialSend getPtPotentialSend(Integer potentialsendId) {
        if (null == potentialsendId) {
            return null;
        }
        return this.getPtPotentialSendModelById(potentialsendId);
    }

    @Override
    public void deletePtPotentialSend(Integer potentialsendId) throws ApiException {
        if (null == potentialsendId) {
            return;
        }
        this.deletePtPotentialSendModel(potentialsendId);
    }

    @Override
    public QueryResult<PtPotentialSend> queryPtPotentialSendPage(Map<String, Object> map) {
        List<PtPotentialSend> ptPotentialSendList = this.queryPtPotentialSendModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPtPotentialSend(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptPotentialSendList);
        return queryResult;
    }

    @Override
    public PtPotentialSend getPtPotentialSendByCode(String tenantCode, String potentialsendCode) throws ApiException {
        if (StringUtils.isBlank((String)potentialsendCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("potentialsendCode", potentialsendCode);
        return this.getPtPotentialSendModelByCode(map);
    }

    @Override
    public void deletePtPotentialSendByCode(String tenantCode, String potentialsendCode) throws ApiException {
        if (StringUtils.isBlank((String)potentialsendCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("potentialsendCode", potentialsendCode);
        this.delPtPotentialSendModelByCode(map);
    }
}

