/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.potential.dao.PtPotentialMapper;
import com.yqbsoft.laser.service.potential.domain.PtPotentialDomain;
import com.yqbsoft.laser.service.potential.domain.PtPotentialReDomain;
import com.yqbsoft.laser.service.potential.domain.PtPotentialSendDomain;
import com.yqbsoft.laser.service.potential.enums.PotentialCreateType;
import com.yqbsoft.laser.service.potential.enums.PotentialCustomerStatus;
import com.yqbsoft.laser.service.potential.enums.PotentialCustomerType;
import com.yqbsoft.laser.service.potential.enums.PotentialFeeAction;
import com.yqbsoft.laser.service.potential.enums.PotentialFeeType;
import com.yqbsoft.laser.service.potential.enums.PotentialLevel;
import com.yqbsoft.laser.service.potential.enums.PotentialSourceType;
import com.yqbsoft.laser.service.potential.enums.PotentialType;
import com.yqbsoft.laser.service.potential.enums.PtPotentialFeatureKey;
import com.yqbsoft.laser.service.potential.model.PtPotential;
import com.yqbsoft.laser.service.potential.model.PtPotentialFee;
import com.yqbsoft.laser.service.potential.model.PtPotentialSend;
import com.yqbsoft.laser.service.potential.service.PtPotentialFeeService;
import com.yqbsoft.laser.service.potential.service.PtPotentialSendService;
import com.yqbsoft.laser.service.potential.service.PtPotentialService;
import com.yqbsoft.laser.service.potential.utils.NumberUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class PtPotentialServiceImpl
extends BaseServiceImpl
implements PtPotentialService {
    private static final String SYS_CODE = "pt.POTENTIAL.PtPotentialServiceImpl";
    private PtPotentialMapper ptPotentialMapper;
    @Autowired
    private PtPotentialFeeService ptPotentialFeeService;
    @Autowired
    private PtPotentialSendService ptPotentialSendService;

    public void setPtPotentialMapper(PtPotentialMapper ptPotentialMapper) {
        this.ptPotentialMapper = ptPotentialMapper;
    }

    private Date getSysDate() {
        try {
            return this.ptPotentialMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtPotentialServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPtPotential(PtPotentialDomain ptPotentialDomain) {
        int potentialSourceType;
        int potentialCreateType;
        if (null == ptPotentialDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String potentialName = ptPotentialDomain.getPotentialName();
        String msg = "";
        if (StringUtils.isBlank((String)potentialName)) {
            msg = "\u6f5c\u5ba2\u540d\u79f0\u4e3a\u7a7a";
            return msg;
        }
        int potentialLevel = NumberUtil.intValue(ptPotentialDomain.getPotentialLevel());
        if (potentialLevel <= 0) {
            msg = "\u6f5c\u5ba2\u7ea7\u522b\u4e3a\u7a7a";
            return msg;
        }
        if (!PotentialLevel.check(potentialLevel)) {
            msg = "\u6f5c\u5ba2\u7ea7\u522b\u65e0\u6548";
            return msg;
        }
        if (StringUtils.isBlank((String)ptPotentialDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        if ((potentialCreateType = NumberUtil.intValue(ptPotentialDomain.getPotentialCreateType())) <= 0) {
            msg = "\u6f5c\u5ba2\u521b\u5efa\u7c7b\u578b\u4e3a\u7a7a";
            return msg;
        }
        if (!PotentialCreateType.check(potentialCreateType)) {
            msg = "\u6f5c\u5ba2\u521b\u5efa\u7c7b\u578b\u65e0\u6548";
            return msg;
        }
        if (PotentialLevel.LEVEL_ONE.getCode() == potentialLevel) {
            if (PotentialCreateType.DOWNGRADE_FROM_PRIMARY.getCode() == potentialCreateType) {
                msg = "\u6f5c\u5ba2\u521b\u5efa\u7c7b\u578b\u65e0\u6548";
                return msg;
            }
        } else if (PotentialLevel.LEVEL_TWO.getCode() == potentialLevel && PotentialCreateType.UPGRADE_FROM_SECONDARY.getCode() == potentialCreateType) {
            msg = "\u6f5c\u5ba2\u521b\u5efa\u7c7b\u578b\u65e0\u6548";
            return msg;
        }
        if ((potentialSourceType = NumberUtil.intValue(ptPotentialDomain.getPotentialSourceType())) <= 0) {
            msg = "\u6f5c\u5ba2\u6765\u6e90\u7c7b\u578b\u4e3a\u7a7a";
            return msg;
        }
        if (!PotentialSourceType.check(potentialSourceType)) {
            msg = "\u6f5c\u5ba2\u6765\u6e90\u7c7b\u578b\u65e0\u6548";
            return msg;
        }
        int potentialType = NumberUtil.intValue(ptPotentialDomain.getPotentialType());
        if (potentialType <= 0) {
            msg = "\u6f5c\u5ba2\u5355\u4f4d\u7c7b\u578b\u4e3a\u7a7a";
            return msg;
        }
        if (!PotentialType.check(potentialType)) {
            msg = "\u6f5c\u5ba2\u5355\u4f4d\u7c7b\u578b\u65e0\u6548";
            return msg;
        }
        int potentialCustomerType = NumberUtil.intValue(ptPotentialDomain.getPotentialCustomerType());
        if (potentialCustomerType <= 0) {
            msg = "\u6f5c\u5ba2\u5355\u4f4d\u7c7b\u578b\u4e3a\u7a7a";
            return msg;
        }
        if (!PotentialCustomerType.check(potentialCustomerType)) {
            msg = "\u6f5c\u5ba2\u5355\u4f4d\u7c7b\u578b\u65e0\u6548";
            return msg;
        }
        return msg;
    }

    private void setPtPotentialDefault(PtPotential ptPotential) {
        ptPotential.setDataState(0);
        Date date = this.getSysDate();
        ptPotential.setGmtCreate(date);
        ptPotential.setGmtModified(date);
        if (PotentialLevel.LEVEL_ONE.getCode() == NumberUtil.intValue(ptPotential.getPotentialLevel())) {
            ptPotential.setPotentialCustomerStatus(PotentialCustomerStatus.PENDING_CREATE_CONTRACT.getCode());
        } else if (PotentialLevel.LEVEL_TWO.getCode() == NumberUtil.intValue(ptPotential.getPotentialLevel())) {
            ptPotential.setPotentialCustomerStatus(PotentialCustomerStatus.PENDING_SET_INTENT_DEPOSIT.getCode());
        }
        ptPotential.setPotentialStatus(0);
        ptPotential.addFeature(PtPotentialFeatureKey.FEATURE_CODE_ATTACH_LIST.getCode(), JSON.toJSONString(ptPotential.getAttachList()));
        if (null == ptPotential.getPotentialCode()) {
            String potentialCode = this.getNo(null, "PtPotential", "ptPotential", ptPotential.getTenantCode());
            this.logger.info("PtPotentialServiceImpl->setPtPotentialDefault  potentialCode:", (Object)potentialCode);
            ptPotential.setPotentialCode(potentialCode);
        }
    }

    private int getPtPotentialMaxCode() {
        int code = 0;
        try {
            return this.ptPotentialMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtPotentialServiceImpl.getPtPotentialMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPtPotentialUpdataDefault(PtPotential ptPotential) {
        if (null == ptPotential) {
            return;
        }
        ptPotential.setGmtModified(this.getSysDate());
    }

    private void savePtPotentialModel(PtPotential ptPotential) throws ApiException {
        if (null == ptPotential) {
            return;
        }
        try {
            if (StringUtils.isNotBlank((String)ptPotential.getPotentialCertNo()) && StringUtils.isNotBlank((String)ptPotential.getTenantCode()) && this.ptPotentialMapper.queryPotentialCertNoCount(ptPotential.getPotentialCertNo(), ptPotential.getTenantCode()) > 0) {
                throw new IllegalArgumentException("'\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801' \u6216 '\u6cd5\u4eba/\u5ba2\u6237\u8eab\u4efd\u8bc1\u53f7' \u4e0d\u80fd\u91cd\u590d\uff01");
            }
            this.ptPotentialMapper.insert(ptPotential);
        }
        catch (Exception e) {
            String errorMsg = e instanceof IllegalArgumentException ? e.getLocalizedMessage() : "\u64cd\u4f5c\u5931\u8d25";
            throw new ApiException("pt.POTENTIAL.PtPotentialServiceImpl.savePtPotentialModel/ex", errorMsg, (Throwable)e);
        }
    }

    private void savePtPotentialBatchModel(List<PtPotential> ptPotentialList) throws ApiException {
        if (null == ptPotentialList || ptPotentialList.isEmpty()) {
            return;
        }
        try {
            this.ptPotentialMapper.insertBatch(ptPotentialList);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtPotentialServiceImpl.savePtPotentialBatchModel.ex", (Throwable)e);
        }
    }

    private PtPotential getPtPotentialModelById(Integer potentialId) {
        if (null == potentialId) {
            return null;
        }
        PtPotential ptPotential = null;
        try {
            ptPotential = this.ptPotentialMapper.selectByPrimaryKey(potentialId);
            if (null == ptPotential) {
                return ptPotential;
            }
            String tenantCode = ptPotential.getTenantCode();
            Map<String, BigDecimal> balanceMap = this.calculatePotentialCodeBalances(ptPotential.getPotentialCode(), tenantCode);
            BigDecimal balance = balanceMap.getOrDefault(ptPotential.getPotentialCode(), BigDecimal.ZERO);
            ptPotential.setPotentialFeeBalance(balance);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtPotentialServiceImpl.getPtPotentialModelById", (Throwable)e);
        }
        this.setFeature(ptPotential);
        return ptPotential;
    }

    private PtPotential getPtPotentialModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        PtPotential ptPotential = null;
        try {
            ptPotential = this.ptPotentialMapper.getByCode(map);
            if (null == ptPotential) {
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtPotentialServiceImpl.getPtPotentialModelByCode", (Throwable)e);
        }
        this.setFeature(ptPotential);
        return ptPotential;
    }

    private void setFeature(PtPotentialDomain ptPotentialDomain) {
        try {
            ptPotentialDomain.setAttachList((List)JSON.parseObject((String)ptPotentialDomain.getFeatureByCode(PtPotentialFeatureKey.FEATURE_CODE_ATTACH_LIST.getCode()), (TypeReference)new TypeReference<List<String>>(){}, (Feature[])new Feature[0]));
        }
        catch (Exception ex) {
            this.logger.error("setAttachList error", (Throwable)ex);
        }
    }

    private void setFeature(PtPotential ptPotential) {
        try {
            ptPotential.setAttachList((List)JSON.parseObject((String)ptPotential.getFeatureByCode(PtPotentialFeatureKey.FEATURE_CODE_ATTACH_LIST.getCode()), (TypeReference)new TypeReference<List<String>>(){}, (Feature[])new Feature[0]));
        }
        catch (Exception ex) {
            this.logger.error("setAttachList error", (Throwable)ex);
        }
    }

    private void delPtPotentialModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptPotentialMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtPotentialServiceImpl.delPtPotentialModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtPotentialServiceImpl.delPtPotentialModelByCode.num");
        }
    }

    private void deletePtPotentialModel(Integer potentialId) throws ApiException {
        if (null == potentialId) {
            return;
        }
        int i = 0;
        try {
            i = this.ptPotentialMapper.deleteByPrimaryKey(potentialId);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtPotentialServiceImpl.deletePtPotentialModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtPotentialServiceImpl.deletePtPotentialModel.num");
        }
    }

    private void updatePtPotentialModel(PtPotential ptPotential) throws ApiException {
        if (null == ptPotential) {
            return;
        }
        int i = 0;
        try {
            i = this.ptPotentialMapper.updateByPrimaryKeySelective(ptPotential);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtPotentialServiceImpl.updatePtPotentialModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.POTENTIAL.PtPotentialServiceImpl.updatePtPotentialModel.num");
        }
    }

    private void updateStatePtPotentialModel(Integer potentialId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == potentialId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("potentialId", potentialId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptPotentialMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtPotentialServiceImpl.updateStatePtPotentialModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtPotentialServiceImpl.updateStatePtPotentialModel.null");
        }
    }

    private void updateCustomerStatusPtPotentialModel(Integer potentialId, Integer potentialCustomerStatus, Integer oldPotentialCustomerStatus, Map<String, Object> expmap) throws ApiException {
        if (null == potentialId || null == potentialCustomerStatus) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("potentialId", potentialId);
        map.put("potentialCustomerStatus", potentialCustomerStatus);
        map.put("oldPotentialCustomerStatus", oldPotentialCustomerStatus);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptPotentialMapper.updateCustomerStatusByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtPotentialServiceImpl.updateCustomerStatusPtPotentialModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtPotentialServiceImpl.updateCustomerStatusPtPotentialModel.null");
        }
    }

    private void updateStatePtPotentialModelByCode(String tenantCode, String potentialCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)potentialCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("potentialCode", potentialCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ptPotentialMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.POTENTIAL.PtPotentialServiceImpl.updateStatePtPotentialModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.POTENTIAL.PtPotentialServiceImpl.updateStatePtPotentialModelByCode.null");
        }
    }

    private PtPotential makePtPotential(PtPotentialDomain ptPotentialDomain, PtPotential ptPotential) {
        if (null == ptPotentialDomain) {
            return null;
        }
        if (null == ptPotential) {
            ptPotential = new PtPotential();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptPotential, (Object)ptPotentialDomain);
            return ptPotential;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtPotentialServiceImpl.makePtPotential", (Throwable)e);
            return null;
        }
    }

    private PtPotentialReDomain makePtPotentialReDomain(PtPotential ptPotential) {
        if (null == ptPotential) {
            return null;
        }
        PtPotentialReDomain ptPotentialReDomain = new PtPotentialReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ptPotentialReDomain, (Object)ptPotential);
            return ptPotentialReDomain;
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtPotentialServiceImpl.makePtPotentialReDomain", (Throwable)e);
            return null;
        }
    }

    private List<PtPotential> queryPtPotentialModelPage(Map<String, Object> parammap) {
        try {
            return this.ptPotentialMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtPotentialServiceImpl.queryPtPotentialModel", (Throwable)e);
            return null;
        }
    }

    private int countPtPotential(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptPotentialMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pt.POTENTIAL.PtPotentialServiceImpl.countPtPotential", (Throwable)e);
        }
        return i;
    }

    private PtPotential createPtPotential(PtPotentialDomain ptPotentialDomain) {
        String msg = this.checkPtPotential(ptPotentialDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtPotentialServiceImpl.savePtPotential.checkPtPotential", msg);
        }
        PtPotential ptPotential = this.makePtPotential(ptPotentialDomain, null);
        this.setPtPotentialDefault(ptPotential);
        return ptPotential;
    }

    @Override
    public List<PtPotentialSend> savePtPotential(PtPotentialDomain ptPotentialDomain) throws ApiException {
        this.logger.info("PtPotentialServiceImpl->savePtPotential begin ptPotentialDomain:", (Object)JSON.toJSONString((Object)ptPotentialDomain));
        PtPotential ptPotential = this.createPtPotential(ptPotentialDomain);
        this.logger.info("PtPotentialServiceImpl->savePtPotential->createPtPotential ptPotential:", (Object)JSON.toJSONString((Object)ptPotential));
        this.savePtPotentialModel(ptPotential);
        this.logger.info("PtPotentialServiceImpl->savePtPotential end ptPotential:", (Object)JSON.toJSONString((Object)ptPotential));
        Collection sendList = null;
        List<PtPotentialSend> reSendList = null;
        ArrayList<PtPotential> list = new ArrayList<PtPotential>();
        list.add(ptPotential);
        reSendList = this.buidPmChannelsend(list, "insert");
        if (ListUtil.isNotEmpty(sendList)) {
            reSendList.addAll(sendList);
        }
        ptPotentialDomain.setPotentialCode(ptPotential.getPotentialCode());
        return reSendList;
    }

    private List<PtPotentialSend> buidPmChannelsend(List<PtPotential> ptPotentialList, String dri) {
        if (ListUtil.isEmpty(ptPotentialList)) {
            return null;
        }
        ArrayList<PtPotentialSend> ptPotentialsendList = new ArrayList();
        ArrayList<PtPotentialSendDomain> disPotentiasendDomainList = new ArrayList<PtPotentialSendDomain>();
        for (PtPotential potential : ptPotentialList) {
            PtPotentialSendDomain ptPotentialSendDomain = new PtPotentialSendDomain();
            ptPotentialSendDomain.setPotentialCode(potential.getChannelCode());
            ptPotentialSendDomain.setPotentialsendType("PtPotential");
            ptPotentialSendDomain.setPotentialsendDir(dri);
            ptPotentialSendDomain.setPotentialLevel(potential.getPotentialLevel());
            ptPotentialSendDomain.setPotentialsendCode(potential.getPotentialCode());
            ptPotentialSendDomain.setTenantCode(potential.getTenantCode());
            disPotentiasendDomainList.add(ptPotentialSendDomain);
        }
        ptPotentialsendList = this.ptPotentialSendService.savePtPotentialSendBatch(disPotentiasendDomainList);
        return ptPotentialsendList;
    }

    @Override
    public String savePtPotentialBatch(List<PtPotentialDomain> ptPotentialDomainList) throws ApiException {
        if (null == ptPotentialDomainList || ptPotentialDomainList.isEmpty()) {
            return null;
        }
        ArrayList<PtPotential> ptPotentialList = new ArrayList<PtPotential>();
        String code = "";
        for (PtPotentialDomain ptPotentialDomain : ptPotentialDomainList) {
            PtPotential ptPotential = this.createPtPotential(ptPotentialDomain);
            code = ptPotential.getPotentialCode();
            ptPotentialList.add(ptPotential);
        }
        this.savePtPotentialBatchModel(ptPotentialList);
        return code;
    }

    @Override
    public void updatePtPotentialState(Integer potentialId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == potentialId) {
            return;
        }
        this.updateStatePtPotentialModel(potentialId, dataState, oldDataState, map);
    }

    @Override
    public void updatePtPotentialCustomerStatus(Integer potentialId, Integer potentialCustomerStatus, Integer oldPotentialCustomerStatus, Map<String, Object> map) throws ApiException {
        if (null == potentialId) {
            return;
        }
        this.updateCustomerStatusPtPotentialModel(potentialId, potentialCustomerStatus, oldPotentialCustomerStatus, map);
    }

    @Override
    public void updatePtPotentialStateByCode(String tenantCode, String potentialCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)potentialCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePtPotentialModelByCode(tenantCode, potentialCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePtPotential(PtPotentialDomain ptPotentialDomain) throws ApiException {
        if (NumberUtil.intValue(ptPotentialDomain.getPotentialId()) <= 0) {
            throw new ApiException("pt.POTENTIAL.PtPotentialServiceImpl.updatePtPotential.potentialId", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtPotential oldPtPotential = this.getPtPotentialModelById(ptPotentialDomain.getPotentialId());
        if (null == oldPtPotential) {
            throw new ApiException("pt.POTENTIAL.PtPotentialServiceImpl.updatePtPotential.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        String msg = this.checkPtPotential(ptPotentialDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.POTENTIAL.PtPotentialServiceImpl.updatePtPotential.checkPtPotential", msg);
        }
        if (ListUtil.isNotEmpty(ptPotentialDomain.getAttachList())) {
            ptPotentialDomain.addFeature(PtPotentialFeatureKey.FEATURE_CODE_ATTACH_LIST.getCode(), JSON.toJSONString(ptPotentialDomain.getAttachList()));
        }
        PtPotential ptPotential = this.makePtPotential(ptPotentialDomain, oldPtPotential);
        this.setPtPotentialUpdataDefault(ptPotential);
        this.updatePtPotentialModel(ptPotential);
    }

    private void setDefaultPtPotentialDomain(PtPotentialDomain ptPotentialDomain, PtPotential oldPtPotential) {
        ptPotentialDomain.setPotentialId(oldPtPotential.getPotentialId());
        ptPotentialDomain.setPotentialCode(oldPtPotential.getPotentialCode());
        ptPotentialDomain.setPotentialCreateType(oldPtPotential.getPotentialCreateType());
        ptPotentialDomain.setPotentialSourceType(oldPtPotential.getPotentialSourceType());
        ptPotentialDomain.setUserCode(oldPtPotential.getUserCode());
        ptPotentialDomain.setUserCode(oldPtPotential.getUserName());
        ptPotentialDomain.setGoodsClass(oldPtPotential.getGoodsClass());
        ptPotentialDomain.initFeature(oldPtPotential.getPotentialFeature());
        this.setFeature(ptPotentialDomain);
    }

    @Override
    public PtPotential getPtPotential(Integer potentialId) {
        if (null == potentialId) {
            return null;
        }
        return this.getPtPotentialModelById(potentialId);
    }

    @Override
    public void deletePtPotential(Integer potentialId) throws ApiException {
        if (null == potentialId) {
            return;
        }
        this.deletePtPotentialModel(potentialId);
    }

    @Override
    public QueryResult<PtPotential> queryPtPotentialPage(Map<String, Object> map) {
        this.logger.info("PtPotentialServiceImpl->queryPtPotentialPage, map:" + JSON.toJSONString(map));
        List<PtPotential> ptPotentialList = this.queryPtPotentialModelPage(map);
        this.setPtPotentialData(ptPotentialList);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPtPotential(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptPotentialList);
        return queryResult;
    }

    private void setPtPotentialData(List<PtPotential> ptPotentialList) {
        if (CollectionUtils.isEmpty(ptPotentialList)) {
            return;
        }
        String potentialCodes = ptPotentialList.stream().map(PtPotential::getPotentialCode).collect(Collectors.joining(","));
        String tenantCode = ptPotentialList.get(0).getTenantCode();
        Map<String, BigDecimal> balanceMap = this.calculatePotentialCodeBalances(potentialCodes, tenantCode);
        for (PtPotential ptPotential : ptPotentialList) {
            BigDecimal balance = balanceMap.getOrDefault(ptPotential.getPotentialCode(), BigDecimal.ZERO);
            ptPotential.setPotentialFeeBalance(balance);
            this.setFeature(ptPotential);
        }
    }

    private Map<String, BigDecimal> calculatePotentialCodeBalances(String potentialCodes, String tenantCode) {
        HashMap<String, BigDecimal> balances = new HashMap();
        try {
            balances = this.calculateBalances(potentialCodes, tenantCode);
        }
        catch (Exception e) {
            this.logger.error("calculateBalances", (Throwable)e);
        }
        return balances;
    }

    private Map<String, BigDecimal> calculateBalances(String potentialCodes, String tenantCode) {
        Map<String, BigDecimal> balanceMap = new HashMap<String, BigDecimal>();
        if (StringUtils.isBlank((String)potentialCodes)) {
            return balanceMap;
        }
        HashMap<String, Object> feeMap = new HashMap<String, Object>();
        feeMap.put("potentialCode", potentialCodes);
        feeMap.put("tenantCode", tenantCode);
        feeMap.put("potentialFeeAction", PotentialFeeAction.SCOUTING_INTENT_GOLD.getCode());
        feeMap.put("potentialLevel", PotentialLevel.LEVEL_TWO.getCode());
        QueryResult<PtPotentialFee> feeQueryResult = this.ptPotentialFeeService.queryPtPotentialFeePage(feeMap);
        if (null == feeQueryResult) {
            return balanceMap;
        }
        List fees = feeQueryResult.getList();
        if (CollectionUtils.isEmpty((Collection)fees)) {
            return balanceMap;
        }
        balanceMap = fees.stream().collect(Collectors.groupingBy(PtPotentialFee::getPotentialCode, Collectors.reducing(BigDecimal.ZERO, fee -> {
            if (NumberUtil.intValue(fee.getPotentialFeeType()) == PotentialFeeType.CHARGE.getCode()) {
                return fee.getPotentialFeeRealamt();
            }
            if (NumberUtil.intValue(fee.getPotentialFeeType()) == PotentialFeeType.REFUND.getCode()) {
                return fee.getPotentialFeeRealamt().negate();
            }
            return BigDecimal.ZERO;
        }, BigDecimal::add)));
        return balanceMap;
    }

    @Override
    public PtPotential getPtPotentialByCode(String tenantCode, String potentialCode) throws ApiException {
        if (StringUtils.isBlank((String)potentialCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("potentialCode", potentialCode);
        return this.getPtPotentialModelByCode(map);
    }

    @Override
    public void deletePtPotentialByCode(String tenantCode, String potentialCode) throws ApiException {
        if (StringUtils.isBlank((String)potentialCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("potentialCode", potentialCode);
        this.delPtPotentialModelByCode(map);
    }
}

