/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.potential.dao.MarginBillMapper;
import com.yqbsoft.laser.service.potential.domain.margin.MarginBill;
import com.yqbsoft.laser.service.potential.domain.margin.MarginTransferRecord;
import com.yqbsoft.laser.service.potential.enums.MarginBillPayStatusEnum;
import com.yqbsoft.laser.service.potential.query.margin.MarginBillPaymentDetail;
import com.yqbsoft.laser.service.potential.service.MarginBillService;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="marginBillService")
public class MarginBillServiceImpl
implements MarginBillService {
    private static final Logger log = LoggerFactory.getLogger(MarginBillServiceImpl.class);
    private final MarginBillMapper marginBillMapper;
    private static final SimpleDateFormat DATE_ONLY = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat DATETIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public SupQueryResult<MarginBill> pageQuery(Map<String, Object> params) {
        int pageNum = (Integer)(params.get("page") == null ? Integer.valueOf(1) : params.get("page"));
        int pageSize = (Integer)(params.get("rows") == null ? Integer.valueOf(10) : params.get("rows"));
        if (pageNum <= 0) {
            pageNum = 1;
        }
        if (pageSize <= 0) {
            pageSize = 20;
        }
        int offset = (pageNum - 1) * pageSize;
        HashMap<String, Object> q = new HashMap<String, Object>();
        q.putAll(params);
        try {
            Object e;
            Object s = q.get("billStartDate");
            if (s != null && s instanceof String && !((String)s).trim().isEmpty()) {
                Date start = DATE_ONLY.parse((String)s);
                String startTimeStr = DATETIME.format(start) + " 00:00:00";
                Calendar c = Calendar.getInstance();
                c.setTime(start);
                c.set(11, 0);
                c.set(12, 0);
                c.set(13, 0);
                q.put("startTime", DATETIME.format(c.getTime()));
            }
            if ((e = q.get("billEndDate")) != null && e instanceof String && !((String)e).trim().isEmpty()) {
                Date end = DATE_ONLY.parse((String)e);
                Calendar c2 = Calendar.getInstance();
                c2.setTime(end);
                c2.set(11, 23);
                c2.set(12, 59);
                c2.set(13, 59);
                q.put("endTime", DATETIME.format(c2.getTime()));
            }
        }
        catch (ParseException s) {
            // empty catch block
        }
        q.put("offset", offset);
        q.put("pageSize", pageSize);
        long total = this.marginBillMapper.countByParams(q);
        List<MarginBill> list = this.marginBillMapper.selectByPage(q);
        SupQueryResult result = new SupQueryResult();
        result.setTotal(total);
        result.setRows(list);
        return result;
    }

    @Override
    public MarginBill getById(Long id) {
        return this.marginBillMapper.selectById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MarginBill create(MarginBill bill) {
        if (bill.getCreatedAt() == null) {
            bill.setCreatedAt(new Date());
        }
        if (bill.getStatus() == null) {
            bill.setStatus("\u5f85\u4ed8\u6b3e");
        }
        this.marginBillMapper.insert(bill);
        return bill;
    }

    @Override
    public MarginTransferRecord convertedInfoPayment(MarginBill bill) {
        return null;
    }

    @Override
    public MarginBill getByMarginNo(String marginNo) {
        return this.marginBillMapper.selectByMarginNo(marginNo);
    }

    @Override
    public MarginBill marginPayment(MarginBillPaymentDetail paymentDetail) {
        MarginBill bill = this.marginBillMapper.selectByMarginNo(paymentDetail.getMarginNo());
        if (bill == null) {
            throw new ApiException("\u4fdd\u8bc1\u91d1\u5355\u4e0d\u5b58\u5728\uff01\u5355\u53f7\u3010" + paymentDetail.getAccountDept() + "\u3011");
        }
        bill.setPayType(paymentDetail.getPayType());
        bill.setReceiveType(paymentDetail.getReceiveType());
        bill.setReceiveAccount(paymentDetail.getReceiveAccount());
        bill.setReceiverName(paymentDetail.getReceiverName());
        bill.setAccountDept(paymentDetail.getAccountDept());
        bill.setOperatorName(paymentDetail.getOperatorName());
        bill.setAmountPaid(bill.getAmountPaid().add(paymentDetail.getAmountPaid()));
        bill.setPayerName(paymentDetail.getPayerName());
        bill.setPayTime(paymentDetail.getPayTime());
        bill.setPayTradeNo(paymentDetail.getPayTradeNo());
        bill.setSettleMethod(paymentDetail.getSettleMethod());
        if (bill.getAmountPayable().compareTo(paymentDetail.getAmountPaid()) <= 0) {
            bill.setPayStatus(MarginBillPayStatusEnum.FULL_PAY.getCode());
        } else {
            bill.setPayStatus(MarginBillPayStatusEnum.PART_PAY.getCode());
        }
        this.marginBillMapper.update(bill);
        return bill;
    }

    public MarginBillServiceImpl(MarginBillMapper marginBillMapper) {
        this.marginBillMapper = marginBillMapper;
    }
}

