/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.service.impl;

import com.yqbsoft.laser.service.potential.dao.MarginPaymentMapper;
import com.yqbsoft.laser.service.potential.domain.margin.MarginPaymentRecord;
import com.yqbsoft.laser.service.potential.service.MarginPaymentService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="marginPaymentService")
public class MarginPaymentServiceImpl
implements MarginPaymentService {
    private static final Logger log = LoggerFactory.getLogger(MarginPaymentServiceImpl.class);
    private final MarginPaymentMapper marginPaymentMapper;

    @Override
    @Transactional
    public MarginPaymentRecord createPayment(MarginPaymentRecord record) {
        record.setPayStatus("PROCESSING");
        record.setCreatedAt(new Date());
        record.setUpdatedAt(new Date());
        this.marginPaymentMapper.insert(record);
        return record;
    }

    @Override
    public MarginPaymentRecord getPaymentByNo(String payNo) {
        return this.marginPaymentMapper.findByPayNo(payNo);
    }

    @Override
    public List<MarginPaymentRecord> listByMarginNo(String marginNo) {
        log.info("==================================list by marginNo:{}", (Object)marginNo);
        return this.marginPaymentMapper.findByMarginNo(marginNo);
    }

    @Override
    public void updateStatus(MarginPaymentRecord record) {
        this.marginPaymentMapper.updateStatus(record.getPayNo(), record.getPayStatus());
    }

    public MarginPaymentServiceImpl(MarginPaymentMapper marginPaymentMapper) {
        this.marginPaymentMapper = marginPaymentMapper;
    }
}

