/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.enums;

import java.util.Objects;

public enum ContractTypeEnum {
    AGENCY(1, "\u7ecf\u9500\u5546\u5408\u540c"),
    FILIALE(2, "\u5206\u516c\u53f8\u5408\u540c"),
    TRIPARTITE(3, "\u4e09\u65b9\u534f\u8bae");

    private final int code;
    private final String description;

    private ContractTypeEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static ContractTypeEnum fromCode(int code) {
        for (ContractTypeEnum type : ContractTypeEnum.values()) {
            if (type.getCode() != code) continue;
            return type;
        }
        return null;
    }

    public static boolean check(int code) {
        for (ContractTypeEnum type : ContractTypeEnum.values()) {
            if (type.getCode() != code) continue;
            return true;
        }
        return false;
    }

    public static int parseDescription(String description) {
        for (ContractTypeEnum type : ContractTypeEnum.values()) {
            if (!Objects.equals(type.getDescription(), description)) continue;
            return type.getCode();
        }
        return -1;
    }
}

