/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.potential.service.impl;

import com.yqbsoft.laser.service.potential.dao.MarginRefundRecordMapper;
import com.yqbsoft.laser.service.potential.domain.margin.MarginRefundRecord;
import com.yqbsoft.laser.service.potential.service.MarginRefundRecordService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="marginRefundRecordService")
public class MarginRefundRecordServiceImpl
implements MarginRefundRecordService {
    private static final Logger log = LoggerFactory.getLogger(MarginRefundRecordServiceImpl.class);
    private final MarginRefundRecordMapper mapper;

    @Override
    public MarginRefundRecord getById(Long id) {
        return this.mapper.selectById(id);
    }

    @Override
    public MarginRefundRecord getByRefundNo(String refundNo) {
        return this.mapper.selectByRefundNo(refundNo);
    }

    @Override
    @Transactional
    public MarginRefundRecord createRefund(MarginRefundRecord record) {
        record.setRefundStatus("PROCESSING");
        record.setRequestTime(new Date());
        this.mapper.insert(record);
        return record;
    }

    @Override
    @Transactional
    public String updateStatus(MarginRefundRecord record) {
        boolean result = this.mapper.updateStatus(record.getId(), record.getRefundStatus(), new Date()) > 0;
        return result ? "SUCCESS" : "FAIL";
    }

    @Override
    @Transactional
    public String processRefund(Long id) {
        MarginRefundRecord record = this.mapper.selectById(id);
        if (record == null || !"PROCESSING".equals(record.getRefundStatus())) {
            return "FAIL";
        }
        try {
            record.setRefundStatus("PROCESSING");
            this.updateStatus(record);
            return "SUCCESS";
        }
        catch (Exception e) {
            record.setRefundStatus("FAIL");
            this.updateStatus(record);
            return "FAIL";
        }
    }

    public MarginRefundRecordServiceImpl(MarginRefundRecordMapper mapper) {
        this.mapper = mapper;
    }
}

