/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsStoreSkuMapper;
import com.yqbsoft.laser.service.resources.domain.RsStoreSkuDomain;
import com.yqbsoft.laser.service.resources.domain.RsStoreSkuReDomain;
import com.yqbsoft.laser.service.resources.model.RsStoreSku;
import com.yqbsoft.laser.service.resources.service.RsStoreSkuService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsStoreSkuServiceImpl
extends BaseServiceImpl
implements RsStoreSkuService {
    private static final String SYS_CODE = "rs.RsStoreSkuServiceImpl";
    private RsStoreSkuMapper rsStoreSkuMapper;

    public void setRsStoreSkuMapper(RsStoreSkuMapper rsStoreSkuMapper) {
        this.rsStoreSkuMapper = rsStoreSkuMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsStoreSkuMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsStoreSkuServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkStoreSku(RsStoreSkuDomain rsStoreSkuDomain) {
        if (null == rsStoreSkuDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsStoreSkuDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setStoreSkuDefault(RsStoreSku rsStoreSku) {
        if (null == rsStoreSku) {
            return;
        }
        if (null == rsStoreSku.getDataState()) {
            rsStoreSku.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsStoreSku.getGmtCreate()) {
            rsStoreSku.setGmtCreate(date);
        }
        rsStoreSku.setGmtModified(date);
        if (StringUtils.isBlank((String)rsStoreSku.getStoreSkuCode())) {
            rsStoreSku.setStoreSkuCode(this.getNo(null, "RsStoreSku", "rsStoreSku", rsStoreSku.getTenantCode()));
        }
    }

    private int getStoreSkuMaxCode() {
        int code = 0;
        try {
            return this.rsStoreSkuMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsStoreSkuServiceImpl.getStoreSkuMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setStoreSkuUpdataDefault(RsStoreSku rsStoreSku) {
        if (null == rsStoreSku) {
            return;
        }
        rsStoreSku.setGmtModified(this.getSysDate());
    }

    private void saveStoreSkuModel(RsStoreSku rsStoreSku) throws ApiException {
        if (null == rsStoreSku) {
            return;
        }
        try {
            this.rsStoreSkuMapper.insert(rsStoreSku);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsStoreSkuServiceImpl.saveStoreSkuModel.ex", (Throwable)e);
        }
    }

    private void saveStoreSkuBatchModel(List<RsStoreSku> rsStoreSkuList) throws ApiException {
        if (null == rsStoreSkuList || rsStoreSkuList.isEmpty()) {
            return;
        }
        try {
            this.rsStoreSkuMapper.insertBatch(rsStoreSkuList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsStoreSkuServiceImpl.saveStoreSkuBatchModel.ex", (Throwable)e);
        }
    }

    private RsStoreSku getStoreSkuModelById(Integer storeSkuId) {
        if (null == storeSkuId) {
            return null;
        }
        try {
            return this.rsStoreSkuMapper.selectByPrimaryKey(storeSkuId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsStoreSkuServiceImpl.getStoreSkuModelById", (Throwable)e);
            return null;
        }
    }

    private RsStoreSku getStoreSkuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsStoreSkuMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsStoreSkuServiceImpl.getStoreSkuModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delStoreSkuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsStoreSkuMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsStoreSkuServiceImpl.delStoreSkuModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsStoreSkuServiceImpl.delStoreSkuModelByCode.num");
        }
    }

    private void deleteStoreSkuModel(Integer storeSkuId) throws ApiException {
        if (null == storeSkuId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsStoreSkuMapper.deleteByPrimaryKey(storeSkuId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsStoreSkuServiceImpl.deleteStoreSkuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsStoreSkuServiceImpl.deleteStoreSkuModel.num");
        }
    }

    private void updateStoreSkuModel(RsStoreSku rsStoreSku) throws ApiException {
        if (null == rsStoreSku) {
            return;
        }
        int i = 0;
        try {
            i = this.rsStoreSkuMapper.updateByPrimaryKey(rsStoreSku);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsStoreSkuServiceImpl.updateStoreSkuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsStoreSkuServiceImpl.updateStoreSkuModel.num");
        }
    }

    private void updateStateStoreSkuModel(Integer storeSkuId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == storeSkuId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storeSkuId", storeSkuId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsStoreSkuMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsStoreSkuServiceImpl.updateStateStoreSkuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsStoreSkuServiceImpl.updateStateStoreSkuModel.null");
        }
    }

    private void updateStateStoreSkuModelByCode(String tenantCode, String storeSkuCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)storeSkuCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeSkuCode", storeSkuCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsStoreSkuMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsStoreSkuServiceImpl.updateStateStoreSkuModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsStoreSkuServiceImpl.updateStateStoreSkuModelByCode.null");
        }
    }

    private RsStoreSku makeStoreSku(RsStoreSkuDomain rsStoreSkuDomain, RsStoreSku rsStoreSku) {
        if (null == rsStoreSkuDomain) {
            return null;
        }
        if (null == rsStoreSku) {
            rsStoreSku = new RsStoreSku();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsStoreSku, (Object)rsStoreSkuDomain);
            return rsStoreSku;
        }
        catch (Exception e) {
            this.logger.error("rs.RsStoreSkuServiceImpl.makeStoreSku", (Throwable)e);
            return null;
        }
    }

    private RsStoreSkuReDomain makeRsStoreSkuReDomain(RsStoreSku rsStoreSku) {
        if (null == rsStoreSku) {
            return null;
        }
        RsStoreSkuReDomain rsStoreSkuReDomain = new RsStoreSkuReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsStoreSkuReDomain, (Object)rsStoreSku);
            return rsStoreSkuReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsStoreSkuServiceImpl.makeRsStoreSkuReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsStoreSku> queryStoreSkuModelPage(Map<String, Object> parammap) {
        try {
            return this.rsStoreSkuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsStoreSkuServiceImpl.queryStoreSkuModel", (Throwable)e);
            return null;
        }
    }

    private int countStoreSku(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsStoreSkuMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsStoreSkuServiceImpl.countStoreSku", (Throwable)e);
        }
        return i;
    }

    private RsStoreSku createRsStoreSku(RsStoreSkuDomain rsStoreSkuDomain) {
        String msg = this.checkStoreSku(rsStoreSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsStoreSkuServiceImpl.saveStoreSku.checkStoreSku", msg);
        }
        RsStoreSku rsStoreSku = this.makeStoreSku(rsStoreSkuDomain, null);
        this.setStoreSkuDefault(rsStoreSku);
        return rsStoreSku;
    }

    @Override
    public String saveStoreSku(RsStoreSkuDomain rsStoreSkuDomain) throws ApiException {
        RsStoreSku rsStoreSku = this.createRsStoreSku(rsStoreSkuDomain);
        this.saveStoreSkuModel(rsStoreSku);
        return rsStoreSku.getStoreSkuCode();
    }

    @Override
    public String saveStoreSkuBatch(List<RsStoreSkuDomain> rsStoreSkuDomainList) throws ApiException {
        if (null == rsStoreSkuDomainList || rsStoreSkuDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsStoreSku> rsStoreSkuList = new ArrayList<RsStoreSku>();
        String code = "";
        for (RsStoreSkuDomain rsStoreSkuDomain : rsStoreSkuDomainList) {
            RsStoreSku rsStoreSku = this.createRsStoreSku(rsStoreSkuDomain);
            code = rsStoreSku.getStoreSkuCode();
            rsStoreSkuList.add(rsStoreSku);
        }
        this.saveStoreSkuBatchModel(rsStoreSkuList);
        return code;
    }

    @Override
    public void updateStoreSkuState(Integer storeSkuId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == storeSkuId) {
            return;
        }
        this.updateStateStoreSkuModel(storeSkuId, dataState, oldDataState, map);
    }

    @Override
    public void updateStoreSkuStateByCode(String tenantCode, String storeSkuCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)storeSkuCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateStoreSkuModelByCode(tenantCode, storeSkuCode, dataState, oldDataState, map);
    }

    @Override
    public void updateStoreSku(RsStoreSkuDomain rsStoreSkuDomain) throws ApiException {
        String msg = this.checkStoreSku(rsStoreSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsStoreSkuServiceImpl.updateStoreSku.checkStoreSku", msg);
        }
        RsStoreSku oldRsStoreSku = this.getStoreSkuModelById(rsStoreSkuDomain.getStoreSkuId());
        if (null == oldRsStoreSku) {
            throw new ApiException("rs.RsStoreSkuServiceImpl.updateStoreSku.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsStoreSku rsStoreSku = this.makeStoreSku(rsStoreSkuDomain, oldRsStoreSku);
        this.setStoreSkuUpdataDefault(rsStoreSku);
        this.updateStoreSkuModel(rsStoreSku);
    }

    @Override
    public RsStoreSku getStoreSku(Integer storeSkuId) {
        if (null == storeSkuId) {
            return null;
        }
        return this.getStoreSkuModelById(storeSkuId);
    }

    @Override
    public void deleteStoreSku(Integer storeSkuId) throws ApiException {
        if (null == storeSkuId) {
            return;
        }
        this.deleteStoreSkuModel(storeSkuId);
    }

    @Override
    public QueryResult<RsStoreSku> queryStoreSkuPage(Map<String, Object> map) {
        List<RsStoreSku> rsStoreSkuList = this.queryStoreSkuModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countStoreSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsStoreSkuList);
        return queryResult;
    }

    @Override
    public RsStoreSku getStoreSkuByCode(String tenantCode, String storeSkuCode) throws ApiException {
        if (StringUtils.isBlank((String)storeSkuCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeSkuCode", storeSkuCode);
        return this.getStoreSkuModelByCode(map);
    }

    @Override
    public void deleteStoreSkuByCode(String tenantCode, String storeSkuCode) throws ApiException {
        if (StringUtils.isBlank((String)storeSkuCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeSkuCode", storeSkuCode);
        this.delStoreSkuModelByCode(map);
    }
}

