/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.rsdis;

import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.domain.RsDisListDomain;
import com.yqbsoft.laser.service.resources.model.RsDisList;
import com.yqbsoft.laser.service.resources.service.RsDisListService;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public class RsDisListRunner
implements ApplicationRunner {
    private static final OpenLogUtil logger = new OpenLogUtil(RsDisListRunner.class);
    public static final String SYS_CODE = "RsDisListRunner.run";
    @Autowired
    RsDisListService rsDisListService;

    public void run(ApplicationArguments args) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataState", 0);
        QueryResult<RsDisList> result = this.rsDisListService.queryRsDisListPage(map);
        if (result == null || result.getRows().isEmpty()) {
            logger.info(SYS_CODE, (Object)".=======\u6e20\u90533.0\u65e0\u9700\u8981\u6267\u884c\u7684\u4efb\u52a1\u6d41\u6c34=======");
        } else {
            long start = System.currentTimeMillis();
            logger.info(SYS_CODE, (Object)(".=======\u6e20\u90533.0\u5f00\u59cb\u4efb\u52a1\u6d41\u6c34 START\uff1a" + start));
            List list = result.getList();
            for (int i = 0; i < list.size(); ++i) {
                RsDisList rsDisList = (RsDisList)list.get(i);
                RsDisListDomain rsDisListDomain = new RsDisListDomain();
                BeanUtils.copyProperties((Object)rsDisListDomain, (Object)rsDisList);
                this.rsDisListService.sendRsDisList(rsDisListDomain);
            }
            long end = System.currentTimeMillis();
            long time = end - start;
            logger.info(SYS_CODE, (Object)(".=======\u6e20\u90533.0\u5f00\u59cb\u4efb\u52a1\u6d41\u6c34 END\uff1a" + end + "\uff0c\u8017\u65f6\uff1a" + time));
        }
    }
}

