/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsOpstoreGoodsMapper;
import com.yqbsoft.laser.service.resources.dao.RsOpstoreMapper;
import com.yqbsoft.laser.service.resources.dao.RsOpstoreSkuMapper;
import com.yqbsoft.laser.service.resources.domain.RsOpstoreDomain;
import com.yqbsoft.laser.service.resources.domain.RsOpstoreGoodsDomain;
import com.yqbsoft.laser.service.resources.domain.RsOpstoreGoodsReDomain;
import com.yqbsoft.laser.service.resources.domain.RsOpstoreReDomain;
import com.yqbsoft.laser.service.resources.domain.RsOpstoreSkuDomain;
import com.yqbsoft.laser.service.resources.domain.RsOpstoreSkuReDomain;
import com.yqbsoft.laser.service.resources.model.RsOpstore;
import com.yqbsoft.laser.service.resources.model.RsOpstoreGoods;
import com.yqbsoft.laser.service.resources.model.RsOpstoreSku;
import com.yqbsoft.laser.service.resources.service.RsOpstoreService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsOpstoreserviceImpl
extends BaseServiceImpl
implements RsOpstoreService {
    private static final String SYS_CODE = "rs.RsOpstoreserviceImpl";
    private RsOpstoreGoodsMapper rsOpstoreGoodsMapper;
    private RsOpstoreMapper rsOpstoreMapper;
    private RsOpstoreSkuMapper rsOpstoreSkuMapper;

    public void setRsOpstoreGoodsMapper(RsOpstoreGoodsMapper rsOpstoreGoodsMapper) {
        this.rsOpstoreGoodsMapper = rsOpstoreGoodsMapper;
    }

    public void setRsOpstoreMapper(RsOpstoreMapper rsOpstoreMapper) {
        this.rsOpstoreMapper = rsOpstoreMapper;
    }

    public void setRsOpstoreSkuMapper(RsOpstoreSkuMapper rsOpstoreSkuMapper) {
        this.rsOpstoreSkuMapper = rsOpstoreSkuMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsOpstoreMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsOpstoreserviceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOpstoreGoods(RsOpstoreGoodsDomain rsOpstoreGoodsDomain) {
        if (null == rsOpstoreGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsOpstoreGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOpstoreGoodsDefault(RsOpstoreGoods rsOpstoreGoods) {
        if (null == rsOpstoreGoods) {
            return;
        }
        if (null == rsOpstoreGoods.getDataState()) {
            rsOpstoreGoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsOpstoreGoods.getGmtCreate()) {
            rsOpstoreGoods.setGmtCreate(date);
        }
        rsOpstoreGoods.setGmtModified(date);
        if (StringUtils.isBlank((String)rsOpstoreGoods.getOpstoreGoodsCode())) {
            rsOpstoreGoods.setOpstoreGoodsCode(this.getNo(null, "RsOpstoreGoods", "rsOpstoreGoods", rsOpstoreGoods.getTenantCode()));
        }
    }

    private int getOpstoreGoodsMaxCode() {
        int code = 0;
        try {
            return this.rsOpstoreGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsOpstoreserviceImpl.getOpstoreGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOpstoreGoodsUpdataDefault(RsOpstoreGoods rsOpstoreGoods) {
        if (null == rsOpstoreGoods) {
            return;
        }
        rsOpstoreGoods.setGmtModified(this.getSysDate());
    }

    private void saveOpstoreGoodsModel(RsOpstoreGoods rsOpstoreGoods) throws ApiException {
        if (null == rsOpstoreGoods) {
            return;
        }
        try {
            this.rsOpstoreGoodsMapper.insert(rsOpstoreGoods);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOpstoreserviceImpl.saveOpstoreGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveOpstoreGoodsBatchModel(List<RsOpstoreGoods> rsOpstoreGoodsList) throws ApiException {
        if (null == rsOpstoreGoodsList || rsOpstoreGoodsList.isEmpty()) {
            return;
        }
        try {
            this.rsOpstoreGoodsMapper.insertBatch(rsOpstoreGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOpstoreserviceImpl.saveOpstoreGoodsBatchModel.ex", (Throwable)e);
        }
    }

    private RsOpstoreGoods getOpstoreGoodsModelById(Integer opstoreGoodsId) {
        if (null == opstoreGoodsId) {
            return null;
        }
        try {
            return this.rsOpstoreGoodsMapper.selectByPrimaryKey(opstoreGoodsId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsOpstoreserviceImpl.getOpstoreGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private RsOpstoreGoods getOpstoreGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsOpstoreGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsOpstoreserviceImpl.getOpstoreGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOpstoreGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsOpstoreGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOpstoreserviceImpl.delOpstoreGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsOpstoreserviceImpl.delOpstoreGoodsModelByCode.num");
        }
    }

    private void deleteOpstoreGoodsModel(Integer opstoreGoodsId) throws ApiException {
        if (null == opstoreGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsOpstoreGoodsMapper.deleteByPrimaryKey(opstoreGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOpstoreserviceImpl.deleteOpstoreGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsOpstoreserviceImpl.deleteOpstoreGoodsModel.num");
        }
    }

    private void updateOpstoreGoodsModel(RsOpstoreGoods rsOpstoreGoods) throws ApiException {
        if (null == rsOpstoreGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.rsOpstoreGoodsMapper.updateByPrimaryKey(rsOpstoreGoods);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOpstoreserviceImpl.updateOpstoreGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsOpstoreserviceImpl.updateOpstoreGoodsModel.num");
        }
    }

    private void updateStateOpstoreGoodsModel(Integer opstoreGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == opstoreGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opstoreGoodsId", opstoreGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsOpstoreGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOpstoreserviceImpl.updateStateOpstoreGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsOpstoreserviceImpl.updateStateOpstoreGoodsModel.null");
        }
    }

    private void updateStateOpstoreGoodsModelByCode(String tenantCode, String opstoreGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)opstoreGoodsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opstoreGoodsCode", opstoreGoodsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsOpstoreGoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOpstoreserviceImpl.updateStateOpstoreGoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsOpstoreserviceImpl.updateStateOpstoreGoodsModelByCode.null");
        }
    }

    private RsOpstoreGoods makeOpstoreGoods(RsOpstoreGoodsDomain rsOpstoreGoodsDomain, RsOpstoreGoods rsOpstoreGoods) {
        if (null == rsOpstoreGoodsDomain) {
            return null;
        }
        if (null == rsOpstoreGoods) {
            rsOpstoreGoods = new RsOpstoreGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsOpstoreGoods, (Object)rsOpstoreGoodsDomain);
            return rsOpstoreGoods;
        }
        catch (Exception e) {
            this.logger.error("rs.RsOpstoreserviceImpl.makeOpstoreGoods", (Throwable)e);
            return null;
        }
    }

    private RsOpstoreGoodsReDomain makeRsOpstoreGoodsReDomain(RsOpstoreGoods rsOpstoreGoods) {
        if (null == rsOpstoreGoods) {
            return null;
        }
        RsOpstoreGoodsReDomain rsOpstoreGoodsReDomain = new RsOpstoreGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsOpstoreGoodsReDomain, (Object)rsOpstoreGoods);
            return rsOpstoreGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsOpstoreserviceImpl.makeRsOpstoreGoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsOpstoreGoods> queryOpstoreGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.rsOpstoreGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsOpstoreserviceImpl.queryOpstoreGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countOpstoreGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsOpstoreGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsOpstoreserviceImpl.countOpstoreGoods", (Throwable)e);
        }
        return i;
    }

    private RsOpstoreGoods createRsOpstoreGoods(RsOpstoreGoodsDomain rsOpstoreGoodsDomain) {
        String msg = this.checkOpstoreGoods(rsOpstoreGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsOpstoreserviceImpl.saveOpstoreGoods.checkOpstoreGoods", msg);
        }
        RsOpstoreGoods rsOpstoreGoods = this.makeOpstoreGoods(rsOpstoreGoodsDomain, null);
        this.setOpstoreGoodsDefault(rsOpstoreGoods);
        return rsOpstoreGoods;
    }

    private String checkOpstore(RsOpstoreDomain rsOpstoreDomain) {
        if (null == rsOpstoreDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsOpstoreDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOpstoreDefault(RsOpstore rsOpstore) {
        if (null == rsOpstore) {
            return;
        }
        if (null == rsOpstore.getDataState()) {
            rsOpstore.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsOpstore.getGmtCreate()) {
            rsOpstore.setGmtCreate(date);
        }
        rsOpstore.setGmtModified(date);
        if (StringUtils.isBlank((String)rsOpstore.getOpstoreCode())) {
            rsOpstore.setOpstoreCode(this.getNo(null, "RsOpstore", "rsOpstore", rsOpstore.getTenantCode()));
        }
    }

    private int getOpstoreMaxCode() {
        int code = 0;
        try {
            return this.rsOpstoreMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsOpstoreserviceImpl.getOpstoreMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOpstoreUpdataDefault(RsOpstore rsOpstore) {
        if (null == rsOpstore) {
            return;
        }
        rsOpstore.setGmtModified(this.getSysDate());
    }

    private void saveOpstoreModel(RsOpstore rsOpstore) throws ApiException {
        if (null == rsOpstore) {
            return;
        }
        try {
            this.rsOpstoreMapper.insert(rsOpstore);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOpstoreserviceImpl.saveOpstoreModel.ex", (Throwable)e);
        }
    }

    private void saveOpstoreBatchModel(List<RsOpstore> rsOpstoreList) throws ApiException {
        if (null == rsOpstoreList || rsOpstoreList.isEmpty()) {
            return;
        }
        try {
            this.rsOpstoreMapper.insertBatch(rsOpstoreList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOpstoreserviceImpl.saveOpstoreBatchModel.ex", (Throwable)e);
        }
    }

    private RsOpstore getOpstoreModelById(Integer opstoreId) {
        if (null == opstoreId) {
            return null;
        }
        try {
            return this.rsOpstoreMapper.selectByPrimaryKey(opstoreId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsOpstoreserviceImpl.getOpstoreModelById", (Throwable)e);
            return null;
        }
    }

    private RsOpstore getOpstoreModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsOpstoreMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsOpstoreserviceImpl.getOpstoreModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOpstoreModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsOpstoreMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOpstoreserviceImpl.delOpstoreModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsOpstoreserviceImpl.delOpstoreModelByCode.num");
        }
    }

    private void deleteOpstoreModel(Integer opstoreId) throws ApiException {
        if (null == opstoreId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsOpstoreMapper.deleteByPrimaryKey(opstoreId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOpstoreserviceImpl.deleteOpstoreModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsOpstoreserviceImpl.deleteOpstoreModel.num");
        }
    }

    private void updateOpstoreModel(RsOpstore rsOpstore) throws ApiException {
        if (null == rsOpstore) {
            return;
        }
        int i = 0;
        try {
            i = this.rsOpstoreMapper.updateByPrimaryKey(rsOpstore);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOpstoreserviceImpl.updateOpstoreModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsOpstoreserviceImpl.updateOpstoreModel.num");
        }
    }

    private void updateStateOpstoreModel(Integer opstoreId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == opstoreId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opstoreId", opstoreId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsOpstoreMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOpstoreserviceImpl.updateStateOpstoreModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsOpstoreserviceImpl.updateStateOpstoreModel.null");
        }
    }

    private void updateStateOpstoreModelByCode(String tenantCode, String opstoreCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)opstoreCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opstoreCode", opstoreCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsOpstoreMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOpstoreserviceImpl.updateStateOpstoreModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsOpstoreserviceImpl.updateStateOpstoreModelByCode.null");
        }
    }

    private RsOpstore makeOpstore(RsOpstoreDomain rsOpstoreDomain, RsOpstore rsOpstore) {
        if (null == rsOpstoreDomain) {
            return null;
        }
        if (null == rsOpstore) {
            rsOpstore = new RsOpstore();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsOpstore, (Object)rsOpstoreDomain);
            return rsOpstore;
        }
        catch (Exception e) {
            this.logger.error("rs.RsOpstoreserviceImpl.makeOpstore", (Throwable)e);
            return null;
        }
    }

    private RsOpstoreReDomain makeRsOpstoreReDomain(RsOpstore rsOpstore) {
        if (null == rsOpstore) {
            return null;
        }
        RsOpstoreReDomain rsOpstoreReDomain = new RsOpstoreReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsOpstoreReDomain, (Object)rsOpstore);
            return rsOpstoreReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsOpstoreserviceImpl.makeRsOpstoreReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsOpstore> queryOpstoreModelPage(Map<String, Object> parammap) {
        try {
            return this.rsOpstoreMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsOpstoreserviceImpl.queryOpstoreModel", (Throwable)e);
            return null;
        }
    }

    private int countOpstore(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsOpstoreMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsOpstoreserviceImpl.countOpstore", (Throwable)e);
        }
        return i;
    }

    private RsOpstore createRsOpstore(RsOpstoreDomain rsOpstoreDomain) {
        String msg = this.checkOpstore(rsOpstoreDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsOpstoreserviceImpl.saveOpstore.checkOpstore", msg);
        }
        RsOpstore rsOpstore = this.makeOpstore(rsOpstoreDomain, null);
        this.setOpstoreDefault(rsOpstore);
        return rsOpstore;
    }

    private String checkOpstoreSku(RsOpstoreSkuDomain rsOpstoreSkuDomain) {
        if (null == rsOpstoreSkuDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsOpstoreSkuDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOpstoreSkuDefault(RsOpstoreSku rsOpstoreSku) {
        if (null == rsOpstoreSku) {
            return;
        }
        if (null == rsOpstoreSku.getDataState()) {
            rsOpstoreSku.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsOpstoreSku.getGmtCreate()) {
            rsOpstoreSku.setGmtCreate(date);
        }
        rsOpstoreSku.setGmtModified(date);
        if (StringUtils.isBlank((String)rsOpstoreSku.getOpstoreSkuCode())) {
            rsOpstoreSku.setOpstoreSkuCode(this.getNo(null, "RsOpstoreSku", "rsOpstoreSku", rsOpstoreSku.getTenantCode()));
        }
    }

    private int getOpstoreSkuMaxCode() {
        int code = 0;
        try {
            return this.rsOpstoreSkuMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsOpstoreserviceImpl.getOpstoreSkuMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOpstoreSkuUpdataDefault(RsOpstoreSku rsOpstoreSku) {
        if (null == rsOpstoreSku) {
            return;
        }
        rsOpstoreSku.setGmtModified(this.getSysDate());
    }

    private void saveOpstoreSkuModel(RsOpstoreSku rsOpstoreSku) throws ApiException {
        if (null == rsOpstoreSku) {
            return;
        }
        try {
            this.rsOpstoreSkuMapper.insert(rsOpstoreSku);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOpstoreserviceImpl.saveOpstoreSkuModel.ex", (Throwable)e);
        }
    }

    private void saveOpstoreSkuBatchModel(List<RsOpstoreSku> rsOpstoreSkuList) throws ApiException {
        if (null == rsOpstoreSkuList || rsOpstoreSkuList.isEmpty()) {
            return;
        }
        try {
            this.rsOpstoreSkuMapper.insertBatch(rsOpstoreSkuList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOpstoreserviceImpl.saveOpstoreSkuBatchModel.ex", (Throwable)e);
        }
    }

    private RsOpstoreSku getOpstoreSkuModelById(Integer opstoreSkuId) {
        if (null == opstoreSkuId) {
            return null;
        }
        try {
            return this.rsOpstoreSkuMapper.selectByPrimaryKey(opstoreSkuId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsOpstoreserviceImpl.getOpstoreSkuModelById", (Throwable)e);
            return null;
        }
    }

    private RsOpstoreSku getOpstoreSkuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsOpstoreSkuMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsOpstoreserviceImpl.getOpstoreSkuModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOpstoreSkuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsOpstoreSkuMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOpstoreserviceImpl.delOpstoreSkuModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsOpstoreserviceImpl.delOpstoreSkuModelByCode.num");
        }
    }

    private void deleteOpstoreSkuModel(Integer opstoreSkuId) throws ApiException {
        if (null == opstoreSkuId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsOpstoreSkuMapper.deleteByPrimaryKey(opstoreSkuId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOpstoreserviceImpl.deleteOpstoreSkuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsOpstoreserviceImpl.deleteOpstoreSkuModel.num");
        }
    }

    private void updateOpstoreSkuModel(RsOpstoreSku rsOpstoreSku) throws ApiException {
        if (null == rsOpstoreSku) {
            return;
        }
        int i = 0;
        try {
            i = this.rsOpstoreSkuMapper.updateByPrimaryKey(rsOpstoreSku);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOpstoreserviceImpl.updateOpstoreSkuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsOpstoreserviceImpl.updateOpstoreSkuModel.num");
        }
    }

    private void updateStateOpstoreSkuModel(Integer opstoreSkuId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == opstoreSkuId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opstoreSkuId", opstoreSkuId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsOpstoreSkuMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOpstoreserviceImpl.updateStateOpstoreSkuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsOpstoreserviceImpl.updateStateOpstoreSkuModel.null");
        }
    }

    private void updateStateOpstoreSkuModelByCode(String tenantCode, String opstoreSkuCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)opstoreSkuCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opstoreSkuCode", opstoreSkuCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsOpstoreSkuMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsOpstoreserviceImpl.updateStateOpstoreSkuModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsOpstoreserviceImpl.updateStateOpstoreSkuModelByCode.null");
        }
    }

    private RsOpstoreSku makeOpstoreSku(RsOpstoreSkuDomain rsOpstoreSkuDomain, RsOpstoreSku rsOpstoreSku) {
        if (null == rsOpstoreSkuDomain) {
            return null;
        }
        if (null == rsOpstoreSku) {
            rsOpstoreSku = new RsOpstoreSku();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsOpstoreSku, (Object)rsOpstoreSkuDomain);
            return rsOpstoreSku;
        }
        catch (Exception e) {
            this.logger.error("rs.RsOpstoreserviceImpl.makeOpstoreSku", (Throwable)e);
            return null;
        }
    }

    private RsOpstoreSkuReDomain makeRsOpstoreSkuReDomain(RsOpstoreSku rsOpstoreSku) {
        if (null == rsOpstoreSku) {
            return null;
        }
        RsOpstoreSkuReDomain rsOpstoreSkuReDomain = new RsOpstoreSkuReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsOpstoreSkuReDomain, (Object)rsOpstoreSku);
            return rsOpstoreSkuReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsOpstoreserviceImpl.makeRsOpstoreSkuReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsOpstoreSku> queryOpstoreSkuModelPage(Map<String, Object> parammap) {
        try {
            return this.rsOpstoreSkuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsOpstoreserviceImpl.queryOpstoreSkuModel", (Throwable)e);
            return null;
        }
    }

    private int countOpstoreSku(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsOpstoreSkuMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsOpstoreserviceImpl.countOpstoreSku", (Throwable)e);
        }
        return i;
    }

    private RsOpstoreSku createRsOpstoreSku(RsOpstoreSkuDomain rsOpstoreSkuDomain) {
        String msg = this.checkOpstoreSku(rsOpstoreSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsOpstoreserviceImpl.saveOpstoreSku.checkOpstoreSku", msg);
        }
        RsOpstoreSku rsOpstoreSku = this.makeOpstoreSku(rsOpstoreSkuDomain, null);
        this.setOpstoreSkuDefault(rsOpstoreSku);
        return rsOpstoreSku;
    }

    @Override
    public String saveOpstoreGoods(RsOpstoreGoodsDomain rsOpstoreGoodsDomain) throws ApiException {
        RsOpstoreGoods rsOpstoreGoods = this.createRsOpstoreGoods(rsOpstoreGoodsDomain);
        this.saveOpstoreGoodsModel(rsOpstoreGoods);
        return rsOpstoreGoods.getOpstoreGoodsCode();
    }

    @Override
    public String saveOpstoreGoodsBatch(List<RsOpstoreGoodsDomain> rsOpstoreGoodsDomainList) throws ApiException {
        if (null == rsOpstoreGoodsDomainList || rsOpstoreGoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsOpstoreGoods> rsOpstoreGoodsList = new ArrayList<RsOpstoreGoods>();
        String code = "";
        for (RsOpstoreGoodsDomain rsOpstoreGoodsDomain : rsOpstoreGoodsDomainList) {
            RsOpstoreGoods rsOpstoreGoods = this.createRsOpstoreGoods(rsOpstoreGoodsDomain);
            code = rsOpstoreGoods.getOpstoreGoodsCode();
            rsOpstoreGoodsList.add(rsOpstoreGoods);
        }
        this.saveOpstoreGoodsBatchModel(rsOpstoreGoodsList);
        return code;
    }

    @Override
    public void updateOpstoreGoodsState(Integer opstoreGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == opstoreGoodsId) {
            return;
        }
        this.updateStateOpstoreGoodsModel(opstoreGoodsId, dataState, oldDataState, map);
    }

    @Override
    public void updateOpstoreGoodsStateByCode(String tenantCode, String opstoreGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)opstoreGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOpstoreGoodsModelByCode(tenantCode, opstoreGoodsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOpstoreGoods(RsOpstoreGoodsDomain rsOpstoreGoodsDomain) throws ApiException {
        String msg = this.checkOpstoreGoods(rsOpstoreGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsOpstoreserviceImpl.updateOpstoreGoods.checkOpstoreGoods", msg);
        }
        RsOpstoreGoods oldRsOpstoreGoods = this.getOpstoreGoodsModelById(rsOpstoreGoodsDomain.getOpstoreGoodsId());
        if (null == oldRsOpstoreGoods) {
            throw new ApiException("rs.RsOpstoreserviceImpl.updateOpstoreGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsOpstoreGoods rsOpstoreGoods = this.makeOpstoreGoods(rsOpstoreGoodsDomain, oldRsOpstoreGoods);
        this.setOpstoreGoodsUpdataDefault(rsOpstoreGoods);
        this.updateOpstoreGoodsModel(rsOpstoreGoods);
    }

    @Override
    public RsOpstoreGoods getOpstoreGoods(Integer opstoreGoodsId) {
        if (null == opstoreGoodsId) {
            return null;
        }
        return this.getOpstoreGoodsModelById(opstoreGoodsId);
    }

    @Override
    public void deleteOpstoreGoods(Integer opstoreGoodsId) throws ApiException {
        if (null == opstoreGoodsId) {
            return;
        }
        this.deleteOpstoreGoodsModel(opstoreGoodsId);
    }

    @Override
    public QueryResult<RsOpstoreGoods> queryOpstoreGoodsPage(Map<String, Object> map) {
        List<RsOpstoreGoods> rsOpstoreGoodsList = this.queryOpstoreGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOpstoreGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsOpstoreGoodsList);
        return queryResult;
    }

    @Override
    public RsOpstoreGoods getOpstoreGoodsByCode(String tenantCode, String opstoreGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)opstoreGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opstoreGoodsCode", opstoreGoodsCode);
        return this.getOpstoreGoodsModelByCode(map);
    }

    @Override
    public void deleteOpstoreGoodsByCode(String tenantCode, String opstoreGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)opstoreGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opstoreGoodsCode", opstoreGoodsCode);
        this.delOpstoreGoodsModelByCode(map);
    }

    @Override
    public String saveOpstore(RsOpstoreDomain rsOpstoreDomain) throws ApiException {
        RsOpstore rsOpstore = this.createRsOpstore(rsOpstoreDomain);
        this.saveOpstoreModel(rsOpstore);
        return rsOpstore.getOpstoreCode();
    }

    @Override
    public String saveOpstoreBatch(List<RsOpstoreDomain> rsOpstoreDomainList) throws ApiException {
        if (null == rsOpstoreDomainList || rsOpstoreDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsOpstore> rsOpstoreList = new ArrayList<RsOpstore>();
        String code = "";
        for (RsOpstoreDomain rsOpstoreDomain : rsOpstoreDomainList) {
            RsOpstore rsOpstore = this.createRsOpstore(rsOpstoreDomain);
            code = rsOpstore.getOpstoreCode();
            rsOpstoreList.add(rsOpstore);
        }
        this.saveOpstoreBatchModel(rsOpstoreList);
        return code;
    }

    @Override
    public void updateOpstoreState(Integer opstoreId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == opstoreId) {
            return;
        }
        this.updateStateOpstoreModel(opstoreId, dataState, oldDataState, map);
    }

    @Override
    public void updateOpstoreStateByCode(String tenantCode, String opstoreCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)opstoreCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOpstoreModelByCode(tenantCode, opstoreCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOpstore(RsOpstoreDomain rsOpstoreDomain) throws ApiException {
        String msg = this.checkOpstore(rsOpstoreDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsOpstoreserviceImpl.updateOpstore.checkOpstore", msg);
        }
        RsOpstore oldRsOpstore = this.getOpstoreModelById(rsOpstoreDomain.getOpstoreId());
        if (null == oldRsOpstore) {
            throw new ApiException("rs.RsOpstoreserviceImpl.updateOpstore.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsOpstore rsOpstore = this.makeOpstore(rsOpstoreDomain, oldRsOpstore);
        this.setOpstoreUpdataDefault(rsOpstore);
        this.updateOpstoreModel(rsOpstore);
    }

    @Override
    public RsOpstore getOpstore(Integer opstoreId) {
        if (null == opstoreId) {
            return null;
        }
        return this.getOpstoreModelById(opstoreId);
    }

    @Override
    public void deleteOpstore(Integer opstoreId) throws ApiException {
        if (null == opstoreId) {
            return;
        }
        this.deleteOpstoreModel(opstoreId);
    }

    @Override
    public QueryResult<RsOpstore> queryOpstorePage(Map<String, Object> map) {
        List<RsOpstore> rsOpstoreList = this.queryOpstoreModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOpstore(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsOpstoreList);
        return queryResult;
    }

    @Override
    public RsOpstore getOpstoreByCode(String tenantCode, String opstoreCode) throws ApiException {
        if (StringUtils.isBlank((String)opstoreCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opstoreCode", opstoreCode);
        return this.getOpstoreModelByCode(map);
    }

    @Override
    public void deleteOpstoreByCode(String tenantCode, String opstoreCode) throws ApiException {
        if (StringUtils.isBlank((String)opstoreCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opstoreCode", opstoreCode);
        this.delOpstoreModelByCode(map);
    }

    @Override
    public String saveOpstoreSku(RsOpstoreSkuDomain rsOpstoreSkuDomain) throws ApiException {
        RsOpstoreSku rsOpstoreSku = this.createRsOpstoreSku(rsOpstoreSkuDomain);
        this.saveOpstoreSkuModel(rsOpstoreSku);
        return rsOpstoreSku.getOpstoreSkuCode();
    }

    @Override
    public String saveOpstoreSkuBatch(List<RsOpstoreSkuDomain> rsOpstoreSkuDomainList) throws ApiException {
        if (null == rsOpstoreSkuDomainList || rsOpstoreSkuDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsOpstoreSku> rsOpstoreSkuList = new ArrayList<RsOpstoreSku>();
        String code = "";
        for (RsOpstoreSkuDomain rsOpstoreSkuDomain : rsOpstoreSkuDomainList) {
            RsOpstoreSku rsOpstoreSku = this.createRsOpstoreSku(rsOpstoreSkuDomain);
            code = rsOpstoreSku.getOpstoreSkuCode();
            rsOpstoreSkuList.add(rsOpstoreSku);
        }
        this.saveOpstoreSkuBatchModel(rsOpstoreSkuList);
        return code;
    }

    @Override
    public void updateOpstoreSkuState(Integer opstoreSkuId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == opstoreSkuId) {
            return;
        }
        this.updateStateOpstoreSkuModel(opstoreSkuId, dataState, oldDataState, map);
    }

    @Override
    public void updateOpstoreSkuStateByCode(String tenantCode, String opstoreSkuCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)opstoreSkuCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOpstoreSkuModelByCode(tenantCode, opstoreSkuCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOpstoreSku(RsOpstoreSkuDomain rsOpstoreSkuDomain) throws ApiException {
        String msg = this.checkOpstoreSku(rsOpstoreSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsOpstoreserviceImpl.updateOpstoreSku.checkOpstoreSku", msg);
        }
        RsOpstoreSku oldRsOpstoreSku = this.getOpstoreSkuModelById(rsOpstoreSkuDomain.getOpstoreSkuId());
        if (null == oldRsOpstoreSku) {
            throw new ApiException("rs.RsOpstoreserviceImpl.updateOpstoreSku.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsOpstoreSku rsOpstoreSku = this.makeOpstoreSku(rsOpstoreSkuDomain, oldRsOpstoreSku);
        this.setOpstoreSkuUpdataDefault(rsOpstoreSku);
        this.updateOpstoreSkuModel(rsOpstoreSku);
    }

    @Override
    public RsOpstoreSku getOpstoreSku(Integer opstoreSkuId) {
        if (null == opstoreSkuId) {
            return null;
        }
        return this.getOpstoreSkuModelById(opstoreSkuId);
    }

    @Override
    public void deleteOpstoreSku(Integer opstoreSkuId) throws ApiException {
        if (null == opstoreSkuId) {
            return;
        }
        this.deleteOpstoreSkuModel(opstoreSkuId);
    }

    @Override
    public QueryResult<RsOpstoreSku> queryOpstoreSkuPage(Map<String, Object> map) {
        List<RsOpstoreSku> rsOpstoreSkuList = this.queryOpstoreSkuModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOpstoreSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsOpstoreSkuList);
        return queryResult;
    }

    @Override
    public RsOpstoreSku getOpstoreSkuByCode(String tenantCode, String opstoreSkuCode) throws ApiException {
        if (StringUtils.isBlank((String)opstoreSkuCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opstoreSkuCode", opstoreSkuCode);
        return this.getOpstoreSkuModelByCode(map);
    }

    @Override
    public void deleteOpstoreSkuByCode(String tenantCode, String opstoreSkuCode) throws ApiException {
        if (StringUtils.isBlank((String)opstoreSkuCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opstoreSkuCode", opstoreSkuCode);
        this.delOpstoreSkuModelByCode(map);
    }
}

