/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.searchengine.util;

import com.yqbsoft.laser.service.searchengine.domain.StoreDomain;
import com.yqbsoft.laser.service.searchengine.index.StoreEnum;
import com.yqbsoft.laser.service.searchengine.util.ElasticConfig;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.ssl.SSLContextBuilder;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"elasticConfig"})
public class EsUtil {
    private static final SupperLogUtil logger = new SupperLogUtil(EsUtil.class);
    private static String bash_searchurl;
    private static String bash_user;
    private static String bash_pw;
    @Autowired
    private ElasticConfig elasticConfig;
    private static RestHighLevelClient highLevelClient;
    private static Object lock;

    public boolean bluk(List<StoreDomain> storeDomainList) {
        BulkRequest request = new BulkRequest();
        try {
            this.initBash();
            for (StoreDomain storeDomain : storeDomainList) {
                String tenantCode = storeDomain.getTenantCode();
                String requestType = storeDomain.getRequestType();
                String id = storeDomain.getBizId();
                if (StringUtils.isBlank((String)id)) {
                    logger.error("es.bulk.missingId", (Object)storeDomain.toString());
                    return false;
                }
                String bizType = storeDomain.getBizType();
                if (StringUtils.isBlank((String)bizType)) {
                    logger.error("es.bulk.missingBizType", (Object)storeDomain.toString());
                    return false;
                }
                String index = this.formatIndexName(tenantCode, bizType);
                String documentJson = null;
                if (storeDomain.getStoreObj() != null) {
                    documentJson = (String)storeDomain.getStoreObj();
                }
                try {
                    switch (EsUtil.fromString(requestType)) {
                        case INSERT: 
                        case SKUINSERT: 
                        case SKUADD: {
                            if (StringUtils.isBlank((String)documentJson)) {
                                logger.error("es.bulk.missingDocument", (Object)(index + "=" + id));
                                return false;
                            }
                            request.add(new IndexRequest(index).id(id).source(documentJson, XContentType.JSON));
                            logger.info("es.bulk.insert", (Object)(index + "=" + id));
                            break;
                        }
                        case ESUPDATE: 
                        case UPDATE: 
                        case EDIT: {
                            if (StringUtils.isBlank((String)documentJson)) {
                                logger.error("es.bulk.missingUpdateDocument", (Object)(index + "=" + id));
                                return false;
                            }
                            request.add(new UpdateRequest(index, id).doc(documentJson, XContentType.JSON).upsert(documentJson, XContentType.JSON));
                            logger.info("es.bulk.update", (Object)(index + "=" + id));
                            break;
                        }
                        case DELETE: 
                        case DELETEOP: 
                        case SKUDELETE: 
                        case SKUDELETEOP: 
                        case SKUDOWN: 
                        case DOWN: {
                            request.add(new DeleteRequest(index, id));
                            logger.info("es.bulk.delete", (Object)(index + "=" + id));
                            break;
                        }
                        default: {
                            logger.error("es.bulk.unsupportedRequestType", (Object)(requestType + "=" + storeDomain.getBizId()));
                            return false;
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("es.bulk.requestBuildError", (Object)("index=" + index + ", id=" + id + ", type=" + requestType), (Throwable)e);
                    return false;
                }
            }
            request.timeout(TimeValue.timeValueSeconds((long)30L));
            request.waitForActiveShards(ActiveShardCount.ALL);
            BulkResponse bulkResponse = highLevelClient.bulk(request, RequestOptions.DEFAULT);
            if (bulkResponse == null) {
                logger.error("es.bulk.nullResponse");
                return false;
            }
            boolean hasCriticalFailure = false;
            if (bulkResponse.hasFailures()) {
                for (BulkItemResponse item : bulkResponse) {
                    if (!item.isFailed()) continue;
                    BulkItemResponse.Failure failure = item.getFailure();
                    String errorType = failure.getStatus().name();
                    String opType = item.getOpType().name();
                    String id = failure.getId();
                    String index = failure.getIndex();
                    if (opType.equals("DELETE") && errorType.equals("NOT_FOUND")) {
                        logger.warn("es.bulk.ignoreDeleteNotFound", (Object)("index=" + index + ", id=" + id + ", \u6587\u6863\u4e0d\u5b58\u5728\uff0c\u5df2\u5ffd\u7565"));
                        continue;
                    }
                    logger.error("es.bulk.criticalFailure", (Object)("opType=" + opType + ", index=" + index + ", id=" + id + ", error=" + failure.getMessage()));
                    hasCriticalFailure = true;
                }
            }
            if (hasCriticalFailure) {
                logger.error("es.bulk.failedWithCriticalErrors");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.error("es.bulk.exception", (Throwable)e);
            return false;
        }
    }

    private String formatIndexName(String tenantCode, String bizType) {
        String indexName;
        if (tenantCode != null) {
            tenantCode = tenantCode.toLowerCase();
        }
        if (bizType != null) {
            bizType = bizType.toLowerCase();
        }
        if (!this.isValidIndexName(indexName = tenantCode + "-" + bizType)) {
            throw new IllegalArgumentException("Invalid index name: " + indexName);
        }
        return indexName;
    }

    private boolean isValidIndexName(String indexName) {
        if (indexName == null || indexName.isEmpty()) {
            return false;
        }
        return !indexName.contains("#") && !indexName.startsWith("-");
    }

    public static StoreEnum fromString(String text) {
        for (StoreEnum type : StoreEnum.values()) {
            if (!type.getType().equalsIgnoreCase(text)) continue;
            return type;
        }
        throw new IllegalArgumentException("No matching RequestType for: " + text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initBash() {
        if (StringUtils.isNotBlank((String)bash_searchurl)) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (StringUtils.isNotBlank((String)bash_searchurl)) {
                return;
            }
            try {
                bash_searchurl = this.elasticConfig.getUrl();
                bash_user = this.elasticConfig.getUsername();
                bash_pw = this.elasticConfig.getPassword();
                String[] split = bash_searchurl.split(",");
                HttpHost[] httpHostArray = new HttpHost[split.length];
                for (int i = 0; i < split.length; ++i) {
                    String item = split[i];
                    httpHostArray[i] = new HttpHost(item.split(":")[1].replace("//", ""), Integer.parseInt(item.split(":")[2].replace("/", "")), item.split(":")[0]);
                }
                SSLContext sslContext = null;
                try {
                    sslContext = SSLContextBuilder.create().loadTrustMaterial((chain, authType) -> true).build();
                }
                catch (Exception e) {
                    logger.error("es.initBash.e", (Throwable)e);
                }
                SSLContext finalSslContext = sslContext;
                RestClientBuilder builder = RestClient.builder((HttpHost[])httpHostArray);
                builder.setRequestConfigCallback(requestConfigBuilder -> {
                    requestConfigBuilder.setConnectTimeout(this.elasticConfig.getConnectTimeoutMillis());
                    requestConfigBuilder.setSocketTimeout(this.elasticConfig.getSocketTimeoutMillis());
                    requestConfigBuilder.setConnectionRequestTimeout(this.elasticConfig.getConnectionRequestTimeoutMillis());
                    return requestConfigBuilder;
                });
                builder.setHttpClientConfigCallback(httpClientBuilder -> {
                    httpClientBuilder.setMaxConnTotal(this.elasticConfig.getMaxConnectTotal());
                    httpClientBuilder.setMaxConnPerRoute(this.elasticConfig.getMaxConnectPerRoute());
                    BasicCredentialsProvider credentialsProvider = null;
                    if (StringUtils.isNotBlank((String)bash_pw)) {
                        credentialsProvider = new BasicCredentialsProvider();
                        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(bash_user, bash_pw));
                        httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                    }
                    httpClientBuilder.setSSLContext(finalSslContext);
                    httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                    httpClientBuilder.setKeepAliveStrategy((response, context) -> TimeUnit.MINUTES.toMillis(3L));
                    return httpClientBuilder;
                });
                highLevelClient = new RestHighLevelClient(builder);
            }
            catch (Exception e) {
                logger.error("httpUrlInsert resourceBundle.getString() Exception:", (Throwable)e);
            }
        }
    }

    public String httpUrlPoolGetByCode(String data, String type, String opcode) {
        if (StringUtils.isBlank((String)data) || StringUtils.isBlank((String)opcode)) {
            logger.error("httpUrlInsert.httpUrlPoolGetByCode.null");
            return null;
        }
        this.initBash();
        GetRequest request = new GetRequest(data + "-" + type, opcode);
        try {
            GetResponse response = highLevelClient.get(request, RequestOptions.DEFAULT);
            return response.getSourceAsString();
        }
        catch (IOException e) {
            logger.error("httpUrlInsert.httpUrlPoolGetByCode.e", (Throwable)e);
            return null;
        }
    }

    public SearchResponse queryEs(String data, String type, SearchSourceBuilder builder) {
        if (StringUtils.isBlank((String)data)) {
            logger.error("httpUrlInsert.queryEs.null");
            return null;
        }
        this.initBash();
        SearchRequest request = new SearchRequest();
        request.indices(new String[]{data + "-" + type});
        request.source(builder);
        try {
            return highLevelClient.search(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            logger.error("httpUrlInsert.queryEs.e", (Throwable)e);
            return null;
        }
    }

    static {
        lock = new Object();
    }
}

