/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ul.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.ul.dao.UlLevelRulenumMapper;
import com.yqbsoft.laser.service.ul.domain.UlLevelRulenumDomain;
import com.yqbsoft.laser.service.ul.domain.UlLevelRulenumReDomain;
import com.yqbsoft.laser.service.ul.model.UlLevelRulenum;
import com.yqbsoft.laser.service.ul.service.UlLevelRulenumService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UlLevelRulenumServiceImpl
extends BaseServiceImpl
implements UlLevelRulenumService {
    private static final String SYS_CODE = "ul.UlLevelRulenumServiceImpl";
    private UlLevelRulenumMapper ulLevelRulenumMapper;

    public void setUlLevelRulenumMapper(UlLevelRulenumMapper ulLevelRulenumMapper) {
        this.ulLevelRulenumMapper = ulLevelRulenumMapper;
    }

    private Date getSysDate() {
        try {
            return this.ulLevelRulenumMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelRulenumServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUlLevelRulenum(UlLevelRulenumDomain ulLevelRulenumDomain) {
        if (null == ulLevelRulenumDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ulLevelRulenumDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUlLevelRulenumDefault(UlLevelRulenum ulLevelRulenum) {
        if (null == ulLevelRulenum) {
            return;
        }
        if (null == ulLevelRulenum.getDataState()) {
            ulLevelRulenum.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ulLevelRulenum.getGmtCreate()) {
            ulLevelRulenum.setGmtCreate(date);
        }
        ulLevelRulenum.setGmtModified(date);
        if (StringUtils.isBlank((String)ulLevelRulenum.getLevelRulenumCode())) {
            ulLevelRulenum.setLevelRulenumCode(this.getNo(null, "UlLevelRulenum", "ulLevelRulenum", ulLevelRulenum.getTenantCode()));
        }
    }

    private int getUlLevelRulenumMaxCode() {
        int code = 0;
        try {
            return this.ulLevelRulenumMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelRulenumServiceImpl.getUlLevelRulenumMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUlLevelRulenumUpdataDefault(UlLevelRulenum ulLevelRulenum) {
        if (null == ulLevelRulenum) {
            return;
        }
        ulLevelRulenum.setGmtModified(this.getSysDate());
    }

    private void saveUlLevelRulenumModel(UlLevelRulenum ulLevelRulenum) throws ApiException {
        if (null == ulLevelRulenum) {
            return;
        }
        try {
            this.ulLevelRulenumMapper.insertSelective(ulLevelRulenum);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelRulenumServiceImpl.saveUlLevelRulenumModel.ex", (Throwable)e);
        }
    }

    private void saveUlLevelRulenumBatchModel(List<UlLevelRulenum> ulLevelRulenumList) throws ApiException {
        if (null == ulLevelRulenumList || ulLevelRulenumList.isEmpty()) {
            return;
        }
        try {
            this.ulLevelRulenumMapper.insertBatch(ulLevelRulenumList);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelRulenumServiceImpl.saveUlLevelRulenumBatchModel.ex", (Throwable)e);
        }
    }

    private UlLevelRulenum getUlLevelRulenumModelById(Integer levelRulenumId) {
        if (null == levelRulenumId) {
            return null;
        }
        try {
            return this.ulLevelRulenumMapper.selectByPrimaryKey(levelRulenumId);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelRulenumServiceImpl.getUlLevelRulenumModelById", (Throwable)e);
            return null;
        }
    }

    private UlLevelRulenum getUlLevelRulenumModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ulLevelRulenumMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelRulenumServiceImpl.getUlLevelRulenumModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUlLevelRulenumModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelRulenumMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelRulenumServiceImpl.delUlLevelRulenumModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelRulenumServiceImpl.delUlLevelRulenumModelByCode.num");
        }
    }

    private void deleteUlLevelRulenumModel(Integer levelRulenumId) throws ApiException {
        if (null == levelRulenumId) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelRulenumMapper.deleteByPrimaryKey(levelRulenumId);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelRulenumServiceImpl.deleteUlLevelRulenumModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelRulenumServiceImpl.deleteUlLevelRulenumModel.num");
        }
    }

    private void updateUlLevelRulenumModel(UlLevelRulenum ulLevelRulenum) throws ApiException {
        if (null == ulLevelRulenum) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelRulenumMapper.updateByPrimaryKey(ulLevelRulenum);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelRulenumServiceImpl.updateUlLevelRulenumModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelRulenumServiceImpl.updateUlLevelRulenumModel.num");
        }
    }

    private void updateStateUlLevelRulenumModel(Integer levelRulenumId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == levelRulenumId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("levelRulenumId", levelRulenumId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulLevelRulenumMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelRulenumServiceImpl.updateStateUlLevelRulenumModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ul.UlLevelRulenumServiceImpl.updateStateUlLevelRulenumModel.null");
        }
    }

    private void updateStateUlLevelRulenumModelByCode(String tenantCode, String levelRulenumCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)levelRulenumCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("levelRulenumCode", levelRulenumCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulLevelRulenumMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelRulenumServiceImpl.updateStateUlLevelRulenumModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ul.UlLevelRulenumServiceImpl.updateStateUlLevelRulenumModelByCode.null");
        }
    }

    private UlLevelRulenum makeUlLevelRulenum(UlLevelRulenumDomain ulLevelRulenumDomain, UlLevelRulenum ulLevelRulenum) {
        if (null == ulLevelRulenumDomain) {
            return null;
        }
        if (null == ulLevelRulenum) {
            ulLevelRulenum = new UlLevelRulenum();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelRulenum, (Object)ulLevelRulenumDomain);
            return ulLevelRulenum;
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelRulenumServiceImpl.makeUlLevelRulenum", (Throwable)e);
            return null;
        }
    }

    private UlLevelRulenumReDomain makeUlLevelRulenumReDomain(UlLevelRulenum ulLevelRulenum) {
        if (null == ulLevelRulenum) {
            return null;
        }
        UlLevelRulenumReDomain ulLevelRulenumReDomain = new UlLevelRulenumReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelRulenumReDomain, (Object)ulLevelRulenum);
            return ulLevelRulenumReDomain;
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelRulenumServiceImpl.makeUlLevelRulenumReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UlLevelRulenum> queryUlLevelRulenumModelPage(Map<String, Object> parammap) {
        try {
            return this.ulLevelRulenumMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelRulenumServiceImpl.queryUlLevelRulenumModel", (Throwable)e);
            return null;
        }
    }

    private int countUlLevelRulenum(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ulLevelRulenumMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelRulenumServiceImpl.countUlLevelRulenum", (Throwable)e);
        }
        return i;
    }

    private UlLevelRulenum createUlLevelRulenum(UlLevelRulenumDomain ulLevelRulenumDomain) {
        String msg = this.checkUlLevelRulenum(ulLevelRulenumDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ul.UlLevelRulenumServiceImpl.saveUlLevelRulenum.checkUlLevelRulenum", msg);
        }
        UlLevelRulenum ulLevelRulenum = this.makeUlLevelRulenum(ulLevelRulenumDomain, null);
        this.setUlLevelRulenumDefault(ulLevelRulenum);
        return ulLevelRulenum;
    }

    @Override
    public String saveUlLevelRulenum(UlLevelRulenumDomain ulLevelRulenumDomain) throws ApiException {
        UlLevelRulenum ulLevelRulenum = this.createUlLevelRulenum(ulLevelRulenumDomain);
        this.saveUlLevelRulenumModel(ulLevelRulenum);
        return ulLevelRulenum.getLevelRulenumCode();
    }

    @Override
    public String saveUlLevelRulenumBatch(List<UlLevelRulenumDomain> ulLevelRulenumDomainList) throws ApiException {
        if (null == ulLevelRulenumDomainList || ulLevelRulenumDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UlLevelRulenum> ulLevelRulenumList = new ArrayList<UlLevelRulenum>();
        String code = "";
        for (UlLevelRulenumDomain ulLevelRulenumDomain : ulLevelRulenumDomainList) {
            UlLevelRulenum ulLevelRulenum = this.createUlLevelRulenum(ulLevelRulenumDomain);
            code = ulLevelRulenum.getLevelRulenumCode();
            ulLevelRulenumList.add(ulLevelRulenum);
        }
        this.saveUlLevelRulenumBatchModel(ulLevelRulenumList);
        return code;
    }

    @Override
    public void updateUlLevelRulenumState(Integer levelRulenumId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == levelRulenumId) {
            return;
        }
        this.updateStateUlLevelRulenumModel(levelRulenumId, dataState, oldDataState, map);
    }

    @Override
    public void updateUlLevelRulenumStateByCode(String tenantCode, String levelRulenumCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)levelRulenumCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUlLevelRulenumModelByCode(tenantCode, levelRulenumCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUlLevelRulenum(UlLevelRulenumDomain ulLevelRulenumDomain) throws ApiException {
        String msg = this.checkUlLevelRulenum(ulLevelRulenumDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ul.UlLevelRulenumServiceImpl.updateUlLevelRulenum.checkUlLevelRulenum", msg);
        }
        UlLevelRulenum oldUlLevelRulenum = this.getUlLevelRulenumModelById(ulLevelRulenumDomain.getLevelRulenumId());
        if (null == oldUlLevelRulenum) {
            throw new ApiException("ul.UlLevelRulenumServiceImpl.updateUlLevelRulenum.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UlLevelRulenum ulLevelRulenum = this.makeUlLevelRulenum(ulLevelRulenumDomain, oldUlLevelRulenum);
        this.setUlLevelRulenumUpdataDefault(ulLevelRulenum);
        this.updateUlLevelRulenumModel(ulLevelRulenum);
    }

    @Override
    public UlLevelRulenum getUlLevelRulenum(Integer levelRulenumId) {
        if (null == levelRulenumId) {
            return null;
        }
        return this.getUlLevelRulenumModelById(levelRulenumId);
    }

    @Override
    public void deleteUlLevelRulenum(Integer levelRulenumId) throws ApiException {
        if (null == levelRulenumId) {
            return;
        }
        this.deleteUlLevelRulenumModel(levelRulenumId);
    }

    @Override
    public QueryResult<UlLevelRulenum> queryUlLevelRulenumPage(Map<String, Object> map) {
        List<UlLevelRulenum> ulLevelRulenumList = this.queryUlLevelRulenumModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUlLevelRulenum(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ulLevelRulenumList);
        return queryResult;
    }

    @Override
    public UlLevelRulenum getUlLevelRulenumByCode(String tenantCode, String levelRulenumCode) throws ApiException {
        if (StringUtils.isBlank((String)levelRulenumCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("levelRulenumCode", levelRulenumCode);
        return this.getUlLevelRulenumModelByCode(map);
    }

    @Override
    public void deleteUlLevelRulenumByCode(String tenantCode, String levelRulenumCode) throws ApiException {
        if (StringUtils.isBlank((String)levelRulenumCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("levelRulenumCode", levelRulenumCode);
        this.delUlLevelRulenumModelByCode(map);
    }
}

