/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ul.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.ul.dao.UlLevelRuleMapper;
import com.yqbsoft.laser.service.ul.domain.UlLevelRuleDomain;
import com.yqbsoft.laser.service.ul.domain.UlLevelRuleReDomain;
import com.yqbsoft.laser.service.ul.model.UlLevel;
import com.yqbsoft.laser.service.ul.model.UlLevelRule;
import com.yqbsoft.laser.service.ul.service.UlLevelRuleService;
import com.yqbsoft.laser.service.ul.service.UlLevelService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class UlLevelRuleServiceImpl
extends BaseServiceImpl
implements UlLevelRuleService {
    private static final String SYS_CODE = "ul.UlLevelRuleServiceImpl";
    private UlLevelRuleMapper ulLevelRuleMapper;
    private UlLevelService ulLevelService;
    private String cachekey = "UlLevelRule-api";

    public void setUlLevelService(UlLevelService ulLevelService) {
        this.ulLevelService = ulLevelService;
    }

    public void setUlLevelRuleMapper(UlLevelRuleMapper ulLevelRuleMapper) {
        this.ulLevelRuleMapper = ulLevelRuleMapper;
    }

    private Date getSysDate() {
        try {
            return this.ulLevelRuleMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelRuleServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUlLevelRule(UlLevelRuleDomain ulLevelRuleDomain) {
        if (null == ulLevelRuleDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ulLevelRuleDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUlLevelRuleDefault(UlLevelRule ulLevelRule) {
        if (null == ulLevelRule) {
            return;
        }
        if (null == ulLevelRule.getDataState()) {
            ulLevelRule.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ulLevelRule.getGmtCreate()) {
            ulLevelRule.setGmtCreate(date);
        }
        ulLevelRule.setGmtModified(date);
        if (StringUtils.isBlank((String)ulLevelRule.getLevelRuleCode())) {
            ulLevelRule.setLevelRuleCode(this.getNo(null, "UlLevelRule", "ulLevelRule", ulLevelRule.getTenantCode()));
        }
    }

    private int getUlLevelRuleMaxCode() {
        int code = 0;
        try {
            return this.ulLevelRuleMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelRuleServiceImpl.getUlLevelRuleMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUlLevelRuleUpdataDefault(UlLevelRule ulLevelRule) {
        if (null == ulLevelRule) {
            return;
        }
        ulLevelRule.setGmtModified(this.getSysDate());
    }

    private void saveUlLevelRuleModel(UlLevelRule ulLevelRule) throws ApiException {
        if (null == ulLevelRule) {
            return;
        }
        try {
            this.ulLevelRuleMapper.insert(ulLevelRule);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelRuleServiceImpl.saveUlLevelRuleModel.ex", (Throwable)e);
        }
    }

    private void saveUlLevelRuleBatchModel(List<UlLevelRule> ulLevelRuleList) throws ApiException {
        if (null == ulLevelRuleList || ulLevelRuleList.isEmpty()) {
            return;
        }
        try {
            this.ulLevelRuleMapper.insertBatch(ulLevelRuleList);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelRuleServiceImpl.saveUlLevelRuleBatchModel.ex", (Throwable)e);
        }
    }

    private UlLevelRule getUlLevelRuleModelById(Integer levelRuleId) {
        if (null == levelRuleId) {
            return null;
        }
        try {
            return this.ulLevelRuleMapper.selectByPrimaryKey(levelRuleId);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelRuleServiceImpl.getUlLevelRuleModelById", (Throwable)e);
            return null;
        }
    }

    private UlLevelRule getUlLevelRuleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ulLevelRuleMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelRuleServiceImpl.getUlLevelRuleModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUlLevelRuleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelRuleMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelRuleServiceImpl.delUlLevelRuleModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelRuleServiceImpl.delUlLevelRuleModelByCode.num");
        }
    }

    private void deleteUlLevelRuleModel(Integer levelRuleId) throws ApiException {
        if (null == levelRuleId) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelRuleMapper.deleteByPrimaryKey(levelRuleId);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelRuleServiceImpl.deleteUlLevelRuleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelRuleServiceImpl.deleteUlLevelRuleModel.num");
        }
    }

    private void updateUlLevelRuleModel(UlLevelRule ulLevelRule) throws ApiException {
        if (null == ulLevelRule) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelRuleMapper.updateByPrimaryKey(ulLevelRule);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelRuleServiceImpl.updateUlLevelRuleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelRuleServiceImpl.updateUlLevelRuleModel.num");
        }
    }

    private void updateStateUlLevelRuleModel(Integer levelRuleId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == levelRuleId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("levelRuleId", levelRuleId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulLevelRuleMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelRuleServiceImpl.updateStateUlLevelRuleModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ul.UlLevelRuleServiceImpl.updateStateUlLevelRuleModel.null");
        }
    }

    private void updateStateUlLevelRuleModelByCode(String tenantCode, String levelRuleCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)levelRuleCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("levelRuleCode", levelRuleCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulLevelRuleMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelRuleServiceImpl.updateStateUlLevelRuleModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ul.UlLevelRuleServiceImpl.updateStateUlLevelRuleModelByCode.null");
        }
    }

    private UlLevelRule makeUlLevelRule(UlLevelRuleDomain ulLevelRuleDomain, UlLevelRule ulLevelRule) {
        if (null == ulLevelRuleDomain) {
            return null;
        }
        if (null == ulLevelRule) {
            ulLevelRule = new UlLevelRule();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)ulLevelRule, (Object)ulLevelRuleDomain);
            return ulLevelRule;
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelRuleServiceImpl.makeUlLevelRule", (Throwable)e);
            return null;
        }
    }

    private UlLevelRuleReDomain makeUlLevelRuleReDomain(UlLevelRule ulLevelRule) {
        if (null == ulLevelRule) {
            return null;
        }
        UlLevelRuleReDomain ulLevelRuleReDomain = new UlLevelRuleReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelRuleReDomain, (Object)ulLevelRule);
            return ulLevelRuleReDomain;
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelRuleServiceImpl.makeUlLevelRuleReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UlLevelRule> queryUlLevelRuleModelPage(Map<String, Object> parammap) {
        try {
            return this.ulLevelRuleMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelRuleServiceImpl.queryUlLevelRuleModel", (Throwable)e);
            return null;
        }
    }

    private int countUlLevelRule(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ulLevelRuleMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelRuleServiceImpl.countUlLevelRule", (Throwable)e);
        }
        return i;
    }

    private UlLevelRule createUlLevelRule(UlLevelRuleDomain ulLevelRuleDomain) {
        String msg = this.checkUlLevelRule(ulLevelRuleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ul.UlLevelRuleServiceImpl.saveUlLevelRule.checkUlLevelRule", msg);
        }
        UlLevelRule ulLevelRule = this.makeUlLevelRule(ulLevelRuleDomain, null);
        this.setUlLevelRuleDefault(ulLevelRule);
        return ulLevelRule;
    }

    @Override
    public String saveUlLevelRule(UlLevelRuleDomain ulLevelRuleDomain) throws ApiException {
        UlLevelRule ulLevelRule = this.createUlLevelRule(ulLevelRuleDomain);
        this.saveUlLevelRuleModel(ulLevelRule);
        return ulLevelRule.getLevelRuleCode();
    }

    @Override
    public String saveUlLevelRuleBatch(List<UlLevelRuleDomain> ulLevelRuleDomainList) throws ApiException {
        if (null == ulLevelRuleDomainList || ulLevelRuleDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UlLevelRule> ulLevelRuleList = new ArrayList<UlLevelRule>();
        String code = "";
        for (UlLevelRuleDomain ulLevelRuleDomain : ulLevelRuleDomainList) {
            UlLevelRule ulLevelRule = this.createUlLevelRule(ulLevelRuleDomain);
            code = ulLevelRule.getLevelRuleCode();
            ulLevelRuleList.add(ulLevelRule);
        }
        this.saveUlLevelRuleBatchModel(ulLevelRuleList);
        return code;
    }

    @Override
    public void updateUlLevelRuleState(Integer levelRuleId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == levelRuleId) {
            return;
        }
        this.updateStateUlLevelRuleModel(levelRuleId, dataState, oldDataState, map);
        this.updateUlLevelRuleDisById(dataState, levelRuleId);
    }

    public void updateUlLevelRuleDisById(Integer dataState, Integer levelRuleId) {
        UlLevelRule ulLevelRule = this.getUlLevelRule(levelRuleId);
        if (null == ulLevelRule) {
            return;
        }
        String key = ulLevelRule.getLevelCode() + "-" + ulLevelRule.getLevelRuleApi() + "-" + ulLevelRule.getTenantCode() + "-" + ulLevelRule.getMemberMcode();
        if (1 == dataState) {
            DisUtil.setMapVer((String)this.cachekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson((Object)ulLevelRule));
        } else if (0 == dataState) {
            DisUtil.delMap((String)this.cachekey, (String[])new String[]{key, JsonUtil.buildNormalBinder().toJson((Object)ulLevelRule)});
        }
    }

    public void updateUlLevelRuleDisByCode(Integer dataState, String tenantCode, String levelRuleCode) {
        UlLevelRule ulLevelRule = this.getUlLevelRuleByCode(tenantCode, levelRuleCode);
        if (null == ulLevelRule) {
            return;
        }
        String key = ulLevelRule.getLevelCode() + "-" + ulLevelRule.getLevelRuleApi() + "-" + ulLevelRule.getTenantCode() + "-" + ulLevelRule.getMemberMcode();
        if (1 == dataState) {
            DisUtil.setMapVer((String)this.cachekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson((Object)ulLevelRule));
        } else if (0 == dataState) {
            DisUtil.delMap((String)this.cachekey, (String[])new String[]{key, JsonUtil.buildNormalBinder().toJson((Object)ulLevelRule)});
        }
    }

    @Override
    public void updateUlLevelRuleStateByCode(String tenantCode, String levelRuleCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)levelRuleCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUlLevelRuleModelByCode(tenantCode, levelRuleCode, dataState, oldDataState, map);
        this.updateUlLevelRuleDisByCode(dataState, tenantCode, levelRuleCode);
    }

    @Override
    public void updateUlLevelRule(UlLevelRuleDomain ulLevelRuleDomain) throws ApiException {
        String msg = this.checkUlLevelRule(ulLevelRuleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ul.UlLevelRuleServiceImpl.updateUlLevelRule.checkUlLevelRule", msg);
        }
        UlLevelRule oldUlLevelRule = this.getUlLevelRuleModelById(ulLevelRuleDomain.getLevelRuleId());
        if (null == oldUlLevelRule) {
            throw new ApiException("ul.UlLevelRuleServiceImpl.updateUlLevelRule.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UlLevelRule ulLevelRule = this.makeUlLevelRule(ulLevelRuleDomain, oldUlLevelRule);
        this.setUlLevelRuleUpdataDefault(ulLevelRule);
        UlLevel ulLevel = this.ulLevelService.getUlLevelByCode(ulLevelRule.getTenantCode(), ulLevelRule.getLevelCode());
        if (ulLevel == null) {
            throw new ApiException("ul.UlLevelRuleServiceImpl.updateUlLevelRule.null", "\u7b49\u7ea7\u4e0d\u5b58\u5728");
        }
        ulLevelRule.setMemberCode(ulLevelRule.getMemberCode());
        ulLevelRule.setMemberName(ulLevelRule.getMemberName());
        ulLevelRule.setMemberMcode(ulLevelRule.getMemberMcode());
        ulLevelRule.setMemberMcode(ulLevelRule.getMemberMname());
        this.updateUlLevelRuleModel(ulLevelRule);
        this.updateUlLevelRuleDisById(ulLevelRule.getDataState(), ulLevelRule.getLevelRuleId());
    }

    @Override
    public UlLevelRule getUlLevelRule(Integer levelRuleId) {
        if (null == levelRuleId) {
            return null;
        }
        return this.getUlLevelRuleModelById(levelRuleId);
    }

    @Override
    public void deleteUlLevelRule(Integer levelRuleId) throws ApiException {
        if (null == levelRuleId) {
            return;
        }
        this.updateUlLevelRuleDisById(0, levelRuleId);
        this.deleteUlLevelRuleModel(levelRuleId);
    }

    @Override
    public QueryResult<UlLevelRule> queryUlLevelRulePage(Map<String, Object> map) {
        List<UlLevelRule> ulLevelRuleList = this.queryUlLevelRuleModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUlLevelRule(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ulLevelRuleList);
        return queryResult;
    }

    @Override
    public UlLevelRule getUlLevelRuleByCode(String tenantCode, String levelRuleCode) throws ApiException {
        if (StringUtils.isBlank((String)levelRuleCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("levelRuleCode", levelRuleCode);
        return this.getUlLevelRuleModelByCode(map);
    }

    @Override
    public void deleteUlLevelRuleByCode(String tenantCode, String levelRuleCode) throws ApiException {
        if (StringUtils.isBlank((String)levelRuleCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("levelRuleCode", levelRuleCode);
        this.updateUlLevelRuleDisByCode(0, tenantCode, levelRuleCode);
        this.delUlLevelRuleModelByCode(map);
    }

    @Override
    public void queryulLevelRuleCache() {
        this.logger.info("UlLevelRuleServiceImpl.queryulLevelRuleCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 1);
        List<UlLevelRule> list = this.queryUlLevelRuleModelPage(parammap);
        if (null == list || list.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("UlLevelRuleServiceImpl.queryulLevelRuleCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        for (UlLevelRule ulLevelRule : list) {
            if (!StringUtils.isNotBlank((String)ulLevelRule.getLevelCode())) continue;
            String key = ulLevelRule.getLevelCode() + "-" + ulLevelRule.getLevelRuleApi() + "-" + ulLevelRule.getTenantCode() + "-" + ulLevelRule.getMemberMcode();
            map.put(key, JsonUtil.buildNormalBinder().toJson((Object)ulLevelRule));
        }
        DisUtil.setMapVer((String)this.cachekey, map);
        this.logger.info("UlLevelRuleServiceImpl.queryulLevelRuleCache", (Object)"===========add-end==========");
    }
}

