/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.dao.UmFootprintMapper;
import com.yqbsoft.laser.service.user.domain.UmFootprintDomain;
import com.yqbsoft.laser.service.user.domain.UmFootprintReDomain;
import com.yqbsoft.laser.service.user.model.UmFootprint;
import com.yqbsoft.laser.service.user.service.UmFootprintService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UmFootprintServiceImpl
extends BaseServiceImpl
implements UmFootprintService {
    private static final String SYS_CODE = "um.USER.UmFootprintServiceImpl";
    private UmFootprintMapper umFootprintMapper;

    public void setUmFootprintMapper(UmFootprintMapper umFootprintMapper) {
        this.umFootprintMapper = umFootprintMapper;
    }

    private Date getSysDate() {
        try {
            return this.umFootprintMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmFootprintServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkFootprint(UmFootprintDomain umFootprintDomain) {
        if (null == umFootprintDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)umFootprintDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setFootprintDefault(UmFootprint umFootprint) {
        if (null == umFootprint) {
            return;
        }
        if (null == umFootprint.getDataState()) {
            umFootprint.setDataState(0);
        }
        if (null == umFootprint.getGmtCreate()) {
            umFootprint.setGmtCreate(this.getSysDate());
        }
        umFootprint.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)umFootprint.getFootprintCode())) {
            umFootprint.setFootprintCode(this.createUUIDString());
        }
    }

    private int getFootprintMaxCode() {
        int code = 0;
        try {
            return this.umFootprintMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmFootprintServiceImpl.getFootprintMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFootprintUpdataDefault(UmFootprint umFootprint) {
        if (null == umFootprint) {
            return;
        }
        Date date = this.getSysDate();
        umFootprint.setGmtModified(date);
        umFootprint.setGmtCreate(date);
    }

    private void saveFootprintModel(UmFootprint umFootprint) throws ApiException {
        if (null == umFootprint) {
            return;
        }
        try {
            this.umFootprintMapper.insert(umFootprint);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmFootprintServiceImpl.saveFootprintModel.ex", (Throwable)e);
        }
    }

    private void saveFootprintBatchModel(List<UmFootprint> umFootprintList) throws ApiException {
        if (null == umFootprintList || umFootprintList.isEmpty()) {
            return;
        }
        try {
            this.umFootprintMapper.insertBatch(umFootprintList);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmFootprintServiceImpl.saveFootprintBatchModel.ex", (Throwable)e);
        }
    }

    private UmFootprint getFootprintModelById(Integer footprintId) {
        if (null == footprintId) {
            return null;
        }
        try {
            return this.umFootprintMapper.selectByPrimaryKey(footprintId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmFootprintServiceImpl.getFootprintModelById", (Throwable)e);
            return null;
        }
    }

    private UmFootprint getFootprintModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umFootprintMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmFootprintServiceImpl.getFootprintModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delFootprintModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umFootprintMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmFootprintServiceImpl.delFootprintModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmFootprintServiceImpl.delFootprintModelByCode.num");
        }
    }

    private void deleteFootprintByUserinfoCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umFootprintMapper.delByUserinfoCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmFootprintServiceImpl.deleteFootprintByUserinfoCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmFootprintServiceImpl.deleteFootprintByUserinfoCode.num");
        }
    }

    private void deleteFootprintModel(Integer footprintId) throws ApiException {
        if (null == footprintId) {
            return;
        }
        int i = 0;
        try {
            i = this.umFootprintMapper.deleteByPrimaryKey(footprintId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmFootprintServiceImpl.deleteFootprintModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmFootprintServiceImpl.deleteFootprintModel.num");
        }
    }

    private void updateFootprintModel(UmFootprint umFootprint) throws ApiException {
        if (null == umFootprint) {
            return;
        }
        int i = 0;
        try {
            i = this.umFootprintMapper.updateByPrimaryKeySelective(umFootprint);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmFootprintServiceImpl.updateFootprintModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmFootprintServiceImpl.updateFootprintModel.num");
        }
    }

    private void updateStateFootprintModel(Integer footprintId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == footprintId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("footprintId", footprintId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.umFootprintMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmFootprintServiceImpl.updateStateFootprintModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmFootprintServiceImpl.updateStateFootprintModel.null");
        }
    }

    private void updateStateFootprintModelByCode(String tenantCode, String footprintCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)footprintCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("footprintCode", footprintCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.umFootprintMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmFootprintServiceImpl.updateStateFootprintModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmFootprintServiceImpl.updateStateFootprintModelByCode.null");
        }
    }

    private UmFootprint makeFootprint(UmFootprintDomain umFootprintDomain, UmFootprint umFootprint) {
        if (null == umFootprintDomain) {
            return null;
        }
        if (null == umFootprint) {
            umFootprint = new UmFootprint();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umFootprint, (Object)umFootprintDomain);
            return umFootprint;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmFootprintServiceImpl.makeFootprint", (Throwable)e);
            return null;
        }
    }

    private UmFootprintReDomain makeUmFootprintReDomain(UmFootprint umFootprint) {
        if (null == umFootprint) {
            return null;
        }
        UmFootprintReDomain umFootprintReDomain = new UmFootprintReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)umFootprintReDomain, (Object)umFootprint);
            return umFootprintReDomain;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmFootprintServiceImpl.makeUmFootprintReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UmFootprint> queryFootprintModelPage(Map<String, Object> parammap) {
        try {
            return this.umFootprintMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmFootprintServiceImpl.queryFootprintModel", (Throwable)e);
            return null;
        }
    }

    private int countFootprint(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umFootprintMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmFootprintServiceImpl.countFootprint", (Throwable)e);
        }
        return i;
    }

    private UmFootprint createUmFootprint(UmFootprintDomain umFootprintDomain) {
        String msg = this.checkFootprint(umFootprintDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmFootprintServiceImpl.saveFootprint.checkFootprint", msg);
        }
        UmFootprint umFootprint = this.makeFootprint(umFootprintDomain, null);
        this.setFootprintDefault(umFootprint);
        return umFootprint;
    }

    @Override
    public String saveFootprint(UmFootprintDomain umFootprintDomain) throws ApiException {
        UmFootprint umFootprint = this.createUmFootprint(umFootprintDomain);
        this.saveFootprintModel(umFootprint);
        return umFootprint.getFootprintCode();
    }

    @Override
    public String saveFootprintBatch(List<UmFootprintDomain> umFootprintDomainList) throws ApiException {
        if (null == umFootprintDomainList || umFootprintDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UmFootprint> umFootprintList = new ArrayList<UmFootprint>();
        String code = "";
        for (UmFootprintDomain umFootprintDomain : umFootprintDomainList) {
            UmFootprint umFootprint = this.createUmFootprint(umFootprintDomain);
            code = umFootprint.getFootprintCode();
            umFootprintList.add(umFootprint);
        }
        this.saveFootprintBatchModel(umFootprintList);
        return code;
    }

    @Override
    public void updateFootprintState(Integer footprintId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFootprintModel(footprintId, dataState, oldDataState);
    }

    @Override
    public void updateFootprintStateByCode(String tenantCode, String footprintCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFootprintModelByCode(tenantCode, footprintCode, dataState, oldDataState);
    }

    @Override
    public void updateFootprint(UmFootprintDomain umFootprintDomain) throws ApiException {
        String msg = this.checkFootprint(umFootprintDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmFootprintServiceImpl.updateFootprint.checkFootprint", msg);
        }
        UmFootprint oldUmFootprint = this.getFootprintModelById(umFootprintDomain.getFootprintId());
        if (null == oldUmFootprint) {
            throw new ApiException("um.USER.UmFootprintServiceImpl.updateFootprint.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmFootprint umFootprint = this.makeFootprint(umFootprintDomain, oldUmFootprint);
        this.setFootprintUpdataDefault(umFootprint);
        this.updateFootprintModel(umFootprint);
    }

    @Override
    public UmFootprint getFootprint(Integer footprintId) {
        return this.getFootprintModelById(footprintId);
    }

    @Override
    public void deleteFootprint(Integer footprintId) throws ApiException {
        this.deleteFootprintModel(footprintId);
    }

    @Override
    public QueryResult<UmFootprint> queryFootprintPage(Map<String, Object> map) {
        List<UmFootprint> umFootprintList = this.queryFootprintModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFootprint(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umFootprintList);
        return queryResult;
    }

    @Override
    public UmFootprint getFootprintByCode(String tenantCode, String footprintCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("footprintCode", footprintCode);
        return this.getFootprintModelByCode(map);
    }

    @Override
    public void deleteFootprintByCode(String tenantCode, String footprintCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("footprintCode", footprintCode);
        this.delFootprintModelByCode(map);
    }

    @Override
    public void deleteFootprintByUserinfoCode(String tenantCode, String userinfoCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userinfoCode", userinfoCode);
        this.deleteFootprintByUserinfoCode(map);
    }

    @Override
    public void updateFootprintByOpCode(Map<String, Object> map) throws ApiException {
        String msg = this.checkFootprintByMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmFootprintServiceImpl.updateFootprintByOpCode.checkFootprintByMap", msg);
        }
        Map<String, Object> paramMap = this.makeMap(map);
        this.updateFootprintByOpCodeModel(paramMap);
    }

    private Map<String, Object> makeMap(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("footprintOpcode", map.get("skuCode"));
        paramMap.put("tenantCode", map.get("tenantCode"));
        paramMap.put("dataState", map.get("dataState"));
        paramMap.put("footprintOpnum", map.get("pricesetNprice"));
        paramMap.put("footprintOppic", map.get("dataPic"));
        paramMap.put("footprintOpcont", map.get("goodsName"));
        return paramMap;
    }

    private String checkFootprintByMap(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)String.valueOf(map.get("tenantCode")))) {
            msg = msg + "tenantCode is null";
        }
        if (StringUtils.isBlank((String)String.valueOf(map.get("footprintOpcode")))) {
            msg = msg + "footprintOpcode is null";
        }
        if (StringUtils.isBlank((String)String.valueOf(map.get("footprintOpnum")))) {
            msg = msg + "footprintOpnum is null";
        }
        return msg;
    }

    private void updateFootprintByOpCodeModel(Map<String, Object> map) throws ApiException {
        if (null == map) {
            return;
        }
        try {
            this.umFootprintMapper.updateByOpCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmFootprintServiceImpl.updateFootprintByOpCodeModel.ex", (Throwable)e);
        }
    }
}

