/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.dao.UmUserattrMapper;
import com.yqbsoft.laser.service.user.domain.UmUserattrDomainBean;
import com.yqbsoft.laser.service.user.model.UmUserattr;
import com.yqbsoft.laser.service.user.service.UserattrService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserattrServiceImpl
extends BaseServiceImpl
implements UserattrService {
    public static final String SYS_CODE = "um.USER.UserattrServiceImpl";
    private UmUserattrMapper umUserattrMapper;

    public void setUmUserattrMapper(UmUserattrMapper umUserattrMapper) {
        this.umUserattrMapper = umUserattrMapper;
    }

    private Date getSysDate() {
        try {
            return this.umUserattrMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserattrServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUserattr(UmUserattrDomainBean umUserattrDomainBean) {
        if (null == umUserattrDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setUserattrDefault(UmUserattr umUserattr) {
        if (null == umUserattr) {
            return;
        }
        if (null == umUserattr.getDataState()) {
            umUserattr.setDataState(0);
        }
        if (null == umUserattr.getGmtCreate()) {
            umUserattr.setGmtCreate(this.getSysDate());
        }
        umUserattr.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)umUserattr.getUserattrCode())) {
            int code = this.getMaxCode();
            umUserattr.setUserattrCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.umUserattrMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserattrServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUserattrUpdataDefault(UmUserattr umUserattr) {
        if (null == umUserattr) {
            return;
        }
        umUserattr.setGmtModified(this.getSysDate());
    }

    private void saveUserattrModel(UmUserattr umUserattr) throws ApiException {
        if (null == umUserattr) {
            return;
        }
        try {
            this.umUserattrMapper.insert(umUserattr);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserattrServiceImpl.saveFtpserverModel.ex");
        }
    }

    private UmUserattr getUserattrModelById(Integer userattrId) {
        if (null == userattrId) {
            return null;
        }
        try {
            return this.umUserattrMapper.selectByPrimaryKey(userattrId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserattrServiceImpl.getUserattrModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteUserattrModel(Integer userattrId) throws ApiException {
        if (null == userattrId) {
            return;
        }
        int i = 0;
        try {
            i = this.umUserattrMapper.deleteByPrimaryKey(userattrId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserattrServiceImpl.deleteUserattrModel.ex");
        }
        if (1 != i) {
            throw new ApiException("um.USER.UserattrServiceImpl.deleteUserattrModel.num");
        }
    }

    private void updateUserattrModel(UmUserattr umUserattr) throws ApiException {
        if (null == umUserattr) {
            return;
        }
        try {
            this.umUserattrMapper.updateByPrimaryKeySelective(umUserattr);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserattrServiceImpl.updateUserattrModel.ex");
        }
    }

    private void updateStateUserattrModel(Integer userattrId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == userattrId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userattrId", userattrId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.umUserattrMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserattrServiceImpl.updateStateUserattrModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserattrServiceImpl.updateStateUserattrModel.null");
        }
    }

    private UmUserattr makeUserattr(UmUserattrDomainBean umUserattrDomainBean, UmUserattr umUserattr) {
        if (null == umUserattrDomainBean) {
            return null;
        }
        if (null == umUserattr) {
            umUserattr = new UmUserattr();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)umUserattr, (Object)umUserattrDomainBean);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserattrServiceImpl.makeUserattr", (Throwable)e);
        }
        return umUserattr;
    }

    private List<UmUserattr> queryUserattrModelPage(Map<String, Object> parammap) {
        try {
            return this.umUserattrMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserattrServiceImpl.queryUserattrModel", (Throwable)e);
            return null;
        }
    }

    private int countUserattr(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umUserattrMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserattrServiceImpl.countUserattr", (Throwable)e);
        }
        return i;
    }

    @Override
    public UmUserattr saveUserattr(UmUserattrDomainBean umUserattrDomainBean) throws ApiException {
        String msg = this.checkUserattr(umUserattrDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UserattrServiceImpl.saveUserattr.checkUserattr", msg);
        }
        UmUserattr umUserattr = this.makeUserattr(umUserattrDomainBean, null);
        this.setUserattrDefault(umUserattr);
        this.saveUserattrModel(umUserattr);
        return umUserattr;
    }

    @Override
    public void updateUserattrState(Integer userattrId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateUserattrModel(userattrId, dataState, oldDataState);
    }

    @Override
    public void updateUserattr(UmUserattrDomainBean umUserattrDomainBean) throws ApiException {
        String msg = this.checkUserattr(umUserattrDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UserattrServiceImpl.updateUserattr.checkUserattr", msg);
        }
        UmUserattr oldUmUserattr = null;
        if (umUserattrDomainBean.getUserattrId() != null) {
            oldUmUserattr = this.getUserattrModelById(umUserattrDomainBean.getUserattrId());
        } else if (StringUtils.isNotBlank((String)umUserattrDomainBean.getUserattrCode())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("userattrCode", umUserattrDomainBean.getUserattrCode());
            map.put("tenantCode", umUserattrDomainBean.getTenantCode());
            oldUmUserattr = this.getUserattrModelByCode(map);
        }
        if (null == oldUmUserattr) {
            throw new ApiException("um.USER.UserattrServiceImpl.updateUserattr.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmUserattr umUserattr = this.makeUserattr(umUserattrDomainBean, oldUmUserattr);
        this.setUserattrUpdataDefault(umUserattr);
        this.updateUserattrModel(umUserattr);
    }

    public UmUserattr getUserattrModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            UmUserattr mmMberextend = this.umUserattrMapper.getByCode(map);
            return mmMberextend;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserattrServiceImpl.getUserattrModelByCode", (Throwable)e);
            return null;
        }
    }

    @Override
    public UmUserattr getUserattr(Integer userattrId) {
        return this.getUserattrModelById(userattrId);
    }

    @Override
    public UmUserattr getUserattrByUnique(UmUserattr umUserattrSearch) {
        if (umUserattrSearch == null) {
            this.logger.warn("IllegalAgrement", (Object)"query params can`t be null");
            return null;
        }
        try {
            return this.umUserattrMapper.selectByUnique(umUserattrSearch);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserattrServiceImpl.getUserattrByUnique", (Throwable)e);
            return null;
        }
    }

    @Override
    public void deleteUserattr(Integer userattrId) throws ApiException {
        this.deleteUserattrModel(userattrId);
    }

    @Override
    public QueryResult<UmUserattr> queryUserattrPage(Map<String, Object> map) {
        List<UmUserattr> umUserattrList = this.queryUserattrModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUserattr(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umUserattrList);
        return queryResult;
    }

    @Override
    public List<UmUserattr> queryUserattrList(Map<String, Object> map) {
        List<UmUserattr> umUserattrList = this.queryUserattrModelPage(map);
        return umUserattrList;
    }

    @Override
    public void saveUserattrList(List<UmUserattrDomainBean> umUserattrDomainBeanList) throws ApiException {
        if (umUserattrDomainBeanList == null || umUserattrDomainBeanList.isEmpty()) {
            return;
        }
        for (UmUserattrDomainBean umUserattrDomainBean : umUserattrDomainBeanList) {
            this.saveUserattr(umUserattrDomainBean);
        }
    }

    public void invalidateUserattrModel(Map<String, Object> map) throws ApiException {
        try {
            this.umUserattrMapper.invalidateUserattr(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserattrServiceImpl.queryOverdueModel", (Throwable)e);
        }
    }

    public List<UmUserattr> queryOverdueModel(Map<String, Object> parameters) throws ApiException {
        try {
            return this.umUserattrMapper.queryOverdue(parameters);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserattrServiceImpl.queryOverdueModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<UmUserattr> updateInvalidateUserattr(Map<String, Object> parameters) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataState", 0);
        map.put("oldDataState", 1);
        this.invalidateUserattrModel(map);
        List<UmUserattr> umUserattrList = this.queryOverdueModel(parameters);
        return umUserattrList;
    }

    @Override
    public void automaticConfirmation() {
        this.logger.info("automaticConfirmation \u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u6267\u884c");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("dataState", 0);
        paramMap.put("userattrType", 10086);
        paramMap.put("userPattrendDate", "true");
        List<UmUserattr> userattrList = this.umUserattrMapper.query(paramMap);
        if (null != userattrList && userattrList.size() != 0) {
            this.logger.info("automaticConfirmation.data \u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u4e2d " + JsonUtil.buildNormalBinder().toJson(userattrList));
            for (UmUserattr userattr : userattrList) {
                UmUserattr updata = new UmUserattr();
                updata.setUserattrId(userattr.getUserattrId());
                updata.setDataState(1);
                updata.setUserattrRemark("\u81ea\u52a8\u786e\u8ba4");
                updata.setUserattrEdate(new Date());
                this.umUserattrMapper.updateByPrimaryKeySelective(updata);
            }
        }
        this.logger.info("automaticConfirmation \u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f");
    }
}

