/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.dao.UmGroupListMapper;
import com.yqbsoft.laser.service.user.dao.UmGroupMapper;
import com.yqbsoft.laser.service.user.dao.UmGroupMemMapper;
import com.yqbsoft.laser.service.user.domain.UmGroupDomain;
import com.yqbsoft.laser.service.user.domain.UmGroupListDomain;
import com.yqbsoft.laser.service.user.domain.UmGroupListReDomain;
import com.yqbsoft.laser.service.user.domain.UmGroupMemDomain;
import com.yqbsoft.laser.service.user.domain.UmGroupMemReDomain;
import com.yqbsoft.laser.service.user.domain.UmGroupReDomain;
import com.yqbsoft.laser.service.user.domain.UmUsersendDomain;
import com.yqbsoft.laser.service.user.es.EsEnginePutThread;
import com.yqbsoft.laser.service.user.model.UmGroup;
import com.yqbsoft.laser.service.user.model.UmGroupList;
import com.yqbsoft.laser.service.user.model.UmGroupMem;
import com.yqbsoft.laser.service.user.model.UmUsersend;
import com.yqbsoft.laser.service.user.service.UmGroupService;
import com.yqbsoft.laser.service.user.service.UmUsersendService;
import com.yqbsoft.laser.service.user.service.impl.UmUsersendServiceImpl;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class UmGroupServiceImpl
extends BaseServiceImpl
implements UmGroupService {
    private static final String SYS_CODE = "um.USER.UmGroupServiceImpl";
    private UmGroupMapper umGroupMapper;
    private UmGroupListMapper umGroupListMapper;
    private UmGroupMemMapper umGroupMemMapper;
    private UmUsersendService umUsersendService;
    private String cachekey = "UmGroup-groupCode";
    private String cacheuserinfokey = "UmGroupList-userinfo";
    private String cacheuserinfomemkey = "UmGroupMem-userinfo";

    public void setUmGroupMapper(UmGroupMapper umGroupMapper) {
        this.umGroupMapper = umGroupMapper;
    }

    public void setUmGroupListMapper(UmGroupListMapper umGroupListMapper) {
        this.umGroupListMapper = umGroupListMapper;
    }

    public void setUmGroupMemMapper(UmGroupMemMapper umGroupMemMapper) {
        this.umGroupMemMapper = umGroupMemMapper;
    }

    public UmUsersendService getUmUsersendService() {
        if (null == this.umUsersendService) {
            this.umUsersendService = (UmUsersendService)ApplicationContextUtil.getService((String)"umUsersendService");
        }
        return this.umUsersendService;
    }

    private Date getSysDate() {
        try {
            return this.umGroupMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGroup(UmGroupDomain umGroupDomain) {
        if (null == umGroupDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)umGroupDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGroupDefault(UmGroup umGroup) {
        if (null == umGroup) {
            return;
        }
        if (null == umGroup.getDataState()) {
            umGroup.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == umGroup.getGmtCreate()) {
            umGroup.setGmtCreate(date);
        }
        umGroup.setGmtModified(date);
        if (StringUtils.isBlank((String)umGroup.getGroupCode())) {
            umGroup.setGroupCode(this.getNo(null, "UmGroup", "umGroup", umGroup.getTenantCode()));
        }
    }

    private int getGroupMaxCode() {
        int code = 0;
        try {
            return this.umGroupMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.getGroupMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGroupUpdataDefault(UmGroup umGroup) {
        if (null == umGroup) {
            return;
        }
        umGroup.setGmtModified(this.getSysDate());
    }

    private void saveGroupModel(UmGroup umGroup) throws ApiException {
        if (null == umGroup) {
            return;
        }
        try {
            this.logger.info("um.USER.UmGroupServiceImpl.saveGroupModel.start", (Object)JsonUtil.buildNormalBinder().toJson((Object)umGroup));
            this.umGroupMapper.insert(umGroup);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.saveGroupModel.ex", (Throwable)e);
        }
    }

    public void saveGroupBatchModel(List<UmGroup> umGroupList) throws ApiException {
        if (null == umGroupList || umGroupList.isEmpty()) {
            return;
        }
        try {
            this.umGroupMapper.insertBatch(umGroupList);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.saveGroupBatchModel.ex", (Throwable)e);
        }
    }

    private UmGroup getGroupModelById(Integer groupId) {
        if (null == groupId) {
            return null;
        }
        try {
            return this.umGroupMapper.selectByPrimaryKey(groupId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.getGroupModelById", (Throwable)e);
            return null;
        }
    }

    private UmGroup getGroupModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umGroupMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.getGroupModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGroupModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umGroupMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.delGroupModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmGroupServiceImpl.delGroupModelByCode.num");
        }
    }

    private void deleteGroupModel(Integer groupId) throws ApiException {
        if (null == groupId) {
            return;
        }
        int i = 0;
        try {
            i = this.umGroupMapper.deleteByPrimaryKey(groupId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.deleteGroupModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmGroupServiceImpl.deleteGroupModel.num");
        }
    }

    private void deleteGroupMemByCodeModel(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        int i = 0;
        try {
            i = this.umGroupMemMapper.delByGroupCode(map);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void deleteGroupMemList(UmGroup umGroup, String oldCode) throws ApiException {
        if (umGroup == null) {
            return;
        }
        this.deleteGroupMemByCodeModel(this.getQueryParamMap("groupCode,tenantCode", new Object[]{umGroup.getGroupCode(), umGroup.getTenantCode()}));
    }

    private void updateGroupMemListCache(String newScode, String oldCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)oldCode)) {
            return;
        }
        HashSet<String> code = new HashSet<String>(Arrays.asList(oldCode.split(",")));
        if (StringUtils.isNotBlank((String)newScode)) {
            code.addAll(Arrays.asList(newScode.split(",")));
        }
        String spCode = String.join((CharSequence)",", code);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("MEMBER_SCODE", spCode);
        List<UmGroupMem> memList = this.queryGroupMemModelPage(map);
        Map<String, List<UmGroupMem>> mem = memList.stream().collect(Collectors.groupingBy(UmGroupMem::getMemberScode));
        for (String c : code) {
            List groupMemList = mem.getOrDefault(c, Collections.emptyList());
            if (groupMemList.isEmpty()) {
                DisUtil.del((String)(this.cacheuserinfomemkey + "-" + c + "-" + tenantCode));
                continue;
            }
            DisUtil.setVer((String)(this.cacheuserinfomemkey + "-" + c + "-" + tenantCode), (String)JsonUtil.getNotDefJsonUtil().toJson(groupMemList));
        }
    }

    private void updateGroupMemListCache(UmGroup umGroup) throws ApiException {
        HashSet<String> code = new HashSet<String>(Arrays.asList(umGroup.getMemberScode().split(",")));
        String spCode = String.join((CharSequence)",", code);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", umGroup.getTenantCode());
        map.put("MEMBER_SCODE", spCode);
        List<UmGroupMem> memList = this.queryGroupMemModelPage(map);
        Map<String, List<UmGroupMem>> mem = memList.stream().collect(Collectors.groupingBy(UmGroupMem::getMemberScode));
        for (String c : code) {
            List groupMemList = mem.getOrDefault(c, Collections.emptyList());
            if (ListUtil.isEmpty(groupMemList)) {
                DisUtil.setVer((String)(this.cacheuserinfomemkey + "-" + c + "-" + umGroup.getTenantCode()), null);
                continue;
            }
            DisUtil.setVer((String)(this.cacheuserinfomemkey + "-" + c + "-" + umGroup.getTenantCode()), (String)JsonUtil.getNotDefJsonUtil().toJson(groupMemList));
        }
    }

    private void deleteGroupListByCodeModel(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        int i = 0;
        try {
            i = this.umGroupListMapper.delByGroupCodeS(map);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateGroupModel(UmGroup umGroup) throws ApiException {
        if (null == umGroup) {
            return;
        }
        int i = 0;
        try {
            i = this.umGroupMapper.updateByPrimaryKey(umGroup);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateGroupModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateGroupModel.num");
        }
    }

    private void updateStateGroupModel(Integer groupId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == groupId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("groupId", groupId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umGroupMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateStateGroupModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateStateGroupModel.null");
        }
    }

    private void updateStateGroupModelByCode(String tenantCode, String groupCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)groupCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("groupCode", groupCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umGroupMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateStateGroupModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateStateGroupModelByCode.null");
        }
    }

    private UmGroup makeGroup(UmGroupDomain umGroupDomain, UmGroup umGroup) {
        if (null == umGroupDomain) {
            return null;
        }
        if (null == umGroup) {
            umGroup = new UmGroup();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umGroup, (Object)umGroupDomain);
            return umGroup;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.makeGroup", (Throwable)e);
            return null;
        }
    }

    private UmGroupReDomain makeUmGroupReDomain(UmGroup umGroup) {
        if (null == umGroup) {
            return null;
        }
        UmGroupReDomain umGroupReDomain = new UmGroupReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)umGroupReDomain, (Object)umGroup);
            return umGroupReDomain;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.makeUmGroupReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UmGroup> queryGroupModelPage(Map<String, Object> parammap) {
        try {
            return this.umGroupMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.queryGroupModel", (Throwable)e);
            return null;
        }
    }

    private int countGroup(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umGroupMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.countGroup", (Throwable)e);
        }
        return i;
    }

    private UmGroup createUmGroup(UmGroupDomain umGroupDomain) {
        String msg = this.checkGroup(umGroupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmGroupServiceImpl.saveGroup.checkGroup", msg);
        }
        UmGroup umGroup = this.makeGroup(umGroupDomain, null);
        this.setGroupDefault(umGroup);
        return umGroup;
    }

    private String checkGroupList(UmGroupListDomain umGroupListDomain) {
        if (null == umGroupListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)umGroupListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGroupListDefault(UmGroupList umGroupList) {
        if (null == umGroupList) {
            return;
        }
        if (null == umGroupList.getDataState()) {
            umGroupList.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == umGroupList.getGmtCreate()) {
            umGroupList.setGmtCreate(date);
        }
        umGroupList.setGmtModified(date);
        if (StringUtils.isBlank((String)umGroupList.getGroupListCode())) {
            umGroupList.setGroupListCode(this.getNo(null, "UmGroupList", "umGroupList", umGroupList.getTenantCode()));
        }
    }

    private int getGroupListMaxCode() {
        int code = 0;
        try {
            return this.umGroupListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.getGroupListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGroupListUpdataDefault(UmGroupList umGroupList) {
        if (null == umGroupList) {
            return;
        }
        umGroupList.setGmtModified(this.getSysDate());
    }

    private void saveGroupListModel(UmGroupList umGroupList) throws ApiException {
        if (null == umGroupList) {
            return;
        }
        try {
            this.umGroupListMapper.insert(umGroupList);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.saveGroupListModel.ex", (Throwable)e);
        }
    }

    private void saveGroupListBatchModel(List<UmGroupList> umGroupListList) throws ApiException {
        if (null == umGroupListList || umGroupListList.isEmpty()) {
            return;
        }
        try {
            this.umGroupListMapper.insertBatch(umGroupListList);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.saveGroupListBatchModel.ex", (Throwable)e);
        }
    }

    private UmGroupList getGroupListModelById(Integer groupListId) {
        if (null == groupListId) {
            return null;
        }
        try {
            return this.umGroupListMapper.selectByPrimaryKey(groupListId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.getGroupListModelById", (Throwable)e);
            return null;
        }
    }

    private UmGroupList getGroupListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umGroupListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.getGroupListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGroupListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umGroupListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.delGroupListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmGroupServiceImpl.delGroupListModelByCode.num");
        }
    }

    private void deleteGroupListModel(Integer groupListId) throws ApiException {
        if (null == groupListId) {
            return;
        }
        int i = 0;
        try {
            i = this.umGroupListMapper.deleteByPrimaryKey(groupListId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.deleteGroupListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmGroupServiceImpl.deleteGroupListModel.num");
        }
    }

    private void delByInfoCodeAndGroupCodeModel(String userinfoCode, String groupCode, String tenantCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoCode", userinfoCode);
        map.put("groupCode", groupCode);
        map.put("tenantCode", tenantCode);
        int i = 0;
        try {
            i = this.umGroupListMapper.delByInfoCodeAndGroupCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.delByInfoCodeAndGroupCodeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmGroupServiceImpl.delByInfoCodeAndGroupCodeModel.num");
        }
    }

    private void updateGroupListModel(UmGroupList umGroupList) throws ApiException {
        if (null == umGroupList) {
            return;
        }
        int i = 0;
        try {
            i = this.umGroupListMapper.updateByPrimaryKey(umGroupList);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateGroupListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateGroupListModel.num");
        }
    }

    private void updateStateGroupListModel(Integer groupListId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == groupListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("groupListId", groupListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umGroupListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateStateGroupListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateStateGroupListModel.null");
        }
    }

    private void updateStateGroupListModelByCode(String tenantCode, String groupListCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)groupListCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("groupListCode", groupListCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umGroupListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateStateGroupListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateStateGroupListModelByCode.null");
        }
    }

    private UmGroupList makeGroupList(UmGroupListDomain umGroupListDomain, UmGroupList umGroupList) {
        if (null == umGroupListDomain) {
            return null;
        }
        if (null == umGroupList) {
            umGroupList = new UmGroupList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umGroupList, (Object)umGroupListDomain);
            return umGroupList;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.makeGroupList", (Throwable)e);
            return null;
        }
    }

    private UmGroupListReDomain makeUmGroupListReDomain(UmGroupList umGroupList) {
        if (null == umGroupList) {
            return null;
        }
        UmGroupListReDomain umGroupListReDomain = new UmGroupListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)umGroupListReDomain, (Object)umGroupList);
            return umGroupListReDomain;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.makeUmGroupListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UmGroupList> queryGroupListModelPage(Map<String, Object> parammap) {
        try {
            return this.umGroupListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.queryGroupListModel", (Throwable)e);
            return null;
        }
    }

    private int countGroupList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umGroupListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.countGroupList", (Throwable)e);
        }
        return i;
    }

    private UmGroupList createUmGroupList(UmGroupListDomain umGroupListDomain) {
        String msg = this.checkGroupList(umGroupListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmGroupServiceImpl.saveGroupList.checkGroupList", msg);
        }
        UmGroupList umGroupList = this.makeGroupList(umGroupListDomain, null);
        this.setGroupListDefault(umGroupList);
        return umGroupList;
    }

    private String checkGroupMem(UmGroupMemDomain umGroupMemDomain) {
        if (null == umGroupMemDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)umGroupMemDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGroupMemDefault(UmGroupMem umGroupMem) {
        if (null == umGroupMem) {
            return;
        }
        if (null == umGroupMem.getDataState()) {
            umGroupMem.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == umGroupMem.getGmtCreate()) {
            umGroupMem.setGmtCreate(date);
        }
        umGroupMem.setGmtModified(date);
        if (StringUtils.isBlank((String)umGroupMem.getGroupMemCode())) {
            umGroupMem.setGroupMemCode(this.getNo(null, "UmGroupMem", "umGroupMem", umGroupMem.getTenantCode()));
        }
    }

    private int getGroupMemMaxCode() {
        int code = 0;
        try {
            return this.umGroupMemMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.getGroupMemMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGroupMemUpdataDefault(UmGroupMem umGroupMem) {
        if (null == umGroupMem) {
            return;
        }
        umGroupMem.setGmtModified(this.getSysDate());
    }

    private void saveGroupMemModel(UmGroupMem umGroupMem) throws ApiException {
        if (null == umGroupMem) {
            return;
        }
        try {
            this.umGroupMemMapper.insert(umGroupMem);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.saveGroupMemModel.ex", (Throwable)e);
        }
    }

    private void saveGroupMemBatchModel(List<UmGroupMem> umGroupMemList) throws ApiException {
        if (null == umGroupMemList || umGroupMemList.isEmpty()) {
            return;
        }
        try {
            this.umGroupMemMapper.insertBatch(umGroupMemList);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.saveGroupMemBatchModel.ex", (Throwable)e);
        }
    }

    private UmGroupMem getGroupMemModelById(Integer groupMemId) {
        if (null == groupMemId) {
            return null;
        }
        try {
            return this.umGroupMemMapper.selectByPrimaryKey(groupMemId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.getGroupMemModelById", (Throwable)e);
            return null;
        }
    }

    private UmGroupMem getGroupMemModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umGroupMemMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.getGroupMemModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGroupMemModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umGroupMemMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.delGroupMemModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmGroupServiceImpl.delGroupMemModelByCode.num");
        }
    }

    private void deleteGroupMemModel(Integer groupMemId) throws ApiException {
        if (null == groupMemId) {
            return;
        }
        int i = 0;
        try {
            i = this.umGroupMemMapper.deleteByPrimaryKey(groupMemId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.deleteGroupMemModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmGroupServiceImpl.deleteGroupMemModel.num");
        }
    }

    private void updateGroupMemModel(UmGroupMem umGroupMem) throws ApiException {
        if (null == umGroupMem) {
            return;
        }
        int i = 0;
        try {
            i = this.umGroupMemMapper.updateByPrimaryKey(umGroupMem);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateGroupMemModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateGroupMemModel.num");
        }
    }

    private void updateStateGroupMemModel(Integer groupMemId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == groupMemId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("groupMemId", groupMemId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umGroupMemMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateStateGroupMemModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateStateGroupMemModel.null");
        }
    }

    private void updateStateGroupMemModelByCode(String tenantCode, String groupMemCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)groupMemCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("groupMemCode", groupMemCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umGroupMemMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateStateGroupMemModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateStateGroupMemModelByCode.null");
        }
    }

    private UmGroupMem makeGroupMem(UmGroupMemDomain umGroupMemDomain, UmGroupMem umGroupMem) {
        if (null == umGroupMemDomain) {
            return null;
        }
        if (null == umGroupMem) {
            umGroupMem = new UmGroupMem();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umGroupMem, (Object)umGroupMemDomain);
            return umGroupMem;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.makeGroupMem", (Throwable)e);
            return null;
        }
    }

    private UmGroupMemReDomain makeUmGroupMemReDomain(UmGroupMem umGroupMem) {
        if (null == umGroupMem) {
            return null;
        }
        UmGroupMemReDomain umGroupMemReDomain = new UmGroupMemReDomain();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)umGroupMemReDomain, (Object)umGroupMem);
            return umGroupMemReDomain;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.makeUmGroupMemReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UmGroupMem> queryGroupMemModelPage(Map<String, Object> parammap) {
        try {
            return this.umGroupMemMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.queryGroupMemModel", (Throwable)e);
            return null;
        }
    }

    private int countGroupMem(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umGroupMemMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.countGroupMem", (Throwable)e);
        }
        return i;
    }

    private UmGroupMem createUmGroupMem(UmGroupMemDomain umGroupMemDomain) {
        String msg = this.checkGroupMem(umGroupMemDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmGroupServiceImpl.saveGroupMem.checkGroupMem", msg);
        }
        UmGroupMem umGroupMem = this.makeGroupMem(umGroupMemDomain, null);
        this.setGroupMemDefault(umGroupMem);
        return umGroupMem;
    }

    @Override
    public String saveGroup(UmGroupDomain umGroupDomain) throws ApiException {
        UmUsersend umUsersend = this.saveGroupRe(umGroupDomain);
        if (null == umUsersend) {
            return null;
        }
        return umUsersend.getUserinfoCode();
    }

    @Override
    public UmUsersend saveGroupRe(UmGroupDomain umGroupDomain) throws ApiException {
        UmGroup umGroup = this.createUmGroup(umGroupDomain);
        this.saveGroupModel(umGroup);
        if (ListUtil.isNotEmpty(umGroupDomain.getUmGroupMemDomainList())) {
            this.saveGropMemDomain(umGroupDomain.getUmGroupMemDomainList(), umGroup);
            this.updateGroupMemListCache(null, umGroup.getMemberScode(), umGroup.getTenantCode());
        }
        if (ListUtil.isNotEmpty(umGroupDomain.getUmGroupListDomainList())) {
            this.saveGropListDomain(umGroupDomain.getUmGroupListDomainList(), umGroup);
        }
        UmUsersendDomain umUsersendDomain = new UmUsersendDomain();
        umUsersendDomain.setUsersendType("g-insert");
        umUsersendDomain.setUserinfoCode(umGroup.getGroupCode());
        umUsersendDomain.setTenantCode(umGroupDomain.getTenantCode());
        UmUsersend umUsersend = this.getUmUsersendService().saveSendUsersend(umUsersendDomain);
        this.updateGroupCache(umGroup.getGroupCode(), umGroup.getTenantCode());
        return umUsersend;
    }

    private void saveGropListDomain(List<UmGroupListDomain> umGroupListDomainList, UmGroup umGroup) {
        if (ListUtil.isEmpty(umGroupListDomainList) || null == umGroup) {
            return;
        }
        for (UmGroupListDomain umGroupListDomain : umGroupListDomainList) {
            try {
                BeanUtils.copyAllPropertysNotNull((Object)umGroupListDomain, (Object)umGroup);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.saveGroupList(umGroupListDomain);
        }
    }

    private void saveGropMemDomain(List<UmGroupMemDomain> umGroupMemDomainList, UmGroup umGroup) {
        if (ListUtil.isEmpty(umGroupMemDomainList) || null == umGroup) {
            return;
        }
        for (UmGroupMemDomain umGroupMemDomain : umGroupMemDomainList) {
            UmGroupMemDomain umGroupMemDomain1 = new UmGroupMemDomain();
            try {
                BeanUtils.copyAllPropertysNotNull((Object)umGroupMemDomain1, (Object)umGroup);
                BeanUtils.copyAllPropertysNotNull((Object)umGroupMemDomain1, (Object)umGroupMemDomain);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.saveGroupMem(umGroupMemDomain1);
        }
    }

    @Override
    public String saveGroupBatch(List<UmGroupDomain> umGroupDomainList) throws ApiException {
        if (null == umGroupDomainList || umGroupDomainList.isEmpty()) {
            return null;
        }
        String code = "";
        String tenantCode = null;
        String groupCode = null;
        for (UmGroupDomain umGroupDomain : umGroupDomainList) {
            tenantCode = umGroupDomain.getTenantCode();
            groupCode = umGroupDomain.getGroupCode();
            this.saveGroup(umGroupDomain);
        }
        this.updateGroupCache(groupCode, tenantCode);
        return code;
    }

    @Override
    public void updateGroupState(Integer groupId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateGroupModel(groupId, dataState, oldDataState, map);
    }

    @Override
    public void updateGroupStateByCode(String tenantCode, String groupCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateGroupModelByCode(tenantCode, groupCode, dataState, oldDataState, map);
    }

    @Override
    public void updateGroup(UmGroupDomain umGroupDomain) throws ApiException {
        this.updateGroupRe(umGroupDomain);
    }

    @Override
    public UmUsersend updateGroupRe(UmGroupDomain umGroupDomain) throws ApiException {
        String msg = this.checkGroup(umGroupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateGroup.checkGroup", msg);
        }
        UmGroup oldUmGroup = this.getGroupModelById(umGroupDomain.getGroupId());
        String oldCode = oldUmGroup.getMemberScode();
        if (null == oldUmGroup) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateGroup.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmGroup umGroup = this.makeGroup(umGroupDomain, oldUmGroup);
        this.setGroupUpdataDefault(umGroup);
        this.updateGroupModel(umGroup);
        try {
            this.updateGropMemDomain(umGroupDomain.getUmGroupMemDomainList(), oldUmGroup, oldCode);
            this.updateGropListDomain(umGroupDomain.getUmGroupListDomainList(), umGroup);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.updateGroupMemAndListModel.All");
        }
        UmUsersendDomain umUsersendDomain = new UmUsersendDomain();
        umUsersendDomain.setUsersendType("g-update");
        umUsersendDomain.setUserinfoCode(umGroupDomain.getGroupCode());
        umUsersendDomain.setTenantCode(umGroupDomain.getTenantCode());
        UmUsersend umUsersend = this.getUmUsersendService().saveSendUsersend(umUsersendDomain);
        this.updateGroupCache(umGroup.getGroupCode(), umGroup.getTenantCode());
        this.updateGroupMemListCache(oldUmGroup.getMemberScode(), oldCode, oldUmGroup.getTenantCode());
        return umUsersend;
    }

    private void updateGropListDomain(List<UmGroupListDomain> umGroupListDomainList, UmGroup umGroup) {
        if (ListUtil.isEmpty(umGroupListDomainList) || null == umGroup) {
            return;
        }
        this.deleteGroupListByCodeModel(this.getQueryParamMap("groupCode,tenantCode", new Object[]{umGroup.getGroupCode(), umGroup.getTenantCode()}));
        this.saveGropListDomain(umGroupListDomainList, umGroup);
    }

    private void updateGropMemDomain(List<UmGroupMemDomain> umGroupMemDomainList, UmGroup umGroup, String oldCode) {
        if (ListUtil.isEmpty(umGroupMemDomainList) || null == umGroup) {
            return;
        }
        this.deleteGroupMemList(umGroup, oldCode);
        this.saveGropMemDomain(umGroupMemDomainList, umGroup);
    }

    @Override
    public UmGroup getGroup(Integer groupId) {
        return this.getGroupModelById(groupId);
    }

    @Override
    public void deleteGroup(Integer groupId) throws ApiException {
        this.deleteGroupRe(groupId);
    }

    @Override
    public UmUsersend deleteGroupRe(Integer groupId) throws ApiException {
        UmGroup umGroup = this.getGroupModelById(groupId);
        this.deleteGroupModel(groupId);
        try {
            this.deleteGroupMemList(umGroup, umGroup.getMemberScode());
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.deleteGroupMemAndListModel.All");
        }
        UmUsersendDomain umUsersendDomain = new UmUsersendDomain();
        umUsersendDomain.setUsersendType("g-delete");
        umUsersendDomain.setUserinfoCode(umGroup.getGroupCode());
        umUsersendDomain.setTenantCode(umGroup.getTenantCode());
        umUsersendDomain.setUsersendData(JsonUtil.buildNonDefaultBinder().toJson((Object)umGroup));
        UmUsersend umUsersend = this.getUmUsersendService().saveSendUsersend(umUsersendDomain);
        this.deleteGroupCache(umGroup.getGroupCode(), umGroup.getTenantCode(), umGroup.getMemberScode());
        return umUsersend;
    }

    @Override
    public QueryResult<UmGroup> queryGroupPage(Map<String, Object> map) {
        List<UmGroup> umGroupList = this.queryGroupModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGroup(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umGroupList);
        return queryResult;
    }

    @Override
    public UmGroup getGroupByCode(String tenantCode, String groupCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("groupCode", groupCode);
        return this.getGroupModelByCode(map);
    }

    @Override
    public void deleteGroupByCode(String tenantCode, String groupCode) throws ApiException {
        this.deleteGroupByCodeRe(tenantCode, groupCode);
    }

    @Override
    public UmUsersend deleteGroupByCodeRe(String tenantCode, String groupCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("groupCode", groupCode);
        UmGroup umGroup = this.getGroupModelByCode(map);
        if (null == umGroup) {
            throw new ApiException("um.USER.UmGroupServiceImpl.deleteGroupByCode.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.delGroupModelByCode(map);
        this.deleteGroupMemByCodeModel(map);
        this.deleteGroupListByCodeModel(map);
        UmUsersendDomain umUsersendDomain = new UmUsersendDomain();
        umUsersendDomain.setUsersendType("g-delete");
        umUsersendDomain.setUserinfoCode(umGroup.getGroupCode());
        umUsersendDomain.setTenantCode(umGroup.getTenantCode());
        umUsersendDomain.setUsersendData(JsonUtil.buildNonDefaultBinder().toJson((Object)umGroup));
        UmUsersend umUsersend = this.getUmUsersendService().saveSendUsersend(umUsersendDomain);
        this.deleteGroupCache(groupCode, tenantCode, umGroup.getMemberScode());
        return umUsersend;
    }

    @Override
    public String saveGroupList(UmGroupListDomain umGroupListDomain) throws ApiException {
        UmGroupList umGroupList = this.createUmGroupList(umGroupListDomain);
        this.saveGroupListModel(umGroupList);
        this.updateGroupCache(umGroupList.getGroupCode(), umGroupList.getTenantCode());
        this.updateGroupListCache(umGroupList);
        return umGroupList.getGroupListCode();
    }

    @Override
    public String saveGroupListBatch(List<UmGroupListDomain> umGroupListDomainList) throws ApiException {
        if (null == umGroupListDomainList || umGroupListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UmGroupList> umGroupListList = new ArrayList<UmGroupList>();
        UmGroupList umGroupList = null;
        String code = "";
        for (UmGroupListDomain umGroupListDomain : umGroupListDomainList) {
            umGroupList = this.createUmGroupList(umGroupListDomain);
            code = umGroupList.getGroupListCode();
            umGroupListList.add(umGroupList);
        }
        this.saveGroupListBatchModel(umGroupListList);
        this.updateGroupCache(umGroupList.getGroupCode(), umGroupList.getTenantCode());
        for (UmGroupList umGroupList2 : umGroupListList) {
            this.updateGroupListCache(umGroupList2);
        }
        return code;
    }

    @Override
    public void updateGroupListState(Integer groupListId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateGroupListModel(groupListId, dataState, oldDataState, map);
    }

    @Override
    public void updateGroupListStateByCode(String tenantCode, String groupListCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateGroupListModelByCode(tenantCode, groupListCode, dataState, oldDataState, map);
    }

    @Override
    public void updateGroupList(UmGroupListDomain umGroupListDomain) throws ApiException {
        String msg = this.checkGroupList(umGroupListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateGroupList.checkGroupList", msg);
        }
        UmGroupList oldUmGroupList = this.getGroupListModelById(umGroupListDomain.getGroupListId());
        if (null == oldUmGroupList) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateGroupList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmGroupList umGroupList = this.makeGroupList(umGroupListDomain, oldUmGroupList);
        this.setGroupListUpdataDefault(umGroupList);
        this.updateGroupListModel(umGroupList);
        this.updateGroupCache(umGroupList.getGroupCode(), umGroupList.getTenantCode());
        this.updateGroupListCache(umGroupList);
    }

    @Override
    public UmGroupList getGroupList(Integer groupListId) {
        return this.getGroupListModelById(groupListId);
    }

    @Override
    public void deleteGroupList(Integer groupListId) throws ApiException {
        this.deleteGroupListModel(groupListId);
        this.updateGroupListCache(this.getGroupListModelById(groupListId));
    }

    @Override
    public QueryResult<UmGroupList> queryGroupListPage(Map<String, Object> map) {
        List<UmGroupList> umGroupListList = this.queryGroupListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGroupList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umGroupListList);
        return queryResult;
    }

    @Override
    public UmGroupList getGroupListByCode(String tenantCode, String groupListCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("groupListCode", groupListCode);
        return this.getGroupListModelByCode(map);
    }

    @Override
    public void deleteGroupListByCode(String tenantCode, String groupListCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("groupListCode", groupListCode);
        this.delGroupListModelByCode(map);
    }

    @Override
    public String saveGroupMem(UmGroupMemDomain umGroupMemDomain) throws ApiException {
        UmGroupMem umGroupMem = this.createUmGroupMem(umGroupMemDomain);
        this.saveGroupMemModel(umGroupMem);
        return umGroupMem.getGroupMemCode();
    }

    @Override
    public String saveGroupMemBatch(List<UmGroupMemDomain> umGroupMemDomainList) throws ApiException {
        if (null == umGroupMemDomainList || umGroupMemDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UmGroupMem> umGroupMemList = new ArrayList<UmGroupMem>();
        String code = "";
        for (UmGroupMemDomain umGroupMemDomain : umGroupMemDomainList) {
            UmGroupMem umGroupMem = this.createUmGroupMem(umGroupMemDomain);
            code = umGroupMem.getGroupMemCode();
            umGroupMemList.add(umGroupMem);
        }
        this.saveGroupMemBatchModel(umGroupMemList);
        return code;
    }

    @Override
    public void updateGroupMemState(Integer groupMemId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateGroupMemModel(groupMemId, dataState, oldDataState, map);
    }

    @Override
    public void updateGroupMemStateByCode(String tenantCode, String groupMemCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateGroupMemModelByCode(tenantCode, groupMemCode, dataState, oldDataState, map);
    }

    @Override
    public void updateGroupMem(UmGroupMemDomain umGroupMemDomain) throws ApiException {
        String msg = this.checkGroupMem(umGroupMemDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateGroupMem.checkGroupMem", msg);
        }
        UmGroupMem oldUmGroupMem = this.getGroupMemModelById(umGroupMemDomain.getGroupMemId());
        if (null == oldUmGroupMem) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateGroupMem.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmGroupMem umGroupMem = this.makeGroupMem(umGroupMemDomain, oldUmGroupMem);
        this.setGroupMemUpdataDefault(umGroupMem);
        this.updateGroupMemModel(umGroupMem);
    }

    @Override
    public UmGroupMem getGroupMem(Integer groupMemId) {
        return this.getGroupMemModelById(groupMemId);
    }

    @Override
    public void deleteGroupMem(Integer groupMemId) throws ApiException {
        this.deleteGroupMemModel(groupMemId);
    }

    @Override
    public QueryResult<UmGroupMem> queryGroupMemPage(Map<String, Object> map) {
        List<UmGroupMem> umGroupMemList = this.queryGroupMemModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGroupMem(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umGroupMemList);
        return queryResult;
    }

    @Override
    public UmGroupMem getGroupMemByCode(String tenantCode, String groupMemCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("groupMemCode", groupMemCode);
        return this.getGroupMemModelByCode(map);
    }

    @Override
    public void deleteGroupMemByCode(String tenantCode, String groupMemCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("groupMemCode", groupMemCode);
        this.delGroupMemModelByCode(map);
    }

    @Override
    public void removeGroupUser(String userinfoCode, String groupCode, String tenantCode) throws ApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoCode", userinfoCode);
        map.put("groupCode", groupCode);
        map.put("tenantCode", tenantCode);
        this.delByInfoCodeAndGroupCodeModel(userinfoCode, groupCode, tenantCode);
        this.updateGroupCache(groupCode, tenantCode);
    }

    private String createListToStr(List<UmGroupMem> umGroupMemList) {
        if (ListUtil.isEmpty(umGroupMemList)) {
            return null;
        }
        String str = "";
        for (UmGroupMem umGroupMem : umGroupMemList) {
            if (StringUtils.isNotBlank((String)str)) {
                str = str + ",";
            }
            str = str + umGroupMem.getMemberScode();
        }
        return str;
    }

    private String createGroupListListToStr(List<UmGroupList> umGroupListList) {
        if (ListUtil.isEmpty(umGroupListList)) {
            return null;
        }
        String str = "";
        for (UmGroupList umGroupList : umGroupListList) {
            if (StringUtils.isNotBlank((String)str)) {
                str = str + ",";
            }
            str = str + umGroupList.getUserinfoCode();
        }
        return str;
    }

    public static void main(String[] args) {
        String str = "";
        if (str == null) {
            System.out.println();
        } else {
            try {
                byte[] byArray = str.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        ConcurrentHashMap memberMap = new ConcurrentHashMap();
    }

    @Override
    public void queryGroupLoadCache() {
        List<UmGroup> umGroupList = this.queryGroupModelPage(null);
        if (ListUtil.isEmpty(umGroupList)) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("UmGroupService.queryGroupLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> memberMap = new ConcurrentHashMap<String, String>();
        for (UmGroup umGroup : umGroupList) {
            List<UmGroupMem> umGroupMemList = this.queryGroupMemModelPage(this.getQueryMapParam("tenantCode,groupCode", new Object[]{umGroup.getTenantCode(), umGroup.getGroupCode()}));
            List<UmGroupList> umGroupListList = this.queryGroupListModelPage(this.getQueryMapParam("tenantCode,groupCode", new Object[]{umGroup.getTenantCode(), umGroup.getGroupCode()}));
            this.loadGroupList(umGroupListList);
            String groupMemListStr = this.createListToStr(umGroupMemList);
            String groupListListToStr = this.createGroupListListToStr(umGroupListList);
            if (StringUtils.isBlank((String)groupListListToStr)) {
                groupListListToStr = "";
            }
            memberMap.put("groupList-" + umGroup.getGroupCode() + "-" + umGroup.getTenantCode(), groupListListToStr);
            if (StringUtils.isBlank((String)groupMemListStr)) {
                groupMemListStr = "";
            }
            memberMap.put("groupMem-" + umGroup.getGroupCode() + "-" + umGroup.getTenantCode(), groupMemListStr);
        }
        DisUtil.setMapVer((String)this.cachekey, memberMap);
    }

    private void loadGroupList(List<UmGroupList> umGroupListList) {
        if (ListUtil.isEmpty(umGroupListList)) {
            return;
        }
        for (UmGroupList umGroupList : umGroupListList) {
            this.updateGroupListCache(umGroupList);
        }
    }

    @Override
    public Map<String, Object> getUserinfoMap(String userinfoCode, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        return DisUtil.getMapJson((String)(this.cacheuserinfokey + "-" + userinfoCode + "-" + tenantCode), String.class, Object.class);
    }

    private void deleteGroupCache(String groupCode, String tenantCode, String sCode) {
        String memberKey = null;
        memberKey = "groupMem-" + groupCode + "-" + tenantCode;
        DisUtil.delMap((String)this.cachekey, (String[])new String[]{memberKey});
        memberKey = "groupList-" + groupCode + "-" + tenantCode;
        DisUtil.delMap((String)this.cachekey, (String[])new String[]{memberKey});
        if (StringUtils.isNotBlank((String)sCode)) {
            this.updateGroupMemListCache(null, sCode, tenantCode);
        }
    }

    private void updateGroupListCache(UmGroupList umGroupList) {
        if (null == umGroupList) {
            return;
        }
        List<UmGroupList> qmem = this.queryGroupListModelPage(this.getQueryMapParam("userinfoCode,tenantCode,order", new Object[]{umGroupList.getUserinfoCode(), umGroupList.getTenantCode(), true}));
        HashMap<String, String> groupMap = new HashMap<String, String>();
        if (ListUtil.isNotEmpty(qmem)) {
            for (UmGroupList umGroupList1 : qmem) {
                groupMap.put(umGroupList1.getGroupCode(), umGroupList1.getGroupName());
            }
        }
        DisUtil.set((String)(this.cacheuserinfokey + "-" + umGroupList.getUserinfoCode() + "-" + umGroupList.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(groupMap));
    }

    private void updateGroupMemCache(UmGroupMem umGroupMem) {
        if (null == umGroupMem) {
            return;
        }
        List<UmGroupMem> qmem = this.queryGroupMemModelPage(this.getQueryMapParam("userinfoCode,tenantCode,order", new Object[]{umGroupMem.getMemberScode(), umGroupMem.getTenantCode(), true}));
        ArrayList<String> groupMap = new ArrayList<String>();
        if (ListUtil.isNotEmpty(qmem)) {
            for (UmGroupMem umGroupList1 : qmem) {
                groupMap.add(umGroupList1.getGroupCode());
            }
            DisUtil.setVer((String)(this.cacheuserinfomemkey + "-" + umGroupMem.getMemberScode() + "-" + umGroupMem.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(groupMap));
        }
    }

    private void updateGroupCache(String groupCode, String tenantCode) {
        List umGroupMemList = this.queryGroupMemPage(this.getQueryMapParam("tenantCode,groupCode", new Object[]{tenantCode, groupCode})).getList();
        List<UmGroupList> umGroupListList = this.queryGroupListModelPage(this.getQueryMapParam("tenantCode,groupCode", new Object[]{tenantCode, groupCode}));
        String groupMemListStr = this.createListToStr(umGroupMemList);
        String groupListListToStr = this.createGroupListListToStr(umGroupListList);
        if (StringUtils.isBlank((String)groupListListToStr)) {
            groupListListToStr = "";
        }
        DisUtil.setMapVer((String)this.cachekey, (String)("groupList-" + groupCode + "-" + tenantCode), (String)groupListListToStr);
        if (StringUtils.isBlank((String)groupMemListStr)) {
            groupMemListStr = "";
        }
        DisUtil.setMapVer((String)this.cachekey, (String)("groupMem-" + groupCode + "-" + tenantCode), (String)groupMemListStr);
    }

    @Override
    public String sendSaveGroup(UmGroupDomain umGroupDomain) {
        if (null == umGroupDomain) {
            this.logger.error("um.USER.UmGroupServiceImpl.sendSaveGroup.umGroupDomain.null");
            return null;
        }
        UmGroup umGroup = this.createUmGroup(umGroupDomain);
        this.saveGroupModel(umGroup);
        if (ListUtil.isNotEmpty(umGroupDomain.getUmGroupMemDomainList())) {
            this.saveGropMemDomain(umGroupDomain.getUmGroupMemDomainList(), umGroup);
        }
        if (ListUtil.isEmpty(umGroupDomain.getUmGroupListDomainList())) {
            return null;
        }
        if (StringUtils.isNotBlank((String)umGroupDomain.getUmGroupListDomainList().get(0).getGroupCode())) {
            umGroup.setGroupCode(null);
        }
        ArrayList<UmUsersend> umUsersendList = new ArrayList<UmUsersend>();
        UmUsersendDomain umUsersendDomain = new UmUsersendDomain();
        this.saveGropListDomain(umGroupDomain.getUmGroupListDomainList(), umGroup);
        umUsersendDomain.setUsersendType("group");
        umUsersendDomain.setUserinfoCode(umGroupDomain.getMemberCode());
        umUsersendDomain.setTenantCode(umGroupDomain.getTenantCode());
        UmUsersend umUsersend = this.getUmUsersendService().saveSendUsersend(umUsersendDomain);
        umUsersendList.add(umUsersend);
        UmUsersendServiceImpl.getEsEngineService().addPutPool(new EsEnginePutThread(UmUsersendServiceImpl.getEsEngineService(), umUsersendList));
        this.updateGroupCache(umGroup.getGroupCode(), umGroup.getTenantCode());
        return umGroup.getGroupCode();
    }
}

