/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.virtualdepositor.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.supper.SupperRuestDomain;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.virtualdepositor.domain.RuestDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountAikang;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountClearDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountDoDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountInfo;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountOuterCtrlDomain;
import com.yqbsoft.laser.service.virtualdepositor.model.VdFaccountClear;
import com.yqbsoft.laser.service.virtualdepositor.model.VdFaccountOuterCtrl;
import com.yqbsoft.laser.service.virtualdepositor.service.VdFaccountClearService;
import com.yqbsoft.laser.service.virtualdepositor.service.VdFaccountInnerService;
import com.yqbsoft.laser.service.virtualdepositor.service.VdFaccountOuterCtrlService;
import com.yqbsoft.laser.service.virtualdepositor.service.VdFaccountOuterService;
import com.yqbsoft.laser.service.virtualdepositor.service.VdFaccountService;
import com.yqbsoft.laser.service.virtualdepositor.service.impl.ClearCallPollThread;
import com.yqbsoft.laser.service.virtualdepositor.service.impl.ClearCallPutThread;
import com.yqbsoft.laser.service.virtualdepositor.service.impl.ClearCallService;
import com.yqbsoft.laser.service.virtualdepositor.service.impl.ClearPollThread;
import com.yqbsoft.laser.service.virtualdepositor.service.impl.ClearPutThread;
import com.yqbsoft.laser.service.virtualdepositor.service.impl.ClearService;
import com.yqbsoft.laser.service.virtualdepositor.service.impl.OuterCallPollThread;
import com.yqbsoft.laser.service.virtualdepositor.service.impl.OuterCtrlCallService;
import com.yqbsoft.laser.service.virtualdepositor.service.impl.OuterCtrlPollThread;
import com.yqbsoft.laser.service.virtualdepositor.service.impl.OuterCtrlPutThread;
import com.yqbsoft.laser.service.virtualdepositor.service.impl.OuterCtrlService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class VdFaccountServiceImpl
extends BaseServiceImpl
implements VdFaccountService {
    public static final String SYS_CODE = "vd.VdFaccountServiceImpl";
    private VdFaccountOuterCtrlService vdFaccountOuterCtrlService;
    private VdFaccountClearService vdFaccountClearService;
    private VdFaccountOuterService vdFaccountOuterService;
    VdFaccountInnerService vdFaccountInnerService;
    private static ClearService clearService;
    private static Object lock;
    private static ClearCallService clearCallService;
    private static Object lockCall;
    private static OuterCtrlService outerCtrlService;
    private static Object outerCtrllock;
    private static OuterCtrlCallService outerCtrlCallService;
    private static Object outerCtrllockCall;

    public void setVdFaccountInnerService(VdFaccountInnerService vdFaccountInnerService) {
        this.vdFaccountInnerService = vdFaccountInnerService;
    }

    public void setVdFaccountOuterService(VdFaccountOuterService vdFaccountOuterService) {
        this.vdFaccountOuterService = vdFaccountOuterService;
    }

    public void setVdFaccountOuterCtrlService(VdFaccountOuterCtrlService vdFaccountOuterCtrlService) {
        this.vdFaccountOuterCtrlService = vdFaccountOuterCtrlService;
    }

    public void setVdFaccountClearService(VdFaccountClearService vdFaccountClearService) {
        this.vdFaccountClearService = vdFaccountClearService;
    }

    @Override
    public void sendFaccounBalance(List<VdFaccountClearDomain> vdFaccountDoDomainList) throws ApiException {
        if (null == vdFaccountDoDomainList || vdFaccountDoDomainList.isEmpty()) {
            throw new ApiException("vd.VdFaccountServiceImpl.saveFaccounBalance.null", "null");
        }
        this.vdFaccountClearService.saveFaccountClearBatch(vdFaccountDoDomainList);
        this.getClearService().addPutPool(new ClearPutThread(this.getClearService(), vdFaccountDoDomainList));
    }

    @Override
    public void sendFaccounBalanceOne(List<VdFaccountClearDomain> vdFaccountDoDomainList) throws ApiException {
        if (null == vdFaccountDoDomainList || vdFaccountDoDomainList.isEmpty()) {
            throw new ApiException("vd.VdFaccountServiceImpl.sendFaccounBalanceOne.null", "null");
        }
        this.vdFaccountClearService.saveFaccountClearBatch(vdFaccountDoDomainList);
        try {
            List<VdFaccountClear> list = this.vdFaccountClearService.updateExcuteFaccountClear(vdFaccountDoDomainList);
            if (ListUtil.isNotEmpty(list)) {
                for (VdFaccountClear vdFaccountClear : list) {
                    this.vdFaccountClearService.updateFaccountClearCallState(vdFaccountClear.getFaccountClearId(), 2, 1);
                }
            }
            return;
        }
        catch (ApiException e) {
            this.logger.error("vd.VdFaccountServiceImpl.sendFaccounBalanceOne.updateExcuteFaccountClear1", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountServiceImpl.sendFaccounBalanceOne.updateExcuteFaccountClear2", (Throwable)e);
        }
        List<VdFaccountClear> list = this.vdFaccountClearService.updateFaccountClearError(vdFaccountDoDomainList);
        if (ListUtil.isNotEmpty(list)) {
            for (VdFaccountClear vdFaccountClear : list) {
                this.vdFaccountClearService.updateFaccountClearCallState(vdFaccountClear.getFaccountClearId(), 2, 1);
            }
        }
    }

    private VdFaccountClearDomain makeClear(VdFaccountDoDomain vdFaccountDoDomain) {
        if (null == vdFaccountDoDomain) {
            return null;
        }
        VdFaccountClearDomain vdFaccountClearDomain = new VdFaccountClearDomain();
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountClearDomain, (Object)vdFaccountDoDomain);
            return vdFaccountClearDomain;
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountServiceImpl.makeClear.e", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClearService getClearService() {
        Object object = lock;
        synchronized (object) {
            if (null == clearService) {
                clearService = new ClearService((VdFaccountService)SpringApplicationContextUtil.getBean((String)"vdFaccountService"));
                for (int i = 0; i < 50; ++i) {
                    clearService.addPollPool(new ClearPollThread(clearService));
                }
            }
            return clearService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClearCallService getClearCallService() {
        Object object = lockCall;
        synchronized (object) {
            if (null == clearCallService) {
                clearCallService = new ClearCallService((VdFaccountService)SpringApplicationContextUtil.getBean((String)"vdFaccountService"));
                for (int i = 0; i < 50; ++i) {
                    clearCallService.addPollPool(new ClearCallPollThread(clearCallService));
                }
            }
            return clearCallService;
        }
    }

    @Override
    public void faccounBalance(List<VdFaccountClearDomain> vdFaccountClearDomainList) throws ApiException {
        if (null == vdFaccountClearDomainList || vdFaccountClearDomainList.isEmpty()) {
            return;
        }
        try {
            List<VdFaccountClear> list = this.vdFaccountClearService.updateExcuteFaccountClear(vdFaccountClearDomainList);
            this.getClearCallService().addPutPool(new ClearCallPutThread(this.getClearCallService(), list));
            return;
        }
        catch (ApiException e) {
            this.logger.error("vd.VdFaccountServiceImpl.faccounBalance.updateExcuteFaccountClear1", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountServiceImpl.faccounBalance.updateExcuteFaccountClear2", (Throwable)e);
        }
        List<VdFaccountClear> list = this.vdFaccountClearService.updateFaccountClearError(vdFaccountClearDomainList);
        this.getClearCallService().addPutPool(new ClearCallPutThread(this.getClearCallService(), list));
    }

    @Override
    public void checkBalance() throws ApiException {
    }

    @Override
    public void saveOpenFaccoun(VdFaccountOuterCtrlDomain vdFaccountOuterCtrlDomain) throws ApiException {
        VdFaccountOuterCtrl vdFaccountOuterCtrl = this.vdFaccountOuterCtrlService.saveFaccountOuterCtrl(vdFaccountOuterCtrlDomain);
        if (null != vdFaccountOuterCtrl) {
            ArrayList<VdFaccountOuterCtrl> list = new ArrayList<VdFaccountOuterCtrl>();
            list.add(vdFaccountOuterCtrl);
            this.getOuterCtrlService().addPutPool(new OuterCtrlPutThread(this.getOuterCtrlService(), list));
        }
    }

    @Override
    public List<VdFaccountInfo> queryOuterFaccount(String merchantCode, String faccountType, String tenantCode) {
        return this.vdFaccountOuterService.queryOuterFaccount(merchantCode, faccountType, tenantCode);
    }

    @Override
    public List<VdFaccountInfo> queryOuterFaccountNew(String merchantCode, String faccountType, String type, String tenantCode) {
        return this.vdFaccountOuterService.queryOuterFaccount(merchantCode, faccountType, tenantCode);
    }

    @Override
    public QueryResult<VdFaccountInfo> queryOuterFaccountInfoPage(Map<String, Object> map) {
        return this.vdFaccountOuterService.queryFaccountInfoPage(map);
    }

    @Override
    public RuestDomain saveFaccounBalanceOne(VdFaccountDoDomain vdFaccountDoDomain) throws ApiException {
        RuestDomain ruestDomain = new RuestDomain();
        if (null == vdFaccountDoDomain) {
            this.logger.error("vd.VdFaccountServiceImpl.saveFaccounBalanceOne.null");
            return null;
        }
        ArrayList<VdFaccountClearDomain> vdFaccountDoDomainList = new ArrayList<VdFaccountClearDomain>();
        vdFaccountDoDomainList.add(this.makeClear(vdFaccountDoDomain));
        try {
            this.sendFaccounBalance(vdFaccountDoDomainList);
            ruestDomain.setOrderState("2");
        }
        catch (ApiException e) {
            this.logger.error("vd.VdFaccountServiceImpl.saveFaccounBalanceOne.service", (Throwable)e);
            ruestDomain.setOrderState("3");
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountServiceImpl.saveFaccounBalanceOne.service1", (Throwable)e);
            ruestDomain.setOrderState("3");
        }
        ruestDomain.setOrderCode(vdFaccountDoDomain.getClearOrderSeqno());
        ruestDomain.setTenantCode(vdFaccountDoDomain.getTenantCode());
        return ruestDomain;
    }

    @Override
    public void saveFaccountClearCall(VdFaccountClear vdFaccountClear) throws ApiException {
        if (null == vdFaccountClear) {
            throw new ApiException("vd.VdFaccountServiceImpl.saveFaccountClearCall.vdFaccountClear", "null");
        }
        this.vdFaccountClearService.updateFaccountClearCallState(vdFaccountClear.getFaccountClearId(), 2, 1);
        SupperRuestDomain ruestDomain = new SupperRuestDomain();
        ruestDomain.setApiCode("pe.payClear.sendClearOrderNext");
        ruestDomain.setOrderCode(vdFaccountClear.getClearOrderSeqno());
        ruestDomain.setTenantCode(vdFaccountClear.getTenantCode());
        ruestDomain.setOrderState(String.valueOf(vdFaccountClear.getDataState()));
        ruestDomain.setReorderCode(vdFaccountClear.getFaccountClearSeqno());
        String extjs = "{\"state\":\"" + vdFaccountClear.getDataState() + "\"}";
        ruestDomain.setExtStr(extjs);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ruestDomain", JsonUtil.buildNormalBinder().toJson((Object)ruestDomain));
        try {
            this.internalInvoke(ruestDomain.getApiCode(), paramMap);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountServiceImpl.saveFaccountClearCall", (Throwable)e);
            throw new ApiException("vd.VdFaccountServiceImpl.saveFaccountClearCall.e", (Throwable)e);
        }
    }

    @Override
    public void loadProcess() {
        this.loadDb();
        this.loadCallDb();
    }

    private void loadCallDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("faccountClearState", 1);
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            QueryResult<VdFaccountClear> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = this.getClearCallService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getClearCallService().getPage());
                result = this.vdFaccountClearService.queryFaccountClearPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    this.getClearCallService().addPutPool(new ClearCallPutThread(this.getClearCallService(), result.getRows()));
                    if (result.getRows().size() == this.getClearCallService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            this.getClearCallService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountServiceImpl.loadDb.e", (Throwable)e);
        }
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataState", "0");
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            QueryResult<VdFaccountClear> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = this.getClearService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getClearService().getPage());
                result = this.vdFaccountClearService.queryFaccountClearPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    this.getClearService().addPutPool(new ClearPutThread(this.getClearService(), this.makeClearList(result.getRows())));
                    if (result.getRows().size() == this.getClearService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            this.getClearService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountServiceImpl.loadDb.e", (Throwable)e);
        }
    }

    private List<VdFaccountClearDomain> makeClearList(List<VdFaccountClear> claerList) {
        if (null == claerList || claerList.isEmpty()) {
            return null;
        }
        ArrayList<VdFaccountClearDomain> domainList = new ArrayList<VdFaccountClearDomain>();
        for (VdFaccountClear vdFaccountClear : claerList) {
            domainList.add(this.makeClear(vdFaccountClear));
        }
        return domainList;
    }

    private VdFaccountClearDomain makeClear(VdFaccountClear vdFaccountClear) {
        if (null == vdFaccountClear) {
            return null;
        }
        VdFaccountClearDomain vdFaccountClearDomain = new VdFaccountClearDomain();
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountClearDomain, (Object)vdFaccountClear);
            return vdFaccountClearDomain;
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountServiceImpl.makeClear.e", (Throwable)e);
            return null;
        }
    }

    @Override
    public void loadOuterCtrlProcess() {
        this.loadOuterCtrlDb();
        this.loadOuterCtrlCallDb();
    }

    private void loadOuterCtrlCallDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("faccountOuterCtrlState", 1);
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            QueryResult<VdFaccountOuterCtrl> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = this.getOuterCtrlCallService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getOuterCtrlCallService().getPage());
                result = this.vdFaccountOuterCtrlService.queryFaccountOuterCtrlPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    for (VdFaccountOuterCtrl vdFaccountOuterCtrl : result.getRows()) {
                        this.getOuterCtrlCallService().putQueue(vdFaccountOuterCtrl);
                    }
                    if (result.getRows().size() == this.getOuterCtrlCallService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            this.getOuterCtrlCallService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountServiceImpl.loadDb.e", (Throwable)e);
        }
    }

    private void loadOuterCtrlDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataState", "0");
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            QueryResult<VdFaccountOuterCtrl> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = this.getOuterCtrlService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getOuterCtrlService().getPage());
                result = this.vdFaccountOuterCtrlService.queryFaccountOuterCtrlPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    this.getOuterCtrlService().addPutPool(new OuterCtrlPutThread(this.getOuterCtrlService(), result.getRows()));
                    if (result.getRows().size() == this.getOuterCtrlService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            this.getOuterCtrlService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountServiceImpl.loadDb.e", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OuterCtrlService getOuterCtrlService() {
        Object object = outerCtrllock;
        synchronized (object) {
            if (null == outerCtrlService) {
                outerCtrlService = new OuterCtrlService((VdFaccountService)SpringApplicationContextUtil.getBean((String)"vdFaccountService"));
                for (int i = 0; i < 100; ++i) {
                    outerCtrlService.addPollPool(new OuterCtrlPollThread(outerCtrlService));
                }
            }
            return outerCtrlService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OuterCtrlCallService getOuterCtrlCallService() {
        Object object = outerCtrllockCall;
        synchronized (object) {
            if (null == outerCtrlCallService) {
                outerCtrlCallService = new OuterCtrlCallService((VdFaccountService)SpringApplicationContextUtil.getBean((String)"vdFaccountService"));
                for (int i = 0; i < 500; ++i) {
                    outerCtrlCallService.addPollPool(new OuterCallPollThread(outerCtrlCallService));
                }
            }
            return outerCtrlCallService;
        }
    }

    @Override
    public void sendOuterCtrlOpenFaccount(VdFaccountOuterCtrl vdFaccountOuterCtrl) {
        VdFaccountOuterCtrl reVdFaccountOuterCtrl = this.vdFaccountOuterCtrlService.saveSendOpenFaccount(vdFaccountOuterCtrl);
        if (null != reVdFaccountOuterCtrl) {
            this.getOuterCtrlCallService().putQueue(reVdFaccountOuterCtrl);
        }
    }

    @Override
    public void sendOuterCtrlCall(VdFaccountOuterCtrl vdFaccountOuterCtrl) {
        this.vdFaccountOuterCtrlService.saveSendCall(vdFaccountOuterCtrl);
    }

    @Override
    public void saveFaccountInit(String tenantCode) {
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return;
        }
        this.vdFaccountInnerService.saveFaccountInnerInit(tenantCode);
    }

    @Override
    public Map<String, Object> countFaccountInDt(Map<String, Object> map) {
        return this.vdFaccountOuterService.countVdFaccountOuterDt(map);
    }

    @Override
    public QueryResult<VdFaccountAikang> queryAikangFaccountInfoPage(Map<String, Object> map) {
        return this.vdFaccountOuterService.queryAikangFaccountInfoPage(map);
    }

    static {
        lock = new Object();
        lockCall = new Object();
        outerCtrllock = new Object();
        outerCtrllockCall = new Object();
    }
}

