/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.financialconnections;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.financialconnections.TransactionCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.financialconnections.TransactionListParams;
import com.stripe.param.financialconnections.TransactionRetrieveParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class Transaction
extends ApiResource
implements HasId {
    @SerializedName(value="account")
    String account;
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="status_transitions")
    StatusTransitions statusTransitions;
    @SerializedName(value="transacted_at")
    Long transactedAt;
    @SerializedName(value="transaction_refresh")
    String transactionRefresh;
    @SerializedName(value="updated")
    Long updated;

    public static TransactionCollection list(Map<String, Object> params) throws StripeException {
        return Transaction.list(params, (RequestOptions)null);
    }

    public static TransactionCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/financial_connections/transactions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (TransactionCollection)Transaction.getGlobalResponseGetter().request(request, (Type)((Object)TransactionCollection.class));
    }

    public static TransactionCollection list(TransactionListParams params) throws StripeException {
        return Transaction.list(params, (RequestOptions)null);
    }

    public static TransactionCollection list(TransactionListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/financial_connections/transactions";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (TransactionCollection)Transaction.getGlobalResponseGetter().request(request, (Type)((Object)TransactionCollection.class));
    }

    public static Transaction retrieve(String transaction) throws StripeException {
        return Transaction.retrieve(transaction, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Transaction retrieve(String transaction, RequestOptions options) throws StripeException {
        return Transaction.retrieve(transaction, (Map<String, Object>)null, options);
    }

    public static Transaction retrieve(String transaction, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/financial_connections/transactions/%s", ApiResource.urlEncodeId(transaction));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (Transaction)Transaction.getGlobalResponseGetter().request(request, (Type)((Object)Transaction.class));
    }

    public static Transaction retrieve(String transaction, TransactionRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/financial_connections/transactions/%s", ApiResource.urlEncodeId(transaction));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Transaction)Transaction.getGlobalResponseGetter().request(request, (Type)((Object)Transaction.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.statusTransitions, responseGetter);
    }

    @Generated
    public String getAccount() {
        return this.account;
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public StatusTransitions getStatusTransitions() {
        return this.statusTransitions;
    }

    @Generated
    public Long getTransactedAt() {
        return this.transactedAt;
    }

    @Generated
    public String getTransactionRefresh() {
        return this.transactionRefresh;
    }

    @Generated
    public Long getUpdated() {
        return this.updated;
    }

    @Generated
    public void setAccount(String account) {
        this.account = account;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setStatusTransitions(StatusTransitions statusTransitions) {
        this.statusTransitions = statusTransitions;
    }

    @Generated
    public void setTransactedAt(Long transactedAt) {
        this.transactedAt = transactedAt;
    }

    @Generated
    public void setTransactionRefresh(String transactionRefresh) {
        this.transactionRefresh = transactionRefresh;
    }

    @Generated
    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transaction)) {
            return false;
        }
        Transaction other = (Transaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$transactedAt = this.getTransactedAt();
        Long other$transactedAt = other.getTransactedAt();
        if (this$transactedAt == null ? other$transactedAt != null : !((Object)this$transactedAt).equals(other$transactedAt)) {
            return false;
        }
        Long this$updated = this.getUpdated();
        Long other$updated = other.getUpdated();
        if (this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        StatusTransitions this$statusTransitions = this.getStatusTransitions();
        StatusTransitions other$statusTransitions = other.getStatusTransitions();
        if (this$statusTransitions == null ? other$statusTransitions != null : !((Object)this$statusTransitions).equals(other$statusTransitions)) {
            return false;
        }
        String this$transactionRefresh = this.getTransactionRefresh();
        String other$transactionRefresh = other.getTransactionRefresh();
        return !(this$transactionRefresh == null ? other$transactionRefresh != null : !this$transactionRefresh.equals(other$transactionRefresh));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Transaction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $transactedAt = this.getTransactedAt();
        result = result * 59 + ($transactedAt == null ? 43 : ((Object)$transactedAt).hashCode());
        Long $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        StatusTransitions $statusTransitions = this.getStatusTransitions();
        result = result * 59 + ($statusTransitions == null ? 43 : ((Object)$statusTransitions).hashCode());
        String $transactionRefresh = this.getTransactionRefresh();
        result = result * 59 + ($transactionRefresh == null ? 43 : $transactionRefresh.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class StatusTransitions
    extends StripeObject {
        @SerializedName(value="posted_at")
        Long postedAt;
        @SerializedName(value="void_at")
        Long voidAt;

        @Generated
        public Long getPostedAt() {
            return this.postedAt;
        }

        @Generated
        public Long getVoidAt() {
            return this.voidAt;
        }

        @Generated
        public void setPostedAt(Long postedAt) {
            this.postedAt = postedAt;
        }

        @Generated
        public void setVoidAt(Long voidAt) {
            this.voidAt = voidAt;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatusTransitions)) {
                return false;
            }
            StatusTransitions other = (StatusTransitions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$postedAt = this.getPostedAt();
            Long other$postedAt = other.getPostedAt();
            if (this$postedAt == null ? other$postedAt != null : !((Object)this$postedAt).equals(other$postedAt)) {
                return false;
            }
            Long this$voidAt = this.getVoidAt();
            Long other$voidAt = other.getVoidAt();
            return !(this$voidAt == null ? other$voidAt != null : !((Object)this$voidAt).equals(other$voidAt));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StatusTransitions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $postedAt = this.getPostedAt();
            result = result * 59 + ($postedAt == null ? 43 : ((Object)$postedAt).hashCode());
            Long $voidAt = this.getVoidAt();
            result = result * 59 + ($voidAt == null ? 43 : ((Object)$voidAt).hashCode());
            return result;
        }
    }
}

