/*
 * Decompiled with CFR 0.152.
 */
package com.unionpay.mpi;

import com.unionpay.mpi.LogUtil;
import com.unionpay.mpi.MpiConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CertUtil {
    private static KeyStore keyStore = null;
    private static X509Certificate encryptCert = null;
    private static X509Certificate validateCert = null;
    private static Map<String, X509Certificate> certMap = new HashMap<String, X509Certificate>();
    private static KeyStore certKeyStore = null;

    public static void init() {
        CertUtil.initSignCert();
        CertUtil.initEncryptCert();
        CertUtil.initValidateCertFromDir();
    }

    public static void initSignCert() {
        LogUtil.writeLog("\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66\u5f00\u59cb");
        if (null != keyStore) {
            keyStore = null;
        }
        keyStore = CertUtil.getKeyInfo(MpiConfig.getConfig().getSignCertPath(), MpiConfig.getConfig().getSignCertPwd(), MpiConfig.getConfig().getSignCertType());
        LogUtil.writeLog("[" + MpiConfig.getConfig().getSignCertPath() + "][serialNumber=" + CertUtil.getSignCertId() + "]");
        LogUtil.writeLog("\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66\u7ed3\u675f");
    }

    public static void initSignCert(String certFilePath, String certPwd) {
        LogUtil.writeLog("\u52a0\u8f7d\u8bc1\u4e66\u6587\u4ef6[" + certFilePath + "]\u548c\u8bc1\u4e66\u5bc6\u7801[" + certPwd + "]\u7684\u7b7e\u540d\u8bc1\u4e66\u5f00\u59cb.");
        File files = new File(certFilePath);
        if (!files.exists()) {
            LogUtil.writeLog("\u8bc1\u4e66\u6587\u4ef6\u4e0d\u5b58\u5728,\u521d\u59cb\u5316\u7b7e\u540d\u8bc1\u4e66\u5931\u8d25.");
            return;
        }
        if (null != certKeyStore) {
            certKeyStore = null;
        }
        certKeyStore = CertUtil.getKeyInfo(certFilePath, certPwd, "PKCS12");
        LogUtil.writeLog("\u52a0\u8f7d\u8bc1\u4e66\u6587\u4ef6[" + certFilePath + "]\u548c\u8bc1\u4e66\u5bc6\u7801[" + certPwd + "]\u7684\u7b7e\u540d\u8bc1\u4e66\u7ed3\u675f.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initEncryptCert() {
        LogUtil.writeLog("\u52a0\u8f7d\u5bc6\u7801\u52a0\u5bc6\u8bc1\u4e66\u5f00\u59cb");
        String path = MpiConfig.getConfig().getEncryptCertPath();
        if (null == path || "".equals(path)) {
            LogUtil.writeLog("\u52a0\u8f7d\u5bc6\u7801\u52a0\u5bc6\u8bc1\u4e66\u8def\u5f84\u662f\u7a7a");
            return;
        }
        CertificateFactory cf = null;
        FileInputStream in = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
            in = new FileInputStream(MpiConfig.getConfig().getEncryptCertPath());
            encryptCert = (X509Certificate)cf.generateCertificate(in);
            LogUtil.writeLog("[" + MpiConfig.getConfig().getEncryptCertPath() + "][serialNumber=" + CertUtil.getEncryptCertId() + "]");
        }
        catch (CertificateException e) {
            LogUtil.writeErrorLog("\u8bc1\u4e66\u52a0\u8f7d\u5931\u8d25", e);
        }
        catch (FileNotFoundException e) {
            LogUtil.writeErrorLog("\u8bc1\u4e66\u52a0\u8f7d\u5931\u8d25,\u6587\u4ef6\u4e0d\u5b58\u5728", e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LogUtil.writeErrorLog(e.toString());
                }
            }
        }
        LogUtil.writeLog("\u52a0\u8f7d\u5bc6\u7801\u52a0\u5bc6\u8bc1\u4e66\u7ed3\u675f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initValidateCert() {
        LogUtil.writeLog("\u52a0\u8f7d\u9a8c\u8bc1\u7b7e\u540d\u8bc1\u4e66");
        String path = MpiConfig.getConfig().getValidateCertPath();
        if (null == path || "".equals(path)) {
            LogUtil.writeLog("\u9a8c\u8bc1\u7b7e\u540d\u8bc1\u4e66\u8def\u5f84\u4e3a\u7a7a");
            return;
        }
        CertificateFactory cf = null;
        FileInputStream in = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
            in = new FileInputStream(MpiConfig.getConfig().getValidateCertPath());
            validateCert = (X509Certificate)cf.generateCertificate(in);
        }
        catch (CertificateException e) {
            LogUtil.writeErrorLog("\u9a8c\u8bc1\u7b7e\u540d\u8bc1\u4e66\u52a0\u8f7d\u5931\u8d25", e);
        }
        catch (FileNotFoundException e) {
            LogUtil.writeErrorLog("\u9a8c\u8bc1\u7b7e\u540d\u8bc1\u4e66\u52a0\u8f7d\u5931\u8d25,\u8bc1\u4e66\u6587\u4ef6\u4e0d\u5b58\u5728", e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LogUtil.writeErrorLog(e.toString());
                }
            }
        }
        LogUtil.writeLog("\u52a0\u8f7d\u9a8c\u8bc1\u7b7e\u540d\u8bc1\u4e66\u7ed3\u675f ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initValidateCertFromDir() {
        LogUtil.writeLog("\u4ece\u76ee\u5f55\u4e2d\u52a0\u8f7d\u9a8c\u8bc1\u7b7e\u540d\u8bc1\u4e66\u5f00\u59cb.");
        certMap.clear();
        String filePath = MpiConfig.getConfig().getValidateCertDir();
        if (null == filePath || "".equals(filePath)) {
            LogUtil.writeLog("\u9a8c\u8bc1\u7b7e\u540d\u8bc1\u4e66\u8def\u5f84\u914d\u7f6e\u4e3a\u7a7a.");
            return;
        }
        CertificateFactory cf = null;
        FileInputStream in = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
            File fileDir = new File(filePath);
            File[] files = fileDir.listFiles(new CerFilter());
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                in = new FileInputStream(file.getAbsolutePath());
                validateCert = (X509Certificate)cf.generateCertificate(in);
                certMap.put(validateCert.getSerialNumber().toString(), validateCert);
                LogUtil.writeLog("[" + file.getAbsolutePath() + "][serialNumber=" + validateCert.getSerialNumber().toString() + "]");
            }
        }
        catch (CertificateException e) {
            LogUtil.writeErrorLog("\u9a8c\u8bc1\u7b7e\u540d\u8bc1\u4e66\u52a0\u8f7d\u5931\u8d25", e);
        }
        catch (FileNotFoundException e) {
            LogUtil.writeErrorLog("\u9a8c\u8bc1\u7b7e\u540d\u8bc1\u4e66\u52a0\u8f7d\u5931\u8d25,\u8bc1\u4e66\u6587\u4ef6\u4e0d\u5b58\u5728", e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LogUtil.writeErrorLog(e.toString());
                }
            }
        }
        LogUtil.writeLog("\u4ece\u76ee\u5f55\u4e2d\u52a0\u8f7d\u9a8c\u8bc1\u7b7e\u540d\u8bc1\u4e66\u7ed3\u675f.");
    }

    public static PrivateKey getSignCertPrivateKey() {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, MpiConfig.getConfig().getSignCertPwd().toCharArray());
            return privateKey;
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u83b7\u53d6\u7b7e\u540d\u8bc1\u4e66\u7684\u79c1\u94a5\u5931\u8d25", e);
            return null;
        }
    }

    public static PrivateKey getSignCertPrivateKey(String certPath, String certPwd) {
        CertUtil.initSignCert(certPath, certPwd);
        try {
            Enumeration<String> aliasenum = certKeyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)certKeyStore.getKey(keyAlias, certPwd.toCharArray());
            return privateKey;
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u83b7\u53d6[" + certPath + "]\u7684\u7b7e\u540d\u8bc1\u4e66\u7684\u79c1\u94a5\u5931\u8d25", e);
            return null;
        }
    }

    public static PublicKey getEncryptCertPublicKey() {
        try {
            if (null == encryptCert) {
                CertUtil.initEncryptCert();
            }
            return encryptCert.getPublicKey();
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u83b7\u53d6\u52a0\u5bc6\u8bc1\u4e66\u5931\u8d25", e);
            return null;
        }
    }

    public static PublicKey getValidateKey() {
        try {
            if (null == validateCert) {
                return null;
            }
            return validateCert.getPublicKey();
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u83b7\u53d6\u9a8c\u8bc1\u7b7e\u540d\u8bc1\u4e66\u5931\u8d25", e);
            return null;
        }
    }

    public static PublicKey getValidateKey(String certId) {
        X509Certificate cf = null;
        if (certMap.containsKey(certId)) {
            cf = certMap.get(certId);
            return cf.getPublicKey();
        }
        CertUtil.initValidateCertFromDir();
        if (certMap.containsKey(certId)) {
            cf = certMap.get(certId);
            return cf.getPublicKey();
        }
        LogUtil.writeErrorLog("\u6ca1\u6709certId=[" + certId + "]\u5bf9\u5e94\u7684\u8bc1\u4e66\u6587\u4ef6,\u8fd4\u56deNULL.");
        return null;
    }

    public static String getSignCertId() {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(keyAlias);
            return cert.getSerialNumber().toString();
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u83b7\u53d6\u7b7e\u540d\u8bc1\u4e66\u7684\u5e8f\u5217\u53f7\u5931\u8d25", e);
            return "";
        }
    }

    public static String getEncryptCertId() {
        if (null == encryptCert) {
            CertUtil.initEncryptCert();
        }
        return encryptCert.getSerialNumber().toString();
    }

    public static PublicKey getSignPublicKey() {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            Certificate cert = keyStore.getCertificate(keyAlias);
            PublicKey pubkey = cert.getPublicKey();
            return pubkey;
        }
        catch (Exception e) {
            LogUtil.writeErrorLog(e.toString());
            return null;
        }
    }

    public static KeyStore getKeyInfo(String pfxkeyfile, String keypwd, String type) {
        try {
            KeyStore ks = null;
            if ("JKS".equals(type)) {
                ks = KeyStore.getInstance(type);
            } else if ("PKCS12".equals(type)) {
                Security.addProvider((Provider)new BouncyCastleProvider());
                ks = KeyStore.getInstance(type, "BC");
            }
            FileInputStream fis = new FileInputStream(pfxkeyfile);
            char[] nPassword = null;
            nPassword = null == keypwd || "".equals(keypwd.trim()) ? null : keypwd.toCharArray();
            ks.load(fis, nPassword);
            fis.close();
            return ks;
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u8bfb\u53d6\u79c1\u94a5\u8bc1\u4e66\u5931\u8d25", e);
            if (e instanceof KeyStoreException && "PKCS12".equals(type)) {
                Security.removeProvider("BC");
            }
            return null;
        }
    }

    public static String getCertIdByCertPath(String path, String pwd, String certTp) {
        KeyStore ks = CertUtil.getKeyInfo(path, pwd, certTp);
        if (null == ks) {
            return "";
        }
        try {
            Enumeration<String> aliasenum = ks.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)ks.getCertificate(keyAlias);
            return cert.getSerialNumber().toString();
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u83b7\u53d6\u7b7e\u540d\u8bc1\u4e66\u7684\u5e8f\u5217\u53f7\u5931\u8d25", e);
            return "";
        }
    }

    public static Map<String, X509Certificate> getCertMap() {
        return certMap;
    }

    public static void setCertMap(Map<String, X509Certificate> certMap) {
        CertUtil.certMap = certMap;
    }

    public static void main(String[] args) {
        System.out.println(CertUtil.getCertIdByCertPath("c://106660149170027_000000.pfx", "000000", "PKCS12"));
    }

    static {
        CertUtil.init();
    }

    static class CerFilter
    implements FilenameFilter {
        CerFilter() {
        }

        public boolean isCer(String name) {
            return name.toLowerCase().endsWith(".cer");
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.isCer(name);
        }
    }
}

