/*
 * Decompiled with CFR 0.152.
 */
package com.unionpay.mpi;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtil {
    private static final Logger GATELOG = LoggerFactory.getLogger((String)"mpiLog");
    private static final Logger GATELOG_ERROR = LoggerFactory.getLogger((String)"mpiLogError");
    private static final Logger GATELOG_MESSAGE = LoggerFactory.getLogger((String)"mpiLogMessage");
    static final String LOG_STRING_REQ_MSG_BEGIN = "============================== MPI REQ MSG BEGIN ==============================";
    static final String LOG_STRING_REQ_MSG_END = "==============================  MPI REQ MSG END  ==============================";
    static final String LOG_STRING_RSP_MSG_BEGIN = "============================== MPI RSP MSG BEGIN ==============================";
    static final String LOG_STRING_RSP_MSG_END = "==============================  MPI RSP MSG END  ==============================";

    public static void writeLog(String cont) {
        GATELOG.info(cont);
    }

    public static void writeLog(String cont, String frameId) {
        GATELOG.info("[" + frameId + "]" + cont);
    }

    public static void writeErrorLog(String cont) {
        GATELOG_ERROR.error(cont);
    }

    public static void writeErrorLog(String cont, String frameId) {
        GATELOG_ERROR.error("[" + frameId + "]" + cont);
    }

    public static void writeErrorLog(String cont, Throwable ex) {
        GATELOG_ERROR.error(cont, ex);
    }

    public static void writeErrorLog(String cont, String frameId, Throwable ex) {
        GATELOG_ERROR.error("[" + frameId + "]" + cont, ex);
    }

    public static void writeMessage(String msg) {
        GATELOG_MESSAGE.info(msg);
    }

    public static void printRequestLog(Map<String, String> reqParam) {
        LogUtil.writeMessage(LOG_STRING_REQ_MSG_BEGIN);
        for (Map.Entry<String, String> en : reqParam.entrySet()) {
            LogUtil.writeMessage("[" + en.getKey() + "] = [" + en.getValue() + "]");
        }
        LogUtil.writeMessage(LOG_STRING_REQ_MSG_END);
    }

    public static void printResponseLog(String res) {
        LogUtil.writeMessage(LOG_STRING_RSP_MSG_BEGIN);
        LogUtil.writeMessage(res);
        LogUtil.writeMessage(LOG_STRING_RSP_MSG_END);
    }

    public static void trace(String cont) {
        if (GATELOG.isTraceEnabled()) {
            GATELOG.trace(cont);
        }
    }

    public static void debug(String cont) {
        if (GATELOG.isDebugEnabled()) {
            GATELOG.debug(cont);
        }
    }
}

