/*
 * Decompiled with CFR 0.152.
 */
package com.unionpay.mpi;

import com.unionpay.mpi.MpiUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class MpiConfig {
    public static String FILE_NAME = "mpi.properties";
    private String frontRequestUrl;
    private String backRequestUrl;
    private String singleQueryUrl;
    private String batchQueryUrl;
    private String batchTransUrl;
    private String fileTransUrl;
    private String signCertPath;
    private String signCertPwd;
    private String signCertType;
    private String encryptCertPath;
    private String validateCertPath;
    private String validateCertDir;
    private String signCertDir;
    private String cbFrontRequestUrl;
    private String cbBackRequestUrl;
    public static final String MPI_FRONT_URL = "mpi.frontTransUrl";
    public static final String MPI_BACK_URL = "mpi.backTransUrl";
    public static final String MPI_SIGNQ_URL = "mpi.singleQueryUrl";
    public static final String MPI_BATQ_URL = "mpi.batchQueryUrl";
    public static final String MPI_BATTRANS_URL = "mpi.batchTransUrl";
    public static final String MPI_FILETRANS_URL = "mpi.fileTransUrl";
    public static final String MPI_CB_FRONT_URL = "mpi.cbFrontTransUrl";
    public static final String MPI_CB_BACK_URL = "mpi.cbBackTransUrl";
    public static final String MPI_SIGNCERT_PATH = "mpi.signCert.path";
    public static final String MPI_SIGNCERT_PWD = "mpi.signCert.pwd";
    public static final String MPI_SIGNCERT_TYPE = "mpi.signCert.type";
    public static final String MPI_ENCRYPTCERT_PATH = "mpi.encryptCert.path";
    public static final String MPI_VALIDATECERT_PATH = "mpi.validateCert.path";
    public static final String MPI_VALIDATECERT_DIR = "mpi.validateCert.dir";
    public static final String MPI_CVN_ENC = "mpi.cvn2.enc";
    public static final String MPI_DATE_ENC = "mpi.date.enc";
    public static final String MPI_PAN_ENC = "mpi.pan.enc";
    public static final String MPI_SIGNCERT_DIR = "mpi.signCert.dir";
    private static MpiConfig config;
    private static Properties properties;

    private MpiConfig() {
    }

    public static MpiConfig getConfig() {
        if (null == config) {
            config = new MpiConfig();
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPropertiesFromPath(String rootPath) {
        File file = new File(rootPath + File.separator + FILE_NAME);
        FileInputStream in = null;
        if (file.exists()) {
            try {
                in = new FileInputStream(file);
                properties = new Properties();
                properties.load(in);
                this.loadProperties(properties);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (null != in) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            System.out.println(rootPath + FILE_NAME + "\u4e0d\u5b58\u5728,\u52a0\u8f7d\u53c2\u6570\u5931\u8d25");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPropertiesFromSrc() {
        InputStream in = null;
        try {
            in = MpiConfig.class.getClassLoader().getResourceAsStream(FILE_NAME);
            if (null != in) {
                properties = new Properties();
                properties.load(in);
            }
            this.loadProperties(properties);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void loadProperties(Properties pro) {
        String value = pro.getProperty(MPI_FRONT_URL);
        if (!MpiUtil.isEmpty(value)) {
            this.frontRequestUrl = value.trim();
        }
        if (!MpiUtil.isEmpty(value = pro.getProperty(MPI_BACK_URL))) {
            this.backRequestUrl = value.trim();
        }
        if (!MpiUtil.isEmpty(value = pro.getProperty(MPI_SIGNCERT_PATH))) {
            this.signCertPath = value.trim();
        }
        if (!MpiUtil.isEmpty(value = pro.getProperty(MPI_SIGNCERT_PWD))) {
            this.signCertPwd = value.trim();
        }
        if (!MpiUtil.isEmpty(value = pro.getProperty(MPI_SIGNCERT_TYPE))) {
            this.signCertType = value.trim();
        }
        if (!MpiUtil.isEmpty(value = pro.getProperty(MPI_ENCRYPTCERT_PATH))) {
            this.encryptCertPath = value.trim();
        }
        if (!MpiUtil.isEmpty(value = pro.getProperty(MPI_VALIDATECERT_PATH))) {
            this.validateCertPath = value.trim();
        }
        if (!MpiUtil.isEmpty(value = pro.getProperty(MPI_VALIDATECERT_DIR))) {
            this.validateCertDir = value.trim();
        }
        if (!MpiUtil.isEmpty(value = pro.getProperty(MPI_BATQ_URL))) {
            this.batchQueryUrl = value.trim();
        }
        if (!MpiUtil.isEmpty(value = pro.getProperty(MPI_BATTRANS_URL))) {
            this.batchTransUrl = value.trim();
        }
        if (!MpiUtil.isEmpty(value = pro.getProperty(MPI_FILETRANS_URL))) {
            this.fileTransUrl = value.trim();
        }
        if (!MpiUtil.isEmpty(value = pro.getProperty(MPI_SIGNQ_URL))) {
            this.singleQueryUrl = value.trim();
        }
        if (!MpiUtil.isEmpty(value = pro.getProperty(MPI_SIGNCERT_DIR))) {
            this.signCertDir = value.trim();
        }
        if (!MpiUtil.isEmpty(value = pro.getProperty(MPI_CB_FRONT_URL))) {
            this.cbFrontRequestUrl = value.trim();
        }
        if (!MpiUtil.isEmpty(value = pro.getProperty(MPI_CB_BACK_URL))) {
            this.cbBackRequestUrl = value.trim();
        }
    }

    public String getFrontRequestUrl() {
        return this.frontRequestUrl;
    }

    public void setFrontRequestUrl(String frontRequestUrl) {
        this.frontRequestUrl = frontRequestUrl;
    }

    public String getBackRequestUrl() {
        return this.backRequestUrl;
    }

    public void setBackRequestUrl(String backRequestUrl) {
        this.backRequestUrl = backRequestUrl;
    }

    public String getSignCertPath() {
        return this.signCertPath;
    }

    public void setSignCertPath(String signCertPath) {
        this.signCertPath = signCertPath;
    }

    public String getSignCertPwd() {
        return this.signCertPwd;
    }

    public void setSignCertPwd(String signCertPwd) {
        this.signCertPwd = signCertPwd;
    }

    public String getSignCertType() {
        return this.signCertType;
    }

    public void setSignCertType(String signCertType) {
        this.signCertType = signCertType;
    }

    public String getEncryptCertPath() {
        return this.encryptCertPath;
    }

    public void setEncryptCertPath(String encryptCertPath) {
        this.encryptCertPath = encryptCertPath;
    }

    public String getValidateCertPath() {
        return this.validateCertPath;
    }

    public void setValidateCertPath(String validateCertPath) {
        this.validateCertPath = validateCertPath;
    }

    public String getValidateCertDir() {
        return this.validateCertDir;
    }

    public void setValidateCertDir(String validateCertDir) {
        this.validateCertDir = validateCertDir;
    }

    public String getSingleQueryUrl() {
        return this.singleQueryUrl;
    }

    public void setSingleQueryUrl(String singleQueryUrl) {
        this.singleQueryUrl = singleQueryUrl;
    }

    public String getBatchQueryUrl() {
        return this.batchQueryUrl;
    }

    public void setBatchQueryUrl(String batchQueryUrl) {
        this.batchQueryUrl = batchQueryUrl;
    }

    public String getBatchTransUrl() {
        return this.batchTransUrl;
    }

    public void setBatchTransUrl(String batchTransUrl) {
        this.batchTransUrl = batchTransUrl;
    }

    public String getFileTransUrl() {
        return this.fileTransUrl;
    }

    public void setFileTransUrl(String fileTransUrl) {
        this.fileTransUrl = fileTransUrl;
    }

    public String getSignCertDir() {
        return this.signCertDir;
    }

    public void setSignCertDir(String signCertDir) {
        this.signCertDir = signCertDir;
    }

    public static Properties getProperties() {
        return properties;
    }

    public static void setProperties(Properties properties) {
        MpiConfig.properties = properties;
    }

    public String getCbFrontRequestUrl() {
        return this.cbFrontRequestUrl;
    }

    public void setCbFrontRequestUrl(String cbFrontRequestUrl) {
        this.cbFrontRequestUrl = cbFrontRequestUrl;
    }

    public String getCbBackRequestUrl() {
        return this.cbBackRequestUrl;
    }

    public void setCbBackRequestUrl(String cbBackRequestUrl) {
        this.cbBackRequestUrl = cbBackRequestUrl;
    }

    static {
        properties = null;
    }
}

