/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.core;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.Tuple;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.core.FlowExecutorHolder;
import com.yomahub.liteflow.core.FlowInitHook;
import com.yomahub.liteflow.enums.ChainExecuteModeEnum;
import com.yomahub.liteflow.enums.InnerChainTypeEnum;
import com.yomahub.liteflow.enums.ParseModeEnum;
import com.yomahub.liteflow.exception.ChainDuplicateException;
import com.yomahub.liteflow.exception.ChainEndException;
import com.yomahub.liteflow.exception.ChainNotFoundException;
import com.yomahub.liteflow.exception.ConfigErrorException;
import com.yomahub.liteflow.exception.CyclicDependencyException;
import com.yomahub.liteflow.exception.FlowExecutorNotInitException;
import com.yomahub.liteflow.exception.LiteFlowException;
import com.yomahub.liteflow.exception.MonitorFileInitErrorException;
import com.yomahub.liteflow.exception.MultipleParsersException;
import com.yomahub.liteflow.exception.NoAvailableSlotException;
import com.yomahub.liteflow.exception.NoMatchedRouteChainException;
import com.yomahub.liteflow.exception.RouteChainNotFoundException;
import com.yomahub.liteflow.exception.RouteELInvalidException;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.flow.LiteflowResponse;
import com.yomahub.liteflow.flow.element.Chain;
import com.yomahub.liteflow.flow.element.Node;
import com.yomahub.liteflow.flow.entity.CmpStep;
import com.yomahub.liteflow.flow.id.IdGeneratorHolder;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.monitor.MonitorFile;
import com.yomahub.liteflow.parser.base.FlowParser;
import com.yomahub.liteflow.parser.factory.FlowParserProvider;
import com.yomahub.liteflow.parser.spi.ParserClassNameSpi;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.DefaultContext;
import com.yomahub.liteflow.slot.Slot;
import com.yomahub.liteflow.spi.holder.ContextCmpInitHolder;
import com.yomahub.liteflow.spi.holder.PathContentParserHolder;
import com.yomahub.liteflow.thread.ExecutorHelper;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class FlowExecutor {
    private static final LFLog LOG = LFLoggerManager.getLogger(FlowExecutor.class);
    private static final String PREFIX_FORMAT_CONFIG_REGEX = "el_xml:|el_json:|el_yml:";
    private LiteflowConfig liteflowConfig;

    public FlowExecutor() {
        FlowExecutorHolder.setHolder(this);
        DataBus.init();
    }

    public FlowExecutor(LiteflowConfig liteflowConfig) {
        this.liteflowConfig = liteflowConfig;
        LiteflowConfigGetter.setLiteflowConfig(liteflowConfig);
        FlowExecutorHolder.setHolder(this);
        if (!liteflowConfig.getParseMode().equals((Object)ParseModeEnum.PARSE_ALL_ON_FIRST_EXEC)) {
            this.init(true);
        }
        DataBus.init();
    }

    public void init(boolean isStart) {
        ArrayList sourceRulePathList;
        String ruleSource;
        if (ObjectUtil.isNull((Object)this.liteflowConfig)) {
            throw new ConfigErrorException("config error, please check liteflow config property");
        }
        ContextCmpInitHolder.loadContextCmpInit().initCmp();
        if (isStart) {
            IdGeneratorHolder.init();
        }
        if (StrUtil.isBlank((CharSequence)(ruleSource = this.liteflowConfig.getRuleSource()))) {
            ServiceLoader<ParserClassNameSpi> loader = ServiceLoader.load(ParserClassNameSpi.class);
            Iterator<ParserClassNameSpi> it = loader.iterator();
            if (it.hasNext()) {
                ParserClassNameSpi parserClassNameSpi = it.next();
                ruleSource = "el_xml:" + parserClassNameSpi.getSpiClassName();
                this.liteflowConfig.setRuleSource(ruleSource);
            } else {
                return;
            }
        }
        if (ReUtil.contains((String)PREFIX_FORMAT_CONFIG_REGEX, (CharSequence)ruleSource)) {
            sourceRulePathList = ListUtil.toList((Object[])new String[]{ruleSource});
        } else {
            String afterHandleRuleSource = ruleSource.replace(" ", "");
            sourceRulePathList = ListUtil.toList((Object[])afterHandleRuleSource.split(",|;"));
        }
        FlowParser parser = null;
        HashSet<String> parserNameSet = new HashSet<String>();
        ArrayList<String> rulePathList = new ArrayList<String>();
        for (String path : sourceRulePathList) {
            try {
                parser = FlowParserProvider.lookup(path);
                parserNameSet.add(parser.getClass().getName());
                path = ReUtil.replaceAll((CharSequence)path, (String)PREFIX_FORMAT_CONFIG_REGEX, (String)"").replace("\\", "/");
                rulePathList.add(path);
                if (!BooleanUtil.isTrue((Boolean)this.liteflowConfig.isSupportMultipleType())) continue;
                parser.parseMain(ListUtil.toList((Object[])new String[]{path}));
            }
            catch (CyclicDependencyException e) {
                LOG.error(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                String errorMsg = StrUtil.format((CharSequence)"init flow executor cause error for path {},reason:{}", (Object[])new Object[]{path, e.getMessage()});
                LOG.error(e.getMessage(), e);
                throw new FlowExecutorNotInitException(errorMsg);
            }
        }
        if (BooleanUtil.isFalse((Boolean)this.liteflowConfig.isSupportMultipleType())) {
            if (parserNameSet.size() > 1) {
                String errorMsg = "cannot have multiple different parsers";
                LOG.error(errorMsg);
                throw new MultipleParsersException(errorMsg);
            }
            try {
                if (parser == null) {
                    throw new ConfigErrorException("parse error, please check liteflow config property");
                }
                parser.parseMain(rulePathList);
            }
            catch (CyclicDependencyException e) {
                LOG.error(e.getMessage(), e);
                LOG.error(e.getMessage());
                throw e;
            }
            catch (ChainDuplicateException e) {
                LOG.error(e.getMessage(), e);
                throw e;
            }
            catch (RouteELInvalidException e) {
                LOG.error(e.getMessage(), e);
                throw e;
            }
            catch (Exception e) {
                String errorMsg = StrUtil.format((CharSequence)"init flow executor cause error for path {},reason: {}", (Object[])new Object[]{rulePathList, e.getMessage()});
                LOG.error(e.getMessage(), e);
                throw new FlowExecutorNotInitException(errorMsg);
            }
        }
        if (StrUtil.isBlank((CharSequence)this.liteflowConfig.getRuleSourceExtData()) && MapUtil.isEmpty(this.liteflowConfig.getRuleSourceExtDataMap()) && FlowBus.getChainMap().isEmpty()) {
            String errMsg = StrUtil.format((CharSequence)"no valid rule config found in rule path [{}]", (Object[])new Object[]{this.liteflowConfig.getRuleSource()});
            throw new ConfigErrorException(errMsg);
        }
        if (isStart) {
            FlowInitHook.executeHook();
        }
        if (isStart && this.liteflowConfig.getEnableMonitorFile().booleanValue()) {
            try {
                this.addMonitorFilePaths(rulePathList);
                MonitorFile.getInstance().create();
            }
            catch (Exception e) {
                String errMsg = StrUtil.format((CharSequence)"file monitor init error for path:{}", (Object[])new Object[]{rulePathList});
                throw new MonitorFileInitErrorException(errMsg);
            }
        }
    }

    public void reloadRule() {
        long start = System.currentTimeMillis();
        this.init(false);
        LOG.info("reload rules takes {}ms", (Object)(System.currentTimeMillis() - start));
    }

    @Deprecated
    public void invoke(String chainId, Object param, Integer slotIndex) throws Exception {
        LiteflowResponse response = this.invoke2Resp(chainId, param, slotIndex, InnerChainTypeEnum.IN_SYNC);
        if (!response.isSuccess()) {
            throw response.getCause();
        }
    }

    @Deprecated
    public void invokeInAsync(String chainId, Object param, Integer slotIndex) throws Exception {
        LiteflowResponse response = this.invoke2Resp(chainId, param, slotIndex, InnerChainTypeEnum.IN_ASYNC);
        if (!response.isSuccess()) {
            throw response.getCause();
        }
    }

    public LiteflowResponse invoke2Resp(String chainId, Object param, Integer slotIndex) {
        return this.invoke2Resp(chainId, param, slotIndex, InnerChainTypeEnum.IN_SYNC);
    }

    public LiteflowResponse invoke2RespInAsync(String chainId, Object param, Integer slotIndex) {
        return this.invoke2Resp(chainId, param, slotIndex, InnerChainTypeEnum.IN_ASYNC);
    }

    @Deprecated
    public void invoke(String nodeId, Integer slotIndex) throws Exception {
        Node node = FlowBus.getNode(nodeId);
        node.execute(slotIndex);
    }

    public LiteflowResponse execute2Resp(String chainId) {
        return this.execute2Resp(chainId, (Object)null, DefaultContext.class);
    }

    public LiteflowResponse execute2Resp(String chainId, Object param) {
        return this.execute2Resp(chainId, param, DefaultContext.class);
    }

    public LiteflowResponse execute2Resp(String chainId, Object param, Class<?> ... contextBeanClazzArray) {
        return this.execute2Resp(chainId, param, (String)null, contextBeanClazzArray, (Object[])null);
    }

    public List<LiteflowResponse> executeRouteChain(Object param, Class<?> ... contextBeanClazzArray) {
        return this.executeWithRoute(null, param, null, contextBeanClazzArray, null);
    }

    public List<LiteflowResponse> executeRouteChain(String namespace, Object param, Class<?> ... contextBeanClazzArray) {
        return this.executeWithRoute(namespace, param, null, contextBeanClazzArray, null);
    }

    public LiteflowResponse execute2Resp(String chainId, Object param, Object ... contextBeanArray) {
        return this.execute2Resp(chainId, param, null, null, contextBeanArray);
    }

    public List<LiteflowResponse> executeRouteChain(Object param, Object ... contextBeanArray) {
        return this.executeWithRoute(null, param, null, null, contextBeanArray);
    }

    public List<LiteflowResponse> executeRouteChain(String namespace, Object param, Object ... contextBeanArray) {
        return this.executeWithRoute(namespace, param, null, null, contextBeanArray);
    }

    public LiteflowResponse execute2RespWithRid(String chainId, Object param, String requestId, Class<?> ... contextBeanClazzArray) {
        return this.execute2Resp(chainId, param, requestId, contextBeanClazzArray, null);
    }

    public List<LiteflowResponse> executeRouteChainWithRid(Object param, String requestId, Class<?> ... contextBeanClazzArray) {
        return this.executeWithRoute(null, param, requestId, contextBeanClazzArray, null);
    }

    public List<LiteflowResponse> executeRouteChainWithRid(String namespace, Object param, String requestId, Class<?> ... contextBeanClazzArray) {
        return this.executeWithRoute(namespace, param, requestId, contextBeanClazzArray, null);
    }

    public LiteflowResponse execute2RespWithRid(String chainId, Object param, String requestId, Object ... contextBeanArray) {
        return this.execute2Resp(chainId, param, requestId, null, contextBeanArray);
    }

    public List<LiteflowResponse> executeRouteChainWithRid(Object param, String requestId, Object ... contextBeanArray) {
        return this.executeWithRoute(null, param, requestId, null, contextBeanArray);
    }

    public List<LiteflowResponse> executeRouteChainWithRid(String namespace, Object param, String requestId, Object ... contextBeanArray) {
        return this.executeWithRoute(namespace, param, requestId, null, contextBeanArray);
    }

    public Future<LiteflowResponse> execute2Future(String chainId, Object param, Class<?> ... contextBeanClazzArray) {
        return ExecutorHelper.loadInstance().buildMainExecutor(this.liteflowConfig.getMainExecutorClass()).submit(() -> FlowExecutorHolder.loadInstance().execute2Resp(chainId, param, contextBeanClazzArray));
    }

    public Future<LiteflowResponse> execute2Future(String chainId, Object param, Object ... contextBeanArray) {
        return ExecutorHelper.loadInstance().buildMainExecutor(this.liteflowConfig.getMainExecutorClass()).submit(() -> FlowExecutorHolder.loadInstance().execute2Resp(chainId, param, contextBeanArray));
    }

    public Future<LiteflowResponse> execute2FutureWithRid(String chainId, Object param, String requestId, Class<?> ... contextBeanClazzArray) {
        return ExecutorHelper.loadInstance().buildMainExecutor(this.liteflowConfig.getMainExecutorClass()).submit(() -> FlowExecutorHolder.loadInstance().execute2RespWithRid(chainId, param, requestId, contextBeanClazzArray));
    }

    public Future<LiteflowResponse> execute2FutureWithRid(String chainId, Object param, String requestId, Object ... contextBeanArray) {
        return ExecutorHelper.loadInstance().buildMainExecutor(this.liteflowConfig.getMainExecutorClass()).submit(() -> FlowExecutorHolder.loadInstance().execute2RespWithRid(chainId, param, requestId, contextBeanArray));
    }

    @Deprecated
    public DefaultContext execute(String chainId, Object param) throws Exception {
        LiteflowResponse response = this.execute2Resp(chainId, param, DefaultContext.class);
        if (!response.isSuccess()) {
            throw response.getCause();
        }
        return (DefaultContext)response.getFirstContextBean();
    }

    private LiteflowResponse execute2Resp(String chainId, Object param, String requestId, Class<?>[] contextBeanClazzArray, Object[] contextBeanArray) {
        Slot slot = this.doExecute(chainId, param, requestId, contextBeanClazzArray, contextBeanArray, null, InnerChainTypeEnum.NONE, ChainExecuteModeEnum.BODY);
        return LiteflowResponse.newMainResponse(slot);
    }

    private List<LiteflowResponse> executeWithRoute(String namespace, Object param, String requestId, Class<?>[] contextBeanClazzArray, Object[] contextBeanArray) {
        List<Slot> slotList = this.doExecuteWithRoute(namespace, param, requestId, contextBeanClazzArray, contextBeanArray);
        return slotList.stream().map(LiteflowResponse::newMainResponse).collect(Collectors.toList());
    }

    private LiteflowResponse invoke2Resp(String chainId, Object param, Integer slotIndex, InnerChainTypeEnum innerChainType) {
        Slot slot = this.doExecute(chainId, param, null, null, null, slotIndex, innerChainType, ChainExecuteModeEnum.BODY);
        return LiteflowResponse.newInnerResponse(chainId, slot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Slot doExecute(String chainId, Object param, String requestId, Class<?>[] contextBeanClazzArray, Object[] contextBeanArray, Integer slotIndex, InnerChainTypeEnum innerChainType, ChainExecuteModeEnum chainExecuteModeEnum) {
        Slot slot;
        block40: {
            if (FlowBus.needInit()) {
                this.init(true);
            }
            if (innerChainType.equals((Object)InnerChainTypeEnum.NONE) && ObjectUtil.isNull((Object)slotIndex) && (slotIndex = ArrayUtil.isNotEmpty((Object[])contextBeanClazzArray) ? Integer.valueOf(DataBus.offerSlotByClass(ListUtil.toList((Object[])contextBeanClazzArray))) : Integer.valueOf(DataBus.offerSlotByBean(ListUtil.toList((Object[])contextBeanArray)))) == -1) {
                throw new NoAvailableSlotException("there is no available slot");
            }
            slot = DataBus.getSlot(slotIndex);
            if (ObjectUtil.isNull((Object)slot)) {
                throw new NoAvailableSlotException(StrUtil.format((CharSequence)"the slot[{}] is not exist", (Object[])new Object[]{slotIndex}));
            }
            if (StrUtil.isNotBlank((CharSequence)requestId)) {
                slot.putRequestId(requestId);
                LFLoggerManager.setRequestId(requestId);
            } else if (StrUtil.isBlank((CharSequence)slot.getRequestId())) {
                slot.generateRequestId();
                LFLoggerManager.setRequestId(slot.getRequestId());
                LOG.info("requestId has generated");
            }
            if (innerChainType.equals((Object)InnerChainTypeEnum.NONE)) {
                LOG.info("slot[{}] offered", (Object)slotIndex);
            }
            if (!innerChainType.equals((Object)InnerChainTypeEnum.NONE)) {
                slot.removeSubException(chainId);
                slot.addSubChain(chainId);
            }
            if (ObjectUtil.isNotNull((Object)param)) {
                if (innerChainType.equals((Object)InnerChainTypeEnum.NONE)) {
                    slot.setRequestData(param);
                } else if (innerChainType.equals((Object)InnerChainTypeEnum.IN_SYNC)) {
                    slot.setChainReqData(chainId, param);
                } else if (innerChainType.equals((Object)InnerChainTypeEnum.IN_ASYNC)) {
                    slot.setChainReqData2Queue(chainId, param);
                }
            }
            Chain chain = null;
            try {
                chain = FlowBus.getChain(chainId);
                if (ObjectUtil.isNull((Object)chain)) {
                    String errorMsg = StrUtil.format((CharSequence)"couldn't find chain with the id[{}]", (Object[])new Object[]{chainId});
                    throw new ChainNotFoundException(errorMsg);
                }
                if (chainExecuteModeEnum.equals((Object)ChainExecuteModeEnum.BODY)) {
                    chain.execute(slotIndex);
                    break block40;
                }
                if (chainExecuteModeEnum.equals((Object)ChainExecuteModeEnum.ROUTE)) {
                    chain.executeRoute(slotIndex);
                    break block40;
                }
                throw new LiteFlowException("chain execute mode error");
            }
            catch (ChainEndException e) {
                if (ObjectUtil.isNotNull((Object)chain)) {
                    String warnMsg = StrUtil.format((CharSequence)"chain[{}] execute end on slot[{}]", (Object[])new Object[]{chain.getChainId(), slotIndex});
                    LOG.warn(warnMsg);
                }
            }
            catch (Exception e) {
                if (ObjectUtil.isNotNull((Object)chain)) {
                    String errMsg = StrUtil.format((CharSequence)"chain[{}] execute error on slot[{}]", (Object[])new Object[]{chain.getChainId(), slotIndex});
                    if (BooleanUtil.isTrue((Boolean)this.liteflowConfig.getPrintExecutionLog())) {
                        LOG.error(errMsg, e);
                    } else {
                        LOG.error(errMsg);
                    }
                } else if (BooleanUtil.isTrue((Boolean)this.liteflowConfig.getPrintExecutionLog())) {
                    LOG.error(e.getMessage(), e);
                } else {
                    LOG.error(e.getMessage());
                }
                if (innerChainType.equals((Object)InnerChainTypeEnum.NONE)) {
                    slot.setException(e);
                } else {
                    slot.setSubException(chainId, e);
                }
                Deque<CmpStep> executeSteps = slot.getExecuteSteps();
                try {
                    Iterator<CmpStep> cmpStepIterator = executeSteps.descendingIterator();
                    while (cmpStepIterator.hasNext()) {
                        CmpStep cmpStep = cmpStepIterator.next();
                        if (!cmpStep.getInstance().isRollback()) continue;
                        Node rollbackItem = cmpStep.getRefNode();
                        rollbackItem.rollback(slotIndex);
                    }
                }
                catch (Exception exception) {
                    LOG.error(exception.getMessage());
                }
                finally {
                    slot.printRollbackStep();
                }
            }
            finally {
                if (innerChainType.equals((Object)InnerChainTypeEnum.NONE)) {
                    slot.printStep();
                    DataBus.releaseSlot(slotIndex);
                    LFLoggerManager.removeRequestId();
                }
            }
        }
        return slot;
    }

    public LiteflowConfig getLiteflowConfig() {
        return this.liteflowConfig;
    }

    public void setLiteflowConfig(LiteflowConfig liteflowConfig) {
        this.liteflowConfig = liteflowConfig;
        LiteflowConfigGetter.setLiteflowConfig(liteflowConfig);
    }

    private void addMonitorFilePaths(List<String> pathList) throws Exception {
        List<String> fileAbsolutePath = PathContentParserHolder.loadContextAware().getFileAbsolutePath(pathList);
        MonitorFile.getInstance().addMonitorFilePaths(fileAbsolutePath);
    }

    private List<Slot> doExecuteWithRoute(String namespace, Object param, String requestId, Class<?>[] contextBeanClazzArray, Object[] contextBeanArray) {
        if (FlowBus.needInit()) {
            this.init(true);
        }
        if (StrUtil.isBlank((CharSequence)namespace)) {
            namespace = "default";
        }
        String finalNamespace = namespace;
        List routeChainList = FlowBus.getChainMap().values().stream().filter(chain -> chain.getNamespace().equals(finalNamespace)).filter(chain -> chain.getRouteItem() != null).collect(Collectors.toList());
        if (CollUtil.isEmpty(routeChainList)) {
            String errorMsg = StrUtil.format((CharSequence)"no route found for namespace[{}]", (Object[])new Object[]{finalNamespace});
            throw new RouteChainNotFoundException(errorMsg);
        }
        String finalRequestId = StrUtil.isBlank((CharSequence)requestId) ? IdGeneratorHolder.getInstance().generate() : requestId;
        ArrayList<Tuple> routeTupleList = new ArrayList<Tuple>();
        for (Chain routeChain : routeChainList) {
            CompletableFuture<Slot> f = CompletableFuture.supplyAsync(() -> this.doExecute(routeChain.getChainId(), param, finalRequestId, contextBeanClazzArray, contextBeanArray, null, InnerChainTypeEnum.NONE, ChainExecuteModeEnum.ROUTE));
            routeTupleList.add(new Tuple(new Object[]{routeChain, f}));
        }
        CompletableFuture<Void> resultRouteCf = CompletableFuture.allOf(routeTupleList.stream().map(tuple -> (CompletableFuture)tuple.get(1)).collect(Collectors.toList()).toArray(new CompletableFuture[0]));
        try {
            resultRouteCf.get();
        }
        catch (Exception e) {
            throw new LiteFlowException("There is An error occurred while executing the route.", e);
        }
        List matchedRouteChainList = routeTupleList.stream().filter(tuple -> {
            try {
                CompletableFuture f = (CompletableFuture)tuple.get(1);
                Slot slot = (Slot)f.get();
                return BooleanUtil.isTrue((Boolean)slot.getRouteResult());
            }
            catch (Exception e) {
                return false;
            }
        }).map(tuple -> (Chain)tuple.get(0)).collect(Collectors.toList());
        if (CollUtil.isEmpty(matchedRouteChainList)) {
            throw new NoMatchedRouteChainException("there is no matched route chain");
        }
        ArrayList<CompletableFuture<Slot>> executeChainCfList = new ArrayList<CompletableFuture<Slot>>();
        for (Chain chain2 : matchedRouteChainList) {
            CompletableFuture<Slot> cf = CompletableFuture.supplyAsync(() -> this.doExecute(chain2.getChainId(), param, finalRequestId, contextBeanClazzArray, contextBeanArray, null, InnerChainTypeEnum.NONE, ChainExecuteModeEnum.BODY));
            executeChainCfList.add(cf);
        }
        CompletableFuture<Void> resultChainCf = CompletableFuture.allOf(executeChainCfList.toArray(new CompletableFuture[0]));
        try {
            resultChainCf.get();
        }
        catch (Exception e) {
            throw new LiteFlowException("There is An error occurred while executing the matched chain.", e);
        }
        List<Slot> resultSlotList = executeChainCfList.stream().map(slotCompletableFuture -> {
            try {
                return (Slot)slotCompletableFuture.get();
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        LOG.info("chain namespace:[{}], total size:[{}], matched size:[{}]", namespace, routeChainList.size(), resultSlotList.size());
        return resultSlotList;
    }
}

