/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.util;

import com.qianjiang.util.MyLogger;
import com.qianjiang.utils.HexUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Util {
    private static final String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    public static final MyLogger LOGGER = new MyLogger(MD5Util.class);

    private MD5Util() {
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuilder resultSb = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            resultSb.append(MD5Util.byteToHexString(b[i]));
        }
        return resultSb.toString();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n += 256;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }

    public static String MD5Encode(String origin, String charsetname) {
        String resultString = null;
        try {
            resultString = new String(origin);
            MessageDigest md = MessageDigest.getInstance("MD5");
            resultString = charsetname == null || "".equals(charsetname) ? MD5Util.byteArrayToHexString(md.digest(resultString.getBytes())) : MD5Util.byteArrayToHexString(md.digest(resultString.getBytes(charsetname)));
        }
        catch (Exception exception) {
            LOGGER.error("" + exception);
            resultString = null;
        }
        return resultString;
    }

    public static String md5Hex(String data) {
        return HexUtil.toHexString(MD5Util.md5(data, null));
    }

    public static byte[] md5(String data, String charset) {
        if (charset == null) {
            return MD5Util.md5(data.getBytes());
        }
        try {
            return MD5Util.md5(data.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.info(e);
            return null;
        }
    }

    public static byte[] md5(byte[] data) {
        return MD5Util.getDigest().digest(data);
    }

    static MessageDigest getDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

