/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.report.util;

import com.qianjiang.util.MyLogger;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil
implements Serializable {
    private static final MyLogger LOGGER = new MyLogger(DateUtil.class);
    private static final String LOGGERINFO1 = "\u65e5\u671f\u5904\u7406\u5931\u8d25:";
    private static final long MILLISECONDS_PER_DAY = 86400000L;

    private DateUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String addOneDay(String strDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String date = null;
        try {
            SimpleDateFormat simpleDateFormat = sdf;
            synchronized (simpleDateFormat) {
                Long mills = sdf.parse(strDate).getTime();
                date = sdf.format(new Date(mills + 86400000L));
            }
        }
        catch (ParseException e) {
            LOGGER.error(LOGGERINFO1, e);
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String subOneDay(String strDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String date = null;
        try {
            SimpleDateFormat simpleDateFormat = sdf;
            synchronized (simpleDateFormat) {
                Long mills = sdf.parse(strDate).getTime();
                date = sdf.format(new Date(mills - 86400000L));
            }
        }
        catch (ParseException e) {
            LOGGER.error(LOGGERINFO1, e);
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDays(String startDate, String endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            SimpleDateFormat simpleDateFormat = sdf;
            synchronized (simpleDateFormat) {
                Long days = (sdf.parse(endDate).getTime() - sdf.parse(startDate).getTime()) / 86400000L;
                return days.intValue();
            }
        }
        catch (ParseException e) {
            LOGGER.error(LOGGERINFO1 + e.getLocalizedMessage());
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String addSomeDays(String startDate, int days) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            SimpleDateFormat simpleDateFormat = sdf;
            synchronized (simpleDateFormat) {
                return sdf.format(new Date(sdf.parse(startDate).getTime() + (long)days * 86400000L));
            }
        }
        catch (ParseException e) {
            LOGGER.error(LOGGERINFO1 + e.getLocalizedMessage());
            return null;
        }
    }

    public static int getDayOfMonth(String date) {
        return Integer.parseInt(date.split("-")[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDateOfLastMonth(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            SimpleDateFormat simpleDateFormat = sdf;
            synchronized (simpleDateFormat) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(sdf.parse(date));
                calendar.add(2, -1);
                return sdf.format(calendar.getTime());
            }
        }
        catch (ParseException e) {
            LOGGER.error(LOGGERINFO1 + e.getLocalizedMessage());
            return null;
        }
    }

    public static String getDateOfLastNMonth(String date, int n) {
        int nNew;
        String dateNew = date;
        for (nNew = n; nNew > 0; --nNew) {
            dateNew = DateUtil.getDateOfLastMonth(dateNew);
        }
        if (nNew == 0) {
            Calendar ca = Calendar.getInstance();
            ca.setTime(DateUtil.stringToDate(dateNew));
            int lastDay = ca.getActualMaximum(5);
            Date lastDate = ca.getTime();
            lastDate.setDate(lastDay);
            dateNew = DateUtil.dateToString(lastDate);
        }
        return dateNew;
    }

    public static String getLastCountDate(String currDate, String[] countDates) {
        String dateOfLastMonth = DateUtil.getDateOfLastMonth(currDate);
        int dayOfLastMonth = DateUtil.getDayOfMonth(currDate);
        String result = null;
        if (countDates.length == 1) {
            result = dateOfLastMonth;
        } else if (countDates[0].equals(dayOfLastMonth + "")) {
            result = dateOfLastMonth.substring(0, dateOfLastMonth.lastIndexOf("-")) + "-" + countDates[countDates.length - 1];
        } else {
            for (int i = 0; i < countDates.length; ++i) {
                if (!countDates[i].equals(dayOfLastMonth + "")) continue;
                result = currDate.substring(0, currDate.lastIndexOf("-")) + "-" + countDates[i - 1];
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date stringToDate(String strDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            SimpleDateFormat simpleDateFormat = sdf;
            synchronized (simpleDateFormat) {
                return sdf.parse(strDate);
            }
        }
        catch (ParseException e) {
            LOGGER.error(LOGGERINFO1 + e.getLocalizedMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dateToString(Date date) {
        SimpleDateFormat sdf;
        SimpleDateFormat simpleDateFormat = sdf = new SimpleDateFormat("yyyy-MM-dd");
        synchronized (simpleDateFormat) {
            return sdf.format(date);
        }
    }
}

