/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.shoppingcart.service.impl;

import com.qianjiang.coupon.bean.Coupon;
import com.qianjiang.customer.bean.CustomerAddress;
import com.qianjiang.goods.bean.GoodsDetailBean;
import com.qianjiang.shoppingcart.bean.ShopCarUtil;
import com.qianjiang.shoppingcart.bean.ShoppingCart;
import com.qianjiang.shoppingcart.service.ShoppingCartService;
import com.qianjiang.system.bean.ShoppingCartWareUtil;
import com.qianjiang.util.CollectionUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.yqbsoft.laser.html.common.send.PostParamMap;
import com.yqbsoft.laser.html.common.send.SupperFacade;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="ShoppingCartService")
public class ShoppingCartServiceImpl
extends SupperFacade
implements ShoppingCartService {
    private static final MyLogger LOGGER = new MyLogger(ShoppingCartServiceImpl.class);
    private static final String CUSTOMERID = "customerId";
    private static final String MALLMID = "_mall_mId";
    private static final String DISTINCTID = "distinctId";
    private static final String MALLSHOPCAR = "_mall_store_shopcar";
    private static final String MALLSHOPSTATUS = "_mall_shopstatus";
    private static final String PROINFO = "110012";

    @Override
    public int delShoppingCartById(Long shoppingCartId, Long goodsInfoId, HttpServletRequest request, HttpServletResponse response) {
        int result = 0;
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        try {
            if (customerId != null) {
                PostParamMap pmap = new PostParamMap("od.shoppingcart.ShoppingCartService.delShoppingCartById");
                pmap.putParam("shoppingCartId", (Object)shoppingCartId);
                pmap.putParam("goodsInfoId", (Object)goodsInfoId);
                pmap.putParam(CUSTOMERID, (Object)customerId);
                return (Integer)this.htmlIBaseService.senReObject(pmap, Integer.class);
            }
            this.delCookShopCar(goodsInfoId, request, response);
            result = 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("pc\u7aef\u4e1a\u52a1\u5c42\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1\u5931\u8d25" + e.getMessage(), e);
        }
        return result;
    }

    @Override
    public int changeShoppingCartById(Long shoppingCartId, Long num) {
        PostParamMap pmap = new PostParamMap("od.shoppingcart.ShoppingCartService.changeShoppingCartById");
        pmap.putParam("shoppingCartId", (Object)shoppingCartId);
        pmap.putParam("num", (Object)num);
        return (Integer)this.htmlIBaseService.senReObject(pmap, Integer.class);
    }

    @Override
    public int changeShoppingCartMarket(Long shoppingCartId, Long marketingActivityId, HttpServletRequest request, HttpServletResponse response) {
        int result = 0;
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        try {
            if (customerId != null) {
                PostParamMap pmap = new PostParamMap("od.site.ShoppingCartService.changeShoppingCartMarketNew");
                pmap.putParam("shoppingCartId", (Object)shoppingCartId);
                pmap.putParam("marketingActivityId", (Object)marketingActivityId);
                pmap.putParam(CUSTOMERID, (Object)customerId);
                return (Integer)this.htmlIBaseService.senReObject(pmap, Integer.class);
            }
            Long marketingId = 0L;
            Long goodsGroupId = 0L;
            Cookie[] cookies = request.getCookies();
            StringBuilder newMid = new StringBuilder();
            if (null != cookies) {
                for (Cookie cookie : cookies) {
                    if (cookie == null || !MALLMID.equals(cookie.getName()) || cookie.getValue() == null || "".equals(cookie.getValue())) continue;
                    String[] mIds = cookie.getValue().split("-");
                    for (int j = 0; j < mIds.length; ++j) {
                        String[] mid = mIds[j].split("e");
                        if (mid[0] == null) continue;
                        if (mid[0].equals(shoppingCartId.toString())) {
                            newMid.append(shoppingCartId);
                            newMid.append("e");
                            newMid.append(marketingId);
                            newMid.append("e");
                            newMid.append(marketingActivityId);
                            newMid.append("e");
                            newMid.append(goodsGroupId);
                            newMid.append("e");
                            newMid.append("1");
                            newMid.append("-");
                            continue;
                        }
                        newMid.append(mIds[j]);
                        newMid.append("-");
                    }
                }
                Cookie cookie = new Cookie(MALLMID, newMid.toString());
                cookie.setMaxAge(1296000);
                cookie.setPath("/");
                response.addCookie(cookie);
                result = 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("pc\u7aef\u4e1a\u52a1\u5c42\u4fee\u6539\u5546\u54c1\u4f18\u60e0\u5931\u8d25" + e.getMessage());
        }
        return result;
    }

    @Override
    public List<Coupon> getUsedCouponlist(HttpServletRequest request, Long[] box) {
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        PostParamMap pmap = new PostParamMap("od.shoppingcart.ShoppingCartService.getUsedCouponlist");
        pmap.putParamToJson(CUSTOMERID, (Object)customerId);
        pmap.putParam("box", (Object)box);
        return this.htmlIBaseService.getForList(pmap, Coupon.class);
    }

    @Override
    public Map<String, Object> getPayorderThirdPriceMap(Long businessId, List<ShoppingCart> shopdata, Long distinctId) {
        PostParamMap pmap = new PostParamMap("od.shoppingcart.ShoppingCartService.getPayorderThirdPriceMap");
        pmap.putParam("businessId", (Object)businessId);
        pmap.putParamToJson("shopdata", shopdata);
        pmap.putParam(DISTINCTID, (Object)distinctId);
        return (Map)this.htmlIBaseService.senReObject(pmap, Map.class);
    }

    @Override
    public Map<String, Object> getEveryThirdPriceMap(Long businessId, List<ShoppingCart> shopdata, Long distinctId) {
        PostParamMap pmap = new PostParamMap("od.shoppingcart.ShoppingCartService.getEveryThirdPriceMap");
        pmap.putParam("businessId", (Object)businessId);
        pmap.putParamToJson("shopdata", shopdata);
        pmap.putParam(DISTINCTID, (Object)distinctId);
        return (Map)this.htmlIBaseService.senReObject(pmap, Map.class);
    }

    @Override
    public Map<String, Object> newsubOrder(HttpServletRequest request, Long[] box, CustomerAddress customerAddress, String[] boxgift) {
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        PostParamMap pmap = new PostParamMap("od.shoppingcart.ShoppingCartService.newsubOrder");
        pmap.putParam(CUSTOMERID, (Object)customerId);
        pmap.putParamToJson("box", (Object)box);
        pmap.putParamToJson("customerAddress", (Object)customerAddress);
        pmap.putParamToJson("boxgift", (Object)boxgift);
        return (Map)this.htmlIBaseService.senReObject(pmap, Map.class);
    }

    @Override
    public Map<String, Object> subOrder(HttpServletRequest request, Long[] box, Long[] marketingId, Long[] thirdId, ShoppingCartWareUtil wareUtil, Long customerId) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        Long dId = (Long)requestMap.get(DISTINCTID);
        if (request.getSession().getAttribute(DISTINCTID) != null && !"".equals(request.getSession().getAttribute(DISTINCTID))) {
            String obj = request.getSession().getAttribute(DISTINCTID).toString();
            dId = Long.parseLong(obj);
        }
        requestMap.put(DISTINCTID, dId);
        requestMap.put("chProvince", request.getSession().getAttribute("chCity"));
        requestMap.put("chCity", request.getSession().getAttribute("chCity"));
        requestMap.put("chDistinct", request.getSession().getAttribute("chDistinct"));
        requestMap.put(CUSTOMERID, request.getSession().getAttribute(CUSTOMERID));
        PostParamMap pmap = new PostParamMap("od.shoppingcart.ShoppingCartService.subOrder");
        pmap.putParamToJson("requestMap", requestMap);
        pmap.putParamToJson("box", (Object)box);
        pmap.putParamToJson("marketingId", (Object)marketingId);
        pmap.putParamToJson("thirdId", (Object)thirdId);
        pmap.putParamToJson("cartWareUtil", (Object)wareUtil);
        pmap.putParam(CUSTOMERID, (Object)customerId);
        return (Map)this.htmlIBaseService.senReObject(pmap, Map.class);
    }

    @Override
    public int addShoppingCart(ShoppingCart shoppingCart, HttpServletRequest request, HttpServletResponse response) {
        int result = 0;
        try {
            Long customerId = shoppingCart.getCustomerId();
            result = null != customerId ? this.addCart(shoppingCart, customerId) : this.addCart2Cookie(shoppingCart, request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("pc\u7aef\u4e1a\u52a1\u5c42\u6dfb\u52a0\u8d2d\u7269\u8f66\u5931\u8d25" + e.getMessage(), e);
        }
        return result;
    }

    @Override
    public int buyNow(HttpServletRequest req, HttpServletResponse resp, ShoppingCart shoppingCart) {
        int result = 0;
        try {
            PostParamMap pmap = new PostParamMap("od.shoppingcart.ShoppingCartService.buyNow");
            pmap.putParamToJson("shoppingCart", (Object)shoppingCart);
            this.htmlIBaseService.sendMesReBean(pmap);
            result = this.addShoppingCart(shoppingCart, req, resp);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("pc\u7aef\u4e1a\u52a1\u5c42\u7acb\u5373\u8d2d\u4e70\u5931\u8d25" + e.getMessage(), e);
        }
        return result;
    }

    @Override
    public List<ShoppingCart> searchByProduct(Long[] box) {
        PostParamMap pmap = new PostParamMap("od.shoppingcart.ShoppingCartService.searchByProduct");
        pmap.putParam("box", (Object)box);
        return this.htmlIBaseService.getForList(pmap, ShoppingCart.class);
    }

    @Override
    public List<ShoppingCart> findProductListByBoxId(Long[] box) {
        PostParamMap pmap = new PostParamMap("od.shoppingcart.ShoppingCartService.findProductListByBoxId");
        pmap.putParamToJson("box", (Object)box);
        return this.htmlIBaseService.getForList(pmap, ShoppingCart.class);
    }

    @Override
    public int deleteShoppingCartByIds(HttpServletRequest request, Long[] shoppingCartId) {
        PostParamMap pmap = new PostParamMap("od.shoppingcart.ShoppingCartService.deleteShoppingCartByIds");
        pmap.putParam("shoppingCartId", (Object)shoppingCartId);
        return (Integer)this.htmlIBaseService.senReObject(pmap, Integer.class);
    }

    @Override
    public List<ShopCarUtil> loadCookShopCar(HttpServletRequest request) {
        ArrayList<ShopCarUtil> list = new ArrayList<ShopCarUtil>();
        try {
            Cookie[] cookies = request.getCookies();
            if (null != cookies) {
                for (Cookie cookie : cookies) {
                    if (null == cookie || !MALLSHOPCAR.equals(cookie.getName()) || cookie.getValue() == null || "".equals(cookie.getValue())) continue;
                    String oldCar = URLDecoder.decode(cookie.getValue(), "utf-8");
                    oldCar = oldCar.substring(1, oldCar.length());
                    String[] cars = (oldCar = oldCar.substring(0, oldCar.length() - 1)).split("e,");
                    if (cars.length <= 0) continue;
                    for (String car1 : cars) {
                        String[] car = car1.split("-");
                        ShopCarUtil carUtil = new ShopCarUtil();
                        carUtil.setProductId(Long.parseLong(car[0]));
                        if (car[0].length() > 6 && PROINFO.equals(car[0].substring(0, 6))) {
                            carUtil.setFitId(Long.parseLong(car[0].substring(6, car[0].length())));
                        } else {
                            for (Cookie cook : cookies) {
                                if (cook == null || !MALLMID.equals(cook.getName()) || cook.getValue() == null || "".equals(cook.getValue())) continue;
                                String[] mIds = cook.getValue().split("-");
                                for (int j = 0; j < mIds.length; ++j) {
                                    String[] mid = mIds[j].split("e");
                                    if (mid[0] == null || !car[0].equals(mid[0])) continue;
                                    carUtil.setMarketId(Long.parseLong(mid[1]));
                                    carUtil.setMarketActiveId(Long.parseLong(mid[2]));
                                    carUtil.setGoodsGroupMarketingId(Long.parseLong(mid[3]));
                                    carUtil.setStatus(Long.parseLong(mid[4]));
                                }
                            }
                        }
                        String[] car2 = car[1].split("&");
                        carUtil.setGoodsNum(Integer.parseInt(car2[0]));
                        carUtil.setDistinctId(Long.parseLong(car2[1]));
                        list.add(carUtil);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u52a0\u8f7dcookie\u4e2d\u8d2d\u7269\u8f66\u4fe1\u606f\u5931\u8d25");
        }
        return list;
    }

    @Override
    public int loadCoodeShopping(Long custId, HttpServletRequest request) {
        PostParamMap pmap = new PostParamMap("od.shoppingcart.ShoppingCartService.loadCoodeShopping");
        List<ShopCarUtil> list = this.loadCookShopCar(request);
        pmap.putParam("custId", (Object)custId);
        pmap.putParamToJson("list", list);
        return (Integer)this.htmlIBaseService.senReObject(pmap, Integer.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delCookShopCar(Long productId, HttpServletRequest request, HttpServletResponse response) {
        int result = 0;
        Cookie[] cookies = request.getCookies();
        String oldCar = null;
        String[] cars = null;
        String[] car = null;
        Cookie cook = null;
        Cookie cookie2 = null;
        StringBuilder bufOldCar = new StringBuilder();
        StringBuilder bufNewMid = new StringBuilder();
        try {
            if (null != cookies) {
                for (Cookie cookie : cookies) {
                    if (null != cookie && MALLSHOPCAR.equals(cookie.getName()) && (oldCar = URLDecoder.decode(cookie.getValue(), "utf-8")).indexOf("," + productId + "-") != -1) {
                        oldCar = oldCar.substring(1, oldCar.length());
                        oldCar = oldCar.substring(0, oldCar.length() - 1);
                        cars = oldCar.split("e,");
                        oldCar = "";
                        for (int j = 0; j < cars.length; ++j) {
                            car = cars[j].split("-");
                            if (car[0].equals(productId.toString())) continue;
                            bufOldCar.append(oldCar);
                            bufOldCar.append(",");
                            bufOldCar.append(car[0]);
                            bufOldCar.append("-");
                            bufOldCar.append(car[1]);
                            bufOldCar.append("e");
                        }
                    }
                    if (cookie == null || !MALLMID.equals(cookie.getName()) || cookie.getValue() == null || "".equals(cookie.getValue())) continue;
                    String[] mIds = cookie.getValue().split("-");
                    for (int j = 0; j < mIds.length; ++j) {
                        String[] mid = mIds[j].split("e");
                        if (mid[0] == null || mid[0].equals("") || mid[0].equals(productId.toString()) || bufNewMid.toString().indexOf(mIds[j]) != -1) continue;
                        bufNewMid.append(mIds[j]);
                        if (j >= mIds.length - 1) continue;
                        bufNewMid.append("-");
                    }
                }
            }
            cook = new Cookie(MALLSHOPCAR, URLEncoder.encode(bufOldCar.toString(), "utf-8"));
            cook.setMaxAge(1296000);
            cook.setPath("/");
            response.addCookie(cook);
            cookie2 = new Cookie(MALLMID, URLEncoder.encode(bufNewMid.toString(), "utf-8"));
            cookie2.setMaxAge(1296000);
            cookie2.setPath("/");
            response.addCookie(cookie2);
            result = 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5220\u9664cookie\u4e2d\u8d2d\u7269\u8f66\u5546\u54c1\u5931\u8d25" + e.getMessage(), e);
        }
        finally {
            cook = null;
            cookie2 = null;
            cars = null;
            car = null;
            cookies = null;
            oldCar = null;
        }
        return result;
    }

    @Override
    public int changeShoppingCartOrderMarket(ShoppingCart cart) {
        PostParamMap pmap = new PostParamMap("od.shoppingcart.ShoppingCartService.changeShoppingCartOrderMarket");
        pmap.putParamToJson("cart", (Object)cart);
        return (Integer)this.htmlIBaseService.senReObject(pmap, Integer.class);
    }

    @Override
    public PageBean selectShoppingCart(HttpServletRequest request, ShoppingCartWareUtil cartWareUtil, PageBean pageBean, HttpServletResponse response) {
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        Object sessionStatus = request.getSession().getAttribute(MALLSHOPSTATUS);
        List<ShopCarUtil> list = this.loadCookShopCar(request);
        PostParamMap pmap = new PostParamMap("od.shoppingcart.ShoppingCartService.selectShoppingCart");
        pmap.putParam(CUSTOMERID, (Object)customerId);
        pmap.putParamToJson("list", list);
        pmap.putParamToJson("sessionStatus", sessionStatus);
        pmap.putParamToJson("cartWareUtil", (Object)cartWareUtil);
        pmap.putParamToJson("pb", (Object)pageBean);
        PageBean p = (PageBean)this.htmlIBaseService.senReObject(pmap, PageBean.class);
        if (p.getSessionStatus() != null) {
            request.getSession().setAttribute(MALLSHOPSTATUS, sessionStatus);
        }
        return p;
    }

    @Override
    public String changeShopStatus(Long shoppingId, String status, HttpServletRequest request, HttpServletResponse response) {
        Object obj = request.getSession().getAttribute(MALLSHOPSTATUS);
        String newStr = "";
        StringBuilder buf = new StringBuilder();
        if (obj != null) {
            String[] strs;
            for (String str : strs = obj.toString().split("-")) {
                String[] shopStatus = str.split("e");
                if (shopStatus[1].equals(shoppingId.toString())) {
                    buf.append(status);
                    buf.append("e");
                    buf.append(shoppingId);
                    buf.append("-");
                    buf.append(newStr);
                } else {
                    buf.append(str);
                    buf.append("-");
                }
                newStr = newStr + buf.toString();
            }
        }
        request.getSession().setAttribute(MALLSHOPSTATUS, (Object)newStr);
        return status;
    }

    @Override
    public String changeShopStatusByParam(Long[] shoppingId, String status, HttpServletRequest request, HttpServletResponse response) {
        StringBuilder newStr = new StringBuilder();
        for (Long id : shoppingId) {
            newStr.append(status);
            newStr.append("e");
            newStr.append(id);
            newStr.append("-");
        }
        request.getSession().setAttribute(MALLSHOPSTATUS, (Object)newStr);
        return status;
    }

    @Override
    public GoodsDetailBean forPurchasing(GoodsDetailBean goodsDetailBean, Long customerId) {
        PostParamMap pmap = new PostParamMap("od.shoppingcart.ShoppingCartService.forPurchasing");
        pmap.putParamToJson("goodsDetailBean", (Object)goodsDetailBean);
        pmap.putParam(CUSTOMERID, (Object)customerId);
        return (GoodsDetailBean)this.htmlIBaseService.senReObject(pmap, GoodsDetailBean.class);
    }

    @Override
    public BigDecimal calExpressPriceByThirdId(Long thirdId, Long cityId, List<ShoppingCart> cartList) {
        PostParamMap pmap = new PostParamMap("od.shoppingcart.ShoppingCartService.calExpressPriceByThirdId");
        pmap.putParam("thirdId", (Object)thirdId);
        pmap.putParam("cityId", (Object)cityId);
        pmap.putParamToJson("cartList", cartList);
        return (BigDecimal)this.htmlIBaseService.senReObject(pmap, BigDecimal.class);
    }

    @Override
    public Map<String, Object> getNewExpressPrice(Long cityId, List<Long> cartIds, Long cityInfoId) {
        PostParamMap pmap = new PostParamMap("od.shoppingcart.ShoppingCartService.getNewExpressPrice");
        pmap.putParam("cityId", (Object)cityId);
        pmap.putParamToJson("cartIds", cartIds);
        pmap.putParam("cityInfoId", (Object)cityInfoId);
        return (Map)this.htmlIBaseService.senReObject(pmap, Map.class);
    }

    @Override
    public List<ShoppingCart> getNobaoyouShoppingcarts(List<ShoppingCart> cartList, Long disId) {
        PostParamMap pmap = new PostParamMap("od.shoppingcart.ShoppingCartService.getNobaoyouShoppingcarts");
        pmap.putParamToJson("cartList", cartList);
        pmap.putParam("disId", (Object)disId);
        return this.htmlIBaseService.getForList(pmap, ShoppingCart.class);
    }

    @Override
    public Map<String, Object> shopCartMap(Long customerId, HttpServletRequest request, HttpServletResponse response) {
        List<ShopCarUtil> list = this.loadCookShopCar(request);
        PostParamMap pmap = new PostParamMap("od.shoppingcart.ShoppingCartService.shopCartMap");
        pmap.putParam(CUSTOMERID, (Object)customerId);
        pmap.putParamToJson("list", list);
        Map resMap = (Map)this.htmlIBaseService.senReObject(pmap, Map.class);
        if (resMap != null && resMap.get("removeShops") != null) {
            List tobeRemoveList = (List)resMap.get("removeShops");
            this.removeShopCartFromCookie(tobeRemoveList, request, response);
        }
        resMap.remove("removeShops");
        return resMap;
    }

    @Override
    public List<ShoppingCart> selectShoppingCartListByCustomerId(Long customerId) {
        PostParamMap pmap = new PostParamMap("od.shoppingcart.ShoppingCartService.selectShoppingCartListByCustomerId");
        pmap.putParam(CUSTOMERID, (Object)customerId);
        return this.htmlIBaseService.getForList(pmap, ShoppingCart.class);
    }

    @Override
    public boolean checkHasErrorProduct(Long[] box) {
        PostParamMap pmap = new PostParamMap("od.shoppingcart.ShoppingCartService.checkHasErrorProduct");
        pmap.putParamToJson("box", (Object)box);
        return (Boolean)this.htmlIBaseService.senReObject(pmap, Boolean.class);
    }

    @Override
    public Integer countCart(Long customerId) {
        PostParamMap pmap = new PostParamMap("od.shoppingcart.ShoppingCartService.countCart");
        pmap.putParam(CUSTOMERID, (Object)customerId);
        return (Integer)this.htmlIBaseService.senReObject(pmap, Integer.class);
    }

    @Override
    public Integer countCartInCookie(HttpServletRequest request, HttpServletResponse response) {
        PostParamMap pmap = new PostParamMap("od.shoppingcart.ShoppingCartService.countCartInCookie");
        List<ShopCarUtil> list = this.loadCookShopCar(request);
        pmap.putParamToJson("list", list);
        return (Integer)this.htmlIBaseService.senReObject(pmap, Integer.class);
    }

    private int addCart(ShoppingCart shoppingCart, Long custId) {
        PostParamMap pmap = new PostParamMap("od.site.ShoppingCartService.addCart");
        pmap.putParamToJson("shoppingCart", (Object)shoppingCart);
        pmap.putParam("custId", (Object)custId);
        return (Integer)this.htmlIBaseService.senReObject(pmap, Integer.class);
    }

    private int addCart2Cookie(ShoppingCart shoppingCart, HttpServletRequest request, HttpServletResponse response) {
        boolean result = false;
        String numStr = "";
        String cartStr = "";
        String mId = "";
        Long goodsInfoId = shoppingCart.getGoodsInfoId();
        Long districtId = shoppingCart.getDistinctId();
        List<Cookie> cookies = CollectionUtil.defaultList(request.getCookies());
        try {
            for (Cookie cookie : cookies) {
                String[] mIds;
                if (MALLSHOPCAR.equals(cookie.getName()) && !"".equals(cookie.getValue())) {
                    String goodsInfoIdStr;
                    cartStr = URLDecoder.decode(cookie.getValue(), "utf-8");
                    if (!cartStr.contains(goodsInfoIdStr = "," + goodsInfoId + "-")) continue;
                    int beginIndex = cartStr.indexOf(goodsInfoIdStr);
                    numStr = cartStr.substring(beginIndex, beginIndex + cartStr.substring(beginIndex, cartStr.length() - 1).indexOf("&"));
                    numStr = numStr.substring(numStr.indexOf("-") + 1, numStr.length());
                    String s2 = goodsInfoIdStr + numStr + "&" + districtId;
                    if (!(cartStr = cartStr.replace(s2 + "e", "")).contains(s2)) continue;
                    cartStr = cartStr.replace(s2, "");
                    continue;
                }
                if (!MALLMID.equals(cookie.getName()) || "".equals(cookie.getValue())) continue;
                for (String mId1 : mIds = cookie.getValue().split("-")) {
                    String[] mid = mId1.split("e");
                    if (mid[0] == null || !"".equals(mIds[0]) || mid[0].equals(goodsInfoId.toString())) continue;
                    mId = cookie.getValue();
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        PostParamMap pmap = new PostParamMap("od.shoppingcart.ShoppingCartService.addCart2Cookie");
        pmap.putParam("numStr", (Object)numStr);
        pmap.putParam("cartStr", (Object)cartStr);
        pmap.putParam("mId", (Object)mId);
        pmap.putParamToJson("shoppingCart", (Object)shoppingCart);
        Map resMap = (Map)this.htmlIBaseService.senReObject(pmap, Map.class);
        if (resMap != null && resMap.get("result").toString().equals("1")) {
            cartStr = resMap.get("cartStr").toString();
            mId = resMap.get("cartStr").toString();
            try {
                Cookie cook = new Cookie(MALLSHOPCAR, URLEncoder.encode(cartStr, "utf-8"));
                cook.setMaxAge(1296000);
                cook.setPath("/");
                response.addCookie(cook);
                Cookie cookie = new Cookie(MALLMID, mId);
                cookie.setMaxAge(1296000);
                cookie.setPath("/");
                response.addCookie(cookie);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return Integer.valueOf(resMap.get("result").toString());
    }

    private void removeShopCartFromCookie(List<ShopCarUtil> list, HttpServletRequest request, HttpServletResponse response) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (ShopCarUtil shopCarUtil : list) {
            try {
                this.delCookShopCar(shopCarUtil.getProductId(), request, response);
            }
            catch (Exception e) {
                LOGGER.error("delCookShopCar fail and id :" + shopCarUtil.getProductId());
            }
        }
    }

    @Override
    public Map<String, Object> newsubCardOrder(HttpServletRequest request, Long[] box, CustomerAddress customerAddress, String[] boxgift) {
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        PostParamMap pmap = new PostParamMap("od.shoppingcart.ShoppingCartService.newsubCardOrder");
        pmap.putParam(CUSTOMERID, (Object)customerId);
        pmap.putParamToJson("box", (Object)box);
        pmap.putParamToJson("customerAddress", (Object)customerAddress);
        pmap.putParamToJson("boxgift", (Object)boxgift);
        return (Map)this.htmlIBaseService.senReObject(pmap, Map.class);
    }
}

