/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.excel;

import com.qianjiang.goods.bean.ProductWare;
import com.qianjiang.goods.service.ProductWareService;
import com.qianjiang.util.MyLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExportGoodsList {
    private static final MyLogger LOGGER = new MyLogger(ExportGoodsList.class);

    private ExportGoodsList() {
    }

    public static void exportGoodsList(List<Object> goodsList, HttpServletResponse response) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet1 = wb.createSheet("\u5546\u54c1\u5217\u8868");
        sheet1.setColumnWidth(0, 6000);
        sheet1.setColumnWidth(1, 15000);
        sheet1.setColumnWidth(2, 6000);
        sheet1.setColumnWidth(3, 6000);
        sheet1.setColumnWidth(4, 6000);
        sheet1.setColumnWidth(5, 4000);
        sheet1.createFreezePane(6, 2);
        HSSFRow row1 = sheet1.createRow(0);
        sheet1.addMergedRegion(new CellRangeAddress(0, 0, 0, 5));
        HSSFCell cell1 = row1.createCell(0);
        HSSFCellStyle cenStyle = wb.createCellStyle();
        cenStyle.setAlignment((short)2);
        cell1.setCellStyle((CellStyle)cenStyle);
        cell1.setCellValue("\u5546\u54c1\u5217\u8868");
        HSSFRow row2 = sheet1.createRow(1);
        row2.createCell(0).setCellValue("\u5546\u54c1\u7f16\u53f7");
        row2.createCell(1).setCellValue("\u5546\u54c1\u540d\u79f0");
        row2.createCell(2).setCellValue("\u9500\u552e\u4ef7\u683c");
        row2.createCell(3).setCellValue("\u5546\u54c1\u72b6\u6001");
        row2.createCell(4).setCellValue("\u5546\u54c1\u5206\u7c7b");
        row2.createCell(5).setCellValue("\u5546\u54c1\u54c1\u724c");
        if (null != goodsList && !goodsList.isEmpty()) {
            for (int i = 0; i < goodsList.size(); ++i) {
                LinkedHashMap map = (LinkedHashMap)goodsList.get(i);
                HSSFRow tempRow = sheet1.createRow(2 + i);
                tempRow.createCell(0).setCellValue((String)map.get("goodsNo"));
                tempRow.createCell(1).setCellValue((String)map.get("goodsName"));
                tempRow.createCell(2).setCellValue(String.valueOf((Double)map.get("goodsPrice")));
                tempRow.createCell(3).setCellValue("1".equals((String)map.get("goodsAdded")) ? "\u4e0a\u67b6\u9500\u552e\u4e2d" : "\u4e0b\u67b6");
                tempRow.createCell(4).setCellValue(map.get("goodsCate") == null ? "" : (String)((LinkedHashMap)map.get("goodsCate")).get("catName"));
                tempRow.createCell(5).setCellValue(map.get("goodsBrand") == null ? "" : (String)((LinkedHashMap)map.get("goodsBrand")).get("brandName"));
            }
        }
        String filename = String.valueOf(System.currentTimeMillis()).concat(".xls");
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment;filename=" + filename);
        try {
            ServletOutputStream ouputStream = response.getOutputStream();
            wb.write((OutputStream)ouputStream);
            ouputStream.flush();
            ouputStream.close();
        }
        catch (IOException e) {
            LOGGER.error("\u5bfc\u51fa\u5546\u54c1\u5217\u8868\u9519\u8bef:" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportProductList(List<Object> productList, ProductWareService productWareService, HttpServletResponse response) {
        HSSFRow tempRow;
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment((short)2);
        HSSFSheet sheet1 = wb.createSheet("\u8d27\u54c1\u5217\u8868");
        sheet1.createFreezePane(255, 1);
        HSSFRow headRow = sheet1.createRow(0);
        headRow.createCell(0).setCellValue("\u8d27\u54c1\u7f16\u53f7");
        headRow.createCell(1).setCellValue("\u8d27\u54c1\u540d\u79f0");
        headRow.createCell(2).setCellValue("\u8d27\u54c1\u526f\u6807\u9898");
        headRow.createCell(3).setCellValue("\u5269\u4f59\u5e93\u5b58");
        headRow.createCell(4).setCellValue("\u9500\u552e\u4ef7\u683c");
        headRow.createCell(5).setCellValue("\u6210\u672c\u4ef7\u683c");
        headRow.createCell(6).setCellValue("\u5e02\u573a\u4ef7\u683c");
        headRow.createCell(7).setCellValue("\u8d27\u54c1\u72b6\u6001");
        if (null != productList && !productList.isEmpty()) {
            int i;
            LinkedHashMap product = (LinkedHashMap)productList.get(0);
            for (i = 0; i < ((List)product.get("specVo")).size(); ++i) {
                LinkedHashMap specVo = (LinkedHashMap)((List)product.get("specVo")).get(i);
                headRow.createCell(8 + i).setCellValue((String)((LinkedHashMap)specVo.get("spec")).get("specName"));
            }
            for (i = 0; i < productList.size(); ++i) {
                product = (LinkedHashMap)productList.get(i);
                tempRow = sheet1.createRow(1 + i);
                tempRow.createCell(0).setCellValue((String)product.get("goodsInfoItemNo"));
                tempRow.createCell(1).setCellValue((String)product.get("goodsInfoName"));
                tempRow.createCell(2).setCellValue((String)product.get("goodsInfoSubtitle"));
                List<ProductWare> productWareList = productWareService.queryAllInfoByProductId(Long.valueOf(String.valueOf(product.get("goodsInfoId"))));
                if (productWareList != null) {
                    if (productWareList.size() == 1) {
                        tempRow.createCell(3).setCellValue((double)productWareList.get(0).getWareStock().longValue());
                    } else {
                        StringBuilder proStr = new StringBuilder();
                        for (int j = 0; j < productWareList.size(); ++j) {
                            proStr.append(productWareList.get(j).getWareName());
                            proStr.append(":");
                            proStr.append(productWareList.get(j).getWareStock());
                            if (j >= productWareList.size() - 1) continue;
                            proStr.append(" - ");
                        }
                        tempRow.createCell(3).setCellValue(proStr.toString());
                    }
                }
                if (null != product.get("goodsInfoPreferPrice")) {
                    tempRow.createCell(4).setCellValue(Double.parseDouble(String.valueOf(product.get("goodsInfoPreferPrice"))));
                }
                if (null != product.get("goodsInfoCostPrice")) {
                    tempRow.createCell(5).setCellValue(Double.parseDouble(String.valueOf(product.get("goodsInfoCostPrice"))));
                }
                if (null != product.get("goodsInfoMarketPrice")) {
                    tempRow.createCell(6).setCellValue(Double.parseDouble(String.valueOf(product.get("goodsInfoMarketPrice"))));
                }
                tempRow.createCell(7).setCellValue("1".equals((String)product.get("goodsInfoAdded")) ? "\u4e0a\u67b6\u9500\u552e\u4e2d" : "\u4e0b\u67b6");
                for (int j = 0; j < ((List)product.get("specVo")).size(); ++j) {
                    LinkedHashMap specVo = (LinkedHashMap)((List)product.get("specVo")).get(j);
                    tempRow.createCell(8 + j).setCellValue((String)specVo.get("gpecValueRemark"));
                }
            }
        }
        String filename = String.valueOf(System.currentTimeMillis()).concat(".xls");
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment;filename=" + filename);
        try {
            ServletOutputStream ouputStream = response.getOutputStream();
            wb.write((OutputStream)ouputStream);
            ouputStream.flush();
            ouputStream.close();
        }
        catch (IOException e) {
            LOGGER.error("\u5bfc\u51fa\u8d27\u54c1\u5217\u8868\u9519\u8bef\uff1a" + e);
        }
        finally {
            wb = null;
            filename = null;
            Object ouputStream = null;
            style = null;
            tempRow = null;
        }
    }
}

