/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.excel;

import com.qianjiang.goods.bean.GoodsBrand;
import com.qianjiang.goods.bean.GoodsCate;
import com.qianjiang.goods.bean.GoodsImport;
import com.qianjiang.goods.bean.GoodsSpec;
import com.qianjiang.goods.bean.GoodsType;
import com.qianjiang.goods.bean.GoodsTypeBrand;
import com.qianjiang.goods.bean.GoodsTypeExpandParam;
import com.qianjiang.goods.bean.GoodsTypeExpandParamValue;
import com.qianjiang.goods.bean.GoodsTypeParam;
import com.qianjiang.goods.bean.GoodsTypeSpec;
import com.qianjiang.goods.service.GoodsBrandService;
import com.qianjiang.goods.service.GoodsCateService;
import com.qianjiang.goods.service.GoodsSpecService;
import com.qianjiang.goods.service.GoodsTypeBrandService;
import com.qianjiang.goods.service.GoodsTypeExpandParamService;
import com.qianjiang.goods.service.GoodsTypeExpandParamValueService;
import com.qianjiang.goods.service.GoodsTypeParamService;
import com.qianjiang.goods.service.GoodsTypeService;
import com.qianjiang.goods.service.GoodsTypeSpecService;
import com.qianjiang.util.MyLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository(value="ImportGoods")
public class ImportGoods {
    private static final MyLogger LOGGER = new MyLogger(ImportGoods.class);
    private static final String RESULT = "result";
    private static final String LOGGERINFO1 = ")\u5df2\u5b58\u5728\uff01";
    @Resource(name="GoodsTypeService")
    private GoodsTypeService goodsTypeService;
    @Resource(name="GoodsBrandService")
    private GoodsBrandService goodsBrandService;
    @Resource(name="GoodsTypeBrandService")
    private GoodsTypeBrandService goodsTypeBrandService;
    @Resource(name="GoodsTypeExpandParamService")
    private GoodsTypeExpandParamService goodsTypeExpandParamService;
    @Resource(name="GoodsTypeExpandParamValueService")
    private GoodsTypeExpandParamValueService goodsTypeExpandParamValueService;
    @Resource(name="GoodsSpecService")
    private GoodsSpecService goodsSpecService;
    @Resource(name="GoodsTypeSpecService")
    private GoodsTypeSpecService goodsTypeSpecService;
    @Resource(name="GoodsTypeParamService")
    private GoodsTypeParamService goodsTypeParamService;
    @Resource(name="GoodsCateService")
    private GoodsCateService goodsCateService;

    public void exportTypeProductLists(HttpServletResponse response) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet1 = wb.createSheet("\u7c7b\u578b\u540d\u79f0");
        HSSFSheet sheet2 = wb.createSheet("\u6269\u5c55\u5c5e\u6027");
        HSSFSheet sheet3 = wb.createSheet("\u89c4\u683c");
        HSSFSheet sheet4 = wb.createSheet("\u53c2\u6570");
        sheet1.createFreezePane(0, 1, 0, 3);
        sheet1.setColumnWidth(0, 4000);
        sheet1.setColumnWidth(1, 4000);
        sheet1.setColumnWidth(2, 4000);
        HSSFRow row = sheet1.createRow(0);
        HSSFCell cell = row.createCell(0);
        cell.setCellValue("\u7c7b\u578b\u540d\u79f0");
        cell = row.createCell(1);
        cell.setCellValue("\u7c7b\u578b\u522b\u540d");
        cell = row.createCell(2);
        cell.setCellValue("\u5173\u8054\u54c1\u724c");
        sheet2.createFreezePane(0, 1, 0, 4);
        sheet2.setColumnWidth(0, 4000);
        sheet2.setColumnWidth(1, 4000);
        sheet2.setColumnWidth(2, 4000);
        sheet2.setColumnWidth(3, 4000);
        HSSFRow row2 = sheet2.createRow(0);
        HSSFCell cell2 = row2.createCell(0);
        cell2.setCellValue("\u5c5e\u6027\u540d");
        cell2 = row2.createCell(1);
        cell2.setCellValue("\u5c5e\u6027\u522b\u540d");
        cell2 = row2.createCell(2);
        cell2.setCellValue("\u9009\u62e9\u9879\u53ef\u9009\u503c");
        cell2 = row2.createCell(3);
        cell2.setCellValue("\u6392\u5e8f");
        sheet3.createFreezePane(0, 1, 0, 2);
        sheet3.setColumnWidth(0, 4000);
        sheet3.setColumnWidth(1, 4000);
        HSSFRow row3 = sheet3.createRow(0);
        HSSFCell cell3 = row3.createCell(0);
        cell3.setCellValue("\u9009\u62e9\u522b\u540d");
        sheet4.createFreezePane(0, 1, 0, 2);
        sheet4.setColumnWidth(0, 4000);
        sheet4.setColumnWidth(1, 4000);
        HSSFRow row4 = sheet4.createRow(0);
        HSSFCell cell4 = row4.createCell(0);
        cell4.setCellValue("\u53c2\u6570\u540d");
        cell4 = row4.createCell(1);
        cell4.setCellValue("\u522b\u540d");
        String filename = String.valueOf(System.currentTimeMillis()).concat(".xls");
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment;filename=" + filename);
        try {
            ServletOutputStream ouputStream = response.getOutputStream();
            wb.write((OutputStream)ouputStream);
            ouputStream.flush();
            ouputStream.close();
        }
        catch (IOException e) {
            LOGGER.error("\u5bfc\u51fa\u5bfc\u5165\u6a21\u677f\u51fa\u9519\uff1a" + e);
        }
    }

    public void exportProductList(HttpServletResponse response) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet1 = wb.createSheet("new Sheet");
        sheet1.createFreezePane(0, 1, 0, 5);
        sheet1.setColumnWidth(0, 4000);
        sheet1.setColumnWidth(1, 4000);
        sheet1.setColumnWidth(2, 4000);
        sheet1.setColumnWidth(3, 4000);
        sheet1.setColumnWidth(4, 4000);
        HSSFRow row = sheet1.createRow(0);
        HSSFCell cell = row.createCell(0);
        cell.setCellValue("\u5546\u54c1\u540d\u79f0");
        cell = row.createCell(1);
        cell.setCellValue("\u5546\u54c1\u526f\u6807\u9898");
        cell = row.createCell(2);
        cell.setCellValue("\u9500\u552e\u4ef7\u683c");
        cell = row.createCell(3);
        cell.setCellValue("\u6210\u672c\u4ef7\u683c");
        cell = row.createCell(4);
        cell.setCellValue("\u5e02\u573a\u4ef7\u683c");
        cell = row.createCell(5);
        cell.setCellValue("SEO\u6807\u7b7e");
        cell = row.createCell(6);
        cell.setCellValue("SEO\u5173\u952e\u5b57");
        cell = row.createCell(7);
        cell.setCellValue("SEO\u8be6\u7ec6\u4f18\u5316");
        cell = row.createCell(8);
        String filename = String.valueOf(System.currentTimeMillis()).concat(".xls");
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment;filename=" + filename);
        try {
            ServletOutputStream ouputStream = response.getOutputStream();
            wb.write((OutputStream)ouputStream);
            ouputStream.flush();
            ouputStream.close();
        }
        catch (IOException e) {
            LOGGER.error("\u5bfc\u51fa\u5bfc\u5165\u6a21\u677f\u51fa\u9519\uff1a" + e);
        }
    }

    public List<GoodsImport> importGoods(POIFSFileSystem fs) {
        ArrayList<GoodsImport> goodsList = new ArrayList<GoodsImport>();
        try {
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            for (int numSheet = 0; numSheet < wb.getNumberOfSheets(); ++numSheet) {
                HSSFSheet hssfSheet = wb.getSheetAt(numSheet);
                if (hssfSheet == null) continue;
                for (int rowNum = 1; rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
                    HSSFRow hssfRow = hssfSheet.getRow(rowNum);
                    if (hssfRow == null) continue;
                    GoodsImport goods = new GoodsImport();
                    HSSFCell xh = hssfRow.getCell(0);
                    if (xh == null) continue;
                    goods.setGoodsName(this.getValue(xh));
                    HSSFCell xm = hssfRow.getCell(1);
                    if (null == xm) {
                        goods.setGoodsSubtitle("");
                    } else {
                        goods.setGoodsSubtitle(this.getValue(xm));
                    }
                    HSSFCell pri = hssfRow.getCell(2);
                    if (null == pri) {
                        goods.setGoodsPrice(new BigDecimal(0));
                    } else {
                        goods.setGoodsPrice(new BigDecimal(this.getValue(pri)));
                    }
                    HSSFCell cp = hssfRow.getCell(3);
                    if (null == cp) {
                        goods.setGoodsCostPrice(new BigDecimal(0));
                    } else {
                        goods.setGoodsCostPrice(new BigDecimal(this.getValue(cp)));
                    }
                    HSSFCell mp = hssfRow.getCell(4);
                    if (null == mp) {
                        goods.setGoodsMarketPrice(new BigDecimal(0));
                    } else {
                        goods.setGoodsMarketPrice(new BigDecimal(this.getValue(mp)));
                    }
                    HSSFCell se = hssfRow.getCell(5);
                    if (null == se) {
                        goods.setSeoTit("");
                    } else {
                        goods.setSeoTit(this.getValue(se));
                    }
                    HSSFCell sekey = hssfRow.getCell(6);
                    if (null == sekey) {
                        goods.setSeoKey("");
                    } else {
                        goods.setSeoKey(this.getValue(sekey));
                    }
                    HSSFCell seodes = hssfRow.getCell(7);
                    if (null == seodes) {
                        goods.setSeoDes("");
                    } else {
                        goods.setSeoDes(this.getValue(seodes));
                    }
                    goodsList.add(goods);
                }
            }
            return goodsList;
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            return Collections.emptyList();
        }
    }

    public void exportProductLists(HttpServletResponse response) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet1 = wb.createSheet("\u5546\u54c1\u89c4\u683c");
        sheet1.createFreezePane(0, 1, 0, 5);
        sheet1.setColumnWidth(0, 4000);
        sheet1.setColumnWidth(1, 4000);
        sheet1.setColumnWidth(2, 4000);
        sheet1.setColumnWidth(3, 4000);
        sheet1.setColumnWidth(4, 4000);
        HSSFRow row = sheet1.createRow(0);
        HSSFCell cell = row.createCell(0);
        cell.setCellValue("\u89c4\u683c\u540d\u79f0");
        cell = row.createCell(1);
        cell.setCellValue("\u89c4\u683c\u5907\u6ce8");
        cell = row.createCell(2);
        cell.setCellValue("\u89c4\u683c\u522b\u540d");
        cell = row.createCell(8);
        String filename = String.valueOf(System.currentTimeMillis()).concat(".xls");
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment;filename=" + filename);
        try {
            ServletOutputStream ouputStream = response.getOutputStream();
            wb.write((OutputStream)ouputStream);
            ouputStream.flush();
            ouputStream.close();
        }
        catch (IOException e) {
            LOGGER.error("\u5bfc\u51fa\u5bfc\u5165\u6a21\u677f\u51fa\u9519\uff1a" + e);
        }
    }

    public Map<String, Object> importTypeGoodsModels(HttpServletRequest request, InputStream is) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            POIFSFileSystem fs = new POIFSFileSystem(is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            long typeId = 0L;
            long expandparamId = 0L;
            for (int numSheet = 0; numSheet < wb.getNumberOfSheets(); ++numSheet) {
                HSSFSheet hssfSheet = wb.getSheetAt(numSheet);
                if (hssfSheet == null) {
                    map.put(RESULT, false);
                    break;
                }
                String name = (String)request.getSession().getAttribute("name");
                if (numSheet == 0) {
                    int rowNum = 1;
                    ArrayList<GoodsType> goodsList1 = new ArrayList<GoodsType>();
                    ArrayList<GoodsTypeBrand> goodsList2 = new ArrayList<GoodsTypeBrand>();
                    GoodsType goodsType = new GoodsType();
                    HSSFRow hssfRow = hssfSheet.getRow(rowNum);
                    hssfRow.getCell(0).setCellType(1);
                    String xm = hssfRow.getCell(0).getStringCellValue();
                    if (null == xm) {
                        map.put(RESULT, false);
                        break;
                    }
                    if (!this.goodsTypeService.checkTypeName(xm, null)) {
                        map.put(RESULT, false);
                        break;
                    }
                    goodsType.setTypeName(xm);
                    HSSFCell gmn = hssfRow.getCell(1);
                    if (null == gmn) {
                        goodsType.setTypeNickname("");
                    } else {
                        gmn.setCellType(1);
                        goodsType.setTypeNickname(new String(this.getValue(gmn)));
                    }
                    goodsType.setTypeCreateTime(new Date());
                    goodsType.setTypeModifiedTime(new Date());
                    typeId = this.goodsTypeService.saveGoodsType(goodsType, name);
                    goodsList1.add(goodsType);
                    hssfRow.getCell(2).setCellType(1);
                    String sm = hssfRow.getCell(2).getStringCellValue();
                    String[] values = sm.split(",");
                    for (int i = 0; i < values.length; ++i) {
                        GoodsTypeBrand goodsTypeBrand = new GoodsTypeBrand();
                        List<GoodsBrand> brands = this.goodsBrandService.queryallbrandbyName(values[i]);
                        if (brands == null || brands.isEmpty()) {
                            map.put(RESULT, false);
                            break;
                        }
                        long brandId = brands.get(0).getBrandId();
                        goodsTypeBrand.setTypeId(typeId);
                        goodsTypeBrand.setBrandId(brandId);
                        goodsTypeBrand.setDelflag("0");
                        goodsList2.add(goodsTypeBrand);
                        this.goodsTypeBrandService.insertTypeBrand(goodsTypeBrand, name);
                    }
                    map.put(RESULT, true);
                    map.put("goodsList1", goodsList1);
                    map.put("goodsList2", goodsList2);
                }
                if (numSheet == 1) {
                    ArrayList<GoodsTypeExpandParam> goodsList3 = new ArrayList<GoodsTypeExpandParam>();
                    ArrayList<GoodsTypeExpandParamValue> goodsList4 = new ArrayList<GoodsTypeExpandParamValue>();
                    for (int rowNum = 1; rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
                        GoodsTypeExpandParam goodsTypeExpandParam = new GoodsTypeExpandParam();
                        HSSFRow hssfRow2 = hssfSheet.getRow(rowNum);
                        if (hssfRow2 == null) continue;
                        hssfRow2.getCell(0).setCellType(1);
                        String expandParamName = hssfRow2.getCell(0).getStringCellValue();
                        if (expandParamName.isEmpty() || expandParamName == null) {
                            goodsTypeExpandParam.setExpandparamName("");
                        } else {
                            goodsTypeExpandParam.setExpandparamName(expandParamName);
                        }
                        hssfRow2.getCell(1).setCellType(1);
                        String expandParamNickname = hssfRow2.getCell(1).getStringCellValue();
                        if (expandParamNickname.isEmpty() || expandParamNickname == null) {
                            goodsTypeExpandParam.setExpandparamNickname("");
                        } else {
                            goodsTypeExpandParam.setExpandparamNickname(expandParamNickname);
                        }
                        hssfRow2.getCell(3).setCellType(1);
                        String expandParamSort = hssfRow2.getCell(3).getStringCellValue();
                        if (expandParamSort.isEmpty() || expandParamSort == null) {
                            goodsTypeExpandParam.setExpandparamSort(Integer.parseInt(""));
                        } else {
                            goodsTypeExpandParam.setExpandparamSort(Integer.parseInt(expandParamSort));
                        }
                        goodsTypeExpandParam.setTypeId(typeId);
                        goodsTypeExpandParam.setExpandparamDelflag("0");
                        goodsTypeExpandParam.setExpandparamCreateTime(new Date());
                        goodsTypeExpandParam.setExpandparamModifiedTime(new Date());
                        expandparamId = this.goodsTypeExpandParamService.saveExpandParam(goodsTypeExpandParam, name);
                        goodsList3.add(goodsTypeExpandParam);
                        hssfRow2.getCell(2).setCellType(1);
                        String expandParamValue = hssfRow2.getCell(2).getStringCellValue();
                        String[] values = expandParamValue.split(",");
                        for (int i = 0; i < values.length; ++i) {
                            GoodsTypeExpandParamValue goodsTypeExpandParamValue = new GoodsTypeExpandParamValue();
                            goodsTypeExpandParamValue.setExpandparamValueName(values[i]);
                            goodsTypeExpandParamValue.setExpandparamId(expandparamId);
                            goodsTypeExpandParamValue.setExpandparamValueDelflag("0");
                            goodsTypeExpandParamValue.setExpandparamValueCreateTime(new Date());
                            goodsTypeExpandParamValue.setExpandparamValueModifiedTime(new Date());
                            this.goodsTypeExpandParamValueService.saveParamValue(goodsTypeExpandParamValue, name);
                            goodsList4.add(goodsTypeExpandParamValue);
                        }
                    }
                    map.put("goodsList3", goodsList3);
                    map.put("goodsList4", goodsList4);
                }
                if (numSheet == 2) {
                    ArrayList<GoodsTypeSpec> goodsList5 = new ArrayList<GoodsTypeSpec>();
                    for (int rowNum = 1; rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
                        GoodsTypeSpec goodsTypeSpec = new GoodsTypeSpec();
                        HSSFRow hssfRow3 = hssfSheet.getRow(rowNum);
                        if (hssfRow3 == null) continue;
                        hssfRow3.getCell(0).setCellType(1);
                        String values = hssfRow3.getCell(0).getStringCellValue();
                        long specId = this.goodsSpecService.querySpecGoodsId(values);
                        goodsTypeSpec.setSpecId(specId);
                        goodsTypeSpec.setTypeId(typeId);
                        goodsTypeSpec.setTypeSpecDelflag("0");
                        goodsTypeSpec.setTypeSpecCreateTime(new Date());
                        goodsTypeSpec.setTypeSpecModifiedTime(new Date());
                        this.goodsTypeSpecService.saveTypeSpec(goodsTypeSpec, name);
                        goodsList5.add(goodsTypeSpec);
                    }
                    map.put("goodList5", goodsList5);
                }
                if (numSheet != 3) continue;
                ArrayList<GoodsTypeParam> goodsList6 = new ArrayList<GoodsTypeParam>();
                for (int rowNum = 1; rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
                    GoodsTypeParam goodsTypeParam = new GoodsTypeParam();
                    HSSFRow hssfRow4 = hssfSheet.getRow(rowNum);
                    if (hssfRow4 == null) continue;
                    hssfRow4.getCell(0).setCellType(1);
                    String paramName = hssfRow4.getCell(0).getStringCellValue();
                    if (paramName.isEmpty() || paramName == null) {
                        goodsTypeParam.setParamName("");
                    } else {
                        goodsTypeParam.setParamName(paramName);
                    }
                    hssfRow4.getCell(1).setCellType(1);
                    String paramNickname = hssfRow4.getCell(1).getStringCellValue();
                    if (paramNickname.isEmpty() || paramNickname == null) {
                        goodsTypeParam.setParamNickname("");
                    } else {
                        goodsTypeParam.setParamNickname(paramNickname);
                    }
                    goodsTypeParam.setTypeId(typeId);
                    goodsTypeParam.setParamCreateTime(new Date());
                    goodsTypeParam.setParamModifiedTime(new Date());
                    this.goodsTypeParamService.saveTypeParam(goodsTypeParam, name);
                    goodsList6.add(goodsTypeParam);
                }
                map.put("goodsList6", goodsList6);
            }
            return map;
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            map.put(RESULT, "400");
            return map;
        }
    }

    public List<GoodsSpec> importGoodsModels(InputStream is) {
        ArrayList<GoodsSpec> goodsList = new ArrayList<GoodsSpec>();
        try {
            POIFSFileSystem fs = new POIFSFileSystem(is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            for (int numSheet = 0; numSheet < wb.getNumberOfSheets(); ++numSheet) {
                HSSFSheet hssfSheet = wb.getSheetAt(numSheet);
                if (hssfSheet == null) continue;
                for (int rowNum = 1; rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
                    HSSFRow hssfRow = hssfSheet.getRow(rowNum);
                    if (hssfRow == null) continue;
                    GoodsSpec goodsSpec = new GoodsSpec();
                    HSSFCell xm = hssfRow.getCell(0);
                    if (null == xm) {
                        goodsSpec.setSpecName("");
                    } else {
                        xm.setCellType(1);
                        goodsSpec.setSpecName(this.getValue(xm));
                    }
                    HSSFCell gmn = hssfRow.getCell(1);
                    if (null == gmn) {
                        goodsSpec.setSpecRemark("");
                    } else {
                        gmn.setCellType(1);
                        goodsSpec.setSpecRemark(new String(this.getValue(gmn)));
                    }
                    HSSFCell ggbm = hssfRow.getCell(2);
                    if (null == ggbm) {
                        goodsSpec.setSpecNickname("");
                    } else {
                        ggbm.setCellType(1);
                        goodsSpec.setSpecNickname(new String(this.getValue(ggbm)));
                    }
                    goodsList.add(goodsSpec);
                }
            }
            return goodsList;
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            return Collections.emptyList();
        }
    }

    public Map<String, Object> importGoodsCate(InputStream is) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<GoodsCate> cateList = new ArrayList<GoodsCate>();
        try {
            POIFSFileSystem fs = new POIFSFileSystem(is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet sheet = wb.getSheetAt(0);
            int rows = sheet.getPhysicalNumberOfRows();
            Pattern numberPattern = Pattern.compile("[0-9]*");
            Pattern decimalPattern = Pattern.compile("([1-9]+[0-9]*|0)(\\.[\\d]+)?");
            for (int i = 1; i < rows; ++i) {
                GoodsCate cate = new GoodsCate();
                HSSFRow row = sheet.getRow(i);
                row.getCell(0).setCellType(1);
                String catIdStr = row.getCell(0).getStringCellValue();
                if (catIdStr == null || "".equals(catIdStr)) {
                    map.put(RESULT, "501\uff1a\u7b2c" + i + "\u884c\u5206\u7c7bid\u4e0d\u80fd\u4e3a\u7a7a");
                    return map;
                }
                Matcher isNum = numberPattern.matcher(catIdStr);
                if (!isNum.matches()) {
                    map.put(RESULT, "502\uff1a\u7b2c" + i + "\u884c\u5206\u7c7bid\u4e0d\u662f\u6570\u5b57");
                    return map;
                }
                if (this.goodsCateService.queryGoodsCateById(Long.parseLong(catIdStr)) != null) {
                    map.put(RESULT, "5021\uff1a\u7b2c" + i + "\u884c\u5206\u7c7bid(" + catIdStr + LOGGERINFO1);
                    return map;
                }
                cate.setCatId(Long.parseLong(catIdStr));
                row.getCell(1).setCellType(1);
                String cateName = row.getCell(1).getStringCellValue();
                if (cateName == null || "".equals(cateName)) {
                    map.put(RESULT, "503:\u7b2c" + i + "\u884c\u5206\u7c7b\u540d\u79f0\u4e3a\u7a7a");
                    return map;
                }
                if (this.goodsCateService.queryCateByCateName(cateName) != null) {
                    map.put(RESULT, "5031:\u7b2c" + i + "\u884c\u5206\u7c7b\u540d\u79f0\uff08" + cateName + "\uff09\u5df2\u5b58\u5728");
                    return map;
                }
                cate.setCatName(cateName);
                row.getCell(2).setCellType(1);
                String typeIdStr = row.getCell(2).getStringCellValue();
                if (typeIdStr == null || "".equals(typeIdStr)) {
                    map.put(RESULT, "504\uff1a\u7b2c" + i + "\u884c\u5206\u7c7b\u7c7b\u578b\u4e3a\u7a7a");
                    return map;
                }
                isNum = numberPattern.matcher(typeIdStr);
                if (!"".equals(typeIdStr) && !isNum.matches()) {
                    map.put(RESULT, "505\uff1a\u7b2c" + i + "\u884c\u5206\u7c7bid\u4e0d\u662f\u6570\u5b57");
                    return map;
                }
                if (!"".equals(typeIdStr)) {
                    cate.setTypeId(Long.parseLong(typeIdStr));
                }
                row.getCell(3).setCellType(1);
                String cateRateStr = row.getCell(3).getStringCellValue();
                Matcher isDecimal = decimalPattern.matcher(cateRateStr);
                if (!"".equals(cateRateStr) && !isDecimal.matches()) {
                    map.put(RESULT, "506\uff1a\u7b2c" + i + "\u884c\u5206\u7c7b\u6263\u7387\u4e0d\u662f\u6570\u5b57");
                    return map;
                }
                cate.setCatRate(new BigDecimal(cateRateStr));
                if (row.getCell(4) != null) {
                    row.getCell(4).setCellType(1);
                    String cateSortStr = row.getCell(4).getStringCellValue();
                    isNum = numberPattern.matcher(cateSortStr);
                    if (!"".equals(cateSortStr) && !isNum.matches()) {
                        map.put(RESULT, "507\uff1a\u7b2c" + i + "\u884c\u5206\u7c7b\u6392\u5e8f\u4e0d\u662f\u6570\u5b57");
                        return map;
                    }
                    if (!"".equals(cateSortStr)) {
                        cate.setCatSort(Integer.parseInt(cateSortStr));
                    }
                }
                row.getCell(5).setCellType(1);
                String cateGradStr = row.getCell(5).getStringCellValue();
                isNum = numberPattern.matcher(cateGradStr);
                if ("".equals(cateGradStr)) {
                    map.put(RESULT, "508\uff1a\u7b2c" + i + "\u884c\u5206\u7c7b\u7ea7\u522b\u4e3a\u7a7a");
                    return map;
                }
                if (!"".equals(cateGradStr) && !isNum.matches()) {
                    map.put(RESULT, "509\uff1a\u7b2c" + i + "\u884c\u5206\u7c7b\u7ea7\u522b\u4e0d\u662f\u6570\u5b57");
                    return map;
                }
                cate.setCatGrade(Integer.parseInt(cateGradStr));
                if (row.getCell(6) != null) {
                    row.getCell(6).setCellType(1);
                    String seoTitle = row.getCell(6).getStringCellValue();
                    cate.setCatSeoTitle(seoTitle);
                }
                if (row.getCell(7) != null) {
                    row.getCell(7).setCellType(1);
                    String seoKey = row.getCell(7).getStringCellValue();
                    cate.setCatSeoKeyword(seoKey);
                }
                if (row.getCell(8) != null) {
                    row.getCell(8).setCellType(1);
                    String seoDesc = row.getCell(8).getStringCellValue();
                    cate.setCatSeoDesc(seoDesc);
                }
                row.getCell(9).setCellType(1);
                String cateParentIdStr = row.getCell(9).getStringCellValue();
                if (cateParentIdStr == null || "".equals(cateParentIdStr)) {
                    map.put(RESULT, "510\uff1a\u7b2c" + i + "\u884c\u7236\u7c7bid\u4e3a\u7a7a");
                    return map;
                }
                isNum = numberPattern.matcher(cateParentIdStr);
                if (!isNum.matches()) {
                    map.put(RESULT, "511\uff1a\u7b2c" + i + "\u884c\u7236\u7c7bid\u4e0d\u662f\u6570\u5b57");
                    return map;
                }
                if (!"".equals(cateParentIdStr)) {
                    cate.setCatParentId(Long.parseLong(cateParentIdStr));
                }
                cateList.add(cate);
            }
            map.put("cateList", cateList);
            return map;
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            map.put(RESULT, "400");
            return map;
        }
    }

    public Map<String, Object> importGoodsBrand(InputStream is) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<GoodsBrand> brandList = new ArrayList<GoodsBrand>();
        ArrayList<String> failBrandNamesRow = new ArrayList<String>();
        ArrayList<String> alerdyBrandNames = new ArrayList<String>();
        try {
            POIFSFileSystem fs = new POIFSFileSystem(is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet sheet = wb.getSheetAt(0);
            int rows = sheet.getPhysicalNumberOfRows();
            Pattern numberPattern = Pattern.compile("[0-9]*");
            for (int i = 1; i < rows; ++i) {
                GoodsBrand brand = new GoodsBrand();
                HSSFRow row = sheet.getRow(i);
                row.getCell(0).setCellType(1);
                String brandName = row.getCell(0).getStringCellValue();
                if (this.goodsBrandService.queryBrandByBrandName(brandName) > 0) {
                    failBrandNamesRow.add(i + 1 + "");
                    continue;
                }
                if (brandName == null || "".equals(brandName)) continue;
                if (this.goodsBrandService.queryByBrandName(brandName) > 0) {
                    failBrandNamesRow.add(i + 1 + "");
                    continue;
                }
                brand.setBrandName(brandName);
                if (alerdyBrandNames.contains(brand.getBrandName())) continue;
                if (row.getCell(1) != null) {
                    row.getCell(1).setCellType(1);
                    String brandNickName = row.getCell(1).getStringCellValue();
                    brand.setBrandNickname(brandNickName);
                }
                if (row.getCell(2) == null) {
                    failBrandNamesRow.add(i + 1 + "");
                    continue;
                }
                row.getCell(2).setCellType(1);
                String brandSortStr = row.getCell(2).getStringCellValue();
                Matcher isNum = numberPattern.matcher(brandSortStr);
                if (!"".equals(brandSortStr) && !isNum.matches()) {
                    failBrandNamesRow.add(i + 1 + "");
                    continue;
                }
                if (!"".equals(brandSortStr)) {
                    brand.setBrandSort(Integer.parseInt(brandSortStr));
                }
                if (row.getCell(3) != null) {
                    row.getCell(3).setCellType(1);
                    String brandUrl = row.getCell(3).getStringCellValue();
                    brand.setBrandUrl(brandUrl);
                }
                if (row.getCell(4) != null) {
                    row.getCell(4).setCellType(1);
                    String brandLogo = row.getCell(4).getStringCellValue();
                    brand.setBrandLogo(brandLogo);
                }
                if (row.getCell(5) != null) {
                    row.getCell(5).setCellType(1);
                    String seoTitle = row.getCell(5).getStringCellValue();
                    brand.setBrandSeoTitle(seoTitle);
                }
                if (row.getCell(6) != null) {
                    row.getCell(6).setCellType(1);
                    String seoKey = row.getCell(6).getStringCellValue();
                    brand.setBrandSeoKeyword(seoKey);
                }
                if (row.getCell(7) != null) {
                    row.getCell(7).setCellType(1);
                    String seoDesc = row.getCell(7).getStringCellValue();
                    brand.setBrandSeoDesc(seoDesc);
                }
                alerdyBrandNames.add(brand.getBrandName());
                brandList.add(brand);
            }
            map.put("brandList", brandList);
            if (CollectionUtils.isEmpty(failBrandNamesRow)) {
                return map;
            }
            map.put(RESULT, "\u90e8\u5206\u54c1\u724c\u91cd\u590d\u6216\u8005\u6392\u5e8f\u4e0d\u6b63\u786e\u5bfc\u5165\u5931\u8d25\u884c\u6570:" + failBrandNamesRow);
            return map;
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            map.put(RESULT, "400");
            return map;
        }
    }

    private String getValue(HSSFCell hssfCell) {
        if (hssfCell.getCellType() == 4) {
            return String.valueOf(hssfCell.getBooleanCellValue());
        }
        if (hssfCell.getCellType() == 0) {
            return String.valueOf(hssfCell.getNumericCellValue());
        }
        return String.valueOf(hssfCell.getStringCellValue());
    }
}

