/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.promotion.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Pageable<T>
implements Serializable {
    private static final long serialVersionUID = -4684429926866096678L;
    private final long total;
    private final List<T> content = new ArrayList<T>();
    private int size = 10;
    private int page = 1;

    public Pageable(List<T> content, long total, int page, int size) {
        if (null == content) {
            throw new IllegalArgumentException("\u5206\u9875\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.content.addAll(content);
        this.total = total;
        this.page = page;
        this.size = size;
    }

    public Pageable(List<T> content, int page, int size) {
        this(content, null == content ? 0L : (long)content.size(), page, size);
    }

    public int getNumber() {
        return this.page;
    }

    public int getSize() {
        return this.size;
    }

    public int getTotalPages() {
        return this.getSize() == 0 ? 1 : (int)Math.ceil((double)this.total / (double)this.getSize());
    }

    public int getNumberOfElements() {
        return this.content.size();
    }

    public long getTotalElements() {
        return this.total;
    }

    public boolean hasPreviousPage() {
        return this.getNumber() > 0;
    }

    public boolean isFirstPage() {
        return !this.hasPreviousPage();
    }

    public boolean hasNextPage() {
        return this.getNumber() + 1 < this.getTotalPages();
    }

    public boolean isLastPage() {
        return !this.hasNextPage();
    }

    public List<T> getContent() {
        return Collections.unmodifiableList(this.content);
    }

    public boolean hasContent() {
        return !this.content.isEmpty();
    }

    public int getEnd() {
        int end = Math.min(this.getBegin() + 10, this.getTotalPages());
        if (end <= 0) {
            end = 1;
        }
        return end;
    }

    public int getCurrent() {
        return this.getNumber();
    }

    public int getBegin() {
        return Math.max(1, this.getCurrent() - 5);
    }
}

