/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.system.bean.CurrencyConf;
import com.qianjiang.system.cache.IDictionarysCache;
import com.qianjiang.system.controller.BaseController;
import com.qianjiang.system.service.ICurrencyConfBiz;
import com.qianjiang.system.service.ISysDictionaryBiz;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller(value="currencyConfController")
public class CurrencyConfController
extends BaseController {
    private static final MyLogger LOGGER = new MyLogger(CurrencyConfController.class);
    private CurrencyConf currencyConf;
    private ICurrencyConfBiz currencyConfBizImpl;
    private static final String[] DICTIONARYS_LIST = new String[0];
    private IDictionarysCache dictionarysCache;
    private ISysDictionaryBiz sysDictionaryBizImpl;
    private static final String INIT_CURRENCYCONF = "initCurrencyConf.htm";
    private static final String ADD_CURRENCYCONF_JSP = "jsp/system/currency/currencyconf_add";
    private static final String CURRENCYCONF_LIST_JSP = "jsp/system/currency/currencyconf_list";
    private static final String UPDATE_CURRENCYCONF_JSP = "jsp/system/currency/currencyconf_update";
    private static final String READ_CURRENCYCONF_JSP = "jsp/system/currency/currencyconf_read";
    private static final String DELETESTATUS = "deleteStatus";
    private static final String MSG = "msg";
    private static final String CURRENCYCONF = "currencyConf";
    private static final String IDS = "ids";
    private static final String CURRENCYNAME = "currencyName";
    private static final String CURRENCYCODE = "currencyCode";

    @RequestMapping(value={"/initCurrencyConf"})
    public ModelAndView initCurrencyConf(PageBean pageBean, @RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, HttpServletRequest request) {
        pageBean.setUrl(INIT_CURRENCYCONF);
        ModelAndView mav = new ModelAndView();
        mav.setViewName(CURRENCYCONF_LIST_JSP);
        HashMap<String, Integer> pa = new HashMap<String, Integer>(1);
        pa.put(DELETESTATUS, deleteStatus);
        mav.addObject("pageBean", (Object)this.currencyConfBizImpl.getCurrencyConfByField(pa, pageBean));
        mav.addObject(DELETESTATUS, (Object)deleteStatus);
        mav.addObject(MSG, request.getAttribute(MSG));
        mav.addObject(MSG, (Object)request.getParameter(MSG));
        mav.addObject("deleteObjectSize", (Object)this.getDeleteObjectSize());
        return mav;
    }

    private int getDeleteObjectSize() {
        HashMap<String, Integer> pa = new HashMap<String, Integer>(1);
        pa.put(DELETESTATUS, 1);
        try {
            return this.currencyConfBizImpl.getCurrencyConfByFieldTotal(pa);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u5f97\u5220\u9664\u5bf9\u8c61\u7684\u6570\u91cf\u5f02\u5e38\uff01", (Throwable)e);
            return 0;
        }
    }

    @RequestMapping(value={"/openAddCurrencyConfPage"})
    public ModelAndView openAddCurrencyConfPage(HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        mav.setViewName(ADD_CURRENCYCONF_JSP);
        this.fullDictionarys(mav);
        return mav;
    }

    @RequestMapping(value={"/addCurrencyConf"})
    public ModelAndView addCurrencyConf(CurrencyConf currencyConf, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            currencyConf.setInsertDate(new Date());
            currencyConf.setInsertId(((Long)request.getSession().getAttribute("loginUserId")).intValue());
            currencyConf.setDeleteStatus(0);
            boolean flag = this.currencyConfBizImpl.saveCurrencyConf(currencyConf);
            if (!flag) {
                mav.addObject(MSG, (Object)"\u4fdd\u5b58\u8d27\u5e01\u8bbe\u7f6e\u5931\u8d25\uff01");
                return this.backAddPage(currencyConf, mav);
            }
            mav.addObject(MSG, (Object)"\u4fdd\u5b58\u8d27\u5e01\u8bbe\u7f6e\u6210\u529f\uff01");
            mav.setView((View)new RedirectView(INIT_CURRENCYCONF));
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u8d27\u5e01\u8bbe\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u4fdd\u5b58\u8d27\u5e01\u8bbe\u7f6e\u5931\u8d25\uff01");
            return this.backAddPage(currencyConf, mav);
        }
        return mav;
    }

    private ModelAndView backAddPage(CurrencyConf currencyConf, ModelAndView mav) {
        this.fullDictionarys(mav);
        mav.addObject(CURRENCYCONF, (Object)currencyConf);
        mav.setViewName(ADD_CURRENCYCONF_JSP);
        return mav;
    }

    @RequestMapping(value={"/openUpdateCurrencyConfPage"})
    public ModelAndView openUpdateCurrencyConfPage(@RequestParam(value="id") Integer id) {
        ModelAndView mav = new ModelAndView();
        try {
            this.fullDictionarys(mav);
            mav.addObject(CURRENCYCONF, (Object)this.currencyConfBizImpl.getCurrencyConfById(id.intValue()));
            mav.setViewName(UPDATE_CURRENCYCONF_JSP);
        }
        catch (Exception e) {
            LOGGER.error("\u52a0\u8f7d\u8d27\u5e01\u8bbe\u7f6e\u5bf9\u8c61\u5931\u8d25\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u52a0\u8f7d\u8d27\u5e01\u8bbe\u7f6e\u5bf9\u8c61\u5931\u8d25\uff01");
            mav.setView((View)new RedirectView(INIT_CURRENCYCONF));
            return mav;
        }
        return mav;
    }

    @RequestMapping(value={"/updateCurrencyConf"})
    public ModelAndView updateCurrencyConf(CurrencyConf currencyConf, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            currencyConf.setModifyDate(new Date());
            currencyConf.setModifyId(((Long)request.getSession().getAttribute("loginUserId")).intValue());
            if (this.currencyConfBizImpl.updateCurrencyConf(currencyConf) < 1) {
                mav.addObject(MSG, (Object)"\u4fee\u6539\u8d27\u5e01\u8bbe\u7f6e\u5931\u8d25\uff01");
                return this.backUpdatePage(currencyConf, mav);
            }
            mav.addObject(MSG, (Object)"\u4fee\u6539\u8d27\u5e01\u8bbe\u7f6e\u6210\u529f\uff01");
            mav.setView((View)new RedirectView(INIT_CURRENCYCONF));
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u8d27\u5e01\u8bbe\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u4fee\u6539\u8d27\u5e01\u8bbe\u7f6e\u5931\u8d25\uff01");
            return this.backUpdatePage(currencyConf, mav);
        }
        return mav;
    }

    private ModelAndView backUpdatePage(CurrencyConf currencyConf, ModelAndView mav) {
        this.fullDictionarys(mav);
        mav.addObject(CURRENCYCONF, (Object)currencyConf);
        mav.setViewName(UPDATE_CURRENCYCONF_JSP);
        return mav;
    }

    @RequestMapping(value={"/readCurrencyConf"})
    public ModelAndView readCurrencyConf(@RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, @RequestParam(value="id") Integer id) {
        ModelAndView mav = new ModelAndView();
        mav.addObject(DELETESTATUS, (Object)deleteStatus);
        if (id == 0) {
            mav.addObject(MSG, (Object)"\u8d27\u5e01\u8bbe\u7f6e\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u67e5\u8be2\uff01");
            mav.setView((View)new RedirectView(INIT_CURRENCYCONF));
        } else {
            mav.setViewName(READ_CURRENCYCONF_JSP);
            mav.addObject(CURRENCYCONF, (Object)this.currencyConfBizImpl.getCurrencyConfById(id.intValue()));
        }
        return mav;
    }

    @RequestMapping(value={"/deleteCurrencyConf"})
    public ModelAndView deleteCurrencyConf(@RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, @RequestParam(value="ids") String ids) {
        ModelAndView mav = new ModelAndView();
        mav.setView((View)new RedirectView(INIT_CURRENCYCONF));
        if (ids == null || ids.trim().length() == 0) {
            mav.addObject(MSG, (Object)"\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u5220\u9664\u8d27\u5e01\u8bbe\u7f6e\u64cd\u4f5c\uff01");
            return mav;
        }
        try {
            if (deleteStatus == 1) {
                if (this.currencyConfBizImpl.deleteCurrencyConf(ids) >= 1) {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u8d27\u5e01\u8bbe\u7f6e\u6210\u529f\uff01");
                } else {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u8d27\u5e01\u8bbe\u7f6e\u5931\u8d25\uff01");
                }
            } else {
                HashMap<String, Object> pa = new HashMap<String, Object>(2);
                pa.put(DELETESTATUS, 1);
                pa.put(IDS, ids);
                if (this.currencyConfBizImpl.updateCurrencyConfFieldById(pa) >= 1) {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u8d27\u5e01\u8bbe\u7f6e\u5230\u56de\u6536\u7ad9\u6210\u529f\uff01");
                } else {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u8d27\u5e01\u8bbe\u7f6e\u5230\u56de\u6536\u7ad9\u5931\u8d25\uff01");
                }
            }
            mav.addObject(DELETESTATUS, (Object)deleteStatus);
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u8d27\u5e01\u8bbe\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u5220\u9664\u8d27\u5e01\u8bbe\u7f6e\u5931\u8d25\uff01");
        }
        return mav;
    }

    @RequestMapping(value={"/restoreCurrencyConf"})
    public ModelAndView restoreCurrencyConf(@RequestParam(value="ids") String ids) {
        ModelAndView mav = new ModelAndView();
        mav.setView((View)new RedirectView(INIT_CURRENCYCONF));
        mav.addObject(DELETESTATUS, (Object)1);
        if (ids == null || ids.trim().length() == 0) {
            mav.addObject(MSG, (Object)"\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u8fd8\u539f\u5220\u9664\u8d27\u5e01\u8bbe\u7f6e\u64cd\u4f5c\uff01");
            return mav;
        }
        try {
            HashMap<String, Object> pa = new HashMap<String, Object>(2);
            pa.put(DELETESTATUS, 0);
            pa.put(IDS, ids);
            if (this.currencyConfBizImpl.updateCurrencyConfFieldById(pa) >= 1) {
                mav.addObject(MSG, (Object)"\u5220\u9664\u8d27\u5e01\u8bbe\u7f6e\u5230\u56de\u6536\u7ad9\u6210\u529f\uff01");
            } else {
                mav.addObject(MSG, (Object)"\u5220\u9664\u8d27\u5e01\u8bbe\u7f6e\u5230\u56de\u6536\u7ad9\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8fd8\u539f\u5220\u9664\u8d27\u5e01\u8bbe\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u8fd8\u539f\u5220\u9664\u8d27\u5e01\u8bbe\u7f6e\u5931\u8d25\uff01");
        }
        return mav;
    }

    @RequestMapping(value={"/queryCurrencyConf"})
    public ModelAndView queryCurrencyConf(@RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, @RequestParam(value="currencyName", required=false, defaultValue="") String currencyName, @RequestParam(value="currencyCode", required=false, defaultValue="") String currencyCode, PageBean pageBean) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, String> queryParam = new HashMap<String, String>();
        if (currencyName != null && currencyName.trim().length() != 0) {
            param.put(CURRENCYNAME, currencyName);
            queryParam.put(CURRENCYNAME, currencyName);
            queryParam.put("searchField", CURRENCYNAME);
            queryParam.put("searchValue", currencyName);
            queryParam.put("searchName", "\u8d27\u5e01\u540d\u79f0");
        }
        if (currencyCode != null && currencyCode.trim().length() != 0) {
            param.put(CURRENCYCODE, currencyCode);
            queryParam.put(CURRENCYCODE, currencyCode);
            queryParam.put("searchField", CURRENCYCODE);
            queryParam.put("searchValue", currencyCode);
            queryParam.put("searchName", "\u8d27\u5e01\u4ee3\u7801");
        }
        ModelAndView mav = new ModelAndView();
        mav.setViewName(CURRENCYCONF_LIST_JSP);
        mav.addObject("queryParam", queryParam);
        param.put(DELETESTATUS, deleteStatus);
        mav.addObject(DELETESTATUS, (Object)deleteStatus);
        try {
            mav.addObject("pageBean", (Object)this.currencyConfBizImpl.getCurrencyConfByField(param, pageBean));
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u8d27\u5e01\u8bbe\u7f6e\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)e);
        }
        return mav;
    }

    private void fullDictionarys(ModelAndView mav) {
        for (String dep : DICTIONARYS_LIST) {
            try {
                mav.addObject(dep, this.dictionarysCache.getDictionaryByName(dep));
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u5f97\u5b57\u5178\u7f13\u5b58\u5f02\u5e38\uff0c\u5b57\u5178\u540d\uff1a" + dep, (Throwable)e);
            }
        }
        PageBean pg = new PageBean();
        int pageSize = 1000;
        pg.setPageSize(pageSize);
        HashMap<String, Integer> pa = new HashMap<String, Integer>(2);
        pa.put("parentId", 1);
        pa.put("status", 1);
        try {
            mav.addObject("sysDic", (Object)this.sysDictionaryBizImpl.getSysDictionaryByField(pa, pg).getList());
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u5f97\u8d27\u5e01\u8bbe\u7f6e\u5b57\u5178\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    public CurrencyConf getCurrencyConf() {
        return this.currencyConf;
    }

    @Resource(name="currencyConf")
    public void setCurrencyConf(CurrencyConf currencyConf) {
        this.currencyConf = currencyConf;
    }

    public ICurrencyConfBiz getCurrencyConfBizImpl() {
        return this.currencyConfBizImpl;
    }

    @Resource(name="currencyConfBizImpl")
    public void setCurrencyConfBizImpl(ICurrencyConfBiz currencyConfBizImpl) {
        this.currencyConfBizImpl = currencyConfBizImpl;
    }

    public IDictionarysCache getDictionarysCache() {
        return this.dictionarysCache;
    }

    @Resource(name="dictionarysCache")
    public void setDictionarysCache(IDictionarysCache dictionarysCache) {
        this.dictionarysCache = dictionarysCache;
    }

    public ISysDictionaryBiz getSysDictionaryBizImpl() {
        return this.sysDictionaryBizImpl;
    }

    @Resource(name="sysDictionaryBizImpl")
    public void setSysDictionaryBizImpl(ISysDictionaryBiz sysDictionaryBizImpl) {
        this.sysDictionaryBizImpl = sysDictionaryBizImpl;
    }
}

