/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.comment.controller;

import com.qianjiang.comment.bean.Share;
import com.qianjiang.comment.bean.ShareReply;
import com.qianjiang.comment.service.ShareService;
import com.qianjiang.comment.vo.ShareVo;
import com.qianjiang.common.util.DateUtil;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.util.DateUtils;
import com.qianjiang.util.IPAddress;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ShareControllerBoss {
    private static final MyLogger logger = new MyLogger(ShareControllerBoss.class);
    private static final String INFO = "\u3011\u5546\u54c1\u7684\u6652\u5355\u4fe1\u606f\uff01";
    private CustomerServiceMapper customerServiceMapper;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    private ShareService shareServiceMapper;

    @RequestMapping(value={"/initsharelist"})
    public ModelAndView initShareList(HttpServletRequest req, PageBean pageBean, @Valid ShareVo shareVo, String[] attr, String commentType) {
        ModelAndView mav = null;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        pageBean.setUrl("initsharelist.htm");
        String startTime = "";
        String endTime = "";
        try {
            if (commentType != null && "2".equals(commentType)) {
                startTime = DateUtil.getPreDate((Date)new Date(), (String)DateUtil.DEFAULT_TIME_PATTERN, (int)-1);
                endTime = DateUtil.getSysCurrentDate((String)DateUtil.DEFAULT_TIME_PATTERN);
                shareVo.setCreateTime(DateUtil.stringtoDate((String)startTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
                shareVo.setCreateTimeTo(DateUtil.stringtoDate((String)endTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            } else {
                startTime = shareVo.getStartTime();
                endTime = shareVo.getEndTime();
                if (startTime == null || "".equals(startTime)) {
                    shareVo.setCreateTime(null);
                } else {
                    shareVo.setCreateTime(DateUtil.stringtoDate((String)startTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
                }
                if (endTime == null || "".equals(endTime)) {
                    shareVo.setCreateTimeTo(null);
                } else {
                    shareVo.setCreateTimeTo(DateUtil.stringtoDate((String)endTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
                }
            }
            resultMap.put("attr", attr);
            resultMap.put("share", shareVo);
            resultMap.put("pagebean", this.shareServiceMapper.selectAllShareByShare(pageBean, shareVo, Long.valueOf(0L)));
            mav = new ModelAndView("jsp/customer/sharelist");
            mav.addAllObjects(resultMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u67e5\u8be2\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/initsharelistthird"})
    public ModelAndView initShareList(HttpServletRequest request, PageBean pageBean, @Valid ShareVo shareVo, String[] attr, String n, String l) {
        ModelAndView view = new ModelAndView("goods/sharelist");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            logger.info((Object)"\u5f00\u59cb\u67e5\u8be2\u7b2c\u4e09\u65b9\u6652\u5355\u5217\u8868");
            String startpublishTime = request.getParameter("startpublishTime");
            String endlishTime = request.getParameter("endlishTime");
            String init = request.getParameter("init");
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if ("init".equals(init)) {
                startpublishTime = DateUtils.getBeforeTodayAfter((SimpleDateFormat)format, (int)-1);
                endlishTime = DateUtils.getTodayDate((SimpleDateFormat)format);
            }
            if (!StringUtils.isEmpty((String)startpublishTime)) {
                shareVo.setCreateTime(format.parse(startpublishTime));
                shareVo.setStartTime(startpublishTime);
            }
            if (!StringUtils.isEmpty((String)endlishTime)) {
                shareVo.setCreateTimeTo(format.parse(endlishTime));
                shareVo.setEndTime(endlishTime);
            }
            if (!StringUtils.isEmpty((String)n)) {
                request.getSession().setAttribute("n", (Object)n);
            }
            if (StringUtils.isEmpty((String)l)) {
                request.getSession().setAttribute("l", (Object)l);
            }
            if (null != shareVo) {
                shareVo.setGoodsNameChine();
                shareVo.setCustomerNickNameChina();
            }
            pageBean.setUrl("initsharelistthird.html");
            resultMap.put("attr", attr);
            resultMap.put("share", shareVo);
            resultMap.put("pagebean", this.shareServiceMapper.selectAllShareByShare(pageBean, shareVo, (Long)request.getSession().getAttribute("thirdId")));
            view.addAllObjects(resultMap).addObject("storeName", (Object)((String)request.getSession().getAttribute("storeName")));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7b2c\u4e09\u65b9\u6652\u5355\u5217\u8868\u5f02\u5e38", (Throwable)e);
        }
        finally {
            logger.error("\u7ed3\u675f\u7b2c\u4e09\u65b9\u6652\u5355\u5217\u8868");
            resultMap = null;
            return view;
        }
    }

    @RequestMapping(value={"/sharedetailboss"})
    public ModelAndView showShareDetail(Long shareId) {
        ShareVo shareVo;
        if (null != shareId && null != (shareVo = this.shareServiceMapper.selectShareDetail(shareId)).getGoodsName()) {
            logger.info((Object)("\u67e5\u8be2\u3010" + shareVo.getGoodsName() + INFO));
            return new ModelAndView("jsp/customer/sharedetail").addObject("share", (Object)shareVo);
        }
        return null;
    }

    @RequestMapping(value={"/sharedetailAjax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ShareVo sharedetailAjax(Long shareId) {
        ShareVo shareVo = null;
        if (null != shareId && null != (shareVo = this.shareServiceMapper.selectShareDetail(shareId)).getGoodsName()) {
            logger.info((Object)("\u67e5\u8be2\u3010" + shareVo.getGoodsName() + INFO));
        }
        return shareVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/sharedetailAjaxNew"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> sharedetailAjaxNew(Long shareId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ShareVo shareVo = null;
        try {
            shareVo = this.shareServiceMapper.selectShareDetail(shareId);
            resultMap.put("shareVo", shareVo);
            resultMap.put("shareReply", this.shareServiceMapper.queryShareReplyByShareId(shareId));
            resultMap.put("bs", this.basicSetService.findBasicSet());
            HashMap<String, Object> hashMap = resultMap;
            return hashMap;
        }
        finally {
            resultMap = null;
        }
    }

    @RequestMapping(value={"/updatesharerep"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int updateShareRep(HttpServletRequest request, @Valid ShareReply reply) {
        return this.shareServiceMapper.updateShareRep(reply);
    }

    @RequestMapping(value={"/updateshare"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int updateShare(@Valid Share share) {
        return this.shareServiceMapper.updateShare(share);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/deleteshare"})
    public ModelAndView deleteShare(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pr = null;
        try {
            pr = response.getWriter();
            Object[] shareIds = request.getParameterValues("parameterIds[]");
            if (ArrayUtils.isEmpty((Object[])shareIds)) {
                shareIds = request.getParameterValues("parameterIds");
            }
            pr.print(this.shareServiceMapper.deleteShare((String[])shareIds));
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6279\u91cf\u5220\u9664\u6652\u5355", (String)((String)request.getSession().getAttribute("operaPath") + "-->\u6279\u91cf\u5220\u9664\u6652\u5355,\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
        }
        finally {
            if (pr != null) {
                pr = null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/updatesharetoindex"})
    public ModelAndView updateShareToIndex(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pr = null;
        try {
            pr = response.getWriter();
            Object[] shareIds = request.getParameterValues("parameterIds[]");
            if (ArrayUtils.isEmpty((Object[])shareIds)) {
                shareIds = request.getParameterValues("parameterIds");
            }
            pr.print(this.shareServiceMapper.updateShareToIndex((String[])shareIds));
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6279\u91cf\u663e\u793a\u5230\u9996\u9875", (String)((String)request.getSession().getAttribute("operaPath") + "-->\u6279\u91cf\u663e\u793a\u5230\u9996\u9875,\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
        }
        finally {
            if (pr != null) {
                pr = null;
            }
        }
        return null;
    }

    @RequestMapping(value={"/updatesharetoindexone"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int updateShareToIndex(@Valid Share share) {
        return this.shareServiceMapper.updateShareToIndexOne(share);
    }

    @RequestMapping(value={"/checkindexsharecount"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int checkIndexShareCount(Long count) {
        if (this.shareServiceMapper.checkIndexShareCount(count)) {
            return 1;
        }
        return 0;
    }

    public CustomerServiceMapper getCustomerServiceMapper() {
        return this.customerServiceMapper;
    }

    @Resource(name="customerServiceMapper")
    public void setCustomerServiceMapper(CustomerServiceMapper customerServiceMapper) {
        this.customerServiceMapper = customerServiceMapper;
    }

    public ShareService getShareServiceMapper() {
        return this.shareServiceMapper;
    }

    @Resource(name="shareServiceNew")
    public void setShareServiceMapper(ShareService shareServiceMapper) {
        this.shareServiceMapper = shareServiceMapper;
    }

    @RequestMapping(value={"/addShareReplay"})
    public ModelAndView addShareReplay(HttpServletRequest request, HttpServletResponse response, @Valid ShareReply replay) throws IOException {
        replay.setCustomerId(null);
        this.shareServiceMapper.saveShareReply(replay);
        try {
            PrintWriter pr = null;
            pr = response.getWriter();
            pr.print(replay.getShareReplyId());
            return null;
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
            return new ModelAndView((View)new RedirectView("queryByCommentId.htm?shareId=" + replay.getShareId() + "&CSRFToken=" + request.getSession().getAttribute("token")));
        }
    }
}

