/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.report.controller;

import com.qianjiang.report.bean.Report;
import com.qianjiang.report.service.ReportService;
import com.qianjiang.report.util.DateUtil;
import com.qianjiang.thirdaudit.service.AuditService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AjaxReportController {
    @Resource(name="ReportService")
    private ReportService reportService;
    @Resource(name="auditService")
    private AuditService auditService;

    @RequestMapping(value={"settleReport"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String settleReport(Long reportId) {
        Report report = new Report();
        report.setReportId(reportId);
        report.setSettleStatus("1");
        this.reportService.update(report);
        return "1";
    }

    @RequestMapping(value={"catereportDetail"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Report catereportDetail(Long reportId) {
        Report report = null;
        if (null != reportId) {
            report = this.reportService.select(reportId);
        }
        return report;
    }

    @RequestMapping(value={"exportSumReport"})
    public void exportSumReport(Report report) {
        if (report.getStartDate() == null || "".equals(report.getStartDate())) {
            report.setStartDate(DateUtil.getDateOfLastMonth((String)DateUtil.dateToString((Date)new Date())));
        }
        if (report.getEndDate() == null || "".equals(report.getEndDate())) {
            report.setEndDate(DateUtil.dateToString((Date)new Date()));
        }
        report.setTimeType("1");
        this.reportService.exportSumReport(report);
    }

    @RequestMapping(value={"exportCateReport"})
    public void exportCateReport(Report report) {
        if (report.getStartDate() == null || "".equals(report.getStartDate())) {
            report.setStartDate(DateUtil.getDateOfLastMonth((String)DateUtil.dateToString((Date)new Date())));
        }
        if (report.getEndDate() == null || "".equals(report.getEndDate())) {
            report.setEndDate(DateUtil.dateToString((Date)new Date()));
        }
        report.setTimeType("1");
        this.reportService.exportCateReport(report);
    }

    @RequestMapping(value={"settleReportByStoreId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int settleReportByStoreId(Long storeId, String startTime, String endTime) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date starttime = sdf.parse(startTime);
        Date endtime = sdf.parse(endTime);
        this.reportService.settleReport(storeId, starttime, endtime);
        return 1;
    }

    @RequestMapping(value={"settleReportById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int settleReportById(Long reportId) {
        this.reportService.settleReportById(reportId);
        return 1;
    }
}

